*****************************************************************
* The Cx0000005 Finder
*
* Version: 0.0.0
* Date   : ??.??.????
* Author : Milan Kosina
*
* Version: 0.0.1
* Date   : 24.06.2007
* Author : Martina Jindr
*
* Version: 0.0.2
* Date   : 25.06.2007
* Author : Martina Jindr
*
*****************************************************************

LPARAMETERS lcPath,lcTypes,lcOutFile,llAppend
LOCAL lcPath
IF PCOUNT()<4
   llAppend=.T.
ENDIF
IF PCOUNT()<3
   lcPath=SYS(16,0)
   lcPath=IIF(RAT("\",lcPath)>0,LEFT(lcPath,RAT("\",lcPath)),lcPath)
   lcOutFile=lcPath+"FixC5.LOG"
ENDIF

SET TALK OFF
CLEAR
CLOSE TABLES ALL

ProcessPath(lcPath,lcTypes,lcOutFile,llAppend)
RETURN

*****************************************************************
PROCEDURE processpath(lcPath,lcTypes, lcOutFile,llAppend)
LOCAL i,lcOutText,lcHeader
lcOutText=""
lcHeader="* File Name"+CHR(9)+"{Row with WITH, Row with ENDWITH"+CHR(59)+" Rows list with RETURN}"+CHR(13)+CHR(10)
?lcHeader

IF EMPTY(lcTypes) OR ATC("P",lcTypes)>0
   FOR i = 1 TO ADIR(arrSCX, lcPath+"*.prg")
       DO TextForC5PRG WITH lcPath+arrSCX(i,1),lcOutText
   ENDFOR
ENDIF

IF EMPTY(lcTypes) OR ATC("S",lcTypes)>0
   FOR i = 1 TO ADIR(arrSCX, lcPath+"*.scx")
       DO TextForC5  WITH lcPath+arrSCX(i,1), "S",lcOutText
   ENDFOR
ENDIF

IF EMPTY(lcTypes) OR ATC("V",lcTypes)>0
   FOR i = 1 TO ADIR(arrSCX, lcPath+"*.Vcx")
       DO TextForC5  WITH lcPath+arrSCX(i,1), "V",lcOutText
   ENDFOR
ENDIF

IF LEN(lcOutText)>0
   =STRTOFILE(lcHeader+lcOutText, lcOutFile,llAppend)
ENDIF   
RETURN
ENDPROC

***************************************************
PROCEDURE TextForC5 (lcFilename, lcFileType,lcOutText)
LOCAL lcMethods, lnOff1, lnOff2, lcS, lcName, lnComa, i, lcMethodName,lcObjname,lcLines
TRY 
  USE (lcFilename)
CATCH
  lcName = "??? Not able to open ??? USE  "+lcFilename
  ? lcFilename
  lcOutText = lcOutText + lcName + CHR(13)+CHR(10)

FINALLY
  SCAN FOR ATC("WITH",methods)>0 AND ATC("RETURN",methods)>0 AND !DELETED()
       lcMethods = NormalizeTXT (methods)
       FOR i = 1 TO OCCURS(CHR(13)+CHR(10)+"PROCEDURE ", lcMethods)
           lnOff1 = AT(CHR(13)+CHR(10)+"PROCEDURE ", lcMethods, i)
           lnOff2 = AT(CHR(13)+CHR(10)+"ENDPROC",    lcMethods, i)
           lcS = SUBSTR(lcMethods, lnOff1+2, lnOff2-lnOff1-2)
           lcMethodName = LEFT(lcS, AT(CHR(13), lcS)-1)
           lcMethodName = SUBSTR(lcMethodName, AT(" ", lcMethodName)+1) && odstra procedure

           lcS = SUBSTR(lcS, AT(CHR(13)+CHR(10),lcS)+2 ) && odstra 1. dek

           DO CASE
              CASE lcFileType="S"
                   lcObjname=IIF(EMPTY(PARENT),"",PARENT+".")+objname
        
                   IF "."$lcObjname
                      lnComa = AT(".", lcobjname)
                      lcName = "MODIFY FORM  "+lcFilename+" METHOD "+SUBSTR(lcobjname,lnComa+1)+"."+lcMethodName
                   ELSE
                      lcName = "MODIFY FORM  "+lcFilename+" METHOD "+lcMethodName
                   ENDIF

              CASE lcFileType="V"
                   lcObjname=IIF(EMPTY(PARENT),"",PARENT+".")+objname
                   IF "."$lcObjname
                      lnComa = AT(".", lcobjname)
                      lcName = "MODIFY CLASS "+LEFT(lcobjname,lnComa-1)+" OF "+lcFilename+" METHOD "+SUBSTR(lcobjname,lnComa+1)+"."+lcMethodName
                   ELSE
                      lcName = "MODIFY CLASS "+OBJNAME+" OF "+lcFilename+" METHOD "+lcMethodName
                   ENDIF

              OTHERWISE
                   SET STEP ON
           ENDCASE
           IF TextForC5Methods (lcS,@lcLines,0)
              ? lcName+" "+CHR(38)+CHR(38)+" Rows: "+lcLines
              lcOutText = lcOutText+lcName+" "+CHR(38)+CHR(38)+" Rows: "+lcLines + CHR(13)+CHR(10)
           ENDIF
       ENDFOR
  ENDSCAN
  USE
ENDTRY 
ENDPROC

************************************************************************************
PROCEDURE TextForC5PRG (lcFilename,lcOutText)
LOCAL lcName,lcLines,lcSRC,lnOff1, lnOff2, lcS, lnComa, i, lcMethodName,liRows,liCnt
lcLines=""
TRY 
  lcSRC=NormalizeTXT(FILETOSTR(lcFilename))
CATCH
  lcName = "??? Not able to open ??? MODI COMM  "+lcFilename
  ? lcFilename
  lcOutText = lcOutText + lcName + CHR(13)+CHR(10)

FINALLY
  * Nyn to rozdl dle procedur a nezapome na hlavn st
  lcS=LEFT(lcSRC,AT(CHR(13)+CHR(10)+"PROCEDURE ", lcSRC, 1)-1)
  IF TextForC5Methods (lcS,@lcLines,-1)
     lcName = "MODIFY COMM  "+lcFilename+" "+CHR(38)+CHR(38)+" Rows: "+lcLines+" (Main program)"
     ? lcName
     lcOutText = lcOutText +lcName + CHR(13)+CHR(10)
  ENDIF
    
  liCnt=OCCURS(CHR(13)+CHR(10)+"PROCEDURE ", lcSRC)
  FOR i = 1 TO liCnt
      lnOff1 = AT(CHR(13)+CHR(10)+"PROCEDURE ", lcSRC, i)
      *lnOff2 = AT(CHR(13)+CHR(10)+"ENDPROC",    lcSRC, i)
      
      IF i<liCnt
         lnOff2 = AT(CHR(13)+CHR(10)+"PROCEDURE ",    lcSRC, i+1)
      ELSE         
         lnOff2 = LEN(lcSRC)
      ENDIF

      liRows=OCCURS(CHR(13)+CHR(10),LEFT(lcSRC,lnOff1+1))

      lcS = SUBSTR(lcSRC, lnOff1+2, lnOff2-lnOff1-2)
      lcMethodName = LEFT(lcS, AT(CHR(13), lcS)-1)
      lcMethodName = SUBSTR(lcMethodName, AT(" ", lcMethodName)+1) && odstra procedure

      lcS = SUBSTR(lcS, AT(CHR(13)+CHR(10),lcS)+2 ) && odstra 1. dek

      IF TextForC5Methods (lcS,@lcLines,liRows)
         lcName = "MODIFY COMM  "+lcFilename+" "+CHR(38)+CHR(38)+" Rows: "+lcLines+" ("+lcMethodName+")"
         ? lcName
         lcOutText = lcOutText +lcName + CHR(13)+CHR(10)
      ENDIF
  NEXT
ENDTRY 
ENDPROC

************************************************************************************
PROCEDURE TextForC5Methods (lcCode,lcLines,liBaseRow)
LOCAL lnCnt, llInsideWith, j,llRet,lcRowB,lcRowsR,liLevel
DIMENSION laLevels(100,3)
lnCnt = ALINES(arr, lcCode)
llInsideWith = .F.
lcLines=""
liLevel=0
FOR j = 1 TO lnCnt
    DO CASE
       CASE arr(j)="WITH "
            liLevel=liLevel+1
            IF liLevel>100
               DIMENSION laLevels(liLevel,3)
            ENDIF
            llInsideWith = .T.
            IF liLevel=1
               STORE "" TO laLevels
            ENDIF
            laLevels(liLevel,1)=LTRIM(STR(liBaseRow+j,11))
            laLevels(liLevel,2)=.F.
            laLevels(liLevel,3)=""

       CASE arr(j)="ENDW"
            IF llInsideWith AND laLevels(liLevel,2)
               lcLines="{"+laLevels(liLevel,1)+","+LTRIM(STR(liBaseRow+j,11))+";"+LEFT(laLevels(liLevel,3),LEN(laLevels(liLevel,3))-1)+"} | "+lcLines
            ENDIF
            liLevel=liLevel-1
            IF liLevel=0
               llInsideWith = .F.
            ENDIF

       CASE arr(j)="RETURN" AND llInsideWith
            STORE .T. TO llRet,laLevels(liLevel,2)
            laLevels(liLevel,3)=LTRIM(STR(liBaseRow+j,11))+","+laLevels(liLevel,3)
      
    ENDCASE
ENDFOR
lcLines=LEFT(lcLines,LEN(lcLines)-3)
RETURN llRet
ENDPROC

************************************************************************************
PROCEDURE  NormalizeTXT (methods)
LOCAL lcMethods,liCR,liLF
* nkdy se uklda jen CR (dle nastaven IDE)
liCR=AT(CHR(13),methods,1)
liLF=AT(CHR(10),methods,1)
       
* Pokud tam nen pln CRLF, ale CR nebo LF
IF m.liCR=0 OR m.liLF=0
   * Pak to nahra CRLF
   methods=STRTRAN(methods,IIF(m.liCR=0,CHR(10),CHR(13)),CHR(13)+CHR(10))
ENDIF
  
lcMethods = CHR(13)+CHR(10)+UPPER(methods)
lcMethods = CHRTRAN(lcMethods, CHR(9),    " ")
lcMethods = STRTRAN(lcMethods, SPACE(16), " ")
lcMethods = STRTRAN(lcMethods, SPACE( 8), " ")
lcMethods = STRTRAN(lcMethods, SPACE( 4), " ")
lcMethods = STRTRAN(lcMethods, SPACE( 3), " ")
lcMethods = STRTRAN(lcMethods, SPACE( 2), " ")
lcMethods = STRTRAN(lcMethods, CHR(13)+CHR(10)+" ", CHR(13)+CHR(10))

lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROT ",CHR(13)+CHR(10))
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROTE ",CHR(13)+CHR(10))
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROTEC ",CHR(13)+CHR(10))
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROTECT ",CHR(13)+CHR(10))
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROTECTE ",CHR(13)+CHR(10))
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROTECTED ",CHR(13)+CHR(10))
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"HIDD ",CHR(13)+CHR(10))
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"HIDDE ",CHR(13)+CHR(10))
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"HIDDEN ",CHR(13)+CHR(10))

lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROC ",CHR(13)+CHR(10)+"PROCEDURE ")
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROCE ",CHR(13)+CHR(10)+"PROCEDURE ")
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROCED ",CHR(13)+CHR(10)+"PROCEDURE ")
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROCEDU ",CHR(13)+CHR(10)+"PROCEDURE ")
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROCEDUR ",CHR(13)+CHR(10)+"PROCEDURE ")
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"FUNC ",CHR(13)+CHR(10)+"PROCEDURE ")
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"FUNCT ",CHR(13)+CHR(10)+"PROCEDURE ")
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"FUNCTI ",CHR(13)+CHR(10)+"PROCEDURE ")
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"FUNCTIO ",CHR(13)+CHR(10)+"PROCEDURE ")
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"FUNCTION ",CHR(13)+CHR(10)+"PROCEDURE ")

RETURN lcMethods
ENDPROC