*****************************************************************
* The missing (not missile)  dot finder
*
* Version: 0.0.2
* Date   : 2007-08-27
* Author : Martina Jindr
*
* *******  S o u r c e s  *******  B a s e  O n  ************
* Source : fixc5.prg
* Author : Milan Kosina, Martina Jindr
*
* Source : prgan.prg from PDM
* Author : Mike Helland, Martina Jindr
*
*****************************************************************

LPARAMETERS lcPath,lcTypes,lcOutFile,llAppend
PUBLIC ARRAY paComments(4),paCommentsS(1)
LOCAL lcPath
IF PCOUNT()<4
   llAppend=.T.
ENDIF
IF PCOUNT()<3
   lcPath=SYS(16,0)
   lcPath=IIF(RAT("\",lcPath)>0,LEFT(lcPath,RAT("\",lcPath)),lcPath)
   lcOutFile=lcPath+"mdot.LOG"
ENDIF

SET TALK OFF
CLEAR
CLOSE TABLES ALL

paComments(1)="NOTE"
paComments(2)="*!*"
paComments(3)="&"+"&"
paComments(4)="*"

paCommentsS(1)="&"+"&"

ProcessPath(lcPath,lcTypes,lcOutFile,llAppend)
RETURN

*****************************************************************
PROCEDURE processpath(lcPath,lcTypes, lcOutFile,llAppend)
LOCAL i,lcOutText,lcHeader
lcOutText=""
lcHeader="* File Name"+CHR(9)+"{Row"+CHR(59)+" Cols with .}"+CHR(13)+CHR(10)
?lcHeader

PUBLIC llSusp


IF EMPTY(lcTypes) OR ATC("P",lcTypes)>0
   FOR i = 1 TO ADIR(arrSCX, lcPath+"*.prg")
       DO TextForC5PRG WITH lcPath+arrSCX(i,1),lcOutText
   ENDFOR
ENDIF

IF EMPTY(lcTypes) OR ATC("S",lcTypes)>0
   FOR i = 1 TO ADIR(arrSCX, lcPath+"*.scx")
       DO TextForC5  WITH lcPath+arrSCX(i,1), "S",lcOutText
   ENDFOR
ENDIF

IF EMPTY(lcTypes) OR ATC("V",lcTypes)>0
   FOR i = 1 TO ADIR(arrSCX, lcPath+"*.Vcx")
       DO TextForC5  WITH lcPath+arrSCX(i,1), "V",lcOutText
   ENDFOR
ENDIF

IF LEN(lcOutText)>0
   =STRTOFILE(lcHeader+lcOutText, lcOutFile,llAppend)
ENDIF   
RETURN
ENDPROC

***************************************************
PROCEDURE TextForC5 (lcFilename, lcFileType,lcOutText)
LOCAL lcMethods, lnOff1, lnOff2, lcS, lcName, lnComa, i, lcMethodName,lcObjname,lcLines
TRY 
  USE (lcFilename)
CATCH
  lcName = "??? Not able to open ??? USE  "+lcFilename
  ? lcFilename
  lcOutText = lcOutText + lcName + CHR(13)+CHR(10)

FINALLY


  SCAN FOR ATC("WITH",methods)>0 AND ATC("RETURN",methods)>0 AND !DELETED()
       lcMethods = NormalizeTXT (methods)
       FOR i = 1 TO OCCURS(CHR(13)+CHR(10)+"PROCEDURE ", lcMethods)
           lnOff1 = AT(CHR(13)+CHR(10)+"PROCEDURE ", lcMethods, i)
           lnOff2 = AT(CHR(13)+CHR(10)+"ENDPROC",    lcMethods, i)
           lcS = SUBSTR(lcMethods, lnOff1+2, lnOff2-lnOff1-2)
           lcMethodName = LEFT(lcS, AT(CHR(13), lcS)-1)
           lcMethodName = SUBSTR(lcMethodName, AT(" ", lcMethodName)+1) && odstra procedure

*!*    IF ATC("KCF112P",lcfileName)>0 AND lcMethodName="VALID"
*!*    SUSPEND
*!*    endif

           lcS = SUBSTR(lcS, AT(CHR(13)+CHR(10),lcS)+2 ) && odstra 1. dek

           DO CASE
              CASE lcFileType="S"
                   lcObjname=IIF(EMPTY(PARENT),"",PARENT+".")+objname
        
                   IF "."$lcObjname
                      lnComa = AT(".", lcobjname)
                      lcName = "MODIFY FORM  "+lcFilename+" METHOD "+SUBSTR(lcobjname,lnComa+1)+"."+lcMethodName
                   ELSE
                      lcName = "MODIFY FORM  "+lcFilename+" METHOD "+lcMethodName
                   ENDIF

              CASE lcFileType="V"
                   lcObjname=IIF(EMPTY(PARENT),"",PARENT+".")+objname
                   IF "."$lcObjname
                      lnComa = AT(".", lcobjname)
                      lcName = "MODIFY CLASS "+LEFT(lcobjname,lnComa-1)+" OF "+lcFilename+" METHOD "+SUBSTR(lcobjname,lnComa+1)+"."+lcMethodName
                   ELSE
                      lcName = "MODIFY CLASS "+OBJNAME+" OF "+lcFilename+" METHOD "+lcMethodName
                   ENDIF

              OTHERWISE
                   SET STEP ON
           ENDCASE
           IF TextForC5Methods (lcS,@lcLines,0)
              ? lcName+" "+CHR(38)+CHR(38)+" Row-Cols: "+lcLines
              lcOutText = lcOutText+lcName+" "+CHR(38)+CHR(38)+" Row-Cols: "+lcLines + CHR(13)+CHR(10)
           ENDIF
       ENDFOR
  ENDSCAN
  USE
ENDTRY 
ENDPROC

************************************************************************************
PROCEDURE TextForC5PRG (lcFilename,lcOutText)
LOCAL lcName,lcLines,lcSRC,lnOff1, lnOff2, lcS, lnComa, i, lcMethodName,liRows,liCnt

lcLines=""
TRY 
  lcSRC=NormalizeTXT(FILETOSTR(lcFilename))
CATCH
  lcName = "??? Not able to open ??? MODI COMM  "+lcFilename
  ? lcFilename
  lcOutText = lcOutText + lcName + CHR(13)+CHR(10)

FINALLY
  * Nyn to rozdl dle procedur a nezapome na hlavn st
  i=AT(CHR(13)+CHR(10)+"PROCEDURE ", lcSRC, 1)
  lcS=IIF(i=0,lcSRC,LEFT(lcSRC,i-1))
  IF TextForC5Methods (lcS,@lcLines,-1)
     lcName = "MODIFY COMM  "+lcFilename+" "+CHR(38)+CHR(38)+" Row-Cols: "+lcLines+" (Main program)"
     ? lcName
     lcOutText = lcOutText +lcName + CHR(13)+CHR(10)
  ENDIF
    
  liCnt=OCCURS(CHR(13)+CHR(10)+"PROCEDURE ", lcSRC)
  FOR i = 1 TO liCnt
      lnOff1 = AT(CHR(13)+CHR(10)+"PROCEDURE ", lcSRC, i)
      *lnOff2 = AT(CHR(13)+CHR(10)+"ENDPROC",    lcSRC, i)
      
      IF i<liCnt
         lnOff2 = AT(CHR(13)+CHR(10)+"PROCEDURE ",    lcSRC, i+1)
      ELSE         
         lnOff2 = LEN(lcSRC)
      ENDIF

      liRows=OCCURS(CHR(13)+CHR(10),LEFT(lcSRC,lnOff1+1))

      lcS = SUBSTR(lcSRC, lnOff1+2, lnOff2-lnOff1-2)
      lcMethodName = LEFT(lcS, AT(CHR(13), lcS)-1)
      lcMethodName = SUBSTR(lcMethodName, AT(" ", lcMethodName)+1) && odstra procedure

      lcS = SUBSTR(lcS, AT(CHR(13)+CHR(10),lcS)+2 ) && odstra 1. dek

      IF TextForC5Methods (lcS,@lcLines,liRows)
         lcName = "MODIFY COMM  "+lcFilename+" "+CHR(38)+CHR(38)+" Row-Cols: "+lcLines+" ("+lcMethodName+")"
         ? lcName
         lcOutText = lcOutText +lcName + CHR(13)+CHR(10)
      ENDIF
  NEXT
ENDTRY 
ENDPROC


************************************************************************************
PROCEDURE  NormalizeTXT (methods)
LOCAL lcMethods,liCR,liLF
* nkdy se uklda jen CR (dle nastaven IDE)
liCR=AT(CHR(13),methods,1)
liLF=AT(CHR(10),methods,1)
       
* Pokud tam nen pln CRLF, ale CR nebo LF
IF m.liCR=0 OR m.liLF=0
   * Pak to nahra CRLF
   methods=STRTRAN(methods,IIF(m.liCR=0,CHR(10),CHR(13)),CHR(13)+CHR(10))
ENDIF
  
lcMethods = CHR(13)+CHR(10)+UPPER(methods)
lcMethods = CHRTRAN(lcMethods, CHR(9),    " ")
lcMethods = STRTRAN(lcMethods, SPACE(16), " ")
lcMethods = STRTRAN(lcMethods, SPACE( 8), " ")
lcMethods = STRTRAN(lcMethods, SPACE( 4), " ")
lcMethods = STRTRAN(lcMethods, SPACE( 3), " ")
lcMethods = STRTRAN(lcMethods, SPACE( 2), " ")
lcMethods = STRTRAN(lcMethods, CHR(13)+CHR(10)+" ", CHR(13)+CHR(10))

lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROT ",CHR(13)+CHR(10))
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROTE ",CHR(13)+CHR(10))
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROTEC ",CHR(13)+CHR(10))
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROTECT ",CHR(13)+CHR(10))
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROTECTE ",CHR(13)+CHR(10))
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROTECTED ",CHR(13)+CHR(10))
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"HIDD ",CHR(13)+CHR(10))
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"HIDDE ",CHR(13)+CHR(10))
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"HIDDEN ",CHR(13)+CHR(10))

lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROC ",CHR(13)+CHR(10)+"PROCEDURE ")
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROCE ",CHR(13)+CHR(10)+"PROCEDURE ")
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROCED ",CHR(13)+CHR(10)+"PROCEDURE ")
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROCEDU ",CHR(13)+CHR(10)+"PROCEDURE ")
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"PROCEDUR ",CHR(13)+CHR(10)+"PROCEDURE ")
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"FUNC ",CHR(13)+CHR(10)+"PROCEDURE ")
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"FUNCT ",CHR(13)+CHR(10)+"PROCEDURE ")
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"FUNCTI ",CHR(13)+CHR(10)+"PROCEDURE ")
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"FUNCTIO ",CHR(13)+CHR(10)+"PROCEDURE ")
lcMethods = STRTRAN(lcMethods,CHR(13)+CHR(10)+"FUNCTION ",CHR(13)+CHR(10)+"PROCEDURE ")
RETURN lcMethods
ENDPROC

************************************************************************************
** Vrt pozici znaku, kter nen mezera i tabeltor, v etzci od urit pozice (vyhledv zleva)
************************************************************************************
PROCEDURE AT_NonSpace(lcSource,liStart,liEnd)
* @lcSource - Zdrojov etzec
* liStart   - Startovac pozice pro hledn
* liEnd     - Konen pozice pro hledn
liEnd=IIF(PCOUNT()=3,m.liEnd,LEN(m.lcSource))
DO WHILE m.liStart<=m.liEnd AND (SUBS(m.lcSource,m.liStart,1)=" " OR  SUBS(m.lcSource,m.liStart,1)=CHR(9))
   liStart=m.liStart+1 && Inkrementuj ta
ENDDO
RETURN IIF(m.liStart>m.liEnd,0,;
       IIF(SUBS(m.lcSource,m.liStart,1)==" " OR SUBS(m.lcSource,m.liStart,1)==CHR(9),0,m.liStart)) && Vra poten pozici 
ENDPROC

************************************************************************************
** Vrt pozici znaku, kter nen mezera i tabeltor, v etzci od urit pozice (vyhledv zprava)
************************************************************************************
PROCEDURE RAT_NonSpace(lcSource,liStart,liEnd)
* @lcSource - Zdrojov etzec
* liStart   - Startovac pozice pro hledn
* liEnd     - Konen pozice pro hledn
LOCAL liLen
liEnd=IIF(PCOUNT()=3,m.liEnd,1)
DO WHILE m.liStart>=m.liEnd AND  (SUBS(m.lcSource,m.liStart,1)=" " OR  SUBS(m.lcSource,m.liStart,1)=CHR(9))
   liStart=m.liStart-1 && Dekrementuj ta
ENDDO
RETURN IIF(m.liStart<m.liEnd,0,;
       IIF(SUBS(m.lcSource,m.liStart,1)==" " OR SUBS(m.lcSource,m.liStart,1)==CHR(9),0,m.liStart)) && Vra poten pozici
ENDPROC


**************************************************************
* Z dku zdrojovho kdu odstran koment a stednk
* a pokud byl stednk ped komentem, pak vrt 1, za komentem 2 a vbec ne 0
****************************************************************
PROCEDURE Trim_SC(lcRow,paComments)
*@lcRow      - dek zdrojovho kdu
*@paComments - Array of comments
LOCAL lii,liComm,liMD,llComm,lcPom,liLen
* Najdi koment

liLen=LEN(m.lcRow)
STORE AT_NonSpace(@lcRow,1,m.liLen) TO liComm

IF !ISNULL(paComments)
   FOR lii=1 TO ALEN(paComments)
       IF IIF(UPPER(paComments(lii))=="NOTE" ,;
             LOWER(SUBS(m.lcRow,m.liComm,LEN(paComments(lii))+1))==paComments(lii)+" ",;
             LOWER(SUBS(m.lcRow,m.liComm,LEN(paComments(lii))))==paComments(lii))
          EXIT
       ENDIF
   NEXT
ELSE
   lii=2
ENDIF

IF m.lii>ALEN(paComments)
   liComm=AT("&"+"&",m.lcRow)
ENDIF


IF m.liComm>0
   liMD=RAT_NonSpace(@lcRow,m.liLen,m.liComm)
   llComm=SUBS(m.lcRow,m.liMD,1)=";"
ENDIF

lii=RAT_NonSpace(@lcRow,IIF(m.liComm>0,m.liComm-1,m.liLen),1)
lii=IIF(SUBS(m.lcRow,m.lii,1)=";",m.lii,0)

lcRow=IIF(m.liComm>0,LEFT(m.lcRow,IIF(m.lii=0,m.liComm,lii)-1),;
          IIF(m.lii=0,m.lcRow,LEFT(m.lcRow,m.lii-1)))

RETURN IIF(m.liComm>0,IIF(m.lii>0,1,IIF(m.llComm,2,0)),;
       IIF(m.lii>0,1,0))


*************************************
* Najde oddlova (zleva)
*************************************
PROCEDURE FindMDSC(lcSource,lcOdd,liStart,liEnd)
* @lcSource - Zdrojov etzec
* lcOdd     - Oddlova co se m hledat
* liStart   - Startovac pozice pro hledn
* liEnd     - Konen pozice pro hledn

LOCAL liFlag,lcChar,liEndFlag

lcChar=SUBS(m.lcSource,m.liStart,1)
liFlag=IIF(m.lcChar="[" AND ATC(RIGHT(CHRTRAN(LEFT(lcSource,liStart-1)," ",""),1),'<>+-$()!=^/%*,?')>0,1,;
       IIF(m.lcChar="'",2,;
       IIF(m.lcChar='"',4,0)))

liEnd=IIF(PCOUNT()=4,m.liEnd,LEN(m.lcSource))

DO WHILE m.liStart<=m.liEnd

   IF m.liFlag=0 AND m.lcChar=m.lcOdd
      RETURN m.liStart
   ENDIF

   liStart=m.liStart+1 && Inkrementuj ta
   lcChar=SUBS(m.lcSource,m.liStart,1) && Nati dal znak

   IF liFlag>0
      liFlag=IIF(m.liFlag=1 AND m.lcChar="]",0,;
             IIF(m.liFlag=2 AND m.lcChar="'",0,;
             IIF(m.liFlag=4 AND m.lcChar='"',0,liFlag)))
   ELSE
      liFlag=IIF(m.lcChar="[" AND ATC(RIGHT(CHRTRAN(LEFT(lcSource,liStart-1)," ",""),1),'<>[+-$(!=^/%*,?')>0,1,;
             IIF(m.lcChar="'",2,;
             IIF(m.lcChar='"',4,m.liFlag)))
   ENDIF
ENDDO

RETURN 0 && Vra, e nic nenael

******************************************************************************
PROCEDURE TextForC5Methods (lcCode,lcLines,liBaseRow)
LOCAL lnCnt, llOutsideWith, j,llRet,liLevel,lii,lcPom,lcRow,liOdd,liOddOld,liy,liz,lcCols,lcPre
lnCnt = ALINES(arr, lcCode)
llOutsideWith = .T. && Mus bt vdy .T.
lcLines=""
liLevel=0
liOddOld=0

FOR j = 1 TO lnCnt
    lcRow=arr(j)

    IF liOddOld=0 THEN
       liOdd=Trim_SC(@lcRow,@paComments)
    ELSE
       IF liOddOld=1 THEN
          liOdd=Trim_SC(@lcRow,@paCommentsS)
       ELSE
          liOdd=IIF(AT(";",lcRow)>0,2,0)
          lcRow=""
       ENDIF
    ENDIF
    IF liOddOld=2 && pedchoz dek ml oddlova za komentem
       liOddOld=liOdd && proto tento dek nezpracovvej
       LOOP
    ENDIF

    IF llOutsideWith AND !EMPTY(lcRow) && zkontroluj kad dek, kter je uvnit ENDWITH..WITH
       * rozparsuj dek na jednotliv tokeny a vyjmi z to vechno co zavn "promnnou"
       * pokud jakkoliv "promnn" zan .
       * pak pidej slo dku do seznamu

       * . nesm bt v etzci
       lcCols=""
       liz=OCCURS('.',lcRow)
       lii=1
       FOR liy=1 TO liz
           lii=FindMDSC(@lcRow,".",lii,LEN(lcRow))
           lcPre=LEFT(lcRow,lii-1)
           IF (lii=1 OR ATC(SUBSTR(lcRow,lii-1,1),'<>[+-$(!=^/%*,? ')>0) AND ;
               SUBSTR(lcRow,lii,3)#".T." AND ;
               SUBSTR(lcRow,lii,3)#".F." AND ;
               SUBSTR(lcRow,lii,5)#".AND." AND ;
               SUBSTR(lcRow,lii,4)#".OR." AND ;
               SUBSTR(lcRow,lii,3)#"..\" AND ;
               SUBSTR(lcRow,lii,5)#".NOT." AND ;
               SUBSTR(lcRow,lii-1,3)#" . " AND ;
               ATC("\",SUBSTR(lcPre,RAT(" ",lcPre)+1))=0 AND ;
               NOT ISDIGIT(SUBSTR(lcRow,lii+1,1)) AND ;
               NOT (SUBSTR(lcRow,lii-1,2)=" ." AND lii=LEN(lcRow)) AND ;
               SUBSTR(lcRow,lii,6)#".NULL."

               lcCols=LTRIM(STR(lii,11))+","+lcCols
               llRet=.T.
           ENDIF
           lii=lii+1
       NEXT
       IF LEN(lcCols)>0
          lcLines="{"+LTRIM(STR(liBaseRow+j,11))+";"+LEFT(lcCols,LEN(lcCols)-1)+"} | "+lcLines
       ENDIF
    ENDIF
    IF lcRow="WITH "
       liLevel=liLevel+1
       llOutsideWith = .F.
    ELSE
       IF lcRow="ENDW"
          liLevel=liLevel-1
          IF liLevel=0
             llOutsideWith = .T.
          ENDIF
       ENDIF
    ENDIF

    liOddOld=liOdd && zapamatuj si kde byl oddlova
ENDFOR
lcLines=LEFT(lcLines,LEN(lcLines)-3)
RETURN llRet
ENDPROC