#INCLUDE "efrx.h"


PROCEDURE EFRX_GetInterface(loHost) && Vrt objekt Interface
* @loHost - (Out) - vrt objekt Interface
LOCAL lcPath,lcProg
loHost=CREATEOBJECT("_EReports")
* Nastav cestu k interface
lcProg=PROGRAM()
lcPath=SYS(16)
lcPath=SUBST(m.lcPath,AT(m.lcProg,m.lcPath)+LEN(m.lcProg)+1)
loHost.Path=IIF(RAT("\",m.lcPath)>0,LEFT(m.lcPath,RAT("\",m.lcPath)),m.lcPath)
RETURN

****************************************************************
* Definice tdy rozhran pro E Reports
****************************************************************
DEFINE CLASS _EReports AS __CFRX
   Name="_EReports"
   
   Engine="EREPORTS" && Kd rozhran
   PreviewAllowed=.F. && Pznak, zda utilita umouje vlastn Preview
   AutoOpenAllowed=.F. && Pznak, zda utilita umouje AutoOpen
   EmailAllowed=.T. && Pznak, zda utilita umouje odeslan E-mailem
   WMAllowed=.T. && Pznak, zda utilita umouje WaterMark

   NativeProgress=.T. && Pznak, zda utilita m vlastn teplomr
   ChangeProgressAllowed=.F. && Pznak, zda se msto vlastnho teplomru D volat vlastn udlost

   Key=""
  
   oReport=.NULL. && Object to report reference
   oProgress=.NULL.


   EMAIL.AuthorizedAllowed=.T. && Pznak, zda utilita umouje odeslan E-mailem - autorizovan pstup
   EMAIL.BodyFromFileAllowed=.T. && Pznak, zda tlo emailu me bt soubor
   EMAIL.CCAllowed=.T. && Carbon copy allowed
   EMAIL.BCCAllowed=.T. && Bicarbon copy allowed
   EMAIL.BodyAllowed=.T. && Body allowed
   EMAIL.TimeOutAllowed=.T. && TimeOut allowed
   
   EMAIL.SMTPAllowed=.T. && SMTP allowed

   WM.HTMLAllowed=.T. && Pznak, zda utilita umouje definovat WM pomoc HTML
   WM.PictureAllowed=.T. && Pznak, zda utilita umouje definovat WM pomoc obrzku

   PROCEDURE Init
      This.Caption="eReports"
   ENDPROC

   PROCEDURE TestHost() &&  Otestuje, zda je mono vytvoit engine
      RETURN LEN(SYS(2000,This.EPath+"eReports.dll"))>0
   ENDPROC

   PROCEDURE CreateHost(lcID,loReport) && Vytvo hostitelsk objekt exportn utility
      * lcID     - Druh vstupu
      *@loReport - Objekt reportu

      LOCAL loHost,llErr
      This.ResetError()
      DO CASE
         CASE m.lcID="PDF"
              loHost = NEWOBJECT("eReportsPDF", This.EPath+"eReports.dll", This.EPath+"eReports.dll")

         CASE m.lcID="HTML"
              loHost = NEWOBJECT("eReportsHTML", This.EPath+"eReports.dll", This.EPath+"eReports.dll")

         CASE m.lcID="EMAIL"
              loHost = NEWOBJECT("eReportsSMTP", This.EPath+"eReports.dll", This.EPath+"eReports.dll")

      ENDCASE
      llErr=This.nError>0
      IF !m.llErr
         liErr=m.loHost.UnLock(This.Key) && Unlock Key
      ENDIF

      IF !m.llErr
         This.oHost=m.loHost
      ENDIF
      This.ResetError()
      RETURN !m.llErr
   ENDPROC


   PROCEDURE SetHost(loHost,loReport,lcID) && Nastav volby hostitele
      * loHost   - Objekt hostitele
      * loReport - Objekt informac o reportu
      * lcID     - Druh vstupu

      LOCAL lii,loEMAIL,lcPom,lcStyle,lcFN
      m.loHost.ShowStatus=IIF(m.loReport.Silent,0,1)

      IF m.lcID=="PDF" OR m.lcID=="HTML"
         loHost.Author=m.loReport.Author

         loHost.ReportExpr=m.loReport.cFor+" "+m.loReport.cWhile+" "+m.loReport.cScope
         loHost.Keywords=m.loReport.Keywords
         loHost.Title=m.loReport.Title
         loHost.Description=m.loReport.Description

         loHost.ReportApp=m.loReport.Producer
         loHost.Author=m.loReport.Creator
         loHost.JPGQuality=m.loReport.PDF.JPEGQuality
         

*!*	      loHost.SetSubject(m.loReport.Subject)

*!*	      loHost.PaperSize=m.loReport.PaperSize
*!*	      loHost.Orientation=m.loReport.Orientation
*!*	      loHost.NewDocFileExpr=m.loReport.NewDocFileExpr
*!*	      loHost.NewDocOnPage=m.loReport.NewDocOnPage

*!*	      loHost.ErrorLog=m.loReport.ErrorLog
*!*	      loHost.ImagePath=m.loReport.ImagePath
*!*	      loHost.UsePrintDriver=m.loReport.UsePrintDriver
*!*	      loHost.WidthObject=m.loReport.WidthObject
      ENDIF

      * PDF only properties
      IF m.lcID=="PDF"
         loHost.EmbedFonts=IIF(m.loReport.PDF.lIncludeFont,1,0)

         IF !EMPTY(m.loReport.UPassword)
            loHost.UserPassword=m.loReport.UPassword
         ENDIF
         IF !EMPTY(m.loReport.OPassword)
            loHost.OwnerPassword=m.loReport.OPassword
         ENDIF

         loHost.CanPrint=IIF(m.loReport.PDF.lAddOrModifyAnnotations,1,0)
         loHost.CanAddNotes=IIF(m.loReport.PDF.lPrintDocument,1,0)
         loHost.CanCopy=IIF(m.loReport.PDF.lCopyTextAndGraphics,1,0)
         loHost.CanChange=IIF(m.loReport.PDF.lModifyDocument,1,0)

         loHost.EncryptStrength=m.loReport.PDF.Encrypt
         loHost.Additive=m.loReport.PDF.Additive

*!*	        loHost.PictureFile=m.loReport.PDF.PictureFile
*!*	        loHost.PictureStretch=m.loReport.PDF.PictureStretch

      ENDIF


      IF m.lcID=="HTML"
*         loHost.NavOptions=6
*         loHost.NavPrompts="snwisw swnsw snwkswn swnkswks"

         loHost.NewDocOnPage=2
*         loHost.NewDocFileExpr=1

         IF !EMPTY(m.loReport.WM.HTML)
            loHost.WaterMarkHTML=m.loReport.WM.HTML
         ELSE
            IF !EMPTY(m.loReport.WM.Text)
               lcPom=""
               IF m.loReport.WM.BackColor#-1
                  lcFN=TRANSFORM(m.loReport.WM.BackColor,'@0')
                  lcPom=m.lcPom+"background-color:#"+RIGHT(m.lcFN,2)+SUBS(m.lcFN,7,2)+SUBS(m.lcFN,5,2)+";"
               ENDIF
               IF m.loReport.WM.ForeColor#-1
                  lcFN=TRANSFORM(m.loReport.WM.ForeColor,'@0')
                  lcPom=m.lcPom+"color:#"+RIGHT(m.lcFN,2)+SUBS(m.lcFN,7,2)+SUBS(m.lcFN,5,2)+";"
               ENDIF
               IF !EMPTY(m.loReport.WM.FontName)
                  lcFN=m.loReport.WM.FontName
                  lcPom=m.lcPom+"font-name:"+IIF(AT(" ",m.lcFN)>0,"'","")+m.loReport.WM.FontName+IIF(AT(" ",m.lcFN)>0,"'","")+";"
               ENDIF
               IF m.loReport.WM.FontSize#-1
                  lcPom=m.lcPom+"font-size:"+LTRIM(STR(m.loReport.WM.FontSize,3))+"pt;"
               ENDIF

               IF !EMPTY(m.loReport.WM.FontStyle)
                  lcStyle=m.loReport.WM.FontStyle
                  lcPom=m.lcPom+IIF(ATC("B",m.lcStyle)>0,' font-weight:bold;','')+;
                              IIF(ATC("I",m.lcStyle)>0,' font-style:italic;','') +;
                              IIF(ATC("U",m.lcStyle)>0 OR AT("S",m.lcStyle)>0, ' text-decoration:'+;
                                IIF(ATC("U",m.lcStyle)>0,' underline','')+;
                                IIF(ATC("S",m.lcStyle)>0,' line-through','')+';','')
               ENDIF
   *            IF !loReport.WM.RotationAngle#-1
   *            ENDIF
               loHost.WaterMarkHTML=[<span style="]+m.lcPom+[">]+m.loReport.WM.Text+[</span>]
            ENDIF
         ENDIF



*!*	   *      loHost.nLeftMargin=loReport.nLeftMargin
*!*	         loHost.ShrinkHeight((loReport.nTopMargin/This.PpIY)*10000)
*!*	      ENDIF

*!*	        loHost.WatermarkHtml=loReport.WatermarkHtml
*!*	        loHost.NavOptions=loReport.NavOptions
*!*	        loHost.NavPrompt=loReport.Prompt

*!*	      * Start Page/End Page or List of Pages
*!*	      IF loReport.SPage>0 AND loReport.EPage>0
*!*	         loHost.SetPageRange(loReport.SPage,loReport.EPage)
*!*	      ENDIF

*!*	      IF !EMPTY(loReport.SEPage) AND loReport.SPage<=0 AND loReport.EPage<=0
*!*	         loHost.SetPageRange(loReport.SEPage)
*!*	      ENDIF

*!*	      IF loReport.Progress
*!*	         This.oReport=loReport
*!*	         This.oProgress=CREATEOBJECT("_XFRX_Progress")
*!*	         loHost.SetProgressObj(This,2)
*!*	      ENDIF
      ENDIF

      IF m.lcID=="EMAIL"
         loEMAIL=m.loReport.EMAIL

         loHost.CharSet=IIF(EMPTY(m.loEMAIL.CharSet),"windows-"+IIF(TYPE("m.loReport.CodePage")="C",ALLT(m.loReport.CodePage),LTRIM(STR(m.loReport.CodePage,7))),m.loEMAIL.CharSet)
         loHost.AutoWrap=m.loEMAIL.AutoWrap
         loHost.FromAddress=m.loEMAIL.FromAddress
         loHost.FromName=m.loEMAIL.FromName

         loHost.ReturnReceiptAddr= m.loEmail.ReturnReceiptAddr
         loHost.ReplyToAddr = m.loEmail.ReplyToAddr

         * loHost.SMTPLogFile=""
         loHost.Priority=m.loEMAIL.Priority
         loHost.Subject=m.loEMAIL.Subject
         loHost.MessageBody=m.loEMAIL.Body

         loHost.ESMTPAuthMode=m.loEMAIL.AuthorizationType
         IF m.loEMAIL.AuthorizationType=_EFRX_ASMTP_No
            loHost.SMTPServer=m.loEMAIL.Host
            loHost.SMTPPort=m.loEMAIL.Port
            loHost.SMTPTimeOut=m.loEMAIL.TimeOut
         ELSE
            loHost.SMTPServer=loEMAIL.EHost
            loHost.SMTPPort=m.loEMAIL.EPort
            loHost.SMTPTimeOut=m.loEMAIL.ETimeOut
            loHost.ESMTPAccount=m.loEMAIL.UserID
            loHost.ESMTPPassword=m.loEMAIL.Password
         ENDIF
         loHost.SMTPDomain=SUBST(m.loHost.SMTPServer,AT(".",m.loHost.SMTPServer)+1)

         FOR lii=1 TO m.loEmail.iRecipient
             =m.loHost.AddRecipient(m.loEmail.aRecipients(m.lii),m.loEmail.aRecipientsE(m.lii),_EFRX_Rcp)
         NEXT

         FOR lii=1 TO m.loEmail.iCC
             =m.loHost.AddRecipient(m.loEmail.aCCs(m.lii),m.loEmail.aCCsE(m.lii),_EFRX_Rcp_cc)
         NEXT

         FOR lii=1 TO m.loEmail.iBCC
             =m.loHost.AddRecipient(m.loEmail.aBCCs(m.lii),m.loEmail.aBCCsE(m.lii),_EFRX_Rcp_bcc)
         NEXT

         FOR lii=1 TO m.loEmail.iFile
             =m.loHost.AddAttachment(m.loEmail.aFiles(m.lii))
         NEXT

         IF This.EMAIL.BodyFromFileAllowed AND !EMPTY(m.loEMAIL.MessageFile)
            loHost.MessageFile=m.loEMAIL.MessageFile
            loHost.MessageFormat=m.loEMAIL.MessageFormat
         ELSE
            loHost.MessageFile=_EFRX_Body_Text
         ENDIF

*!*	              loHost.Subject="Test email ereports - 0"
*!*	              loHost.MessageBody="body mail"
*!*	              loHost.MessageFormat=0
*!*	              loHost.SMTPLogFile="e:\ereports.txt"
*!*	              liErr=loHost.SendMail()

*!*	              loHost.Subject="Test email ereports - 3"
*!*	              loHost.MessageFormat=3
*!*	              loHost.MessageFile="e:\xx2.rtf"
*!*	              loHost.SMTPLogFile="e:\ereports3.txt"
*!*	              liErr=loHost.SendMail()

      ENDIF
   ENDPROC

   PROCEDURE GetOuts(laOuts)
      *@laOuts - Matice definovanch vstup
      DIME laOuts(2,4)
      laOuts(1,1)= m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_HTML)
      laOuts(1,2)=This.Engine
      laOuts(1,3)="HTML"
      laOuts(1,4)="html"

      laOuts(2,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_PDF)
      laOuts(2,2)=This.Engine
      laOuts(2,3)="PDF"
      laOuts(2,4)="pdf"

      RETURN ALEN(laOuts,1)
   ENDPROC

   PROCEDURE Export(lcID,loReport) && Provede tisk/export reportu
      * lcID     - ID vstupu rozhran
      * loReport - Objekt reportu

      LOCAL loHost,llErr,liErr,lcFile,lcScope,lcPath
      IF ISNULL(This.oHost)
         llErr=!This.CreateHost(m.lcID,@m.loReport)
      ENDIF
      loHost=This.oHost
      lcFile=m.loReport.OFile

      lcPath=SET("PATH")
      SET PATH TO (This.EPath)

      DO CASE
         CASE m.llErr && Dolo k chyb
              liErr=_EFRX_PrintFailed
             
         OTHERWISE
              loHost.ReportFile = m.loReport.RFile && change to an existing report
              loHost.OutPutFile = m.lcFile

              This.SetHost(@m.loHost,@m.loReport,m.lcID) && Nastav volby hostitele

              =IIF(PEMSTATUS(m.loReport.oCallBack,"EFRX_BeforeExport",5),m.loReport.oCallBack.EFRX_BeforeExport(@m.loHost),.T.)

              liErr=m.loHost.ReportConvert()
              llErr=m.liErr<0
              IF !m.llErr
                 =IIF(PEMSTATUS(m.loReport.oCallBack,"EFRX_NextReport",5),m.loReport.oCallBack.EFRX_NextReport(@m.loHost),.T.)
              ENDIF
              WAIT CLEAR

              IF m.loReport.ToEmail
                 llErr=!This.CreateHost("EMAIL",@m.loReport)
                 IF !m.llErr
                    loHost=This.oHost

                    This.SetHost(@m.loHost,@m.loReport,"EMAIL") && Nastav volby hostitele

                    m.loHost.AddAttachment(m.lcFile) && Pidej vygenerovan soubor
                    =IIF(PEMSTATUS(m.loReport.oCallBack,"EFRX_BeforeEmail",5),m.loReport.oCallBack.EFRX_BeforeEmail(@m.loHost),.T.)
                    liErr=m.loHost.SendMail()

*!*	              loHost.Subject="Test email ereports - 1"
*!*	              =loHost.AddRecipient("jindra","jindra@egservis.cz",_EFRX_Rcp)
*!*	              loHost.AddAttachment(lcFile) && Pidej vygenerovan soubor
*!*	              loHost.MessageFormat=1
*!*	              loHost.MessageFile="e:\xx.html"
*!*	              loHost.SMTPLogFile="e:\ereports1.txt"
*!*	              liErr=loHost.SendMail()

*!*	              =loHost.AddRecipient("jindra","jindra@egservis.cz",_EFRX_Rcp)
*!*	              loHost.AddAttachment(lcFile) && Pidej vygenerovan soubor
*!*	              loHost.Subject="Test email ereports - 2"
*!*	              loHost.MessageFormat=2
*!*	              loHost.MessageFile="e:\xx.html"
*!*	              loHost.SMTPLogFile="e:\ereports2.txt"
*!*	              liErr=loHost.SendMail()

*!*	              loHost.Subject="Test email ereports - 3"
*!*	              loHost.MessageFormat=3
*!*	              loHost.MessageFile="e:\aa.rtf"
*!*	              loHost.SMTPLogFile="e:\ereports3.txt"
*!*	              liErr=loHost.SendMail()

*!*	              debugout lierr
*!*	              debugout lohost.smtperror
*!*	              debugout lohost.errorlog



                 ENDIF
              ENDIF
      ENDCASE
      STORE .NULL. TO This.oReport,This.oProgress,This.oHost

      SET PATH TO (m.lcPath)

      loReport.ErrNo=m.liErr
      IF m.liErr=_EFRX_OK
         loReport.Exported=.T.
      ENDIF
      RETURN IIF(m.liErr=0,_EFRX_OK,_EFRX_PrintFailed)
   ENDPROC


   PROCEDURE GetVersion() && Vrt verzi report enginu
      LOCAL llErr
      LOCAL ARRAY laFile(1)
      IF ISNULL(This.oHost)
         llErr=!This.CreateHost("PDF",.NULL.)
      ENDIF
      =AGETFILEVERSION(laFile,This.EPath+"eReports.dll")
      This.oHost=.NULL.
      RETURN IIF(m.llErr,"",laFile(4))
   ENDPROC

* eReports properties
*!*	CharSet             "US-ASCII"
*!*	AutoWrap            76
*!*	FromAddress         "jdoe@mydomain.com"
*!*	FromName            "John Doe"
*!*	MessageBody         "The text of this email is a really long string variable which can include multiple lines"
*!*	MessageFile         "C:\AppDir\OutPutPath\message.txt"
*!*	MessageFormat       1 (PLAINT/HTML/RTF)
*!*	Priority            "2"
*!*	eplyToAddr         "jdoe@mydomain.com"
*!*	ReturnReceiptAddr   "jdoe@mydomain.com"
*!*	SMTPDomain          "mydomain.com"
*!*	SMTPLogFile         "C:\SMTPLog.txt"
*!*	SMTPPort            25
*!*	SMTPServer          "mail.mydomain.com"
*!*	Subject             "January's Billing Statement"
*!*	TimeOut             30
*!*	ESMTPAccount		"jdoe@mydomain.com"
*!*	ESMTPPassword		"password"
*!*	ESMTPAuthMode		0


* EFRX properties
*!*    CharSet "US-ASCII"  && possibly- if empty convert CodePage from EFRX
*!*	   AttachmentFileName="" && Specifies the file name to be used as the attachment that the report will be emailed as.
*!*	   BCC="" &&  Specifies a comma separated list of formatted Blind Carbon Copy addresses to email to
*!*	   BodyText="" && Specifies the Body Text of the email.
*!*	   CC="" && Specifies a comma separated list of formatted Carbon Copy addresses to email to.
*!*	   FromAddress="" && Specifies the From Address for the email and is required.
*!*	   MessagingType=0 && Specifies the Email Messaging Type: 0 = SMTP 1 = MAPI
*!*	   Recipients="" && Specifies a comma separated list of formatted Recipient addresses to email to.
*!*	   ReturnReceipt=.F. && Specifies that a Return Receipt will be requested.
*!*	   SMTPAuthorizationType=0 && Specifies the SMTP Authorization Type. 0 = none, 1 = Login Required
*!*	   SMTPHost="" && Specifies the name of the SMTP Host and must be specified in order to send an email.
*!*	   SMTPPassword="" && Specifies the Password for logging into an SMTP Server when using Authentication Type =1.
*!*	   SMTPPort=0 && Specifies the Port for the SMTP Server if required. Default is 0 and not used.
*!*	   SMPTUserID="" && Specifies the UserID for logging into an SMTP Server when using Authentication Type = 1.
*!*	   Subject=""




ENDDEFINE

