#INCLUDE "Files.h"

DEFINE CLASS _lstFiles AS DataEnvironment
   Name= "_lstFiles"
 
   lError=.F. && Pznak chyby
   List="" && Umstn a nzev list souboru

   * provede registraci souboru
   PROCEDURE Register(lcFile)
      * lcFile - Umstn a nzev souboru
      LOCAL lii,lcList,liErr
      IF EMPTY(This.List) && Pokud seznam nen definovn
         RETURN _lstFiles_ListNotDefine && Pak se vra
      ENDIF
      lcFile=UPPER(ALLT(m.lcFile)) && Uprav nzev souboru
      IF FILE(This.List) && Pokud seznam existuje
         lcList="" && Nastav poten stav
         liErr=This.Read(This.List,@m.lcList) && Nati seznam
         IF m.liErr#_lstFiles_OK
            RETURN m.liErr
         ENDIF
      ELSE
         lcList=""
      ENDIF
      lii=AT(m.lcFile,m.lcList)
      IF m.lii=0 && Pokud souboru nen v seznamu
         * Pak ho tam pidej
         lcList=m.lcList+IIF(LEN(m.lcList)=0,"",_lstFiles_CRLF)+m.lcFile
         liErr=This.Save(This.List,@m.lcList,@m.lcFile)
         IF m.liErr#_lstFiles_OK
            RETURN m.liErr
         ENDIF
      ENDIF
      RETURN _lstFiles_OK
   ENDPROC

   * Provede odregistraci souboru
   PROCEDURE UnRegister(lcFile)
      * lcFile - Umstn a nzev souboru
      LOCAL lii,lcList,liErr
      IF EMPTY(This.List) && Pokud seznam nen definovn
         RETURN _lstFiles_ListNotDefine && pak se vra
      ENDIF
      lcFile=UPPER(ALLT(m.lcFile)) && Uprav nzev souboru
      IF !FILE(This.List) && Pokud seznam neexistuje
         RETURN _lstFiles_ListNotExist
      ENDIF
      lcList="" && Nastav poten stav
      liErr=This.Read(This.List,@m.lcList) && Nati seznam
      IF m.liErr#_lstFiles_OK
         RETURN m.liErr
      ENDIF

      lii=AT(m.lcFile,m.lcList)
      IF m.lii>0 && Pokud souboru je v seznamu
         lcList=STUFF(m.lcList,m.lii+IIF(m.lii=1,0,-2),LEN(m.lcFile)+IIF(m.lii=1,0,2),"") && Sma soubor ze seznamu
         liErr=This.Save(This.List,@m.lcList)
         IF m.liErr#_lstFiles_OK
            RETURN m.liErr
         ENDIF
      ENDIF
      RETURN _lstFiles_OK
   ENDPROC

   * Smae vechny soubory dle listu
   PROCEDURE DeleteFiles
      LOCAL lii,llDele,lcList,liy,liLast,lcFile
      IF EMPTY(This.List) && Pokud seznam nen definovn
         RETURN _lstFiles_ListNotDefine && pak se vra
      ENDIF

      IF !FILE(This.List) && Pokud seznam neexistuje
         RETURN _lstFiles_ListNotExist
      ENDIF

      lcList="" && Nastav poten stav
      liErr=This.Read(This.List,@m.lcList) && Nati seznam
      IF m.liErr#_lstFiles_OK
         RETURN m.liErr
      ENDIF

      liy=OCCURS(_lstFiles_CRLF,m.lcList)
      lii=AT(_lstFiles_CRLF,m.lcList,m.liy)
      liLast=LEN(m.lcList)

      DO WHILE m.lii#0
         lii=AT(_lstFiles_CRLF,m.lcList,IIF(m.liy>0,m.liy,1))
         lcFile=IIF(m.lii>0,SUBST(m.lcList,m.lii+2,m.liLast-m.lii+1),m.lcList)

         liLast=m.lii-1 && Tak abych byl na konci etzce
         liy=m.liy-1 && Dekrementuj ta
         IF EMPTY(m.lcFile) && Pokud je przdn etzec
            lcList=STUFF(m.lcList,m.lii,2,"") && Sma przdn ENTER ze seznamu
         ELSE
            This.lError=.F. && Pastav pznak, e nen chyba
            DELE FILE (m.lcFile)
            IF !This.lError && Pokud nedolo k chyb
               * Pak vyma soubor ze seznamu
               lcList=STUFF(m.lcList,IIF(m.lii=0,1,m.lii),LEN(m.lcFile)+2,"") && Sma soubor ze seznamu
            ENDIF
         ENDIF
      ENDDO

      * a Nyn opt seznam ulo
      liErr=This.Save(This.List,@m.lcList)
      IF m.liErr#_lstFiles_OK
         RETURN m.liErr
      ENDIF
   ENDPROC
 
 
   PROCEDURE Error(nError, cMethod, nLine)
      * nError  - slo chyby
      * cMethod - Nzev metody
      * nLine   - slo dku
      
      IF UPPER(m.cMethod)="READ"
         This.lError=.T. && Nastav pznak chyby
      ELSE
         IF UPPER(m.cMethod)="SAVE"
            This.lError=.T. && Nastav pznak chyby
         ELSE
            IF UPPER(m.cMethod)="DELETEFILES"
               This.lError=.T. && Nastav pznak chyby
            ELSE
               DODEFAULT(m.nError, m.cMethod, m.nLine)
            ENDIF
         ENDIF
      ENDIF
   ENDPROC



   * Provede uloen seznamu
   PROCEDURE Save(lcList,lcData,lcFile)
      * lcList - Umstn a nzev seznamu
      *@lcData - Data seznamu
      *@lcFile - Nzev souboru je se m uloit 

      LOCAL ARRAY laFile(1,2)
      IF ADIR(m.laFile,m.lcList,"ARHS")=0 && Pokud jet nen
         laFile(1,2)=0 && Pak nastav 0 velikost
      ENDIF
      This.lError=.F.
      =IIF(PCOUNT()=3,STRTOFILE(IIF(m.laFile(1,2)>0,_lstFiles_CRLF,"")+m.lcFile,m.lcList,.T.),;
                      STRTOFILE(m.lcData,m.lcList,.F.))
      RETURN IIF(This.lError,_lstFiles_NotSaveList,_lstFiles_OK)
   ENDPROC

   * Provede naten seznamu
   PROCEDURE Read(lcList,lcData)
      * lcList - Umstn a nzev seznamu
      *@lcData - Data seznamu
      This.lError=.F.
      lcData=FILETOSTR(This.List)
      RETURN IIF(This.lError,_lstFiles_NotReadList,_lstFiles_OK)
   ENDPROC
ENDDEFINE


