#INCLUDE "krc001.h"
#INCLUDE "winbase.h"

EXTERNAL ARRAY laFunc
EXTERNAL ARRAY laFile


*********************************************************************
* procedura na deklaraci API funkc
*********************************************************************

*****************************************************************************
* procedury pro zaveden komponent (DLL,FLL)
*****************************************************************************
*
*
*
*

*****************************************************************************
* zaveden DLL funkce
*****************************************************************************
PROCEDURE LoadDllFunc(lcFunc)
LOCAL llErr
TRY
 &lcFunc.
CATCH
 m.llErr=.T.
ENDTRY 
RETURN !m.llErr && vra pznak


*****************************************************************************
* zaveden DLL funkce - seznam funkc
*****************************************************************************
PROCEDURE LoadDllFuncEx(laFunc)
LOCAL lii,llErr
FOR lii=1 TO ALEN(m.laFunc)
    TRY
     &laFunc(m.lii). && zave dll funkci
    CATCH 
      m.llErr=.T.
    ENDTRY
    IF m.llErr && pokud to selhalo
       EXIT && pak vypadni
    ENDIF
NEXT

RETURN !m.llErr


*****************************************************************************
* zaveden FLL knihovny
*****************************************************************************
PROCEDURE LoadLibrary(lcFile)
IF FindFile(@lcFile)
   LOCAL llErr
   TRY
    SET LIBRARY TO (m.lcFile) ADDITIVE && pipoj knihovnu
   CATCH 
     m.llErr=.T.
   ENDTRY
   RETURN !m.llErr && vra pznak
ELSE
   RETURN .F.
ENDIF
RETURN .T.


*****************************************************************************
* uvolnn FLL knihovny
*****************************************************************************
PROCEDURE UnLoadLibrary(lcFile)
IF FindFile(@lcFile)
   TRY
   RELEASE LIBRARY (m.lcFile) && uvolni knihovnu
   ENDTRY
ENDIF
RETURN .T.


*****************************************************************************
PROCEDURE FindFile(lcFile)
* @lcFile - nzev souboru, kter se m najt, sem se vrt taky pln cesta

LOCAL lcFullFile,lii,lcPath,liCount,lcRoot,liy,lcPom,llDal,lcBuffer,liBuffer

lii=1
DO WHILE .T.
   lcPath=SYS(16,m.lii)
   IF LEFT(m.lcPath,3)=="ON."
      lii=m.lii+1
      LOOP
   ENDIF
   EXIT
ENDDO

lcPath=ADDBS(JUSTPATH(m.lcPath)) && vem si cestu sputnho souboru
lcRoot=ExtractRootFromFile(m.lcPath) && vem si Root

lcPom=SUBS(m.lcPath,LEN(m.lcRoot)+1)
liCount=OCCURS("\",m.lcPom) && spotej lomtka

llDal=.F. && zru pznak
FOR lii=m.liCount TO 1 STEP -1
    liy=AT("\",m.lcPom,m.lii)
    lcPath=m.lcRoot+LEFT(m.lcPom,m.liy)
    IF FILE(m.lcPath+m.lcFile) && hledej soubor
       lcFile=m.lcPath+m.lcFile
       RETURN .T.
    ENDIF
NEXT

lcFullFile=FULLPATH(m.lcFile,0) && najdi soubor na cest vzhru a na PATH
llDal=FILE(m.lcFullFile) && pokud neexistuje

IF !llDal
   lcBuffer=SPACE(254)+CHR(0)
   liBuffer=LEN(m.lcBuffer) && nadimezuj buffer
   lii=cvp_GetSystemDirectory(@m.lcBuffer,m.liBuffer)
   IF m.lii>0 && pokud to neselhalo
      lcBuffer=LEFT(m.lcBuffer,m.lii)+"\" && oe buffer
      IF FILE(m.lcBuffer+m.lcFile)
         lcFile=m.lcBuffer+m.lcFile
         llDal=.T.
      ENDIF
   ENDIF
ELSE
   lcFile=m.lcFullFile
ENDIF

RETURN m.llDal

****************************************************************
* ostatn procedury
*
*********************************************************************

FUNCTION cvp_SetActiveWindow(liHWND)
 DECLARE LONG SetActiveWindow IN USER32.DLL  AS cvp_SetActiveWindow LONG
 RETURN cvp_SetActiveWindow(liHWND)
ENDFUNC

FUNCTION cvp_SHChangeNotify(liEventId, luFlags, lcItem1, lcItem2)
 DECLARE LONG SHChangeNotify IN SHELL32.DLL AS cvp_SHChangeNotify LONG, INTEGER, STRING @, STRING @
 RETURN cvp_SHChangeNotify(liEventId, luFlags, @lcItem1, @lcItem2)
ENDFUNC

FUNCTION cvp_SetFileAttributes(lcFile, liATTRIB)
 DECLARE INTEGER SetFileAttributes   IN kernel32 AS cvp_SetFileAttributes String @,INTEGER
 RETURN cvp_SetFileAttributes(@lcFile, liATTRIB)
ENDFUNC

FUNCTION cvp_MoveFile(lcFileOld, lcFileNew)
 DECLARE INTEGER MoveFile IN KERNEL32 AS cvp_MoveFile STRING @, STRING @
 RETURN cvp_MoveFile(@lcFileOld, @lcFileNew)
ENDFUNC

FUNCTION cvp__fpreset
 DECLARE _fpreset IN msvcrt20.dll AS cvp__fpreset
 RETURN cvp__fpreset()
ENDFUNC

FUNCTION cvp_CoCreateGuid(pGuid)
 DECLARE INTEGER CoCreateGuid IN OLE32.DLL AS cvp_CoCreateGuid STRING @pGuid
 RETURN cvp_CoCreateGuid(@pGuid)
ENDFUNC

FUNCTION cvp_LockWindowUpdate(liHWND)
 DECLARE LONG LockWindowUpdate IN USER32.DLL AS cvp_LockWindowUpdate LONG
 RETURN cvp_LockWindowUpdate(liHWND)
ENDFUNC

FUNCTION cvp_GetEnvironmentVariable(lpName, lpBuffer, nSize)
 DECLARE INTEGER GetEnvironmentVariable  IN kernel32.dll AS cvp_GetEnvironmentVariable STRING @, STRING @, INTEGER
 RETURN cvp_GetEnvironmentVariable(@lpName, @lpBuffer, nSize)
ENDFUNC

FUNCTION cvp_GetCurrentThread
 DECLARE INTEGER GetCurrentThread  IN kernel32.dll AS cvp_GetCurrentThread
 RETURN cvp_GetCurrentThread()
ENDFUNC

FUNCTION cvp_GetThreadPriority(liHandle)
 DECLARE INTEGER GetThreadPriority IN kernel32.dll AS cvp_GetThreadPriority LONG
 RETURN cvp_GetThreadPriority(liHandle)
ENDFUNC

FUNCTION cvp_SetThreadPriority(liHandle, liPriority)
DECLARE INTEGER SetThreadPriority IN kernel32.dll AS cvp_SetThreadPriority LONG, INTEGER
 RETURN cvp_SetThreadPriority(liHandle, liPriority)
ENDFUNC

FUNCTION cvp_DragAcceptFiles(lihWnd, lfAccept)
 DECLARE DragAcceptFiles IN Shell32.dll AS cvp_DragAcceptFiles LONG, INTEGER
 RETURN cvp_DragAcceptFiles(lihWnd, lfAccept)
ENDFUNC

FUNCTION cvp_DragQueryFile(lihDrop, liFile, lpszFile,licch)
DECLARE LONG DragQueryFile IN shell32.dll AS cvp_DragQueryFile LONG, LONG, STRING @, INTEGER
 RETURN cvp_DragQueryFile(lihDrop, liFile, @lpszFile,licch)
ENDFUNC

FUNCTION cvp_DragQueryPoint(lihDrop, lclppt) && NOTHING
 DECLARE LONG DragQueryPoint IN shell32.dll AS cvp_DragQueryPoint LONG, STRING @
 RETURN cvp_DragQueryPoint(lihDrop, @lclppt)
ENDFUNC

FUNCTION cvp_CallWindowProc(lpPrevWndFunc, lihWnd, liMsg, lwParam, llParam)
 DECLARE LONG CallWindowProc IN user32.dll AS cvp_CallWindowProc LONG, LONG, LONG , INTEGER, INTEGER
 RETURN cvp_CallWindowProc(lpPrevWndFunc, lihWnd, liMsg, lwParam, llParam)
ENDFUNC

FUNCTION cvp_GetWindowLong(lihWnd, lnIndex)
 DECLARE LONG GetWindowLong IN user32.dll AS cvp_GetWindowLong LONG, INTEGER
 RETURN cvp_GetWindowLong(lihWnd, lnIndex)
ENDFUNC

FUNCTION cvp_DragFinish(lihDrop)
 DECLARE DragFinish IN shell32.dll AS cvp_DragFinish LONG
 RETURN cvp_DragFinish(lihDrop)
ENDFUNC

FUNCTION cvp_SHGetSpecialFolderPath(lihwndOwner, lpszPath, lcsidl, lfCreate)
 DECLARE LONG SHGetSpecialFolderPath IN shell32.dll AS cvp_SHGetSpecialFolderPath LONG, STRING @, INTEGER, INTEGER
 RETURN cvp_SHGetSpecialFolderPath(lihwndOwner, @lpszPath, lcsidl, lfCreate)
ENDFUNC

FUNCTION cvp_PathIsDirectory(lpszPath)
 DECLARE INTEGER PathIsDirectory IN Shlwapi.dll AS cvp_PathIsDirectory STRING @
 RETURN cvp_PathIsDirectory(@lpszPath)
ENDFUNC


FUNCTION cvp_GetDriveType(lpszRootPathName)
 DECLARE INTEGER GetDriveType IN kernel32 AS cvp_GetDriveType String @ lpszRootPathName
 RETURN cvp_GetDriveType(@lpszRootPathName)
ENDFUNC

FUNCTION cvp_RemoveDirectory(lpszPath)
 DECLARE INTEGER RemoveDirectory IN kernel32 AS cvp_RemoveDirectory String @lpszPath
 RETURN cvp_RemoveDirectory(@lpszPath)
ENDFUNC

FUNCTION cvp_DeleteFile(lpszFile)
 DECLARE INTEGER DeleteFile  IN kernel32 AS cvp_DeleteFile String @lpszFile
 RETURN cvp_DeleteFile(@lpszFile)
ENDFUNC

FUNCTION cvp_CopyFile(lpExistingFileName, lpNewFileName, liFlag )
 DECLARE INTEGER CopyFile IN KERNEL32 AS cvp_CopyFile STRING @lpExistingFileName, STRING @lpNewFileName, INTEGER
 RETURN cvp_CopyFile(@lpExistingFileName, @lpNewFileName, liFlag )
ENDFUNC

FUNCTION cvp_GetSystemDirectory(lpBuffer, luSize)
 DECLARE INTEGER GetSystemDirectory IN kernel32 AS cvp_GetSystemDirectory STRING @,INTEGER
 RETURN cvp_GetSystemDirectory(@lpBuffer, luSize)
ENDFUNC

FUNCTION cvp_GetPrivateProfileString(lcSection, lcKeyName, lcDefault, lcBuf, liBufLen, lcFileName)
 DECLARE INTEGER GetPrivateProfileString IN win32api AS cvp_GetPrivateProfileString STRING @Section, STRING @KeyName, STRING @Default, STRING @Buf, INTEGER BufLen, STRING @FileName
 RETURN cvp_GetPrivateProfileString(@lcSection, @lcKeyName, @lcDefault, @lcBuf, liBufLen, @lcFileName)
ENDFUNC

FUNCTION cvp_WritePrivateProfileString(lcSection, lcKeyName, lcBuf, lcFileName)
 DECLARE INTEGER WritePrivateProfileString IN win32api AS cvp_WritePrivateProfileString STRING @Section, STRING @KeyName, STRING @Buf, STRING @FileName
 RETURN cvp_WritePrivateProfileString(@lcSection, @lcKeyName, @lcBuf, @lcFileName)
ENDFUNC

FUNCTION cvp_SystemParametersInfo( luiAction, luiParam, lcpvParam, lfWinIni)
 DECLARE INTEGER SystemParametersInfo IN win32api AS cvp_SystemParametersInfo INTEGER,INTEGER,STRING @,INTEGER
 RETURN cvp_SystemParametersInfo( luiAction, luiParam, @lcpvParam, lfWinIni)
ENDFUNC

FUNCTION cvp_SystemParametersInfoI( luiAction, luiParam, lcpvParam, lfWinIni)
 DECLARE INTEGER SystemParametersInfo IN win32api AS cvp_SystemParametersInfoI INTEGER,INTEGER, INTEGER @,INTEGER
 RETURN cvp_SystemParametersInfoI( luiAction, luiParam, @lcpvParam, lfWinIni)
ENDFUNC

FUNCTION cvp_PathRelativePathTo(lpszPath, lpszFrom, ldwAttrFrom, lpszTo, ldwAttrTo)
 DECLARE Integer PathRelativePathToA IN Shlwapi.DLL  AS cvp_PathRelativePathTo String @ , String @ ,Integer , String @ ,Integer
 RETURN cvp_PathRelativePathTo(@lpszPath, @lpszFrom, ldwAttrFrom, @lpszTo, ldwAttrTo)
ENDFUNC

FUNCTION cvp_MoveWindow(lihWnd, liX, liY, lnWidth, lnHeight, lbRepaint)
 DECLARE INTEGER MoveWindow IN USER32.DLL AS cvp_MoveWindow INTEGER,INTEGER,INTEGER,INTEGER,INTEGER,INTEGER
 RETURN cvp_MoveWindow(lihWnd, liX, liY, lnWidth, lnHeight, lbRepaint)
ENDFUNC

FUNCTION cvp_GetActiveWindow
 DECLARE LONG GetActiveWindow IN WIN32API AS cvp_GetActiveWindow
 RETURN cvp_GetActiveWindow()
ENDFUNC

FUNCTION cvp_GetWindowRect(lihwnd, lcRECT)
 DECLARE LONG GetWindowRect IN USER32.DLL AS cvp_GetWindowRect LONG,STRING @
 RETURN cvp_GetWindowRect(lihwnd, @lcRECT)
ENDFUNC

FUNCTION cvp_Sleep(lii)
 DECLARE Sleep IN kernel32 AS cvp_Sleep integer
 RETURN cvp_Sleep(lii)
ENDFUNC

FUNCTION cvp_GetLastError
 DECLARE INTEGER GetLastError IN kernel32 AS cvp_GetLastError
 RETURN cvp_GetLastError()
ENDFUNC

FUNCTION cvp_SetLastError(fdwError)
 DECLARE INTEGER SetLastError IN kernel32 AS cvp_SetLastError Integer fdwError
 RETURN cvp_SetLastError(fdwError)
ENDFUNC

FUNCTION cvp_GetPrivateProfileInt(lcSection, lcKeyName, liLEN , lcFileName)
 DECLARE INTEGER GetPrivateProfileInt IN win32api AS cvp_GetPrivateProfileInt STRING @Section, STRING @KeyName, INTEGER , STRING @FileName
 RETURN cvp_GetPrivateProfileInt(@lcSection, @lcKeyName, liLEN , @lcFileName)
ENDFUNC

FUNCTION cvp_ExpandEnvironmentStrings(lpSrc, lpDst, lnSize)
 DECLARE INTEGER ExpandEnvironmentStrings IN KERNEL32.DLL AS cvp_ExpandEnvironmentStrings STRING @ ,STRING @, INTEGER
  RETURN cvp_ExpandEnvironmentStrings(@lpSrc, @lpDst, lnSize)
ENDFUNC

FUNCTION cvp_GetDiskFreeSpaceEx(lpDirectoryName, lpFreeBytesAvailable, lpTotalNumberOfBytes, lpTotalNumberOfFreeBytes)
 DECLARE SHORT GetDiskFreeSpaceEx IN kernel32 AS cvp_GetDiskFreeSpaceEx STRING @ lpDirectoryName, STRING @ lpFreeBytesAvailable, STRING @ lpTotalNumberOfBytes, STRING @ lpTotalNumberOfFreeBytes
 RETURN cvp_GetDiskFreeSpaceEx(@lpDirectoryName, @lpFreeBytesAvailable, @lpTotalNumberOfBytes, @lpTotalNumberOfFreeBytes)
ENDFUNC

FUNCTION cvp_PathIsRelative(lcPath)
 DECLARE INTEGER PathIsRelativeA IN shlwapi.dll AS cvp_PathIsRelative string @
 RETURN cvp_PathIsRelative(@lcPath)
ENDFUNC

FUNCTION cvp_GetPrivateProfileSection(lcSection, lcBuf, liBufLen, lcFileName) && NOTHING
 DECLARE INTEGER GetPrivateProfileSection IN win32api AS cvp_GetPrivateProfileSection STRING @Section, STRING @Buf, INTEGER BufLen, STRING @FileName
 RETURN cvp_GetPrivateProfileSection(@lcSection, @lcBuf, liBufLen, @lcFileName)
ENDFUNC

FUNCTION cvp_PathSkipRoot(lcPath)
 DECLARE STRING PathSkipRootA IN shlwapi.dll AS cvp_PathSkipRoot String @
 RETURN cvp_PathSkipRoot(@lcPath)
ENDFUNC

FUNCTION cvp_GetTickCount()
 DECLARE INTEGER GetTickCount IN kernel32 AS cvp_GetTickCount
 RETURN cvp_GetTickCount()
ENDFUNC

 PROCEDURE cvp_CreateFile(m.lcPar1, m.liPar2, m.liPar3, m.liPar4, m.liPar5, m.liPar6, m.liPar7)
  DECLARE LONG CreateFile IN kernel32.dll AS cvp_CreateFile STRING @, INTEGER, INTEGER, INTEGER, INTEGER, INTEGER, LONG
  RETURN cvp_CreateFile(@m.lcPar1, m.liPar2, m.liPar3, m.liPar4, m.liPar5, m.liPar6, m.liPar7)
 ENDPROC 
 
 * MJ 2022-09-02 B
 PROCEDURE cvp_ReadFile(m.liPar1, m.lcPar2, m.liPar3, m.liPar4, m.liPar5)
  DECLARE INTEGER ReadFile IN kernel32.dll AS cvp_ReadFile LONG hFile, STRING @ lpBuffer, INTEGER nNumberOfBytesToRead, INTEGER @ lpNumberOfBytesRead, INTEGER lpOverlapped
  RETURN cvp_ReadFile(m.liPar1, @m.lcPar2, m.liPar3, m.liPar4, m.liPar5)
 ENDPROC
 
 PROCEDURE cvp_SetFilePointer(m.liPar1, m.liPar2, m.liPar3, m.liPar4)
  DECLARE INTEGER SetFilePointer IN kernel32.dll AS cvp_SetFilePointer LONG hFile, INTEGER lowbytes, INTEGER @ highytes, INTEGER mode
  RETURN cvp_SetFilePointer(m.liPar1, m.liPar2, @m.liPar3, m.liPar4)
 ENDPROC
 * MJ 2022-09-02 E

 PROCEDURE CVP_SetProcessWorkingSetSize(m.liProcessID, m.lnMiWS, m.lnMaWS)
  DECLARE INTEGER SetProcessWorkingSetSize IN kernel32 AS CVP_SetProcessWorkingSetSize LONG hProcess, INTEGER dwMinimumWorkingSetSize, INTEGER dwMaximumWorkingSetSize
  RETURN CVP_SetProcessWorkingSetSize(m.liProcessID, m.lnMiWS, m.lnMaWS) 
 ENDPROC

 PROCEDURE CVP_GetCurrentProcess()
  DECLARE LONG GetCurrentProcess IN kernel32 AS CVP_GetCurrentProcess
  RETURN CVP_GetCurrentProcess()
 ENDPROC


*********************************************************************
* 
*********************************************************************
PROCEDURE IsTagExists
LPARAMETERS m.lcTAG, m.liSele

m.liSele=IIF(EMPTY(m.liSele), SELECT(), m.liSele)

LOCAL m.lii, m.liCNT
m.liCNT=TAGCOUNT("", m.liSele)

FOR m.lii=1 TO m.liCNT
    IF TAG(m.lii, m.liSele)==m.lcTAG
       EXIT
    ENDIF
NEXT
RETURN m.lii<=m.liCNT
ENDPROC

*********************************************************************
* vrt maximln RECT umstn okna
*********************************************************************
PROCEDURE GetMaxRectWind(lihwnd,lcNewRect)
* lihwnd    - Handle okna
*@lcNewRect - Nov pozice okna

IF EMPTY(m.lihwnd) && pokud nen definovno
   lihwnd=cvp_GetActiveWindow() && pak zjisti z API
ENDIF

LOCAl lcRect,liMaxWidth,liMaxHeight,liWLeft,liWTop,liWLeftR,liWTopR,liWHeight,liWWidth,liLeft,liTop,liHeight,liWidth

lcRect=REPL(CHR(0),16)
=cvp_SystemParametersInfo(48,0,@m.lcRect,0)

liWLeft=CTOBIN(LEFT(m.lcRect,4),"RS")    && pevod na sla - pozice zleva
liWTop=CTOBIN(SUBS(m.lcRect,5,4),"RS")  && pevod na sla - pozice zeshora
liWLeftR=CTOBIN(SUBS(m.lcRect,9,4),"RS")    && pevod na sla - pozice zleva po
liWTopR=CTOBIN(SUBS(m.lcRect,13,4),"RS")  && pevod na sla - pozice zeshora po

liWHeight=m.liWTopR-m.liWTop && vka pracovn plochy
liWWidth=m.liWLeftR-m.liWLeft && ka pracovn plochy

liMaxWidth=SYSMETRIC(1) && maximln ka plochy
liMaxHeight=SYSMETRIC(2) && maximln vka plochy

liTop=m.liWTop       && pevezmi pozici od shora
liLeft=m.liWLeft     && pevezmi pozici zleva
liWidth=m.liWWidth   && pevezmi ku
liHeight=m.liWHeight && pevezmi vku

IF m.liHeight>m.liMaxHeight && je-li vka pracovn plochy > max. vka zobrazen
   liHeight=m.liMaxHeight-m.liWTop
ENDIF

IF m.liWidth>m.liMaxWidth && je-li vka pracovn plochy > max. vka zobrazen
   liWidth=m.liMaxWidth-m.liWLeft
ENDIF

lcNewRect=BINTOC(m.liLeft,"RS")+BINTOC(m.liTop,"RS")+BINTOC(m.liLeft+m.liWidth,"RS")+BINTOC(m.liLeft+m.liHeight,"RS")
ENDPROC


********************************************************************
PROCEDURE NullTermined(lcChar)
LOCAL lii
lii=AT(CHR(0),m.lcChar) && najdi NULL znak v etzci
RETURN IIF(m.lii>0,LEFT(m.lcChar,m.lii-1),m.lcChar) && a oe to, pokud tam je
ENDPROC

********************************************************************
PROCEDURE SetPict(loPicture,lcProp,lcPicture)  && objekt, nzev vlastnosti,  nzev obrzku
STORE IIF(!EMPTY(m.lcPicture),m.lcPicture,"P") TO ("m.loPicture."+m.lcProp) && nastaven vlastnosti
ENDPROC


PROCEDURE CVP_FILE
LPARAMETERS m.lcFile
LOCAL ARRAY m.laX(1)
RETURN ADIR(m.laX, m.lcFile, "ASHR")>0
ENDPROC

*****************************************************************************
*                                                                           *
*   Direcotory Defination                                                   *
*                                                                           *
*****************************************************************************

**************************************************************************************
PROCEDURE Mkd(lcPath)
* lcPath -  cesta
LOCAL lcPom,lcDriveRoot,lii,loErr

lcPath=ALLT("&lcPath") && preventivn odstra makra
IF DIRECTORY(m.lcPath) && pokud dan cesta existuje
   RETURN 1 && pak se vra 
ENDIF

* patrn nejde o UNC nebo DOS cestu s diskem
IF !(LEFT(m.lcPath,2)="\\" OR SUBS(m.lcPath,2,1)=":")
   lcPom=ALLTRIM(SET("PATH")) && vra nastaven PATH a oe mezery
   IF LEFT(m.lcPath,1)="\" && jde o cestu z rootu, pak musm pidat jen disk (server+sdlen disk)
      IF LEFT(m.lcPom,2)="\\" && jde o UNC cestu
         lii=AT("\",m.lcPom,4) && najdi 4. oddlova
         IF m.lii>0 && pokud tam je
            lcPom=LEFT(m.lcPom,m.lii-1) && pak nati cestu bez oddlovae
         ENDIF
       ELSE
         * jinak jde o DOS cestu
         lcPom=LEFT(m.lcPom,2)
       ENDIF
   ELSE
      IF RIGHT(m.lcPom,1)#"\" && pokud na konci nen oddlova
         lcPom=m.lcPom+"\" && pak ho tam pidej
      ENDIF
   ENDIF
   lcPath=m.lcPom+m.lcPath && seti novou cestu
ENDIF

IF LEFT(m.lcPath,2)#"\\" && pokud to je DOS cesta
   lcDriveRoot=LEFT(m.lcPath,2)+"\"+CHR(0) && vem si disk
   IF INLIST(CVP_GetDriveType(@m.lcDriveRoot),DRIVE_UNKNOWN,DRIVE_CDROM) && Disk neexistuje, nebo je to CD-ROM
      RETURN 4  && vra se
   ENDIF
ENDIF

loErr=.NULL.
TRY
 MD (m.lcPath) && zalo cestu
CATCH TO loErr
FINALLY
ENDTRY

* pokud nen chyba, pak vra 0
* pstup zamtnut
* invalid path or name
RETURN IIF(ISNULL(m.loErr),0,;
       IIF(m.loErr.ErrorNo=1705,2,;
       IIF(m.loErr.ErrorNo=202,3,3)))  && vra pznak chyb
ENDPROC


*********************************************************************************
PROCEDURE RemoveDirectoryAll(lcSource)
IF PCOUNT()=0 && pokud nen parametr
   RETURN .F. && ErrFewArguments pak se vra
ENDIF
LOCAL lcSourceN,lic,lierr,lierrx,lii,lcFSource
LOCAL ARRAY laDir(1)

lcSource=ALLT("&lcSource") && preventivn odstra makra
lcSourceN=m.lcSource+CHR(0) && piti nulov znak

IF RIGHT(m.lcSource,1)#'\' && pokud na konci nen lomtko
   lcSource=m.lcSource+'\' && pak ho pidej
ENDIF

lic=ADIR(laDir,m.lcSource+'*.*','AHRSD')
FOR lii=1 TO m.lic
    IF !(!m.laDir(m.lii,1)=="." AND !m.laDir(m.lii,1)=="..") && pokud se jedn o fiktivn adrese
       LOOP && pak sko na dal
    ENDIF
    IF RIGHT(m.laDir(m.lii,5),1)='D' && jde o adres a m se koprovat
       * pokud se m koprovat a nejde vytvoit
       IF !RemoveDirectoryAll(m.lcSource+m.laDir(m.lii,1))
          RETURN .F. && ErrOther pak se vra
       ENDIF
    ELSE
       * jinak jde o soubor
       lcFSource=m.lcSource+m.laDir(m.lii,1)+CHR(0) && zdroj
        =cvp_SetLastError(0) && vynuluj chyby
       lierr=cvp_DeleteFile(@m.lcFSource) && vmaz souboru
*       lierrx=GetLastError() && nati rozenou chybu
       IF m.lierr=0 && pokud dolo k chyb
          RETURN .F. && ErrOther pak se vra
       ENDIF
   ENDIF
NEXT
=cvp_SetLastError(0) && vynuluj chyby
liErr=cvp_RemoveDirectory(m.lcSourceN) && odstra adres
*liErrx=GetLastError() && nati rozenou chybu

RETURN m.liErr#0 && ErrOK, ErrOther pak se vra .T. pokud nedolo k chyb
ENDPROC


******************************************************************************
PROCEDURE RelativePathFromTo(lcFrom,liFromType,lcTo,liToType)
* lcFrom     - cesta nebo cesta+ soubor odkud
* liFromType - typ (adres,soubor)
* lcTo       - cesta nebo cesta+ soubor kam
* liToType   - typ (adres,soubor) 
LOCAL lcOut,liErr
lcOut=SPACE(254)+CHR(0)
lcTo=m.lcTo+CHR(0)
lcFrom=m.lcFrom+CHR(0)
liErr=cvp_PathRelativePathTo(@m.lcOut,@m.lcFrom,m.liFromType,@m.lcTo,m.liToType)
RETURN NullTermined(IIF(m.liErr=1,m.lcOut,m.lcTo))
ENDPROC


******************************************************************************
* Pipoj text k nzvu souboru (ped pponu)
******************************************************************************
PROCEDURE AppendShortFileFromFile(lcFile,lcAppend)
* lcFile    - cesta+ nzev souboru, nebo jen nzev souboru
* lcAppend  - text, kter se m pipojit
LOCAL lii,lcSFile
lii=RAT("\",m.lcFile) && hledej oddlova
lcSFile=IIF(m.lii>0,SUBS(m.lcFile,m.lii+1),m.lcFile) && pak to ozni
lcFile=IIF(m.lii>0,LEFT(m.lcFile,m.lii),"")  && ponech si zde cestu
lii=RAT(".",m.lcSFile) && hledej teku
RETURN m.lcFile+IIF(m.lii>0,LEFT(m.lcSFile,m.lii-1)+m.lcAppend+SUBS(m.lcSFile,m.lii),m.lcSFile+m.lcAppend)
ENDPROC

******************************************************************************
PROCEDURE ExtractRootFromFile(lcFile)
* lcFile - cesta nebo cesta+ nzev souboru
LOCAL lii,lcRoot,lcSubPath
lcRoot=ADDBS(ALLT(m.lcFile))+CHR(0)
lcSubPath=cvp_PathSkipRoot(@m.lcRoot) && vymkni znho sub cestu
lii=LEN(m.lcSubPath) && zjisti dlku subcesty
RETURN LEFT(m.lcRoot,LEN(m.lcRoot)-1-m.lii-IIF(m.lii=0,0,1))
ENDPROC

******************************************************************************
PROCEDURE ChangeExtensionFromFile(lcFile,lcNewExt)
* lcFile   - cesta+ nzev souboru, nebo jen nzev souboru
* lcNewExt - nov extension
LOCAL lii
lii=RAT(".",lcFile) && hledej teku
RETURN IIF(lii>0,LEFT(lcFile,lii)+lcNewExt,lcFile+'.'+lcNewExt)
ENDPROC


******************************************************************************
PROCEDURE DiskSpaceEx(lcRoot,liErr)
LOCAL liDFS, lpFreeBytesAvailable, lpTotalNumberOfBytes, m.lpTNOfFB
#DEFINE maxInt 4294967296 && &H100000000

STORE REPL(CHR(0), 8) TO lpFreeBytesAvailable, lpTotalNumberOfBytes, m.lpTNOfFB
=cvp_SetLastError(0)
lcRoot=m.lcRoot+CHR(0)
IF cvp_GetDiskFreeSpaceEx(@m.lcRoot, @m.lpFreeBytesAvailable, @m.lpTotalNumberOfBytes, @m.lpTNOfFB) #0

  liDFS = ASC(SUBSTR(m.lpTNOfFB, 1, 1))+256*ASC(SUBSTR(m.lpTNOfFB, 2, 1))+256*256*ASC(SUBSTR(m.lpTNOfFB, 3, 1))+256*256*256*ASC(SUBSTR(m.lpTNOfFB, 4, 1))+;
          (ASC(SUBSTR(m.lpTNOfFB, 5, 1))+256*ASC(SUBSTR(m.lpTNOfFB, 6, 1))+256*256*ASC(SUBSTR(m.lpTNOfFB, 7, 1))+256*256*256*ASC(SUBSTR(m.lpTNOfFB, 8, 1)))*maxInt
   liErr=0
ELSE
   liDFS=-1
   liErr=cvp_GetLastError()
ENDIF
RETURN m.liDFS
ENDPROC



***************************************************************************
PROCEDURE GetShortText(loObj,lcText,liRightLen,lcIntertxt)
* loObj      - Objekt
* lcText     - text je se m zkrtit
* liRightLen - Poet pozic zprava je maj bt vdy vidny
* lcIntertxt - oddlovac text

LOCAL liRighttxt,liModulustxt,lii,liWidth,liIntertxtWidth,liPom,liStart,liEnd,liStep,lcFormat

WITH loObj  && NASTAVEN INF. FontU NA SCREENU DLE OBJEKTU

lcFormat=IIF(.FontBold,"B","")+IIF(.FontItalic,"I","")+IIF(.FontStrikethru,"-","")+IIF(.FontUnderline,"U","")

liWidth=.Width-IIF(PEMSTATUS(m.loObj,"Margin",5),.Margin*2,0)-IIF(PEMSTATUS(m.loObj,"BorderStyle",5) AND .BorderStyle=1,2,0)
ENDWITH

IF TXTWIDTH(m.lcText,m.loObj.FontName,m.loObj.FontSize,m.lcFormat)*FONTMETRIC(6,m.loObj.FontName,m.loObj.FontSize,m.lcFormat)<=m.liWidth   && porovnej dlku textu s vypo. dlkou
   RETURN m.lcText && a pokud je men, pak se vra
ENDIF

WITH loObj  
liRighttxt=LEN(m.lcText)-m.liRightLen
liIntertxtWidth=TXTWIDTH(m.lcIntertxt,.FontName,.FontSize,m.lcFormat)*FONTMETRIC(6,.FontName,.FontSize,m.lcFormat) && dlka mezi textu
liModulustxt=m.liWidth-TXTWIDTH(SUBST(m.lcText,m.liRighttxt),.FontName,.FontSize,m.lcFormat)*FONTMETRIC(6,.FontName,.FontSize,m.lcFormat)-m.liIntertxtWidth && zbyl dlka

* pokud je ka zbylho textu men ne polovika celho textu
IF m.liModulustxt<(TXTWIDTH(m.lcText,.FontName,.FontSize,m.lcFormat)*FONTMETRIC(6,.FontName,.FontSize,m.lcFormat)/2)
   * pak hledej od zatku
   liStart=1
   liEnd=LEN(m.lcText)-m.liRightLen
   liStep=1
ELSE
   * jinak hledej od konce
   liStart=LEN(m.lcText)-m.liRightLen
   liEnd=1
   liStep=-1
ENDIF

FOR lii=m.liStart TO m.liEnd STEP m.liStep
    IF m.liStep=1
       IF TXTWIDTH(LEFT(m.lcText,m.lii),.FontName,.FontSize,m.lcFormat)*FONTMETRIC(6,.FontName,.FontSize,m.lcFormat)>m.liModulustxt && dlka vypotnho textu
          lcText=LEFT(m.lcText,m.lii-1)+m.lcIntertxt+SUBST(m.lcText,m.liRighttxt)
          EXIT
       ENDIF
    ELSE
       IF TXTWIDTH(LEFT(m.lcText,m.lii),.FontName,.FontSize,m.lcFormat)*FONTMETRIC(6,.FontName,.FontSize,m.lcFormat)<=m.liModulustxt && dlka vypotnho textu
          lcText=LEFT(m.lcText,m.lii)+m.lcIntertxt+SUBST(m.lcText,m.liRighttxt)
          EXIT
       ENDIF
    ENDIF
NEXT
ENDWITH

RETURN m.lcText
ENDPROC


***********************************************************
* Vrt etzec omezen na n znak (inteligentn oezvn)
* oddlova se vkld doprosted textu
***************************************************************************
PROCEDURE GetShortText_MidleText(lcText,liMaxLen,liLeftLen,liRightLen,lcIntertxt)
* lcText     - Text na oezn
* liMaxLen   - Maximln dlka
* liLeftLen  - Dlka zleva je m bt zachovna
* liRightLen - Dlka zprava je m bt zachovna
* lcIntertxt - Oddlovac text

LOCAL lii,lcRet
* pokud je dlka textu men nebo rovno maximln
IF LEN(m.lcText)<=m.liMaxLen
   RETURN m.lcText && pak vra pvodn text
ENDIF
* pokud je zbvajc dlka etzce men ne povolen
IF m.liMaxLen-m.liRightLen-LEN(m.lcIntertxt)<m.liLeftLen
   RETURN LEFT(m.lcText,m.liLeftLen)+m.lcIntertxt+RIGHT(m.lcText,m.liMaxLen-m.liLeftLen-LEN(m.lcIntertxt))
ELSE
   RETURN LEFT(m.lcText,m.liMaxLen-m.liRightLen-LEN(m.lcIntertxt))+m.lcIntertxt+RIGHT(m.lcText,m.liRightLen)
ENDIF
ENDPROC


***********************************************************************************
PROCEDURE GetINIString(lcSection,lcKey,lcDVal,liBuf,lcFile)
LOCAL lcBuf,liLen
lcBuf=SPACE(m.liBuf)+CHR(0) && nastav buffer
lcSection=m.lcSection+CHR(0)
lcKey=m.lcKey+CHR(0)
lcDVal=m.lcDVal+CHR(0)
lcFile=m.lcFile+CHR(0)
liLen=cvp_GetPrivateProfileString(@m.lcSection,@m.lcKey,@m.lcDVal,@m.lcBuf,m.liBuf+1,@m.lcFile)
RETURN LEFT(m.lcBuf,m.liLen)
ENDPROC

**************************************************************************************
PROCEDURE WriteINIString(lcSection,lcKey,lcVal,lcFile)
* zapi hodnotu
lcSection=m.lcSection+CHR(0)
lcKey=m.lcKey+CHR(0)
lcVal=m.lcVal+CHR(0)
lcFile=m.lcFile+CHR(0)
=cvp_WritePrivateProfileString(@m.lcSection,@m.lcKey,@m.lcVal,@m.lcFile)
RETURN ErrOK
ENDPROC

***********************************************************************************
PROCEDURE GetINIInt(lcSection,lcKey,liDVal,lcFile)
lcSection=m.lcSection+CHR(0)
lcKey=m.lcKey+CHR(0)
lcFile=m.lcFile+CHR(0)
RETURN cvp_GetPrivateProfileInt(@m.lcSection,@m.lcKey,@m.liDVal,@m.lcFile)
ENDPROC






************************************************************************************
** Vrt pozici znaku, kter nen mezera i tabeltor, v etzci od urit pozice (vyhledv zleva)
************************************************************************************
PROCEDURE AT_NonSpace(lcSource,liStart,liEnd)
* @lcSource - Zdrojov etzec
* liStart   - Startovac pozice pro hledn
* liEnd     - Konen pozice pro hledn
liEnd=IIF(PCOUNT()=3,m.liEnd,LEN(m.lcSource))
DO WHILE m.liStart<=m.liEnd AND (SUBS(m.lcSource,m.liStart,1)=" " OR  SUBS(m.lcSource,m.liStart,1)=CHR(9))
   liStart=m.liStart+1 && Inkrementuj ta
ENDDO
RETURN IIF(m.liStart>m.liEnd,0,;
       IIF(SUBS(m.lcSource,m.liStart,1)==" " OR SUBS(m.lcSource,m.liStart,1)==CHR(9),0,m.liStart)) && Vra poten pozici 
ENDPROC

************************************************************************************
** Vrt pozici znaku, kter nen mezera i tabeltor, v etzci od urit pozice (vyhledv zprava)
************************************************************************************
PROCEDURE RAT_NonSpace(lcSource,liStart,liEnd)
* @lcSource - Zdrojov etzec
* liStart   - Startovac pozice pro hledn
* liEnd     - Konen pozice pro hledn
LOCAL liLen
liEnd=IIF(PCOUNT()=3,m.liEnd,1)
DO WHILE m.liStart>=m.liEnd AND  (SUBS(m.lcSource,m.liStart,1)=" " OR  SUBS(m.lcSource,m.liStart,1)=CHR(9))
   liStart=m.liStart-1 && Dekrementuj ta
ENDDO
RETURN IIF(m.liStart<m.liEnd,0,;
       IIF(SUBS(m.lcSource,m.liStart,1)==" " OR SUBS(m.lcSource,m.liStart,1)==CHR(9),0,m.liStart)) && Vra poten pozici
ENDPROC

************************************************************************************
** Vrt pozici znaku, kter je mezera i tabeltor, v etzci od urit pozice (vyhledv zleva)
************************************************************************************
PROCEDURE AT_Space(lcSource,liStart,liEnd)
* @lcSource - Zdrojov etzec
* liStart   - Startovac pozice pro hledn
* liEnd     - Konen pozice pro hledn
liEnd=IIF(PCOUNT()=3,m.liEnd,LEN(m.lcSource))
DO WHILE m.liStart<=m.liEnd AND !SUBS(m.lcSource,m.liStart,1)=" " AND  !SUBS(m.lcSource,m.liStart,1)=CHR(9)
   liStart=m.liStart+1 && Inkrementuj ta
ENDDO
RETURN IIF(m.liStart>m.liEnd,0,;
       IIF(SUBS(m.lcSource,m.liStart,1)==" " OR SUBS(m.lcSource,m.liStart,1)==CHR(9),m.liStart,0)) && Vra poten pozici
ENDPROC

************************************************************************************
** Vrt pozici znaku, kter nen mezera i tabeltor, v etzci od urit pozice
** (vyhledv zleva), s tm, e ignoruje znaky SPACE a TAB
************************************************************************************
PROCEDURE AT_Word(lcSource,liStart,liEnd)
* @lcSource - Zdrojov etzec
* liStart   - Startovac pozice pro hledn
* liEnd     - Konen pozice pro hledn

liEnd=IIF(PCOUNT()=3,m.liEnd,LEN(m.lcSource))
DO WHILE m.liStart<=m.liEnd AND !SUBS(m.lcSource,m.liStart,1)=" " AND  !SUBS(m.lcSource,m.liStart,1)=CHR(9)
   liStart=m.liStart+1 && Inkrementuj ta
ENDDO
liStart=IIF(m.liStart>m.liEnd,0,;
        IIF(SUBS(m.lcSource,m.liStart,1)==" " OR SUBS(m.lcSource,m.liStart,1)==CHR(9),m.liStart,0)) && Vra poten pozici

IF m.liStart>0
   liEnd=IIF(PCOUNT()=3,m.liEnd,LEN(m.lcSource))
   DO WHILE m.liStart<=m.liEnd AND (SUBS(m.lcSource,m.liStart,1)=" " OR  SUBS(m.lcSource,m.liStart,1)=CHR(9))
      liStart=m.liStart+1 && Inkrementuj ta
   ENDDO
   RETURN IIF(m.liStart>m.liEnd,0,;
          IIF(SUBS(m.lcSource,m.liStart,1)==" " OR SUBS(m.lcSource,m.liStart,1)==CHR(9),0,m.liStart)) && Vra poten pozici
ELSE
   RETURN 0
ENDIF
ENDPROC


************************************************************************************
** Vrt pozici etzce v etzci od urit pozice (vyhledv zleva)
************************************************************************************
PROCEDURE AT_Ex(lcSource,lcString,liStart,liEnd)
* @lcSource - Zdrojov etzec
* @lcString - Hledan etzec
* liStart   - Startovac pozice pro hledn
* liEnd     - Konen pozice pro hledn
LOCAL liLen
liLen=LEN(m.lcString)
liEnd=IIF(PCOUNT()=4,m.liEnd,LEN(m.lcSource))
DO WHILE m.liStart<=m.liEnd AND !SUBS(m.lcSource,m.liStart,m.liLen)==m.lcString
   liStart=m.liStart+1 && Inkrementuj ta
ENDDO
RETURN IIF(m.liStart>m.liEnd,0,;
       IIF(!SUBS(m.lcSource,m.liStart,m.liLen)==m.lcString,0,m.liStart)) && Vra poten pozici
ENDPROC

************************************************************************************
** Vrt pozici etzce v etzci od urit pozice (vyhledv zprava)
************************************************************************************
PROCEDURE RAT_Ex(lcSource,lcString,liStart,liEnd)
* @lcSource - Zdrojov etzec
* @lcString - Hledan etzec
* liStart   - Startovac pozice pro hledn
* liEnd     - Konen pozice pro hledn
LOCAL liLen
liLen=LEN(m.lcString)
liEnd=IIF(PCOUNT()=4,m.liEnd,1)
DO WHILE m.liStart>=m.liEnd AND !SUBS(m.lcSource,m.liStart,m.liLen)==m.lcString
   liStart=m.liStart-1 && Dekrementuj ta
ENDDO
RETURN IIF(m.liStart<m.liEnd,0,;
       IIF(!SUBS(m.lcSource,m.liStart,m.liLen)==m.lcString,0,m.liStart)) && Vra poten pozici nalezenho etzce
ENDPROC


***************************************************************************************
* Rozbal string dle %%
***************************************************************************************
PROCEDURE API_ExpandEnvironmentStrings(lcString)
* lcString - string, kter se m rozbalit

LOCAL lcOut
lcString=m.lcString+CHR(0)
DO WHILE .T.
   lcOut=SPACE(254)+CHR(0)
   =cvp_ExpandEnvironmentStrings(m.lcString,@m.lcOut,LEN(m.lcOut))
   lcOut=NullTermined(m.lcOut) && Zbav se NULL znaku

   IF UPPER(m.lcOut)==UPPER(m.lcString)
      EXIT && Ukoni smyku
   ENDIF
   lcString=m.lcOut
ENDDO

RETURN m.lcOut
ENDPROC



*****************************************************************
* definice obecnch td
******************************************************************
DEFINE CLASS _ParObj AS custom  && univerzln tda pro parametry
   Name="_ParObj"
   DIME pArray(1)
   OK     = .F. && pznak spnosti
   Par1   = .F.
   Par2   = .F.
   Par3   = .F.
   Par4   = .F.
   Par5   = .F.
   Par6   = .F.
   Par7   = .F.
   Par8   = .F.
   Par9   = .F.
   Par10  = .F.
ENDDEFINE 



************************************************************
* definice tdy sloupce pro grid
DEFINE CLASS _Column AS Column
   Name="_Column"
   txtclass="_textbox"
   ADD OBJECT Header1 AS Header

   FontName="Tahoma"
   FontSize=8
   DecimalPlace=0

   Header1.FontName="Tahoma"
   Header1.FontSize=8

   BackColor=RGB(255,255,255)  && barva pozad sloupce
   ForeColor=RGB(000,000,000)  && barva psma sloupce
   ReadOnly=.T.

   PROCEDURE Init
      This.RemoveObject("Text1")
      This.AddObject("Text1",This.txtClass)
      WITH This.Text1
      .Visible=.T.
      .Margin=0    
      .FocusColor=.F.
      .BorderStyle=0  && bez okraje
      .SpecialEffect=1  && plain
      .PropAsColumn=.T.
      ENDWITH
   ENDPROC

   PROCEDURE Show
      STORE .T. TO This.Visible,This.Text1.Visible  && uka textbox
   ENDPROC

   PROCEDURE Header1.DblClick
      LOCAL liMRow, liMRowMax
      liMRow=MCOL(Thisform.Name,3) && pozice myi
      liMRowMax=OBJTOCLIENT(This,2)+This.Parent.Width+1 && pozice sloupce + ka sloupce pevedeno na formul
      * poku se mimo
      IF ! BETWEEN(m.liMRow,m.liMRowMax-5,m.liMRowMax+5)
         RETURN && pak se vra
      ENDIF

      This.Parent.AutoFitEx()
   ENDPROC



   PROCEDURE AutoFitEx(llAlwaysResize, llAllRows)
      LOCAL liSele,liRecno,liHeight,liRow,lolbl,liRelRow,lcSource,loColumn,liMax,luVal,lcType,lcSCOPE
      LOCAL ARRAY laFont(6)

      IF EOF(This.Parent.RecordSource) && pokud tam nen ani zznam
         RETURN && pak se vra
      ENDIF

      loColumn=This && aktivn sloupec
      lcSource=loColumn.ControlSource && zdroj dat
      IF EMPTY(lcSource) OR EMPTY(loColumn.CurrentControl) OR (!loColumn.Resizable AND !m.llAlwaysResize)
         RETURN
      ENDIF


      liSele=SELE() && uschovej si oblast
      WITH This.Parent
      SELE (.RecordSource) && sko na tabulku
      liHeight=.Height-.HeaderHeight-IIF(INLIST(.ScrollBars,1,3),SYSMETRIC(8),0)
      liRow=INT(liHeight/.RowHeight)
      liRelRow=.RelativeRow && relativn dek
      ENDWITH
 
      loControl=EVAL("loColumn."+loColumn.CurrentControl)
      lcType=TYPE("EVAL(lcSource)")
      
      * nyn projdu viditeln dky a zjistm ku textu
      liRecno=RECNO() && zjisti pvodn vtu


      * USCHOVN INF. O FINTU NA SCREENU
      laFont(1)=_SCREEN.FontName
      laFont(2)=_SCREEN.FontSize
      laFont(3)=_SCREEN.FontBold
      laFont(4)=_SCREEN.FontItalic
      laFont(5)=_SCREEN.FontStrikethru
      laFont(6)=_SCREEN.FontUnderline

      IF !PEMSTATUS(loControl,"PropAsColumn",5) OR PEMSTATUS(loControl,"PropAsColumn",5) AND !loControl.PropAsColumn
         * NASTAVEN INF. FontU NA SCREENU DLE OBJEKTU
         _SCREEN.FontName=loControl.FontName
         _SCREEN.FontSize=loControl.FontSize
         _SCREEN.FontBold=loControl.FontBold
         _SCREEN.FontItalic=loControl.FontItalic
         _SCREEN.FontStrikethru=loControl.FontStrikethru
         _SCREEN.FontUnderline=loControl.FontUnderline
      ENDIF

      SKIP -1*(liRelRow-1) && sko na zatek viditelnho obsahu
      liMax=0

      lcSCOPE=IIF(llAllRows,"ALL", "NEXT "+LTRIM(STR(liRow,11)))

      DO CASE
         CASE lcType='C' && etzec
              SCAN &lcSCOPE.
                   IF PEMSTATUS(loControl,"PropAsColumn",5) AND loControl.PropAsColumn
                      * NASTAVEN INF. FontU NA SCREENU DLE OBJEKTU
                      _SCREEN.FontName=IIF(EMPTY(loColumn.DynamicFontName),loColumn.FontName,EVAL(loColumn.DynamicFontName))
                      _SCREEN.FontSize=IIF(EMPTY(loColumn.DynamicFontSize),loColumn.FontSize,EVAL(loColumn.DynamicFontSize))
                      _SCREEN.FontBold=IIF(EMPTY(loColumn.DynamicFontBold),loColumn.FontBold,EVAL(loColumn.DynamicFontBold))
                      _SCREEN.FontItalic=IIF(EMPTY(loColumn.DynamicFontItalic),loColumn.FontItalic,EVAL(loColumn.DynamicFontItalic))
                      _SCREEN.FontStrikethru=IIF(EMPTY(loColumn.DynamicFontStrikethru),loColumn.FontStrikethru,EVAL(loColumn.DynamicFontStrikethru))
                      _SCREEN.FontUnderline=IIF(EMPTY(loColumn.DynamicFontUnderline),loColumn.FontUnderline,EVAL(loColumn.DynamicFontUnderline))
                   ENDIF

                   luVal=EVAL(lcSource)
                   liMax=MAX(_SCREEN.TextWidth(IIF(ISNUL(luVal),".NULL.",RTRIM(luVal)))+10,liMax)
              ENDSCAN

         CASE lcType='M' && etzec
              IF PEMSTATUS(loControl,"PropAsColumn",5) AND loControl.PropAsColumn
                 * NASTAVEN INF. FontU NA SCREENU DLE OBJEKTU
                 _SCREEN.FontName=IIF(EMPTY(loColumn.DynamicFontName),loColumn.FontName,EVAL(loColumn.DynamicFontName))
                 _SCREEN.FontSize=IIF(EMPTY(loColumn.DynamicFontSize),loColumn.FontSize,EVAL(loColumn.DynamicFontSize))
                 _SCREEN.FontBold=IIF(EMPTY(loColumn.DynamicFontBold),loColumn.FontBold,EVAL(loColumn.DynamicFontBold))
                 _SCREEN.FontItalic=IIF(EMPTY(loColumn.DynamicFontItalic),loColumn.FontItalic,EVAL(loColumn.DynamicFontItalic))
                 _SCREEN.FontStrikethru=IIF(EMPTY(loColumn.DynamicFontStrikethru),loColumn.FontStrikethru,EVAL(loColumn.DynamicFontStrikethru))
                 _SCREEN.FontUnderline=IIF(EMPTY(loColumn.DynamicFontUnderline),loColumn.FontUnderline,EVAL(loColumn.DynamicFontUnderline))
              ENDIF
              luVal="Memo"
              liMax=_SCREEN.TextWidth(luVal)+10

         CASE lcType='L' && logick hodnota
              SCAN &lcSCOPE.
                   IF PEMSTATUS(loControl,"PropAsColumn",5) AND loControl.PropAsColumn
                      * NASTAVEN INF. FontU NA SCREENU DLE OBJEKTU
                      _SCREEN.FontName=IIF(EMPTY(loColumn.DynamicFontName),loColumn.FontName,EVAL(loColumn.DynamicFontName))
                      _SCREEN.FontSize=IIF(EMPTY(loColumn.DynamicFontSize),loColumn.FontSize,EVAL(loColumn.DynamicFontSize))
                      _SCREEN.FontBold=IIF(EMPTY(loColumn.DynamicFontBold),loColumn.FontBold,EVAL(loColumn.DynamicFontBold))
                      _SCREEN.FontItalic=IIF(EMPTY(loColumn.DynamicFontItalic),loColumn.FontItalic,EVAL(loColumn.DynamicFontItalic))
                      _SCREEN.FontStrikethru=IIF(EMPTY(loColumn.DynamicFontStrikethru),loColumn.FontStrikethru,EVAL(loColumn.DynamicFontStrikethru))
                      _SCREEN.FontUnderline=IIF(EMPTY(loColumn.DynamicFontUnderline),loColumn.FontUnderline,EVAL(loColumn.DynamicFontUnderline))
                   ENDIF
                   luVal=EVAL(lcSource)
                   liMax=MAX(_SCREEN.TextWidth(IIF(ISNUL(luVal),".NULL.",IIF(luVal,'T','F')))+10,liMax)
              ENDSCAN

         CASE lcType='I' && Integer hodnota
              SCAN &lcSCOPE.
                   IF PEMSTATUS(loControl,"PropAsColumn",5) AND loControl.PropAsColumn
                      * NASTAVEN INF. FontU NA SCREENU DLE OBJEKTU
                      _SCREEN.FontName=IIF(EMPTY(loColumn.DynamicFontName),loColumn.FontName,EVAL(loColumn.DynamicFontName))
                      _SCREEN.FontSize=IIF(EMPTY(loColumn.DynamicFontSize),loColumn.FontSize,EVAL(loColumn.DynamicFontSize))
                      _SCREEN.FontBold=IIF(EMPTY(loColumn.DynamicFontBold),loColumn.FontBold,EVAL(loColumn.DynamicFontBold))
                      _SCREEN.FontItalic=IIF(EMPTY(loColumn.DynamicFontItalic),loColumn.FontItalic,EVAL(loColumn.DynamicFontItalic))
                      _SCREEN.FontStrikethru=IIF(EMPTY(loColumn.DynamicFontStrikethru),loColumn.FontStrikethru,EVAL(loColumn.DynamicFontStrikethru))
                      _SCREEN.FontUnderline=IIF(EMPTY(loColumn.DynamicFontUnderline),loColumn.FontUnderline,EVAL(loColumn.DynamicFontUnderline))
                   ENDIF
                   luVal=EVAL(lcSource)
                   liMax=MAX(_SCREEN.TextWidth(IIF(ISNUL(luVal),".NULL.",LTRIM(STR(luVal,20))))+10,liMax)
              ENDSCAN

         CASE lcType$'Y,N,F,B' && numerick hodnota
              SCAN &lcSCOPE.
                   IF PEMSTATUS(loControl,"PropAsColumn",5) AND loControl.PropAsColumn
                      * NASTAVEN INF. FontU NA SCREENU DLE OBJEKTU
                      _SCREEN.FontName=IIF(EMPTY(loColumn.DynamicFontName),loColumn.FontName,EVAL(loColumn.DynamicFontName))
                      _SCREEN.FontSize=IIF(EMPTY(loColumn.DynamicFontSize),loColumn.FontSize,EVAL(loColumn.DynamicFontSize))
                      _SCREEN.FontBold=IIF(EMPTY(loColumn.DynamicFontBold),loColumn.FontBold,EVAL(loColumn.DynamicFontBold))
                      _SCREEN.FontItalic=IIF(EMPTY(loColumn.DynamicFontItalic),loColumn.FontItalic,EVAL(loColumn.DynamicFontItalic))
                      _SCREEN.FontStrikethru=IIF(EMPTY(loColumn.DynamicFontStrikethru),loColumn.FontStrikethru,EVAL(loColumn.DynamicFontStrikethru))
                      _SCREEN.FontUnderline=IIF(EMPTY(loColumn.DynamicFontUnderline),loColumn.FontUnderline,EVAL(loColumn.DynamicFontUnderline))
                   ENDIF
                   luVal=EVAL(lcSource)
                   liMax=MAX(_SCREEN.TextWidth(IIF(ISNUL(luVal),".NULL.",LTRIM(STR(luVal, 30, This.DecimalPlace))))+10,liMax)
              ENDSCAN
              
         CASE lcType='D' && datum
              SCAN &lcSCOPE.
                   IF PEMSTATUS(loControl,"PropAsColumn",5) AND loControl.PropAsColumn
                      * NASTAVEN INF. FontU NA SCREENU DLE OBJEKTU
                      _SCREEN.FontName=IIF(EMPTY(loColumn.DynamicFontName),loColumn.FontName,EVAL(loColumn.DynamicFontName))
                      _SCREEN.FontSize=IIF(EMPTY(loColumn.DynamicFontSize),loColumn.FontSize,EVAL(loColumn.DynamicFontSize))
                      _SCREEN.FontBold=IIF(EMPTY(loColumn.DynamicFontBold),loColumn.FontBold,EVAL(loColumn.DynamicFontBold))
                      _SCREEN.FontItalic=IIF(EMPTY(loColumn.DynamicFontItalic),loColumn.FontItalic,EVAL(loColumn.DynamicFontItalic))
                      _SCREEN.FontStrikethru=IIF(EMPTY(loColumn.DynamicFontStrikethru),loColumn.FontStrikethru,EVAL(loColumn.DynamicFontStrikethru))
                      _SCREEN.FontUnderline=IIF(EMPTY(loColumn.DynamicFontUnderline),loColumn.FontUnderline,EVAL(loColumn.DynamicFontUnderline))
                   ENDIF
                   luVal=EVAL(lcSource)
                   liMax=MAX(_SCREEN.TextWidth(IIF(ISNUL(luVal),".NULL.",DTOC(luVal)))+10,liMax)
              ENDSCAN

         CASE lcType='T' && datum a as
              SCAN &lcSCOPE.
                   IF PEMSTATUS(loControl,"PropAsColumn",5) AND loControl.PropAsColumn
                      * NASTAVEN INF. FontU NA SCREENU DLE OBJEKTU
                      _SCREEN.FontName=IIF(EMPTY(loColumn.DynamicFontName),loColumn.FontName,EVAL(loColumn.DynamicFontName))
                      _SCREEN.FontSize=IIF(EMPTY(loColumn.DynamicFontSize),loColumn.FontSize,EVAL(loColumn.DynamicFontSize))
                      _SCREEN.FontBold=IIF(EMPTY(loColumn.DynamicFontBold),loColumn.FontBold,EVAL(loColumn.DynamicFontBold))
                      _SCREEN.FontItalic=IIF(EMPTY(loColumn.DynamicFontItalic),loColumn.FontItalic,EVAL(loColumn.DynamicFontItalic))
                      _SCREEN.FontStrikethru=IIF(EMPTY(loColumn.DynamicFontStrikethru),loColumn.FontStrikethru,EVAL(loColumn.DynamicFontStrikethru))
                      _SCREEN.FontUnderline=IIF(EMPTY(loColumn.DynamicFontUnderline),loColumn.FontUnderline,EVAL(loColumn.DynamicFontUnderline))
                   ENDIF
                   luVal=EVAL(lcSource)
                   liMax=MAX(_SCREEN.TextWidth(IIF(ISNUL(luVal),".NULL.",TTOC(luVal)))+10,liMax)
              ENDSCAN

         CASE lcType='G' && general ( objekt )
              IF PEMSTATUS(loControl,"PropAsColumn",5) AND loControl.PropAsColumn
                 * NASTAVEN INF. FontU NA SCREENU DLE OBJEKTU
                 _SCREEN.FontName=IIF(EMPTY(loColumn.DynamicFontName),loColumn.FontName,EVAL(loColumn.DynamicFontName))
                 _SCREEN.FontSize=IIF(EMPTY(loColumn.DynamicFontSize),loColumn.FontSize,EVAL(loColumn.DynamicFontSize))
                 _SCREEN.FontBold=IIF(EMPTY(loColumn.DynamicFontBold),loColumn.FontBold,EVAL(loColumn.DynamicFontBold))
                 _SCREEN.FontItalic=IIF(EMPTY(loColumn.DynamicFontItalic),loColumn.FontItalic,EVAL(loColumn.DynamicFontItalic))
                 _SCREEN.FontStrikethru=IIF(EMPTY(loColumn.DynamicFontStrikethru),loColumn.FontStrikethru,EVAL(loColumn.DynamicFontStrikethru))
                 _SCREEN.FontUnderline=IIF(EMPTY(loColumn.DynamicFontUnderline),loColumn.FontUnderline,EVAL(loColumn.DynamicFontUnderline))
              ENDIF
              luVal='General'
              liMax=_SCREEN.TextWidth(luVal)+10
      ENDCASE

      _SCREEN.FontName=laFont(1)
      _SCREEN.FontSize=laFont(2)
      _SCREEN.FontBold=laFont(3)
      _SCREEN.FontItalic=laFont(4)
      _SCREEN.FontStrikethru=laFont(5)
      _SCREEN.FontUnderline=laFont(6)

      GO liRecno && sko na pvodn vtu
      IF liMax>0 && pokud tam nco je
         loColumn.Width=liMax && pak nastav novou ku
      ENDIF
      SELE (liSele)
   ENDPROC

ENDDEFINE
