LPARAM luPar1,luPar2,luPar3,luPar4,luPar5

* Load localized layout report to basic report
LOCAL loRPTL,llRet
loRPTL=CREATEOBJECT("_rptlocalize")
DO CASE
   CASE m.luPar1=="L"
        llRet=m.loRPTL.CreateLayout(@m.luPar2,@m.luPar3,@m.luPar4,@m.luPar5)

   CASE m.luPar1=="S"
        llRet=m.loRPTL.SynchroniseLayout(@m.luPar2,@m.luPar3,@m.luPar4)

   CASE m.luPar1=="C"
        llRet=m.loRPTL.SynchroniseLayoutX(@m.luPar2,@m.luPar3)

   CASE m.luPar1=="CL"
        llRet=m.loRPTL.CopyLayout(@m.luPar2,@m.luPar3)

ENDCASE
RETURN m.llRet

*************************************************************************************

************************************************************************
DEFINE CLASS _rptlocalize AS CUSTOM
   lErr=.F.

   PROCEDURE Error(nError,cMethod,nLine)
      * nError  - Error number
      * cMethod - Name procedure
      * nLine   - Row number

      LOCAL lcErr,lii,lcCProg,lcPom

      DO CASE
         CASE UPPER(m.cMethod)=="CREATETABLE" OR;
              UPPER(m.cMethod)=="OPENTABLE" OR ;
              UPPER(m.cMethod)=="COPYFILE"

              This.lErr=.T.
         OTHERWISE

              IF TYPE("XX_System")="O"
                 lii=0
                 lcCProg="A"
                 lcPom=""
                 DO WHILE !EMPTY(m.lcCProg)
                    lii=m.lii+1  && Inkrementuj ta
                    lcCProg=PROGRAM(m.lii)   && Nzev programu
                    lcPom=m.lcPom+CHR(9)+m.lcCProg+CRLF
                 ENDDO

                 =m.XX_System.OPT.Add(m.XX_System.GetModulObj(),;
                                      CHR(9)+"E: "+LTRIM(STR(m.nError,11))+" M: "+m.cMethod+" L: "+LTRIM(STR(m.nLine,11))+CRLF+;
                                      CHR(9)+MESSAGE()+CRLF+CHR(9)+MESSAGE(1)+CRLF+;
                                      m.lcPom, .T.)

              ENDIF 

              lcErr=ON("ERROR")
              IF !EMPTY(m.lcErr)
                 ON ERROR &lcErr.
              ELSE
                 =DODEFAULT(m.nError,m.cMethod,m.nLine)
                 ERROR m.nError
              ENDIF
      ENDCASE
   ENDPROC

   PROTECTED PROCEDURE CreateTable(lcNew,laFields,lcAlias)
      * lcNew    - New file
      * laFields - Array with structure
      * lcAlias  - Alias
      This.lErr=.F.
      CREATE TABLE (m.lcNew) FREE  FROM ARRAY m.laFields
      IF !This.lErr
         USE
         USE (m.lcNew) IN 0 ALIAS (m.lcAlias)
      ENDIF
      RETURN !This.lErr
   ENDPROC

   PROTECTED PROCEDURE OpenTable(lcTable,lcAlias,lcParam)
      This.lErr=.F.
      USE (m.lcTable) ALIAS (m.lcAlias) IN 0 &lcParam.
      RETURN !This.lErr
   ENDPROC

   PROTECTED PROCEDURE CopyFile(lcSR,lcDR)
      This.lErr=.F.
      COPY FILE (m.lcSR) TO (m.lcDR)
      RETURN !This.lErr
   ENDPROC

   PROTECTED PROCEDURE GetLCC(lcComment,lcLCC,lcLCCSC,llOnlyBasicLCC) && Return LCC from comment
      LOCAL lii,liy
      lii=AT("LCC:",m.lcComment)
      lcLCC=""
      IF m.lii>0
         lcPom=SUBST(m.lcComment,lii+4)
         liy=AT(CHR(13),m.lcPom)
         lcLCC=ALLT(IIF(m.liy>0,LEFT(m.lcPom,m.liy-1),m.lcPom))
         liy=RAT(":",m.lcLCC)
         IF m.liy>0
            lcLCCSC=SUBST(m.lcLCC,m.liy+1)
            lcLCC=LEFT(m.lcLCC,m.liy-1)
         ELSE
            lcLCCSC=""
         ENDIF
         IF m.llOnlyBasicLCC
            liy=AT(":",m.lcLCC)
            IF m.liy>0
               lcLCC=LEFT(m.lcLCC,m.liy-1)
            ENDIF
         ENDIF

      ENDIF
      RETURN m.lii
   ENDPROC

   PROTECTED PROCEDURE SetLCC(lcComment,lcLCC,lcLCCSC)
      LOCAL lii,liy
      lii=AT("LCC:",m.lcComment)
      IF m.lii>0
         lcPom=SUBST(m.lcComment,lii+4)
         liy=AT(CHR(13),m.lcPom)
         lcComment=STUFF(m.lcComment,m.lii,IIF(m.liy=0,LEN(m.lcComment)-m.lii+1,m.liy+4-1),"LCC:"+m.lcLCC+":"+m.lcLCCSC)
      ELSE
         lcComment=m.lcComment+"LCC:"+m.lcLCC+":"+m.lcLCCSC
      ENDIF
      RETURN m.lcComment
   ENDPROC


   PROCEDURE CreateLayout(lcABasic,lcALayout,lcNew,lcAShadow)
      * lcABasic     - Alias basic report
      * lcALayout    - Alias Layout report
      * lcNew     - Output file (report)
      *@lcAShadow - Output alias (report)

      LOCAL lcLCC,lii,liSRX,loRam,lcATMP
      LOCAL ARRAY laRow(1),laSR_C(1),laSR_R(1),laFields(1)

      lcATMP=SYS(2015)
      lcAShadow=SYS(2015)

      * Scan basic report
      SELE (m.lcABasic)
      COUNT TO liSRX FOR INLIST(OBJTYPE,5,6,7,8,17,9)
      IF m.liSRX>0
         DIME laSR_C(m.liSRX,1), laSR_R(m.liSRX,1)
      ENDIF

      * check LCC
      SCAN FOR INLIST(OBJTYPE,5,6,7,8,17,9)
           * locate LCC code
           IF OBJTYPE=9
              lcLCC=STR(OBJTYPE,3)+STR(OBJCODE,3)+EXPR
           ELSE
              =This.GetLCC(COMMENT,@m.lcLCC,"")
           ENDIF
           * If not exist, add it
           IF EMPTY(m.lcLCC)
              lcLCC=SYS(2015)
              REPL COMMENT WITH COMMENT+CHR(13)+CHR(10)+"LCC:"+m.lcLCC
           ENDIF
      ENDSCAN

      * Create copy record
      =AFIELDS(m.laFields)

      SELE 0 
      CREATE CURSOR (m.lcATMP) FROM ARRAY laFields
      SELE 0
      IF !This.CreateTable(lcNew,@m.laFields,m.lcAShadow)
         RETURN .F.
      ENDIF

      SELE (m.lcABasic)
      SCAN FOR INLIST(OBJTYPE,5,6,7,8,17,9)
           SCATTER TO laRow MEMO
           INSERT INTO (m.lcATMP) FROM ARRAY laRow
      ENDSCAN

      SELE (m.lcABasic)
      SCAN FOR !INLIST(OBJTYPE,5,6,7,8,17,9,25,26,18)
           SCATTER TO laRow MEMO
           INSERT INTO (m.lcAShadow) FROM ARRAY laRow
      ENDSCAN

      SELE (m.lcATMP)
      * Create index 
      liSRX=1
      SCAN ALL
           =This.GetLCC(COMMENT,@m.lcLCC,"")
           laSR_C(m.liSRX)=m.lcLCC
           laSR_R(m.liSRX)=RECNO()
           liSRX=m.liSRX+1
      ENDSCAN

      * Find all non objects
      SELE (m.lcALayout)
      SCAN FOR INLIST(OBJTYPE,5,6,7,8,17,9)
           IF OBJTYPE=9
              lcLCC=STR(OBJTYPE,3)+STR(OBJCODE,3)+EXPR
           ELSE
              =This.GetLCC(COMMENT,@m.lcLCC,"")
           ENDIF
           IF !EMPTY(m.lcLCC)
              lii=ASCAN(m.laSR_C,m.lcLCC)
              IF m.lii=0 && Not found, Insert It
                 SCATTER TO laRow MEMO
                 INSERT INTO (m.lcAShadow) FROM ARRAY laRow
              ELSE
                 * 5,6,7,8,17. VPOS, HPOS, WITDH, HEIGHT
                 * 9 WITDH, HEIGHT
                 * 5 EXPR
                 SCATTER NAME loRam MEMO
                 SELE (m.lcATMP)
                 GO (m.laSR_R(m.lii))
                 DO CASE
                    CASE OBJTYPE=9
                         REPLACE PLAIN WITH m.loRam.PLAIN, HEIGHT WITH m.loRam.HEIGHT

                    CASE OBJTYPE=17
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 GENERAL WITH m.loRam.GENERAL, DOUBLE WITH m.loRam.DOUBLE,;
                                 MODE WITH m.loRam.MODE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP,;
                                 NAME WITH m.loRam.NAME,;
                                 PICTURE WITH m.loRam.PICTURE
                           
                    CASE OBJTYPE=5
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 EXPR WITH m.loRam.EXPR,;
                                 PENRED WITH m.loRam.PENRED,PENGREEN WITH m.loRam.PENGREEN,PENBLUE WITH m.loRam.PENBLUE,;
                                 FILLRED WITH m.loRam.FILLRED,FILLGREEN WITH m.loRam.FILLGREEN,FILLBLUE WITH m.loRam.FILLBLUE,;
                                 FONTFACE WITH m.loRam.FONTFACE,FONTSIZE WITH m.loRam.FONTSIZE,FONTSTYLE WITH m.loRam.FONTSTYLE,;
                                 MODE WITH m.loRam.MODE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP,;
                                 PICTURE WITH m.loRam.PICTURE,;
                                 SPACING WITH m.loRam.SPACING,;
                                 OFFSET WITH m.loRam.OFFSET,;
                                 RESOID WITH m.loRam.RESOID


                    CASE OBJTYPE=6
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 PENSIZE WITH m.loRam.PENSIZE,PENPAT WITH m.loRam.PENPAT,;
                                 PENRED WITH m.loRam.PENRED,PENGREEN WITH m.loRam.PENGREEN,PENBLUE WITH m.loRam.PENBLUE,;
                                 FILLRED WITH m.loRam.FILLRED,FILLGREEN WITH m.loRam.FILLGREEN,FILLBLUE WITH m.loRam.FILLBLUE,;
                                 MODE WITH m.loRam.MODE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP


                    CASE OBJTYPE=7
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 PENSIZE WITH m.loRam.PENSIZE,PENPAT WITH m.loRam.PENPAT,FILLPAT WITH m.loRam.FILLPAT,;
                                 PENRED WITH m.loRam.PENRED,PENGREEN WITH m.loRam.PENGREEN,PENBLUE WITH m.loRam.PENBLUE,;
                                 FILLRED WITH m.loRam.FILLRED,FILLGREEN WITH m.loRam.FILLGREEN,FILLBLUE WITH m.loRam.FILLBLUE,;
                                 MODE WITH m.loRam.MODE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP,;
                                 OFFSET WITH m.loRam.OFFSET


                    CASE OBJTYPE=8
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 FONTFACE WITH m.loRam.FONTFACE,FONTSIZE WITH m.loRam.FONTSIZE,FONTSTYLE WITH m.loRam.FONTSTYLE,;
                                 PENRED WITH m.loRam.PENRED,PENGREEN WITH m.loRam.PENGREEN,PENBLUE WITH m.loRam.PENBLUE,;
                                 FILLRED WITH m.loRam.FILLRED,FILLGREEN WITH m.loRam.FILLGREEN,FILLBLUE WITH m.loRam.FILLBLUE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 MODE WITH m.loRam.MODE,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP,;
                                 PICTURE WITH m.loRam.PICTURE,;
                                 SPACING WITH m.loRam.SPACING,;
                                 OFFSET WITH m.loRam.OFFSET,;
                                 RULERLINES WITH m.loRam.RULERLINES,;
                                 RESOID WITH m.loRam.RESOID

                 ENDCASE
                 SCATTER TO laRow MEMO
                 INSERT INTO (m.lcAShadow) FROM ARRAY m.laRow
           
                 SELE (m.lcALayout)
              ENDIF
           ELSE
              SCATTER TO laRow MEMO
              INSERT INTO (m.lcAShadow) FROM ARRAY m.laRow
           ENDIF
      ENDSCAN

      * Append DE
      SELE (m.lcABasic)
      SCAN FOR INLIST(OBJTYPE,18,25,26,23)
           SCATTER TO laRow MEMO
           INSERT INTO (m.lcAShadow) FROM ARRAY m.laRow
      ENDSCAN
      USE IN (m.lcATMP)
      RETURN .T.
   ENDPROC

   PROCEDURE SynchroniseLayout(lcSR,lcDR,liMode) && Synchronization localized report with basic report
      * lcSR   - Source report
      * lcDR   - Destination report - layout
      * liMode - Synchrnoisation mode (0 - transitional, 1 - strict)
      LOCAL lcASR,lcADR,lcLCC,llExist,lii,liDR,liSR,lcLCCSC,llDele,liWIDTH,liSRX,lcSafety,lcATMP
      LOCAL ARRAY laRow(1),laDR_C(1),laDR_R(1),laDR_SC(1),laSR_C(1),laSR_R(1),laFields(1)
      liMode=IIF(PCOUNT()<3 OR TYPE("m.liMode")#"N",0,m.liMode)

      lcSafety=SET("SAFETY")
      SET SAFETY OFF

      lcASR=SYS(2015)
      lcADR=SYS(2015)
      lcATMP=SYS(2015)

      IF !FILE(m.lcDR)
         IF !This.CopyFile(m.lcSR,m.lcDR)
            DELE FILE (m.lcDR)
            RETURN .F.
         ENDIF

         IF !This.CopyFile(STRTRAN(LOWER(m.lcSR),".frx",".frt"),STRTRAN(LOWER(m.lcDR),".frx",".frt"))
            DELE FILE (STRTRAN(LOWER(m.lcDR),".frx",".frt"))
            RETURN .F.
         ENDIF
      ELSE
         llExist=.T.
      ENDIF

      IF !This.OpenTable(m.lcSR,m.lcASR," AGAIN")
         RETURN .F.
      ENDIF

      IF !This.OpenTable(m.lcDR,m.lcADR," EXCLUSIVE")
         USE IN (m.lcASR)
         RETURN .F.
      ENDIF

      * Create copy record
      SELE (m.lcASR)
      =AFIELDS(m.laFields)

      SELE 0 
      CREATE CURSOR (m.lcATMP) FROM ARRAY laFields

      SELE (m.lcADR)
      SCAN FOR INLIST(OBJTYPE,5,6,7,8,17,9)
           SCATTER TO laRow MEMO
           INSERT INTO (m.lcATMP) FROM ARRAY m.laRow
      ENDSCAN
      ZAP

      SELE (m.lcASR)
      SCAN FOR !INLIST(OBJTYPE,5,6,7,8,17,9,25,26,23,18)
           SCATTER TO laRow MEMO
           INSERT INTO (m.lcADR) FROM ARRAY m.laRow
      ENDSCAN

      * Find all non objects
      liDR=0
      IF m.llExist
         SELE (m.lcATMP)
         liDR=RECC()
         IF m.liDR>0
            DIME laDR_C(m.liDR,1), laDR_R(m.liDR,1), laDR_SC(m.liDR,1), laDR_RX(m.liDR,1)
         ENDIF
         GO BOTTOM
         lii=0

         DO WHILE !BOF()
            IF OBJTYPE=9
               lcLCC=STR(OBJTYPE,3)+STR(OBJCODE,3)+EXPR
               lcLCCSC=""
               SELE (m.lcASR)
               LOCATE FOR STR(OBJTYPE,3)+STR(OBJCODE,3)+EXPR==m.lcLCC
               IF !FOUND()
                  lcLCC=""
               ENDIF
               SELE (m.lcATMP)
            ELSE
               =This.GetLCC(COMMENT,@m.lcLCC,@m.lcLCCSC)
            ENDIF
            IF !EMPTY(m.lcLCC)
               lii=m.lii+1
               laDR_C(m.lii)=m.lcLCC
               laDR_SC(m.lii)=m.lcLCCSC
               laDR_R(m.lii)=RECNO()
            ELSE
               IF m.liMode=1 OR OBJTYPE=9
                  DELE NEXT 1
                  llDele=.T.
               ENDIF
            ENDIF
            SKIP -1
         ENDDO

         liDR=m.lii
         IF m.liDR>0
            DIME laDR_C(m.lii), laDR_R(m.lii),laDR_RX(m.lii), laDR_SC(m.lii)
         ENDIF

         IF m.llDele
            PACK
         ENDIF


         SCAN ALL
              IF OBJTYPE=9
                 lcLCC=STR(OBJTYPE,3)+STR(OBJCODE,3)+EXPR
                 lcLCCSC=""
              ELSE
                 =This.GetLCC(COMMENT,@m.lcLCC,@m.lcLCCSC)
              ENDIF

              SCATTER TO laRow MEMO
              INSERT INTO (m.lcADR) FROM ARRAY m.laRow

              IF !EMPTY(m.lcLCC)
                 lii=ASCAN(m.laDR_C,m.lcLCC)
                 IF m.lii>0 && found
                    laDR_RX(m.lii)=RECC(m.lcADR)
                 ENDIF
              ENDIF
         ENDSCAN
      ENDIF

      SELE (m.lcASR)
      COUNT TO liSR FOR INLIST(OBJTYPE,5,6,7,8,17,9)
      IF m.liSR>0
         DIME laSR_C(m.liSR,1), laSR_R(m.liSR,1)
      ENDIF
      liSRX=1

      SCAN FOR INLIST(OBJTYPE,5,6,7,8,17,9)
           * locate LCC code
           IF OBJTYPE=9
              lcLCC=STR(OBJTYPE,3)+STR(OBJCODE,3)+EXPR
              lcLCCSC=""
           ELSE
              =This.GetLCC(COMMENT,@m.lcLCC,@m.lcLCCSC)
           ENDIF

           * If not exist, add it
           IF EMPTY(m.lcLCC)
              lcLCC=SYS(2015)
              REPL COMMENT WITH COMMENT+CHR(13)+CHR(10)+"LCC:"+m.lcLCC
           ENDIF
           lcLCCSC=IIF(OBJTYPE=5,EXPR,"0000")
           liWIDTH=WIDTH

           laSR_C(m.liSRX)=m.lcLCC
           laSR_R(m.liSRX)=RECNO()
           liSRX=m.liSRX+1

           * locate object with same LCC code in localized report        
           lii=ASCAN(m.laDR_C,m.lcLCC)
           IF m.lii=0
              SCATTER TO laRow MEMO
              INSERT INTO (m.lcADR) FROM ARRAY laRow
              SELE (m.lcADR)
              REPL COMMENT WITH This.SetLCC(COMMENT,m.lcLCC,m.lcLCCSC)
           ELSE
              * LCC found, check LCC sub code
              IF OBJTYPE=5 AND !m.lcLCCSC==m.laDR_SC(m.lii)
                 SELE (m.lcADR)
                 GO (m.laDR_RX(m.lii))
                 REPL EXPR WITH '"'+SUBST(m.lcLCCSC,2,LEN(m.lcLCCSC)-2)+" ("+SUBST(EXPR,2,LEN(EXPR)-2)+")"+'"',;
                      COMMENT WITH This.SetLCC(COMMENT,m.lcLCC,m.lcLCCSC), WIDTH WITH WIDTH+m.liWIDTH
              ENDIF
              SELE (m.lcASR)
           ENDIF
      ENDSCAN

      SELE (m.lcADR)
      * Delete lost objects
      IF m.liSR>0 AND m.liDR>0
         llDele=.F.
         FOR lii=1 TO m.liDR
             IF ASCAN(m.laSR_C,m.laDR_C(m.lii))=0
                GO (m.laDR_RX(m.lii))
                DELETE NEXT 1
                llDele=.T.
             ENDIF
         NEXT

         IF m.llDele
            PACK
         ENDIF
      ENDIF

      * Append DE
      SELE (m.lcASR)
      SCAN FOR INLIST(OBJTYPE,18,25,26,23)
           SCATTER TO laRow MEMO
           INSERT INTO (m.lcADR) FROM ARRAY laRow
      ENDSCAN

      USE IN (m.lcASR)
      USE IN (m.lcADR)
      USE IN (m.lcATMP)

      IF m.lcSafety=="ON"
         SET SAFETY ON
      ENDIF
      RETURN
   ENDPROC


   PROCEDURE SynchroniseLayoutX(lcSR,lcDR) && Create localized report from basic report
      * lcSR   - Source report
      * lcDR   - Destination report - layout
      LOCAL lcASR,lcADR,lcLCC,llExist,lii,lcLCCSC,llDele,liWIDTH,lcSafety,lcPom
      LOCAL ARRAY laRow(1),laDR_C(1),laDR_R(1),laDR_SC(1), m.laFields(1)

      lcSafety=SET("SAFETY")
      SET SAFETY OFF

      lcASR=SYS(2015)
      lcADR=SYS(2015)
      lcATMP=SYS(2015)

      IF !FILE(m.lcDR)
         IF !This.CopyFile(m.lcSR,m.lcDR)
            DELE FILE (m.lcDR)
            RETURN .F.
         ENDIF

         IF !This.CopyFile(STRTRAN(LOWER(m.lcSR),".frx",".frt"),STRTRAN(LOWER(m.lcDR),".frx",".frt"))
            DELE FILE (STRTRAN(LOWER(m.lcDR),".frx",".frt"))
            RETURN .F.
         ENDIF
      ELSE
         llExist=.T.
      ENDIF

      IF !This.OpenTable(m.lcSR,m.lcASR," AGAIN")
         RETURN .F.
      ENDIF

      IF !This.OpenTable(m.lcDR,m.lcADR," EXCLUSIVE")
         USE IN (m.lcASR)
         RETURN .F.
      ENDIF


      SELE (m.lcADR)
      IF !m.llExist
         ZAP
      ELSE
         =AFIELDS(m.laFields)
         SELE 0 
         CREATE CURSOR (m.lcATMP) FROM ARRAY laFields

         SELE (m.lcADR)
         SCAN FOR OBJTYPE=5
              SCATTER TO laRow MEMO
              INSERT INTO (m.lcATMP) FROM ARRAY laRow
         ENDSCAN
         ZAP

         SELE (m.lcATMP)
         lii=RECC()
         IF m.lii>0
            DIME laDR_C(m.lii,1), laDR_R(m.lii,1), laDR_SC(m.lii,1)
         ENDIF
         GO BOTTOM
         lii=0

         DO WHILE !BOF()
            =This.GetLCC(COMMENT,@m.lcLCC,@m.lcLCCSC)
            IF !EMPTY(m.lcLCC)
               lii=m.lii+1
               laDR_C(m.lii)=m.lcLCC
               laDR_SC(m.lii)=IIF(OBJTYPE=5,EXPR,"0000")
               laDR_R(m.lii)=RECNO()
            ELSE
               DELE NEXT 1
               llDele=.T.
            ENDIF
            SKIP -1
         ENDDO

         IF m.lii>0
            DIME laDR_C(m.lii),laDR_R(m.lii), laDR_SC(m.lii)
         ENDIF

         IF m.llDele
            PACK
         ENDIF
      ENDIF

      SELE (m.lcASR)
      SCAN ALL
           SCATTER TO laRow MEMO
           INSERT INTO (m.lcADR) FROM ARRAY laRow

           IF INLIST(OBJTYPE,5,6,7,8,17,9)
              IF OBJTYPE=9
                 lcLCC=STR(OBJTYPE,3)+STR(OBJCODE,3)+EXPR
                 lcLCCSC=""
              ELSE
                 =This.GetLCC(COMMENT,@m.lcLCC,@m.lcLCCSC)
              ENDIF

              * If not exist, add it
              IF EMPTY(m.lcLCC)
                 lcLCC=SYS(2015)
                 REPL COMMENT WITH COMMENT+CHR(13)+CHR(10)+"LCC:"+m.lcLCC
              ENDIF
              lcLCCSC=IIF(OBJTYPE=5,EXPR,"0000")
              liWIDTH=WIDTH

              IF OBJTYPE=5
                 SELE (m.lcADR)
                 lii=ASCAN(m.laDR_C,m.lcLCC)
                 IF m.lii>0 && found
                    GO (m.laDR_R(m.lii)) IN (m.lcATMP)
                    lcPom=EVAL(m.lcATMP+".EXPR")
                    IF m.lcLCCSC==m.laDR_SC(m.lii)
                       REPL EXPR WITH m.lcPom, WIDTH WITH EVAL(m.lcATMP+".WIDTH")
                    ELSE
                       REPL EXPR WITH '"'+SUBST(m.lcLCCSC,2,LEN(m.lcLCCSC)-2)+" ("+SUBST(m.lcPom,2,LEN(m.lcPom)-2)+")"+'"',;
                            WIDTH WITH WIDTH+m.liWIDTH

                    ENDIF
                 ENDIF
                 REPL COMMENT WITH This.SetLCC(COMMENT,m.lcLCC,m.lcLCCSC)
                 SELE (m.lcASR)
              ENDIF
           ENDIF
      ENDSCAN

      USE IN (m.lcASR)
      USE IN (m.lcADR)
      IF m.llExist
         USE IN (m.lcATMP)
      ENDIF
      
      IF m.lcSafety=="ON"
         SET SAFETY ON
      ENDIF
      RETURN
   ENDPROC


   PROCEDURE CopyLayout(lcSR,lcDR)
      * lcSR  - Source report
      * lcDR  - Destination report

      LOCAL lcASR,lcADR,lcLCC,lii,liSRX,loRam
      LOCAL ARRAY laRow(1),laSR_C(1),laSR_R(1),laFields(1)

      lcASR=SYS(2015)
      lcADR=SYS(2015)


      IF !This.OpenTable(m.lcSR,m.lcASR," AGAIN")
         RETURN .F.
      ENDIF

      IF !This.OpenTable(m.lcDR,m.lcADR," AGAIN")
         USE IN (m.lcASR)
         RETURN .F.
      ENDIF

      * Scan basic report
      SELE (m.lcADR)
      COUNT TO liSRX FOR INLIST(OBJTYPE,5,6,7,8,17,9,1)
      IF m.liSRX>0
         DIME laSR_C(m.liSRX,1), laSR_R(m.liSRX,1)
      ENDIF

      * check LCC
      SCAN FOR INLIST(OBJTYPE,5,6,7,8,17,9,1)
           * locate LCC code
           IF OBJTYPE=9
              lcLCC=STR(OBJTYPE,3)+STR(OBJCODE,3)+EXPR
           ELSE
              IF OBJTYPE=1
                 lcLCC=STR(OBJTYPE,3)+STR(OBJCODE,3)
              ELSE
                 =This.GetLCC(COMMENT,@m.lcLCC,"",.T.)
              ENDIF
           ENDIF
           * If not exist, add it
           IF EMPTY(m.lcLCC)
              lcLCC=SYS(2015)
              REPL COMMENT WITH COMMENT+CHR(13)+CHR(10)+"LCC:"+m.lcLCC
           ENDIF
      ENDSCAN

      * Create copy record
      =AFIELDS(m.laFields)

      SELE (m.lcADR)
      * Create index 
      liSRX=1
      SCAN FOR INLIST(OBJTYPE,1,5,6,7,8,17,9)
           IF OBJTYPE=9
              lcLCC=STR(OBJTYPE,3)+STR(OBJCODE,3)+EXPR
           ELSE
              IF OBJTYPE=1
                 lcLCC=STR(OBJTYPE,3)+STR(OBJCODE,3)
              ELSE
                 =This.GetLCC(COMMENT,@m.lcLCC,"",.T.)
              ENDIF
           ENDIF
           laSR_C(m.liSRX)=m.lcLCC
           laSR_R(m.liSRX)=RECNO()
           liSRX=m.liSRX+1
      ENDSCAN

      * Find all non objects
      SELE (m.lcASR)
      SCAN FOR INLIST(OBJTYPE,1,5,6,7,8,17,9)
           IF OBJTYPE=9 
              lcLCC=STR(OBJTYPE,3)+STR(OBJCODE,3)+EXPR
           ELSE
              IF OBJTYPE=1
                 lcLCC=STR(OBJTYPE,3)+STR(OBJCODE,3)
              ELSE
                 =This.GetLCC(COMMENT,@m.lcLCC,"",.T.)
              ENDIF
           ENDIF

           IF !EMPTY(m.lcLCC)
              lii=ASCAN(m.laSR_C,m.lcLCC)
              IF m.lii=0 && Not found, Insert It

              ELSE
                 * 5,6,7,8,17. VPOS, HPOS, WITDH, HEIGHT
                 * 9 WITDH, HEIGHT
                 * 5 EXPR
                 SCATTER NAME loRam MEMO
                 SELE (m.lcADR)
                 GO (m.laSR_R(m.lii))
                 DO CASE
                    CASE OBJTYPE=1
                         REPLACE EXPR WITH m.loRam.EXPR, TAG WITH m.loRam.TAG,;
                                 TAG2 WITH m.loRam.TAG2,;
                                 VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 FONTFACE WITH m.loRam.FONTFACE,FONTSIZE WITH m.loRam.FONTSIZE,FONTSTYLE WITH m.loRam.FONTSTYLE,;
                                 RULER WITH m.loRam.RULER,RULERLINES WITH m.loRam.RULERLINES,;
                                 GRID WITH m.loRam.GRID,GRIDV WITH m.loRam.GRIDV,GRIDH WITH m.loRam.GRIDH

                    CASE OBJTYPE=9
                         REPLACE PLAIN WITH m.loRam.PLAIN, HEIGHT WITH m.loRam.HEIGHT

                    CASE OBJTYPE=17
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 GENERAL WITH m.loRam.GENERAL, DOUBLE WITH m.loRam.DOUBLE,;
                                 MODE WITH m.loRam.MODE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP
                           
                    CASE OBJTYPE=5
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 HEIGHT WITH m.loRam.HEIGHT,; && WIDTH WITH m.loRam.WIDTH, 
                                 PENRED WITH m.loRam.PENRED,PENGREEN WITH m.loRam.PENGREEN,PENBLUE WITH m.loRam.PENBLUE,;
                                 FILLRED WITH m.loRam.FILLRED,FILLGREEN WITH m.loRam.FILLGREEN,FILLBLUE WITH m.loRam.FILLBLUE,;
                                 FONTFACE WITH m.loRam.FONTFACE,FONTSIZE WITH m.loRam.FONTSIZE,FONTSTYLE WITH m.loRam.FONTSTYLE,;
                                 MODE WITH m.loRam.MODE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP,;
                                 PICTURE WITH m.loRam.PICTURE,;
                                 SPACING WITH m.loRam.SPACING,;
                                 OFFSET WITH m.loRam.OFFSET


                    CASE OBJTYPE=6
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 PENSIZE WITH m.loRam.PENSIZE,PENPAT WITH m.loRam.PENPAT,;
                                 PENRED WITH m.loRam.PENRED,PENGREEN WITH m.loRam.PENGREEN,PENBLUE WITH m.loRam.PENBLUE,;
                                 FILLRED WITH m.loRam.FILLRED,FILLGREEN WITH m.loRam.FILLGREEN,FILLBLUE WITH m.loRam.FILLBLUE,;
                                 MODE WITH m.loRam.MODE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP


                    CASE OBJTYPE=7
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 PENSIZE WITH m.loRam.PENSIZE,PENPAT WITH m.loRam.PENPAT,FILLPAT WITH m.loRam.FILLPAT,;
                                 PENRED WITH m.loRam.PENRED,PENGREEN WITH m.loRam.PENGREEN,PENBLUE WITH m.loRam.PENBLUE,;
                                 FILLRED WITH m.loRam.FILLRED,FILLGREEN WITH m.loRam.FILLGREEN,FILLBLUE WITH m.loRam.FILLBLUE,;
                                 MODE WITH m.loRam.MODE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP,;
                                 OFFSET WITH m.loRam.OFFSET

                    CASE OBJTYPE=8
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 FONTFACE WITH m.loRam.FONTFACE,FONTSIZE WITH m.loRam.FONTSIZE,FONTSTYLE WITH m.loRam.FONTSTYLE,;
                                 PENRED WITH m.loRam.PENRED,PENGREEN WITH m.loRam.PENGREEN,PENBLUE WITH m.loRam.PENBLUE,;
                                 FILLRED WITH m.loRam.FILLRED,FILLGREEN WITH m.loRam.FILLGREEN,FILLBLUE WITH m.loRam.FILLBLUE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 MODE WITH m.loRam.MODE,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP,;
                                 PICTURE WITH m.loRam.PICTURE,;
                                 SPACING WITH m.loRam.SPACING,;
                                 OFFSET WITH m.loRam.OFFSET,;
                                 RULERLINES WITH m.loRam.RULERLINES

                 ENDCASE
                 SELECT (m.lcASR)
              ENDIF
           ENDIF
      ENDSCAN

      USE IN (m.lcASR)
      USE IN (m.lcADR)

      RETURN .T.
   ENDPROC

ENDDEFINE

