*****************************************************************************************************************
* Definice tdy OCX knihovny
DEFINE CLASS _OCXLibrary AS Custom
   Name= "_OCXLibrary"
   DIME aClss(1) && Seznam td je se maj odzkouet
ENDDEFINE


*****************************************************************************************************************
* Definice tdy OCX knihoven
DEFINE CLASS _OCXVersLibraries AS Custom
   Name= "_OCXVersLibraries"

   Active_Library="" && Aktivn knihovna

   * Pid verzi knihovny do seznamu
   PROCEDURE Add(lcLibrary)
      * lcLibrary - Nzev OCX knihovny - verze
      IF TYPE("This."+m.lcLibrary)#"O"
         This.AddObject(m.lcLibrary,"_OCXLibrary") && Vytvo objekt knihovny
      ENDIF
      RETURN EVAL("This."+m.lcLibrary) && Vra objekt knihovny
   ENDPROC

   * Odstran verzi knihovny ze seznamu
   PROCEDURE Remove(lcLibrary)
      * lcLibrary - Nzev OCX knihovny - verze
      IF TYPE("This."+m.lcLibrary)="O"
         This.RemoveObject(m.lcLibrary) && Odstra objekt knihovny
      ENDIF
   ENDPROC

   * Provede otestovn verz knihoven a jejich td
   PROCEDURE Test
      LOCAL lii,liy,loo,llErr
      FOR lii=This.ControlCount TO 1 STEP -1
          FOR liy=1 TO ALEN(This.Controls(lii).aClss)
              * Pokus se vytvoit tdu
              TRY
               loo=CREATEOBJECT(This.Controls(m.lii).aClss(m.liy))
               RELE m.loo
              CATCH
               m.llErr=.T.
              ENDTRY

              IF m.llErr && Pokud dolo k chyb
                 * Pak mus z thle smyky vyskoit ven
                 EXIT
              ENDIF
          NEXT
          IF !m.llErr && Pokud nedolo k chyb
             EXIT
          ENDIF
      NEXT

      * Nastav verzi Aktivn knihovny
      This.Active_Library=IIF(m.lii=0,"",This.Controls(m.lii).Name)
      * Pokud dolo k chyb, pak vra .F. , jinak .T.
      RETURN !m.llErr
   ENDPROC


ENDDEFINE

*****************************************************************************************************************
* Definice tdy testu OCX knihoven
DEFINE CLASS _OCXLibraries AS Custom
   Name= "_OCXLibraries"

   Failed_Library="" && Nzev knihovny, kterou se nepodailo inializovat (jedn se pouze o zkratku)

   * Pid knihovnu do seznamu
   PROCEDURE Add(lcLibrary)
      * lcLibrary - Nzev OCX knihovny
      IF TYPE("This."+m.lcLibrary)#"O"
         This.AddObject(m.lcLibrary,"_OCXVersLibraries") && Vytvo objekt knihovny
      ENDIF
      RETURN EVAL("This."+m.lcLibrary) && Vra objekt knihovny
   ENDPROC

   * Odstran knihovnu ze seznamu
   PROCEDURE Remove(lcLibrary)
      * lcLibrary - Nzev OCX knihovny
      IF TYPE("This."+m.lcLibrary)="O"
         This.RemoveObject(m.lcLibrary) && Odstra objekt knihovny
      ENDIF
   ENDPROC

   * Provede otestovn knihoven
   PROCEDURE Test
      LOCAL lii,llRet
      llRet=.T. && Nastav pznak na OK
      FOR lii=1 TO This.ControlCount
          IF !This.Controls(m.lii).Test()
             This.Failed_Library=This.Controls(m.lii).Name
             llRet=.F. && Nastav na .F.
             EXIT && Ukoni smyku
          ENDIF
      NEXT
      RETURN m.llRet
   ENDPROC

ENDDEFINE
