**************************************************************************
** Nzev programu: RegAPI.PRG
** Verze: 1.0.0
** Datum vytvoen: 2000-01-08
** Popis: Procedury pro prci s Registry
** Autor: Martin Jindra
** E-mail: martin.jindra@egservis.cz
**

#INCLUDE "RegAPI.h"

*******************************************
* Poznmka
*******************************************

* hodnoty se nataj a ukldaj v etzcovm tvaru
* u REG_SZ se mus potat s NULL znakem
* u REG_DWORD se mus potat, e se ukld v binrnm tvaru vyjdenm etzcem
* atd ...

*****************************
* ukzkov procedura
*****************************

* zpis etzcov hodnoty
**************************
*=RegAPIInit()
*LOCAL liHKEY,liOFlag,lcData
*lcData=SPACE(100)
*?API_RegCreateKeyEx(HKEY_CURRENT_USER,"Software\xxx","REG_SZ",@liHKEY,@liOFlag)
*?API_RegSetValueEx(liHKEY,"test",REG_SZ,"ahoj"+CHR(0))
*?API_RegQueryValueEx(liHKEY,"test",REG_SZ,@lcData,100)
*?API_RegCloseKey(liHKEY)

* zpis integeru hodnoty
******************
*=RegAPIInit()
*set proced to kernel
*LOCAL liHKEY,liOFlag,liData
*liData="    "
*?API_RegCreateKeyEx(HKEY_CURRENT_USER,"Software\xxx","REG_SZ",@liHKEY,@liOFlag)
*?API_RegSetValueEx(liHKEY,"test",REG_DWORD,BINTOC(100,"RS"))
*?API_RegQueryValueEx(liHKEY,"test",REG_DWORD,@liData,4)
*?API_RegCloseKey(liHKEY)
*set proced to

* Smazn kle
***********************
*?API_RegDeleteKey(HKEY_CURRENT_USER,"Software\MyApp\Settings")
*?API_RegDeleteKey(HKEY_CURRENT_USER,"Software\MyApp")


***************************************************************************************
* inicializace API funkc
***************************************************************************************

FUNCTION cvp_RegQueryValueEx(lhKey, lpValueName, lpReserved, lpType, lpData, lpcbData)
 DECLARE LONG RegQueryValueEx IN ADVAPI32.DLL  AS cvp_RegQueryValueEx LONG,STRING @,INTEGER ,INTEGER @,STRING @,INTEGER @
  RETURN cvp_RegQueryValueEx(lhKey, @lpValueName, lpReserved, @lpType, @lpData, @lpcbData)
ENDFUNC

FUNCTION cvp_RegSetValueEx( lhKey, lpValueName, lReserved, ldwType, lpData, lcbData)
 DECLARE INTEGER RegSetValueEx IN ADVAPI32.DLL AS cvp_RegSetValueEx LONG,STRING @,INTEGER,INTEGER,STRING @,INTEGER
 RETURN cvp_RegSetValueEx( lhKey, @lpValueName, lReserved, ldwType, @lpData, lcbData)
ENDFUNC

FUNCTION cvp_RegCreateKeyEx(lhKey, lpSubKey, liReserved, lpClass, ldwOptions, lsamDesired, lpSecurityAttributes, lphkResult, lpdwDisposition)
 DECLARE INTEGER RegCreateKeyEx IN ADVAPI32.DLL AS cvp_RegCreateKeyEx LONG,STRING @,INTEGER,STRING @,INTEGER,INTEGER,INTEGER,LONG@, INTEGER @
 RETURN cvp_RegCreateKeyEx(lhKey, @lpSubKey, liReserved, @lpClass, ldwOptions, lsamDesired, lpSecurityAttributes, @lphkResult, @lpdwDisposition)
ENDFUNC

        
FUNCTION cvp_RegOpenKeyEx(lhKey, lpSubKey, lulOptions, lsamDesired, lphkResult) 
 DECLARE INTEGER RegOpenKeyEx in ADVAPI32.DLL AS cvp_RegOpenKeyEx LONG, STRING @,INTEGER,INTEGER,INTEGER @nKeyHandle 
 RETURN cvp_RegOpenKeyEx(lhKey, @lpSubKey, lulOptions, lsamDesired, @lphkResult) 
ENDFUNC


FUNCTION cvp_RegCloseKey(lhkey)
 DECLARE INTEGER RegCloseKey in ADVAPI32.DLL AS cvp_RegCloseKey LONG
 RETURN cvp_RegCloseKey(lhkey)
ENDFUNC


FUNCTION cvp_RegEnumKeyEx(lhKey, ldwIndex, lpName, lpcName, lpReserved, lpClass, lpcClass, lpftLastWriteTime)
 DECLARE INTEGER RegEnumKeyEx IN ADVAPI32.DLL AS cvp_RegEnumKeyEx LONG,INTEGER,STRING @,INTEGER @,INTEGER,STRING @,INTEGER @,INTEGER @
 RETURN cvp_RegEnumKeyEx(lhKey, ldwIndex, @lpName, @lpcName, lpReserved, @lpClass, @lpcClass, @lpftLastWriteTime)
ENDFUNC


FUNCTION cvp_RegDeleteKey( lhKey, lpSubKey)
 DECLARE INTEGER RegDeleteKey IN ADVAPI32.DLL AS cvp_RegDeleteKey LONG, STRING @
 RETURN cvp_RegDeleteKey( lhKey, @lpSubKey)
ENDFUNC


FUNCTION cvp_RegDeleteValue( lhKey, lpSubKey)
 DECLARE INTEGER RegDeleteValue IN ADVAPI32.DLL AS cvp_RegDeleteValue LONG, STRING @
 RETURN cvp_RegDeleteValue( lhKey, @lpSubKey)
ENDFUNC


FUNCTION cvp_RegEnumValue(lhKey, ldwIndex, lpValueName, lpcchValueName, lpReserved, lpType, lpData, lpcbData)
 DECLARE INTEGER RegEnumValue IN ADVAPI32.DLL AS cvp_RegEnumValue LONG,INTEGER,STRING @,INTEGER @,INTEGER,INTEGER @,STRING @,INTEGER @
 RETURN cvp_RegEnumValue(lhKey, ldwIndex, @lpValueName, @lpcchValueName, lpReserved, @lpType, @lpData, @lpcbData)
ENDFUNC


FUNCTION cvp_RegQueryInfoKey( hKey, lpClass, lpcClass, lpReserved, lpcSubKeys, lpcMaxSubKeyLen, lpcMaxClassLen, lpcValues, lpcMaxValueNameLen, lpcMaxValueLen, lpcbSecurityDescriptor, lpftLastWriteTime)
 DECLARE INTEGER RegQueryInfoKey IN ADVAPI32.DLL AS cvp_RegQueryInfoKey  LONG, STRING @, INTEGER @, INTEGER, INTEGER @, INTEGER @, INTEGER @, INTEGER @, INTEGER @, INTEGER @, INTEGER @, STRING @
 RETURN cvp_RegQueryInfoKey( hKey, @lpClass, @lpcClass, lpReserved, @lpcSubKeys, @lpcMaxSubKeyLen, @lpcMaxClassLen, @lpcValues, @lpcMaxValueNameLen, @lpcMaxValueLen, @lpcbSecurityDescriptor, @lpftLastWriteTime)   
ENDFUNC


***************************************************************************************
* Oteve dan kl
***************************************************************************************
PROCEDURE API_RegOpenKeyEx(liHRoot,lcKey,liHKEY)
* liHRoot - ID rootu kle nap: HKEY_CURRENT_USER
* lcKey   - Nzev kle (cel cesty) nap: "Software\XXXXX"
*@liHKEY  - Sem se vrt handle kle
LOCAL liErr
liErr=cvp_RegOpenKeyEx(m.liHRoot,@m.lcKey,0,SECURITY_ACCESS_MASK,@m.liHKEY)
RETURN IIF(m.liErr=ERROR_SUCCESS,REGAPI_SUCCESS,REGAPI_Other)

***************************************************************************************
* Vytvo dan kl
***************************************************************************************
PROCEDURE API_RegCreateKeyEx(liHRoot,lcKey,lcType,liHKEY,liOpenFlag)
* liHRoot    - ID rootu kle nap: HKEY_CURRENT_USER
* lcKey      - Nzev kle (cel cesty) nap: "Software\XXXXX"
* lcType     - Typ ukldanho objektu
*@liHKEY     - Sem se vrt handle kle
*@liOpenFlag - Sem vrt zda kl zaloil, mebo otevel

LOCAL liErr
liErr=cvp_RegCreateKeyEx(m.liHRoot,@m.lcKey,0,@m.lcType,0,SECURITY_ACCESS_MASK,0,@m.liHKEY,@m.liOpenFlag)
RETURN IIF(m.liErr=ERROR_SUCCESS,REGAPI_SUCCESS,REGAPI_Other)


***************************************************************************************
* uzave kl
***************************************************************************************
PROCEDURE API_RegCloseKey(liHKEY)
* liHKEY - Handle kle
LOCAL liErr
liErr=cvp_RegCloseKey(m.liHKEY)
RETURN IIF(m.liErr=ERROR_SUCCESS,REGAPI_SUCCESS,REGAPI_Other)


***************************************************************************************
* Zape hodnotu do kle
***************************************************************************************
PROCEDURE API_RegSetValueEx(liHKEY,lcValue,liType,lcData)
* liHKEY  - Handle kle
* lcValue - Nzev hodnoty
* liType  - Typ hodnoty
* lcData  - Data hodnoty

LOCAL liErr,liReserved,liData
liReserved=0
liData=LEN(m.lcData)

liErr=cvp_RegSetValueEx(m.liHKEY,@m.lcValue,m.liReserved,m.liType,@m.lcData,m.liData)
RETURN IIF(m.liErr=ERROR_SUCCESS,REGAPI_SUCCESS,REGAPI_Other)

***************************************************************************************
* Nate hodnotu z kle
***************************************************************************************
PROCEDURE API_RegQueryValueEx(liHKEY,lcValue,liType,lcData,liData)
* liHKEY  - Handle kle
* lcValue - Nzev hodnoty
* liType  - Typ hodnoty
*@lcData  - Sem se nacpou data hodnoty
* liData  - Velikost bufferu na data

LOCAL liErr,liReserved
liReserved=0
liErr=cvp_RegQueryValueEx(m.liHKEY,@m.lcValue,m.liReserved,@m.liType,@m.lcData,@m.liData)
lcData=LEFT(m.lcData,m.liData) && oe data
RETURN IIF(m.liErr=ERROR_SUCCESS,REGAPI_SUCCESS,REGAPI_Other)

***************************************************************************************
* Smae kl
***************************************************************************************
PROCEDURE API_RegDeleteKey(liHKEY,lcKey)
* liHKEY - Handle kle
* lcKey  - Nzev subkle nap: "XXXXX"
LOCAL liErr
liErr=cvp_RegDeleteKey(m.liHKEY,@m.lcKey)
RETURN IIF(m.liErr=ERROR_SUCCESS,REGAPI_SUCCESS,REGAPI_Other)

***************************************************************************************
* Smae hodnotu
***************************************************************************************
PROCEDURE API_RegDeleteValue(liHKEY,lcValue)
* liHKEY  - Handle kle
* lcValue - Nzev hodnoty (cel cesty) nap: "Software\XXXXX\hdonota1"
LOCAL liErr
liErr=cvp_RegDeleteValue(m.liHKEY,@m.lcValue)
RETURN IIF(m.liErr=ERROR_SUCCESS,REGAPI_SUCCESS,REGAPI_Other)


***************************************************************************************
* Vrt kl v poad v otevenm nebo standardnm kli
***************************************************************************************
PROCEDURE API_RegEnumKeyEx(liHKEY,liIndex,lcKey,lcClass,liTime)
* liHKEY  - Handle kle
* liIndex - Poadov index kle
*@lcKey   - Sem se vrt nzev kle
* lcClass - Omezen na tdu kle
*@liTime  - as zpisu ??

LOCAL liErr,liKey,liClass

lcClass=ALLT(m.lcClass)+CHR(0)
liClass=LEN(m.lcClass)
liKey=LEN(m.lcKey)

liErr=cvp_RegEnumKeyEx(m.liHKEY,m.liIndex,@m.lcKey,@m.liKey,0,@m.lcClass,@m.liClass,@m.liTime)
RETURN m.liErr


***************************************************************************************
* Vrt hodnoty v poad v otevenm nebo standardnm kli
***************************************************************************************
PROCEDURE API_RegEnumValue(liHKEY,liIndex,lcValue,liType,lcData)
* liHKEY  - Handle kle
* liIndex - Poadov index hodnoty
*@lcValue - Sem se vrt nzev kle
*@liType  - Typ natan hodnoty
*@lcData  - Data hodnoty

LOCAL liErr,liValue,liData

liValue=LEN(m.lcValue)
* nechce vrtit data
IF PCOUNT()<5 && pokud nechce vrtit obsah hodnoty
   IF PCOUNT()<4 && pokud nechce vrtit typ hodnoty
      liErr=cvp_RegEnumValue(m.liHKEY,m.liIndex,@m.lcValue,@m.liValue,0,0,0,0)
   ELSE
      liErr=cvp_RegEnumValue(m.liHKEY,m.liIndex,@m.lcValue,@m.liValue,0,@m.liType,0,0)
   ENDIF
   lcValue=LEFT(m.lcValue,m.liValue) && oe nzev hodnoty
ELSE
   liData=LEN(m.lcData)
   liErr=cvp_RegEnumValue(m.liHKEY,m.liIndex,@m.lcValue,@m.liValue,0,@m.liType,@m.lcData,@m.liData)
   lcData=LEFT(m.lcData,m.liData) && oe data
ENDIF
RETURN m.liErr


***************************************************************************************
PROCEDURE API_RegQueryInfoKey(liHKEY,lcClass,liSubKeys,liMaxSubKeyLen,liMaxClassLen,;
 liValues,liMaxValueNameLen,liMaxValueLen,liSecurityDescriptor,lcDT)
* liHKEY               - Handle kle
* lcClass              - class buffer
* liSubKeys            - number of subkeys
* liMaxSubKeyLen       - longest subkey name
* liMaxClassLen        - longest class string
* liValues             -  number of value entries
* liMaxValueNameLen    - longest value name
* liMaxValueLen        - longest value data
* liSecurityDescriptor - descriptor length
* lcDT                 - last write time

LOCAL liErr,liClass,liReserved

liClass=LEN(m.lcClass)
liReserved=0
lcDT=REPL(CHR(0),16)

liErr=cvp_RegQueryInfoKey(m.liHKEY,@m.lcClass,@m.liClass,m.liReserved,@m.liSubKeys,@m.liMaxSubKeyLen,;
      @m.liMaxClassLen,@m.liValues,@m.liMaxValueNameLen,@m.liMaxValueLen,@m.liSecurityDescriptor,@m.lcDT)
RETURN IIF(m.liErr=ERROR_SUCCESS,REGAPI_SUCCESS,REGAPI_Other)

ENDPROC
