# INCLUDE "VFPRes.h"
* tda pro prci s lokalizovanmi zdroji VFP

EXTERNAL PROCEDURE FILLOBJECT
EXTERNAL PROCEDURE RETURNERRSTRING

DEFINE CLASS _VFPResources AS Custom

   PROTECTED ARRAY ahRes(255) && matice volnch handl

   DIME aResource(1,3) && matice zdroj (1) - Nzev knihovny, (2) - ID , (3) - doplkov objekt
   iResource=0 && ta matice

   NoString="Neznm ltajc string (UFS) %StringID%"
   NoPad="Neznm ltajc pad (UFP) %PadID%,%PropID%"
   NoBar="Neznm ltajc bar (UFB) %BarID%,%PropID%"

   PROTECTED CurrLocIndex
   CurrLocIndex=0

   PROCEDURE LoadLibrary(lcLibrary,lcErrMsg)

      * lcLibrary - Umstn a nzev lokalizovan knihovny
      *@lcErrMsg  - Sem se ulo chybov hlky
      LOCAL lcExact,lii,lcPom
      IF This.iResource=ALEN(This.ahRes) && pokud ji je naplnn stav
         RETURN Res_LoadLibrary_Full && pak vra 0
      ENDIF

      IF !FILE(m.lcLibrary) && pokud aplikace neexistuje
         RETURN Res_LoadLibrary_NotFile && pak vra -1
      ENDIF

      lcExact=SET("EXACT") && pvodn nastaven SET EXACT
      SET EXACT ON && nastav ON an pln porovnn
      lii=ASCAN(This.aResource,m.lcLibrary) && najdi knihovnu
      SET EXACT &lcExact.
      IF m.lii>0 && pokud tam ji je 
         lii=ASUBS(This.aResource,m.lii,1) && pekonvertuj to na dek
         RETURN This.aResource(m.lii,2) && a vra ID knihovny
      ENDIF     

      This.iResource=This.iResource+1 && inkrementuj ta
      DIME This.aResource(This.iResource,3) && pedimenzuj matici
      
      This.aResource(This.iResource,1)=m.lcLibrary && nzev knihovny
      This.aResource(This.iResource,2)=ASCAN(This.ahRes,.F.) && najdi voln handle
      This.aResource(This.iResource,3)=CREATEOBJECT("_VFPResourceLibrary",m.lcLibrary) && vytvo popisn objekt
      
      * tady se zavol procedura v knihovn, kter vypln popisn objekt
      DO FillObject IN (m.lcLibrary) WITH This.aResource(This.iResource,3)

      * tady se zavol metoda, kter zavede jednotliv zdroje
      lii=This.aResource(This.iResource,3).LoadResource()
      IF m.lii#0 && dolo k chyb
         * pak sestav hlen

         IF PCOUNT()=2 && pokud je to vydno
            lcErrMsg=""
            IF BITTEST(m.liErr,Res_Type_Menu_b)
               DO ReturnErrString IN (m.lcLibrary) WITH Res_Type_Menu,lcPom
               lcErrMsg=m.lcErrMsg+m.lcPom+CHR(13)+CHR(10)
            ENDIF
  
            IF BITTEST(m.liErr,Res_Type_String_b)
               DO ReturnErrString IN (m.lcLibrary) WITH Res_Type_String,lcPom
               lcErrMsg=m.lcErrMsg+m.lcPom+CHR(13)+CHR(10)
            ENDIF

            IF BITTEST(m.liErr,Res_Type_Dlg_b)
               DO ReturnErrString IN (m.lcLibrary) WITH Res_Type_Dlg,lcPom
               lcErrMsg=m.lcErrMsg+m.lcPom+CHR(13)+CHR(10)
            ENDIF
         ENDIF

         RETURN Res_LoadLibrary_Failed
      ENDIF
      RETURN This.aResource(This.iResource,2)
   ENDPROC


   * provede uvolnn lokalizovanch zdroj
   PROCEDURE FreeLibrary(liID)
      * liID - ID lokalizovan knihovny
      LOCAL lii,loVFPRes
      IF This.iResource=0 && pokud tam nic nen, 
         RETURN && pak vypadni
      ENDIF
      lii=ASCAN(This.aResource,m.liID) && najdi knihovnu
      IF m.lii>0 && pokud tam je
         lii=ASUBS(This.aResource,m.lii,1) && pekonvertuj to na dek
         This.ahRes(This.aResource(m.lii,2))=.F. && uvolni handle
         loVFPRes=This.aResource(m.lii,3) && zapamatuje si popisn objekt
         =ADEL(This.aResource,m.lii) && sma dek
         This.iResource=This.iResource-1
         IF This.iResource>0 && pokud je to nen 0
            DIME This.aResource(This.iResource,3) && pedimenzuj matici
         ENDIF
         * nyn se provede vlastn uvolnn
         loVFPRes.FreeResource()
      ENDIF
   ENDPROC

   * Nate informaci o padu
   PROCEDURE ReadPad(liID,liPadID,liPropID)
     * liID     - ID knihovny
     * liPadID  - ID padu
     * liPropID - ID vlastnosti

     LOCAL liRow
     liRow=ASCAN(This.aResource,m.liID) && nejdve lokalizuj knihovnu
     RETURN IIF(m.liRow=0,"",;
            IIF(SEEK(BINTOC(Res_Type_Menu_Pad)+BINTOC(m.liPadID)+BINTOC(m.liPropID),This.aResource(m.liRow+1).MenuTableAlias),;
            STRTRAN(STRTRAN(EVAL(This.aResource(m.liRow+1).MenuTableAlias+".XX006"),"CRLF",CHR(13)+CHR(10)),"TAB",CHR(9)),;
            STRTRAN(STRTRAN(This.NoPad,"%PadID%",LTRIM(STR(m.liPadID,11))),"%PropID%",LTRIM(STR(m.liPropID,11)))))
   ENDPROC

   PROCEDURE ReadPadEx
     LPARAMETERS m.liPadID, m.liPropID
     
     * liPadID  - ID padu
     * liPropID - ID vlastnosti
     RETURN IIF(This.CurrLocIndex=0,"",;
            IIF(SEEK(BINTOC(Res_Type_Menu_Pad)+BINTOC(m.liPadID)+BINTOC(m.liPropID),This.aResource(This.CurrLocIndex+1).MenuTableAlias),;
            STRTRAN(STRTRAN(EVAL(This.aResource(This.CurrLocIndex+1).MenuTableAlias+".XX006"),"CRLF",CHR(13)+CHR(10)),"TAB",CHR(9)),;
            STRTRAN(STRTRAN(This.NoPad,"%PadID%",LTRIM(STR(m.liPadID,11))),"%PropID%",LTRIM(STR(m.liPropID,11)))))
   ENDPROC


   * Nate informaci o baru
   PROCEDURE ReadBar(liID,liBarID,liPropID)
     * liID     - ID knihovny
     * liBarID  - ID baru
     * liPropID - ID vlastnosti
     LOCAL liRow
     liRow=ASCAN(This.aResource,m.liID) && nejdve lokalizuj knihovnu
     RETURN IIF(m.liRow=0,"",;
            IIF(SEEK(BINTOC(Res_Type_Menu_Bar)+BINTOC(m.liBarID)+BINTOC(m.liPropID),This.aResource(m.liRow+1).MenuTableAlias),;
            STRTRAN(STRTRAN(EVAL(This.aResource(m.liRow+1).MenuTableAlias+".XX006"),"CRLF",CHR(13)+CHR(10)),"TAB",CHR(9)),;
            STRTRAN(STRTRAN(This.NoBar,"%BarID%",LTRIM(STR(m.liBarID,11))),"%PropID%",LTRIM(STR(m.liPropID,11)))))
   ENDPROC

   PROCEDURE ReadBarEx
     LPARAMETERS m.liBarID, m.liPropID
     
     * liBarID  - ID baru
     * liPropID - ID vlastnosti
     RETURN IIF(This.CurrLocIndex=0,"",;
            IIF(SEEK(BINTOC(Res_Type_Menu_Bar)+BINTOC(m.liBarID)+BINTOC(m.liPropID),This.aResource(This.CurrLocIndex+1).MenuTableAlias),;
            STRTRAN(STRTRAN(EVAL(This.aResource(This.CurrLocIndex+1).MenuTableAlias+".XX006"),"CRLF",CHR(13)+CHR(10)),"TAB",CHR(9)),;
            STRTRAN(STRTRAN(This.NoBar,"%BarID%",LTRIM(STR(m.liBarID,11))),"%PropID%",LTRIM(STR(m.liPropID,11)))))
   ENDPROC


   * Nate string
   PROCEDURE ReadString(liID,liStringID)
     * liID       - ID knihovny
     * liStringID - ID Stringu
     
     LOCAL liRow
     liRow=ASCAN(This.aResource,m.liID) && nejdve lokalizuj knihovnu

     RETURN IIF(m.liRow=0,"",;
            IIF(SEEK(BINTOC(m.liStringID),This.aResource(m.liRow+1).StringTableAlias),;
            STRTRAN(STRTRAN(EVAL(This.aResource(m.liRow+1).StringTableAlias+".XX006"),"CRLF",CHR(13)+CHR(10)),"TAB",CHR(9)),;
            STRTRAN(This.NoString,"%StringID%",LTRIM(STR(m.liStringID,11)))))
   ENDPROC

   PROCEDURE ReadStringEx
     LPARAMETERS m.liStringID
     
     * liStringID - ID Stringu
     RETURN IIF(This.CurrLocIndex=0, "",;
            IIF(SEEK(BINTOC(m.liStringID), This.aResource(This.CurrLocIndex+1).StringTableAlias),;
            STRTRAN(STRTRAN(EVAL(This.aResource(This.CurrLocIndex+1).StringTableAlias+".XX006"), "CRLF", CHR(13)+CHR(10)), "TAB",CHR(9)),;
            STRTRAN(This.NoString, "%StringID%", LTRIM(STR(m.liStringID, 11)))))
   ENDPROC

   * Vrt objekt s definici zdroj
   PROCEDURE GetResource
      LPARAMETERS m.liID
      * liID - ID knihovny
      
      LOCAL m.liRow
      m.liRow=ASCAN(This.aResource,m.liID) && nejdve lokalizuj knihovnu
      RETURN IIF(m.liRow=0,.NULL.,This.aResource(m.liRow+1))
   ENDPROC


   PROCEDURE SetResource
      LPARAMETERS m.liID
      This.CurrLocIndex=ASCAN(This.aResource, m.liID)
   ENDPROC

ENDDEFINE


* tda uchovvajc informace o knihovn lokalizovanch zdroj
DEFINE CLASS _VFPResourceLibrary AS Custom

   Library="" && nzev knihovny
   StringTable="" && nzev tabulky string
   MenuTable="" && nzev tabulky menu
   DialogVCX="" && nzev knihovny VCX

   FontCharset=1

   StringTableAlias="" && alias pro lokalizan tabulku string
   MenuTableAlias="" && alias pro lokalizan tabulku menu
   DialogVCXAlias="" && alias pro VCX knihovnu

   PROCEDURE Init(lcLibrary)
      This.Library=m.lcLibrary
      This.StringTableAlias=SYS(2015) && alias pro lokalizan tabulku string
      This.MenuTableAlias=SYS(2015) && alias pro lokalizan tabulku menu
   ENDPROC

   PROCEDURE Destroy
      This.FreeResource() && uvolni zdroje
   ENDPROC

   * vlastn metoda pro uvolnn zdroj
   PROCEDURE FreeResource()
      EXTERNAL PROCEDURE OpenTable
      * pokud je vyplnna tabulka string
      IF !EMPTY(This.StringTable) AND USED(This.StringTableAlias)
         USE IN (This.StringTableAlias) && uzavi ji
      ENDIF

      * pokud je vyplnna tabulka menu
      IF !EMPTY(This.MenuTable) AND USED(This.MenuTableAlias)
         USE IN (This.MenuTableAlias) && uzavi ji
      ENDIF

      * pokud je vyplnna VCX knihovna
      IF !EMPTY(This.DialogVCX) AND " "+UPPER(This.DialogVCXAlias) $ SET('CLASSLIB')
         * uvoln knihovnu
         DO OpenTable IN (This.Library) WITH "CLEAR CLASSLIB "+This.DialogVCX

*         CLEAR CLASSLIB (This.DialogVCX)
         RELEASE CLASSLIB ALIAS (This.DialogVCXAlias) IN (This.Library)
      ENDIF
   ENDPROC

   * vlastn metoda pro zavedn zdroj
   PROCEDURE LoadResource()
      EXTERNAL PROCEDURE OpenTable
      LOCAL llErr,lcLibrary,lii,liErr
      lcLibrary=This.Library && nzev knihovny

      liErr=0 && resetuj chyby
      * pokud je vyplnna tabulka string
      IF !EMPTY(This.StringTable)
         TRY
          DO OpenTable IN (m.lcLibrary) WITH "USE "+This.StringTable+" IN 0 ALIAS "+This.StringTableAlias+" SHARE AGAIN NOUPDATE"
         CATCH 
          m.llErr=.T.
         ENDTRY 
         IF !m.llErr
            llErr=!USED(This.StringTableAlias)
         ENDIF
         IF !m.llErr
            TRY
             SET ORDER TO "XXI000" IN (This.StringTableAlias)
            CATCH
            ENDTRY
         ENDIF
         IF m.llErr
            liErr=m.liErr+Res_Type_String
         ENDIF
      ENDIF

      * pokud je vyplnna tabulka menu
      IF !EMPTY(This.MenuTable)
         TRY
          DO OpenTable IN (m.lcLibrary) WITH "USE "+This.MenuTable+" IN 0 ALIAS "+This.MenuTableAlias+" SHARE AGAIN NOUPDATE"
         CATCH 
          m.llErr=.T.
         ENDTRY 
         IF !m.llErr
            llErr=!USED(This.MenuTableAlias)
         ENDIF
         IF !m.llErr
            TRY
             SET ORDER TO "XXI000" IN (This.MenuTableAlias)
            CATCH
              m.llErr=.T.
            ENDTRY
         ENDIF
         IF m.llErr
            liErr=m.liErr+Res_Type_Menu
         ENDIF
      ENDIF

      * pokud je vyplnna VCX knihovna
      IF !EMPTY(This.DialogVCX)
         lii=AT(".",This.DialogVCX)
         This.DialogVCXAlias=IIF(m.lii=0,This.DialogVCX,LEFT(This.DialogVCX,m.lii-1))
         TRY
          SET CLASSLIB TO (This.DialogVCX) IN (m.lcLibrary) ALIAS (This.DialogVCXAlias) ADDITIVE 
         CATCH
          liErr=m.liErr+IRes_Type_Dlg
         ENDTRY 
      ENDIF

      RETURN m.liErr && vra chybov kd
   ENDPROC

ENDDEFINE
