#INCLUDE "Main.h"

*************************************************************
* Procedura, kter vrt objekt pro pakovn a rozpakovn
PROCEDURE CVP_GetInterface
LPARAMETERS m.loObj
*@loObj - Promnn do kter se zape odkaz na objekt pro pakovn
m.loObj=CREATEOBJECT("_ZLib_Archiver")


*************************************************************
* vlastn tda pro pakovn a rozpakovn
DEFINE CLASS _ZLib_Archiver AS Custom
   Name="_ZLib_Archiver"
  
   * Dekompresn metoda
   PROCEDURE Decompress
      LPARAMETERS m.loPack
      * loPack - Objekt pro rozpakovn

      IF !LoadDllFunc("DECLARE INTEGER uncompress IN "+["]+loPack.PU.D_File+["]+" STRING @, INTEGER @, STRING @, INTEGER") && inicializuj doplkov API funkce
         RETURN _PP_ProcessFailed
      ENDIF

      LOCAL m.lcDest, m.lnDestLen, m.lnSourceLen, m.lcSource, m.liRet
      m.liRet=_PP_PAUNFailed
      m.XX_System.SetCatch(.T.)
      m.lcSource    =FILETOSTR(m.loPack.File_S)
      IF m.XX_System.nERR=0
         m.lnSourceLen = LEN(m.lcSource)
         m.lnDestLen   = m.loPack.File.Size
         m.lcDest      = SPACE(m.lnDestLen) && velikost rozpakovanho souboru

         IF m.XX_System.nERR=0 AND uncompress(@m.lcDest, @m.lnDestLen, @m.lcSource, m.lnSourceLen)=0
            m.lcDest = LEFT(m.lcDest, m.lnDestLen)  && musi se zkratit na potrebnou delku !!!
            m.liRet=IIF(STRTOFILE(m.lcDest, m.loPack.File_D)>0, _PP_ErrOK, _PP_PAUNFailed)
         ELSE
         ENDIF
      ENDIF
      m.XX_System.SetCatch(.NULL.)
      RETURN m.liRet
   ENDPROC

   * Kompresn metoda
   PROCEDURE Compress
      LPARAMETERS m.loPack
      * loPack - Objekt pro rozpakovn

      IF !LoadDllFunc("DECLARE INTEGER compress IN "+["]+m.loPack.PU.C_File+["]+" STRING @, INTEGER @, STRING @, INTEGER") && inicializuj doplkov API funkce
         RETURN _PP_ProcessFailed
      ENDIF

      LOCAL m.lcDest, m.lnDestLen, m.lnSourceLen, m.lcSource, m.liRet
      m.XX_System.SetCatch(.T.)
      m.liRet=_PP_PAUNFailed
      m.lcSource=FILETOSTR(m.loPack.File_S)
      IF m.XX_System.nERR=0
         m.lnSourceLen = LEN(m.lcSource)
         m.lnDestLen   = INT(m.lnSourceLen*1.001+12) && presne takhle velky buffer
         m.lcDest      = SPACE(m.lnDestLen)

         IF m.XX_System.nERR=0 AND compress(@m.lcDest, @m.lnDestLen, @m.lcSource, m.lnSourceLen)=0
            m.lcDest = LEFT(m.lcDest, m.lnDestLen)  && musi se zkratit na potrebnou delku !!!
            m.liRet=IIF(STRTOFILE(m.lcDest, m.loPack.File_D)>0, _PP_ErrOK, _PP_PAUNFailed)
         ELSE
         ENDIF
      ENDIF
      m.XX_System.SetCatch(.NULL.)
      RETURN m.liRet
   ENDPROC
ENDDEFIN