#INCLUDE "efrx.h"

#DEFINE cnLOG_PIXELS_Y 90

#DEFINE cnWORD          1
#DEFINE cnHTML          2
#DEFINE cnRTF           3
#DEFINE cnEXCEL         4
#DEFINE cnXML           5
#DEFINE cnPREVIEW       6
#DEFINE cnPDF           8
#DEFINE cnBMP           9

#DEFINE cnOUTPUT_SCREEN 1 && Specifies that output file will be displayed after creation 
#DEFINE cnOUTPUT_PRINT  2 && Specifies that output file will be printed after creation 
#DEFINE cnOUTPUT_EMAIL  3 && Specifies that output file will be e-mailed after creation 
#DEFINE cnOUTPUT_FILE   4 && Specifies no action after output file creation  


***************************************************************************************************************************
*-- IMAGE's output file formats
***************************************************************************************************************************
#DEFINE cnIMAGE_OUTPUT_FILE_FORMAT_BMP          1
#DEFINE cnIMAGE_OUTPUT_FILE_FORMAT_JPG            2
#DEFINE cnIMAGE_OUTPUT_FILE_FORMAT_GIF            3
#DEFINE cnIMAGE_OUTPUT_FILE_FORMAT_TIF            4
#DEFINE cnIMAGE_OUTPUT_FILE_FORMAT_PNG            5



#DEFINE cnOK                                    0       && Everything is OK.
#DEFINE cnNO_PARAMETERS                         1       && No parameter
#DEFINE cnREP_FILE_NOT_FOUND                    2       && Report file not found
#DEFINE cnNO_BANDS_DEFINED                      3       && No bands defined in FRX file (corrupted?)
#DEFINE cnNO_OPEN_TABLE                         4       && No open table and no dataenviroment cursors in FRX file
#DEFINE cnEOF                                   5       && Main alias at EOF() and no dataenvironment cursors
#DEFINE cnNO_HEADER_RECORD                      7       && No header record in FRX file (corrupted?)
#DEFINE cnNO_ANY_OBJECTS                        8       && No labels, fields, or images.
#DEFINE cnERR_CREATING_FILE                     9           && Error creating fle
#DEFINE cnUSER_INTERRUPTED                     10      && User interrupted
#DEFINE cnINVALID_BANDTYPE_PARAMETER           11
#DEFINE cnINVALID_ARRAY_REPORT_OBJ_PARAMETER   12
#DEFINE cnINVALID_NUMBER_OF_PARAMETER          13
#DEFINE cnINVALID_TYPE_OF_PARAMETER            14
#DEFINE cnINVALID_SPECIFIED_OBJECT_TYPE        15
#DEFINE cnWRONG_EXPORT_FILE_TYPE               16
#DEFINE cnDE_INIT_RETURN_FALSE                 17        && DE Init metod return false

#DEFINE cnSCOPE_CLAUSE_ALL      1
#DEFINE cnSCOPE_CLAUSE_NEXT     2
#DEFINE cnSCOPE_CLAUSE_RECORD   3
#DEFINE cnSCOPE_CLAUSE_REST     4

#DEFINE cnPREVIEW_WINDOW_TOOLBAR_NOTDOCKED -1 && Specifies that toolbar will be not docked 
#DEFINE cnPREVIEW_WINDOW_TOOLBAR_TOP        0 && Specifies that toolbar will be docked to Top side 
#DEFINE cnPREVIEW_WINDOW_TOOLBAR_LEFT       1 && Specifies that toolbar will be docked to Left side 
#DEFINE cnPREVIEW_WINDOW_TOOLBAR_RIGHT      2 && Specifies that toolbar will be docked to Right side 
#DEFINE cnPREVIEW_WINDOW_TOOLBAR_BOTTOM     3 && Specifies that toolbar will be docked to Bottom side 

#DEFINE cnPREVIEW_WINDOW_STATE_NORMAL 0 && Specifies if FRX2Any's Report Preview window is Normal   
#DEFINE cnPREVIEW_WINDOW_STATE_MIN    1 && Specifies if FRX2Any's Report Preview window is Minimized 
#DEFINE cnPREVIEW_WINDOW_STATE_MAX    2 && Specifies if FRX2Any's Report Preview window is Maximized 


PROCEDURE EFRX_GetInterface(loHost) && Vrati objekt Interface
* @loHost - (Out) - vrati objekt Interface
LOCAL lcPath,lcProg
loHost=CREATEOBJECT("_FRX2ANY")
* Nastav cestu k interface
lcProg=PROGRAM()
lcPath=SYS(16)
lcPath=SUBST(m.lcPath,AT(m.lcProg,m.lcPath)+LEN(m.lcProg)+1)
loHost.Path=IIF(RAT("\",m.lcPath)>0,LEFT(m.lcPath,RAT("\",m.lcPath)),m.lcPath)
RETURN

****************************************************************
* Definice tridy rozhrani pro XFRX
****************************************************************
DEFINE CLASS _FRX2ANY AS __CFRX
   Name="_FRX2ANY"
   
   Engine="FRX2ANY" && Kod rozhrani
   PreviewAllowed=.T. && Priznak, zda utilita umoznuje vlastni Preview
   NativeProgress=.T. && Priznak, zda utilita ma vlastni teplomer
   ChangeProgressAllowed=.F. && Priznak, zda se misto vlastniho teplomeru DA volat vlastni udalost
   EmailAllowed=.T. && Priznak, zda utilita umoznuje odeslani E-mailem

   PpIY=96
   
   oFSetting=.NULL.

   EMAIL.CCAllowed=.T. && Carbon copy allowed
   EMAIL.MAPIAllowed=.T. && MAPI allowed

   PROCEDURE Init
      This.Caption="FRX2Any"

      DECLARE INTEGER GetDC           IN WIN32API INTEGER iHDC
      DECLARE INTEGER ReleaseDC       IN WIN32API INTEGER ihwnd,INTEGER iHDC
      DECLARE INTEGER GetDeviceCaps   IN WIN32API INTEGER iHDC, INTEGER iIndex

      LOCAL lihwnd,liHDC
      lihwnd = GetActiveWindow() && Get handle active window
      liHDC  = GetDC(m.lihwnd) && Get DC okna
      This.PpIY=GetDeviceCaps(m.liHDC, cnLOG_PIXELS_Y)
      =ReleaseDC(m.lihwnd,m.liHDC) && Release handle

   ENDPROC

   PROCEDURE TestHost() &&  Otestuje, zda je mozno vytvorit engine
      RETURN LEN(SYS(2000,This.EPath+"frx2any.app"))>0
   ENDPROC

   PROCEDURE CreateHost(lcID,loReport) && Vytvori hostitelsky objekt exportni utility
      * lcID     - ID vystupu rozhrani
      * loReport - Objekt informaci o reportu

      LOCAL loHost,llErr,lcClassName,liFileType
      DO CASE
         CASE m.lcID=="PDF"
              lcClassName="PDFFile"
              liFileType=cnPDF

         CASE m.lcID=="DOC"
              lcClassName="WORDFile"
              liFileType=cnWORD

         CASE m.lcID=="HTML" OR lcID=="MHT"
              lcClassName="HTMLFile"
              liFileType=cnHTML

         CASE m.lcID=="RTF"
              lcClassName="WORDFile"
              liFileType=cnRTF

         CASE m.lcID=="XLS"
              lcClassName="EXCELFile"
              liFileType=cnEXCEL

         CASE m.lcID=="XML"
              lcClassName="XMLFile"
              liFileType=cnXML

         CASE m.lcID=="PRV"
              lcClassName="PreviewFile"
              liFileType=cnPreview

         CASE INLIST(m.lcID,"BMP", "JPG", "TIFF", "GIF","PNG")
              lcClassName="IMAGEFile"
              liFileType=cnPreview



      ENDCASE
      This.ResetError()
      loHost = NEWOBJECT(m.lcClassName, This.EPath+"Frx2Any.vcx", This.EPath+"Frx2Any.app")
      IF This.nError>0
         This.ResetError()
         IF !UPPER("frx2any.vcx")$UPPER(SET("CLASSLIB"))
            * Pokus se nalinkovat VCX knihovnu
            SET CLASSLIB TO FRX2Any IN (This.EPath+"Frx2Any.app") ALIAS FRX2Any ADDITIVE
            IF This.nError=0
               This.ResetError()
               loHost = CREATEOBJECT("frx2any."+m.lcClassName)
            ENDIF
         ENDIF
      ENDIF

      llErr=This.nError>0
      IF !m.llErr
         This.oHost=m.loHost
      ENDIF
      This.ResetError()
      RETURN !m.llErr
   ENDPROC

   PROCEDURE ReleaseHost() && Uvolni hostitelsky objekt exportni utility
      DODEFAULT() && Volani puvodni metody
      LOCAL lcLib
      lcLib=UPPER("frx2any.vcx")
      IF m.lcLib$UPPER(SET("CLASSLIB"))
         RELEASE CLASSLIB (m.lcLib) IN (This.EPath+"Frx2Any.app") ALIAS FRX2Any
      ENDIF
   ENDPROC


   PROCEDURE SetHost(loHost,loReport,lcID) && Nastavi volby hostitele
      * loHost   - Objekt hostitele
      * loReport - Objekt informaci o reportu
      * lcID     - Druh vystupu

      LOCAL lcPom,lii,liNRec
      lcPom=UPPER(ALLT(m.loReport.cScope))
      lii=AT(" ",m.lcPom)
      liNRec=0
      IF m.lii>0
         * NEXT/ RECORD
         liNRec=VAL(LTRIM(SUBST(m.lcPom,m.lii+1)))
         lcPom=LEFT(m.lcPom,m.lii-1)
      ENDIF

      DO CASE
         CASE m.lcPom=="NEXT"
              loHost.nScopeClauseType = cnSCOPE_CLAUSE_NEXT
              loHost.nScopeRecords = IIF(m.liNRec>0,m.liNRec,m.loReport.nInitialRecord)

         CASE m.lcPom=="RECORD"
              loHost.nScopeClauseType = cnSCOPE_CLAUSE_RECORD
              loHost.nScopeRecordNumber = IIF(m.liNRec>0,m.liNRec,m.loReport.nInitialRecord)

         CASE m.lcPom=="ALL"
              loHost.nScopeClauseType = cnSCOPE_CLAUSE_ALL

         CASE m.lcPom=="REST"
              loHost.nScopeClauseType = cnSCOPE_CLAUSE_REST

      ENDCASE

      IF !EMPTY(m.loReport.cFor)
         loHost.cFORExpression = ALLTRIM(m.loReport.cFor)
      ENDIF

      IF !EMPTY(m.loReport.cWhile)
         loHost.cWHILEExpression = ALLTRIM(m.loReport.cWhile)
      ENDIF

*        IF !EMPTY(tcHeading)
*            loFile.cHeadingText = ALLTRIM(tcHeading)
*        ENDIF
        
        m.loHost.lPlain   = m.loReport.lPlain
        m.loHost.lSummary = m.loReport.lSummary
        m.loHost.cHeadingText = m.loReport.cHeadingText
        m.loHost.lDisplayStatus=m.loReport.Progress

      * PDF only properties
      IF m.lcID=="PDF"
         m.loHost.lIncludeFont=m.loReport.PDF.lIncludeFont
         m.loHost.nCodePage=m.loReport.CodePage
*         m.loHost.Additive=m.loReport.Additive

*         m.loHost.SetCreator(m.loReport.Creator)
*         m.loHost.SetProducer(m.loReport.Producer)
      ENDIF

      * Word only properties
      IF m.lcID=="DOC"
*         m.loHost.SetComments(m.loReport.Comments)
*         m.loHost.SetCategory(m.loReport.Category)
*         m.loHost.SetManager(m.loReport.Manager)
*         m.loHost.SetCompany(m.loReport.Company)
      ENDIF


      IF m.lcID=="HTML"
*lKeepImgFileWithOutPut
*         m.loHost.ShrinkHeight((m.loReport.nTopMargin/This.PpIY)*10000)
      ENDIF

      * Start Page/End Page or List of Pages
      IF m.loReport.SPage>0 AND m.loReport.EPage>0
*         m.loHost.SetPageRange(m.loReport.SPage,m.loReport.EPage)
      ENDIF

      IF !EMPTY(m.loReport.SEPage) AND m.loReport.SPage<=0 AND m.loReport.EPage<=0
*         m.loHost.SetPageRange(m.loReport.SEPage)
      ENDIF

   ENDPROC



   PROCEDURE GetOuts(laOuts)
      *@laOuts - Matice definovanych vystupu

* MHT,  XML SpreadSheet, 
      LOCAL lii
      DIME laOuts(12,4)
      lii=1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_DOC)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="DOC"
      laOuts(m.lii,4)="doc"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_HTML)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="HTML"
      laOuts(m.lii,4)="htm"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_HTA)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="MHT"
      laOuts(m.lii,4)="mht"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_RTF)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="RTF"
      laOuts(m.lii,4)="rtf"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_XLS)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="XLS"
      laOuts(m.lii,4)="xls"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_XML)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="XML"
      laOuts(m.lii,4)="xml"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_PDF)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="PDF"
      laOuts(m.lii,4)="pdf"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_BMP)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="BMP"
      laOuts(m.lii,4)="bmp"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_JPEG)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="JPG"
      laOuts(m.lii,4)="jpg"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_TIFF)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="TIFF"
      laOuts(m.lii,4)="tif"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_GIF)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="GIF"
      laOuts(m.lii,4)="gif"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_PNG)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="PNG"
      laOuts(m.lii,4)="png"


      RETURN ALEN(m.laOuts,1)
   ENDPROC

   PROCEDURE Export(lcID,loReport) && Provede tisk/export reportu
      * lcID     - ID vystupu rozhrani
      * loReport - Objekt reportu

      LOCAL lcPath,loHost,llErr,liErr,lcFile,lcScope,lnSuccess,lcPom

      lcPath=SET("PATH")
      SET PATH TO (This.EPath)

      IF ISNULL(This.oHost)
         llErr=!This.CreateHost(m.lcID,@m.loReport)
      ENDIF
      loHost=This.oHost
      lcFile=m.loReport.OFile

      DO CASE
         CASE m.llErr && Dolo k chyb
              liErr=_EFRX_PrintFailed
             
         OTHERWISE
              This.SetHost(@m.loHost,@m.loReport,@m.lcID)
 
              =IIF(PEMSTATUS(m.loReport.oCallBack,"EFRX_BeforeExport",5),m.loReport.oCallBack.EFRX_BeforeExport(@m.loHost),.T.)

              lcPom = SUBST(m.lcFile,RAT("\",m.lcFile)+1)
              loHost.cExportFileName = IIF(RAT(".",m.lcPom)>0,LEFT(m.lcPom,RAT(".",m.lcPom)-1),m.lcPom)
              loHost.cSaveFolder     = LEFT(m.lcFile,RAT("\",m.lcFile))


              IF m.loReport.ToEmail
                 loEmail=m.loReport.EMAIL

*!*	                 loEmail.AddRecipient("aaa","aa@aa.com",1)
*!*	                 loEmail.AddRecipient("bbb","bb@bb.com",1)

*!*	                 loEmail.AddRecipient("ccc","cc@cc.com",2)
*!*	                 loEmail.AddRecipient("ddd","dd@dd.com",2)

                 loHost.nOutPutType=cnOUTPUT_EMAIL
                 loHost.lDisplayBeforeEMail=!m.loReport.Silent AND m.loEMAIL.ShowDialog
                 loHost.lAsAttachment =.T.
                 loHost.cSubject=m.loEMAIL.Subject

*                 loHost.EmailFromAddress=m.loEMAIL.FromAddress
*                 loHost.EmailBody=m.loEMAIL.Body
   
*                 loHost.EmailSMTPAuthorizationType=m.loEMAIL.AuthorizationType
*                 IF m.loEMAIL.AuthorizationType=_EFRX_ASMTP_No
*                    loHost.EmailSMTPHost=m.loEMAIL.Host
*                    loHost.EmailSMTPPort=m.loEMAIL.Port
*                    * loHost.EmailSMTPTimeOut=m.loEMAIL.TimeOut
*                 ELSE
*                    loHost.EmailSMTPHost=m.loEMAIL.EHost
*                    loHost.EmailSMTPPort=m.loEMAIL.EPort
*                    * loHost.EmailSMTPTimeOut=m.loEMAIL.ETimeOut
*                    loHost.EmailSMPTUserID=m.loEMAIL.UserID
*                    loHost.EmailSMTPPassword=m.loEMAIL.Password
*                 ENDIF


                 lcPom=""
                 FOR lii=1 TO m.loEmail.iRecipient
                     lcPom=m.lcPom+m.loEmail.Separator+m.loEmail.aRecipientsE(m.lii)
                 NEXT
                 loHost.cSendTo=SUBST(m.lcPom,2)

                 lcPom=""
                 FOR lii=1 TO m.loEmail.iCC
                     lcPom=m.lcPom+m.loEmail.Separator+m.loEmail.aCCsE(m.lii)
                 NEXT
                 loHost.cSendCC=SUBST(m.lcPom,2)

                 * lcPom=""
                 * FOR lii=1 TO m.loEmail.iBCC
                 *     lcPom=m.lcPom+m.loEmail.Separator+m.loEmail.aBCCsE(m.lii)
                 * NEXT
                 * loHost.cSendBCC=SUBST(m.lcPom,2)

                 * loHost.EmailAttachmentFileName=m.lcFile
                 * loHost.EmailMessagingType=m.loEMAIL.MessagingType
                 * loHost.EmailReturnReceipt=m.loEMAIL.ReturnReceipt

                 =IIF(PEMSTATUS(m.loReport.oCallBack,"EFRX_BeforeEmail",5),m.loReport.oCallBack.EFRX_BeforeEmail(@m.loHost),.T.)

              ELSE
                 IF INLIST(m.lcID,"BMP", "JPG", "TIFF", "GIF","PNG")
                    loHost.nOutPutType     = cnOUTPUT_SCREEN

                    *-- Default value is cnIMAGE_OUTPUT_FILE_FORMAT_GIF
                    DO CASE
                       CASE m.lcID="BMP"
                            loHost.nImageFileType  = cnIMAGE_OUTPUT_FILE_FORMAT_BMP

                       CASE m.lcID="JPG"
                            loHost.nImageFileType  = cnIMAGE_OUTPUT_FILE_FORMAT_JPG

                       CASE m.lcID="TIFF"
                            loHost.nImageFileType  = cnIMAGE_OUTPUT_FILE_FORMAT_TIF

                       CASE m.lcID="GIF"
                            loHost.nImageFileType  = cnIMAGE_OUTPUT_FILE_FORMAT_GIF

                       CASE m.lcID="PNG"
                            loHost.nImageFileType  = cnIMAGE_OUTPUT_FILE_FORMAT_PNG

                    ENDCASE
                 ELSE
                    IF m.lcID=="MHT"
                       loHost.nOutPutType=cnOUTPUT_SCREEN
                       loHost.lEmbedImage = .T. 
                    ELSE
                       loHost.nOutPutType=cnOUTPUT_FILE
                    ENDIF
                 ENDIF
              ENDIF

*!*                  liErr = loHost.InitDataEnvironment(loReport.RFile)

*!*                  IF liErr = cnOK
                 liErr  = m.loHost.Save(m.loReport.RFile)
                 llErr  = !m.liErr=cnOK
*!*                  ENDIF
              IF !m.llErr
                 =IIF(PEMSTATUS(m.loReport.oCallBack,"EFRX_NextReport",5),m.loReport.oCallBack.EFRX_NextReport(@m.loHost),.T.)
              ENDIF
              =IIF(PEMSTATUS(m.loHost,"Release",5),m.loHost.Release(),.T.)
      ENDCASE
      This.oHost=.NULL.

      SET PATH TO (m.lcPath)

      loReport.ErrNo=cnOK
      IF m.liErr=_EFRX_OK
         loReport.Exported=.T.
      ENDIF
      RETURN IIF(m.liErr=0,_EFRX_OK,_EFRX_PrintFailed)
   ENDPROC

   PROCEDURE Preview(loReport) && Zavola preview reportu
      * loReport - Objekt reportu
      LOCAL lcPath,loHost,llErr,liErr
      PUBLIC poXXF000

      lcPath=SET("PATH")
      SET PATH TO (This.EPath)

      IF ISNULL(This.oHost)
         llErr=!This.CreateHost("PRV",@m.loReport)
      ENDIF
      loHost=This.oHost

      DO CASE
         CASE m.llErr && Dolo k chyb
              liErr=_EFRX_PrintFailed
             
         OTHERWISE

              loHost.nOutPutType=cnOUTPUT_FILE
              loHost.cPrintPreviewFormTitle=m.loReport.Caption

              IF m.loReport.Lang="csy" AND FILE(This.EPath+"Service Utilities\Localization\Localizationcz.dbf")
                 loHost.cLocalization=This.EPath+"Service Utilities\Localization\Localizationcz.dbf"
              ENDIF
              liErr=0


*!*                  liErr = loHost.InitDataEnvironment(loReport.RFile)

*opreviewform
*cPrintPreviewFormTitle Character 
*!*                  IF liErr = cnOK
*      =IIF(PEMSTATUS(loReport.oCallBack,"EFRX_BeforePreview",5),loReport.oCallBack.EFRX_BeforePreview(@loHost,@poXXF000),.T.)
                 llErr  = m.loHost.Save(m.loReport.RFile)=cnOK

*!*                  ENDIF
              IF !m.llErr
*                 =IIF(PEMSTATUS(loReport.oCallBack,"EFRX_NextReport",5),loReport.oCallBack.EFRX_NextReport(@loHost),.T.)
              ENDIF
      ENDCASE
      This.oForm=.NULL.
      RELE poXXF000
      This.oHost=.NULL.

      SET PATH TO (m.lcPath)

      loReport.ErrNo=m.liErr
      RETURN IIF(m.liErr=0,_EFRX_OK,_EFRX_PrintFailed)
   ENDPROC


   PROCEDURE GetVersion() && Vrati verzi report enginu
      LOCAL lcPath,llErr,lcPom

      lcPath=SET("PATH")
      SET PATH TO (This.EPath)

      IF ISNULL(This.oHost)
         llErr=!This.CreateHost("PDF")
      ENDIF
      lcPom=This.oHost.GetVersion()
      This.oHost=.NULL.

      SET PATH TO (m.lcPath)
      RETURN IIF(m.llErr,"",m.lcPom)
   ENDPROC

ENDDEFINE
