#INCLUDE "efrx.h"

PROCEDURE EFRX_GetInterface(loHost) && Vrati objekt Interface
* @loHost - (Out) - vrati objekt Interface
LOCAL lcPath,lcProg
loHost=CREATEOBJECT("_MERE")
* Nastav cestu k interface
lcProg=PROGRAM()
lcPath=SYS(16)
lcPath=SUBST(m.lcPath,AT(m.lcProg,m.lcPath)+LEN(m.lcProg)+1)
loHost.Path=IIF(RAT("\",m.lcPath)>0,LEFT(m.lcPath,RAT("\",m.lcPath)),m.lcPath)
RETURN

****************************************************************
* Definice tridy rozhrani pro MindsEyeReportEngine
****************************************************************
DEFINE CLASS _MERE AS __CFRX
   Name="_MERE"
   
   Engine="MERE" && Kod rozhrani
   PreviewAllowed=.T. && Priznak, zda utilita umoznuje vlastni Preview
   PrintAllowed=.T.   && Priznak, zda utilita umoznuje vlastni Preview

   PageRange=_EFRX_PR_Basic

   EmailAllowed=.T. && Priznak, zda utilita umoznuje odeslani E-mailem
   WMAllowed=.T. && Priznak, zda utilita umoznuje WaterMark

   PRV.UpdateModeAllowed=.T.

   EMAIL.AuthorizedAllowed=.T. && Priznak, zda utilita umoznuje odeslani E-mailem - autorizovany pristup
   EMAIL.CCAllowed=.T. && Carbon copy allowed
   EMAIL.BCCAllowed=.T. && Bicarbon copy allowed
   EMAIL.BodyAllowed=.T. && Body allowed
   
   EMAIL.EngineAllowed=.T.
   EMAIL.MAPIAllowed=.T. && MAPI allowed
   EMAIL.SMTPAllowed=.T. && SMTP allowed
  
   PICT.bppAllowed=.T. && Bit per pixel
   PICT.JPQAllowed=.T. && JPEG Quality
   PICT.GrayScaleAllowed=.T. && GrayScale Flag
   PICT.ThumbnailAllowed=.T.


   PROCEDURE Init
      This.Caption="Minds Eye Report Engine"
   ENDPROC

   PROCEDURE TestHost() &&  Otestuje, zda je mozno vytvorit engine
      RETURN LEN(SYS(2000,This.EPath+"mindseyereportengine.vcx"))>0 AND;
             LEN(SYS(2000,This.EPath+"mindseyereportengine.vct"))>0 AND;
             LEN(SYS(2000,This.EPath+"mindseyereportpreviewforms.vcx"))>0 AND;
             LEN(SYS(2000,This.EPath+"mindseyereportpreviewforms.vct"))>0
   ENDPROC


   PROCEDURE CreateHost() && Vytvori hostitelsky objekt exportni utility
      LOCAL loHost,llErr
      IF !UPPER(This.EPath+"mindseyereportengine.vcx")$UPPER(SET("CLASSLIB"))
         This.ResetError()
         * Pokus se nalinkovat VCX knihovnu
         SET CLASSLIB TO (This.EPath+"mindseyereportengine.vcx") ADDITIVE
         llErr=This.nError>0
      ENDIF

      IF !m.llErr AND !UPPER(This.EPath+"mindseyereportpreviewforms.vcx")$UPPER(SET("CLASSLIB"))
         This.ResetError()
         * Pokus se nalinkovat VCX knihovnu
         SET CLASSLIB TO (This.EPath+"mindseyereportpreviewforms.vcx") ADDITIVE
         llErr=This.nError>0
      ENDIF

      IF !m.llErr
         This.ResetError()
         loHost=CREATEOBJECT('MindsEyeReportEngine')
         llErr=This.nError>0
         IF !m.llErr
            This.oHost=m.loHost
         ENDIF
      ENDIF
      This.ResetError()
      RETURN !m.llErr
   ENDPROC


   PROCEDURE ReleaseHost() && Uvolni hostitelsky objekt exportni utility
      DODEFAULT() && Volani puvodni metody
      LOCAL lcLib
      lcLib=UPPER(This.EPath+"mindseyereportengine.vcx")
      IF m.lcLib$UPPER(SET("CLASSLIB"))
         RELEASE CLASSLIB (m.lcLib)
      ENDIF

      lcLib=UPPER(This.EPath+"mindseyereportpreviewforms.vcx")
      IF m.lcLib$UPPER(SET("CLASSLIB"))
         RELEASE CLASSLIB (m.lcLib)
      ENDIF
   ENDPROC


   PROCEDURE SetHost(loHost,loReport,lcID) && Nastavi volby hostitele
      * loHost   - Objekt hostitele
      * loReport - Objekt informaci o reportu
      * lcID     - Druh vystupu

      loHost.cScope=m.loReport.cScope
      loHost.cWhileExpression=m.loReport.cWhile
      loHost.cForExpression=m.loReport.cFor
      loHost.nRecords=m.loReport.nInitialRecord

      loHost.lDisplayexecutiontime=!m.loReport.Silent
      loHost.cReportPreviewFormCaption=m.loReport.Caption

   ENDPROC


   PROCEDURE SetEngine(loEngine,loReport,lcID) && Nastavi volby enginu hostitele
      * loEngine   - Objekt enginu hostitele
      * loReport - Objekt informaci o reportu
      * lcID     - Druh vystupu

      IF TYPE("m.loEngine.PDFAuthor")#"U"
         loEngine.PDFAuthor=m.loReport.Author
      ENDIF
      loEngine.PDFEmbedFonts=m.loReport.lIncludeFont

      loEngine.PDFBitmapQuality=m.loReport.PDF.BitmapQuality
      loEngine.PDFCompress=m.loReport.PDF.Compress
      loEngine.PDFCompressBitmaps=m.loReport.PDF.CompressBitmaps
      IF TYPE("m.loEngine.PDFEncrypt")#"U"
         loEngine.PDFEncrypt=m.loReport.PDF.Encrypt
      ENDIF
      loEngine.PDFJPEGQuality=m.loReport.PDF.JPEGQuality
      loEngine.PDFMargin=m.loReport.PDF.Margin
      IF TYPE("m.loEngine.PDFPassword")#"U"
         loEngine.PDFPassword=m.loReport.Password
      ENDIF
      loEngine.PDFTitle=m.loReport.Title
      loEngine.PDFSubject=m.loReport.Subject
      loEngine.PDFKeywords=m.loReport.Keywords
      loEngine.PDFCreator=m.loReport.Creator

      loEngine.DisplayNewPageButton=m.loReport.PRV.UpdateMode
      loEngine.DisplayDeletePageButton=m.loReport.PRV.UpdateMode
      loEngine.Scale=m.loReport.PRV.Scale

      loEngine.Additive=m.loReport.Additive
   ENDPROC


   PROCEDURE GetOuts(laOuts)
      *@laOuts - Matice definovanych vystupu
      DIME laOuts(7,4)
      laOuts(1,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_PDF)
      laOuts(1,2)=This.Engine
      laOuts(1,3)="PDF"
      laOuts(1,4)="pdf"

      laOuts(2,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_DOC)
      laOuts(2,2)=This.Engine
      laOuts(2,3)="DOC"
      laOuts(2,4)="doc"

      laOuts(3,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_BMP)
      laOuts(3,2)=This.Engine
      laOuts(3,3)="BMP"
      laOuts(3,4)="bmp"

      laOuts(4,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_JPEG)
      laOuts(4,2)=This.Engine
      laOuts(4,3)="JPEG"
      laOuts(4,4)="jpeg"

      laOuts(5,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_PNG)
      laOuts(5,2)=This.Engine
      laOuts(5,3)="PNG"
      laOuts(5,4)="png"

      laOuts(6,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_WMF)
      laOuts(6,2)=This.Engine
      laOuts(6,3)="META"
      laOuts(6,4)="emf"

      laOuts(7,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_TIFF)
      laOuts(7,2)=This.Engine
      laOuts(7,3)="TIFF"
      laOuts(7,4)="tiff"
      
      RETURN ALEN(m.laOuts,1)
   ENDPROC

   PROCEDURE Export(lcID,loReport) && Provede tisk/export reportu
      * lcID     - ID vystupu rozhrani
      * loReport - Objekt reportu

      LOCAL loHost,llErr,liErr,lcFile,loEngine,loForm,lii,loEmail,lcPom

      IF ISNULL(This.oHost)
         llErr=!This.CreateHost()
      ENDIF
      loHost=This.oHost
      lcFile=m.loReport.OFile

      DO CASE
         CASE m.llErr && Doslo k chybe
              liErr=_EFRX_PrintFailed
             
         OTHERWISE
              This.SetHost(@m.loHost,@m.loReport,m.lcID)

              loForm = m.loHost.ReportFormObject(m.loReport.RFile)
              loEngine=m.loForm.oReportEngine

              This.SetEngine(@m.loEngine,@m.loReport,m.lcID)

              =IIF(PEMSTATUS(m.loReport.oCallBack,"EFRX_BeforeExport",5),m.loReport.oCallBack.EFRX_BeforeExport(@m.loEngine),.T.)
              =IIF(PEMSTATUS(m.loReport.oCallBack,"EFRX_NextReport",5),m.loReport.oCallBack.EFRX_NextReport(@m.loEngine),.T.)

              IF !EMPTY(m.loReport.WM.Text)
                 This.SetWaterMark(m.loEngine,m.loReport)
              ENDIF


              DO CASE
                 CASE m.lcID=="PDF"
                      liErr=IIF(m.loEngine.SaveToPDF(m.lcFile,m.loReport.AutoOpen),0,1)

                 CASE m.lcID=="DOC"
                      liErr=IIF(m.loEngine.SaveToWord(m.lcFile,m.loReport.AutoOpen),0,1)

                 CASE m.lcID=="BMP" OR m.lcID=="JPEG" OR m.lcID=="META" OR m.lcID=="PNG" OR m.lcID=="TIFF"
                      lii=RAT(".",m.lcFile)
                      IF m.lii>0
                         lcPom=SUBST(m.lcFile,m.lii)
                         lcFile=LEFT(m.lcFile,m.lii-1)
                      ELSE
                         lcPom=""
                      ENDIF
                 
                      DO CASE
                         CASE m.lcID=="BMP"
                               FOR lii=1 TO m.loEngine.nTotalpages
                                   liErr=m.loEngine.SaveToBitmap(m.lcFile+LTRIM(STR(m.lii,11))+m.lcPom, m.loReport.PICT.ThumbnailWidth,;
                                         m.loReport.AutoOpen, 1, m.loReport.PICT.bpp, m.loReport.PICT.GrayScale)
                               NEXT
                               *SaveToBMP(cFileName, [nPageNumber], [lOpenFile], [nThumbnailSize], [nBitsPerPixel], [lGrayScale])

                         CASE m.lcID=="JPEG"
                               FOR lii=1 TO m.loEngine.nTotalpages
                                   liErr=m.loEngine.SaveToJPEG(m.lcFile+LTRIM(STR(m.lii,11))+m.lcPom, m.lii, m.loReport.AutoOpen, m.loReport.PICT.ThumbnailWidth,;
                                         m.loReport.PICT.GrayScale, m.loReport.PICT.JPQ, .F.)
                               NEXT
                               *SaveToJPEG(cFileName As Variant, nPageNumber As Numeric, lOpenFile As Logical,;
*                                            nThumbnailSize As Numeric, lGrayScale As Logical, nCompressionQuality As Numeric, lProgressiveEncoding As Logical)
                                           
                         CASE m.lcID=="PNG"
                               FOR lii=1 TO m.loEngine.nTotalpages
                                   liErr=m.loEngine.SaveToPNG(m.lcFile+LTRIM(STR(m.lii,11))+m.lcPom, m.lii, m.loReport.AutoOpen,;
                                            m.loReport.PICT.ThumbnailWidth, m.loReport.PICT.bpp, m.loReport.PICT.GrayScale)
                               NEXT
                               *SaveToPNG(cFileName, [nPageNumber], [lOpenFile], [nThumbnailSize], [nBitsPerPixel], [lGrayScale])

                         CASE m.lcID=="META"
                               FOR lii=1 TO m.loEngine.nTotalpages
                                   liErr=m.loEngine.SaveToMetafile(m.lcFile+LTRIM(STR(m.lii,11))+m.lcPom, m.lii, m.loReport.AutoOpen)
                               NEXT
                               *SaveToMetafile(cFileName, [nPageNumber], [lOpenFile])

                         CASE m.lcID=="TIFF"
                               liErr=m.loEngine.SaveToTIFF(m.lcFile+m.lcPom, 1,m.loEngine.nTotalpages,;
                                         m.loReport.AutoOpen, m.loReport.PICT.ThumbnailWidth, m.loReport.PICT.JPQ, m.loReport.PICT.bpp, m.loReport.PICT.GrayScale)


                               *SaveToTIFF(cFileName As Variant, nPageNumberStart As Numeric, nPageNumberEnd As Numeric,;
                               *           lOpenFile As Logical, nThumbnailSize As Numeric, nCompressionType As Numeric,
                               *           nBitsPerPixel As Numeric, lGrayScale As Logical)
                      ENDCASE
              ENDCASE
              

              IF m.loReport.ToEmail
                 loEmail=m.loReport.EMAIL
                 loEngine.EmailFromAddress=m.loEMAIL.FromAddress
                 loEngine.EmailSubject=m.loEMAIL.Subject
                 loEngine.EmailBody=m.loEMAIL.Body
   
                 m.loEngine.EmailSMTPAuthorizationType=m.loEMAIL.AuthorizationType
                 IF m.loEMAIL.AuthorizationType=_EFRX_ASMTP_No
                    loEngine.EmailSMTPHost=m.loEMAIL.Host
                    loEngine.EmailSMTPPort=m.loEMAIL.Port
                    * loEngine.EmailSMTPTimeOut=m.loEMAIL.TimeOut
                 ELSE
                    loEngine.EmailSMTPHost=m.loEMAIL.EHost
                    loEngine.EmailSMTPPort=m.loEMAIL.EPort
                    * loEngine.EmailSMTPTimeOut=m.loEMAIL.ETimeOut
                    loEngine.EmailSMPTUserID=m.loEMAIL.UserID
                    loEngine.EmailSMTPPassword=m.loEMAIL.Password
                 ENDIF

                 lcPom=""
                 FOR lii=1 TO m.loEmail.iRecipient
                     lcPom=m.lcPom+m.loEmail.Separator+m.loEmail.aRecipientsE(m.lii)
                 NEXT
                 loEngine.EmailRecipients=SUBST(m.lcPom,2)

                 lcPom=""
                 FOR lii=1 TO m.loEmail.iCC
                     lcPom=m.lcPom+m.loEmail.Separator+m.loEmail.aCCsE(m.lii)
                 NEXT
                 loEngine.EmailCCAddresses=SUBST(m.lcPom,2)

                 lcPom=""
                 FOR lii=1 TO m.loEmail.iBCC
                     lcPom=m.lcPom+m.loEmail.Separator+m.loEmail.aBCCsE(m.lii)
                 NEXT
                 loEngine.EmailBCCAddresses=SUBST(m.lcPom,2)

                 loEngine.EmailAttachmentFileName=m.lcFile

                 * MERE Native Properties
                 loEngine.EmailMessagingType=m.loEmail.Engine
                 loEngine.EmailReturnReceipt=!EMPTY(m.loEmail.ReturnReceiptAddr)

                 =IIF(PEMSTATUS(m.loReport.oCallBack,"EFRX_BeforeEmail",5),m.loReport.oCallBack.EFRX_BeforeEmail(@m.loEngine),.T.)

                 liErr=m.loEngine.SendMail()

              ENDIF

      ENDCASE
      STORE .NULL. TO This.oHost,loEngine,loHost
      

      loReport.ErrNo=m.liErr
      IF m.liErr=_EFRX_OK
         loReport.Exported=.T.
      ENDIF
      RETURN IIF(m.liErr=0,_EFRX_OK,_EFRX_PrintFailed)
   ENDPROC

   PROCEDURE Preview(loReport) && Zavola preview reportu
      * loReport - Objekt reportu
      LOCAL loHost,llErr,liErr,loEngine
      PUBLIC poXXF000

      IF ISNULL(This.oHost)
         llErr=!This.CreateHost()
      ENDIF
      loHost=This.oHost

      DO CASE
         CASE m.llErr && Doslo k chybe
              liErr=_EFRX_PrintFailed
             
         OTHERWISE
              This.SetHost(@m.loHost,@m.loReport,"PRV")
              STORE m.loHost.ReportFormObject(m.loReport.RFile,IIF(m.loReport.PRV.AsTopLevel,1,0)) TO poXXF000,This.oForm

              loEngine=m.poXXF000.oReportEngine
              This.SetEngine(@m.loEngine,@m.loReport,"PRV")

              =IIF(PEMSTATUS(m.loReport.oCallBack,"EFRX_NextReport",5),m.loReport.oCallBack.EFRX_NextReport(@m.loHost),.T.)
              =IIF(PEMSTATUS(m.loReport.oCallBack,"EFRX_BeforePreview",5),m.loReport.oCallBack.EFRX_BeforePreview(@m.loEngine,@m.poXXF000),.T.)

              IF !EMPTY(m.loReport.WM.Text)
                 This.SetWaterMark(m.loEngine,m.loReport)
              ENDIF

              m.poXXF000.Show(1)
              This.oForm=.NULL.

      ENDCASE
      RELE m.poXXF000
      This.oHost=.NULL.

      RETURN _EFRX_OK
   ENDPROC

   PROCEDURE Print(loReport) && Zavola preview reportu
      * loReport - Objekt reportu
      LOCAL loHost,llErr,liErr

      IF ISNULL(This.oHost)
         llErr=!This.CreateHost()
      ENDIF
      loHost=This.oHost

      DO CASE
         CASE m.llErr && Doslo k chybe
              liErr=_EFRX_PrintFailed
             
         OTHERWISE
              This.SetHost(@m.loHost,@m.loReport,m.lcID)
              This.SetEngine(@m.loEngine,@m.loReport,m.lcID)


              IF !EMPTY(m.loReport.WM.Text)
                 loForm = m.loHost.ReportFormObject(m.loReport.RFile)
                 =IIF(PEMSTATUS(m.loReport.oCallBack,"EFRX_NextReport",5),m.loReport.oCallBack.EFRX_NextReport(@m.loHost),.T.)
                 loEngine=m.loForm.oReportEngine

                 =IIF(PEMSTATUS(m.loReport.oCallBack,"EFRX_BeforePrint",5),m.loReport.oCallBack.EFRX_BeforePrint(@m.loEngine),.T.)

                 This.SetWaterMark(m.loEngine,m.loReport)

                 liErr=_EFRX_OK
                 m.loEngine.PrintReport(m.loReport.PrinterName,m.loReport.SPage,m.loReport.EPage)
              ELSE
                 m.loHost.ReportToPrinterPrompt(m.loReport.RFile)
              ENDIF

      ENDCASE
      This.oHost=.NULL.
      IF m.liErr=_EFRX_OK
         loReport.Printed=.T.
      ENDIF

      RETURN _EFRX_OK
   ENDPROC


   PROCEDURE SetWaterMark(loEngine,loReport) && Nastavi WaterMark
      * loEngine - Intern engine
      * loReport - Objekt reportu
      LOCAL lii   
      FOR lii = 1 TO m.loEngine.nTotalPages
          m.loEngine.GoToPage(m.lii)

          IF m.loReport.WM.BackColor#-1
             loEngine.WaterMarkBackColor=m.loReport.WM.BackColor
          ENDIF
          IF m.loReport.WM.ForeColor#-1
             loEngine.WaterMarkForeColor=m.loReport.WM.ForeColor
          ENDIF
          IF !EMPTY(m.loReport.WM.FontName)
             loEngine.WatermarkFontName=m.loReport.WM.FontName
          ENDIF
          IF m.loReport.WM.FontSize#-1
             loEngine.WatermarkFontSize=m.loReport.WM.FontSize
          ENDIF
          IF !EMPTY(m.loReport.WM.FontStyle)
             loEngine.WatermarkFontStyle=m.loReport.WM.FontStyle
          ENDIF
          IF !m.loReport.WM.RotationAngle#-1
             loEngine.WatermarkRotationAngle=m.loReport.WM.RotationAngle
          ENDIF
          loEngine.WatermarkText=m.loReport.WM.Text
      NEXT
      m.loEngine.GoToPage(IIF(m.loEngine.nTotalPages=0,0,1))
   ENDPROC

   PROCEDURE GetVersion() && Vrati verzi report enginu
      LOCAL llErr,lcPom
      LOCAL ARRAY laFile(1)

      IF ISNULL(This.oHost)
         llErr=!This.CreateHost()
      ENDIF
      IF FILE(This.EPath+"..\MindsEyeReportEnginePro1.ocx")
         =AGETFILEVERSION(m.laFile,This.EPath+"..\MindsEyeReportEnginePro1.ocx")
         lcPom=m.laFile(4) && This.oHost.GetVersion()
      ELSE
         IF FILE(This.EPath+"..\MindsEyeReportEngineStd1.ocx")
            =AGETFILEVERSION(m.laFile,This.EPath+"..\MindsEyeReportEngineStd1.ocx")
            lcPom=m.laFile(4) && This.oHost.GetVersion()
         ELSE
            lcPom="MERE - Unknown" && This.oHost.GetVersion()
         ENDIF
      ENDIF
      This.oHost=.NULL.

      RETURN IIF(m.llErr,"",m.lcPom)
   ENDPROC


* MERE properties
*!*    EmailAttachmentFileName    String    Specifies the file name to be used as the attachment that the report will be emailed as.
*!*    EmailBCCAddresses    String    Specifies a comma separated list of formatted Blind Carbon Copy addresses to email to
*!*    EmailBody    String    Specifies the Body Text of the email.
*!*    EmailCCAddresses    String    Specifies a comma separated list of formatted Carbon Copy addresses to email to.
*!*    EmailFromAddress    String    Specifies the From Address for the email and is required.
*!*    EmailMessagingType    Numeric    Specifies the Email Messaging Type:
*!*    0 = SMTP
*!*    1 = MAPI

*!*    EmailRecipients    String    Specifies a comma separated list of formatted Recipient addresses to email to.
*!*    EmailReturnReceipt    Boolean    Specifies that a Return Receipt will be requested.
*!*    EmailSMTPAuthorizationType    Numeric    Specifies the SMTP Authorization Type. 0 = none, 1 = Login Required
*!*    EmailSMTPHost    String    Specifies the name of the SMTP Host and must be specified in order to send an email.
*!*    EmailSMTPPassword    String    Specifies the Password for logging into an SMTP Server when using Authentication Type =1.
*!*    EmailSMTPPort    Numeric    Specifies the Port for the SMTP Server if required. Default is 0 and not used.
*!*    EmailSMPTUserID    String    Specifies the UserID for logging into an SMTP Server when using Authentication Type = 1.
*!*    EmailSubject    


*EFRX properties
*!*	   AttachmentFileName="" && Specifies the file name to be used as the attachment that the report will be emailed as.
*!*	   BCC="" &&  Specifies a comma separated list of formatted Blind Carbon Copy addresses to email to
*!*	   Body="" && Specifies the Body Text of the email.
*!*	   CC="" && Specifies a comma separated list of formatted Carbon Copy addresses to email to.
*!*	   FromAddress="" && Specifies the From Address for the email and is required.
*!*	   MessagingType=0 && Specifies the Email Messaging Type: 0 = SMTP 1 = MAPI
*!*	   Recipients="" && Specifies a comma separated list of formatted Recipient addresses to email to.
*!*	   ReturnReceipt=.F. && Specifies that a Return Receipt will be requested.
*!*	   SMTPAuthorizationType=0 && Specifies the SMTP Authorization Type. 0 = none, 1 = Login Required
*!*	   SMTPHost="" && Specifies the name of the SMTP Host and must be specified in order to send an email.
*!*	   SMTPPassword="" && Specifies the Password for logging into an SMTP Server when using Authentication Type =1.
*!*	   SMTPPort=0 && Specifies the Port for the SMTP Server if required. Default is 0 and not used.
*!*	   SMPTUserID="" && Specifies the UserID for logging into an SMTP Server when using Authentication Type = 1.
*!*	   Subject=""


ENDDEFINE
