*#EXTERNAL PROCEDURE EFRX_GETINTERFACE
#INCLUDE "efrx.h"

****************************************************************
* Definice tridy konteineru rozhrani pro export reportu 
****************************************************************
DEFINE CLASS __CFRXs AS CUSTOM
   Name="__CFRXs"

   Version="0.1.0"   && Version of EFRX engine
  
   iCount=0 && Pocet interface
   DIME aEFRX(1) && Matice Interface

   SourcePath=""

   PROCEDURE Destroy()
      * lcEngine - Typ rozhrani
      LOCAL lii
      FOR lii=1 TO This.iCount
          This.aEFRX(m.lii,1)=""
          This.aEFRX(m.lii,2)=.NULL.
      NEXT
      RETURN .NULL.
   ENDPROC

   PROCEDURE InitEngine(loEngine) && Dodatecna inicializace interface
      * loEngine - Objekt interface
   ENDPROC

   PROCEDURE GetEngine(lcEngine) && Vrati interface
      * lcEngine - Typ rozhrani
      LOCAL lii
      FOR lii=1 TO This.iCount
          IF This.aEFRX(m.lii,1)==m.lcEngine
             =m.XX_System.OPT.Add(IIF(EMPTY(m.XX_System.Modul) OR !LEFT(m.XX_System.Modul,7)=="XXF000_",.NULL.,EVAL("m.XX_SrvSeznam.CVPFiles."+m.XX_System.Modul)),;
                   "Reports Engine (get) "+m.lcEngine+": "+IIF(ISNULL(This.aEFRX(m.lii,2)),"FAILURE","OK"))

             RETURN This.aEFRX(m.lii,2)
          ENDIF
      NEXT
      RETURN .NULL.
   ENDPROC

   PROCEDURE GetEnginesList(laOuts,llOnlyValid) && Vrati seznam enginu
      *@laOuts - Matice definovanych vystupu

      LOCAL lii,lcPom,liy
      liy=0
      IF This.iCount>0
         lcPom=""
         DIME m.laOuts(This.iCount,2)
         FOR lii=1 TO This.iCount
             IF m.llOnlyValid AND This.aEFRX(m.lii,2).TestHost() OR !m.llOnlyValid
                liy=m.liy+1
                laOuts(m.liy,1)=This.aEFRX(m.lii,1)
                laOuts(m.liy,2)=This.aEFRX(m.lii,2).Caption
                lcPom=m.lcPom+This.aEFRX(m.lii,1)+","
             ENDIF
         NEXT
         IF m.liy>0
            DIMENSION m.laOuts(m.liy,2)
         ENDIF

         =XX_System.OPT.Add(IIF(EMPTY(m.XX_System.Modul) OR !LEFT(m.XX_System.Modul,7)=="XXF000_",.NULL.,EVAL("m.XX_SrvSeznam.CVPFiles."+m.XX_System.Modul)),;
                           "Reports Engine List: "+m.lcPom)
      ENDIF
      RETURN m.liy
   ENDPROC
   
   PROCEDURE GetOuts(lcEngine,laOuts) && Vrati seznam vystupu
      * lcEngine - Engine
      *@laOuts - Matice definovanych vystupu

      LOCAL lii,liCount,liy
      LOCAL ARRAY laOut(1)
      liy=0
      FOR lii=1 TO This.iCount
          IF EMPTY(m.lcEngine) OR This.aEFRX(m.lii,1)==m.lcEngine
             liCount=This.aEFRX(m.lii,2).GetOuts(@m.laOut)
             IF m.liCount>0
                DIME m.laOuts(m.liy+m.liCount,4)
                ACOPY(m.laOut,m.laOuts,1,m.liCount*4,m.liy*4+1)
                liy=m.liy+m.liCount
             ENDIF
          ENDIF
      NEXT
      RETURN m.liy
   ENDPROC

   PROCEDURE Print(lcEngine,loReport) && Provede tisk reportu
      * lcEngine - Typ rozhrani
      * loReport - Objekt reportu
      LOCAL lii
      STORE .F. TO loReport.Exported,loReport.Printed
      FOR lii=1 TO This.iCount
          IF This.aEFRX(m.lii,1)==m.lcEngine
             RETURN This.aEFRX(m.lii,2).Print(m.loReport)
          ENDIF
      NEXT
      RETURN _EFRX_NotInterface
   ENDPROC

   PROCEDURE Preview(lcEngine,loReport) && Zavola preview reportu
      * lcEngine - Typ rozhrani
      * loReport - Objekt reportu
      STORE .F. TO loReport.Exported,loReport.Printed
      LOCAL lii
      FOR lii=1 TO This.iCount
          IF This.aEFRX(m.lii,1)==m.lcEngine
             RETURN This.aEFRX(m.lii,2).Preview(m.loReport)
          ENDIF
      NEXT
      RETURN _EFRX_NotInterface
   ENDPROC

   PROCEDURE Export(lcEngine,lcID,loReport) && Provede export reportu
      * lcEngine - Typ rozhrani
      * lcID     - ID vystupu rozhrani
      * loReport - Objekt reportu
      LOCAL lii
      STORE .F. TO loReport.Exported,loReport.Printed
      FOR lii=1 TO This.iCount
          IF This.aEFRX(m.lii,1)==m.lcEngine
             RETURN This.aEFRX(m.lii,2).Export(m.lcID,m.loReport)
          ENDIF
      NEXT
      RETURN _EFRX_NotInterface
   ENDPROC

   PROCEDURE Requery() && Nacte seznam rozhrani
      LOCAL lii,liCount,liy,loEngine,llErr,lcPom
      LOCAL ARRAY laEFRXs(1)
      PRIVATE loErrObj

      liCount=ADIR(laEFRXs,This.SourcePath+"*.fxp","AR")
      
      liy=0
      FOR lii=1 TO m.liCount
          IF m.laEFRXs(m.lii,1)=="EFRX.FXP" && Vyblokuj hlavni program
             LOOP
          ENDIF
          
          STORE .NULL. TO loEngine,loErrObj &&  Resetuj interface
          DO EFRX_GetInterface IN (This.SourcePath+laEFRXs(m.lii,1)) WITH m.loEngine
          llErr=!ISNULL(m.loErrObj)
          loErrObj=IIF(ISNULL(m.loErrObj),.F.,m.loErrObj)

          lcPom="Report's Engine loaded status "+This.SourcePath+m.laEFRXs(m.lii,1)+ ": "+IIF(ISNULL(m.loEngine),"Failed","OK")
          =m.XX_System.OPT.Add(IIF(EMPTY(m.XX_System.Modul) OR !LEFT(m.XX_System.Modul,7)=="XXF000_",.NULL.,EVAL("m.XX_SrvSeznam.CVPFiles."+m.XX_System.Modul)),;
                            m.lcPom)

          IF !ISNULL(m.loEngine)
             liy=m.liy+1
             DIME This.aEFRX(m.liy,2)
             This.aEFRX(m.liy,1)=m.loEngine.Engine
             This.aEFRX(m.liy,2)=m.loEngine
          ENDIF
      NEXT
      This.iCount=m.liy
      RELE m.loErrObj
      RETURN m.liy
   ENDPROC

   PROCEDURE InitEngines()
      LOCAL lii
      FOR lii=1 TO This.iCount
          =This.InitEngine(This.aEFRX(m.lii,2))
      NEXT
   ENDPROC
ENDDEFINE


****************************************************************
* Definice tridy rozhrani pro export reportu 
****************************************************************
DEFINE CLASS __CFRX AS CUSTOM
   Name="__CFRX"

   Version="0.1.0"   && Version of EFRX interface
   Caption="" && Popis
   Engine="" && Kod rozhrani
   Path="" && FullPath to Interface
   EPath="" && FullPath to executive modules
   
   PreviewAllowed=.F. && Priznak, zda utilita umoznuje vlastni Preview
   PrintAllowed=.F.   && Priznak, zda utilita umoznuje vlastni Print
   AutoOpenAllowed=.F. && Priznak, zda utilita umoznuje AutoOpen

   EmailAllowed=.F. && Priznak, zda utilita umoznuje odeslani E-mailem
   WMAllowed=.F. && Priznak, zda utilita umoznuje WaterMark

   NativeProgress=.F. && Priznak, zda utilita ma vlastni teplomer

   ChangeProgressAllowed=.F. && Priznak, zda se misto vlastniho teplomeru DA volat vlastni udalost
   ChangeProgress=.F. && Priznak, zda se misto vlastniho teplomeru MA volat udalost EFRX_Progress
   
   PageRange=_EFRX_PR_None
      
   oHost=.NULL. && Odkaz na objekt exportni utility (je-li)
   oForm=.NULL. && Odkaz na objekt formulare Preview

   nError=0 && Cilo chyby

   ADD OBJECT EMAIL AS __CFRX_EMAIL
   ADD OBJECT WM AS __CFRX_WM
   ADD OBJECT PRV AS __CFRX_PRV
   ADD OBJECT PICT AS __CFRX_PICT
   
   PROCEDURE Error(nError,cMethod,nLine) && Chybova rutina
      * nError  - Cislo chyby
      * cMethod - Nazev metody ve ktere doslo k chybe
      * nLine   - Cislo radku na kterem doslo k chybe
      This.nError=nError

      LOCAL lii,lcCProg,lcPom,lcMth
         * Pak zarvi, nebot jde o chybu mimo provadeni
         lii=0
         lcCProg="A"
         lcPom=""
         DO WHILE !EMPTY(m.lcCProg)
            lii=m.lii+1  && Inkrementuj citac
            lcCProg=PROGRAM(m.lii)   && Nazev programu
            lcPom=m.lcPom+CHR(9)+m.lcCProg+CRLF
     
         ENDDO

         =XX_System.OPT.Add(IIF(EMPTY(m.XX_System.Modul) OR !LEFT(m.XX_System.Modul,7)=="XXF000_",.NULL.,EVAL("m.XX_SrvSeznam.CVPFiles."+m.XX_System.Modul)),;
                           CHR(9)+"E: "+LTRIM(STR(m.nError,11))+" M: "+m.cMethod+" L: "+LTRIM(STR(m.nLine,11))+CRLF+;
                           CHR(9)+MESSAGE()+CRLF+CHR(9)+MESSAGE(1)+CRLF+;
                           m.lcPom)

         loErrObj=This
         RETURN && A vyskoc ven
   ENDPROC

   PROCEDURE ResetError()
      This.nError=0
   ENDPROC

   PROCEDURE Destroy()
      This.ReleaseHost()
      This.oForm=.NULL.
   ENDPROC

   PROCEDURE GetOuts(laOuts)
      *@laOuts - Matice definovanych vystupu
      RETURN 0
   ENDPROC

   PROCEDURE Print(loReport) && Provede tisk reportu
      * loReport - Objekt reportu
      RETURN _EFRX_OK
   ENDPROC

   PROCEDURE Export(lcID,loReport) && Provede export reportu
      * lcID     - ID vystupu rozhrani
      * loReport - Objekt reportu
      RETURN _EFRX_OK
   ENDPROC

   PROCEDURE Preview(loReport) && Zavola preview reportu
      * loReport - Objekt reportu
      RETURN _EFRX_OK
   ENDPROC

   PROCEDURE TestHost() && Otestuje, zda je mozno vytvorit engine
   ENDPROC

   PROCEDURE CreateHost() && Vytvori hostitelsky objekt exportni utility
   ENDPROC

   PROCEDURE ReleaseHost() && Uvolni hostitelsky objekt exportni utility
      This.oHost=.NULL.
   ENDPROC

   PROCEDURE GetVersion() && Vrati verzi report enginu
      RETURN ""
   ENDPROC

   PROCEDURE SendEmail(loReport) && Zavola odeslani E-mailu
      * loReport - Objekt reportu
      RETURN _EFRX_OK
   ENDPROC

ENDDEFINE


****************************************************************
* Definice tridy pro urceni moznosti Prveiew EFRX interface
****************************************************************
DEFINE CLASS __CFRX_PRV AS CUSTOM
   Name="__CFRX_PRV"
   UpdateModeAllowed=.F. && Priznak, zda utilita umoznuje Update mod
ENDDEFINE

****************************************************************
* Definice tridy pro urceni moznosti EMAILu EFRX interface
****************************************************************
DEFINE CLASS __CFRX_EMAIL AS CUSTOM
   Name="__CFRX_EMAIL"
   AuthorizedAllowed=.F. && Priznak, zda utilita umoznuje odeslani E-mailem - autorizovany pristup
   BodyFromFileAllowed=.F. && Priznak, zda telo emailu muze byt soubor
   CCAllowed=.F. && Carbon copy allowed
   BCCAllowed=.F. && Bicarbon copy allowed
   BodyAllowed=.F. && Body allowed

   TimeOutAllowed=.F. && TimeOut allowed
   
   EngineAllowed=.F.
   SMTPAllowed=.F.
   MAPIAllowed=.F.

   AMethodAllowed=.F. && Athorization method allowed
ENDDEFINE

****************************************************************
* Definice tridy  pro urceni moznosti tvorby obrazku
****************************************************************
DEFINE CLASS __CFRX_PICT AS CUSTOM
   Name="__CFRX_PICT"

   bppAllowed=.F. && Bit per pixel
   JPQAllowed=.F. && JPEG Quality
   GrayScaleAllowed=.F. && GrayScale Flag
   ThumbnailAllowed=.F.
ENDDEFINE


****************************************************************
* Definice tridy pro urceni moznosti WM EFRX interface
****************************************************************
DEFINE CLASS __CFRX_WM AS CUSTOM
   Name="__CFRX_WM"
   HTMLAllowed=.F. && Priznak, zda utilita umoznuje definovat WM pomoci HTML
   PictureAllowed=.F. && Priznak, zda utilita umoznuje definovat WM pomoci obrazku
ENDDEFINE


****************************************************************
* Definice tridy pro predani informaci o reportu
****************************************************************
DEFINE CLASS __cReport AS CUSTOM
   Name="__cReport"

   * Internal report properties
   oCallBack=.NULL. && Objekt pro volani hookovacich metod
   RFile="" && Umisteni a nazev reportu
   OFile="" && Vystupni soubor
   Caption="" && Popis reportu - titulek
   PrinterName=""
   ErrNo=_EFRX_OK && Cislo chyby interface po tisku
   TempDirectory="" && Pracovni adresar
   AutoOpen=.F. && Priznak Auto otevreni vytvoreneho dokumentu
   Silent=.F.
   Progress=.F.
   ToEmail=.F. && Priznak, automatickeho odeslani E-mailem

   Printed=.F. && Priznak, zda byl report vytisten
   Exported=.F. && Priznak, zda byl report exportovan/ulozen

   Lang="" && Language

   * Basic VFP report properties
   cFor=""
   lSummary=.F.
   cScope=""
   cWhile=""
   lPlain=.F.
   nInitialRecord=0
   cHeadingText=""

   CodePage=CPCURRENT()
   
   SPage=1
   EPage=9999
   SEPage="" && Enhanced pages range


   * Enhanced document properties
   Author=""
   Title=""
   Subject=""
   KeyWords=""
   Description=""
   
   Creator=""
   Producer=""
   
   Comments=""
   Category=""
   Manager=""
   Company=""

   OPassword="" && Owner
   UPassword="" && User
   wPassword="" && for write


   SplitDocument=0 && Number of page to one document
   nLeftMargin=0 && in Pixels
   nTopMargin=0 && in Pixels

   ADD OBJECT PRV AS __cReport_PRV
   ADD OBJECT PDF AS __cReport_PDF
   ADD OBJECT WM AS __cReport_WM
   ADD OBJECT EMAIL AS __cReport_EMAIL
   ADD OBJECT PICT AS __cReport_PICT

ENDDEFINE


****************************************************************
* Definice tridy vlastnosti pro tvorbu obrazku
****************************************************************
DEFINE CLASS __cReport_PICT AS CUSTOM
   Name="__cReport_PICT"

   bpp=16 && Bit per pixel
   JPQ=90 && JPEG Quality
   GrayScale=.F. && GrayScale Flag
   ThumbnailWidth=0
   ThumbnailHeight=0
   
   PROCEDURE CopyProps(loSrc)
      * loSrc - Source object
      This.bpp=m.loSrc.bpp
      This.JPQ=m.loSrc.JPQ
      This.GrayScale=m.loSrc.GrayScale
      This.ThumbnailWidth=m.loSrc.ThumbnailWidth
      This.ThumbnailHeight=m.loSrc.ThumbnailHeight
   ENDPROC
ENDDEFINE


****************************************************************
* Definice tridy vlastnosti pro preview
****************************************************************
DEFINE CLASS __cReport_PRV AS CUSTOM
   Name="__cReport_PRV"

   AsTopLevel=.F. && Priznak, zda se ma spustit formular AsTopLevel
   WindowType=1
   Scale=100 && V %
   UpdateMode=.F. && Priznak UpdateModu - zmeny
   
   PROCEDURE CopyProps(loSrc)
      * loSrc - Source object
      This.AsTopLevel=m.loSrc.AsTopLevel
      This.WindowType=m.loSrc.WindowType
      This.Scale=m.loSrc.Scale
      This.UpdateMode=m.loSrc.UpdateMode
   ENDPROC
ENDDEFINE

****************************************************************
* Definice tridy vlastnosti pro tvorbu PDF
****************************************************************
DEFINE CLASS __cReport_PDF AS CUSTOM
   Name="__cReport_PDF"

   lPrintDocument=.T.
   lModifyDocument=.F.
   lCopyTextAndGraphics=.T.
   lAddOrModifyAnnotations=.F.
   lIncludeFont=.T.

   BitmapQuality=100
   Compress=.T.
   CompressBitmaps=.T.
   Encrypt=.F.
   JPEGQuality=90
   Margin=0.25
   Additive=.F.

   PROCEDURE CopyProps(loSrc)
      * loSrc - Source object
      This.lPrintDocument=m.loSrc.lPrintDocument
      This.lModifyDocument=m.loSrc.lModifyDocument
      This.lCopyTextAndGraphics=m.loSrc.lCopyTextAndGraphics
      This.lAddOrModifyAnnotations=m.loSrc.lAddOrModifyAnnotations
      This.lIncludeFont=m.loSrc.lIncludeFont

      This.BitmapQuality=m.loSrc.BitmapQuality
      This.Compress=m.loSrc.Compress
      This.CompressBitmaps=m.loSrc.CompressBitmaps
      This.Encrypt=m.loSrc.Encrypt
      This.JPEGQuality=m.loSrc.JPEGQuality
      This.Margin=m.loSrc.Margin
      This.Additive=m.loSrc.Additive

   ENDPROC
ENDDEFINE


****************************************************************
* Definice tridy vlastnosti pro tvorbu water mark
****************************************************************
DEFINE CLASS __cReport_WM AS CUSTOM
   Name="__cReport_WM"

   * Watter mark
   BackColor=-1
   ForeColor=-1
   FontName=""
   FontSize=-1
   FontStyle=""
   RotationAngle=-1
   Text=""
 
   HTML="" && Ma prednost pro HTML

   PictureFile=""
   PictureTransparency=0
   PictureStretch=0

   PROCEDURE CopyProps(loSrc)
      * loSrc - Source object
      This.BackColor=m.loSrc.BackColor
      This.ForeColor=m.loSrc.ForeColor
      This.FontName=m.loSrc.FontName
      This.FontSize=m.loSrc.FontSize
      This.FontStyle=m.loSrc.FontStyle
      This.RotationAngle=m.loSrc.RotationAngle
      This.Text=m.loSrc.Text
      This.HTML=m.loSrc.HTML

      This.PictureFile=m.loSrc.PictureFile
      This.PictureTransparency=m.loSrc.PictureTransparency
      This.PictureStretch=m.loSrc.PictureStretch

   ENDPROC
ENDDEFINE



****************************************************************
* Definice tridy vlastnosti pro tvorbu emailu
****************************************************************
DEFINE CLASS __cReport_EMAIL AS CUSTOM
   Name="__cReport_EMAIL"

   Subject=""
   Body=" " && Specifies the Body Text of the email.
   Priority="2" && Priority

   FromAddress="" && Specifies the From Address for the email and is required.
   FromName="" && Specifies the From Name for the email and is required.

   AuthorizationType=_EFRX_ASMTP_No && Specifies the SMTP Authorization Type. 0 = none (_EFRX_ASMTP_No), 1 = Login Required (_EFRX_ASMTP_Yes)
   Engine=_EFRX_EMAILE_SMTP && Engine for sending e-mail

   Host="" && Specifies the name of the SMTP Host and must be specified in order to send an email.
   Port=25 && Specifies the Port for the SMTP Server if required. Default is 0 and not used.
   TimeOut=60 && TimeOut for SMTPserver

   EHost="" && (authorization) Specifies the name of the SMTP Host and must be specified in order to send an email.
   EPort=25 && (authorization) Specifies the Port for the SMTP Server if required. Default is 0 and not used.
   ETimeOut=60 && (authorization) TimeOut for SMTPserver
   Password="" && (authorization) Specifies the Password for logging into an SMTP Server when using Authentication Type =1.
   UserID="" && (authorization) Specifies the UserID for logging into an SMTP Server when using Authentication Type = 1.
   AMethod="" && authorization method PLAIN/MD5/....

   AutoWrap=76 && Number characters on row
   CharSet=""

   ReturnReceiptAddr="" && ???
   ReplyToAddr ="" && Reply Adress

   MessageFormat=_EFRX_Body_Text
   MessageFile=""

   Separator=";" && Separator for address
   
   ShowDialog=.F. && Flag of show Message dialog if any information missed

   * Internal Array of Recipients/CC/BCC/Files
   DIME aRecipients(1),aRecipientsE(1),aCCs(1),aCCsE(1),aBCCs(1),aBCCsE(1),aFiles(1),aFilesE(1)
   iRecipient=0
   iCC=0
   iBCC=0
   iFile=0


   PROCEDURE CopyProps(loSrc)
      * loSrc - Source object
      LOCAL liRecipient,liCC,liBCC,liFile

      This.Subject=m.loSrc.Subject
      This.Body=m.loSrc.Body

      This.FromAddress=m.loSrc.FromAddress
      This.FromName=m.loSrc.FromName

      This.ReturnReceiptAddr=m.loSrc.ReturnReceiptAddr
      This.ReplyToAddr =m.loSrc.ReplyToAddr

      This.AuthorizationType=m.loSrc.AuthorizationType
      This.Engine=m.loSrc.Engine

      This.Host=m.loSrc.Host
      This.Port=m.loSrc.Port
      This.TimeOut=m.loSrc.TimeOut

      This.EHost=m.loSrc.EHost
      This.EPort=m.loSrc.EPort
      This.ETimeOut=m.loSrc.ETimeOut
      This.Password=m.loSrc.Password
      This.UserID=m.loSrc.UserID

      This.AutoWrap=m.loSrc.AutoWrap
      This.Priority=m.loSrc.Priority
      This.CharSet=m.loSrc.CharSet
      This.ShowDialog=m.loSrc.ShowDialog

      This.Separator=m.loSrc.Separator

      STORE m.loSrc.iRecipient TO This.iRecipient,liRecipient
      STORE m.loSrc.iCC TO This.iCC,liCC
      STORE m.loSrc.iBCC TO This.iBCC,liBCC
      STORE m.loSrc.iFile TO This.iFile,liFile

      DIME This.aRecipients(IIF(m.liRecipient>0,m.liRecipient,1)),This.aRecipientsE(IIF(m.liRecipient>0,m.liRecipient,1))
      DIME This.aCCs(IIF(m.loSrc.iCC>0,m.loSrc.iCC,1)),This.aCCsE(IIF(m.loSrc.iCC>0,m.loSrc.iCC,1))
      DIME This.aBCCs(IIF(m.loSrc.iBCC>0,m.loSrc.iBCC,1)),This.aBCCsE(IIF(m.loSrc.iBCC>0,m.loSrc.iBCC,1))
      DIME This.aFiles(IIF(m.loSrc.iFile>0,m.loSrc.iFile,1)),This.aFilesE(IIF(m.loSrc.iFile>0,m.loSrc.iFile,1))

      =ACOPY(m.loSrc.aRecipients,This.aRecipients)
      =ACOPY(m.loSrc.aCCs,This.aCCs)
      =ACOPY(m.loSrc.aBCCs,This.aBCCs)
      =ACOPY(m.loSrc.aFiles,This.aFiles)

      =ACOPY(m.loSrc.aRecipientsE,This.aRecipientsE)
      =ACOPY(m.loSrc.aCCsE,This.aCCsE)
      =ACOPY(m.loSrc.aBCCsE,This.aBCCsE)
      =ACOPY(m.loSrc.aFilesE,This.aFilesE)
   ENDPROC


   PROCEDURE AddRecipient(lcName,lcEmail,liType) && Add recipient to internal list
      * lcName  - Name of recipient
      * lcEmail - E-mail of recipient
      * liType  - Typ of recipient: 1-Recipient, 2-CC, 3-BCC
      LOCAL lcExact,lii
      lcExact=SET("EXACT")
      SET EXACT ON
      lcEmail=ALLT(m.lcEmail)
      lcName=ALLT(m.lcName)

      IF m.liType=_EFRX_Rcp
         lii=ASCAN(This.aRecipientsE,m.lcEmail)
         IF m.lii=0
            STORE This.iRecipient+1 TO lii,This.iRecipient
            DIME This.aRecipients(m.lii),This.aRecipientsE(m.lii)
            This.aRecipientsE(m.lii)=m.lcEmail
         ENDIF
         This.aRecipients(m.lii)=m.lcName
      ELSE
         IF m.liType=_EFRX_Rcp_cc
            lii=ASCAN(This.aCCsE,m.lcEmail)
            IF m.lii=0
               STORE This.iCC+1 TO lii,This.iCC
               DIME This.aCCs(m.lii),This.aCCsE(m.lii)
               This.aCCsE(m.lii)=m.lcEmail
            ENDIF
            This.aCCs(m.lii)=m.lcName
         ELSE
            lii=ASCAN(This.aBCCsE,m.lcEmail)
            IF m.lii=0
               STORE This.iBCC+1 TO lii,This.iBCC
               DIME This.aBCCs(m.lii),This.aBCCsE(m.lii)
               This.aBCCsE(m.lii)=m.lcEmail
            ENDIF
            This.aBCCs(m.lii)=m.lcName
         ENDIF
      ENDIF
      IF m.lcExact=="OFF"
         SET EXACT OFF
      ENDIF
   ENDPROC


   PROCEDURE DeleteRecipient(lcEmail,liType) && Delete recipient to internal list
      * lcEmail - E-mail of recipient
      * liType  - Typ of recipient: 0-Recipient, 1-CC, 2-BCC
      LOCAL lcExact,lii
      lcExact=SET("EXACT")
      SET EXACT ON
      lcEmail=ALLT(m.lcEmail)
      lcName=ALLT(m.lcName)

      IF m.liType=_EFRX_Rcp
         lii=ASCAN(This.aRecipientsE,m.lcEmail)
         IF m.lii>0
            STORE This.iRecipient-1 TO lii,This.iRecipient
            IF m.lii>0
               DIME This.aRecipients(m.lii),This.aRecipientsE(m.lii)
            ELSE
               STORE "" TO This.aRecipients(1),This.aRecipientsE(1)
            ENDIF
         ENDIF
      ELSE
         IF m.liType=_EFRX_Rcp_cc
            lii=ASCAN(This.aCCsE,m.lcEmail)
            IF m.lii>0
               STORE This.iCC-1 TO lii,This.iCC
               IF m.lii>0
                  DIME This.aCCs(m.lii),This.aCCEs(m.lii)
               ELSE
                  STORE "" TO This.aCCs(1),This.aCCEs(1)
               ENDIF
            ENDIF
         ELSE
            lii=ASCAN(This.aBCCEs,m.lcEmail)
            IF m.lii>0
               STORE This.iBCC-1 TO lii,This.iBCC
               IF m.lii>0
                  DIME This.aBCCs(m.lii),This.aBCCsE(m.lii)
               ELSE
                  STORE "" TO This.aBCCs(1),This.aBCCsE(1)
               ENDIF
            ENDIF
         ENDIF
      ENDIF
      IF m.lcExact=="OFF"
         SET EXACT OFF
      ENDIF
   ENDPROC


   PROCEDURE DeleteAllRecipients(liType) && Delete all recipients from internal list
      * liType  - Typ of recipient: 0-Recipient, 1-CC, 2-BCC
      IF m.liType=_EFRX_Rcp
         This.iRecipient=0
         DIME This.aRecipients(1),This.aRecipientsE(1)
         STORE "" TO This.aRecipients(1),This.aRecipientsE(1)
      ELSE
         IF m.liType=_EFRX_Rcp_cc
            This.iCC=0
            DIME This.aCCs(1),This.aCCsE(1)
            STORE "" TO This.aCCs(1),This.aCCsE(1)
         ELSE
            This.iBCC=0
            DIME This.aBCCs(1),This.aBCCsE(1)
            STORE "" TO This.aBCCs(1),This.aBCCsE(1)
         ENDIF
      ENDIF
   ENDPROC

   PROCEDURE AddFile(lcName,lcFile) && Add file to internal list
      * lcName - Name of File
      * lcFile - Path and file
      LOCAL lcExact,lii
      lcExact=SET("EXACT")
      SET EXACT ON
      lcFile=ALLT(m.lcFile)

      lii=ASCAN(This.aFilesE,m.lcFile)
      IF m.lii=0
         STORE This.iFile+1 TO lii,This.iFile
         DIME This.aFiles(m.lii),This.aFilesE(m.lii)
         This.aFilesE(m.lii)=m.lcFile
      ENDIF
      This.aFiles(m.lii)=ALLT(m.lcName)

      IF m.lcExact=="OFF"
         SET EXACT OFF
      ENDIF
   ENDPROC

   PROCEDURE DeleteFile(lcFile) && Delete file from internal list
      * lcFile - Path and file
      LOCAL lcExact,lii
      lcExact=SET("EXACT")
      SET EXACT ON
      lcFile=ALLT(m.lcFile)

      lii=ASCAN(This.aFilesE,m.lcFile)
      IF m.lii>0
         =ADEL(This.aFiles,m.lii)
         =ADEL(This.aFilesE,m.lii)
         STORE This.iFile-1 TO lii,This.iFile
         IF m.lii>0
            DIME This.aFiles(m.lii),This.aFilesE(m.lii)
         ELSE
            STORE "" TO This.aFiles(1),This.aFilesE(1)
         ENDIF
      ENDIF
      IF m.lcExact=="OFF"
         SET EXACT OFF
      ENDIF
   ENDPROC

   PROCEDURE DeleteAllFiles() && Delete all files from internal list
      This.iFile=0
      DIME This.aFiles(1),This.aFilesE(1)
      STORE "" TO This.aFiles(1),This.aFilesE(1)
   ENDPROC

ENDDEFINE


****************************************************************
* Definice tridy callback objektu
* Tato trida je pouze ilustrativni
* Dulezite jsou metody automaticky volane interfaces
****************************************************************
DEFINE CLASS __cCallBack AS CUSTOM
   Name="__cCallBack"

   PROCEDURE EFRX_BeforePreview(loHost,loForm)
      * loHost - Odkaz na hostitelsky objekt
      * loForm - Odkaz na formular kde bude preview
   ENDPROC

   PROCEDURE EFRX_AfterPreview(loHost,loForm)
      * loHost - Odkaz na hostitelsky objekt
      * loForm - Odkaz na formular kde bude preview
   ENDPROC

   PROCEDURE EFRX_BeforeExport(loHost)
      * loHost - Odkaz na hostitelsky objekt
   ENDPROC

   PROCEDURE EFRX_BeforePrint(loHost)
      * loHost - Odkaz na hostitelsky objekt
   ENDPROC

   PROCEDURE EFRX_NextReport(loHost)
      * loHost - Odkaz na hostitelsky objekt
   ENDPROC

   PROCEDURE EFRX_Progress(loHost,loPPar)
      * loHost - Odkaz na hostitelsky objekt
      * loPPar - Odkaz na objet s parametry pro progress
   ENDPROC

   PROCEDURE EFRX_BeforeEmail(loHost)
      * loHost - Odkaz na hostitelsky objekt
   ENDPROC

ENDDEFINE
