#INCLUDE "efrx.h"

#DEFINE cnLOG_PIXELS_Y 90

#DEFINE __xfrxlib_DM_Disable -1
#DEFINE __xfrxlib_DM_Hide     0
#DEFINE __xfrxlib_DM_Show     1

PROCEDURE EFRX_GetInterface(loHost) && Vrati objekt Interface
* @loHost - (Out) - vrati objekt Interface
LOCAL lcPath,lcProg
loHost=CREATEOBJECT("_XFRX")
* Nastav cestu k interface
lcProg=PROGRAM()
lcPath=SYS(16)
lcPath=SUBST(m.lcPath,AT(m.lcProg,m.lcPath)+LEN(m.lcProg)+1)
loHost.Path=IIF(RAT("\",m.lcPath)>0,LEFT(m.lcPath,RAT("\",m.lcPath)),m.lcPath)
RETURN

****************************************************************
* Definice tridy rozhrani pro XFRX
****************************************************************
DEFINE CLASS _XFRX AS __CFRX
   Name="_XFRX"
   
   Engine="XFRX" && Kod rozhrani
   PreviewAllowed=.T. && Priznak, zda utilita umoznuje vlastni Preview
   AutoOpenAllowed=.T. && Priznak, zda utilita umoznuje AutoOpen
   PageRange=_EFRX_PR_Enhanced
   NativeProgress=.F. && Priznak, zda utilita ma vlastni teplomer
   ChangeProgressAllowed=.T. && Priznak, zda se misto vlastniho teplomeru DA volat vlastni udalost

   PpIY=96
  
   oFSetting=.NULL.
   oMTSetting=.NULL.
   oDMSetting=.NULL.
   oReport=.NULL. && Object to report reference
   oProgress=.NULL.

   PRV.UpdateModeAllowed=.T.

   PICT.bppAllowed=.T. && Bit per pixel
   PICT.JPQAllowed=.T. && JPEG Quality
   PICT.GrayScaleAllowed=.F. && GrayScale Flag
   PICT.ThumbnailAllowed=.T.

   PROCEDURE Init
      This.Caption="XFRX"

      DECLARE INTEGER GetDC           IN WIN32API INTEGER iHDC
      DECLARE INTEGER ReleaseDC       IN WIN32API INTEGER ihwnd,INTEGER iHDC
      DECLARE INTEGER GetDeviceCaps   IN WIN32API INTEGER iHDC, INTEGER iIndex

      LOCAL lihwnd,liHDC
      lihwnd = GetActiveWindow() && Get handle active window
      liHDC  = GetDC(m.lihwnd) && Get DC okna
      This.PpIY=GetDeviceCaps(m.liHDC, cnLOG_PIXELS_Y)
      =ReleaseDC(m.lihwnd,m.liHDC) && Release handle

   ENDPROC

   PROCEDURE TestHost() &&  Otestuje, zda je mozno vytvorit engine
      RETURN (LEN(SYS(2000,This.EPath+"xfrx.app"))>0 OR LEN(SYS(2000,This.EPath+"xfrx.frx"))>0) AND ;
              LEN(SYS(2000,This.EPath+"hndlib.dll"))>0 AND ;
              LEN(SYS(2000,This.EPath+"xfrxlib.fll"))>0 AND ;
              LEN(SYS(2000,This.EPath+"zlib.dll"))>0 
   ENDPROC

   PROCEDURE CreateHost() && Vytvori hostitelsky objekt exportni utility
      LOCAL loHost,llErr
      IF !UPPER(This.EPath+"xfrxlib\xfrxlib.vcx")$UPPER(SET("CLASSLIB"))
         This.ResetError()
         * Pokus se nalinkovat VCX knihovnu
         SET CLASSLIB TO (This.EPath+"xfrxlib\xfrxlib.vcx") ADDITIVE
         llErr=This.nError>0
      ENDIF

      IF !m.llErr
         This.ResetError()
         loHost=XFRX("XFRX#INIT")
         llErr=This.nError>0
         IF !m.llErr
            This.oHost=m.loHost
         ENDIF
      ENDIF
      This.ResetError()
      RETURN !m.llErr
   ENDPROC


   PROCEDURE SetHost(loHost,loReport,lcID) && Nastavi volby hostitele
      * loHost   - Objekt hostitele
      * loReport - Objekt informaci o reportu
      * lcID     - Druh vystupu
      loHost.SetAuthor(m.loReport.Author)
      loHost.SetTitle(m.loReport.Title)
      loHost.SetSubject(m.loReport.Subject)
      loHost.SetKeywords(m.loReport.Keywords)
      loHost.SetOtherParams("COMMENTS",m.loReport.Description)


      * PDF only properties
      IF m.lcID=="PDF"
         m.loHost.SetCreator(m.loReport.Creator)
         m.loHost.SetProducer(m.loReport.Producer)

         m.loHost.SetPasswords(m.loReport.OPassword,m.loReport.UPassword)
         m.loHost.SetPermissions(m.loReport.PDF.lPrintDocument, ;
                               m.loReport.PDF.lModifyDocument, ;
                               m.loReport.PDF.lCopyTextAndGraphics, ;
                               m.loReport.PDF.lAddOrModifyAnnotations)

*         loHost.Additive=loReport.Additive
      ENDIF

      * Word only properties
      IF m.lcID=="DOC" OR m.lcID=="FDOC"
         m.loHost.SetComments(m.loReport.Comments)
         m.loHost.SetCategory(m.loReport.Category)
         m.loHost.SetManager(m.loReport.Manager)
         m.loHost.SetCompany(m.loReport.Company)
         m.loHost.SetPasswords(m.loReport.UPassword, m.loReport.WPassword, .F.)

         * Split document
         IF m.loReport.SplitDocument>0
            m.loHost.SplitDocument(m.loReport.SplitDocument)
         ENDIF
      ENDIF

      IF m.lcID=="HTML"
   *      m.loHost.nLeftMargin=m.loReport.nLeftMargin
         m.loHost.ShrinkHeight((m.loReport.nTopMargin/This.PpIY)*10000)
      ENDIF

      * Start Page/End Page or List of Pages
      IF m.loReport.SPage>0 AND m.loReport.EPage>0
         m.loHost.SetPageRange(m.loReport.SPage,m.loReport.EPage)
      ENDIF

      IF !EMPTY(m.loReport.SEPage) AND m.loReport.SPage<=0 AND m.loReport.EPage<=0
         m.loHost.SetPageRange(m.loReport.SEPage)
      ENDIF

      IF m.loReport.Progress
         This.oReport=m.loReport
         This.oProgress=CREATEOBJECT("_XFRX_Progress")
         m.loHost.SetProgressObj(This,2)
      ENDIF
   ENDPROC

   PROCEDURE GetOuts(laOuts)
      *@laOuts - Matice definovanych vystupu
      LOCAL lii,lcVersion
      DIME laOuts(20,4)
      lcVersion=This.GetVersion()
      lii=AT(" ",m.lcVersion)
      lcVersion=LEFT(m.lcVersion,m.lii-1)


      lii=1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_TXT)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="PLAIN"
      laOuts(m.lii,4)="txt"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_HTML)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="HTML"
      laOuts(m.lii,4)="html"

      lii=m.lii+1
      laOuts(lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_HTA)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="MHT"
      laOuts(m.lii,4)="mht"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_PDF)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="PDF"
      laOuts(m.lii,4)="pdf"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_RTF)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="RTF"
      laOuts(m.lii,4)="rtf"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_XML)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="XML"
      laOuts(m.lii,4)="xml"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_XFF)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="XFF"
      laOuts(m.lii,4)="xff"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_DOC)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="DOC"
      laOuts(m.lii,4)="doc"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_FDOC)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="FDOC"
      laOuts(m.lii,4)="doc"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_XLS)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="XLS"
      laOuts(m.lii,4)="xls"

      IF m.lcVersion>="11.3.0000"
         lii=m.lii+1
         laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_ODT)
         laOuts(m.lii,2)=This.Engine
         laOuts(m.lii,3)="ODT"
         laOuts(m.lii,4)="odt"
      ENDIF

      IF m.lcVersion>="12.0.0000"
         lii=m.lii+1
         laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_FODT)
         laOuts(m.lii,2)=This.Engine
         laOuts(m.lii,3)="FODT"
         laOuts(m.lii,4)="odt"

         lii=m.lii+1
         laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_ODS)
         laOuts(m.lii,2)=This.Engine
         laOuts(m.lii,3)="ODS"
         laOuts(m.lii,4)="ods"

         lii=m.lii+1
         laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_FODS)
         laOuts(m.lii,2)=This.Engine
         laOuts(m.lii,3)="FODS"
         laOuts(m.lii,4)="ods"
      ENDIF

      IF m.lcVersion>="12.3.0000"
         lii=m.lii+1
         laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_XPS)
         laOuts(m.lii,2)=This.Engine
         laOuts(m.lii,3)="XPS"
         laOuts(m.lii,4)="xps"
      ENDIF


      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_BMP)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="BMP"
      laOuts(m.lii,4)="bmp"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_TIFF)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="TIFF"
      laOuts(m.lii,4)="tiff"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_GIF)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="GIF"
      laOuts(m.lii,4)="gif"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_JPEG)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="JPEG"
      laOuts(m.lii,4)="jpeg"

      lii=m.lii+1
      laOuts(m.lii,1)=m.XX_Res.ReadString(m.XX_System.CVPLocID,_EFRX_Out_PNG)
      laOuts(m.lii,2)=This.Engine
      laOuts(m.lii,3)="PNG"
      laOuts(m.lii,4)="png"
      DIME laOuts(m.lii,4)

      RETURN ALEN(m.laOuts,1)
   ENDPROC

   PROCEDURE Export(lcID,loReport) && Provede tisk/export reportu
      * lcID     - ID vystupu rozhrani
      * loReport - Objekt reportu

      LOCAL lcPath,loHost,llErr,liErr,lcFile,lcScope,lcTFile,loOW,lcPom,lii

      lcPath=SET("PATH")
      SET PATH TO (This.EPath)

      IF ISNULL(This.oHost)
         llErr=!This.CreateHost()
      ENDIF
      loHost=This.oHost
      lcFile=m.loReport.OFile
      lcTFile=SYS(2023)+"\"+SYS(2015)+".xff"

      DO CASE
         CASE m.llErr && Dolo k chyb
              liErr=_EFRX_PrintFailed
             
         OTHERWISE
              This.SetHost(@m.loHost,@m.loReport,@m.lcID)
              =IIF(PEMSTATUS(m.loReport.oCallBack,"EFRX_BeforeExport",5),m.loReport.oCallBack.EFRX_BeforeExport(@m.loHost),.T.)

              lcScope=UPPER(ALLT(m.loReport.cScope))
              IF ((LEFT(m.lcScope,4)=="NEXT" AND !ISDIGIT(RIGHT(m.lcScope,1))) OR;
                  (LEFT(m.lcScope,6)=="RECORD" AND !ISDIGIT(RIGHT(m.lcScope,1)))) AND;
                 This.loReport.nInitialRecord>0
                 lcScope=m.lcScope+" "+LTRIM(STR(m.nInitialRecord,11))
              ENDIF

              liErr=m.loHost.SetParams(m.lcTFile, m.loReport.TempDirectory, !m.loReport.AutoOpen, , m.loReport.Silent , ,"XFF")
              IF m.liErr=0
                 llErr=!m.loHost.ProcessReport(m.loReport.RFile, m.loReport.cFor, m.loReport.lSummary, m.lcScope, m.loReport.cWhile , m.loReport.lPlain)

                 IF !m.llErr
                    =IIF(PEMSTATUS(m.loReport.oCallBack,"EFRX_NextReport",5),m.loReport.oCallBack.EFRX_NextReport(@m.loHost),.T.)
                 ENDIF


                 IF !m.llErr
                    loOW = m.loHost.Finalize()
                    IF !INLIST(m.lcID,"BMP","TIFF", "GIF", "JPEG", "PNG") 
                       liErr=m.loHost.SetParams(m.lcFile, m.loReport.TempDirectory, !m.loReport.AutoOpen, , m.loReport.Silent , ,m.lcID)
                       IF m.liErr=0
                          m.loHost.TransformReport(@m.loOW)
                       ENDIF
                    ELSE
                       IF m.lcID="TIFF"
                          m.loOW.SavePicture(m.lcFile,m.lcID,m.loHost.cPageScope,0,24)
                       ELSE
                          lii=RAT(".",m.lcFile)
                          IF m.lii>0
                             lcPom=SUBST(m.lcFile,m.lii)
                             lcFile=LEFT(m.lcFile,m.lii-1)
                          ELSE
                             lcPom=""
                          ENDIF
                          liy=0
                          FOR lii = 1 TO m.loOW.PageCount
                              IF _pageNoCheck(m.lii, m.loHost.cPageScope)
                                 liy=m.liy+1
                                 IF m.loReport.PICT.ThumbnailWidth=0 OR m.loReport.PICT.ThumbnailHeight=0
                                    m.loOW.SavePicture(m.lcFile+IIF(m.liy=1,"","_"+LTRIM(STR(m.liy,11)))+m.lcPom,m.lcID,m.lii,m.lii,m.loReport.PICT.bpp,m.loReport.PICT.JPQ)
                                 ELSE
                                    m.loOW.SavePicture(m.lcFile+IIF(m.liy=1,"","_"+LTRIM(STR(m.liy,11)))+m.lcPom,m.lcID,m.lii,m.lii,m.loReport.PICT.bpp,m.loReport.PICT.JPQ,m.loReport.PICT.ThumbnailWidth,m.loReport.PICT.ThumbnailHeight)
                                 ENDIF
                              ENDIF
                          NEXT
                       ENDIF
                    ENDIF
                 ENDIF
              ENDIF

              WAIT CLEAR

      ENDCASE
      STORE .NULL. TO This.oReport,This.oProgress,This.oHost
      RELE m.loOW,m.loHost


      SET PATH TO (m.lcPath)
      DELE FILE (m.lcTFile)
      DELE FILE (FORCEEXT(m.lcTFile,"fpt"))
      DELE FILE (FORCEEXT(m.lcTFile,"cdx"))

      loReport.ErrNo=m.liErr
      IF m.liErr=_EFRX_OK
         loReport.Exported=.T.
      ENDIF
      RETURN IIF(m.liErr=0,_EFRX_OK,_EFRX_PrintFailed)
   ENDPROC

   PROCEDURE Preview(loReport) && Zavola preview reportu
      * loReport - Objekt reportu
      LOCAL lcPath,loHost,llErr,liErr,lcTFile,loOW
      PUBLIC poXXF000

      lcPath=SET("PATH")
      SET PATH TO (This.EPath)

      IF ISNULL(This.oHost)
         llErr=!This.CreateHost()
      ENDIF
      loHost=This.oHost
      lcTFile=SYS(2023)+"\"+SYS(2015)+".xff"

      STORE CREATEOBJECT(IIF(m.loReport.PRV.AsTopLevel,"XFRXfrmPreviewATL","XFRXfrmPreview")) TO This.oForm,poXXF000
      poXXF000.Name="poXXF000"

      =IIF(PEMSTATUS(m.loReport.oCallBack,"EFRX_BeforePreview",5),m.loReport.oCallBack.EFRX_BeforePreview(@m.loHost,@m.poXXF000),.T.)

      DO CASE
         CASE m.llErr && Doslo k chybe
              liErr=_EFRX_PrintFailed
             
         OTHERWISE

              liErr=m.loHost.SetParams(m.lcTFile, m.loReport.TempDirectory, !m.loReport.AutoOpen, , m.loReport.Silent , ,"XFF")
              IF m.liErr=0
                 lcScope=UPPER(ALLT(m.loReport.cScope))
                 IF ((LEFT(m.lcScope,4)=="NEXT" AND !ISDIGIT(RIGHT(m.lcScope,1))) OR;
                     (LEFT(m.lcScope,6)=="RECORD" AND !ISDIGIT(RIGHT(m.lcScope,1)))) AND;
                    m.loReport.nInitialRecord>0
                    lcScope=m.lcScope+" "+LTRIM(STR(m.loReport.nInitialRecord,11))
                 ENDIF

                 llErr=!m.loHost.ProcessReport(m.loReport.RFile, m.loReport.cFor, m.loReport.lSummary, m.lcScope , m.loReport.cWhile , m.loReport.lPlain)

                 IF !m.llErr
                    IF ISNULL(This.oFSetting)
                       This.oFSetting=CREATEOBJECT(m.poXXF000.cntXFRX.ClsSetFind)
                    ENDIF
                    IF ISNULL(This.oMTSetting)
                       This.oMTSetting=CREATEOBJECT(m.poXXF000.cntXFRX.ClsSetMainToolbar)
                    ENDIF
                    IF ISNULL(This.oDMSetting)
                       This.oDMSetting=CREATEOBJECT(m.poXXF000.cntXFRX.ClsSetDM)
                    ENDIF

                    * Inicializace jazyka
                    poXXF000.cntXFRX.SetLanguage(m.loReport.Lang)
                    poXXF000.cntXFRX.iDM=IIF(m.loReport.PRV.UpdateMode,__xfrxlib_DM_Hide,__xfrxlib_DM_Disable)

                    poXXF000.cntXFRX.oFSetting=This.oFSetting
                    poXXF000.cntXFRX.oMTSetting=This.oMTSetting
                    poXXF000.cntXFRX.oDMSetting=This.oDMSetting

                    loHost.oDocumentWriter=.NULL.

                    loOW = xfrx("XFRX#DRAW")
                    IF m.loOW.openDocument(lcTFile)
                       liErr = m.loHost.SetParams(,,,,,,"CNT")
                       IF m.liErr = 0

                          m.loHost.SetOtherParams(m.poXXF000.cntXFRX)
                          m.loHost.TransformReport(@m.loOW)

                          =IIF(PEMSTATUS(m.loReport.oCallBack,"EFRX_NextReport",5),m.loReport.oCallBack.EFRX_NextReport(@m.loHost),.T.)

                          poXXF000.cntXFRX.nZoom=m.loReport.PRV.Scale
                          IF m.loReport.PRV.AsTopLevel
                    
                          ENDIF

                          m.poXXF000.Show(m.loReport.PRV.WindowType)
                       ENDIF
                    ENDIF
                 ENDIF
              ENDIF
      ENDCASE
      This.oForm=.NULL.
      This.oHost=.NULL.

      RELE m.poXXF000,m.loOW,m.loHost
      STORE .NULL. TO This.oReport,This.oProgress

      SET PATH TO (m.lcPath)
      DELE FILE (m.lcTFile)
      DELE FILE (FORCEEXT(lcTFile,"fpt"))
      DELE FILE (FORCEEXT(lcTFile,"cdx"))

      loReport.ErrNo=m.liErr
      RETURN IIF(m.liErr=0,_EFRX_OK,_EFRX_PrintFailed)
   ENDPROC

   PROCEDURE GetVersion() && Vrati verzi report enginu
      LOCAL lcPath,llErr,lcPom

      lcPath=SET("PATH")
      SET PATH TO (This.EPath)

      IF ISNULL(This.oHost)
         llErr=!This.CreateHost()
      ENDIF
      lcPom=This.oHost.GetVersion()
      This.oHost=.NULL.

      SET PATH TO (m.lcPath)
      RETURN IIF(m.llErr,"",m.lcPom)
   ENDPROC


   PROCEDURE UpdateProgress(ta,tb, tc)
      IF !This.oReport.ChangeProgressAllowed
         WAIT WINDOW "Page #: "+ALLT(STR(m.tb))+" Report #: "+ALLT(STR(m.ta))+" ("+ALLT(STR(m.tc))+"%)" NOWAIT 
      ELSE
         This.oProgress.Report=m.ta
         This.oProgress.Page=m.tb
         This.oProgress.Percent=m.tc
         This.oReport.oCallBack.EFRX_Progress(This,This.oProgress)
      ENDIF
   ENDPROC

ENDDEFINE

DEFINE CLASS _XFRX_Progress AS CUSTOM
   Name="_XFRX_Progress"
   Report=0
   Page=0
   Percent=0
ENDDEFINE