#INCLUDE "Files.h"

DEFINE CLASS _lstFiles AS DataEnvironment
   Name= "_lstFiles"
 
   lError=.F. && Priznak chyby
   List="" && Umisteni a nazev list souboru

   * provede registraci souboru
   PROCEDURE Register
      LPARAMETERS m.lcFile
      
      * lcFile - Umisteni a nazev souboru
      LOCAL m.lii, m.lcList, m.liErr
      IF EMPTY(This.List) && Pokud seznam neni definovan
         RETURN _lstFiles_ListNotDefine && Pak se vrat
      ENDIF
      m.lcFile=UPPER(ALLT(m.lcFile)) && Uprav nazev souboru
      IF FILE(This.List) && Pokud seznam existuje
         m.lcList="" && Nastav pocatecni stav
         m.liErr=This.Read(This.List, @m.lcList) && Nacti seznam
         IF m.liErr#_lstFiles_OK
            RETURN m.liErr
         ENDIF
      ELSE
         m.lcList=""
      ENDIF
      m.lii=AT(m.lcFile, m.lcList)
      IF m.lii=0 && Pokud souboru neni v seznamu
         * Pak ho tam pridej
         m.lcList=m.lcList+IIF(LEN(m.lcList)=0, "", _lstFiles_CRLF)+m.lcFile
         m.liErr=This.Save(This.List, @m.lcList, @m.lcFile)
         IF m.liErr#_lstFiles_OK
            RETURN m.liErr
         ENDIF
      ENDIF
      RETURN _lstFiles_OK
   ENDPROC

   * Provede odregistraci souboru
   PROCEDURE UnRegister
      LPARAMETERS m.lcFile

      * lcFile - Umisteni a nazev souboru
      LOCAL m.lii, m.lcList, m.liErr
      IF EMPTY(This.List) && Pokud seznam neni definovan
         RETURN _lstFiles_ListNotDefine && pak se vrat
      ENDIF
      m.lcFile=UPPER(ALLT(m.lcFile)) && Uprav nazev souboru
      IF !FILE(This.List) && Pokud seznam neexistuje
         RETURN _lstFiles_ListNotExist
      ENDIF
      m.lcList="" && Nastav pocatecni stav
      m.liErr=This.Read(This.List, @m.lcList) && Nacti seznam
      IF m.liErr#_lstFiles_OK
         RETURN m.liErr
      ENDIF

      m.lii=AT(m.lcFile, m.lcList)
      IF m.lii>0 && Pokud souboru je v seznamu
         m.lcList=STUFF(m.lcList, m.lii+IIF(m.lii=1, 0, -2), LEN(m.lcFile)+IIF(m.lii=1, 0, 2), "") && Smaz soubor ze seznamu
         m.liErr=This.Save(This.List, @m.lcList)
         IF m.liErr#_lstFiles_OK
            RETURN m.liErr
         ENDIF
      ENDIF
      RETURN _lstFiles_OK
   ENDPROC

   * Smaze vsechny soubory dle listu
   PROCEDURE DeleteFiles
      LOCAL m.lii, m.llDele, m.lcList, m.liy, m.liLast, m.lcFile

      IF EMPTY(This.List) && Pokud seznam neni definovan
         RETURN _lstFiles_ListNotDefine && pak se vrat
      ENDIF

      IF !FILE(This.List) && Pokud seznam neexistuje
         RETURN _lstFiles_ListNotExist
      ENDIF

      m.lcList="" && Nastav pocatecni stav
      m.liErr=This.Read(This.List, @m.lcList) && Nacti seznam
      IF m.liErr#_lstFiles_OK
         RETURN m.liErr
      ENDIF

      m.liy=OCCURS(_lstFiles_CRLF, m.lcList)
      m.lii=AT(_lstFiles_CRLF, m.lcList, m.liy)
      m.liLast=LEN(m.lcList)

      DO WHILE m.lii#0
         m.lii=AT(_lstFiles_CRLF, m.lcList, IIF(m.liy>0, m.liy, 1))
         m.lcFile=IIF(m.lii>0, SUBST(m.lcList, m.lii+2, m.liLast-m.lii+1), m.lcList)

         m.liLast=m.lii-1 && Tak abych byl na konci retezce
         m.liy=m.liy-1 && Dekrementuj citac
         IF EMPTY(m.lcFile) && Pokud je prazdny retezec
            m.lcList=STUFF(m.lcList, m.lii, 2, "") && Smaz prazdny ENTER ze seznamu
         ELSE
            This.lError=.F. && Pastav priznak, ze neni chyba
            DELE FILE (m.lcFile)
            IF !This.lError && Pokud nedoslo k chybe
               * Pak vymaz soubor ze seznamu
               m.lcList=STUFF(m.lcList, IIF(m.lii=0, 1, m.lii), LEN(m.lcFile)+2, "") && Smaz soubor ze seznamu
            ENDIF
         ENDIF
      ENDDO

      * a Nyni opet seznam uloz
      m.liErr=This.Save(This.List, @m.lcList)
      IF m.liErr#_lstFiles_OK
         RETURN m.liErr
      ENDIF
   ENDPROC
 
 
   PROCEDURE Error
      LPARAMETERS m.nError, m.cMethod, m.nLine
      * nError  - Cislo chyby
      * cMethod - Nazev metody
      * nLine   - Cislo radku
      
      IF UPPER(m.cMethod)="READ"
         This.lError=.T. && Nastav priznak chyby
      ELSE
         IF UPPER(m.cMethod)="SAVE"
            This.lError=.T. && Nastav priznak chyby
         ELSE
            IF UPPER(m.cMethod)="DELETEFILES"
               This.lError=.T. && Nastav priznak chyby
            ELSE
               DODEFAULT(m.nError, m.cMethod, m.nLine)
            ENDIF
         ENDIF
      ENDIF
   ENDPROC



   * Provede ulozeni seznamu
   PROCEDURE Save
      LPARAMETERS m.lcList, m.lcData, m.lcFile
      * lcList - Umisteni a nazev seznamu
      *@lcData - Data seznamu
      *@lcFile - Nazev souboru jez se ma ulozit 

      LOCAL ARRAY m.laFile(1, 2)
      IF ADIR(m.laFile, m.lcList, "ARHS")=0 && Pokud jeste neni
         m.laFile(1,2)=0 && Pak nastav 0 velikost
      ENDIF
      This.lError=.F.
      =IIF(PCOUNT()=3, STRTOFILE(IIF(m.laFile(1, 2)>0, _lstFiles_CRLF, "")+m.lcFile, m.lcList, .T.),;
                       STRTOFILE(m.lcData, m.lcList, .F.))
      RETURN IIF(This.lError, _lstFiles_NotSaveList, _lstFiles_OK)
   ENDPROC

   * Provede nacteni seznamu
   PROCEDURE Read
      LPARAMETERS m.lcList, m.lcData
      * lcList - Umisteni a nazev seznamu
      *@lcData - Data seznamu
      
      This.lError=.F.
      m.lcData=FILETOSTR(This.List)
      RETURN IIF(This.lError, _lstFiles_NotReadList, _lstFiles_OK)
   ENDPROC
ENDDEFINE


