#INCLUDE "krc001.h"
#INCLUDE "winbase.h"

EXTERNAL ARRAY laFunc
EXTERNAL ARRAY laFile


*********************************************************************
* procedura na deklaraci API funkci
*********************************************************************

*****************************************************************************
* procedury pro zavedeni komponent (DLL,FLL)
*****************************************************************************
*
*
*
*

*****************************************************************************
* zavedeni DLL funkce
*****************************************************************************
PROCEDURE LoadDllFunc(lcFunc)
LOCAL llErr
TRY
 &lcFunc.
CATCH
 m.llErr=.T.
ENDTRY 
RETURN !m.llErr && vrat priznak


*****************************************************************************
* zavedeni DLL funkce - seznam funkci
*****************************************************************************
PROCEDURE LoadDllFuncEx(laFunc)
LOCAL lii,llErr
FOR lii=1 TO ALEN(m.laFunc)
    TRY
     &laFunc(m.lii). && zaved dll funkci
    CATCH 
      m.llErr=.T.
    ENDTRY
    IF m.llErr && pokud to selhalo
       EXIT && pak vypadni
    ENDIF
NEXT

RETURN !m.llErr


*****************************************************************************
* zavedeni FLL knihovny
*****************************************************************************
PROCEDURE LoadLibrary(lcFile)
IF FindFile(@lcFile)
   LOCAL llErr
   TRY
    SET LIBRARY TO (m.lcFile) ADDITIVE && pripoj knihovnu
   CATCH 
     m.llErr=.T.
   ENDTRY
   RETURN !m.llErr && vrat priznak
ELSE
   RETURN .F.
ENDIF
RETURN .T.


*****************************************************************************
* uvolneni FLL knihovny
*****************************************************************************
PROCEDURE UnLoadLibrary(lcFile)
IF FindFile(@lcFile)
   TRY
   RELEASE LIBRARY (m.lcFile) && uvolni knihovnu
   ENDTRY
ENDIF
RETURN .T.


*****************************************************************************
PROCEDURE FindFile(lcFile)
* @lcFile - nazev souboru, ktery se ma najit, sem se vrati taky plna cesta

LOCAL lcFullFile,lii,lcPath,liCount,lcRoot,liy,lcPom,llDal,lcBuffer,liBuffer

lii=1
DO WHILE .T.
   lcPath=SYS(16,m.lii)
   IF LEFT(m.lcPath,3)=="ON."
      lii=m.lii+1
      LOOP
   ENDIF
   EXIT
ENDDO

lcPath=ADDBS(JUSTPATH(m.lcPath)) && vem si cestu spusteneho souboru
lcRoot=ExtractRootFromFile(m.lcPath) && vem si Root

lcPom=SUBS(m.lcPath,LEN(m.lcRoot)+1)
liCount=OCCURS("\",m.lcPom) && spocitej lomitka

llDal=.F. && zrus priznak
FOR lii=m.liCount TO 1 STEP -1
    liy=AT("\",m.lcPom,m.lii)
    lcPath=m.lcRoot+LEFT(m.lcPom,m.liy)
    IF FILE(m.lcPath+m.lcFile) && hledej soubor
       lcFile=m.lcPath+m.lcFile
       RETURN .T.
    ENDIF
NEXT

lcFullFile=FULLPATH(m.lcFile,0) && najdi soubor na ceste vzhuru a na PATH
llDal=FILE(m.lcFullFile) && pokud neexistuje

IF !llDal
   lcBuffer=SPACE(254)+CHR(0)
   liBuffer=LEN(m.lcBuffer) && nadimezuj buffer
   lii=cvp_GetSystemDirectory(@m.lcBuffer,m.liBuffer)
   IF m.lii>0 && pokud to neselhalo
      lcBuffer=LEFT(m.lcBuffer,m.lii)+"\" && orez buffer
      IF FILE(m.lcBuffer+m.lcFile)
         lcFile=m.lcBuffer+m.lcFile
         llDal=.T.
      ENDIF
   ENDIF
ELSE
   lcFile=m.lcFullFile
ENDIF

RETURN m.llDal

****************************************************************
* ostatni procedury
*
*********************************************************************

FUNCTION cvp_SetParent
 LPARAMETERS m.liHWND, m.liParentHWND
 DECLARE LONG SetParent IN USER32.DLL  AS cvp_SetParent LONG, LONG
 RETURN cvp_SetParent(m.liHWND, m.liParentHWND)
ENDFUNC


FUNCTION cvp_SetActiveWindow(liHWND)
 DECLARE LONG SetActiveWindow IN USER32.DLL  AS cvp_SetActiveWindow LONG
 RETURN cvp_SetActiveWindow(liHWND)
ENDFUNC

FUNCTION cvp_SHChangeNotify(liEventId, luFlags, lcItem1, lcItem2)
 DECLARE LONG SHChangeNotify IN SHELL32.DLL AS cvp_SHChangeNotify LONG, INTEGER, STRING @, STRING @
 RETURN cvp_SHChangeNotify(liEventId, luFlags, @lcItem1, @lcItem2)
ENDFUNC

FUNCTION cvp_SetFileAttributes(lcFile, liATTRIB)
 DECLARE INTEGER SetFileAttributes   IN kernel32 AS cvp_SetFileAttributes String @,INTEGER
 RETURN cvp_SetFileAttributes(@lcFile, liATTRIB)
ENDFUNC

FUNCTION cvp_MoveFile(lcFileOld, lcFileNew)
 DECLARE INTEGER MoveFile IN KERNEL32 AS cvp_MoveFile STRING @, STRING @
 RETURN cvp_MoveFile(@lcFileOld, @lcFileNew)
ENDFUNC

FUNCTION cvp__fpreset
 DECLARE _fpreset IN msvcrt20.dll AS cvp__fpreset
 RETURN cvp__fpreset()
ENDFUNC

FUNCTION cvp_CoCreateGuid(pGuid)
 DECLARE INTEGER CoCreateGuid IN OLE32.DLL AS cvp_CoCreateGuid STRING @pGuid
 RETURN cvp_CoCreateGuid(@pGuid)
ENDFUNC

FUNCTION cvp_LockWindowUpdate(liHWND)
 DECLARE LONG LockWindowUpdate IN USER32.DLL AS cvp_LockWindowUpdate LONG
 RETURN cvp_LockWindowUpdate(liHWND)
ENDFUNC

FUNCTION cvp_GetEnvironmentVariable(lpName, lpBuffer, nSize)
 DECLARE INTEGER GetEnvironmentVariable  IN kernel32.dll AS cvp_GetEnvironmentVariable STRING @, STRING @, INTEGER
 RETURN cvp_GetEnvironmentVariable(@lpName, @lpBuffer, nSize)
ENDFUNC

FUNCTION cvp_GetCurrentThread
 DECLARE INTEGER GetCurrentThread  IN kernel32.dll AS cvp_GetCurrentThread
 RETURN cvp_GetCurrentThread()
ENDFUNC

FUNCTION cvp_GetThreadPriority(liHandle)
 DECLARE INTEGER GetThreadPriority IN kernel32.dll AS cvp_GetThreadPriority LONG
 RETURN cvp_GetThreadPriority(liHandle)
ENDFUNC

FUNCTION cvp_SetThreadPriority(liHandle, liPriority)
DECLARE INTEGER SetThreadPriority IN kernel32.dll AS cvp_SetThreadPriority LONG, INTEGER
 RETURN cvp_SetThreadPriority(liHandle, liPriority)
ENDFUNC

FUNCTION cvp_DragAcceptFiles(lihWnd, lfAccept)
 DECLARE DragAcceptFiles IN Shell32.dll AS cvp_DragAcceptFiles LONG, INTEGER
 RETURN cvp_DragAcceptFiles(lihWnd, lfAccept)
ENDFUNC

FUNCTION cvp_DragQueryFile(lihDrop, liFile, lpszFile,licch)
DECLARE LONG DragQueryFile IN shell32.dll AS cvp_DragQueryFile LONG, LONG, STRING @, INTEGER
 RETURN cvp_DragQueryFile(lihDrop, liFile, @lpszFile,licch)
ENDFUNC

FUNCTION cvp_DragQueryPoint(lihDrop, lclppt) && NOTHING
 DECLARE LONG DragQueryPoint IN shell32.dll AS cvp_DragQueryPoint LONG, STRING @
 RETURN cvp_DragQueryPoint(lihDrop, @lclppt)
ENDFUNC

FUNCTION cvp_CallWindowProc(lpPrevWndFunc, lihWnd, liMsg, lwParam, llParam)
 DECLARE LONG CallWindowProc IN user32.dll AS cvp_CallWindowProc LONG, LONG, LONG , INTEGER, INTEGER
 RETURN cvp_CallWindowProc(lpPrevWndFunc, lihWnd, liMsg, lwParam, llParam)
ENDFUNC

FUNCTION cvp_GetWindowLong(lihWnd, lnIndex)
 DECLARE LONG GetWindowLong IN user32.dll AS cvp_GetWindowLong LONG, INTEGER
 RETURN cvp_GetWindowLong(lihWnd, lnIndex)
ENDFUNC

FUNCTION cvp_DragFinish(lihDrop)
 DECLARE DragFinish IN shell32.dll AS cvp_DragFinish LONG
 RETURN cvp_DragFinish(lihDrop)
ENDFUNC

FUNCTION cvp_SHGetSpecialFolderPath(lihwndOwner, lpszPath, lcsidl, lfCreate)
 DECLARE LONG SHGetSpecialFolderPath IN shell32.dll AS cvp_SHGetSpecialFolderPath LONG, STRING @, INTEGER, INTEGER
 RETURN cvp_SHGetSpecialFolderPath(lihwndOwner, @lpszPath, lcsidl, lfCreate)
ENDFUNC

FUNCTION cvp_PathIsDirectory(lpszPath)
 DECLARE INTEGER PathIsDirectory IN Shlwapi.dll AS cvp_PathIsDirectory STRING @
 RETURN cvp_PathIsDirectory(@lpszPath)
ENDFUNC


FUNCTION cvp_GetDriveType(lpszRootPathName)
 DECLARE INTEGER GetDriveType IN kernel32 AS cvp_GetDriveType String @ lpszRootPathName
 RETURN cvp_GetDriveType(@lpszRootPathName)
ENDFUNC

FUNCTION cvp_RemoveDirectory(lpszPath)
 DECLARE INTEGER RemoveDirectory IN kernel32 AS cvp_RemoveDirectory String @lpszPath
 RETURN cvp_RemoveDirectory(@lpszPath)
ENDFUNC

FUNCTION cvp_DeleteFile(lpszFile)
 DECLARE INTEGER DeleteFile  IN kernel32 AS cvp_DeleteFile String @lpszFile
 RETURN cvp_DeleteFile(@lpszFile)
ENDFUNC

FUNCTION cvp_CopyFile(lpExistingFileName, lpNewFileName, liFlag )
 DECLARE INTEGER CopyFile IN KERNEL32 AS cvp_CopyFile STRING @lpExistingFileName, STRING @lpNewFileName, INTEGER
 RETURN cvp_CopyFile(@lpExistingFileName, @lpNewFileName, liFlag )
ENDFUNC

FUNCTION cvp_GetSystemDirectory(lpBuffer, luSize)
 DECLARE INTEGER GetSystemDirectory IN kernel32 AS cvp_GetSystemDirectory STRING @,INTEGER
 RETURN cvp_GetSystemDirectory(@lpBuffer, luSize)
ENDFUNC

FUNCTION cvp_GetPrivateProfileString(lcSection, lcKeyName, lcDefault, lcBuf, liBufLen, lcFileName)
 DECLARE INTEGER GetPrivateProfileString IN win32api AS cvp_GetPrivateProfileString STRING @Section, STRING @KeyName, STRING @Default, STRING @Buf, INTEGER BufLen, STRING @FileName
 RETURN cvp_GetPrivateProfileString(@lcSection, @lcKeyName, @lcDefault, @lcBuf, liBufLen, @lcFileName)
ENDFUNC

FUNCTION cvp_WritePrivateProfileString(lcSection, lcKeyName, lcBuf, lcFileName)
 DECLARE INTEGER WritePrivateProfileString IN win32api AS cvp_WritePrivateProfileString STRING @Section, STRING @KeyName, STRING @Buf, STRING @FileName
 RETURN cvp_WritePrivateProfileString(@lcSection, @lcKeyName, @lcBuf, @lcFileName)
ENDFUNC

FUNCTION cvp_GetPrivateProfileSection(m.lcSection, m.lcBuf, m.liBufLen, m.lcFileName)
 DECLARE INTEGER GetPrivateProfileSection IN win32api AS cvp_GetPrivateProfileSection  STRING @Section, STRING @Buf, INTEGER BufLen, STRING @FileName
 RETURN cvp_GetPrivateProfileSection(@m.lcSection, @m.lcBuf, m.liBufLen, @m.lcFileName)
ENDFUNC

FUNCTION cvp_GetPrivateProfileSectionNames(m.lcBuf, m.liBufLen, m.lcFileName)
 DECLARE INTEGER GetPrivateProfileSectionNames IN win32api AS cvp_GetPrivateProfileSectionNames STRING @Buf, INTEGER BufLen, STRING @FileName
 RETURN cvp_GetPrivateProfileSectionNames(@m.lcBuf, m.liBufLen, @m.lcFileName)
ENDFUNC


FUNCTION cvp_SystemParametersInfo( luiAction, luiParam, lcpvParam, lfWinIni)
 DECLARE INTEGER SystemParametersInfo IN win32api AS cvp_SystemParametersInfo INTEGER,INTEGER,STRING @,INTEGER
 RETURN cvp_SystemParametersInfo( luiAction, luiParam, @lcpvParam, lfWinIni)
ENDFUNC

FUNCTION cvp_SystemParametersInfoI( luiAction, luiParam, lcpvParam, lfWinIni)
 DECLARE INTEGER SystemParametersInfo IN win32api AS cvp_SystemParametersInfoI INTEGER,INTEGER, INTEGER @,INTEGER
 RETURN cvp_SystemParametersInfoI( luiAction, luiParam, @lcpvParam, lfWinIni)
ENDFUNC

FUNCTION cvp_PathRelativePathTo(lpszPath, lpszFrom, ldwAttrFrom, lpszTo, ldwAttrTo)
 DECLARE Integer PathRelativePathToA IN Shlwapi.DLL  AS cvp_PathRelativePathTo String @ , String @ ,Integer , String @ ,Integer
 RETURN cvp_PathRelativePathTo(@lpszPath, @lpszFrom, ldwAttrFrom, @lpszTo, ldwAttrTo)
ENDFUNC

FUNCTION cvp_MoveWindow(lihWnd, liX, liY, lnWidth, lnHeight, lbRepaint)
 DECLARE INTEGER MoveWindow IN USER32.DLL AS cvp_MoveWindow INTEGER,INTEGER,INTEGER,INTEGER,INTEGER,INTEGER
 RETURN cvp_MoveWindow(lihWnd, liX, liY, lnWidth, lnHeight, lbRepaint)
ENDFUNC

FUNCTION cvp_GetActiveWindow
 DECLARE LONG GetActiveWindow IN WIN32API AS cvp_GetActiveWindow
 RETURN cvp_GetActiveWindow()
ENDFUNC

FUNCTION cvp_GetWindowRect(lihwnd, lcRECT)
 DECLARE LONG GetWindowRect IN USER32.DLL AS cvp_GetWindowRect LONG,STRING @
 RETURN cvp_GetWindowRect(lihwnd, @lcRECT)
ENDFUNC

FUNCTION cvp_Sleep(lii)
 DECLARE Sleep IN kernel32 AS cvp_Sleep integer
 RETURN cvp_Sleep(lii)
ENDFUNC

FUNCTION cvp_GetLastError
 DECLARE INTEGER GetLastError IN kernel32 AS cvp_GetLastError
 RETURN cvp_GetLastError()
ENDFUNC

FUNCTION cvp_SetLastError(fdwError)
 DECLARE INTEGER SetLastError IN kernel32 AS cvp_SetLastError Integer fdwError
 RETURN cvp_SetLastError(fdwError)
ENDFUNC

FUNCTION cvp_GetPrivateProfileInt(lcSection, lcKeyName, liLEN , lcFileName)
 DECLARE INTEGER GetPrivateProfileInt IN win32api AS cvp_GetPrivateProfileInt STRING @Section, STRING @KeyName, INTEGER , STRING @FileName
 RETURN cvp_GetPrivateProfileInt(@lcSection, @lcKeyName, liLEN , @lcFileName)
ENDFUNC

FUNCTION cvp_ExpandEnvironmentStrings(lpSrc, lpDst, lnSize)
 DECLARE INTEGER ExpandEnvironmentStrings IN KERNEL32.DLL AS cvp_ExpandEnvironmentStrings STRING @ ,STRING @, INTEGER
  RETURN cvp_ExpandEnvironmentStrings(@lpSrc, @lpDst, lnSize)
ENDFUNC

FUNCTION cvp_GetDiskFreeSpaceEx(lpDirectoryName, lpFreeBytesAvailable, lpTotalNumberOfBytes, lpTotalNumberOfFreeBytes)
 DECLARE SHORT GetDiskFreeSpaceEx IN kernel32 AS cvp_GetDiskFreeSpaceEx STRING @ lpDirectoryName, STRING @ lpFreeBytesAvailable, STRING @ lpTotalNumberOfBytes, STRING @ lpTotalNumberOfFreeBytes
 RETURN cvp_GetDiskFreeSpaceEx(@lpDirectoryName, @lpFreeBytesAvailable, @lpTotalNumberOfBytes, @lpTotalNumberOfFreeBytes)
ENDFUNC

FUNCTION cvp_PathIsRelative(lcPath)
 DECLARE INTEGER PathIsRelativeA IN shlwapi.dll AS cvp_PathIsRelative string @
 RETURN cvp_PathIsRelative(@lcPath)
ENDFUNC

FUNCTION cvp_GetPrivateProfileSection(lcSection, lcBuf, liBufLen, lcFileName) && NOTHING
 DECLARE INTEGER GetPrivateProfileSection IN win32api AS cvp_GetPrivateProfileSection STRING @Section, STRING @Buf, INTEGER BufLen, STRING @FileName
 RETURN cvp_GetPrivateProfileSection(@lcSection, @lcBuf, liBufLen, @lcFileName)
ENDFUNC

FUNCTION cvp_PathSkipRoot(lcPath)
 DECLARE STRING PathSkipRootA IN shlwapi.dll AS cvp_PathSkipRoot String @
 RETURN cvp_PathSkipRoot(@lcPath)
ENDFUNC

FUNCTION cvp_GetTickCount()
 DECLARE INTEGER GetTickCount IN kernel32 AS cvp_GetTickCount
 RETURN cvp_GetTickCount()
ENDFUNC

 PROCEDURE cvp_CreateFile(m.lcPar1, m.liPar2, m.liPar3, m.liPar4, m.liPar5, m.liPar6, m.liPar7)
  DECLARE LONG CreateFile IN kernel32.dll AS cvp_CreateFile STRING @, INTEGER, INTEGER, INTEGER, INTEGER, INTEGER, LONG
  RETURN cvp_CreateFile(@m.lcPar1, m.liPar2, m.liPar3, m.liPar4, m.liPar5, m.liPar6, m.liPar7)
 ENDPROC 
 
 PROCEDURE cvp_ReadFile(m.liPar1, m.lcPar2, m.liPar3, m.liPar4, m.liPar5)
  DECLARE INTEGER ReadFile IN kernel32.dll AS cvp_ReadFile LONG hFile, STRING @ lpBuffer, INTEGER nNumberOfBytesToRead, INTEGER @ lpNumberOfBytesRead, INTEGER lpOverlapped
  RETURN cvp_ReadFile(m.liPar1, @m.lcPar2, m.liPar3, @m.liPar4, m.liPar5)
 ENDPROC

 PROCEDURE cvp_WriteFile(m.liPar1, m.lcPar2, m.liPar3, m.liPar4, m.liPar5)
  DECLARE INTEGER WriteFile IN kernel32.dll AS cvp_WriteFile LONG hFile, STRING @ lpBuffer, INTEGER nNumberOfBytesToWrite, INTEGER @ lpNumberOfBytesWrited, INTEGER lpOverlapped
  RETURN cvp_WriteFile(m.liPar1, @m.lcPar2, m.liPar3, @m.liPar4, m.liPar5)
 ENDPROC
 
 PROCEDURE cvp_SetFilePointer(m.liPar1, m.liPar2, m.liPar3, m.liPar4)
  DECLARE INTEGER SetFilePointer IN kernel32.dll AS cvp_SetFilePointer LONG hFile, INTEGER lowbytes, INTEGER @ highytes, INTEGER mode
  RETURN cvp_SetFilePointer(m.liPar1, m.liPar2, @m.liPar3, m.liPar4)
 ENDPROC

 PROCEDURE CVP_SetProcessWorkingSetSize(m.liProcessID, m.lnMiWS, m.lnMaWS)
  DECLARE INTEGER SetProcessWorkingSetSize IN kernel32 AS CVP_SetProcessWorkingSetSize LONG hProcess, INTEGER dwMinimumWorkingSetSize, INTEGER dwMaximumWorkingSetSize
  RETURN CVP_SetProcessWorkingSetSize(m.liProcessID, m.lnMiWS, m.lnMaWS) 
 ENDPROC

 PROCEDURE CVP_GetCurrentProcess()
  DECLARE LONG GetCurrentProcess IN kernel32 AS CVP_GetCurrentProcess
  RETURN CVP_GetCurrentProcess()
 ENDPROC

 PROCEDURE CVP_PrepareZstream()
  DECLARE LONG PrepareZstream IN (m.pcCVPFLL) AS CVP_PrepareZstream
  RETURN CVP_PrepareZstream()
 ENDPROC

 PROCEDURE CVP_FreeZstream(m.liMapZstream)
  DECLARE LONG FreeZstream IN (m.pcCVPFLL) AS CVP_FreeZstream LONG
  RETURN CVP_FreeZstream(m.liMapZstream)
 ENDPROC

 PROCEDURE CVP_DIZstream(m.liMapZstream, m.liLevel, m.liWindowBits, m.liMemLevel, m.liStrategy, m.liOBuffer)
  DECLARE LONG DIZstream IN (m.pcCVPFLL) AS CVP_DIZstream LONG, INTEGER, INTEGER, INTEGER, INTEGER, LONG @
  RETURN CVP_DIZstream(m.liMapZstream, m.liLevel, m.liWindowBits, m.liMemLevel, m.liStrategy, @m.liOBuffer)
 ENDPROC

 PROCEDURE CVP_DEZstream(m.liMapZstream)
  DECLARE LONG DEZstream IN (m.pcCVPFLL) AS CVP_DEZstream LONG
  RETURN CVP_DEZstream(m.liMapZstream)
 ENDPROC

 PROCEDURE CVP_DSZstream(m.liMapZstream)
  DECLARE LONG DSZstream IN (m.pcCVPFLL) AS CVP_DSZstream LONG
  RETURN CVP_DSZstream(m.liMapZstream)
 ENDPROC


 PROCEDURE CVP_DeflateZstream(m.liMapZstream, m.liSize, m.lihFile)
  DECLARE LONG DeflateZstream IN (m.pcCVPFLL) AS CVP_DeflateZstream LONG, LONG @, LONG
  RETURN CVP_DeflateZstream(m.liMapZstream, @m.liSize, m.lihFile)
 ENDPROC

 PROCEDURE CVP_IIZstream(m.liMapZstream, m.liIBuffer)
  DECLARE LONG IIZstream IN (m.pcCVPFLL) AS CVP_IIZstream LONG, LONG @
  RETURN CVP_IIZstream(m.liMapZstream, @m.liIBuffer)
 ENDPROC

 PROCEDURE CVP_IEZstream(m.liMapZstream)
  DECLARE LONG IEZstream IN (m.pcCVPFLL) AS CVP_IEZstream LONG
  RETURN CVP_IEZstream(m.liMapZstream)
 ENDPROC

 PROCEDURE CVP_InflateZstream(m.liMapZstream, m.lihFile, m.liIBuffer)
  DECLARE LONG InflateZstream IN (m.pcCVPFLL) AS CVP_InflateZstream LONG, LONG, LONG
  RETURN CVP_InflateZstream(m.liMapZstream, m.lihFile, m.liIBuffer)
 ENDPROC


 PROCEDURE CVP_zipOpen(m.lcFile, m.liFlag)
  DECLARE INTEGER zipOpen IN (m.pczlibDLL) AS CVP_zipOpen STRING @, INTEGER
  RETURN CVP_zipOpen(@m.lcFile, m.liFlag)
 ENDPROC

 PROCEDURE CVP_zipClose(m.liZIPHandle, m.lcComment)
  DECLARE INTEGER zipClose IN (m.pczlibDLL) AS CVP_zipClose INTEGER, STRING
  RETURN CVP_zipClose(m.liZIPHandle, m.lcComment)
 ENDPROC

 PROCEDURE CVP_zipOpenNewFileInZip(m.liZIPHandle, m.lcFileName, m.lcZipfi, m.lcEFLocal, m.liEFLocal, m.lcEFGlobal, m.liEFGlobal, m.lcComment, m.liMethod, m.liLevel, ;
                                   m.luX1, m.liWindowBits, m.liMEMLevel, m.liStrategy, m.lcPassword, m.liCRC32, m.luX2, m.lnFLAGBASE, m.liBigFile;
                                  )
  DECLARE INTEGER zipOpenNewFileInZip4_64 IN (m.pczlibDLL) AS CVP_zipOpenNewFileInZip;
                 INTEGER, STRING, STRING, ;
                 STRING, INTEGER, STRING, INTEGER, STRING, ;
                 INTEGER, INTEGER, INTEGER,;
                 INTEGER, INTEGER, INTEGER, STRING, INTEGER, INTEGER, INTEGER, INTEGER

  RETURN CVP_zipOpenNewFileInZip(m.liZIPHandle, m.lcFileName, m.lcZipfi, m.lcEFLocal, m.liEFLocal, m.lcEFGlobal, m.liEFGlobal, m.lcComment, ;
                                  m.liMethod, m.liLevel, m.luX1, ; 
                                   -m.liWindowBits, m.liMEMLevel, m.liStrategy, ;
                                  @m.lcPassword, m.liCRC32, m.luX2, m.lnFLAGBASE, m.liBigFile)
 ENDPROC



 PROCEDURE CVP_zipWriteInFileInZip(m.liZIPHandle, m.lcBuffer, m.liLen)
  DECLARE INTEGER zipWriteInFileInZip IN (m.pczlibDLL) AS CVP_zipWriteInFileInZip INTEGER, STRING, INTEGER
  RETURN CVP_zipWriteInFileInZip(m.liZIPHandle, m.lcBuffer, m.liLen)
 ENDPROC

 PROCEDURE CVP_zipCloseFileInZip(m.liZIPHandle)
  DECLARE INTEGER zipCloseFileInZip IN (m.pczlibDLL) AS CVP_zipCloseFileInZip INTEGER
  RETURN CVP_zipCloseFileInZip(m.liZIPHandle)
 ENDPROC

 PROCEDURE CVP_WriteFileInZip(m.liZIPHandle, m.lcFullFile, m.lcFile, m.lcFileInfo, m.lcComment, m.liMethod, m.liLevel,;
                              m.liRaw, m.liWBITS, m.liMEMLevel, m.liStrategy, m.lcPassword, m.liCRC32, m.lnFLAGBASE, m.liBuffer;
                             )
  DECLARE INTEGER WriteFileInZip IN (m.pcCVPFLL) AS CVP_WriteFileInZip INTEGER, STRING, STRING, STRING, STRING, INTEGER, INTEGER,;
                                                                       INTEGER, INTEGER, INTEGER, INTEGER, STRING, LONG, LONG, LONG
  RETURN CVP_WriteFileInZip(m.liZIPHandle, m.lcFullFile, m.lcFile, m.lcFileInfo, m.lcComment, m.liMethod, m.liLevel,;
                            m.liRaw, m.liWBITS, m.liMEMLevel, m.liStrategy, m.lcPassword, m.liCRC32, m.lnFLAGBASE, m.liBuffer;
                           )
 ENDPROC


 PROCEDURE CVP_unzOpen(m.lcFile)
  DECLARE INTEGER unzOpen IN (m.pczlibDLL) AS CVP_unzOpen STRING @
  RETURN CVP_unzOpen(@m.lcFile)
 ENDPROC

 PROCEDURE CVP_unzClose(m.liZIPHandle)
  DECLARE INTEGER unzClose IN (m.pczlibDLL) AS CVP_unzClose INTEGER
  RETURN CVP_unzClose(m.liZIPHandle)
 ENDPROC

 PROCEDURE CVP_unzGetGlobalInfo(m.liZIPHandle, m.lcINFO)
  DECLARE INTEGER unzGetGlobalInfo IN (m.pczlibDLL) AS CVP_unzGetGlobalInfo INTEGER, STRING @
  RETURN CVP_unzGetGlobalInfo(m.liZIPHandle, @m.lcINFO)
 ENDPROC

 PROCEDURE CVP_unzGetCurrentFileInfo(m.liFileHandle, m.lcINFO, m.lcFileName, m.liFileName, m.lcEF, m.liEF, m.lcComment, m.liComment)
  DECLARE INTEGER unzGetCurrentFileInfo IN (m.pczlibDLL) AS CVP_unzGetCurrentFileInfo INTEGER, STRING @, STRING @, INTEGER, STRING @, INTEGER, STRING @, INTEGER
  RETURN CVP_unzGetCurrentFileInfo(m.liFileHandle, @m.lcINFO, @m.lcFileName, m.liFileName, @m.lcEF, m.liEF, @m.lcComment, m.liComment)
 ENDPROC

 PROCEDURE CVP_unzGetCurrentFileInfo64(m.liFileHandle, m.lcINFO64, m.lcFileName, m.liFileName, m.lcEF, m.liEF, m.lcComment, m.liComment)
  DECLARE INTEGER unzGetCurrentFileInfo64 IN (m.pczlibDLL) AS CVP_unzGetCurrentFileInfo64 INTEGER, STRING @, STRING @, INTEGER, STRING @, INTEGER, STRING @, INTEGER
  RETURN CVP_unzGetCurrentFileInfo64(m.liFileHandle, @m.lcINFO64, @m.lcFileName, m.liFileName, @m.lcEF, m.liEF, @m.lcComment, m.liComment)
 ENDPROC

 PROCEDURE CVP_unzOpenCurrentFile(m.liFileHandle)
  DECLARE INTEGER unzOpenCurrentFile IN (m.pczlibDLL) AS CVP_unzOpenCurrentFile INTEGER
  RETURN CVP_unzOpenCurrentFile(m.liFileHandle)
 ENDPROC

 PROCEDURE CVP_unzReadCurrentFile(m.liFileHandle, m.lcBuffer, m.liLen)
  DECLARE INTEGER unzReadCurrentFile IN (m.pczlibDLL) AS CVP_unzReadCurrentFile INTEGER, STRING @, INTEGER
  RETURN CVP_unzReadCurrentFile(m.liFileHandle, @m.lcBuffer, m.liLen)
 ENDPROC

 PROCEDURE CVP_unzCloseCurrentFile(m.liFileHandle)
  DECLARE INTEGER unzCloseCurrentFile IN (m.pczlibDLL) AS CVP_unzCloseCurrentFile INTEGER
  RETURN CVP_unzCloseCurrentFile(m.liFileHandle)
 ENDPROC

 PROCEDURE CVP_unzGoToNextFile(m.liFileHandle)
  DECLARE INTEGER unzGoToNextFile IN (m.pczlibDLL) AS CVP_unzGoToNextFile INTEGER
  RETURN CVP_unzGoToNextFile(m.liFileHandle)
 ENDPROC

 PROCEDURE CVP_unzGoToFirstFile(m.liFileHandle)
  DECLARE INTEGER unzGoToFirstFile IN (m.pczlibDLL) AS CVP_unzGoToFirstFile INTEGER
  RETURN CVP_unzGoToFirstFile(m.liFileHandle)
 ENDPROC

*********************************************************************
* 
*********************************************************************
PROCEDURE IsTagExists
LPARAMETERS m.lcTAG, m.liSele

m.liSele=IIF(EMPTY(m.liSele), SELECT(), m.liSele)

LOCAL m.lii, m.liCNT
m.liCNT=TAGCOUNT("", m.liSele)

FOR m.lii=1 TO m.liCNT
    IF TAG(m.lii, m.liSele)==m.lcTAG
       EXIT
    ENDIF
NEXT
RETURN m.lii<=m.liCNT
ENDPROC

*********************************************************************
* vrati maximalni RECT umisteni okna
*********************************************************************
PROCEDURE GetMaxRectWind(lihwnd,lcNewRect)
* lihwnd    - Handle okna
*@lcNewRect - Nova pozice okna

IF EMPTY(m.lihwnd) && pokud neni definovano
   lihwnd=cvp_GetActiveWindow() && pak zjisti z API
ENDIF

LOCAl lcRect,liMaxWidth,liMaxHeight,liWLeft,liWTop,liWLeftR,liWTopR,liWHeight,liWWidth,liLeft,liTop,liHeight,liWidth

lcRect=REPL(CHR(0),16)
=cvp_SystemParametersInfo(48,0,@m.lcRect,0)

liWLeft=CTOBIN(LEFT(m.lcRect,4),"RS")    && prevod na cisla - pozice zleva
liWTop=CTOBIN(SUBS(m.lcRect,5,4),"RS")  && prevod na cisla - pozice zeshora
liWLeftR=CTOBIN(SUBS(m.lcRect,9,4),"RS")    && prevod na cisla - pozice zleva po
liWTopR=CTOBIN(SUBS(m.lcRect,13,4),"RS")  && prevod na cisla - pozice zeshora po

liWHeight=m.liWTopR-m.liWTop && vyska pracovni plochy
liWWidth=m.liWLeftR-m.liWLeft && sirka pracovni plochy

liMaxWidth=SYSMETRIC(1) && maximalni sirka plochy
liMaxHeight=SYSMETRIC(2) && maximalni vyska plochy

liTop=m.liWTop       && prevezmi pozici od shora
liLeft=m.liWLeft     && prevezmi pozici zleva
liWidth=m.liWWidth   && prevezmi sirku
liHeight=m.liWHeight && prevezmi vysku

IF m.liHeight>m.liMaxHeight && je-li vyska pracovni plochy > max. vyska zobrazeni
   liHeight=m.liMaxHeight-m.liWTop
ENDIF

IF m.liWidth>m.liMaxWidth && je-li vyska pracovni plochy > max. vyska zobrazeni
   liWidth=m.liMaxWidth-m.liWLeft
ENDIF

lcNewRect=BINTOC(m.liLeft,"RS")+BINTOC(m.liTop,"RS")+BINTOC(m.liLeft+m.liWidth,"RS")+BINTOC(m.liLeft+m.liHeight,"RS")
ENDPROC


********************************************************************
PROCEDURE NullTermined(lcChar)
LOCAL lii
lii=AT(CHR(0),m.lcChar) && najdi NULL znak v retezci
RETURN IIF(m.lii>0,LEFT(m.lcChar,m.lii-1),m.lcChar) && a orez to, pokud tam je
ENDPROC

********************************************************************
PROCEDURE SetPict(loPicture,lcProp,lcPicture)  && objekt, nazev vlastnosti,  nazev obrazku
STORE IIF(!EMPTY(m.lcPicture),m.lcPicture,"P") TO ("m.loPicture."+m.lcProp) && nastaveni vlastnosti
ENDPROC


PROCEDURE CVP_FILE
LPARAMETERS m.lcFile
LOCAL ARRAY m.laX(1)
RETURN ADIR(m.laX, m.lcFile, "ASHR")>0
ENDPROC

*****************************************************************************
*                                                                           *
*   Direcotory Defination                                                   *
*                                                                           *
*****************************************************************************

**************************************************************************************
PROCEDURE Mkd(lcPath)
* lcPath -  cesta
LOCAL lcPom,lcDriveRoot,lii,loErr

lcPath=ALLT("&lcPath") && preventivne odstran makra
IF DIRECTORY(m.lcPath) && pokud dana cesta existuje
   RETURN 1 && pak se vrat 
ENDIF

* patrne nejde o UNC nebo DOS cestu s diskem
IF !(LEFT(m.lcPath,2)="\\" OR SUBS(m.lcPath,2,1)=":")
   lcPom=ALLTRIM(SET("PATH")) && vrat nastaveni PATH a orez mezery
   IF LEFT(m.lcPath,1)="\" && jde o cestu z rootu, pak musim pridat jen disk (server+sdileny disk)
      IF LEFT(m.lcPom,2)="\\" && jde o UNC cestu
         lii=AT("\",m.lcPom,4) && najdi 4. oddelovac
         IF m.lii>0 && pokud tam je
            lcPom=LEFT(m.lcPom,m.lii-1) && pak nacti cestu bez oddelovace
         ENDIF
       ELSE
         * jinak jde o DOS cestu
         lcPom=LEFT(m.lcPom,2)
       ENDIF
   ELSE
      IF RIGHT(m.lcPom,1)#"\" && pokud na konci neni oddelovac
         lcPom=m.lcPom+"\" && pak ho tam pridej
      ENDIF
   ENDIF
   lcPath=m.lcPom+m.lcPath && secti novou cestu
ENDIF

IF LEFT(m.lcPath,2)#"\\" && pokud to je DOS cesta
   lcDriveRoot=LEFT(m.lcPath,2)+"\"+CHR(0) && vem si disk
   IF INLIST(CVP_GetDriveType(@m.lcDriveRoot),DRIVE_UNKNOWN,DRIVE_CDROM) && Disk neexistuje, nebo je to CD-ROM
      RETURN 4  && vrat se
   ENDIF
ENDIF

loErr=.NULL.
TRY
 MD (m.lcPath) && zaloz cestu
CATCH TO loErr
FINALLY
ENDTRY

* pokud neni chyba, pak vrat 0
* pristup zamitnut
* invalid path or name
RETURN IIF(ISNULL(m.loErr),0,;
       IIF(m.loErr.ErrorNo=1705,2,;
       IIF(m.loErr.ErrorNo=202,3,3)))  && vrat priznak chyb
ENDPROC


*********************************************************************************
PROCEDURE RemoveDirectoryAll(lcSource)
IF PCOUNT()=0 && pokud neni parametr
   RETURN .F. && ErrFewArguments pak se vrat
ENDIF
LOCAL lcSourceN,lic,lierr,lierrx,lii,lcFSource
LOCAL ARRAY laDir(1)

lcSource=ALLT("&lcSource") && preventivne odstran makra
lcSourceN=m.lcSource+CHR(0) && pricti nulovy znak

IF RIGHT(m.lcSource,1)#'\' && pokud na konci neni lomitko
   lcSource=m.lcSource+'\' && pak ho pridej
ENDIF

lic=ADIR(laDir,m.lcSource+'*.*','AHRSD')
FOR lii=1 TO m.lic
    IF !(!m.laDir(m.lii,1)=="." AND !m.laDir(m.lii,1)=="..") && pokud se jedna o fiktivni adresare
       LOOP && pak skoc na dalsi
    ENDIF
    IF RIGHT(m.laDir(m.lii,5),1)='D' && jde o adresar a ma se kopirovat
       * pokud se ma kopirovat a nejde vytvorit
       IF !RemoveDirectoryAll(m.lcSource+m.laDir(m.lii,1))
          RETURN .F. && ErrOther pak se vrat
       ENDIF
    ELSE
       * jinak jde o soubor
       lcFSource=m.lcSource+m.laDir(m.lii,1)+CHR(0) && zdroj
        =cvp_SetLastError(0) && vynuluj chyby
       lierr=cvp_DeleteFile(@m.lcFSource) && vymaz souboru
*       lierrx=GetLastError() && nacti rozsirenou chybu
       IF m.lierr=0 && pokud doslo k chybe
          RETURN .F. && ErrOther pak se vrat
       ENDIF
   ENDIF
NEXT
=cvp_SetLastError(0) && vynuluj chyby
liErr=cvp_RemoveDirectory(m.lcSourceN) && odstran adresar
*liErrx=GetLastError() && nacti rozsirenou chybu

RETURN m.liErr#0 && ErrOK, ErrOther pak se vrat .T. pokud nedoslo k chybe
ENDPROC


******************************************************************************
PROCEDURE RelativePathFromTo(lcFrom,liFromType,lcTo,liToType)
* lcFrom     - cesta nebo cesta+ soubor odkud
* liFromType - typ (adresar,soubor)
* lcTo       - cesta nebo cesta+ soubor kam
* liToType   - typ (adresar,soubor) 
LOCAL lcOut,liErr
lcOut=SPACE(254)+CHR(0)
lcTo=m.lcTo+CHR(0)
lcFrom=m.lcFrom+CHR(0)
liErr=cvp_PathRelativePathTo(@m.lcOut,@m.lcFrom,m.liFromType,@m.lcTo,m.liToType)
RETURN NullTermined(IIF(m.liErr=1,m.lcOut,m.lcTo))
ENDPROC


******************************************************************************
* Pripoji text k nazvu souboru (pred priponu)
******************************************************************************
PROCEDURE AppendShortFileFromFile(lcFile,lcAppend)
* lcFile    - cesta+ nazev souboru, nebo jen nazev souboru
* lcAppend  - text, ktery se ma pripojit
LOCAL lii,lcSFile
lii=RAT("\",m.lcFile) && hledej oddelovac
lcSFile=IIF(m.lii>0,SUBS(m.lcFile,m.lii+1),m.lcFile) && pak to orizni
lcFile=IIF(m.lii>0,LEFT(m.lcFile,m.lii),"")  && ponech si zde cestu
lii=RAT(".",m.lcSFile) && hledej tecku
RETURN m.lcFile+IIF(m.lii>0,LEFT(m.lcSFile,m.lii-1)+m.lcAppend+SUBS(m.lcSFile,m.lii),m.lcSFile+m.lcAppend)
ENDPROC

******************************************************************************
PROCEDURE ExtractRootFromFile(lcFile)
* lcFile - cesta nebo cesta+ nazev souboru
LOCAL lii,lcRoot,lcSubPath
lcRoot=ADDBS(ALLT(m.lcFile))+CHR(0)
lcSubPath=cvp_PathSkipRoot(@m.lcRoot) && vymackni zneho sub cestu
lii=LEN(m.lcSubPath) && zjisti delku subcesty
RETURN LEFT(m.lcRoot,LEN(m.lcRoot)-1-m.lii-IIF(m.lii=0,0,1))
ENDPROC

******************************************************************************
PROCEDURE ChangeExtensionFromFile(m.lcFile, m.lcNewExt)
* lcFile   - cesta+ nazev souboru, nebo jen nazev souboru
* lcNewExt - nova extension
LOCAL m.lii
m.lii=RAT(".", m.lcFile) && hledej tecku
RETURN IIF(m.lii>0, LEFT(m.lcFile, m.lii)+m.lcNewExt, m.lcFile+'.'+m.lcNewExt)
ENDPROC


******************************************************************************
PROCEDURE DiskSpaceEx(lcRoot,liErr)
LOCAL liDFS, lpFreeBytesAvailable, lpTotalNumberOfBytes, m.lpTNOfFB
#DEFINE maxInt 4294967296 && &H100000000

STORE REPL(CHR(0), 8) TO lpFreeBytesAvailable, lpTotalNumberOfBytes, m.lpTNOfFB
=cvp_SetLastError(0)
lcRoot=m.lcRoot+CHR(0)
IF cvp_GetDiskFreeSpaceEx(@m.lcRoot, @m.lpFreeBytesAvailable, @m.lpTotalNumberOfBytes, @m.lpTNOfFB) #0

  liDFS = ASC(SUBSTR(m.lpTNOfFB, 1, 1))+256*ASC(SUBSTR(m.lpTNOfFB, 2, 1))+256*256*ASC(SUBSTR(m.lpTNOfFB, 3, 1))+256*256*256*ASC(SUBSTR(m.lpTNOfFB, 4, 1))+;
          (ASC(SUBSTR(m.lpTNOfFB, 5, 1))+256*ASC(SUBSTR(m.lpTNOfFB, 6, 1))+256*256*ASC(SUBSTR(m.lpTNOfFB, 7, 1))+256*256*256*ASC(SUBSTR(m.lpTNOfFB, 8, 1)))*maxInt
   liErr=0
ELSE
   liDFS=-1
   liErr=cvp_GetLastError()
ENDIF
RETURN m.liDFS
ENDPROC



***************************************************************************
PROCEDURE GetShortText(loObj,lcText,liRightLen,lcIntertxt)
* loObj      - Objekt
* lcText     - text jez se ma zkratit
* liRightLen - Pocet pozic zprava jez maji byt vzdy videny
* lcIntertxt - oddelovaci text

LOCAL liRighttxt,liModulustxt,lii,liWidth,liIntertxtWidth,liPom,liStart,liEnd,liStep,lcFormat

WITH loObj  && NASTAVENI INF. FontU NA SCREENU DLE OBJEKTU

lcFormat=IIF(.FontBold,"B","")+IIF(.FontItalic,"I","")+IIF(.FontStrikethru,"-","")+IIF(.FontUnderline,"U","")

liWidth=.Width-IIF(PEMSTATUS(m.loObj,"Margin",5),.Margin*2,0)-IIF(PEMSTATUS(m.loObj,"BorderStyle",5) AND .BorderStyle=1,2,0)
ENDWITH

IF TXTWIDTH(m.lcText,m.loObj.FontName,m.loObj.FontSize,m.lcFormat)*FONTMETRIC(6,m.loObj.FontName,m.loObj.FontSize,m.lcFormat)<=m.liWidth   && porovnej delku textu s vypo. delkou
   RETURN m.lcText && a pokud je mensi, pak se vrat
ENDIF

WITH loObj  
liRighttxt=LEN(m.lcText)-m.liRightLen
liIntertxtWidth=TXTWIDTH(m.lcIntertxt,.FontName,.FontSize,m.lcFormat)*FONTMETRIC(6,.FontName,.FontSize,m.lcFormat) && delka mezi textu
liModulustxt=m.liWidth-TXTWIDTH(SUBST(m.lcText,m.liRighttxt),.FontName,.FontSize,m.lcFormat)*FONTMETRIC(6,.FontName,.FontSize,m.lcFormat)-m.liIntertxtWidth && zbyla delka

* pokud je sirka zbyleho textu mensi nez polovicka celeho textu
IF m.liModulustxt<(TXTWIDTH(m.lcText,.FontName,.FontSize,m.lcFormat)*FONTMETRIC(6,.FontName,.FontSize,m.lcFormat)/2)
   * pak hledej od zacatku
   liStart=1
   liEnd=LEN(m.lcText)-m.liRightLen
   liStep=1
ELSE
   * jinak hledej od konce
   liStart=LEN(m.lcText)-m.liRightLen
   liEnd=1
   liStep=-1
ENDIF

FOR lii=m.liStart TO m.liEnd STEP m.liStep
    IF m.liStep=1
       IF TXTWIDTH(LEFT(m.lcText,m.lii),.FontName,.FontSize,m.lcFormat)*FONTMETRIC(6,.FontName,.FontSize,m.lcFormat)>m.liModulustxt && delka vypocteneho textu
          lcText=LEFT(m.lcText,m.lii-1)+m.lcIntertxt+SUBST(m.lcText,m.liRighttxt)
          EXIT
       ENDIF
    ELSE
       IF TXTWIDTH(LEFT(m.lcText,m.lii),.FontName,.FontSize,m.lcFormat)*FONTMETRIC(6,.FontName,.FontSize,m.lcFormat)<=m.liModulustxt && delka vypocteneho textu
          lcText=LEFT(m.lcText,m.lii)+m.lcIntertxt+SUBST(m.lcText,m.liRighttxt)
          EXIT
       ENDIF
    ENDIF
NEXT
ENDWITH

RETURN m.lcText
ENDPROC


***********************************************************
* Vrati retezec omezeny na n znaku (inteligentni orezavani)
* oddelovac se vklada doprostred textu
***************************************************************************
PROCEDURE GetShortText_MidleText(lcText,liMaxLen,liLeftLen,liRightLen,lcIntertxt)
* lcText     - Text na orezani
* liMaxLen   - Maximalni delka
* liLeftLen  - Delka zleva jez ma byt zachovana
* liRightLen - Delka zprava jez ma byt zachovana
* lcIntertxt - Oddelovaci text

LOCAL lii,lcRet
* pokud je delka textu mensi nebo rovno maximalni
IF LEN(m.lcText)<=m.liMaxLen
   RETURN m.lcText && pak vrat puvodni text
ENDIF
* pokud je zbyvajici delka retezce mensi nez povolena
IF m.liMaxLen-m.liRightLen-LEN(m.lcIntertxt)<m.liLeftLen
   RETURN LEFT(m.lcText,m.liLeftLen)+m.lcIntertxt+RIGHT(m.lcText,m.liMaxLen-m.liLeftLen-LEN(m.lcIntertxt))
ELSE
   RETURN LEFT(m.lcText,m.liMaxLen-m.liRightLen-LEN(m.lcIntertxt))+m.lcIntertxt+RIGHT(m.lcText,m.liRightLen)
ENDIF
ENDPROC


***********************************************************************************
PROCEDURE GetINIString(lcSection,lcKey,lcDVal,liBuf,lcFile)
LOCAL lcBuf,liLen
lcBuf=SPACE(m.liBuf)+CHR(0) && nastav buffer
lcSection=m.lcSection+CHR(0)
lcKey=m.lcKey+CHR(0)
lcDVal=m.lcDVal+CHR(0)
lcFile=m.lcFile+CHR(0)
liLen=cvp_GetPrivateProfileString(@m.lcSection,@m.lcKey,@m.lcDVal,@m.lcBuf,m.liBuf+1,@m.lcFile)
RETURN LEFT(m.lcBuf,m.liLen)
ENDPROC

**************************************************************************************
PROCEDURE WriteINIString(lcSection,lcKey,lcVal,lcFile)
* zapis hodnotu
lcSection=m.lcSection+CHR(0)
lcKey=m.lcKey+CHR(0)
lcVal=m.lcVal+CHR(0)
lcFile=m.lcFile+CHR(0)
=cvp_WritePrivateProfileString(@m.lcSection,@m.lcKey,@m.lcVal,@m.lcFile)
RETURN ErrOK
ENDPROC

***********************************************************************************
PROCEDURE GetINIInt(lcSection,lcKey,liDVal,lcFile)
lcSection=m.lcSection+CHR(0)
lcKey=m.lcKey+CHR(0)
lcFile=m.lcFile+CHR(0)
RETURN cvp_GetPrivateProfileInt(@m.lcSection,@m.lcKey,@m.liDVal,@m.lcFile)
ENDPROC


***********************************************************************************
PROCEDURE GetINISectionNames(m.liBuf, m.lcFile)
LOCAL m.lcBuf, m.liLen
m.lcBuf=SPACE(m.liBuf)+CHR(0) && nastav buffer
m.lcFile=m.lcFile+CHR(0)
m.liLen=cvp_GetPrivateProfileSectionNames(@m.lcBuf, m.liBuf, @m.lcFile)
m.lcFile=STUFF(m.lcFile, LEN(m.lcFile), 1, "")
RETURN LEFT(m.lcBuf,m.liLen)
ENDPROC

***********************************************************************************
PROCEDURE GetINISection(m.lcSection, m.liBuf, m.lcFile)
LOCAL m.lcBuf, m.liLen
m.lcBuf=SPACE(m.liBuf)+CHR(0) && nastav buffer
m.lcSection=m.lcSection+CHR(0)
m.lcFile=m.lcFile+CHR(0)
m.liLen=cvp_GetPrivateProfileSection(@m.lcSection, @m.lcBuf, m.liBuf,@m.lcFile)
m.lcFile=STUFF(m.lcFile, LEN(m.lcFile), 1, "")
RETURN LEFT(m.lcBuf, m.liLen)
ENDPROC

************************************************************************************
** Vrati pozici znaku, ktery neni mezera ci tabelator, v retezci od urcite pozice (vyhledava zleva)
************************************************************************************
PROCEDURE AT_NonSpace(lcSource,liStart,liEnd)
* @lcSource - Zdrojovy retezec
* liStart   - Startovaci pozice pro hledani
* liEnd     - Konecna pozice pro hledani
liEnd=IIF(PCOUNT()=3,m.liEnd,LEN(m.lcSource))
DO WHILE m.liStart<=m.liEnd AND (SUBS(m.lcSource,m.liStart,1)=" " OR  SUBS(m.lcSource,m.liStart,1)=CHR(9))
   liStart=m.liStart+1 && Inkrementuj citac
ENDDO
RETURN IIF(m.liStart>m.liEnd,0,;
       IIF(SUBS(m.lcSource,m.liStart,1)==" " OR SUBS(m.lcSource,m.liStart,1)==CHR(9),0,m.liStart)) && Vrat pocatecni pozici 
ENDPROC

************************************************************************************
** Vrati pozici znaku, ktery neni mezera ci tabelator, v retezci od urcite pozice (vyhledava zprava)
************************************************************************************
PROCEDURE RAT_NonSpace(lcSource,liStart,liEnd)
* @lcSource - Zdrojovy retezec
* liStart   - Startovaci pozice pro hledani
* liEnd     - Konecna pozice pro hledani
LOCAL liLen
liEnd=IIF(PCOUNT()=3,m.liEnd,1)
DO WHILE m.liStart>=m.liEnd AND  (SUBS(m.lcSource,m.liStart,1)=" " OR  SUBS(m.lcSource,m.liStart,1)=CHR(9))
   liStart=m.liStart-1 && Dekrementuj citac
ENDDO
RETURN IIF(m.liStart<m.liEnd,0,;
       IIF(SUBS(m.lcSource,m.liStart,1)==" " OR SUBS(m.lcSource,m.liStart,1)==CHR(9),0,m.liStart)) && Vrat pocatecni pozici
ENDPROC

************************************************************************************
** Vrati pozici znaku, ktery je mezera ci tabelator, v retezci od urcite pozice (vyhledava zleva)
************************************************************************************
PROCEDURE AT_Space(lcSource,liStart,liEnd)
* @lcSource - Zdrojovy retezec
* liStart   - Startovaci pozice pro hledani
* liEnd     - Konecna pozice pro hledani
liEnd=IIF(PCOUNT()=3,m.liEnd,LEN(m.lcSource))
DO WHILE m.liStart<=m.liEnd AND !SUBS(m.lcSource,m.liStart,1)=" " AND  !SUBS(m.lcSource,m.liStart,1)=CHR(9)
   liStart=m.liStart+1 && Inkrementuj citac
ENDDO
RETURN IIF(m.liStart>m.liEnd,0,;
       IIF(SUBS(m.lcSource,m.liStart,1)==" " OR SUBS(m.lcSource,m.liStart,1)==CHR(9),m.liStart,0)) && Vrat pocatecni pozici
ENDPROC

************************************************************************************
** Vrati pozici znaku, ktery neni mezera ci tabelator, v retezci od urcite pozice
** (vyhledava zleva), s tim, ze ignoruje znaky SPACE a TAB
************************************************************************************
PROCEDURE AT_Word(lcSource,liStart,liEnd)
* @lcSource - Zdrojovy retezec
* liStart   - Startovaci pozice pro hledani
* liEnd     - Konecna pozice pro hledani

liEnd=IIF(PCOUNT()=3,m.liEnd,LEN(m.lcSource))
DO WHILE m.liStart<=m.liEnd AND !SUBS(m.lcSource,m.liStart,1)=" " AND  !SUBS(m.lcSource,m.liStart,1)=CHR(9)
   liStart=m.liStart+1 && Inkrementuj citac
ENDDO
liStart=IIF(m.liStart>m.liEnd,0,;
        IIF(SUBS(m.lcSource,m.liStart,1)==" " OR SUBS(m.lcSource,m.liStart,1)==CHR(9),m.liStart,0)) && Vrat pocatecni pozici

IF m.liStart>0
   liEnd=IIF(PCOUNT()=3,m.liEnd,LEN(m.lcSource))
   DO WHILE m.liStart<=m.liEnd AND (SUBS(m.lcSource,m.liStart,1)=" " OR  SUBS(m.lcSource,m.liStart,1)=CHR(9))
      liStart=m.liStart+1 && Inkrementuj citac
   ENDDO
   RETURN IIF(m.liStart>m.liEnd,0,;
          IIF(SUBS(m.lcSource,m.liStart,1)==" " OR SUBS(m.lcSource,m.liStart,1)==CHR(9),0,m.liStart)) && Vrat pocatecni pozici
ELSE
   RETURN 0
ENDIF
ENDPROC


************************************************************************************
** Vrati pozici retezce v retezci od urcite pozice (vyhledava zleva)
************************************************************************************
PROCEDURE AT_Ex(lcSource,lcString,liStart,liEnd)
* @lcSource - Zdrojovy retezec
* @lcString - Hledany retezec
* liStart   - Startovaci pozice pro hledani
* liEnd     - Konecna pozice pro hledani
LOCAL liLen
liLen=LEN(m.lcString)
liEnd=IIF(PCOUNT()=4,m.liEnd,LEN(m.lcSource))
DO WHILE m.liStart<=m.liEnd AND !SUBS(m.lcSource,m.liStart,m.liLen)==m.lcString
   liStart=m.liStart+1 && Inkrementuj citac
ENDDO
RETURN IIF(m.liStart>m.liEnd,0,;
       IIF(!SUBS(m.lcSource,m.liStart,m.liLen)==m.lcString,0,m.liStart)) && Vrat pocatecni pozici
ENDPROC

************************************************************************************
** Vrati pozici retezce v retezci od urcite pozice (vyhledava zprava)
************************************************************************************
PROCEDURE RAT_Ex(lcSource,lcString,liStart,liEnd)
* @lcSource - Zdrojovy retezec
* @lcString - Hledany retezec
* liStart   - Startovaci pozice pro hledani
* liEnd     - Konecna pozice pro hledani
LOCAL liLen
liLen=LEN(m.lcString)
liEnd=IIF(PCOUNT()=4,m.liEnd,1)
DO WHILE m.liStart>=m.liEnd AND !SUBS(m.lcSource,m.liStart,m.liLen)==m.lcString
   liStart=m.liStart-1 && Dekrementuj citac
ENDDO
RETURN IIF(m.liStart<m.liEnd,0,;
       IIF(!SUBS(m.lcSource,m.liStart,m.liLen)==m.lcString,0,m.liStart)) && Vrat pocatecni pozici nalezeneho retezce
ENDPROC


***************************************************************************************
* Rozbali string dle %%
***************************************************************************************
PROCEDURE API_ExpandEnvironmentStrings(lcString)
* lcString - string, ktery se ma rozbalit

LOCAL lcOut
lcString=m.lcString+CHR(0)
DO WHILE .T.
   lcOut=SPACE(254)+CHR(0)
   =cvp_ExpandEnvironmentStrings(m.lcString,@m.lcOut,LEN(m.lcOut))
   lcOut=NullTermined(m.lcOut) && Zbav se NULL znaku

   IF UPPER(m.lcOut)==UPPER(m.lcString)
      EXIT && Ukonci smycku
   ENDIF
   lcString=m.lcOut
ENDDO

RETURN m.lcOut
ENDPROC



*****************************************************************
* definice obecnych trid
******************************************************************
DEFINE CLASS _ParObj AS custom  && univerzalni trida pro parametry
   Name="_ParObj"
   DIME pArray(1)
   OK     = .F. && priznak uspesnosti
   Par1   = .F.
   Par2   = .F.
   Par3   = .F.
   Par4   = .F.
   Par5   = .F.
   Par6   = .F.
   Par7   = .F.
   Par8   = .F.
   Par9   = .F.
   Par10  = .F.
ENDDEFINE 



************************************************************
* definice tridy sloupce pro grid
DEFINE CLASS _Column AS Column
   Name="_Column"
   txtclass="_textbox"
   ADD OBJECT Header1 AS Header

   FontName="Tahoma"
   FontSize=8
   DecimalPlace=0

   Header1.FontName="Tahoma"
   Header1.FontSize=8

   BackColor=RGB(255,255,255)  && barva pozadi sloupce
   ForeColor=RGB(000,000,000)  && barva pisma sloupce
   ReadOnly=.T.

   PROCEDURE Init
      This.RemoveObject("Text1")
      This.AddObject("Text1",This.txtClass)
      WITH This.Text1
      .Visible=.T.
      .Margin=0    
      .FocusColor=.F.
      .BorderStyle=0  && bez okraje
      .SpecialEffect=1  && plain
      .PropAsColumn=.T.
      ENDWITH
   ENDPROC

   PROCEDURE Show
      STORE .T. TO This.Visible,This.Text1.Visible  && ukaz textbox
   ENDPROC

   PROCEDURE Header1.DblClick
      LOCAL liMRow, liMRowMax
      liMRow=MCOL(Thisform.Name,3) && pozice mysi
      liMRowMax=OBJTOCLIENT(This,2)+This.Parent.Width+1 && pozice sloupce + sirka sloupce prevedeno na formular
      * pokud ses mimo
      IF ! BETWEEN(m.liMRow,m.liMRowMax-5,m.liMRowMax+5)
         RETURN && pak se vrat
      ENDIF

      This.Parent.AutoFitEx()
   ENDPROC



   PROCEDURE AutoFitEx(llAlwaysResize, llAllRows)
      LOCAL liSele,liRecno,liHeight,liRow,lolbl,liRelRow,lcSource,loColumn,liMax,luVal,lcType,lcSCOPE
      LOCAL ARRAY laFont(6)

      IF EOF(This.Parent.RecordSource) && pokud tam neni ani zaznam
         RETURN && pak se vrat
      ENDIF

      loColumn=This && aktivni sloupec
      lcSource=loColumn.ControlSource && zdroj dat
      IF EMPTY(lcSource) OR EMPTY(loColumn.CurrentControl) OR (!loColumn.Resizable AND !m.llAlwaysResize)
         RETURN
      ENDIF


      liSele=SELE() && uschovej si oblast
      WITH This.Parent
      SELE (.RecordSource) && skoc na tabulku
      liHeight=.Height-.HeaderHeight-IIF(INLIST(.ScrollBars,1,3),SYSMETRIC(8),0)
      liRow=INT(liHeight/.RowHeight)
      liRelRow=.RelativeRow && relativni radek
      ENDWITH
 
      loControl=EVAL("loColumn."+loColumn.CurrentControl)
      lcType=TYPE("EVAL(lcSource)")
      
      * nyni projdu viditelny radky a zjistim sirku textu
      liRecno=RECNO() && zjisti puvodni vetu


      * USCHOVANI INF. O FINTU NA SCREENU
      laFont(1)=_SCREEN.FontName
      laFont(2)=_SCREEN.FontSize
      laFont(3)=_SCREEN.FontBold
      laFont(4)=_SCREEN.FontItalic
      laFont(5)=_SCREEN.FontStrikethru
      laFont(6)=_SCREEN.FontUnderline

      IF !PEMSTATUS(loControl,"PropAsColumn",5) OR PEMSTATUS(loControl,"PropAsColumn",5) AND !loControl.PropAsColumn
         * NASTAVENI INF. FontU NA SCREENU DLE OBJEKTU
         _SCREEN.FontName=loControl.FontName
         _SCREEN.FontSize=loControl.FontSize
         _SCREEN.FontBold=loControl.FontBold
         _SCREEN.FontItalic=loControl.FontItalic
         _SCREEN.FontStrikethru=loControl.FontStrikethru
         _SCREEN.FontUnderline=loControl.FontUnderline
      ENDIF

      SKIP -1*(liRelRow-1) && skoc na zacatek viditelneho obsahu
      liMax=0

      lcSCOPE=IIF(llAllRows,"ALL", "NEXT "+LTRIM(STR(liRow,11)))

      DO CASE
         CASE lcType='C' && retezec
              SCAN &lcSCOPE.
                   IF PEMSTATUS(loControl,"PropAsColumn",5) AND loControl.PropAsColumn
                      * NASTAVENI INF. FontU NA SCREENU DLE OBJEKTU
                      _SCREEN.FontName=IIF(EMPTY(loColumn.DynamicFontName),loColumn.FontName,EVAL(loColumn.DynamicFontName))
                      _SCREEN.FontSize=IIF(EMPTY(loColumn.DynamicFontSize),loColumn.FontSize,EVAL(loColumn.DynamicFontSize))
                      _SCREEN.FontBold=IIF(EMPTY(loColumn.DynamicFontBold),loColumn.FontBold,EVAL(loColumn.DynamicFontBold))
                      _SCREEN.FontItalic=IIF(EMPTY(loColumn.DynamicFontItalic),loColumn.FontItalic,EVAL(loColumn.DynamicFontItalic))
                      _SCREEN.FontStrikethru=IIF(EMPTY(loColumn.DynamicFontStrikethru),loColumn.FontStrikethru,EVAL(loColumn.DynamicFontStrikethru))
                      _SCREEN.FontUnderline=IIF(EMPTY(loColumn.DynamicFontUnderline),loColumn.FontUnderline,EVAL(loColumn.DynamicFontUnderline))
                   ENDIF

                   luVal=EVAL(lcSource)
                   liMax=MAX(_SCREEN.TextWidth(IIF(ISNUL(luVal),".NULL.",RTRIM(luVal)))+10,liMax)
              ENDSCAN

         CASE lcType='M' && retezec
              IF PEMSTATUS(loControl,"PropAsColumn",5) AND loControl.PropAsColumn
                 * NASTAVENI INF. FontU NA SCREENU DLE OBJEKTU
                 _SCREEN.FontName=IIF(EMPTY(loColumn.DynamicFontName),loColumn.FontName,EVAL(loColumn.DynamicFontName))
                 _SCREEN.FontSize=IIF(EMPTY(loColumn.DynamicFontSize),loColumn.FontSize,EVAL(loColumn.DynamicFontSize))
                 _SCREEN.FontBold=IIF(EMPTY(loColumn.DynamicFontBold),loColumn.FontBold,EVAL(loColumn.DynamicFontBold))
                 _SCREEN.FontItalic=IIF(EMPTY(loColumn.DynamicFontItalic),loColumn.FontItalic,EVAL(loColumn.DynamicFontItalic))
                 _SCREEN.FontStrikethru=IIF(EMPTY(loColumn.DynamicFontStrikethru),loColumn.FontStrikethru,EVAL(loColumn.DynamicFontStrikethru))
                 _SCREEN.FontUnderline=IIF(EMPTY(loColumn.DynamicFontUnderline),loColumn.FontUnderline,EVAL(loColumn.DynamicFontUnderline))
              ENDIF
              luVal="Memo"
              liMax=_SCREEN.TextWidth(luVal)+10

         CASE lcType='L' && logicka hodnota
              SCAN &lcSCOPE.
                   IF PEMSTATUS(loControl,"PropAsColumn",5) AND loControl.PropAsColumn
                      * NASTAVENI INF. FontU NA SCREENU DLE OBJEKTU
                      _SCREEN.FontName=IIF(EMPTY(loColumn.DynamicFontName),loColumn.FontName,EVAL(loColumn.DynamicFontName))
                      _SCREEN.FontSize=IIF(EMPTY(loColumn.DynamicFontSize),loColumn.FontSize,EVAL(loColumn.DynamicFontSize))
                      _SCREEN.FontBold=IIF(EMPTY(loColumn.DynamicFontBold),loColumn.FontBold,EVAL(loColumn.DynamicFontBold))
                      _SCREEN.FontItalic=IIF(EMPTY(loColumn.DynamicFontItalic),loColumn.FontItalic,EVAL(loColumn.DynamicFontItalic))
                      _SCREEN.FontStrikethru=IIF(EMPTY(loColumn.DynamicFontStrikethru),loColumn.FontStrikethru,EVAL(loColumn.DynamicFontStrikethru))
                      _SCREEN.FontUnderline=IIF(EMPTY(loColumn.DynamicFontUnderline),loColumn.FontUnderline,EVAL(loColumn.DynamicFontUnderline))
                   ENDIF
                   luVal=EVAL(lcSource)
                   liMax=MAX(_SCREEN.TextWidth(IIF(ISNUL(luVal),".NULL.",IIF(luVal,'T','F')))+10,liMax)
              ENDSCAN

         CASE lcType='I' && Integer hodnota
              SCAN &lcSCOPE.
                   IF PEMSTATUS(loControl,"PropAsColumn",5) AND loControl.PropAsColumn
                      * NASTAVENI INF. FontU NA SCREENU DLE OBJEKTU
                      _SCREEN.FontName=IIF(EMPTY(loColumn.DynamicFontName),loColumn.FontName,EVAL(loColumn.DynamicFontName))
                      _SCREEN.FontSize=IIF(EMPTY(loColumn.DynamicFontSize),loColumn.FontSize,EVAL(loColumn.DynamicFontSize))
                      _SCREEN.FontBold=IIF(EMPTY(loColumn.DynamicFontBold),loColumn.FontBold,EVAL(loColumn.DynamicFontBold))
                      _SCREEN.FontItalic=IIF(EMPTY(loColumn.DynamicFontItalic),loColumn.FontItalic,EVAL(loColumn.DynamicFontItalic))
                      _SCREEN.FontStrikethru=IIF(EMPTY(loColumn.DynamicFontStrikethru),loColumn.FontStrikethru,EVAL(loColumn.DynamicFontStrikethru))
                      _SCREEN.FontUnderline=IIF(EMPTY(loColumn.DynamicFontUnderline),loColumn.FontUnderline,EVAL(loColumn.DynamicFontUnderline))
                   ENDIF
                   luVal=EVAL(lcSource)
                   liMax=MAX(_SCREEN.TextWidth(IIF(ISNUL(luVal),".NULL.",LTRIM(STR(luVal,20))))+10,liMax)
              ENDSCAN

         CASE lcType$'Y,N,F,B' && numericka hodnota
              SCAN &lcSCOPE.
                   IF PEMSTATUS(loControl,"PropAsColumn",5) AND loControl.PropAsColumn
                      * NASTAVENI INF. FontU NA SCREENU DLE OBJEKTU
                      _SCREEN.FontName=IIF(EMPTY(loColumn.DynamicFontName),loColumn.FontName,EVAL(loColumn.DynamicFontName))
                      _SCREEN.FontSize=IIF(EMPTY(loColumn.DynamicFontSize),loColumn.FontSize,EVAL(loColumn.DynamicFontSize))
                      _SCREEN.FontBold=IIF(EMPTY(loColumn.DynamicFontBold),loColumn.FontBold,EVAL(loColumn.DynamicFontBold))
                      _SCREEN.FontItalic=IIF(EMPTY(loColumn.DynamicFontItalic),loColumn.FontItalic,EVAL(loColumn.DynamicFontItalic))
                      _SCREEN.FontStrikethru=IIF(EMPTY(loColumn.DynamicFontStrikethru),loColumn.FontStrikethru,EVAL(loColumn.DynamicFontStrikethru))
                      _SCREEN.FontUnderline=IIF(EMPTY(loColumn.DynamicFontUnderline),loColumn.FontUnderline,EVAL(loColumn.DynamicFontUnderline))
                   ENDIF
                   luVal=EVAL(lcSource)
                   liMax=MAX(_SCREEN.TextWidth(IIF(ISNUL(luVal),".NULL.",LTRIM(STR(luVal, 30, This.DecimalPlace))))+10,liMax)
              ENDSCAN
              
         CASE lcType='D' && datum
              SCAN &lcSCOPE.
                   IF PEMSTATUS(loControl,"PropAsColumn",5) AND loControl.PropAsColumn
                      * NASTAVENI INF. FontU NA SCREENU DLE OBJEKTU
                      _SCREEN.FontName=IIF(EMPTY(loColumn.DynamicFontName),loColumn.FontName,EVAL(loColumn.DynamicFontName))
                      _SCREEN.FontSize=IIF(EMPTY(loColumn.DynamicFontSize),loColumn.FontSize,EVAL(loColumn.DynamicFontSize))
                      _SCREEN.FontBold=IIF(EMPTY(loColumn.DynamicFontBold),loColumn.FontBold,EVAL(loColumn.DynamicFontBold))
                      _SCREEN.FontItalic=IIF(EMPTY(loColumn.DynamicFontItalic),loColumn.FontItalic,EVAL(loColumn.DynamicFontItalic))
                      _SCREEN.FontStrikethru=IIF(EMPTY(loColumn.DynamicFontStrikethru),loColumn.FontStrikethru,EVAL(loColumn.DynamicFontStrikethru))
                      _SCREEN.FontUnderline=IIF(EMPTY(loColumn.DynamicFontUnderline),loColumn.FontUnderline,EVAL(loColumn.DynamicFontUnderline))
                   ENDIF
                   luVal=EVAL(lcSource)
                   liMax=MAX(_SCREEN.TextWidth(IIF(ISNUL(luVal),".NULL.",DTOC(luVal)))+10,liMax)
              ENDSCAN

         CASE lcType='T' && datum a cas
              SCAN &lcSCOPE.
                   IF PEMSTATUS(loControl,"PropAsColumn",5) AND loControl.PropAsColumn
                      * NASTAVENI INF. FontU NA SCREENU DLE OBJEKTU
                      _SCREEN.FontName=IIF(EMPTY(loColumn.DynamicFontName),loColumn.FontName,EVAL(loColumn.DynamicFontName))
                      _SCREEN.FontSize=IIF(EMPTY(loColumn.DynamicFontSize),loColumn.FontSize,EVAL(loColumn.DynamicFontSize))
                      _SCREEN.FontBold=IIF(EMPTY(loColumn.DynamicFontBold),loColumn.FontBold,EVAL(loColumn.DynamicFontBold))
                      _SCREEN.FontItalic=IIF(EMPTY(loColumn.DynamicFontItalic),loColumn.FontItalic,EVAL(loColumn.DynamicFontItalic))
                      _SCREEN.FontStrikethru=IIF(EMPTY(loColumn.DynamicFontStrikethru),loColumn.FontStrikethru,EVAL(loColumn.DynamicFontStrikethru))
                      _SCREEN.FontUnderline=IIF(EMPTY(loColumn.DynamicFontUnderline),loColumn.FontUnderline,EVAL(loColumn.DynamicFontUnderline))
                   ENDIF
                   luVal=EVAL(lcSource)
                   liMax=MAX(_SCREEN.TextWidth(IIF(ISNUL(luVal),".NULL.",TTOC(luVal)))+10,liMax)
              ENDSCAN

         CASE lcType='G' && general ( objekt )
              IF PEMSTATUS(loControl,"PropAsColumn",5) AND loControl.PropAsColumn
                 * NASTAVENI INF. FontU NA SCREENU DLE OBJEKTU
                 _SCREEN.FontName=IIF(EMPTY(loColumn.DynamicFontName),loColumn.FontName,EVAL(loColumn.DynamicFontName))
                 _SCREEN.FontSize=IIF(EMPTY(loColumn.DynamicFontSize),loColumn.FontSize,EVAL(loColumn.DynamicFontSize))
                 _SCREEN.FontBold=IIF(EMPTY(loColumn.DynamicFontBold),loColumn.FontBold,EVAL(loColumn.DynamicFontBold))
                 _SCREEN.FontItalic=IIF(EMPTY(loColumn.DynamicFontItalic),loColumn.FontItalic,EVAL(loColumn.DynamicFontItalic))
                 _SCREEN.FontStrikethru=IIF(EMPTY(loColumn.DynamicFontStrikethru),loColumn.FontStrikethru,EVAL(loColumn.DynamicFontStrikethru))
                 _SCREEN.FontUnderline=IIF(EMPTY(loColumn.DynamicFontUnderline),loColumn.FontUnderline,EVAL(loColumn.DynamicFontUnderline))
              ENDIF
              luVal='General'
              liMax=_SCREEN.TextWidth(luVal)+10
      ENDCASE

      _SCREEN.FontName=laFont(1)
      _SCREEN.FontSize=laFont(2)
      _SCREEN.FontBold=laFont(3)
      _SCREEN.FontItalic=laFont(4)
      _SCREEN.FontStrikethru=laFont(5)
      _SCREEN.FontUnderline=laFont(6)

      GO liRecno && skoc na puvodni vetu
      IF liMax>0 && pokud tam neco je
         loColumn.Width=liMax && pak nastav novou sirku
      ENDIF
      SELE (liSele)
   ENDPROC

ENDDEFINE
