LPARAM m.luPar1, m.luPar2, m.luPar3, m.luPar4, m.luPar5

* Load localized layout report to basic report
LOCAL m.loRPTL, m.llRet
m.loRPTL=CREATEOBJECT("_rptlocalize")
DO CASE
   CASE m.luPar1=="L"
        m.llRet=m.loRPTL.CreateLayout(@m.luPar2, @m.luPar3, @m.luPar4, @m.luPar5)

   CASE m.luPar1=="S"
        m.llRet=m.loRPTL.SynchroniseLayout(@m.luPar2, @m.luPar3, @m.luPar4)

   CASE m.luPar1=="C"
        m.llRet=m.loRPTL.SynchroniseLayoutX(@m.luPar2, @m.luPar3)

   CASE m.luPar1=="CL"
        m.llRet=m.loRPTL.CopyLayout(@m.luPar2, @m.luPar3)

ENDCASE
RETURN m.llRet

*************************************************************************************

************************************************************************
DEFINE CLASS _rptlocalize AS CUSTOM
   lErr=.F.

   PROCEDURE Error
      LPARAMETERS m.nError, m.cMethod, m.nLine
      * nError  - Error number
      * cMethod - Name procedure
      * nLine   - Row number

      LOCAL m.lcErr, m.lii, m.lcCProg, m.lcPom

      DO CASE
         CASE UPPER(m.cMethod)=="CREATETABLE" OR;
              UPPER(m.cMethod)=="OPENTABLE" OR ;
              UPPER(m.cMethod)=="COPYFILE"

              This.lErr=.T.
         OTHERWISE

              IF TYPE("XX_System")="O"
                 m.lii=0
                 m.lcCProg="A"
                 m.lcPom=""
                 DO WHILE !EMPTY(m.lcCProg)
                    m.lii=m.lii+1  && Inkrementuj citac
                    m.lcCProg=PROGRAM(m.lii)   && Nazev programu
                    m.lcPom=m.lcPom+CHR(9)+m.lcCProg+CRLF
                 ENDDO

                 =m.XX_System.OPT.Add(m.XX_System.GetModulObj(),;
                                      CHR(9)+"E: "+LTRIM(STR(m.nError, 11))+" M: "+m.cMethod+" L: "+LTRIM(STR(m.nLine, 11))+CRLF+;
                                      CHR(9)+MESSAGE()+CRLF+CHR(9)+MESSAGE(1)+CRLF+;
                                      m.lcPom, .T.)

              ENDIF 

              m.lcErr=ON("ERROR")
              IF !EMPTY(m.lcErr)
                 ON ERROR &lcErr.
              ELSE
                 =DODEFAULT(m.nError, m.cMethod, m.nLine)
                 ERROR m.nError
              ENDIF
      ENDCASE
   ENDPROC

   PROTECTED PROCEDURE CreateTable
      LPARAMETERS m.lcNew, m.laFields, m.lcAlias
      * lcNew    - New file
      * laFields - Array with structure
      * lcAlias  - Alias
      
      This.lErr=.F.
      CREATE TABLE (m.lcNew) FREE  FROM ARRAY m.laFields
      IF !This.lErr
         USE
         USE (m.lcNew) IN 0 ALIAS (m.lcAlias)
      ENDIF
      RETURN !This.lErr
   ENDPROC

   PROTECTED PROCEDURE OpenTable
      LPARAMETERS m.lcTable, m.lcAlias, m.lcParam
      
      This.lErr=.F.
      USE (m.lcTable) ALIAS (m.lcAlias) IN 0 &lcParam.
      RETURN !This.lErr
   ENDPROC

   PROTECTED PROCEDURE CopyFile
      LPARAMETERS m.lcSR, m.lcDR
      
      This.lErr=.F.
      COPY FILE (m.lcSR) TO (m.lcDR)
      RETURN !This.lErr
   ENDPROC

   PROTECTED PROCEDURE GetLCC && Return LCC from comment
      LPARAMETERS m.lcComment, m.lcLCC, m.lcLCCSC, m.llOnlyBasicLCC
      
      LOCAL m.lii, m.liy
      m.lii=AT("LCC:", m.lcComment)
      m.lcLCC=""
      IF m.lii>0
         m.lcPom=SUBST(m.lcComment, m.lii+4)
         m.liy=AT(CHR(13), m.lcPom)
         m.lcLCC=ALLT(IIF(m.liy>0, LEFT(m.lcPom, m.liy-1), m.lcPom))
         m.liy=RAT(":", m.lcLCC)
         IF m.liy>0
            m.lcLCCSC=SUBST(m.lcLCC, m.liy+1)
            m.lcLCC=LEFT(m.lcLCC, m.liy-1)
         ELSE
            m.lcLCCSC=""
         ENDIF
         IF m.llOnlyBasicLCC
            m.liy=AT(":", m.lcLCC)
            IF m.liy>0
               m.lcLCC=LEFT(m.lcLCC, m.liy-1)
            ENDIF
         ENDIF

      ENDIF
      RETURN m.lii
   ENDPROC

   PROTECTED PROCEDURE SetLCC
      LPARAMETERS m.lcComment, m.lcLCC, m.lcLCCSC
      
      LOCAL m.lii, m.liy
      m.lii=AT("LCC:", m.lcComment)
      IF m.lii>0
         m.lcPom=SUBST(m.lcComment, m.lii+4)
         m.liy=AT(CHR(13), m.lcPom)
         m.lcComment=STUFF(m.lcComment, m.lii, IIF(m.liy=0, LEN(m.lcComment)-m.lii+1, m.liy+4-1), "LCC:"+m.lcLCC+":"+m.lcLCCSC)
      ELSE
         m.lcComment=m.lcComment+"LCC:"+m.lcLCC+":"+m.lcLCCSC
      ENDIF
      RETURN m.lcComment
   ENDPROC


   PROCEDURE CreateLayout
      LPARAMETERS m.lcABasic, m.lcALayout, m.lcNew, m.lcAShadow
      * lcABasic     - Alias basic report
      * lcALayout    - Alias Layout report
      * lcNew     - Output file (report)
      *@lcAShadow - Output alias (report)

      LOCAL m.lcLCC, m.lii, m.liSRX, m.loRam, m.lcATMP
      LOCAL ARRAY m.laRow(1), m.laSR_C(1), m.laSR_R(1), m.laFields(1)

      m.lcATMP=SYS(2015)
      m.lcAShadow=SYS(2015)

      * Scan basic report
      SELE (m.lcABasic)
      COUNT TO m.liSRX FOR INLIST(OBJTYPE, 5, 6, 7, 8, 17, 9)
      IF m.liSRX>0
         DIME m.laSR_C(m.liSRX, 1), m.laSR_R(m.liSRX, 1)
      ENDIF

      * check LCC
      SCAN FOR INLIST(OBJTYPE, 5, 6, 7, 8, 17, 9)
           * locate LCC code
           IF OBJTYPE=9
              m.lcLCC=STR(OBJTYPE, 3)+STR(OBJCODE, 3)+EXPR
           ELSE
              =This.GetLCC(COMMENT, @m.lcLCC, "")
           ENDIF
           * If not exist, add it
           IF EMPTY(m.lcLCC)
              m.lcLCC=SYS(2015)
              REPL COMMENT WITH COMMENT+CHR(13)+CHR(10)+"LCC:"+m.lcLCC
           ENDIF
      ENDSCAN

      * Create copy record
      =AFIELDS(m.laFields)

      SELE 0 
      CREATE CURSOR (m.lcATMP) FROM ARRAY m.laFields
      SELE 0
      IF !This.CreateTable(m.lcNew, @m.laFields, m.lcAShadow)
         RETURN .F.
      ENDIF

      SELE (m.lcABasic)
      SCAN FOR INLIST(OBJTYPE, 5, 6, 7, 8, 17, 9)
           SCATTER TO m.laRow MEMO
           INSERT INTO (m.lcATMP) FROM ARRAY m.laRow
      ENDSCAN

      SELE (m.lcABasic)
      SCAN FOR !INLIST(OBJTYPE, 5, 6, 7, 8, 17, 9, 25, 26, 18)
           SCATTER TO m.laRow MEMO
           INSERT INTO (m.lcAShadow) FROM ARRAY m.laRow
      ENDSCAN

      SELE (m.lcATMP)
      * Create index 
      m.liSRX=1
      SCAN ALL
           =This.GetLCC(COMMENT, @m.lcLCC, "")
           m.laSR_C(m.liSRX)=m.lcLCC
           m.laSR_R(m.liSRX)=RECNO()
           m.liSRX=m.liSRX+1
      ENDSCAN

      * Find all non objects
      SELE (m.lcALayout)
      SCAN FOR INLIST(OBJTYPE, 5, 6, 7, 8, 17, 9)
           IF OBJTYPE=9
              m.lcLCC=STR(OBJTYPE, 3)+STR(OBJCODE, 3)+EXPR
           ELSE
              =This.GetLCC(COMMENT, @m.lcLCC, "")
           ENDIF
           IF !EMPTY(m.lcLCC)
              lii=ASCAN(m.laSR_C, m.lcLCC)
              IF m.lii=0 && Not found, Insert It
                 SCATTER TO m.laRow MEMO
                 INSERT INTO (m.lcAShadow) FROM ARRAY m.laRow
              ELSE
                 * 5,6,7,8,17. VPOS, HPOS, WITDH, HEIGHT
                 * 9 WITDH, HEIGHT
                 * 5 EXPR
                 SCATTER NAME m.loRam MEMO
                 SELE (m.lcATMP)
                 GO (m.laSR_R(m.lii))
                 DO CASE
                    CASE OBJTYPE=9
                         REPLACE PLAIN WITH m.loRam.PLAIN, HEIGHT WITH m.loRam.HEIGHT

                    CASE OBJTYPE=17
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 GENERAL WITH m.loRam.GENERAL, DOUBLE WITH m.loRam.DOUBLE,;
                                 MODE WITH m.loRam.MODE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP,;
                                 NAME WITH m.loRam.NAME,;
                                 PICTURE WITH m.loRam.PICTURE
                           
                    CASE OBJTYPE=5
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 EXPR WITH m.loRam.EXPR,;
                                 PENRED WITH m.loRam.PENRED,PENGREEN WITH m.loRam.PENGREEN,PENBLUE WITH m.loRam.PENBLUE,;
                                 FILLRED WITH m.loRam.FILLRED,FILLGREEN WITH m.loRam.FILLGREEN,FILLBLUE WITH m.loRam.FILLBLUE,;
                                 FONTFACE WITH m.loRam.FONTFACE,FONTSIZE WITH m.loRam.FONTSIZE,FONTSTYLE WITH m.loRam.FONTSTYLE,;
                                 MODE WITH m.loRam.MODE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP,;
                                 PICTURE WITH m.loRam.PICTURE,;
                                 SPACING WITH m.loRam.SPACING,;
                                 OFFSET WITH m.loRam.OFFSET,;
                                 RESOID WITH m.loRam.RESOID


                    CASE OBJTYPE=6
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 PENSIZE WITH m.loRam.PENSIZE,PENPAT WITH m.loRam.PENPAT,;
                                 PENRED WITH m.loRam.PENRED,PENGREEN WITH m.loRam.PENGREEN,PENBLUE WITH m.loRam.PENBLUE,;
                                 FILLRED WITH m.loRam.FILLRED,FILLGREEN WITH m.loRam.FILLGREEN,FILLBLUE WITH m.loRam.FILLBLUE,;
                                 MODE WITH m.loRam.MODE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP


                    CASE OBJTYPE=7
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 PENSIZE WITH m.loRam.PENSIZE,PENPAT WITH m.loRam.PENPAT,FILLPAT WITH m.loRam.FILLPAT,;
                                 PENRED WITH m.loRam.PENRED,PENGREEN WITH m.loRam.PENGREEN,PENBLUE WITH m.loRam.PENBLUE,;
                                 FILLRED WITH m.loRam.FILLRED,FILLGREEN WITH m.loRam.FILLGREEN,FILLBLUE WITH m.loRam.FILLBLUE,;
                                 MODE WITH m.loRam.MODE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP,;
                                 OFFSET WITH m.loRam.OFFSET


                    CASE OBJTYPE=8
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 FONTFACE WITH m.loRam.FONTFACE,FONTSIZE WITH m.loRam.FONTSIZE,FONTSTYLE WITH m.loRam.FONTSTYLE,;
                                 PENRED WITH m.loRam.PENRED,PENGREEN WITH m.loRam.PENGREEN,PENBLUE WITH m.loRam.PENBLUE,;
                                 FILLRED WITH m.loRam.FILLRED,FILLGREEN WITH m.loRam.FILLGREEN,FILLBLUE WITH m.loRam.FILLBLUE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 MODE WITH m.loRam.MODE,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP,;
                                 PICTURE WITH m.loRam.PICTURE,;
                                 SPACING WITH m.loRam.SPACING,;
                                 OFFSET WITH m.loRam.OFFSET,;
                                 RULERLINES WITH m.loRam.RULERLINES,;
                                 RESOID WITH m.loRam.RESOID

                 ENDCASE
                 SCATTER TO m.laRow MEMO
                 INSERT INTO (m.lcAShadow) FROM ARRAY m.laRow
           
                 SELE (m.lcALayout)
              ENDIF
           ELSE
              SCATTER TO m.laRow MEMO
              INSERT INTO (m.lcAShadow) FROM ARRAY m.laRow
           ENDIF
      ENDSCAN

      * Append DE
      SELE (m.lcABasic)
      SCAN FOR INLIST(OBJTYPE, 18, 25, 26, 23)
           SCATTER TO m.laRow MEMO
           INSERT INTO (m.lcAShadow) FROM ARRAY m.laRow
      ENDSCAN
      USE IN (m.lcATMP)
      RETURN .T.
   ENDPROC

   PROCEDURE SynchroniseLayout && Synchronization localized report with basic report
      LPARAMETERS m.lcSR, m.lcDR, m.liMode
      * lcSR   - Source report
      * lcDR   - Destination report - layout
      * liMode - Synchrnoisation mode (0 - transitional, 1 - strict)
      
      LOCAL m.lcASR, m.lcADR, m.lcLCC, m.llExist, m.lii, m.liDR, m.liSR, m.lcLCCSC, m.llDele, m.liWIDTH, m.liSRX, m.lcSafety, m.lcATMP
      LOCAL ARRAY m.laRow(1), m.laDR_C(1), m.laDR_R(1), m.laDR_SC(1), m.laSR_C(1), m.laSR_R(1), m.laFields(1)
      m.liMode=IIF(PCOUNT()<3 OR TYPE("m.liMode")#"N", 0, m.liMode)

      m.lcSafety=SET("SAFETY")
      SET SAFETY OFF

      m.lcASR=SYS(2015)
      m.lcADR=SYS(2015)
      m.lcATMP=SYS(2015)

      IF !FILE(m.lcDR)
         IF !This.CopyFile(m.lcSR, m.lcDR)
            DELE FILE (m.lcDR)
            RETURN .F.
         ENDIF

         IF !This.CopyFile(STRTRAN(LOWER(m.lcSR), ".frx", ".frt"), STRTRAN(LOWER(m.lcDR), ".frx", ".frt"))
            DELE FILE (STRTRAN(LOWER(m.lcDR), ".frx", ".frt"))
            RETURN .F.
         ENDIF
      ELSE
         m.llExist=.T.
      ENDIF

      IF !This.OpenTable(m.lcSR, m.lcASR, " AGAIN")
         RETURN .F.
      ENDIF

      IF !This.OpenTable(m.lcDR, m.lcADR, " EXCLUSIVE")
         USE IN (m.lcASR)
         RETURN .F.
      ENDIF

      * Create copy record
      SELE (m.lcASR)
      =AFIELDS(m.laFields)

      SELE 0 
      CREATE CURSOR (m.lcATMP) FROM ARRAY m.laFields

      SELE (m.lcADR)
      SCAN FOR INLIST(OBJTYPE, 5, 6, 7, 8, 17, 9)
           SCATTER TO m.laRow MEMO
           INSERT INTO (m.lcATMP) FROM ARRAY m.laRow
      ENDSCAN
      ZAP

      SELE (m.lcASR)
      SCAN FOR !INLIST(OBJTYPE, 5, 6, 7, 8, 17, 9, 25, 26, 23, 18)
           SCATTER TO m.laRow MEMO
           INSERT INTO (m.lcADR) FROM ARRAY m.laRow
      ENDSCAN

      * Find all non objects
      m.liDR=0
      IF m.llExist
         SELE (m.lcATMP)
         m.liDR=RECC()
         IF m.liDR>0
            DIME m.laDR_C(m.liDR, 1), m.laDR_R(m.liDR,1), m.laDR_SC(m.liDR,1), m.laDR_RX(m.liDR,1)
         ENDIF
         GO BOTTOM
         m.lii=0

         DO WHILE !BOF()
            IF OBJTYPE=9
               m.lcLCC=STR(OBJTYPE, 3)+STR(OBJCODE, 3)+EXPR
               m.lcLCCSC=""
               SELE (m.lcASR)
               LOCATE FOR STR(OBJTYPE, 3)+STR(OBJCODE, 3)+EXPR==m.lcLCC
               IF !FOUND()
                  m.lcLCC=""
               ENDIF
               SELE (m.lcATMP)
            ELSE
               =This.GetLCC(COMMENT, @m.lcLCC, @m.lcLCCSC)
            ENDIF
            IF !EMPTY(m.lcLCC)
               m.lii=m.lii+1
               m.laDR_C(m.lii)=m.lcLCC
               m.laDR_SC(m.lii)=m.lcLCCSC
               m.laDR_R(m.lii)=RECNO()
            ELSE
               IF m.liMode=1 OR OBJTYPE=9
                  DELE NEXT 1
                  m.llDele=.T.
               ENDIF
            ENDIF
            SKIP -1
         ENDDO

         m.liDR=m.lii
         IF m.liDR>0
            DIME m.laDR_C(m.lii), m.laDR_R(m.lii), m.laDR_RX(m.lii), m.laDR_SC(m.lii)
         ENDIF

         IF m.llDele
            PACK
         ENDIF


         SCAN ALL
              IF OBJTYPE=9
                 m.lcLCC=STR(OBJTYPE, 3)+STR(OBJCODE, 3)+EXPR
                 m.lcLCCSC=""
              ELSE
                 =This.GetLCC(COMMENT, @m.lcLCC, @m.lcLCCSC)
              ENDIF

              SCATTER TO m.laRow MEMO
              INSERT INTO (m.lcADR) FROM ARRAY m.laRow

              IF !EMPTY(m.lcLCC)
                 lii=ASCAN(m.laDR_C, m.lcLCC)
                 IF m.lii>0 && found
                    m.laDR_RX(m.lii)=RECC(m.lcADR)
                 ENDIF
              ENDIF
         ENDSCAN
      ENDIF

      SELE (m.lcASR)
      COUNT TO liSR FOR INLIST(OBJTYPE, 5, 6, 7, 8, 17, 9)
      IF m.liSR>0
         DIME m.laSR_C(m.liSR, 1), m.laSR_R(m.liSR, 1)
      ENDIF
      m.liSRX=1

      SCAN FOR INLIST(OBJTYPE, 5, 6, 7, 8, 17, 9)
           * locate LCC code
           IF OBJTYPE=9
              m.lcLCC=STR(OBJTYPE, 3)+STR(OBJCODE, 3)+EXPR
              m.lcLCCSC=""
           ELSE
              =This.GetLCC(COMMENT, @m.lcLCC, @m.lcLCCSC)
           ENDIF

           * If not exist, add it
           IF EMPTY(m.lcLCC)
              m.lcLCC=SYS(2015)
              REPL COMMENT WITH COMMENT+CHR(13)+CHR(10)+"LCC:"+m.lcLCC
           ENDIF
           m.lcLCCSC=IIF(OBJTYPE=5, EXPR, "0000")
           m.liWIDTH=WIDTH

           m.laSR_C(m.liSRX)=m.lcLCC
           m.laSR_R(m.liSRX)=RECNO()
           m.liSRX=m.liSRX+1

           * locate object with same LCC code in localized report        
           m.lii=ASCAN(m.laDR_C, m.lcLCC)
           IF m.lii=0
              SCATTER TO m.laRow MEMO
              INSERT INTO (m.lcADR) FROM ARRAY m.laRow
              SELE (m.lcADR)
              REPL COMMENT WITH This.SetLCC(COMMENT, m.lcLCC, m.lcLCCSC)
           ELSE
              * LCC found, check LCC sub code
              IF OBJTYPE=5 AND !m.lcLCCSC==m.laDR_SC(m.lii)
                 SELE (m.lcADR)
                 GO (m.laDR_RX(m.lii))
                 REPL EXPR WITH '"'+SUBST(m.lcLCCSC, 2, LEN(m.lcLCCSC)-2)+" ("+SUBST(EXPR, 2, LEN(EXPR)-2)+")"+'"',;
                      COMMENT WITH This.SetLCC(COMMENT, m.lcLCC, m.lcLCCSC), WIDTH WITH WIDTH+m.liWIDTH
              ENDIF
              SELE (m.lcASR)
           ENDIF
      ENDSCAN

      SELE (m.lcADR)
      * Delete lost objects
      IF m.liSR>0 AND m.liDR>0
         m.llDele=.F.
         FOR m.lii=1 TO m.liDR
             IF ASCAN(m.laSR_C, m.laDR_C(m.lii))=0
                GO (m.laDR_RX(m.lii))
                DELETE NEXT 1
                m.llDele=.T.
             ENDIF
         NEXT

         IF m.llDele
            PACK
         ENDIF
      ENDIF

      * Append DE
      SELE (m.lcASR)
      SCAN FOR INLIST(OBJTYPE, 18, 25, 26, 23)
           SCATTER TO m.laRow MEMO
           INSERT INTO (m.lcADR) FROM ARRAY m.laRow
      ENDSCAN

      USE IN (m.lcASR)
      USE IN (m.lcADR)
      USE IN (m.lcATMP)

      IF m.lcSafety=="ON"
         SET SAFETY ON
      ENDIF
      RETURN
   ENDPROC


   PROCEDURE SynchroniseLayoutX && Create localized report from basic report
      LPARAMETERS m.lcSR, m.lcDR
      * lcSR   - Source report
      * lcDR   - Destination report - layout
      LOCAL m.lcASR, m.lcADR, m.lcLCC, m.llExist, m.lii, m.lcLCCSC, m.llDele, m.liWIDTH, m.lcSafety, m.lcPom
      LOCAL ARRAY m.laRow(1), m.laDR_C(1), m.laDR_R(1), m.laDR_SC(1), m.laFields(1)

      m.lcSafety=SET("SAFETY")
      SET SAFETY OFF

      m.lcASR=SYS(2015)
      m.lcADR=SYS(2015)
      m.lcATMP=SYS(2015)

      IF !FILE(m.lcDR)
         IF !This.CopyFile(m.lcSR, m.lcDR)
            DELE FILE (m.lcDR)
            RETURN .F.
         ENDIF

         IF !This.CopyFile(STRTRAN(LOWER(m.lcSR), ".frx", ".frt"), STRTRAN(LOWER(m.lcDR), ".frx", ".frt"))
            DELE FILE (STRTRAN(LOWER(m.lcDR), ".frx", ".frt"))
            RETURN .F.
         ENDIF
      ELSE
         m.llExist=.T.
      ENDIF

      IF !This.OpenTable(m.lcSR, m.lcASR, " AGAIN")
         RETURN .F.
      ENDIF

      IF !This.OpenTable(m.lcDR, m.lcADR, " EXCLUSIVE")
         USE IN (m.lcASR)
         RETURN .F.
      ENDIF


      SELE (m.lcADR)
      IF !m.llExist
         ZAP
      ELSE
         =AFIELDS(m.laFields)
         SELE 0 
         CREATE CURSOR (m.lcATMP) FROM ARRAY m.laFields

         SELE (m.lcADR)
         SCAN FOR OBJTYPE=5
              SCATTER TO m.laRow MEMO
              INSERT INTO (m.lcATMP) FROM ARRAY m.laRow
         ENDSCAN
         ZAP

         SELE (m.lcATMP)
         m.lii=RECC()
         IF m.lii>0
            DIME m.laDR_C(m.lii, 1), m.laDR_R(m.lii, 1), m.laDR_SC(m.lii, 1)
         ENDIF
         GO BOTTOM
         m.lii=0

         DO WHILE !BOF()
            =This.GetLCC(COMMENT, @m.lcLCC, @m.lcLCCSC)
            IF !EMPTY(m.lcLCC)
               m.lii=m.lii+1
               m.laDR_C(m.lii)=m.lcLCC
               m.laDR_SC(m.lii)=IIF(OBJTYPE=5, EXPR, "0000")
               m.laDR_R(m.lii)=RECNO()
            ELSE
               DELE NEXT 1
               m.llDele=.T.
            ENDIF
            SKIP -1
         ENDDO

         IF m.lii>0
            DIME m.laDR_C(m.lii), m.laDR_R(m.lii), m.laDR_SC(m.lii)
         ENDIF

         IF m.llDele
            PACK
         ENDIF
      ENDIF

      SELE (m.lcASR)
      SCAN ALL
           SCATTER TO m.laRow MEMO
           INSERT INTO (m.lcADR) FROM ARRAY m.laRow

           IF INLIST(OBJTYPE, 5, 6, 7, 8, 17, 9)
              IF OBJTYPE=9
                 m.lcLCC=STR(OBJTYPE, 3)+STR(OBJCODE, 3)+EXPR
                 m.lcLCCSC=""
              ELSE
                 =This.GetLCC(COMMENT, @m.lcLCC, @m.lcLCCSC)
              ENDIF

              * If not exist, add it
              IF EMPTY(m.lcLCC)
                 m.lcLCC=SYS(2015)
                 REPL COMMENT WITH COMMENT+CHR(13)+CHR(10)+"LCC:"+m.lcLCC
              ENDIF
              m.lcLCCSC=IIF(OBJTYPE=5, EXPR, "0000")
              m.liWIDTH=WIDTH

              IF OBJTYPE=5
                 SELE (m.lcADR)
                 m.lii=ASCAN(m.laDR_C, m.lcLCC)
                 IF m.lii>0 && found
                    GO (m.laDR_R(m.lii)) IN (m.lcATMP)
                    m.lcPom=EVAL(m.lcATMP+".EXPR")
                    IF m.lcLCCSC==m.laDR_SC(m.lii)
                       REPL EXPR WITH m.lcPom, WIDTH WITH EVAL(m.lcATMP+".WIDTH")
                    ELSE
                       REPL EXPR WITH '"'+SUBST(m.lcLCCSC, 2, LEN(m.lcLCCSC)-2)+" ("+SUBST(m.lcPom, 2, LEN(m.lcPom)-2)+")"+'"',;
                            WIDTH WITH WIDTH+m.liWIDTH

                    ENDIF
                 ENDIF
                 REPL COMMENT WITH This.SetLCC(COMMENT, m.lcLCC, m.lcLCCSC)
                 SELE (m.lcASR)
              ENDIF
           ENDIF
      ENDSCAN

      USE IN (m.lcASR)
      USE IN (m.lcADR)
      IF m.llExist
         USE IN (m.lcATMP)
      ENDIF
      
      IF m.lcSafety=="ON"
         SET SAFETY ON
      ENDIF
      RETURN
   ENDPROC


   PROCEDURE CopyLayout
      LPARAMETERS m.lcSR, m.lcDR
      * lcSR  - Source report
      * lcDR  - Destination report

      LOCAL m.lcASR, m.lcADR, m.lcLCC, m.lii, m.liSRX, m.loRam
      LOCAL ARRAY m.laRow(1), m.laSR_C(1), m.laSR_R(1), m.laFields(1)

      m.lcASR=SYS(2015)
      m.lcADR=SYS(2015)


      IF !This.OpenTable(m.lcSR, m.lcASR, " AGAIN")
         RETURN .F.
      ENDIF

      IF !This.OpenTable(m.lcDR, m.lcADR, " AGAIN")
         USE IN (m.lcASR)
         RETURN .F.
      ENDIF

      * Scan basic report
      SELE (m.lcADR)
      COUNT TO m.liSRX FOR INLIST(OBJTYPE, 5, 6, 7, 8, 17, 9, 1)
      IF m.liSRX>0
         DIME m.laSR_C(m.liSRX, 1), m.laSR_R(m.liSRX, 1)
      ENDIF

      * check LCC
      SCAN FOR INLIST(OBJTYPE, 5, 6, 7, 8, 17, 9, 1)
           * locate LCC code
           IF OBJTYPE=9
              m.lcLCC=STR(OBJTYPE, 3)+STR(OBJCODE, 3)+EXPR
           ELSE
              IF OBJTYPE=1
                 m.lcLCC=STR(OBJTYPE, 3)+STR(OBJCODE, 3)
              ELSE
                 =This.GetLCC(COMMENT, @m.lcLCC, "", .T.)
              ENDIF
           ENDIF
           * If not exist, add it
           IF EMPTY(m.lcLCC)
              m.lcLCC=SYS(2015)
              REPL COMMENT WITH COMMENT+CHR(13)+CHR(10)+"LCC:"+m.lcLCC
           ENDIF
      ENDSCAN

      * Create copy record
      =AFIELDS(m.laFields)

      SELE (m.lcADR)
      * Create index 
      m.liSRX=1
      SCAN FOR INLIST(OBJTYPE, 1, 5, 6, 7, 8, 17, 9)
           IF OBJTYPE=9
              m.lcLCC=STR(OBJTYPE, 3)+STR(OBJCODE, 3)+EXPR
           ELSE
              IF OBJTYPE=1
                 m.lcLCC=STR(OBJTYPE, 3)+STR(OBJCODE, 3)
              ELSE
                 =This.GetLCC(COMMENT, @m.lcLCC, "", .T.)
              ENDIF
           ENDIF
           m.laSR_C(m.liSRX)=m.lcLCC
           m.laSR_R(m.liSRX)=RECNO()
           m.liSRX=m.liSRX+1
      ENDSCAN

      * Find all non objects
      SELE (m.lcASR)
      SCAN FOR INLIST(OBJTYPE, 1, 5, 6, 7, 8, 17, 9)
           IF OBJTYPE=9 
              m.lcLCC=STR(OBJTYPE, 3)+STR(OBJCODE, 3)+EXPR
           ELSE
              IF OBJTYPE=1
                 m.lcLCC=STR(OBJTYPE, 3)+STR(OBJCODE, 3)
              ELSE
                 =This.GetLCC(COMMENT, @m.lcLCC, "", .T.)
              ENDIF
           ENDIF

           IF !EMPTY(m.lcLCC)
              m.lii=ASCAN(m.laSR_C, m.lcLCC)
              IF m.lii=0 && Not found, Insert It

              ELSE
                 * 5,6,7,8,17. VPOS, HPOS, WITDH, HEIGHT
                 * 9 WITDH, HEIGHT
                 * 5 EXPR
                 SCATTER NAME m.loRam MEMO
                 SELE (m.lcADR)
                 GO (m.laSR_R(m.lii))
                 DO CASE
                    CASE OBJTYPE=1
                         REPLACE EXPR WITH m.loRam.EXPR, TAG WITH m.loRam.TAG,;
                                 TAG2 WITH m.loRam.TAG2,;
                                 VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 FONTFACE WITH m.loRam.FONTFACE,FONTSIZE WITH m.loRam.FONTSIZE,FONTSTYLE WITH m.loRam.FONTSTYLE,;
                                 RULER WITH m.loRam.RULER,RULERLINES WITH m.loRam.RULERLINES,;
                                 GRID WITH m.loRam.GRID,GRIDV WITH m.loRam.GRIDV,GRIDH WITH m.loRam.GRIDH

                    CASE OBJTYPE=9
                         REPLACE PLAIN WITH m.loRam.PLAIN, HEIGHT WITH m.loRam.HEIGHT

                    CASE OBJTYPE=17
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 GENERAL WITH m.loRam.GENERAL, DOUBLE WITH m.loRam.DOUBLE,;
                                 MODE WITH m.loRam.MODE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP
                           
                    CASE OBJTYPE=5
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 HEIGHT WITH m.loRam.HEIGHT,; && WIDTH WITH m.loRam.WIDTH, 
                                 PENRED WITH m.loRam.PENRED,PENGREEN WITH m.loRam.PENGREEN,PENBLUE WITH m.loRam.PENBLUE,;
                                 FILLRED WITH m.loRam.FILLRED,FILLGREEN WITH m.loRam.FILLGREEN,FILLBLUE WITH m.loRam.FILLBLUE,;
                                 FONTFACE WITH m.loRam.FONTFACE,FONTSIZE WITH m.loRam.FONTSIZE,FONTSTYLE WITH m.loRam.FONTSTYLE,;
                                 MODE WITH m.loRam.MODE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP,;
                                 PICTURE WITH m.loRam.PICTURE,;
                                 SPACING WITH m.loRam.SPACING,;
                                 OFFSET WITH m.loRam.OFFSET


                    CASE OBJTYPE=6
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 PENSIZE WITH m.loRam.PENSIZE,PENPAT WITH m.loRam.PENPAT,;
                                 PENRED WITH m.loRam.PENRED,PENGREEN WITH m.loRam.PENGREEN,PENBLUE WITH m.loRam.PENBLUE,;
                                 FILLRED WITH m.loRam.FILLRED,FILLGREEN WITH m.loRam.FILLGREEN,FILLBLUE WITH m.loRam.FILLBLUE,;
                                 MODE WITH m.loRam.MODE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP


                    CASE OBJTYPE=7
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 PENSIZE WITH m.loRam.PENSIZE,PENPAT WITH m.loRam.PENPAT,FILLPAT WITH m.loRam.FILLPAT,;
                                 PENRED WITH m.loRam.PENRED,PENGREEN WITH m.loRam.PENGREEN,PENBLUE WITH m.loRam.PENBLUE,;
                                 FILLRED WITH m.loRam.FILLRED,FILLGREEN WITH m.loRam.FILLGREEN,FILLBLUE WITH m.loRam.FILLBLUE,;
                                 MODE WITH m.loRam.MODE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP,;
                                 OFFSET WITH m.loRam.OFFSET

                    CASE OBJTYPE=8
                         REPLACE VPOS WITH m.loRam.VPOS, HPOS WITH m.loRam.HPOS,;
                                 WIDTH WITH m.loRam.WIDTH, HEIGHT WITH m.loRam.HEIGHT,;
                                 FONTFACE WITH m.loRam.FONTFACE,FONTSIZE WITH m.loRam.FONTSIZE,FONTSTYLE WITH m.loRam.FONTSTYLE,;
                                 PENRED WITH m.loRam.PENRED,PENGREEN WITH m.loRam.PENGREEN,PENBLUE WITH m.loRam.PENBLUE,;
                                 FILLRED WITH m.loRam.FILLRED,FILLGREEN WITH m.loRam.FILLGREEN,FILLBLUE WITH m.loRam.FILLBLUE,;
                                 FLOAT WITH m.loRam.FLOAT,;
                                 MODE WITH m.loRam.MODE,;
                                 TOP WITH m.loRam.TOP,;
                                 STRETCH WITH m.loRam.STRETCH,;
                                 STRETCHTOP WITH m.loRam.STRETCHTOP,;
                                 PICTURE WITH m.loRam.PICTURE,;
                                 SPACING WITH m.loRam.SPACING,;
                                 OFFSET WITH m.loRam.OFFSET,;
                                 RULERLINES WITH m.loRam.RULERLINES

                 ENDCASE
                 SELECT (m.lcASR)
              ENDIF
           ENDIF
      ENDSCAN

      USE IN (m.lcASR)
      USE IN (m.lcADR)

      RETURN .T.
   ENDPROC

ENDDEFINE

