LPARAM m.lcFile, m.lcAction

#INCLUDE "..\_MEdit.h"
#INCLUDE "..\RegAPI.h"
#INCLUDE "Main.h"

#INCLUDE "fll.source\cvp0130\cvp_api.h"

#DEFINE ICON_ANIMATE_GIF 0
#DEFINE ICON_ANIMATE_BMP 1

#IF BITAND(cvp_api, cvp_api_animated)>0
 #DEFINE ICON_ANIMATE ICON_ANIMATE_BMP
#ELSE
 #DEFINE ICON_ANIMATE ICON_ANIMATE_GIF
#ENDIF 


#IF VAL(SUBS(VERSION(),LEN("Visual FoxPro ")+1,2))>=10 AND IIF(GETENV("PROCESSOR_ARCHITECTURE")=="x86", "32", "64")=="64"
 EXTERNAL LIBRARY cvp64.fll, vfpbmp64.fll
#ELSE
 EXTERNAL LIBRARY cvp.fll, vfpbmp.fll
#ENDIF

EXTERNAL PROCEDURE CVP_GETINTERFACE

*set covera to c:\temp\cvp.log

* pokud byl predan parametr, pak otestuj jestli je typu C, pokud ne
* pak nastav prazdny retezec
IF PCOUNT()=1 AND TYPE("m.lcFile")#"C"
   lcFile=""
ENDIF

IF VERSION(2)=0 && pokud to je RunTime
   _FOXCODE=""
   IF _Screen.Visible && pokud je videt
      _Screen.Visible=.F. && pak ho skryj
   ENDIF
ENDIF

=SYS(2450, 1) && don't search path

PUBLIC m.XX_System, m.XX_ActSrv, m.XX_SrvSeznam, m.XXF010, m.XXTherm, m.pcCVPFLL, m.pczlibDLL,;
       m.pcCommandLine, m.XX_ListImage, m.XX_Res, m.XX_OCXClasslib, m.XX_tmpFiles, m.plEnd, m.XXEFRX, m.pcJUSTIFY

LOCAL m.liErr, m.loPar, m.lii, m.lcName, m.llEnd, m.lcPom, m.lcFile, m.oOCX, m.loLib, m.loVers, m.lcBC, m.lcPict, m.loIDE, m.llGUIAllowed, m.lcOutFile

m.loIDE=CREATEOBJECT("_IDEEnv")
m.loIDE.SaveIDEProps()

SET EXCLUSIVE OFF
SET STATUS BAR ON
SET SCOREBOARD OFF
SET CONFIRM OFF
SET SYSFORMAT ON
SET DATE TO GERMAN
SET EXACT OFF
SET HOURS TO 24
SET TALK OFF
SET CENTURY ON
SET SAFETY OFF
SET ESCAPE OFF 


IF TYPE("m.CVP_PLATFORM")<>"N"
   IF TYPE("m.CVP_PLATFORM")="U"
      PUBLIC m.CVP_PLATFORM
   ENDIF 
   m.CVP_PLATFORM=CVP_GETPLATFORM()
ENDIF

m.pcCommandLine=ADDBS(JUSTPATH(SYS(16)))
m.pcCVPFLL=m.pcCommandLine+"cvp"+IIF(m.CVP_PLATFORM=64, "64", "")+".FLL"
m.pczlibDLL=m.pcCommandLine+"zlib"+IIF(m.CVP_PLATFORM=64, "64", "")+".DLL"

SET PATH TO (m.pcCommandLine)
SET DEFA TO (m.pcCommandLine)
SET PROCED TO (m.pcCommandLine+"mainx")

liErr=AppInit(@lcFile) && inicializuj knihovny
IF m.liErr#ErrOK
   * chybove hlasky zde budou v cestine
   =MESSAGEBOX(STRTRAN(STRTRAN(Main_msgCI_LoadLibrary,"%d",LTRIM(STR(m.liErr,11))),"%FILE%",m.lcFile),msgType1,"CVP")
   m.loIDE.RestoreIDEProps()
   RETURN .T.
ENDIF

*m.lcAction
* Second Parameter
* --SAVE (TO CVP/CVI)
* --CREATELOG
* --CREATELOGEX (WITH SOURCES)
* --EXPORTCALLSTACK
* --REPAIRCALLSTACK
DO CASE
   CASE EMPTY(m.lcAction)

   CASE UPPER(LEFT(m.lcAction, 6))=="--SAVE"
        m.lcOutFile=SUBSTR(m.lcAction, 7)
        m.lcAction=LEFT(m.lcAction, 6)
   
   CASE UPPER(LEFT(m.lcAction, 11))=="--CREATELOG"
        m.lcOutFile=SUBSTR(m.lcAction, 12)
        m.lcAction=LEFT(m.lcAction, 11)

   CASE UPPER(LEFT(m.lcAction, 13))=="--CREATELOGEX"
        m.lcOutFile=SUBSTR(m.lcAction, 14)
        m.lcAction=LEFT(m.lcAction, 13)

   CASE UPPER(LEFT(m.lcAction, 17))=="--EXPORTCALLSTACK"
        m.lcOutFile=SUBSTR(m.lcAction, 18)
        m.lcAction=LEFT(m.lcAction, 17)

   CASE UPPER(LEFT(m.lcAction, 17))="--REPAIRCALLSTACK"
        m.lcOutFile=""
        m.lcAction=LEFT(m.lcAction, 17)

ENDCASE
m.llGUIAllowed=EMPTY(m.lcAction)
IF NOT m.llGUIAllowed
   SET SYSMENU TO DEFAULT
ENDIF

* otestuj OCX tridy (jen pokud to neni oprava regitry nebo vymaz z registry)
IF !(PCOUNT()=1 AND ( UPPER(ALLT(m.lcFile))=="--R" OR UPPER(ALLT(m.lcFile))=="--D")) AND m.llGUIAllowed

   m.loOCX=CREATEOBJECT("_OCXLibraries")
   m.loLib=m.loOCX.Add("COMCTL")

   m.loVers=m.loLib.Add("__MSComctlLib")
   DIME m.loVers.aClss(3)
   m.loVers.aClss(1)="MSComctlLib.TreeCtrl"
   m.loVers.aClss(2)="MSComctlLib.ListViewCtrl"
   m.loVers.aClss(3)="MSComctlLib.ImageListCtrl"

   * Selhala inicalizace OCX knihoven
   IF !m.loOCX.Test()
      =MESSAGEBOX(STRTRAN(STRTRAN(Main_msgCI_InitOCX, "%d", LTRIM(STR(Init_InitOCX, 11))), "%Library%", m.loOCX.Failed_Library), msgType1, "CVP")
      m.loIDE.RestoreIDEProps()
      RETURN .T.
   ELSE
      XX_OCXClasslib=m.loOCX.COMCTL.Active_Library
   ENDIF
   RELE m.loOCX, m.loLib, m.loVers && Uvolni promenne
ENDIF

m.XX_tmpFiles=CREATEOBJECT("_lstFiles") && vytvor registracni server pracovnich souboru
m.XX_tmpFiles.List=SYS(2023)+"\"+"CVP.LST"
m.XX_tmpFiles.DeleteFiles() && smaz vsechny pozustale pracovni souboru

m.XXEFRX=CREATEOBJECT('__CVPCFRXs') && Export reportu
m.XXEFRX.SourcePath=m.pcCommandLine+"EFRX\"

m.XX_System=CREATEOBJECT("_System") && vytvori systemovy objekt
m.XX_System.Name="XX_System"
m.XX_System.lGUIAllowed=m.llGUIAllowed
m.XX_System.RestoreLanguage() && nacti informace o jazykovych mutacich z ini souboru


=m.XX_System.OPT.Add(m.XX_System, VERSION()+", Platform: "+IIF(GETENV("PROCESSOR_ARCHITECTURE")=="x86", "32", "64")+" bit", .T.)


m.XX_System.RestorePackUtils() && nacti informace o pakovacich utilitach z ini souboru
m.XX_System.ReadEFRX() && 


ON ESCAPE XX_System.Canceled()

IF m.XX_System.RightToLeft
   m.pcJUSTIFY="RTLJUSTIFY"
   SET SYSMENU OFF TO RTLJUSTIFY
ELSE
   m.pcJUSTIFY=""
ENDIF



m.XX_Res=m.XX_System.Resources



m.liErr=m.XX_System.LoadLocalize()
IF m.liErr#ErrOK
   m.loIDE.RestoreIDEProps()
   RETURN .T.
ENDIF

m.XX_System.SimplyFilter.aErrorMsg(ABS(_PC_ValueIsNotValid))=m.XX_Res.ReadStringEx(_SF_ErrMsg_ValueIsNotValid)
m.XX_System.SimplyFilter.aErrorMsg(ABS(_PC_ConditionIsNotValid))=m.XX_Res.ReadStringEx(_SF_ErrMsg_ConditionIsNotValid)
m.XX_System.SimplyFilter.aErrorMsg(ABS(_PC_FieldHasBadType))=m.XX_Res.ReadStringEx(_SF_ErrMsg_FieldHasBadType)
m.XX_System.SimplyFilter.aErrorMsg(ABS(_PC_FieldNotExists))=m.XX_Res.ReadStringEx(_SF_ErrMsg_FieldNotExists)


IF PCOUNT()=1
   IF UPPER(ALLT(m.lcFile))=="--R" && jde o znovu vytvoreni zaznamu v registry
      =m.XX_System.RepairRegistry()
      =MESSAGEBOX(m.XX_Res.ReadStringEx(Main_msgRegistryRepaired),msgType4, m.XX_System.cAPPName)
      m.loIDE.RestoreIDEProps()
      RETURN && a vypadni ven
   ELSE
      IF UPPER(ALLT(m.lcFile))=="--D" && jde o smazani zaznamu v registry
         =m.XX_System.DeleteRegistry()
         =MESSAGEBOX(m.XX_Res.ReadStringEx(Main_msgRegistryClear),msgType4, m.XX_System.cAPPName)
         m.loIDE.RestoreIDEProps()
         RETURN && a vypadni ven
      ENDIF
   ENDIF
ENDIF
*   RETURN && a vypadni ven
*ELSE

IF m.XX_System.lGUIAllowed
   * jinak je nacti z registry
   m.XX_System.RestoreScreen() && nacti pozici a velikost okna
ENDIF
m.XX_System.RestoreOptions() && nacti nastaveni aplikace

IF m.XX_System.lGUIAllowed
   m.XX_System.RestoreRecentFiles() && nacte seznam naposled otevrenych souboru
   m.XX_System.RestoreFindValues() && nacte seznam naposled otevrenych souboru
   m.XX_System.RestoreWindPosition() && nacte pozice oken
ENDIF

m.XX_System.ReInitialize() && reinicializace
m.XXEFRX.InitEngines()
*ENDIF



SELE 0 && skoc na nejblizsi volnou oblast

XX_Res.NoString=m.XX_Res.ReadStringEx(XXF000_VFPRes_NoString)
XX_Res.NoPad=m.XX_Res.ReadStringEx(XXF000_VFPRes_NoPad)
XX_Res.NoBar=m.XX_Res.ReadStringEx(XXF000_VFPRes_NoBar)

XX_ActSrv=CREATEOBJECT("_ActionSrv") && vytvori server akci
XX_SrvSeznam=CREATEOBJECT("_SrvSeznam") && vytvori server pro seznamy
m.XX_ActSrv.System_Action="XX_SrvSeznam" && odkaz na objekt se syst. akcema


m.XX_ActSrv.SetFlag("XX_SrvSeznam") && povol/nastav priznaky

IF m.XX_System.lGUIAllowed
   XX_ListImage=CREATEOBJECT("form")
   m.XX_ListImage.AddObject("ImageList",XX_OCXClasslib+"_ImageList")

   m.XX_ListImage.AddObject("MenuForm","__MenuForm") && popup pro okna
   m.XX_ListImage.AddObject("MenuEdit","__MenuEdit") && popup pro editaci
ENDIF



IF m.XX_System.lGUIAllowed
   lcPom=m.XX_Res.ReadPadEx(_msm_File_prm,Res_Type_Menu_Prompt)
   lcKey=IIF(AT("\<",m.lcPom)>0,"KEY ALT+"+SUBS(m.lcPom,AT("\<",m.lcPom)+2,1)+",'' ","")
   DEFINE PAD _msm_file   OF _msysmenu PROMPT m.lcPom ;
                                       MESSAGE m.XX_Res.ReadPadEx(_msm_File_prm,Res_Type_Menu_Message);
                                       &lcKey.

   ON PAD _msm_file  OF _msysmenu  ACTIVATE POPUP _main_mfile

   lcPom=m.XX_Res.ReadPadEx(_msm_Edit_prm,Res_Type_Menu_Prompt)
   lcKey=IIF(AT("\<",m.lcPom)>0,"KEY ALT+"+SUBS(m.lcPom,AT("\<",m.lcPom)+2,1)+",'' ","")
   DEFINE PAD _msm_edit   OF _msysmenu PROMPT m.lcPom;
                                       MESS m.XX_Res.ReadPadEx(_msm_Edit_prm,Res_Type_Menu_Message);
                                       &lcKey.
   ON PAD _msm_edit  OF _msysmenu  ACTIVATE POPUP _main_medit

   lcPom=m.XX_Res.ReadPadEx(_msm_View_prm,Res_Type_Menu_Prompt)
   lcKey=IIF(AT("\<",m.lcPom)>0,"KEY ALT+"+SUBS(m.lcPom,AT("\<",m.lcPom)+2,1)+",'' ","")
   DEFINE PAD _msm_View   OF _msysmenu PROMPT m.lcPom AFTER _msm_edit;
                                       MESSAGE m.XX_Res.ReadPadEx(_msm_View_prm,Res_Type_Menu_Message);
                                       &lcKey.
   ON PAD _msm_View  OF _msysmenu  ACTIVATE POPUP _main_mView


   lcPom=m.XX_Res.ReadPadEx(_msm_Move_prm,Res_Type_Menu_Prompt)
   lcKey=IIF(AT("\<",m.lcPom)>0,"KEY ALT+"+SUBS(m.lcPom,AT("\<",m.lcPom)+2,1)+",'' ","")
   DEFINE PAD _msm_Move   OF _msysmenu PROMPT m.lcPom AFTER _msm_View;
                                       MESSAGE m.XX_Res.ReadPadEx(_msm_Move_prm,Res_Type_Menu_Message);
                                       &lcKey.
   ON PAD _msm_Move  OF _msysmenu  ACTIVATE POPUP _main_mMove

   lcPom=m.XX_Res.ReadPadEx(_msm_Tools_prm,Res_Type_Menu_Prompt)
   lcKey=IIF(AT("\<",m.lcPom)>0,"KEY ALT+"+SUBS(m.lcPom,AT("\<",m.lcPom)+2,1)+",'' ","")
   DEFINE PAD _msm_Tools   OF _msysmenu PROMPT m.lcPom AFTER _msm_View;
                                       MESSAGE m.XX_Res.ReadPadEx(_msm_Tools_prm,Res_Type_Menu_Message);
                                       &lcKey.
   ON PAD _msm_Tools  OF _msysmenu  ACTIVATE POPUP _main_mTools


   lcPom=m.XX_Res.ReadPadEx(_msm_Wind_prm,Res_Type_Menu_Prompt)
   lcKey=IIF(AT("\<",m.lcPom)>0,"KEY ALT+"+SUBS(m.lcPom,AT("\<",m.lcPom)+2,1)+",'' ","")
   DEFINE PAD _msm_windo  OF _msysmenu PROMPT m.lcPom;
                                       MESS m.XX_Res.ReadPadEx(_msm_Wind_prm,Res_Type_Menu_Message);
                                       &lcKey.
                                      
   ON PAD _msm_windo OF _msysmenu  ACTIVATE POPUP _main_mWind


   lcPom=m.XX_Res.ReadPadEx(_msm_Help_prm,Res_Type_Menu_Prompt)
   lcKey=IIF(AT("\<",m.lcPom)>0,"KEY ALT+"+SUBS(m.lcPom,AT("\<",m.lcPom)+2,1),"")
   DEFINE PAD _msm_Help  OF _msysmenu PROMPT m.lcPom ;
                                      MESS m.XX_Res.ReadPadEx(_msm_Help_prm,Res_Type_Menu_Message);
                                       &lcKey.,'' 
                                      
   ON PAD _msm_Help OF _msysmenu  ACTIVATE POPUP _main_mHelp


   *RTLJUSTIFY

   DEFINE POPUP _main_mOpenSpec MARGIN RELATIVE &pcJUSTIFY. && popup exportu
   DEFINE POPUP _main_mPrint  MARGIN RELATIVE &pcJUSTIFY.  && popup exportu
   DEFINE POPUP _main_mExport MARGIN RELATIVE &pcJUSTIFY.  && popup exportu
   DEFINE POPUP _main_mFile   MARGIN RELATIVE &pcJUSTIFY.  && popup souboru
   DEFINE POPUP _main_mEdit   MARGIN RELATIVE &pcJUSTIFY. && popup editacni
   DEFINE POPUP _main_mView   MARGIN RELATIVE &pcJUSTIFY. && popup zobrazeni
   DEFINE POPUP _main_mMove   MARGIN RELATIVE &pcJUSTIFY. && popup pruchodu
   DEFINE POPUP _main_mTools  MARGIN RELATIVE &pcJUSTIFY.  && popup nastroje
   DEFINE POPUP _main_mWind   MARGIN RELATIVE &pcJUSTIFY.  && popup oken
   DEFINE POPUP _main_mHelp   MARGIN RELATIVE &pcJUSTIFY.  && popup helpu


   * _main_mOpenSpec
   DEFINE BAR 1 OF _main_mOpenSpec PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_131,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_131,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_OpenAnalyseExport)

   ON SELECTION BAR 1 OF _main_mOpenSpec m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_OpenAnalyseExport)



   * _main_mExport
   DEFINE BAR 1 OF _main_mExport PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_111,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_111,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_Export)

   ON SELECTION BAR 1 OF _main_mExport m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_Export)

   DEFINE BAR 2 OF _main_mExport PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_112,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_112,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_CreateLog)

   ON SELECTION BAR 2 OF _main_mExport m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_CreateLog)

   DEFINE BAR 6 OF _main_mExport PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_116,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_116,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_CreateLogEx)

   ON SELECTION BAR 6 OF _main_mExport m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_CreateLogEx)


   DEFINE BAR 3 OF _main_mExport PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_113,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_113,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_ExportCallStack)

   ON SELECTION BAR 3 OF _main_mExport m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_ExportCallStack)


   DEFINE BAR 4 OF _main_mExport PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_114,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_114,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_AnalyseExport)  PICTURE 'resources\ico16\xml.bmp'

   ON SELECTION BAR 4 OF _main_mExport m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_AnalyseExport)

   DEFINE BAR 5 OF _main_mExport PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_115,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_115,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_StatisticExport)  PICTURE 'resources\ico16\xml.bmp'

   ON SELECTION BAR 5 OF _main_mExport m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_StatisticExport)



   * _main_mPrint
   DEFINE BAR 1 OF _main_mPrint PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_121,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_121,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_AnalysePrint)

   ON SELECTION BAR 1 OF _main_mPrint m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_AnalysePrint)

   DEFINE BAR 2 OF _main_mPrint PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_122,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_122,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_StatisticPrint)

   ON SELECTION BAR 2 OF _main_mPrint m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_StatisticPrint)



   * _main_mFile
   DEFINE BAR 1 OF _main_mFile PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_01,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_01,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag("XX_SrvSeznam",_ACT_New);
                               KEY CTRL+N,"Ctrl+N"  PICTURE 'resources\ico16\newdoc.bmp'

   ON SELECTION BAR 1 OF _main_mFile m.XX_ActSrv.Run("XX_SrvSeznam",_ACT_New)

   DEFINE BAR 2 OF _main_mFile PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_02,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_02,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag("XX_SrvSeznam",_ACT_Open);
                               KEY CTRL+O,"Ctrl+O"  PICTURE 'resources\ico16\opendoc.bmp'
   ON SELECTION BAR 2 OF _main_mFile m.XX_ActSrv.Run("XX_SrvSeznam",_ACT_Open)

   DEFINE BAR 13 OF _main_mFile PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_13,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_13,Res_Type_Menu_Message)
   ON   BAR 13 OF _main_mFile ACTIVATE POPUP _main_mOpenSpec


   DEFINE BAR 3 OF _main_mFile PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_03,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_03,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_Close)  PICTURE 'resources\ico16\close.bmp'
   ON SELECTION BAR 3 OF _main_mFile m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_Close)

   DEFINE BAR _mfi_sp100 OF _main_mFile PROMPT '\-'          MESS ''
   DEFINE BAR 4 OF _main_mFile PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_04,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_04,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_Save);
                               KEY CTRL+S,"Ctrl+S"  PICTURE 'resources\ico16\save.bmp'
   ON SELECTION BAR 4 OF _main_mFile m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_Save)

   DEFINE BAR 5 OF _main_mFile PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_05,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_05,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_SaveAs)  PICTURE 'resources\ico16\saveas.bmp'
   ON SELECTION BAR 5 OF _main_mFile m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_SaveAs)


   DEFINE BAR 7 OF _main_mFile PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_07,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_07,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag("XX_SrvSeznam",_ACT_SaveAll)  PICTURE 'resources\ico16\saveall.bmp'
   ON SELECTION BAR 7 OF _main_mFile m.XX_ActSrv.Run("XX_SrvSeznam",_ACT_SaveAll)


   DEFINE BAR _mfi_sp200 OF _main_mFile PROMPT '\-'          MESS ''
   DEFINE BAR 8 OF _main_mFile PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_08,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_08,Res_Type_Menu_Message)

   ON SELECTION BAR 8 OF _main_mFile ShowOptionDlg()

   DEFINE BAR 10 OF _main_mFile PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_10,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_10,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_Prop)

   ON SELECTION BAR 10 OF _main_mFile m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_Prop)

   DEFINE BAR _mfi_sp400 OF _main_mFile PROMPT '\-'          MESS ''

   ********** TEST
   DEFINE BAR 12 OF _main_mFile PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_12,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_12,Res_Type_Menu_Message)  PICTURE 'resources\ico16\print.bmp'

   ON   BAR 12 OF _main_mFile ACTIVATE POPUP _main_mPrint


   DEFINE BAR 11 OF _main_mFile PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_11,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_11,Res_Type_Menu_Message)

   ON   BAR 11 OF _main_mFile ACTIVATE POPUP _main_mExport


   **************

   DEFINE BAR _mfi_sp300 OF _main_mFile PROMPT '\-'          MESS ''
   DEFINE BAR 6 OF _main_mFile PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_06,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_06,Res_Type_Menu_Message)

   ON SELECTION BAR 6 OF _main_mFile Main_Quit()



   DEFINE BAR _med_undo  OF _main_mEdit PROMPT m.XX_Res.ReadBarEx(_msm_Edit_prmUndo,Res_Type_Menu_Prompt);
                                        KEY CTRL+Z,'Ctrl+Z';
                                        MESSAGE m.XX_Res.ReadBarEx(_msm_Edit_prmUndo,Res_Type_Menu_Message)
   DEFINE BAR _med_redo  OF _main_mEdit PROMPT m.XX_Res.ReadBarEx(_msm_Edit_prmRedo,Res_Type_Menu_Prompt) ;
                                        KEY CTRL+R,'Ctrl+R';
                                        MESSAGE m.XX_Res.ReadBarEx(_msm_Edit_prmRedo,Res_Type_Menu_Message)
   DEFINE BAR _med_sp100 OF _main_mEdit PROMPT '\-'                               MESS ''
   DEFINE BAR _med_cut   OF _main_mEdit PROMPT m.XX_Res.ReadBarEx(_msm_Edit_prmCut,Res_Type_Menu_Prompt) ;
                                        KEY CTRL+X,'Ctrl+X';
                                        MESSAGE m.XX_Res.ReadBarEx(_msm_Edit_prmCut,Res_Type_Menu_Message)
   DEFINE BAR _med_copy  OF _main_mEdit PROMPT m.XX_Res.ReadBarEx(_msm_Edit_prmCopy,Res_Type_Menu_Prompt) ;
                                        KEY CTRL+C,'Ctrl+C';
                                        MESSAGE m.XX_Res.ReadBarEx(_msm_Edit_prmCopy,Res_Type_Menu_Message)
   DEFINE BAR _med_paste OF _main_mEdit PROMPT m.XX_Res.ReadBarEx(_msm_Edit_prmPaste,Res_Type_Menu_Prompt) ;
                                        KEY CTRL+V,'Ctrl+V';
                                        MESSAGE m.XX_Res.ReadBarEx(_msm_Edit_prmPaste,Res_Type_Menu_Message)
   DEFINE BAR _med_slcta OF _main_mEdit PROMPT m.XX_Res.ReadBarEx(_msm_Edit_prmSelectAll,Res_Type_Menu_Prompt) ;
                                        KEY CTRL+A,'Ctrl+A';
                                        MESSAGE m.XX_Res.ReadBarEx(_msm_Edit_prmSelectAll,Res_Type_Menu_Message)
   DEFINE BAR _med_sp200 OF _main_mEdit PROMPT '\-'                               MESS ''

   DEFINE BAR 4          OF _main_mEdit PROMPT m.XX_Res.ReadBarEx(_msm_Edit_Find,Res_Type_Menu_Prompt) ;
                                        MESSAGE m.XX_Res.ReadBarEx(_msm_Edit_Find,Res_Type_Menu_Message) ;
                                        SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_Find) PICTURE 'resources\ico16\find.bmp'

   DEFINE BAR _med_sp300 OF _main_mEdit PROMPT '\-'                               MESS ''

   DEFINE BAR 1          OF _main_mEdit PROMPT m.XX_Res.ReadBarEx(_msm_Edit_SelectRecord,Res_Type_Menu_Prompt) ;
                                        MESSAGE m.XX_Res.ReadBarEx(_msm_Edit_SelectRecord,Res_Type_Menu_Message) ;
                                        SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_SelectRecord)

   DEFINE BAR 7          OF _main_mEdit PROMPT m.XX_Res.ReadBarEx(_msm_Edit_SelAllRecords,Res_Type_Menu_Prompt) ;
                                        MESSAGE m.XX_Res.ReadBarEx(_msm_Edit_SelAllRecords,Res_Type_Menu_Message) ;
                                        SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_SelAllRecords)

   DEFINE BAR 2          OF _main_mEdit PROMPT m.XX_Res.ReadBarEx(_msm_Edit_UnSelAllRecord,Res_Type_Menu_Prompt) ;
                                        MESSAGE m.XX_Res.ReadBarEx(_msm_Edit_UnSelAllRecord,Res_Type_Menu_Message) ;
                                        SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_UnSelAllRecord)

   DEFINE BAR 3          OF _main_mEdit PROMPT m.XX_Res.ReadBarEx(_msm_Edit_InvSelRecord,Res_Type_Menu_Prompt) ;
                                        MESSAGE m.XX_Res.ReadBarEx(_msm_Edit_InvSelRecord,Res_Type_Menu_Message) ;
                                        SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_InVSelRecord)

   DEFINE BAR 5          OF _main_mEdit PROMPT m.XX_Res.ReadBarEx(_msm_Edit_SelRecords,Res_Type_Menu_Prompt) ;
                                        MESSAGE m.XX_Res.ReadBarEx(_msm_Edit_SelRecords,Res_Type_Menu_Message) ;
                                        SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_SelRecords)

   DEFINE BAR 6          OF _main_mEdit PROMPT m.XX_Res.ReadBarEx(_msm_Edit_HighLightRecords,Res_Type_Menu_Prompt) ;
                                        MESSAGE m.XX_Res.ReadBarEx(_msm_Edit_HighLightRecords,Res_Type_Menu_Message) ;
                                        SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_HighLightRecords)
   DEFINE BAR _med_sp400 OF _main_mEdit PROMPT '\-'                               MESS ''

   DEFINE BAR 8          OF _main_mEdit PROMPT m.XX_Res.ReadBarEx(_msm_Edit_FilterSelRecords,Res_Type_Menu_Prompt) ;
                                        MESSAGE m.XX_Res.ReadBarEx(_msm_Edit_FilterSelRecords,Res_Type_Menu_Message) ;
                                        SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_FilterSelRecords)
   DEFINE BAR 9          OF _main_mEdit PROMPT m.XX_Res.ReadBarEx(_msm_Edit_FilterHighLightRecords,Res_Type_Menu_Prompt) ;
                                        MESSAGE m.XX_Res.ReadBarEx(_msm_Edit_FilterHighLightRecords,Res_Type_Menu_Message) ;
                                        SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_FilterHighLightRecords)


   ON SELECTION BAR 1 OF _main_mEdit m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_SelectRecord)
   ON SELECTION BAR 2 OF _main_mEdit m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_UnSelAllRecord)
   ON SELECTION BAR 3 OF _main_mEdit m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_InVSelRecord)
   ON SELECTION BAR 4 OF _main_mEdit m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_Find)
   ON SELECTION BAR 5 OF _main_mEdit m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_SelRecords)
   ON SELECTION BAR 6 OF _main_mEdit m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_HighLightRecords)
   ON SELECTION BAR 7 OF _main_mEdit m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_SelAllRecords)
   ON SELECTION BAR 8 OF _main_mEdit m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_FilterSelRecords)
   ON SELECTION BAR 9 OF _main_mEdit m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_FilterHighLightRecords)


   DEFINE BAR 1 OF _main_mView PROMPT m.XX_Res.ReadBarEx(_main_mView_barprm_OutPut,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mView_barprm_OutPut,Res_Type_Menu_Message)

   DEFINE BAR 2 OF _main_mView PROMPT m.XX_Res.ReadBarEx(_main_mView_barprm_XXTool_1,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mView_barprm_XXTool_1,Res_Type_Menu_Message)

   DEFINE BAR 3 OF _main_mView PROMPT m.XX_Res.ReadBarEx(_main_mView_barprm_XXTool_2,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mView_barprm_XXTool_2,Res_Type_Menu_Message)


   DEFINE BAR 4 OF _main_mView PROMPT m.XX_Res.ReadBarEx(_main_mView_barprm_4,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mView_barprm_4,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_RowD) PICTURE 'resources\ico16\rowd.bmp'

   DEFINE BAR 5 OF _main_mView PROMPT m.XX_Res.ReadBarEx(_main_mView_barprm_5,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mView_barprm_5,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_MPG) PICTURE 'resources\ico16\rowd.bmp'

   DEFINE BAR 6 OF _main_mView PROMPT m.XX_Res.ReadBarEx(_main_mView_barprm_6,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mView_barprm_6,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_MPD) PICTURE 'resources\ico16\rowd.bmp'

   ON SELECTION BAR 1 OF _main_mView ShowOutPutDlg()
   ON SELECTION BAR 2 OF _main_mView ShowXXTool_1()
   ON SELECTION BAR 3 OF _main_mView ShowXXTool_2()
   ON SELECTION BAR 4 OF _main_mView m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_RowD)
   ON SELECTION BAR 5 OF _main_mView m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_MPG)
   ON SELECTION BAR 6 OF _main_mView m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_MPD)



   DEFINE BAR 1 OF _main_mMove PROMPT m.XX_Res.ReadBarEx(_main_mMove_GoToParent,Res_Type_Menu_Prompt) ;
                                        MESSAGE m.XX_Res.ReadBarEx(_main_mMove_GoToParent,Res_Type_Menu_Message) ;
                                        SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_GoToParent) PICTURE 'resources\ico16\jumpp.bmp'

   DEFINE BAR 3 OF _main_mMove PROMPT m.XX_Res.ReadBarEx(_main_mMove_GoToChild,Res_Type_Menu_Prompt) ;
                                        MESSAGE m.XX_Res.ReadBarEx(_main_mMove_GoToChild,Res_Type_Menu_Message) ;
                                        SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_GoToChild) PICTURE 'resources\ico16\jumpc.bmp'


   DEFINE BAR 2 OF _main_mMove PROMPT m.XX_Res.ReadBarEx(_main_mMove_GoToCurrent,Res_Type_Menu_Prompt) ;
                                        MESSAGE m.XX_Res.ReadBarEx(_main_mMove_GoToCurrent,Res_Type_Menu_Message) ;
                                        SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_GoToCurrent) PICTURE 'resources\ico16\jump.bmp'

   DEFINE BAR 6 OF _main_mMove PROMPT m.XX_Res.ReadBarEx(_main_mMove_GoToSource,Res_Type_Menu_Prompt) ;
                                        MESSAGE m.XX_Res.ReadBarEx(_main_mMove_GoToSource,Res_Type_Menu_Message) ;
                                        SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_GoToSource) PICTURE 'resources\ico16\jumps.bmp'

   DEFINE BAR 4 OF _main_mMove PROMPT m.XX_Res.ReadBarEx(_main_mMove_GoToHome,Res_Type_Menu_Prompt) ;
                                        MESSAGE m.XX_Res.ReadBarEx(_main_mMove_GoToHome,Res_Type_Menu_Message) ;
                                        SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_GoToHome) PICTURE 'resources\ico16\thome.bmp'

   DEFINE BAR 5 OF _main_mMove PROMPT m.XX_Res.ReadBarEx(_main_mMove_GoToEnd,Res_Type_Menu_Prompt) ;
                                        MESSAGE m.XX_Res.ReadBarEx(_main_mMove_GoToEnd,Res_Type_Menu_Message) ;
                                        SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_GoToEnd) PICTURE 'resources\ico16\tend.bmp'

   ON SELECTION BAR 1 OF _main_mMove m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_GoToParent)
   ON SELECTION BAR 3 OF _main_mMove m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_GoToChild)
   ON SELECTION BAR 2 OF _main_mMove m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_GoToCurrent)
   ON SELECTION BAR 4 OF _main_mMove m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_GoToHome)
   ON SELECTION BAR 5 OF _main_mMove m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_GoToEnd)
   ON SELECTION BAR 6 OF _main_mMove m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_GoToSource)


   DEFINE BAR 1 OF _main_mTools PROMPT m.XX_Res.ReadBarEx(_main_mTools_barprm_01,Res_Type_Menu_Prompt) ;
                                       MESSAGE m.XX_Res.ReadBarEx(_main_mTools_barprm_01,Res_Type_Menu_Message) ;
                                       SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_RepairCallStack)
   DEFINE BAR 2 OF _main_mTools PROMPT m.XX_Res.ReadBarEx(_main_mTools_barprm_02,Res_Type_Menu_Prompt) ;
                                       MESSAGE m.XX_Res.ReadBarEx(_main_mTools_barprm_02,Res_Type_Menu_Message) ;
                                       SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_Analyse)
   DEFINE BAR 3 OF _main_mTools PROMPT m.XX_Res.ReadBarEx(_main_mTools_barprm_03,Res_Type_Menu_Prompt) ;
                                       MESSAGE m.XX_Res.ReadBarEx(_main_mTools_barprm_03,Res_Type_Menu_Message) ;
                                       SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_Statistics)

   ON SELECTION BAR 1 OF _main_mTools m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_RepairCallStack)
   ON SELECTION BAR 2 OF _main_mTools m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_Analyse)
   ON SELECTION BAR 3 OF _main_mTools m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_Statistics)

   IF VERSION(2)>0
      DEFINE BAR _mfi_sp100 OF _main_mTools PROMPT '\-'          MESS ''
      DEFINE BAR 98 OF _main_mTools PROMPT "SUSPEND"
      ON SELECTION BAR 98 OF _main_mTools SUSPEND
      DEFINE BAR 99 OF _main_mTools PROMPT "RESUME"
      ON SELECTION BAR 99 OF _main_mTools RESUME

      DEFINE BAR 100 OF _main_mTools PROMPT "SetSaveTimer()"
      ON SELECTION BAR 100 OF _main_mTools m.XX_System.SetSaveTimer()
      DEFINE BAR 101 OF _main_mTools PROMPT "StopSaveTimer()"
      ON SELECTION BAR 101 OF _main_mTools m.XX_System.StopSaveTimer()

      DEFINE BAR 102 OF _main_mTools PROMPT "SetPackTimer()"
      ON SELECTION BAR 102 OF _main_mTools m.XX_System.SetPackTimer()
      DEFINE BAR 103 OF _main_mTools PROMPT "StopPackTimer()"
      ON SELECTION BAR 103 OF _main_mTools m.XX_System.StopPackTimer()

      DEFINE BAR 104 OF _main_mTools PROMPT "SetFindTimer()"
      ON SELECTION BAR 104 OF _main_mTools m.XX_System.SetFindTimer()
      DEFINE BAR 105 OF _main_mTools PROMPT "StopFindTimer()"
      ON SELECTION BAR 105 OF _main_mTools m.XX_System.StopFindTimer()
   ENDIF   

   DEFINE BAR _mwi_arran OF _main_mWind PROMPT m.XX_Res.ReadBarEx(_main_mWind_barprm_01,Res_Type_Menu_Prompt);
                                        MESS m.XX_Res.ReadBarEx(_main_mWind_barprm_01,Res_Type_Menu_Message)
                                        
   DEFINE BAR 1          OF _main_mWind PROMPT '\-'                  MESS ''

   DEFINE BAR _mwi_rotat OF _main_mWind PROMPT m.XX_Res.ReadBarEx(_main_mWind_barprm_03,Res_Type_Menu_Prompt);
                                        MESS m.XX_Res.ReadBarEx(_main_mWind_barprm_03,Res_Type_Menu_Message)
   DEFINE BAR 4          OF _main_mWind PROMPT "\-"                  MESS ""
   DEFINE BAR 5          OF _main_mWind PROMPT m.XX_Res.ReadBarEx(_main_mWind_barprm_05,Res_Type_Menu_Prompt);
                                        MESS m.XX_Res.ReadBarEx(_main_mWind_barprm_05,Res_Type_Menu_Message);
                                        SKIP FOR XX_SrvSeznam.CVPFiles.ControlCount<=m.XX_System.MaxWindowCount

   ON SELECTION BAR 5 OF _main_mWind ShowWindDlg()

   DEFINE BAR 1 OF _main_mHelp PROMPT m.XX_Res.ReadBarEx(_main_mHelp_barprm_01,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mHelp_barprm_01,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag(m.XX_System.Modul,_ACT_Help);
                               KEY F1,"F1" PICTURE 'resources\ico16\help.bmp'
   ON SELECTION BAR 1 OF _main_mHelp m.XX_ActSrv.Run(m.XX_System.Modul,_ACT_Help)

   DEFINE BAR _mst_sp100 OF _main_mHelp PROMPT '\-'                               MESS ''

   DEFINE BAR 2 OF _main_mHelp PROMPT m.XX_Res.ReadBarEx(_main_mHelp_barprm_02,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mHelp_barprm_02,Res_Type_Menu_Message);
                               SKIP FOR !m.XX_ActSrv.GetFlag("XX_SrvSeznam",_ACT_Help)
   ON SELECTION BAR 2 OF _main_mHelp m.XX_ActSrv.Run("XX_SrvSeznam",_ACT_Help)
   DEFINE BAR _mst_sp200 OF _main_mHelp PROMPT '\-'                               MESS ''

   DEFINE BAR 3 OF _main_mHelp PROMPT m.XX_Res.ReadBarEx(_main_mHelp_barprm_03,Res_Type_Menu_Prompt);
                               MESS m.XX_Res.ReadBarEx(_main_mHelp_barprm_03,Res_Type_Menu_Message)
   ON SELECTION BAR 3 OF _main_mHelp ShowAboutDlg()

   m.XX_System.Start_mFilecntBar=CNTBAR("_main_mFile")

   m.XX_System.RedefineRecentFile() && predefinuje popup
ENDIF

SET STATUS BAR ON
SET CENTURY ON
SET SAFETY OFF
SET ENGINEBEHAVIOR 70
SET NOTIFY CURSOR OFF
SET HELP OFF && 

ON SHUTDOW DO Main_Quit

STORE .NULL. TO m.XXF010, m.XXTherm

IF m.XX_System.lGUIAllowed
   DO FORM XXF010 LINKED NAME XXF010 NOSHOW
   =CVP_SetParent(m.XXF010.hwnd, CVP_GetSTBhwnd()) && presun ho do status baru

   =m.XX_System.Resize() && nastav pozici
   =BINDEVENT(_Screen, "Resize" ,m.XX_System, "Resize")

   m.XXF010.Show() && zobraz okno
   m.XXTherm=m.XXF010.Therm && objekt teplomeru

   =IIF(m.XX_System.OutPut=1, _ShowOutPutDlg(), .T.)
   =IIF(m.XX_System.XXTool_1=1, _ShowXXTool_1(), .T.)

   =IIF(m.XX_System.XXTool_2=1, _ShowXXTool_2(), .T.)

   =SYS(2333,0)
   _VFP.AutoYield=.F. && if .T., then tree view doesn't fire event Expand sometime 
   
   _Screen.Caption=m.XX_Res.ReadStringEx(Main_Title)
   _Screen.Icon="resources\ico16\cvp.ico"

   =cvp_SetActiveWindow(m.XX_System.hwnd)
   IF !_Screen.Visible
      _Screen.Visible=.T.
   ENDIF
ENDIF

*set covera to

LOCAL m.lcOutExt, m.loLOG, m.llOK

IF PCOUNT()>=1 && pokud poslal nazev souboru
   m.lcPom=UPPER(JUSTEXT(m.lcFile)) && nacti typ souboru
ENDIF

IF PCOUNT()>=2
   m.lcOutExt=UPPER(JUSTEXT(m.lcOUTFile))
ENDIF

DO CASE
   CASE PCOUNT()=1 AND (m.lcPom=="LOG" OR m.lcPom=="TXT") && pokud poslal nazev souboru
        m.XX_ActSrv.Run('XX_SrvSeznam', _ACT_New, m.lcFile)

   CASE PCOUNT()=1 AND (m.lcPom=="CVP" OR m.lcPom=="CVPX" OR m.lcPom=="CVI") && pokud poslal nazev souboru
        m.XX_ActSrv.Run('XX_SrvSeznam', _ACT_Open, m.lcFile)


   CASE NOT EMPTY(m.lcAction)
        m.loLOG=CREATEOBJECT("_xxLog")

        DO CASE
           CASE m.lcPom=="LOG" OR m.lcPom=="TXT"
                m.XX_System.FileSource=XXF000_FileSource_I
                m.llOK=m.loLog.ReadLog(UPPER(m.lcFile))
                IF m.llOK
                   m.loLog.Files.XXT500_DBF.SetSave(m.XX_System.SaveFile_XXT500)
                   m.loLog.Files.XXT500_FPT.SetSave(m.XX_System.SaveFile_XXT500)
                   m.loLog.Files.XXT505_DBF.SetSave(m.XX_System.SaveFile_XXT505)
                ENDIF

           CASE m.lcPom=="CVP" OR m.lcPom=="CVPX" OR m.lcPom=="CVI"
                m.llOK=m.loLog.Open(UPPER(m.lcFile))

        ENDCASE

        DO CASE
           CASE NOT m.llOK
           
           CASE UPPER(m.lcAction)=="--SAVE"
                DO CASE
                   CASE m.lcOutExt=="CVP" OR m.lcOutExt=="CVPX"
                        m.loLog.Save(m.lcOUTFile)

                   CASE m.lcOutExt=="CVI"
                        m.loLog.Export(m.lcOUTFile)

                ENDCASE
                m.loLOG=.NULL.

           CASE UPPER(m.lcAction)=="--CREATELOG"
                m.loLog.CreateLog(m.lcOUTFile)

           CASE UPPER(m.lcAction)=="--CREATELOGEX"
                m.loLog.CreateLogEx(m.lcOUTFile)

           CASE UPPER(m.lcAction)=="--EXPORTCALLSTACK"
                m.loLog.ExportXXT505(m.lcOUTFile)

           CASE UPPER(m.lcAction)="--REPAIRCALLSTACK"
                m.loLog.RepairXXT505()
   ENDCASE
ENDCASE

RELE m.lcOutExt, m.loLOG, m.llOK


XX_System.NT=CREATEOBJECT("_NumberTable")

DO WHILE m.XX_System.lGUIAllowed
   m.llEnd=.T.
   m.plEnd=.F. && zrus priznak ukonceni
   m.XX_System.ReadEvents()

   =CVP_CLOSEALLFORMS()

   IF m.llEnd && pokud ma byt konec
      EXIT && pak vyskoc ven
   ENDIF
ENDDO

DO CVP_CLEAR
m.loIDE.RestoreIDEProps()

RETURN 

*****************************************************************************
PROCEDURE CVP_DOC
=CVP_CLOSEALLFORMS()
=CVP_CLEAR()
ENDPROC

*****************************************************************************
PROCEDURE CVP_CLOSEALLFORMS

LOCAL m.lcName, m.lcBC, m.llEnd, m.lii
m.plEnd=.T. && nastav priznak ukonceni
FOR m.lii=_Screen.FormCount TO 1 STEP -1
    IF TYPE("_Screen.Forms(m.lii)")#"O"
       LOOP
    ENDIF

    m.lcName=_Screen.Forms(m.lii).Name
    m.lcBC=UPPER(_Screen.Forms(m.lii).BaseClass)
    IF UPPER(m.lcName)="XXF000_"
       RELEASE WIND (m.lcName)
       IF _Screen.FormCount>=m.lii AND _Screen.Forms(m.lii).Name==m.lcName
          m.llEnd=.F.
          EXIT && pak vyskoc ven
       ELSE
          RELE (m.lcName)
       ENDIF
    ELSE
       IF UPPER(m.lcName)="XXF012" OR m.lcBC="TOOLBAR"
          RELEASE WIND (m.lcName)
          RELE (m.lcName)
       ENDIF
    ENDIF
NEXT

ENDPROC

*****************************************************************************
PROCEDURE CVP_CLEAR
ON SHUTDOWN

IF m.XX_System.lGUIAllowed
   m.XX_System.SaveScreen() && uloz pozici a velikost okna
   m.XX_System.SaveOptions() && uloz nastaveni aplikace
   m.XX_System.SaveRecentFiles() && uloz seznam naposled otevrenych souboru
   m.XX_System.SaveFindValues() && uloz seznam naposled hledanych hodnot
   m.XX_System.SaveWindPosition() && uloz pozice oken
   m.XX_System.SaveEFRX() && uloz umisteni reportovacich enginu
   m.XX_System.UnLoadLocalize()
ENDIF

XX_System.NT=.NULL.

LOCAL m.loPar
m.loPar=CREATEOBJECT("_WinHelp")
m.loPar.hwnd=m.XX_System.hwnd
m.loPar.File=m.XX_System.Help
m.loPar.Command=HH_CLOSE_ALL
m.loPar.Data=0
m.XX_ActSrv.Run("XX_SrvSeznam", _ACT_Help, @m.loPar) && ukonci help

IF m.XX_System.lGUIAllowed
   =UNBINDEVENTS(_Screen, "Resize", m.XX_System, "Resize")
   =UNBINDEVENTS(m.XX_System.hwndS, WM_DROPFILES)

   =cvp_DragAcceptFiles(m.XX_System.hwndS, 0)
ENDIF


IF m.XX_System.lGUIAllowed
   m.XXF010.Hide()
   =CVP_SetParent(m.XXF010.hwnd, 0) && presun ho ze status baru

   RELE POPUP _main_mFile,_main_mEdit,_main_mView,_main_mWind,_main_mMove,;
              _main_mPrint,_main_mExport,_main_mOpenSpec
   RELE PAD _msm_File OF _msysmenu
   RELE PAD _msm_Edit OF _msysmenu
   RELE PAD _msm_View OF _msysmenu
   RELE PAD _msm_Windo OF _msysmenu
   RELE PAD _msm_Move OF _msysmenu
ENDIF


RELE m.XXEFRX
RELE m.XX_Res
RELE m.XX_ActSrv
RELE m.XX_SrvSeznam
RELE m.XXF010
RELE m.XXTherm
RELE m.XX_ListImage
RELE m.XX_OCXClasslib
RELE m.plEnd
RELE m.XXEFRX
RELE m.pcJUSTIFY
RELE m.XX_System
RELE m.XX_tmpFiles

=AppDestroy() && odstran knihovny


SET SYSMENU TO DEFAULT
RELE m.pcCommandLine
ENDPROC


*****************************************************************************
PROCEDURE CVP_GETPLATFORM
RETURN IIF(GETENV("PROCESSOR_ARCHITECTURE")=="x86", 32, 64)
ENDPROC


*****************************************************************************
PROCEDURE SeekInXXTY(m.liVal, m.liSele)
=SEEK(BINTOC(m.liVal), m.liSele, "X02")
RETURN

*****************************************************************************
* Vrati zda existuje dana instance objektu
*****************************************************************************
PROCEDURE GetObjRef(m.lcInstance, m.loForm)
* lcInstance - Nazev instance objektu
* @loForm    - zde se linkuje dany formular

* Vraci .T. pokud instance existuje
IF !EMPTY(m.lcInstance) AND TYPE(m.lcInstance)="O" AND !ISNULL(EVAL(m.lcInstance))
   m.loForm=EVAL(m.lcInstance) && nastav referenci na formular
   RETURN .T. && nastav priznak na .T.
ENDIF
RETURN .F. && vrat priznak

****************************************************************************************
PROCEDURE GetMainParent(m.loObj, m.loParent)
*  loObj    - objekt na formulari
* @loParent - sem se zapise nalezeny objekt
LOCAL m.lcObj, m.lii
IF TYPE("m.loObj")#"O" && pokud pod mysi neni objekt
   m.loParent=.NULL. && pak nastav .NULL.
   RETURN ErrOK
ENDIF
m.lcObj=SYS(1272, m.loObj)
m.lii=AT(".", m.lcObj)
m.loParent=EVAL(IIF(m.lii=0, IIF(m.lcObj="screen", "_Screen", m.lcObj), LEFT(m.lcObj, m.lii-1))) && zapis si aktualni objekt do loParent
RETURN ErrOK


*************************************
PROCEDURE Main_Quit
LOCAL m.llQuit
m.llQuit=.T. && nastav priznak ukonceni
* pokud tam jsou nejake formulare

IF _Screen.FormCount>0
   IF TYPE("_Screen.ActiveForm")="O"
      IF _Screen.ActiveForm.WindowType=1 && pokud je aktivni okno modalni
         m.llQuit=.F. && zrus priznak ukonceni
         _Screen.ActiveForm.Release() && ukonci jej
         RETURN && vrat se
      ENDIF
   ENDIF
ENDIF
IF m.llQuit
   CLEAR EVENTS
ENDIF
RETURN

************************************************************
PROCEDURE ShowWindDlg()
PUBLIC m.XXF020
LOCAL m.loPar, m.loForm
m.loPar=CREATEOBJECT("_ParObj")
m.loPar.Par1=0
m.XXF020=CREATEOBJECT("_frmXXF020", @m.loPar)
m.XXF020.Name="XXF020"
m.XXF020.Show() && zobraz ho
RELE m.XXF020
m.XX_ActSrv.SetFlag("m.XX_SrvSeznam") && povol/nastav priznaky
IF TYPE("m.XXTool_1")="O"
   m.XXTool_1.GoContainer.SetEnab() && povol/zakaz butony v toolbaru
ENDIF
IF m.loPar.Par1>0
   =EVAL(m.XX_SrvSeznam.CVPFiles.Controls(m.loPar.Par1).Name+".Show()")
ENDIF
RETURN

************************************************************
PROCEDURE ShowFileDlg()
PUBLIC m.XXF022
LOCAL m.loPar, m.lii
m.loPar=CREATEOBJECT("_ParObj")
m.loPar.Par1=0
m.XXF022=CREATEOBJECT("_frmXXF022", @m.loPar)
m.XXF022.Name="XXF022"
m.XXF022.Show() && zobraz ho
RELE m.XXF022

m.XX_ActSrv.SetFlag("m.XX_SrvSeznam") && povol/nastav priznaky
IF TYPE("m.XXTool_1")="O"
   m.XXTool_1.GoContainer.SetEnab() && povol/zakaz butony v toolbaru
ENDIF
IF m.loPar.Par1>0
   * Par1 obsahuje pocet vybranych souboru
   * a matice pArray pak jejich seznam 
   FOR m.lii=1 TO m.loPar.Par1
       m.XX_ActSrv.Run('XX_SrvSeznam', _ACT_Open, m.loPar.pArray(m.lii))
   NEXT
ENDIF
RETURN

************************************************************
PROCEDURE ShowOutputDlg()
m.XX_System.OutPut=IIF(m.XX_System.OutPut=0, 1, 0)
_ShowOutputDlg() && zobraz/skryj ho

************************************************************
PROCEDURE _ShowOutputDlg()
IF m.XX_System.OutPut=0 && pokud nema existovat
   RELE m.XXF012 && pak ho shod
   SET MARK OF BAR 1 OF _main_mView TO .F.
ELSE
   PUBLIC m.XXF012
   m.XXF012=CREATEOBJECT("_frmXXF012")
   m.XXF012.Name="XXF012"

   IF LEN(m.XX_System.OPT.OPText)>0 AND LEN(m.XXF012.edtList.Value)=0
      m.XXF012.edtList.Value=m.XX_System.OPT.OPText
   ENDIF

   m.XXF012.Show() && zobraz ho
   SET MARK OF BAR 1 OF _main_mView TO .T.
ENDIF

************************************************************
PROCEDURE ShowXXTool_1()
m.XX_System.XXTool_1=IIF(m.XX_System.XXTool_1=0, 1, 0)
_ShowXXTool_1() && zobraz/skryj ho

************************************************************
PROCEDURE ShowXXTool_2()
m.XX_System.XXTool_2=IIF(m.XX_System.XXTool_2=0, 1, 0)
_ShowXXTool_2() && zobraz/skryj ho

************************************************************
PROCEDURE _ShowXXTool_1()

IF m.XX_System.XXTool_1=0 && pokud nema existovat
   RELE m.XXTool_1
   SET MARK OF BAR 2 OF _main_mView TO .F.
ELSE
   PUBLIC m.XXTool_1
   m.XXTool_1=CREATEOBJECT("_CVP_Toolbar", "XXTool_1") && vytvor toolbar
   WITH m.XXTool_1
   .Name="XXTool_1"
   .AddObject("GoContainer", "_action_go_cont")
   .GoContainer.AddActButt(_ACT_New, "_cmd_1", m.XX_Res.ReadBarEx(_main_mFile_barprm_01, Res_Type_Menu_Message)) && New
   .GoContainer.AddActButt(_ACT_Open, "_cmd_2", m.XX_Res.ReadBarEx(_main_mFile_barprm_02, Res_Type_Menu_Message)) && Open
   .GoContainer.AddActButt(_ACT_Close, "_cmd_3", m.XX_Res.ReadBarEx(_main_mFile_barprm_03, Res_Type_Menu_Message)) && Close
   .GoContainer.AddActButt(_ACT_Save, "_cmd_4", m.XX_Res.ReadBarEx(_main_mFile_barprm_04, Res_Type_Menu_Message)) && Save
   .GoContainer.AddActButt(_ACT_SaveAs, "_cmd_5", m.XX_Res.ReadBarEx(_main_mFile_barprm_05, Res_Type_Menu_Message)) && SaveAs
   .GoContainer.AddActButt(_ACT_SaveAll, "_cmd_6", m.XX_Res.ReadBarEx(_main_mFile_barprm_07, Res_Type_Menu_Message)) && SaveAll
   .AddObject("Sep1", "Separator")
   .Sep1.Visible= .T.
   .GoContainer.AddActButt(_ACT_Find, "_cmd_18", m.XX_Res.ReadBarEx(_msm_Edit_Find, Res_Type_Menu_Message)) && Find
   .GoContainer.AddActButt(_ACT_SelRecords, "_cmd_32", m.XX_Res.ReadBarEx(_msm_Edit_SelRecords, Res_Type_Menu_Message)) && Select rows...
   .GoContainer.AddActButt(_ACT_HighLightRecords, "_cmd_33", m.XX_Res.ReadBarEx(_msm_Edit_HighLightRecords, Res_Type_Menu_Message)) && HighLight rows
   .AddObject("Sep5", "Separator")
   .Sep5.Visible= .T.
   .GoContainer.AddActButt(_ACT_FilterSelRecords, "_cmd_42", m.XX_Res.ReadBarEx(_msm_Edit_FilterSelRecords, Res_Type_Menu_Message)) && Filter Select rows
   .GoContainer.AddActButt(_ACT_FilterHighLightRecords, "_cmd_43", m.XX_Res.ReadBarEx(_msm_Edit_FilterHighLightRecords, Res_Type_Menu_Message)) && Filter HighLight rows
   .AddObject("Sep2", "Separator")
   .Sep2.Visible= .T.
   .GoContainer.AddActButt(_ACT_RowD, "_cmd_19", m.XX_Res.ReadBarEx(_main_mView_barprm_4, Res_Type_Menu_Message)) && Row detail
   .GoContainer.AddActButt(_ACT_MPG, "_cmd_20", m.XX_Res.ReadBarEx(_main_mView_barprm_5, Res_Type_Menu_Message)) && Globalni pohled na M/P
   .GoContainer.AddActButt(_ACT_MPD, "_cmd_21", m.XX_Res.ReadBarEx(_main_mView_barprm_6, Res_Type_Menu_Message)) && Detail M/P
   .AddObject("Sep3", "Separator")
   .Sep3.Visible= .T.
   .GoContainer.AddActButt(_ACT_GraphZoom, "_cmd_34", m.XX_Res.ReadStringEx(XXF08X_Zoom_TTT)) && Row detail
   .GoContainer.AddActButt(_ACT_Graph_1, "_cmd_35", m.XX_Res.ReadStringEx(XXF08X_Graph1_TTT)) && Globalni pohled na M/P
   .GoContainer.AddActButt(_ACT_Graph_2, "_cmd_36", m.XX_Res.ReadStringEx(XXF08X_Graph2_TTT)) && Detail M/P
   .GoContainer.AddActButt(_ACT_Graph_3, "_cmd_37", m.XX_Res.ReadStringEx(XXF08X_Graph3_TTT)) && Detail M/P
   .AddObject("Sep4", "Separator")
   .Sep4.Visible= .T.
   .GoContainer.AddActButt(_ACT_Help, "_cmd_7", m.XX_Res.ReadBarEx(_main_mHelp_barprm_01, Res_Type_Menu_Message)) && SaveAll


*   .Dock(0,0,0)        && umisteni toolbaru
   .Caption=m.XX_Res.ReadStringEx(_main_tlbCaption)  && nastaveni nadpisu
*   .Width=560         && nastevni sirky toolbaru

   .SetAll("FontCharSet",m.XX_System.FontCharSet)
   .Visible=.T.
   ENDWITH
   m.XX_ActSrv.GoSrv.Register("XXTool_1.GoContainer") && zaregistruj objekt u serveru
   m.XXTool_1.GoContainer.SetEnab() && povol/zakaz butony v toolbaru
   SET MARK OF BAR 2 OF _main_mView TO .T.
ENDIF
RETURN 

************************************************************
PROCEDURE _ShowXXTool_2()

IF m.XX_System.XXTool_2=0 && pokud nema existovat
   RELE m.XXTool_2
   SET MARK OF BAR 3 OF _main_mView TO .F.
ELSE
   PUBLIC XXTool_2
   XXTool_2=CREATEOBJECT("_CVP_Toolbar","XXTool_2") && vytvor toolbar
   WITH m.XXTool_2
   .Name="XXTool_2"
   .AddObject("GoContainer","_action_go_cont")
   .GoContainer.AddActButt(_ACT_GoToParent,"_cmd_8",m.XX_Res.ReadBarEx(_main_mMove_GoToParent,Res_Type_Menu_Message)) && GoToParent
   .GoContainer.AddActButt(_ACT_GoToChild,"_cmd_9",m.XX_Res.ReadBarEx(_main_mMove_GoToChild,Res_Type_Menu_Message)) && GoToChild
   .GoContainer.AddActButt(_ACT_GoToSource,"_cmd_31",m.XX_Res.ReadBarEx(_main_mMove_GoToSource,Res_Type_Menu_Message)) && GoToSource
   .AddObject("Sep1","Separator")
   .Sep1.Visible= .T.
   .GoContainer.AddActButt(_ACT_GoToCurrent,"_cmd_10",m.XX_Res.ReadBarEx(_main_mMove_GoToCurrent,Res_Type_Menu_Message)) && GoToCurrent
   .AddObject("Sep2","Separator")
   .Sep2.Visible= .T.
   .GoContainer.AddActButt(_ACT_GoToHome,"_cmd_11",m.XX_Res.ReadBarEx(_main_mMove_GoToHome,Res_Type_Menu_Message)) && GoToHome
   .GoContainer.AddActButt(_ACT_GoToEnd,"_cmd_12",m.XX_Res.ReadBarEx(_main_mMove_GoToEnd,Res_Type_Menu_Message)) && GoToEnd
   
*   .Dock(0,XXTool_1.Width+5,0)        && umisteni toolbaru
   .Caption=m.XX_Res.ReadStringEx(_main_tlbCaption2)  && nastaveni nadpisu
*   .Width=200         && nastevni sirky toolbaru

   .SetAll("FontCharSet",m.XX_System.FontCharSet)

   .Visible=.T.
   ENDWITH

   m.XX_ActSrv.GoSrv.Register("XXTool_2.GoContainer") && zaregistruj objekt u serveru
   XXTool_2.GoContainer.SetEnab() && povol/zakaz butony v toolbaru
   SET MARK OF BAR 3 OF _main_mView TO .T.
ENDIF
RETURN 




************************************************************
PROCEDURE ShowOptionDlg()
PUBLIC m.XXF030
m.XXF030=CREATEOBJECT("_frmXXF030")
m.XXF030.Name="XXF030"
m.XXF030.Show() && zobraz ho
RELE m.XXF030

m.XX_ActSrv.SetFlag("XX_SrvSeznam") && povol/nastav priznaky
IF TYPE("m.XXTool_1")="O"
   m.XXTool_1.GoContainer.SetEnab() && povol/zakaz butony v toolbaru
ENDIF
RETURN

************************************************************
PROCEDURE ShowAboutDlg()
PUBLIC m.XXF040
m.XXF040=CREATEOBJECT("_frmXXF040")
m.XXF040.Name="XXF040"
m.XXF040.Show() && zobraz ho
RELE m.XXF040

m.XX_ActSrv.SetFlag("XX_SrvSeznam") && povol/nastav priznaky
IF TYPE("m.XXTool_1")="O"
   m.XXTool_1.GoContainer.SetEnab() && povol/zakaz butony v toolbaru
ENDIF
RETURN


************************************************************
PROCEDURE ShowFileOptionDlg(m.lcName)
* lcName - nazev objektu
PUBLIC m.XXF060
m.XXF060=CREATEOBJECT("_frmXXF060", m.lcName)
m.XXF060.Name="XXF060"
m.XXF060.Show() && zobraz ho
RELE m.XXF060

m.XX_ActSrv.SetFlag("XX_SrvSeznam") && povol/nastav priznaky
IF TYPE("m.XXTool_1")="O"
   m.XXTool_1.GoContainer.SetEnab() && povol/zakaz butony v toolbaru
ENDIF
RETURN


************************************************************
PROCEDURE ShowPrintDlg(m.loReport)
* loReport - Objekt reportu
PUBLIC m.XXF100
m.XXF100=CREATEOBJECT("_frmXXF100", @loReport)
m.XXF100.Name="XXF100"
m.XXF100.Show() && zobraz ho
RELE m.XXF100

m.XX_ActSrv.SetFlag("XX_SrvSeznam") && povol/nastav priznaky
IF TYPE("m.XXTool_1")="O"
   m.XXTool_1.GoContainer.SetEnab() && povol/zakaz butony v toolbaru
ENDIF
RETURN

************************************************************
PROCEDURE ShowEFRXDlg(m.lcEFRX)
* lcEFRX - ID enginu
PUBLIC m.XXF0305
m.XXF0305=CREATEOBJECT("_frmXXF0305", @m.lcEFRX)
m.XXF0305.Name="XXF0305"
m.XXF0305.Show() && zobraz ho
RELE m.XXF0305

m.XX_ActSrv.SetFlag("XX_SrvSeznam") && povol/nastav priznaky
IF TYPE("m.XXTool_1")="O"
   m.XXTool_1.GoContainer.SetEnab() && povol/zakaz butony v toolbaru
ENDIF
RETURN


************************************************************
PROCEDURE ShowWMDlg(m.loEWM, m.loWM)
* loEWM - Engine MW scope
* loWM  - Report MW 
PUBLIC m.XXF110
m.XXF110=CREATEOBJECT("_frmXXF110", @m.loEWM, @m.loWM)
m.XXF110.Name="XXF110"
m.XXF110.Show() && zobraz ho
RELE m.XXF110

m.XX_ActSrv.SetFlag("XX_SrvSeznam") && povol/nastav priznaky
IF TYPE("m.XXTool_1")="O"
   m.XXTool_1.GoContainer.SetEnab() && povol/zakaz butony v toolbaru
ENDIF
RETURN

************************************************************
PROCEDURE ShowMsgDlg(m.loEEmail, m.loEmail)
* loEEmail - Engine Email scope
* loEmail  - Report Email
PUBLIC m.XXF120
m.XXF120=CREATEOBJECT("_frmXXF120", @m.loEEmail, @m.loEmail)
m.XXF120.Name="XXF120"
m.XXF120.Show() && zobraz ho
RELE m.XXF120

m.XX_ActSrv.SetFlag("XX_SrvSeznam") && povol/nastav priznaky
IF TYPE("m.XXTool_1")="O"
   m.XXTool_1.GoContainer.SetEnab() && povol/zakaz butony v toolbaru
ENDIF
RETURN

************************************************************
PROCEDURE ShowSMTPDlg(m.loEEmail, m.loEmail)
* loEEmail - Engine Email scope
* loEmail - Objekt Email scope
PUBLIC m.XXF130
m.XXF130=CREATEOBJECT("_frmXXF130", @m.loEEmail, @m.loEmail)
m.XXF130.Name="XXF130"
m.XXF130.Show() && zobraz ho
RELE m.XXF130

m.XX_ActSrv.SetFlag("XX_SrvSeznam") && povol/nastav priznaky
IF TYPE("m.XXTool_1")="O"
   m.XXTool_1.GoContainer.SetEnab() && povol/zakaz butony v toolbaru
ENDIF
RETURN

************************************************************
DEFINE CLASS _IDEEnv AS custom
   Name="_IDEEnv"
   cIDECaption="" && Screen caption
   cIDEIcon="" && screen icon
   cIDEHelp="" && Help on/off
   cIDEHelp_1="" && help file (dbf,chm,hlp)
   cIDEHelp_2="" && URL
   cIDEHelp_3="" && SYSTEM
   cPROCED=""
   cCLASSLIB=""
   cFLLs=""
   cSHUTDOWN=""
   cERROR=""
   cSTATUSBAR=""

   cEXCLUSIVE=""
   cDATE=""
   cSCOREBOARD=""
   cCONFIRM=""
   cSYSFORMAT=""
   cEXACT=""
   cHOURS=""
   cTALK=""
   cCENTURY=""
   cSAFETY=""

   cESCAPE=""
   cONESCAPE=""

   PROCEDURE SaveIDEProps()
     PUSH MENU _msysmenu
     SET SYSMENU TO  && pak zlikviduj menu
     This.cPROCED=SET("PROCED")
     This.cCLASSLIB=SET("CLASSLIB")
     This.cFLLs=SET("LIBRARY")
     This.cIDECaption=_Screen.Caption
     This.cIDEIcon=_Screen.Icon
     This.cIDEHelp=SET("HELP")
     This.cIDEHelp_1=SET("HELP", 1)
     This.cIDEHelp_2=SET("HELP", 2)
     This.cIDEHelp_3=SET("HELP", 3)
     This.cSHUTDOWN=ON("SHUTDOWN")
     This.cERROR=ON("ERROR")
     This.cSTATUSBAR=SET("STATUS BAR")


     This.cEXCLUSIVE=SET("EXCLUSIVE")
     This.cDATE=SET("DATE")
     This.cSCOREBOARD=SET("SCOREBOARD")
     This.cCONFIRM=SET("CONFIRM")
     This.cSYSFORMAT=SET("SYSFORMAT")
     This.cEXACT=SET("EXACT")
     This.cHOURS=SET("HOURS")
     This.cTALK=SET("TALK")
     This.cCENTURY=SET("CENTURY")
     This.cSAFETY=SET("SAFETY")

     This.cESCAPE=SET("ESCAPE")
     This.cONESCAPE=ON("ESCAPE")

   ENDPROC

   PROCEDURE RestoreIDEProps()
     LOCAL m.lcPom, m.lii, m.liy
     LOCAL ARRAY m.laFiles(1)
     _Screen.Caption=This.cIDECaption
     _Screen.Icon=This.cIDEIcon

     IF !EMPTY(This.cIDEHelp_1)
        SET HELP TO (This.cIDEHelp_1)
     ENDIF

*!*     IF !EMPTY(This.cIDEHelp_2)
*!*        SET HELP COLLECTION (This.cIDEHelp_2)
*!*     ENDIF

     IF !EMPTY(This.cIDEHelp_3)
        SET HELP SYSTEM
     ENDIF

     m.lcPom=This.cIDEHelp
     SET HELP &lcPom.

     SET PROCEDURE TO
     IF LEN(This.cPROCED)>0
        FOR lii=1 TO ALINES(m.laFiles, This.cPROCED, 0, ",")
            SET PROCEDURE TO (m.laFiles(m.lii)) ADDITIVE
        NEXT
     ENDIF

     SET CLASSLIB TO
     IF LEN(This.cCLASSLIB)>0
        FOR m.lii=1 TO ALINES(m.laFiles, This.cCLASSLIB, 0, ",")
            m.liy=RAT(" ", m.laFiles(m.lii))
            m.lcPom=SUBSTR(m.laFiles(m.lii), m.liy+1)
            IF RIGHT(m.lcPom, 6)=="ALIAS "
               m.lcPom=LEFT(m.lcPom, LEN(m.lcPom)-6)
            ENDIF
            SET CLASSLIB TO (LEFT(m.laFiles(m.lii), m.liy))  ALIAS (m.lcPom) ADDITIVE
        NEXT
     ENDIF

     SET LIBRARY TO
     IF LEN(This.cFLLs)>0
        FOR lii=1 TO ALINES(m.laFiles, This.cFLLs, 0, ",")
            SET LIBRARY TO (m.laFiles(m.lii)) ADDITIVE
        NEXT
     ENDIF

     IF EMPTY(This.cSHUTDOWN)
        ON SHUTDOWN 
     ELSE
        m.lcPom=This.cSHUTDOWN
        ON SHUTDOWN &lcPom.
     ENDIF

     IF EMPTY(This.cERROR)
        ON ERROR
     ELSE
        m.lcPom=This.cERROR
        ON ERROR &lcPom.
     ENDIF

     m.lcPom=This.cSTATUSBAR
     SET STATUS BAR &lcPom

     m.lcPom=This.cEXCLUSIVE
     SET EXCLUSIVE &lcPom.
     m.lcPom=This.cDATE
     SET DATE TO &lcPom.
     m.lcPom=This.cSCOREBOARD
     SET SCOREBOARD &lcPom.
     m.lcPom=This.cCONFIRM
     SET CONFIRM &lcPom.
     m.lcPom=This.cSYSFORMAT
     SET SYSFORMAT &lcPom.
     m.lcPom=This.cEXACT
     SET EXACT &lcPom.
     m.lcPom=This.cHOURS
     SET HOURS TO &lcPom.
     m.lcPom=This.cTALK
     SET TALK &lcPom.
     lcPom=This.cCENTURY
     SET CENTURY &lcPom.
     m.lcPom=This.cSAFETY
     SET SAFETY &lcPom.

     m.lcPom=This.cESCAPE
     SET ESCAPE &lcPom.

     IF EMPTY(This.cONESCAPE)
        ON ESCAPE
     ELSE
        m.lcPom=This.cONESCAPE
        ON ESCAPE &lcPom.
     ENDIF

     POP MENU _msysmenu

   ENDPROC
ENDDEFINE


DEFINE CLASS _AutoYield AS CUSTOM
   Name="_AutoYield"

   iCount=0
   _AutoYield=.NULL. && default value

   PROCEDURE Push
      *
      * _AutoYield::Push
      *
      LPARAMETERS m.llAutoYield
      IF This.iCount=0
         This._AutoYield=_VFP.AutoYield
         _VFP.AutoYield=m.llAutoYield
      ENDIF
      This.iCount=This.iCount+1
   ENDPROC


   PROCEDURE Pop
      *
      * _AutoYield::Pop
      *
      This.iCount=This.iCount-1

      IF This.iCount=0
         _VFP.AutoYield=This._AutoYield
      ENDIF

   ENDPROC

ENDDEFINE
************************************************************
DEFINE CLASS _System AS custom
   Name="_System"

   FontCharSet=1

   BarCount = 100  && posledni pouzite ID baru pro popup _maim_mWind
   Modul="" && nazev aktivniho modulu

   DIME aRecentFiles(1) && seznam otevrenych souboru
   iRecentFiles=0 && citac seznamu

   DIME aFindValues(1) && seznam hledanych hodnot
   iFindValues=0 && citac seznamu

   hwnd=0 && Handle hlavniho okna VFP
   hCallProc=0

   hwndS=0 && Handle _screenu
   hCallProcS=0

   RightToLeft=0

   LogDebug=0 && priznak, zda se maji zachytavat debug hlaska
   RecentFile=0 && priznak, zda se maji zobrazit naposled otevrene soubory (popup)
   RecentFileCount=5 && maximalni pocet naposled otevrenych souboru
   MaxFileCount=5 && maximalni pocet viditelnych souboru (popup)
   MaxWindowCount=5 && maximalni pocet viditelnych oken (popup)
   SizeGrid=XXF000_SizeGrid_A && typ zmeny sloupcu v gridech pro zobrazeni zdrojoveho kodu
   FileSource=XXF000_FileSource_O && priznak , co se ma stat pri zpracovani log souboru, pokud neexistuje soubor se zdrojaky
   OutPut=0 && priznak, zda je zobrazeno vystupni okno
   XXTool_1=1 && Priznak, zda je zobrazen toolbar 1
   XXTool_2=1 && Priznak, zda je zobrazen toolbar 2
   PackMinSize=0.10 && Minimalni velikost souboru pro spusteni jeho komprimace pred ulozenim
   ThreadPriority=-2 && Priorita threadu
   iThreadPriority=0 && Citac nastaveni priority
   DIME aThreadPriority(1)

   DefaultLanguage="ENGLISH" && Defaultni jakzyk, ktery se hleda pokud selze aktualne nastaveny
   Language="ENGLISH" && urceni typu jazyka
   NewLanguage="ENGLISH" && urceni typu jazyka pri zmene v nastaveni
   Collate="GENERAL" && trideni
   Help="" && umisteni a nazev helpu
   CurrentLanguageID=0 && ID jazyka v interni matici aLanguage

   DIME aLanguages(1,2) && seznam jazykovych mutaci
   iLanguage=0 && citac seznamu

   DIME aPackUtils(1,2) && seznam pakovacich utilit
   iPackUtils=0 && citac seznamu

   CVPLocID=0 && ID lokalizovaneho APP

   RegAPP_Path="Software\MJ\CVP\1.0" && cesta v registrech pro ulozeni nastaveni aplikace
   RegCVP_Path="Coverage.Profiler.CVPFile.1" && cesta v registrech souboru CVP
   RegCVPX_Path="Coverage.Profiler.CVPXFile.1" && cesta v registrech souboru CVPX
   RegLOG_Path="Coverage.Profiler.LOGFile.1" && cesta v registrech souboru LOG
   RegCVI_Path="Coverage.Profiler.CVIFile.1" && cesta v registrech souboru CVI

   DefPathNew="" && defaultni cesta pro volbu Novy
   DefPathOpen="" && defaultni cesta pro volbu Otevrit
   DefPath="" && defaultni cesta

   AsociateLOG=0 && priznak, zda se jsou asociovane soubory LOG
   AsociateCVP=0 && priznak, zda se jsou asociovane soubory CVP
   AsociateCVPX=0 && priznak, zda se jsou asociovane soubory CVPX
   AsociateCVI=0 && priznak, zda se jsou asociovane soubory CVI

   SaveFile_XXT500 = 0 && priznak, zda ukladat strom zdroju
   SaveFile_XXT505 = 0 && priznak, zda ukladat strom postupneho volani
   SaveFile_PackU  = "" && Kod pakovaci utility

   Loader="" && Loader
   IntegrateIDE=0 && Flag of integrate CVP with IDE

   AnimatedIcon = XXF000_Icon_Animated && priznak, zda maji byt ikony animovane

   lPackTimer=.F. && priznak spusteni
   lSaveTimer=.F. && priznak spusteni
   lFindTimer=.F. && priznak spusteni

   * umisteni a nazvy pracovni BMP po vykopirovani
   bmpFindA=""
   bmpFindD=""
   bmpSaveA=""
   bmpPackA=""

   Start_mFilecntBar=0 && pocatecni pocet baru popupu _mFile

   chmEngine=.NULL. && Cesta a nazev OCX enginu pro HTML Help

   Version=VAL(CHRTRAN(SUBS(VERSION(), LEN("Visual FoxPro ")+1, 5), '.,', SET("POINT")+SET("POINT")))

   cAPPData=""

   ADD OBJECT Resources AS _VFPResources && trida, ktera hlida lokalizacni knihovny
   ADD OBJECT tmrKick AS _tmrKick && trida, ktera shodi modul, kdyz se nepodari zpetne otevrit soubory po ulozeni CVP souboru
   ADD OBJECT OPT AS _cOutPutText
   ADD OBJECT Windows AS CUSTOM
   ADD OBJECT SIMPLYFILTER AS _SIMPLYFILTER
   ADD OBJECT AutoYield AS _AutoYield

   Report=.NULL.
   LockScreen=.F.

   Catch=.NULL. &&  Priznak, ze se ma chyba zachytit
   nErr=0 &&  Error number
   cErrMsg="" &&  Message error
   cErrMethod="" &&  Nazev metody, kam se ma vratit
   
   NT=.NULL. && Number table object

   lFilterSelRecords=.F.
   lFilterHighLightRecords=.F.

   lCancelMode=.F.
   lIsCanceled=.F.
   cAPPName="CVP" && default app name
   lSYS3054=.T. 
   cSYS3054=""
   cNone="" && empty string
   lGUIAllowed=.T.

   cVersion="0130"

   PROCEDURE GetModulObj
     RETURN IIF(EMPTY(This.Modul) OR !LEFT(This.Modul, 7)=="XXF000_", .NULL., EVAL("m.XX_SrvSeznam.CVPFiles."+This.Modul))
   ENDPROC


   PROCEDURE MessageBox
      LPARAMETERS m.lcText, m.liFlags

      LOCAL m.liRet
      IF This.lGUIAllowed
         m.liRet=MESSAGEBOX(m.lcText, m.liFlags, This.cAPPName)
      ELSE
         m.liRet=0
         DEBUGOUT m.lcText
      ENDIF
      RETURN m.liRet
   ENDPROC

   PROCEDURE Error(m.nError, m.cMethod, m.nLine)
      * nError  - Cislo chyby
      * cMethod - Nazev metody ve ktere doslo k chybe
      * nLine   - Cislo radku na kterem doslo k chybe
      LOCAL m.lii, m.lcCProg, m.lcPom, m.lcMth

      IF ISNULL(This.Catch) && Pokud neni definovano
         * Pak zarvi, nebot jde o chybu mimo provadeni
         This.nErr=m.nError && Cislo chyby
         This.cErrMSG=MESSAGE() && Hlaseni chyby

*!*          DECLARE INTEGER sndPlaySoundA IN winmm.dll STRING lpszSoundName, LONG uFlags
*!*          =sndPlaySoundA("X:\Jabber\services\system\sounds\alert.wav",1)
         m.lii=0
         m.lcCProg="A"
         m.lcPom=""
         DO WHILE !EMPTY(m.lcCProg)
            m.lii=m.lii+1  && Inkrementuj citac
            m.lcCProg=PROGRAM(m.lii)   && Nazev programu
            m.lcPom=m.lcPom+CHR(9)+m.lcCProg+CRLF
         ENDDO

         =This.OPT.Add(This.GetModulObj(),;
                       CHR(9)+"E: "+LTRIM(STR(m.nError, 11))+" M: "+m.cMethod+" L: "+LTRIM(STR(m.nLine, 11))+CRLF+;
                       CHR(9)+MESSAGE()+CRLF+CHR(9)+MESSAGE(1)+CRLF+;
                       m.lcPom,.T.)

         m.loErrObj=This
         IF VERSION(2)<>0 AND MESSAGEBOX("Can open Debug?", 4+32)=6
            SUSPEND
         ENDIF   
         RETURN && A vyskoc ven
      ENDIF
      IF This.Catch && Ma ji zachytit
         This.nErr=m.nError && Cislo chyby
         This.cErrMSG=MESSAGE() && Hlaseni chyby
      ELSE
         m.lcMth=This.cErrMethod
         RETURN TO &lcMth.
      ENDIF

   ENDPROC

   PROCEDURE SetAutoYield
      This._AutoYield=.NULL.
      This.iAutoYield=0
   ENDPROC


   PROCEDURE SYS3054 && 
      LPARAMETERS m.llON

      IF NOT This.lSYS3054
         RETURN
      ENDIF

      IF m.llON
         IF EMPTY(This.cSYS3054)
            This.cSYS3054="CVP_"+SYS(2015)
            PUBLIC (This.cSYS3054)
         ENDIF
         =SYS(3054,11, This.cSYS3054)
      ENDIF
      IF NOT m.llON
         =SYS(3054, 0)
         =This.OPT.Add(This.GetModulObj(), EVALUATE(This.cSYS3054)+CRLF)
      ENDIF
   ENDPROC


   PROCEDURE SYS1104
      LPARAM m.lcAlias

      =IIF(EMPTY(m.lcAlias), SYS(1104), SYS(1104, m.lcAlias))
      
      IF This.Version>=10 AND VAL(RIGHT(VERSION(4),4))>=2406
         RETURN
      ENDIF

      * use API
      =CVP_SetProcessWorkingSetSize(CVP_GetCurrentProcess(),-1,-1)
   ENDPROC

   PROCEDURE SetStatusbarText && 
      LPARAMETERS m.lcMSG, m.llDOVENTS

      _VFP.StatusBar=m.lcMSG
      IF m.llDOVENTS
         DOEVENTS FORCE
      ENDIF
   ENDPROC


   PROCEDURE SetThreadPriority && Nastaveni priority
      LPARAMETERS m.liType, m.liNewP

      * liType - 1 - Set, 0 - Reset
*      debugout "SetThreadPriority "+str(liType,11)
      LOCAL m.lihThread, m.liTP

      m.lihThread=cvp_GetCurrentThread()
      IF m.liType=1
         m.liTP=cvp_GetThreadPriority(m.lihThread)

         =cvp_SetThreadPriority(m.lihThread, IIF(PCOUNT()=1, This.ThreadPriority, m.liNewP))
         =This.OPT.Add(This.GetModulObj(), "New thread priority: "+LTRIM(STR(cvp_GetThreadPriority(m.lihThread), 3)))

         This.iThreadPriority=This.iThreadPriority+1
         DIME This.aThreadPriority(This.iThreadPriority)
         This.aThreadPriority(This.iThreadPriority)=m.liTP
         RETURN
      ENDIF

      =cvp_SetThreadPriority(m.lihThread, This.aThreadPriority(This.iThreadPriority))
      =This.OPT.Add(This.GetModulObj(), "Restore thread priority: "+LTRIM(STR(cvp_GetThreadPriority(m.lihThread), 3)))
      This.iThreadPriority=This.iThreadPriority-1
      IF This.iThreadPriority>0
         DIME This.aThreadPriority(This.iThreadPriority)
      ENDIF
   ENDPROC


   PROCEDURE SetCatch(m.llCatch, m.lcMethod) &&  Nastaveni zachyceni chyby
      * llCatch  - Priznak zachyceni chyby
      * lcMethod - Nazev metody, kam se ma vratit

      LOCAL luCatch
      luCatch=This.Catch
      This.Catch=m.llCatch
      IF m.llCatch && Pokud ma chybu zachytit
         * Pak vyresetuj nastaveni chyby
         This.nErr=0 && Cislo chyby
         This.cErrMSG="" && Hlaseni chyby
         This.cErrMethod=m.lcMethod && Nazev meotdy, kam se ma vratit
      ENDIF
      RETURN m.luCatch && Vrat puvodni nastaveni
   ENDPROC


   PROCEDURE SetCancelMode
      LPARAMETERS m.llCancelMode
      This.lCancelMode=m.llCancelMode
      This.lIsCanceled=.F.
      IF m.llCancelMode
         SET ESCAPE ON
      ELSE
         SET ESCAPE OFF
      ENDIF
   ENDPROC


   PROCEDURE ResetCancelFlag
      This.lIsCanceled=.F.
   ENDPROC


   PROCEDURE Canceled
      IF NOT This.lCancelMode
         RETURN
      ENDIF
      This.lIsCanceled=.T.
   ENDPROC


   PROCEDURE CancelQuestion
     LPARAMETERS m.lcQuestion
      
     IF This.lIsCanceled 
        IF MESSAGEBOX(m.lcQuestion, msgType24, This.cAPPName)=6
           RETURN .F.
        ENDIF
        =This.ResetCancelFlag()
     ENDIF
     RETURN .T.
   ENDPROC


   PROCEDURE ReadEvents()
      READ EVENTS
   ENDPROC

   * ulozi pozice okna do prislusneho objektu
   PROCEDURE Windows.SavePosition(m.lcWind, m.loWind)
      * lcWind - Nazev okna
      * loWind - Objekt okna
      LOCAL m.loObj
      m.loObj=EVAL("This."+m.lcWind)
      m.loObj.Width=m.loWind.Width
      m.loObj.Height=m.loWind.Height
      IF UPPER(m.loObj.XBaseClass)="FORM"
         m.loObj.Left=m.loWind.Left
         m.loObj.Top=m.loWind.Top
         m.loObj.WindowState=m.loWind.WindowState
         m.loObj.Dockable=m.loWind.Dockable
      ENDIF
      IF UPPER(m.loObj.XBaseClass)="TOOLBAR"
         m.loObj.Left=m.loWind.LPosition
         m.loObj.Top=m.loWind.TPosition
         m.loObj.DockPosition=m.loWind.DPosition
      ENDIF
   ENDPROC

   * nacte pozice okna z prislusneho objektu
   PROCEDURE Windows.LoadPosition(m.lcWind, m.loWind)
      * lcWind - Nazev okna
      * loWind - Objekt okna
      LOCAL m.loObj
      m.loObj=EVAL("This."+m.lcWind)
      IF UPPER(m.loObj.XBaseClass)="FORM"
         m.loWind.Dockable=m.loObj.Dockable
*!*             IF m.lcWind=="XXF080" OR m.lcWind=="XXF082" OR m.lcWind=="XXF084"
*!*                RETURN
*!*             ENDIF
      ENDIF

      * nejdrive zjistim, zda se okno nema automaticky nastavit do prostred
      IF m.loObj.AutoCenter AND UPPER(m.loObj.XBaseClass)="FORM"
         loWind.AutoCenter=.T.
      ELSE
         * nyni zjistim, zda okno neni mimo viditelny rozsah tak , aby neslo presunout
         * pokud ano, pak ho necham opet vycentrovat
         IF m.loObj.Top>_Screen.Height OR (m.loObj.Top+m.loObj.Height+SYSMETRIC(4)*2+SYSMETRIC(9))<_Screen.Top OR;
            m.loObj.Left>_Screen.Width OR (m.loObj.Left+m.loObj.Width+SYSMETRIC(3)*2)<_Screen.Left
            IF UPPER(m.loObj.XBaseClass)="FORM"
               m.loWind.AutoCenter=.T.
            ENDIF
         ELSE
            m.loObj.AutoCenter=.F.    && Resetuj priznak autocentru
            IF UPPER(m.loObj.XBaseClass)="FORM"
               * pokud to neni mensi, nez ma byt
               IF m.loObj.Height>=m.loWind.Height AND m.loObj.Width>=m.loWind.Width
                  * pak nastav pozici a velikost
                  m.loWind.Move(m.loObj.Left ,m.loObj.Top, m.loObj.Width, m.loObj.Height)
               ELSE
                  * jinak nastav  jenom pozici
                  m.loWind.Move(m.loObj.Left, m.loObj.Top)
               ENDIF
               loWind.WindowState=m.loObj.WindowState
            ENDIF
            IF UPPER(m.loObj.XBaseClass)="TOOLBAR"
               IF m.loObj.DockPosition=-1 && toolbar neni dokovan
                  loWind.Move(m.loObj.Left, m.loObj.Top)
               ELSE
                  loWind.Dock(m.loObj.DockPosition, m.loObj.Left, m.loObj.Top)
               ENDIF
               loWind.Width=m.loObj.Width
               loWind.Height=m.loObj.Height
            ENDIF
         ENDIF
      ENDIF
   ENDPROC


   PROCEDURE Resize()
      * nyni musim zjisti pozice okna a posunout ho
      IF This.LockScreen OR NOT This.lGUIAllowed
         RETURN
      ENDIF

       This.LockScreen=.T.
      =cvp_LockWindowUpdate(This.hwnd)
      LOCAL m.liWidth, m.lcRect
      m.lcRect=REPL(CHR(0),16)    && nastav buffer pro strukturu
      =cvp_GetWindowRect(m.XX_System.hwnd, @m.lcRect) && zjisti umisteni a velikost screenu
      m.liWidth=IIF(_Screen.WindowState=2, CTOBIN(SUBS(m.lcRect, 9, 4), "RS"), CTOBIN(SUBS(m.lcRect, 9, 4), "RS")-CTOBIN(LEFT(m.lcRect, 4), "RS"))
      m.XXF010.Move(m.liWidth-m.XXF010.Width-IIF(_Screen.WindowState=2, 0, 20), 1)
      =cvp_LockWindowUpdate(0)

      IF NOT ISNULL(This.Report)
         This.ReportPreviewResize()
      ENDIF

      This.LockScreen=.F.
   ENDPROC


   PROCEDURE OnFilesDropped(m.hWindow, m.nMsgID, m.wParam, m.lParam)
      * requires VFP9, otherwise ignored
      * note that input parameters are predefined and should not be changed
      * see WindowProc function for details

      LOCAL m.nReturn
      m.nReturn=0
      IF m.nMsgID=WM_DROPFILES
         This.ProcessDroppedFiles(m.wParam) 
      ELSE
         * pass control to the original window procedure 
         m.nReturn = cvp_CallWindowProc(This.hCallProcS, This.hwnds, m.nMsgID, m.wParam, m.lParam) 
      ENDIF
      RETURN m.nReturn
   ENDPROC


   PROCEDURE ProcessDroppedFiles(m.hDrop) 
      LOCAL m.lnFilecount, m.lii, m.lcBuffer, m.lnLength, m.llDrop,m.lcExt
      m.lnFilecount = cvp_DragQueryFile(m.hDrop, 0xFFFFFFFF, .NULL., 0) 

      FOR m.lii=0 TO m.lnFilecount-1 
          m.lcBuffer = REPLICATE(CHR(0), MAX_PATH) 
          m.lnLength = cvp_DragQueryFile(m.hDrop, m.lii, @m.lcBuffer, MAX_PATH) 
          m.lcBuffer = LEFT(m.lcBuffer, m.lnLength) 

          m.lcExt=UPPER(JUSTEXT(m.lcBuffer)) && nacti typ souboru
          IF cvp_PathIsDirectory(@m.lcBuffer)=0
             DO CASE
                CASE m.lcExt=="CVP" OR m.lcExt=="CVPX" OR m.lcExt=="CVI"
                     =m.XX_ActSrv.Run('XX_SrvSeznam', _ACT_Open, m.lcBuffer)
                     m.llDrop=.T.

                CASE m.lcExt=="LOG" OR m.lcExt=="TXT"
                     =m.XX_ActSrv.Run('XX_SrvSeznam', _ACT_New, m.lcBuffer)
                     m.llDrop=.T.

             ENDCASE
          ENDIF
      NEXT 
      IF m.llDrop
         =cvp_DragFinish(m.hDrop) 
      ENDIF
   ENDPROC


   * provede post-inicializaci vlastnosti, nastaveni atd.
   PROCEDURE ReInitialize
      This.RegisterAppFile()
      This.RestoreEFRX()
   ENDPROC


   PROCEDURE ReadEFRX()
      m.XXEFRX.Requery()
   ENDPROC


   PROCEDURE Destroy
      * stopni animaci
      This.StopSaveTimer()
      This.StopPackTimer()
      This.StopFindTimer()

      * smaz pracovni soubory
      IF FILE(This.bmpFindA)
         DELE FILE (This.bmpFindA)
      ENDIF
      
      IF FILE(This.bmpFindD)
         DELE FILE (This.bmpFindD)
      ENDIF

      IF FILE(This.bmpSaveA)
         DELE FILE (This.bmpSaveA)
      ENDIF

      IF FILE(This.bmpPackA)
         DELE FILE (This.bmpPackA)
      ENDIF

      XX_tmpFiles.UnRegister(This.bmpFindA)
      XX_tmpFiles.UnRegister(This.bmpFindD)
      XX_tmpFiles.UnRegister(This.bmpSaveA)
      XX_tmpFiles.UnRegister(This.bmpPackA)

      IF NOT EMPTY(This.cSYS3054)
         RELEASE (This.cSYS3054)
      ENDIF
   ENDPROC


   PROCEDURE Init
      LOCAL m.lcAPPData, m.liRightToLeft, m.lcData, m.lcDataS, m.lcDataU, m.liZ, m.lii, m.liy, m.liSection, m.lcSection, m.liCountS, m.liCountU, m.lcKey, m.lcCVPINI, m.liCountX
      LOCAL ARRAY m.laSections(1), m.laDataS(1), m.laDataU(1)

      This.hwnd=_vfp.hwnd
      This.hwndS=_screen.hwnd

      IF This.lGUIAllowed
         This.hCallProcS = cvp_GetWindowLong(This.hwndS, GWL_WNDPROC) 
         =BINDEVENT(This.hwndS, WM_DROPFILES, This, "OnFilesDropped") 
         =cvp_DragAcceptFiles(This.hwndS, 1) 
      ENDIF

      STORE m.pcCommandLine TO This.DefPathNew, This.DefPathOpen, This.DefPath

      This.bmpFindA=SYS(2023)+"\"+SYS(2015)+".BMP"
      This.bmpFindD=SYS(2023)+"\"+SYS(2015)+".BMP"
      This.bmpSaveA=SYS(2023)+"\"+SYS(2015)+".BMP"
      This.bmpPackA=SYS(2023)+"\"+SYS(2015)+".BMP"

      This.Windows.AddObject("XXF012","_VFPRect")
      This.Windows.XXF012.xBaseClass="FORM"
      This.Windows.AddObject("XXF080","_VFPRect")
      This.Windows.XXF080.xBaseClass="FORM"
      This.Windows.AddObject("XXF082","_VFPRect")
      This.Windows.XXF082.xBaseClass="FORM"
      This.Windows.AddObject("XXF084","_VFPRect")
      This.Windows.XXF084.xBaseClass="FORM"
      This.Windows.AddObject("XXF070","_VFPRect")
      This.Windows.XXF070.xBaseClass="FORM"
      This.Windows.AddObject("XXF210","_VFPRect")
      This.Windows.XXF210.xBaseClass="FORM"
      This.Windows.AddObject("XXF220","_VFPRect")
      This.Windows.XXF220.xBaseClass="FORM"
      This.Windows.AddObject("XXF090","_VFPRect")
      This.Windows.XXF090.xBaseClass="FORM"
      This.Windows.AddObject("XXTOOL_1","_VFPRect")
      This.Windows.XXTOOL_1.xBaseClass="TOOLBAR"
      STORE 0 TO This.Windows.XXTOOL_1.Left, This.Windows.XXTOOL_1.Top, This.Windows.XXTOOL_1.DockPosition
      This.Windows.XXTOOL_1.Width=500

      This.Windows.AddObject("XXTOOL_2","_VFPRect")
      This.Windows.XXTOOL_2.xBaseClass="TOOLBAR"
      STORE 0 TO This.Windows.XXTOOL_2.Top, This.Windows.XXTOOL_2.DockPosition
      This.Windows.XXTOOL_2.Left=This.Windows.XXTOOL_1.Width+5
      This.Windows.XXTOOL_2.Width=200

      m.lcAPPData=SPACE(254)+CHR(0)
      =cvp_SHGetSpecialFolderPath(0, @m.lcAPPData, 0x1a, 0)
      STORE ADDBS(NullTermined(m.lcAPPData))+"cvp\" TO m.lcAPPData, This.cAPPData
      =MKD(m.lcAPPData)

      IF FILE(m.pcCommandLine+"CVP.ini") 
         m.lcCVPINI=m.lcAPPData+"CVP"+This.cVersion+".ini"
         IF FILE(m.lcCVPINI)

            * Nacti seznam sekci ze vzoroveho souboru
            m.lcData=GetINISectionNames(30000, m.pcCommandLine+"CVP.ini")
            IF !EMPTY(lcData) && Pokud to neni prazdne
               m.lcData=STRTRAN(m.lcData, CHR(0),CHR(13)+CHR(10))
               m.liSection=ALINES(m.laSections, m.lcData) && Nacti radky
            ENDIF

            * Nyni prochazej jednotlive sekce a kontroluj obsah
            FOR m.liz=1 TO m.liSection
                m.lcSection=m.laSections(m.liz)

                STORE 0 TO m.liCountS, m.liCountU
                * Nacti sekci ve vzoru a v uzivatelskem souboru
                m.lcData=GetINISection(@m.lcSection, 32000, m.pcCommandLine+"CVP.ini") && Cela sekce
                IF !EMPTY(m.lcData) && Pokud to neni prazdne
                   m.lcDataS=STRTRAN(m.lcData, CHR(0), CHR(13)+CHR(10))
                   m.liCountS=ALINES(m.laDataS, m.lcDataS) && Nacti radky
                ENDIF

                m.lcData=GetINISection(@m.lcSection, 32000, m.lcCVPINI) && Cela sekce
                IF !EMPTY(lcData) && Pokud to neni prazdne
                   m.lcDataU=STRTRAN(m.lcData, CHR(0), CHR(13)+CHR(10))
                   m.liCountU=ALINES(m.laDataU, m.lcDataU) && Nacti radky
                ENDIF

                * Nyni projdi matici vzorovych dat a hledej klic v uzivatelskych datech
                * Pokud tam klic neni, pak jej zaloz do uzivatelskych dat
                FOR m.lii=1 TO m.liCountS
                    IF EMPTY(m.laDataS(m.lii))
                       LOOP
                    ENDIF
                    m.lcKey=LEFT(m.laDataS(m.lii), AT("=", m.laDataS(m.lii))-1)
                    FOR m.liy=1 TO m.liCountU
                        IF EMPTY(m.laDataU(m.liy)) OR NOT m.lcKey==LEFT(m.laDataU(m.liy), AT("=", m.laDataU(m.liy))-1)
                           LOOP
                        ENDIF
                        IF m.lcKey=="Count" AND;
                           VAL(SUBSTR(m.laDataU(m.liy), AT("=", m.laDataU(m.liy))+1))<VAL(SUBSTR(m.laDataS(m.liy), AT("=", m.laDataS(m.liy))+1))
                           m.liy=m.liCountU+1
                        ENDIF
                        EXIT
                    NEXT
                    * Klic tam neni, zaloz ho
                    =IIF(m.liy<=m.liCountU, .T.,;
                        WriteINIString(@m.lcSection, m.lcKey, SUBS(m.laDataS(m.lii), AT("=", m.laDataS(m.lii))+1), m.lcCVPINI))
                NEXT
            NEXT

         ENDIF

         IF NOT FILE(m.lcCVPINI)
            COPY FILE (m.pcCommandLine+"CVP.ini") TO (m.lcCVPINI)
         ENDIF
      ENDIF

      m.liRightToLeft=0
      This.RightToLeft=cvp_SystemParametersInfoI(27, 0, @m.liRightToLeft, 4)=1 AND m.liRightToLeft=1

   ENDPROC


   * Prida bar do seznamu souboru
   PROCEDURE AddRecentFile
      LPARAMETERS m.loXXLog

      LOCAL m.lii
      * nejdrive musim otestovat zda uz tento soubor neni v seznamu
      FOR m.lii=1 TO This.iRecentFiles
          * pokud je to tento radek
          IF UPPER(This.aRecentFiles(m.lii, 1))==UPPER(m.loXXlog.File)
             =ADEL(This.aRecentFiles,m.lii) && pak je smaz
             This.iRecentFiles=This.iRecentFiles-1 && pak sniz citac
             EXIT && ukonci smycku
          ENDIF
      NEXT

      * dokud jsem nenarazil na mez
      IF This.iRecentFiles<This.RecentFileCount
         This.iRecentFiles=This.iRecentFiles+1 && inkrementuj citac

         DIME This.aRecentFiles(This.iRecentFiles, 2) && nadimenzuj matici
      ELSE
         ADEL(This.aRecentFiles, 1) && smaz prvni radek matice
         * VFP vse nyni posunula dopredu
      ENDIF

      This._AddRecentFile(This.iRecentFiles, m.loXXlog.File)

      * nyni se musi pregenerovat menu
      This.RedefineRecentFile()
   ENDPROC

   PROCEDURE _AddRecentFile && Zapise soubor do interni matice
      LPARAMETERS m.liIndex, m.lcFile
      LOCAL m.lii
      This.aRecentFiles(m.liIndex,1)=m.lcFile && zapis si novy soubor (podle toho budu hledat)
      m.lii=AT("\\",m.lcFile) && nejdriv hledej \\ lomitka (UNC)
      m.lii=IIF(m.lii=0, AT("\", m.lcFile), m.lii+1)
      This.aRecentFiles(m.liIndex,2)=GetShortText_MidleText(m.lcFile, 35, m.lii, LEN(m.lcFile)-RAT("\", m.lcFile)+1, CHR(133)) && toto se zobrazi v popupu
   ENDPROC


   * pregeneruje popup _main_mFile
   PROCEDURE RedefineRecentFile()
      LOCAL m.lii, m.lcPom, m.liy, m.lcPict
      * smaz vsechny vygenerovane bary
      FOR m.lii=CNTBAR("_main_mFile")-1 TO This.Start_mFilecntBar STEP -1
          RELE BAR GETBAR("_main_mFile", m.lii) OF _main_mFile
      NEXT

      IF m.XX_System.RecentFile=1 && pokud se ma generovat
         m.liy=0

         FOR m.lii=m.XX_System.iRecentFiles TO IIF(m.XX_System.iRecentFiles<=m.XX_System.MaxFileCount,1, m.XX_System.iRecentFiles-m.XX_System.MaxFileCount+1) STEP -1
             m.lcPom="m.XX_ActSrv.Run('XX_SrvSeznam', "+LTRIM(STR(_ACT_Open, 11))+",'"+This.aRecentFiles(m.lii, 1)+"')"

             m.liy=m.liy+1
             m.lcPict=" PICTURE "+IIF(FILE(This.aRecentFiles(m.lii, 1)), "'resources\ico16\flok.bmp'", "'resources\ico16\flcl.bmp'")
             DEFINE BAR 1001+m.lii OF _main_mFile PROMPT This.aRecentFiles(m.lii, 2) ;
                                                MESSAGE STRTRAN(m.XX_Res.ReadStringEx(IIF(FILE(This.aRecentFiles(m.lii, 1)), _main_RecentFile_Exist, _main_RecentFile_NotExist)), "%s", This.aRecentFiles(m.lii, 1)) ;
                                                &lcPict.;
                                                BEFORE 6

             ON SELECTION BAR 1001+m.lii OF _main_mFile &lcPom.
         NEXT
         IF m.XX_System.iRecentFiles>m.liy
            DEFINE BAR 1000 OF _main_mFile PROMPT m.XX_Res.ReadBarEx(_main_mFile_barprm_1000, Res_Type_Menu_Prompt) ;
                                           MESS m.XX_Res.ReadBarEx(_main_mFile_barprm_1000, Res_Type_Menu_Message) BEFORE 6
            ON SELECTION BAR 1000 OF _main_mFile ShowFileDlg()
         ENDIF
         IF m.liy>0 && pokud neco bylo
            DEFINE BAR 1001 OF _main_mFile PROMPT '\-'          MESS '' BEFORE 6
         ENDIF
      ENDIF
   ENDPROC


   * Prida bar do popup _main_mWind
   PROCEDURE AddBar
      LPARAMETERS m.loXXLog
      LOCAL m.lcPom, m.lii
      m.lii=CNTBAR("_main_mWind")+1-5
      m.lcPom=m.loXXlog.Name+".Show()"
      STORE This.BarCount+1 TO loXXLog.Bar, This.BarCount && inkrementuj citac baru
      IF m.lii<=This.MaxWindowCount
         DEFINE BAR m.loXXLog.Bar OF _main_mWind PROMPT '\<'+IIF(m.lii<10, STR(m.lii, 1), CHR(m.lii+55))+" "+EVAL(m.loXXlog.Name+".Caption") ;
                                               MESSAGE "" BEFORE 5

         ON SELECTION BAR m.loXXLog.Bar OF _main_mWind &lcPom.
      ENDIF
   ENDPROC


   * zmeni popis baru v popupu _main_mWind
   PROCEDURE ChangeBar
      LPARAMETERS m.loXXLog
      LOCAL m.lcPom, m.lii
      m.lcPom=m.loXXlog.Name+".Show()"
      * nejdriv musim zjistit zda vubec existuje
      FOR m.lii=5 TO CNTBAR("_main_mWind")-1
          IF GETBAR("_main_mWind", m.lii)=m.loXXLog.Bar
             m.lii=m.lii-5
             DEFINE BAR m.loXXLog.Bar OF _main_mWind PROMPT '\<'+IIF(m.lii<10, STR(m.lii, 1), CHR(m.lii+55))+" "+EVAL(m.loXXlog.Name+".Caption") ;
                                                     MESSAGE "" BEFORE m.loXXLog.Bar+1

             ON SELECTION BAR m.loXXLog.Bar OF _main_mWind &lcPom.
             EXIT
          ENDIF
      NEXT
   ENDPROC


   * Odstrani bar z popupu _main_mWind
   PROCEDURE RemoveBar
      LPARAMETERS m.loXXLog
      LOCAL m.lii
      * nejdriv musim zjistit zda vubec existuje
      FOR m.lii=5 TO CNTBAR("_main_mWind")-1
          IF GETBAR("_main_mWind", m.lii)=m.loXXLog.Bar
             RELE BAR (m.loXXLog.Bar) OF _main_mWind
             EXIT
          ENDIF
      NEXT
   ENDPROC


   * pregeneruje popup _main_mWind
   PROCEDURE RedefinePopup()
      LOCAL m.lii, m.lcPom, m.loModul
      * smaz vsechny vygenerovane bary
      FOR m.lii=CNTBAR("_main_mWind")-1 TO 5 STEP -1
          RELE BAR GETBAR("_main_mWind", m.lii) OF _main_mWind
      NEXT

      FOR m.lii=1 TO IIF(m.XX_SrvSeznam.CVPFiles.ControlCount>This.MaxWindowCount, This.MaxWindowCount, m.XX_SrvSeznam.CVPFiles.ControlCount)
          m.loModul=m.XX_SrvSeznam.CVPFiles.Controls(m.lii)
          m.lcPom=m.loModul.Name+".Show()"

          DEFINE BAR m.loModul.Bar OF _main_mWind PROMPT '\<'+IIF(m.lii<10, STR(m.lii, 1), CHR(m.lii+55))+" "+EVAL(m.loModul.Name+".Caption") ;
                                                MESSAGE "" BEFORE 5

          ON SELECTION BAR m.loModul.Bar OF _main_mWind &lcPom.
      NEXT
   ENDPROC


   * nacte pozici a velikost okna z registru
   PROCEDURE RestoreScreen()

      LOCAL m.liHKEY, m.liOFlag, m.llNew, m.lcNewRect, m.liLeft, m.liTop, m.liHeight, m.liWidth, m.liWindowState,;
            m.liMLeft, m.liMTop, m.liMHeight, m.liMWidth

      STORE 0 TO m.liOFlag, m.liHKEY

      * nastaveni defaultnich pozic
      m.lcNewRect=SPACE(16)
      =GetMaxRectWind(This.hwnd, @m.lcNewRect) && zjisti maximalni RECT wokna
      m.liMLeft  =LEFT(m.lcNewRect, 4)    && prevod na cisla - pozice zleva
      m.liMTop   =SUBS(m.lcNewRect, 5, 4)  && prevod na cisla - pozice zeshora
      m.liMWidth =BINTOC(CTOBIN(SUBS(m.lcNewRect, 9, 4), "RS")-CTOBIN(m.liMLeft, "RS"), "RS")
      m.liMHeight=BINTOC(CTOBIN(RIGHT(m.lcNewRect, 4), "RS")-CTOBIN(m.liMTop, "RS"), "RS")

      m.liLeft  =m.liMLeft
      m.liTop   =m.liMTop
      m.liWidth =m.liMWidth
      m.liHeight=m.liMHeight

      m.liMLeft  =CTOBIN(m.liMLeft, "RS")
      m.liMTop   =CTOBIN(m.liMTop, "RS")
      m.liMWidth =CTOBIN(m.liMWidth, "RS")
      m.liMHeight=CTOBIN(m.liMHeight, "RS")

      m.liWindowState=REPL(CHR(0), 4)

      * nacti hodnoty z registry
      =API_RegCreateKeyEx(HKEY_CURRENT_USER, This.RegAPP_Path+CHR(0), "REG_SZ"+CHR(0), @m.liHKEY, @m.liOFlag)
      m.llNew=m.liOFlag=REG_CREATED_NEW_KEY
      IF !m.llNew
         =API_RegQueryValueEx(m.liHKEY, "WindowState"+CHR(0), REG_DWORD, @m.liWindowState, 4)
         m.liWindowState=CTOBIN(m.liWindowState, "RS")

         IF m.liWindowState#1 && pokud okno neni minimalizovano
            _Screen.WindowState=m.liWindowState && pak nastav status
         ENDIF

         IF m.liWindowState=0
            =API_RegQueryValueEx(m.liHKEY, "Left"+CHR(0), REG_DWORD, @m.liLeft, 4)
            =API_RegQueryValueEx(m.liHKEY, "Width"+CHR(0), REG_DWORD, @m.liWidth, 4)
            =API_RegQueryValueEx(m.liHKEY, "Top"+CHR(0), REG_DWORD, @m.liTop, 4)
            =API_RegQueryValueEx(m.liHKEY, "Height"+CHR(0), REG_DWORD, @m.liHeight, 4)
            m.liLeft=CTOBIN(m.liLeft, "RS")
            m.liTop=CTOBIN(m.liTop, "RS")
            m.liWidth=CTOBIN(m.liWidth, "RS")
            m.liHeight=CTOBIN(m.liHeight, "RS")

            m.liLeft=IIF(!BETWEEN(m.liLeft, 0, m.liMLeft), 0, m.liLeft)
            m.liTop=IIF(!BETWEEN(m.liTop, 0, m.liMTop), 0, m.liTop)
            m.liWidth=IIF(!BETWEEN(m.liWidth, 0, m.liMWidth), m.liMWidth, m.liWidth)
            m.liHeight=IIF(!BETWEEN(m.liHeight, 0, m.liMHeight), m.liMHeight, m.liHeight)

            =cvp_MoveWindow(This.hwnd, m.liLeft, m.liTop, m.liWidth, m.liHeight, 1)  && presun screenu pomoci winapi
         ENDIF
      ELSE
         =cvp_MoveWindow(This.hwnd, m.liMLeft, m.liMTop, m.liMWidth, m.liMHeight, 1)  && presun screenu pomoci winapi
      ENDIF
      =API_RegCloseKey(m.liHKEY)
   ENDPROC

   * ulozi pozici a velikost okna do registru
   PROCEDURE SaveScreen()
      LOCAL m.liHKEY, m.lcRect, m.liLeft, m.liWidth, m.liHeight, m.liOFlag
      STORE 0 TO m.liOFlag, m.liHKEY
      * uloz hodnoty do registry
      =API_RegCreateKeyEx(HKEY_CURRENT_USER, This.RegAPP_Path+CHR(0), "REG_SZ"+CHR(0), @m.liHKEY, @m.liOFlag)
      =API_RegSetValueEx(m.liHKEY, "WindowState"+CHR(0), REG_DWORD, BINTOC(_Screen.WindowState, "RS"))

      IF _Screen.WindowState=0
         m.lcRect=REPL(CHR(0), 16)
         * nacti pozice okna
         =cvp_GetWindowRect(This.hwnd, @m.lcRect)

         m.liLeft=LEFT(m.lcRect, 4)  && pozice zleva
         m.liTop=SUBS(m.lcRect, 5, 4) && pozice zeshora

         m.liWidth=BINTOC(CTOBIN(SUBS(m.lcRect, 9, 4), "RS")-CTOBIN(m.liLeft, "RS"), "RS")   && sirka
         m.liHeight=BINTOC(CTOBIN(SUBS(m.lcRect, 13, 4), "RS")-CTOBIN(m.liTop, "RS"), "RS")  && vyska

         =API_RegSetValueEx(m.liHKEY, "Left"+CHR(0), REG_DWORD, m.liLeft)
         =API_RegSetValueEx(m.liHKEY, "Width"+CHR(0), REG_DWORD, m.liWidth)
         =API_RegSetValueEx(m.liHKEY, "Top"+CHR(0), REG_DWORD, m.liTop)
         =API_RegSetValueEx(m.liHKEY, "Height"+CHR(0), REG_DWORD, m.liHeight)
      ENDIF

      =API_RegCloseKey(m.liHKEY)
   ENDPROC


   * nacte nastaveni aplikace z registru
   PROCEDURE RestoreOptions()

      LOCAL m.liHKEY, m.liOFlag, m.llNew, m.liRecentFile, m.liRecentFileCount, m.liMaxWindowCount, m.liOutPut,;
            m.liMaxFileCount, m.lcLanguage, m.liSizeGrid, m.lcDefPathNew, m.lcDefPathOpen,;
            m.liAsociateLOG, m.liAsociateCVP, m.liAsociateCVPX, m.AsociateCVI, m.lcApp, m.liSaveFile_XXT500, m.liSaveFile_XXT505,;
            m.liFileSource, m.liAnimatedIcon, m.liXXTool_1, m.liXXTool_2, m.lcSaveFile_PackU, m.lcPackMinSize,;
            m.liIntegrateIDE, m.lcLoader, m.lcThreadPriority, m.liLogDebug

      STORE 0 TO m.liOFlag, m.liHKEY

      m.liLogDebug=BINTOC(This.LogDebug, "RS")
      m.liRecentFile=BINTOC(This.RecentFile, "RS")
      m.liSizeGrid=BINTOC(This.SizeGrid, "RS")
      m.liFileSource=BINTOC(This.FileSource, "RS")
      m.liRecentFileCount=BINTOC(This.RecentFileCount, "RS")
      m.liMaxFileCount=BINTOC(This.MaxFileCount, "RS")
      m.liMaxWindowCount=BINTOC(This.MaxWindowCount, "RS")
      m.lcLanguage=PADR("ENGLISH", 253)+CHR(0)
      m.lcDefPathNew=PADR(This.DefPathNew, 253)+CHR(0)
      m.lcDefPathOpen=PADR(This.DefPathOpen, 253)+CHR(0)
      m.liOutPut=BINTOC(This.OutPut, "RS")
      m.liAsociateLOG=This.AsociateLOG
      m.liAsociateCVP=This.AsociateCVP
      m.liAsociateCVPX=This.AsociateCVPX
      m.liAsociateCVI=This.AsociateCVI
      m.liSaveFile_XXT500=BINTOC(This.SaveFile_XXT500, "RS")
      m.liSaveFile_XXT505=BINTOC(This.SaveFile_XXT505, "RS")
      m.liAnimatedIcon=BINTOC(This.AnimatedIcon, "RS")
      m.liXXTool_1=BINTOC(This.XXTool_1, "RS")
      m.liXXTool_2=BINTOC(This.XXTool_2, "RS")
      m.lcSaveFile_PackU=PADR(This.SaveFile_PackU, 253)+CHR(0)
      m.lcPackMinSize=STR(This.PackMinSize, 5, 2)+CHR(0)
      m.lcLoader=PADR(This.Loader, 253)+CHR(0)
      m.liIntegrateIDE=BINTOC(This.IntegrateIDE, "RS")
      m.lcThreadPriority=STR(This.ThreadPriority, 3)+CHR(0)

      * nacti hodnoty z registry
      =API_RegCreateKeyEx(HKEY_CURRENT_USER, This.RegAPP_Path+"\Options"+CHR(0), "REG_SZ"+CHR(0), @m.liHKEY, @m.liOFlag)
      m.llNew=m.liOFlag=REG_CREATED_NEW_KEY

      IF !m.llNew

         * priznak, zda se maji zachytavat  debug hlasky
         =API_RegQueryValueEx(m.liHKEY, "LogDebug"+CHR(0), REG_DWORD, @m.liLogDebug, 4)

         * priznak, zda se maji zobrazit naposled otevrene soubory
         =API_RegQueryValueEx(m.liHKEY, "RecentFile"+CHR(0), REG_DWORD, @m.liRecentFile, 4)

         * maximalni pocet naposled otevrenych souboru
         =API_RegQueryValueEx(m.liHKEY, "RecentFileCount"+CHR(0), REG_DWORD, @m.liRecentFileCount, 4)

         * typ zmeny sirky sloupcu v gridech pro zobrazeni zdroj. kodu
         =API_RegQueryValueEx(m.liHKEY, "SizeGrid"+CHR(0), REG_DWORD, @m.liSizeGrid, 4)

         * Priznak, jak se ma CVP zachovat pri zpracovani LOG souboru kdyz nenajde zdrojove kody
         =API_RegQueryValueEx(m.liHKEY, "FileSource"+CHR(0), REG_DWORD, @m.liFileSource, 4)

         * maximalni pocet viditelnych souboru
         =API_RegQueryValueEx(m.liHKEY, "MaxFileCount"+CHR(0), REG_DWORD, @m.liMaxFileCount, 4)

         * pocet otevrenych oken
         =API_RegQueryValueEx(m.liHKEY, "MaxWindowCount"+CHR(0), REG_DWORD, @m.liMaxWindowCount, 4)

         * Priorita threadu
         =API_RegQueryValueEx(m.liHKEY, "ThreadPriority"+CHR(0), REG_SZ, @m.lcThreadPriority, 3)

         * Typ jazyka
         =API_RegQueryValueEx(m.liHKEY, "Language"+CHR(0), REG_SZ, @m.lcLanguage, 254)

         * Defa, cesta pro volbu New
         =API_RegQueryValueEx(m.liHKEY, "DefPathNew"+CHR(0), REG_SZ, @m.lcDefPathNew, 254)

         * Defa, cesta pro volbu Open
         =API_RegQueryValueEx(m.liHKEY, "DefPathOpen"+CHR(0), REG_SZ, @m.lcDefPathOpen, 254)

         * Priznak zobrazeni vystupniho okna
         =API_RegQueryValueEx(m.liHKEY, "OutPut"+CHR(0), REG_DWORD, @m.liOutPut, 4)

         * Priznak zda se ma ulozit strom zdroju
         =API_RegQueryValueEx(m.liHKEY, "SaveFile_XXT500"+CHR(0), REG_DWORD, @m.liSaveFile_XXT500, 4)

         * Priznak zda se ma ulozit strom postupneho volani
         =API_RegQueryValueEx(m.liHKEY, "SaveFile_XXT505"+CHR(0), REG_DWORD, @m.liSaveFile_XXT505, 4)

         * Kod pakovaci utility pro novy soubor
         =API_RegQueryValueEx(m.liHKEY, "SaveFile_PackU"+CHR(0), REG_SZ, @m.lcSaveFile_PackU, 254)

         * Priznak zda maji byt ikony animovane
         =API_RegQueryValueEx(m.liHKEY, "AnimatedIcon"+CHR(0), REG_DWORD, @m.liAnimatedIcon, 4)

         * Priznak zobrazeni toolbaru 1
         =API_RegQueryValueEx(m.liHKEY, "XXTool_1"+CHR(0), REG_DWORD, @m.liXXTool_1, 4)

         * Priznak zobrazeni toolbaru 2
         =API_RegQueryValueEx(m.liHKEY, "XXTool_2"+CHR(0), REG_DWORD, @m.liXXTool_2, 4)

         * Minimalni velikost souboru pro spusteni komprimace pred ulozenim
         =API_RegQueryValueEx(m.liHKEY, "PackMinSize"+CHR(0), REG_SZ, @m.lcPackMinSize, 6)

         * Priznak zda se ma ulozit integrovani s IDE
         =API_RegQueryValueEx(m.liHKEY, "IntegrateIDE"+CHR(0), REG_DWORD, @m.liIntegrateIDE, 4)

         * Umisteni loaderovaci utility
         =API_RegQueryValueEx(m.liHKEY, "Loader"+CHR(0), REG_SZ, @m.lcLoader, 254)

         =API_RegCloseKey(m.liHKEY)

         * Priznak zda je asociovan soubor LOG
         IF API_RegOpenKeyEx(HKEY_CLASSES_ROOT, ".log"+CHR(0), @m.liHKEY)=REGAPI_SUCCESS
            * typ souboru je registrovan
            * nyni nactu defaultni hodnotu a porovnam s nazev App
            m.lcApp=SPACE(254)
            =API_RegQueryValueEx(m.liHKEY, ""+CHR(0), REG_SZ, @m.lcApp, 254)
            m.liAsociateLOG=IIF(NullTermined(m.lcApp)==This.RegLOG_Path, 1, 0)
            =API_RegCloseKey(m.liHKEY)

            IF m.liAsociateLOG=0 AND API_RegOpenKeyEx(HKEY_CLASSES_ROOT, ".log"+"\OpenWithList\Coverage.Profiler"+CHR(0), @m.liHKEY)=REGAPI_SUCCESS
               m.liAsociateLOG=1
               =API_RegCloseKey(m.liHKEY)
            ENDIF
         ENDIF

         * Priznak zda je asociovan soubor CVP
         IF API_RegOpenKeyEx(HKEY_CLASSES_ROOT, ".cvp"+CHR(0), @m.liHKEY)=REGAPI_SUCCESS
            * typ souboru je registrovan
            * nyni nactu defaultni hodnotu a porovnam s nazev App
            m.lcApp=SPACE(254)
            =API_RegQueryValueEx(m.liHKEY, ""+CHR(0), REG_SZ, @m.lcApp, 254)
            m.liAsociateCVP=IIF(NullTermined(m.lcApp)==This.RegCVP_Path, 1, 0)
            =API_RegCloseKey(m.liHKEY)

            IF m.liAsociateCVP=0 AND API_RegOpenKeyEx(HKEY_CLASSES_ROOT, ".cvp"+"\OpenWithList\Coverage.Profiler"+CHR(0), @m.liHKEY)=REGAPI_SUCCESS
               m.liAsociateCVP=1
               =API_RegCloseKey(m.liHKEY)
            ENDIF
         ENDIF

         * Priznak zda je asociovan soubor CVPX
         IF API_RegOpenKeyEx(HKEY_CLASSES_ROOT, ".cvpx"+CHR(0), @m.liHKEY)=REGAPI_SUCCESS
            * typ souboru je registrovan
            * nyni nactu defaultni hodnotu a porovnam s nazev App
            lcApp=SPACE(254)
            =API_RegQueryValueEx(m.liHKEY, ""+CHR(0), REG_SZ, @m.lcApp, 254)
            m.liAsociateCVPX=IIF(NullTermined(m.lcApp)==This.RegCVP_Path, 1, 0)
            =API_RegCloseKey(m.liHKEY)

            IF m.liAsociateCVPX=0 AND API_RegOpenKeyEx(HKEY_CLASSES_ROOT, ".cvpx"+"\OpenWithList\Coverage.Profiler"+CHR(0), @m.liHKEY)=REGAPI_SUCCESS
               m.liAsociateCVPX=1
               =API_RegCloseKey(m.liHKEY)
            ENDIF
         ENDIF

         * Priznak zda je asociovan soubor CVI
         IF API_RegOpenKeyEx(HKEY_CLASSES_ROOT,".cvi"+CHR(0),@m.liHKEY)=REGAPI_SUCCESS
            * typ souboru je registrovan
            * nyni nactu defaultni hodnotu a porovnam s nazev App
            lcApp=SPACE(254)
            =API_RegQueryValueEx(m.liHKEY,""+CHR(0),REG_SZ,@m.lcApp,254)
            liAsociateCVI=IIF(NullTermined(m.lcApp)==This.RegCVI_Path,1,0)
            =API_RegCloseKey(m.liHKEY)

            IF m.liAsociateCVI=0 AND API_RegOpenKeyEx(HKEY_CLASSES_ROOT, ".cvi"+"\OpenWithList\Coverage.Profiler"+CHR(0), @m.liHKEY)=REGAPI_SUCCESS
               m.liAsociateCVI=1
               =API_RegCloseKey(m.liHKEY)
            ENDIF
         ENDIF
      ELSE
         =API_RegCloseKey(m.liHKEY)
      ENDIF

      * nyni to pekne uloz do vlastnosti
      This.LogDebug=CTOBIN(m.liLogDebug, "RS")
      This.RecentFile=CTOBIN(m.liRecentFile, "RS")
      This.RecentFileCount=CTOBIN(m.liRecentFileCount, "RS")
      This.MaxFileCount=CTOBIN(m.liMaxFileCount, "RS")
      This.MaxWindowCount=CTOBIN(m.liMaxWindowCount, "RS")
      This.ThreadPriority=VAL(NullTermined(m.lcThreadPriority))
      This.ThreadPriority=IIF(INLIST(This.ThreadPriority,;
                 THREAD_PRIORITY_LOWEST, THREAD_PRIORITY_BELOW_NORMAL, THREAD_PRIORITY_NORMAL,;
                 THREAD_PRIORITY_HIGHEST, THREAD_PRIORITY_ABOVE_NORMAL, THREAD_PRIORITY_TIME_CRITICAL,;
                 THREAD_PRIORITY_IDLE), This.ThreadPriority, THREAD_PRIORITY_NORMAL)
      This.SizeGrid=CTOBIN(m.liSizeGrid, "RS")
      This.FileSource=CTOBIN(m.liFileSource, "RS")
      STORE NullTermined(m.lcLanguage) TO This.NewLanguage, This.Language
      This.DefPathNew=NullTermined(m.lcDefPathNew)
      This.DefPathOpen=NullTermined(m.lcDefPathOpen)
      This.OutPut=CTOBIN(m.liOutPut, "RS")
      This.AsociateLOG=m.liAsociateLOG
      This.AsociateCVP=m.liAsociateCVP
      This.AsociateCVPX=m.liAsociateCVPX
      This.AsociateCVI=m.liAsociateCVI
      This.SaveFile_XXT500=CTOBIN(m.liSaveFile_XXT500, "RS")
      This.SaveFile_XXT505=CTOBIN(m.liSaveFile_XXT505, "RS")
      This.SaveFile_PackU=NullTermined(m.lcSaveFile_PackU)
      This.PackMinSize=VAL(NullTermined(m.lcPackMinSize))
      This.AnimatedIcon=CTOBIN(m.liAnimatedIcon, "RS")
      This.XXTool_1=CTOBIN(m.liXXTool_1, "RS")
      This.XXTool_2=CTOBIN(m.liXXTool_2, "RS")

      This.IntegrateIDE=CTOBIN(m.liIntegrateIDE, "RS")
      This.Loader=NullTermined(m.lcLoader)
   ENDPROC


   * ulozi nastaveni aplikace do registru
   PROCEDURE SaveOptions()
      LOCAL m.liHKEY, m.liOFlag
      STORE 0 TO m.liOFlag, m.liHKEY

      * uloz hodnoty do registry
      =API_RegCreateKeyEx(HKEY_CURRENT_USER, This.RegAPP_Path+"\Options"+CHR(0), "REG_SZ"+CHR(0), @m.liHKEY, @m.liOFlag)

      =API_RegSetValueEx(liHKEY, "LogDebug"+CHR(0), REG_DWORD, BINTOC(This.LogDebug, "RS"))
      =API_RegSetValueEx(liHKEY, "RecentFile"+CHR(0), REG_DWORD, BINTOC(This.RecentFile, "RS"))
      =API_RegSetValueEx(liHKEY, "RecentFileCount"+CHR(0), REG_DWORD, BINTOC(This.RecentFileCount, "RS"))
      =API_RegSetValueEx(liHKEY, "MaxFileCount"+CHR(0), REG_DWORD, BINTOC(This.MaxFileCount, "RS"))
      =API_RegSetValueEx(liHKEY, "MaxWindowCount"+CHR(0), REG_DWORD, BINTOC(This.MaxWindowCount, "RS"))
      =API_RegSetValueEx(liHKEY, "ThreadPriority"+CHR(0), REG_SZ, STR(This.ThreadPriority, 3))
      =API_RegSetValueEx(liHKEY, "Language"+CHR(0), REG_SZ, This.NewLanguage+CHR(0))
      =API_RegSetValueEx(liHKEY, "SizeGrid"+CHR(0), REG_DWORD, BINTOC(This.SizeGrid, "RS"))
      =API_RegSetValueEx(liHKEY, "FileSource"+CHR(0), REG_DWORD, BINTOC(This.FileSource, "RS"))
      =API_RegSetValueEx(liHKEY, "DefPathNew"+CHR(0), REG_SZ, This.DefPathNew+CHR(0))
      =API_RegSetValueEx(liHKEY, "DefPathOpen"+CHR(0), REG_SZ, This.DefPathOpen+CHR(0))
      =API_RegSetValueEx(liHKEY, "OutPut"+CHR(0), REG_DWORD, BINTOC(This.OutPut, "RS"))
      =API_RegSetValueEx(liHKEY, "SaveFile_XXT500"+CHR(0), REG_DWORD, BINTOC(This.SaveFile_XXT500, "RS"))
      =API_RegSetValueEx(liHKEY, "SaveFile_XXT505"+CHR(0), REG_DWORD, BINTOC(This.SaveFile_XXT505, "RS"))
      =API_RegSetValueEx(liHKEY, "SaveFile_PackU"+CHR(0), REG_SZ, This.SaveFile_PackU+CHR(0))
      =API_RegSetValueEx(liHKEY, "AnimatedIcon"+CHR(0), REG_DWORD, BINTOC(This.AnimatedIcon, "RS"))
      =API_RegSetValueEx(liHKEY, "XXTool_1"+CHR(0), REG_DWORD, BINTOC(This.XXTool_1, "RS"))
      =API_RegSetValueEx(liHKEY, "XXTool_2"+CHR(0), REG_DWORD, BINTOC(This.XXTool_2, "RS"))
      =API_RegSetValueEx(liHKEY, "PackMinSize"+CHR(0), REG_SZ, STR(This.PackMinSize, 5, 2))
      =API_RegSetValueEx(liHKEY, "IntegrateIDE"+CHR(0), REG_DWORD, BINTOC(This.IntegrateIDE, "RS"))
      =API_RegSetValueEx(liHKEY, "Loader"+CHR(0), REG_SZ, This.Loader+CHR(0))

      * priznak asociace souboru CVP a LOG se neukladaji, protoze pri nacteni
      * se divam primo na strom HKEY_CLASSES_ROOT
      =API_RegCloseKey(m.liHKEY)
   ENDPROC


   * nacte seznam naposled editovanych souboru z registru
   PROCEDURE RestoreRecentFiles()

      LOCAL m.liHKEY, m.liErr, m.lcValue, m.liType, m.lcData, m.liIndex, m.lii
      STORE 0 TO m.liHKEY, m.liIndex

      IF API_RegOpenKeyEx(HKEY_CURRENT_USER, This.RegAPP_Path+"\RecentFiles"+CHR(0), @m.liHKEY)=REGAPI_SUCCESS

         DO WHILE .T.
            STORE SPACE(254)+CHR(0) TO m.lcValue, m.lcData
            m.liType=0

            * nacti prvni hodnotu
            m.liErr=API_RegEnumValue(m.liHKEY, m.liIndex, @m.lcValue, @m.liType, @m.lcData)
            IF m.liErr=REGAPI_NO_MORE_ITEMS && pokud tam jiz nic neni
               EXIT && pak ukonci smycku
            ENDIF
            
            m.lcData=NullTermined(m.lcData)
            This.iRecentFiles=m.liIndex+1 && zapis si posledni index
            DIME This.aRecentFiles(This.iRecentFiles, 2) && predimenzuj matici
            This.aRecentFiles(This.iRecentFiles, 1)=m.lcData

            m.lii=AT("\\", m.lcData) && nejdriv hledej \\ lomitka (UNC)
            m.lii=IIF(m.lii=0, AT("\", m.lcData), m.lii+1)
            This.aRecentFiles(This.iRecentFiles, 2)=GetShortText_MidleText(m.lcData, 35, m.lii, LEN(m.lcData)-RAT("\", m.lcData)+1, CHR(133)) && toto se zobrazi v popupu
            
            m.liIndex=m.liIndex+1 && inkremetuj citac
         ENDDO

         =API_RegCloseKey(m.liHKEY)
      ENDIF
   ENDPROC


   * ulozi seznam naposled editovanych souboru do registru
   PROCEDURE SaveRecentFiles()
      LOCAL m.liHKEY, m.liOFlag, m.lii
      STORE 0 TO m.liOFlag, m.liHKEY

      * otevri klic k aplikaci
      =API_RegCreateKeyEx(HKEY_CURRENT_USER, This.RegAPP_Path+CHR(0), "REG_SZ"+CHR(0), @m.liHKEY, @m.liOFlag)
      =API_RegDeleteKey(m.liHKEY, "RecentFiles"+CHR(0)) && smaz seznam 
      =API_RegCloseKey(m.liHKEY) && uzavri klic
      
      * nyni ho znovu kompletne vytvor
      =API_RegCreateKeyEx(HKEY_CURRENT_USER, This.RegAPP_Path+"\RecentFiles"+CHR(0), "REG_SZ"+CHR(0), @m.liHKEY, @m.liOFlag)
      FOR m.lii=1 TO This.iRecentFiles
          =API_RegSetValueEx(m.liHKEY, "File"+LTRIM(STR(m.lii, 11))+CHR(0), REG_SZ, This.aRecentFiles(m.lii, 1)+CHR(0))
      NEXT
      =API_RegCloseKey(m.liHKEY)
   ENDPROC


   * nacte seznam naposled hledanych hodnot
   PROCEDURE RestoreFindValues()

      LOCAL m.liHKEY, m.liErr, m.lcValue, m.liType, m.lcData, m.liIndex
      STORE 0 TO m.liHKEY, m.liIndex

      IF API_RegOpenKeyEx(HKEY_CURRENT_USER, This.RegAPP_Path+"\FindValues"+CHR(0), @m.liHKEY)=REGAPI_SUCCESS

         DO WHILE .T.
            STORE SPACE(254)+CHR(0) TO m.lcValue, m.lcData
            m.liType=0

            * nacti prvni hodnotu
            m.liErr=API_RegEnumValue(m.liHKEY, m.liIndex, @m.lcValue, @m.liType, @m.lcData)
            IF m.liErr=REGAPI_NO_MORE_ITEMS && pokud tam jiz nic neni
               EXIT && pak ukonci smycku
            ENDIF

            m.lcData=NullTermined(m.lcData)
            This.iFindValues=m.liIndex+1 && zapis si posledni index
            DIME This.aFindValues(This.iFindValues) && predimenzuj matici
            This.aFindValues(This.iFindValues)=m.lcData
            
            m.liIndex=m.liIndex+1 && inkremetuj citac
         ENDDO

         =API_RegCloseKey(m.liHKEY)
      ENDIF
   ENDPROC


   * ulozi seznam naposled hledanych hodnot
   PROCEDURE SaveFindValues()
      LOCAL m.liHKEY, m.liOFlag, m.lii
      STORE 0 TO m.liOFlag, m.liHKEY

      * otevri klic k aplikaci
      =API_RegCreateKeyEx(HKEY_CURRENT_USER, This.RegAPP_Path+CHR(0), "REG_SZ"+CHR(0), @m.liHKEY, @m.liOFlag)
      =API_RegDeleteKey(m.liHKEY, "FindValues"+CHR(0)) && smaz seznam 
      =API_RegCloseKey(m.liHKEY) && uzavri klic
      
      * nyni ho znovu kompletne vytvor
      =API_RegCreateKeyEx(HKEY_CURRENT_USER, This.RegAPP_Path+"\FindValues"+CHR(0), "REG_SZ"+CHR(0), @m.liHKEY, @m.liOFlag)
      FOR m.lii=1 TO This.iFindValues
          =API_RegSetValueEx(m.liHKEY, "Value"+LTRIM(STR(m.lii, 11))+CHR(0), REG_SZ, This.aFindValues(m.lii)+CHR(0))
      NEXT
      =API_RegCloseKey(m.liHKEY)
   ENDPROC


   * Nacte cesty k enginum Reports Engines
   PROCEDURE RestoreEFRX()

      LOCAL m.liHKEY, m.lcValue, m.liType, m.lii, m.loEngine
      LOCAL ARRAY m.laEngines(1)
      STORE 0 TO m.liHKEY

      IF API_RegOpenKeyEx(HKEY_CURRENT_USER, This.RegAPP_Path+"\EFRX"+CHR(0), @m.liHKEY)=REGAPI_SUCCESS
         FOR m.lii=1 TO m.XXEFRX.GetEnginesList(@m.laEngines)
             m.loEngine=m.XXEFRX.GetEngine(m.laEngines(m.lii, 1))

             IF ISNULL(m.loEngine)
                LOOP
             ENDIF

             STORE SPACE(254) TO m.lcValue
             =API_RegQueryValueEx(m.liHKEY, m.laEngines(m.lii,1)+CHR(0), REG_SZ, @m.lcValue, 254)
             m.loEngine.EPath=NullTermined(m.lcValue)
             m.loEngine.EPath=IIF(AT("\\", m.loEngine.EPath)>0 OR SUBST(m.loEngine.EPath, 2, 1)=":", m.loEngine.EPath, m.pcCommandLine+SUBS(m.loEngine.EPath, 2))

*!*	IF AT("..\..\",loEngine.EPath)>0
*!*	         =This.OPT.Add(IIF(EMPTY(This.Modul) OR !LEFT(This.Modul,7)=="XXF000_",.NULL.,EVAL("XX_SrvSeznam.CVPFiles."+THis.Modul)),;
*!*	                       "Mismatch in report engine folder"+CRLF+;
*!*	                       CHR(9)+"Saved value: "+lcValue+CRLF+;
*!*	                       CHR(9)+"Fixed value:"+loEngine.EPath)
*!*	ENDIF

             IF m.laEngines(m.lii,1)=="EREPORTS"
                STORE SPACE(254) TO m.lcValue
                =API_RegQueryValueEx(m.liHKEY,m.laEngines(m.lii, 1)+"_Key"+CHR(0), REG_SZ, @m.lcValue, 254)
                m.loEngine.Key=NullTermined(m.lcValue)
             ENDIF
         NEXT
         =API_RegCloseKey(m.liHKEY)
      ENDIF
   ENDPROC


   * ulozi cesty k enginum Reports Engines
   PROCEDURE SaveEFRX()
      LOCAL m.liHKEY, m.liOFlag, m.lii, m.loEngine, m.lcValue
      LOCAL ARRAY m.laEngines(1)
      STORE 0 TO m.liOFlag, m.liHKEY

      =API_RegCreateKeyEx(HKEY_CURRENT_USER, This.RegAPP_Path+"\EFRX"+CHR(0), "REG_SZ"+CHR(0), @m.liHKEY, @m.liOFlag)
      FOR m.lii=1 TO m.XXEFRX.GetEnginesList(@m.laEngines)
          m.loEngine=m.XXEFRX.GetEngine(m.laEngines(m.lii, 1))

          IF ISNULL(m.loEngine)
             LOOP
          ENDIF

          m.lcValue=RelativePathFromTo(m.pcCommandLine, FILE_ATTRIBUTE_DIRECTORY, m.loEngine.EPath, FILE_ATTRIBUTE_DIRECTORY)
          =API_RegSetValueEx(m.liHKEY, m.laEngines(m.lii, 1)+CHR(0), REG_SZ, m.lcValue+CHR(0))
*!*IF AT("..\..\",lcValue)>0
*!*         MESSAGEBOX("Mismatch in report engine folder"+CRLF+;
*!*                       CHR(9)+"From: "+pcCommandLine+CRLF+;
*!*                       CHR(9)+"Origin value: "+loEngine.EPath+CRLF+;
*!*                       CHR(9)+"Fixed value:"+lcValue)
*!*LOCAL lcOut,liErr
*!*lcOut=SPACE(254)+CHR(0)
*!*lcTo=loEngine.EPath+CHR(0)
*!*lcFrom=pcCommandLine+CHR(0)
*!*liErr=PathRelativePathTo(@lcOut,@lcFrom,FILE_ATTRIBUTE_DIRECTORY,@lcTo,FILE_ATTRIBUTE_DIRECTORY)
*!*MESSAGEBOX(STR(lierr)+" : "+STR(getlasterror()))
*!*ENDIF

      NEXT
      =API_RegCloseKey(m.liHKEY)
   ENDPROC


   * nacte pozice oken
   PROCEDURE RestoreWindPosition()

      LOCAL m.liHKEY, m.liErr, m.lcValue, m.liType, m.lcData, m.loObj, m.liRet
      STORE 0 TO m.liHKEY, m.liIndex

      IF API_RegOpenKeyEx(HKEY_CURRENT_USER, This.RegAPP_Path+CHR(0), @m.liHKEY)=REGAPI_SUCCESS

         FOR m.lii=1 TO This.Windows.ControlCount
             m.loObj=This.Windows.Controls(m.lii)
             m.lcData=SPACE(24) && napln buffer
             * nacti hodnoty z registry
             m.liRet=API_RegQueryValueEx(m.liHKEY, m.loObj.Name+CHR(0), REG_BINARY, @m.lcData, 24)
             IF m.liRet=REGAPI_SUCCESS
                m.loObj.Left=CTOBIN(LEFT(m.lcData, 4), "RS")
                m.loObj.Top=CTOBIN(SUBST(m.lcData, 5, 4), "RS")
                m.loObj.Width=CTOBIN(SUBST(m.lcData, 9, 4), "RS")
                m.loObj.Height=CTOBIN(SUBST(m.lcData, 13, 4), "RS")
                IF UPPER(m.loObj.XBaseClass)=="FORM"
                   m.loObj.WindowState=CTOBIN(SUBST(m.lcData, 17, 4), "RS")
                   m.loObj.WindowState=IIF(INLIST(m.loObj.WindowState, 0, 1, 2) ,m.loObj.WindowState, 0)
                   m.loObj.Dockable=CTOBIN(RIGHT(m.lcData, 4), "RS")
                   m.loObj.Dockable=IIF(INLIST(m.loObj.Dockable, 0, 1, 2), m.loObj.Dockable, 1)
                ELSE
                   m.loObj.DockPosition=CTOBIN(SUBST(m.lcData, 18, 4), "RS")
                   m.loObj.DockPosition=IIF(INLIST(m.loObj.DockPosition, -1, 0, 1, 2, 3), m.loObj.DockPosition, -1)
                ENDIF
                m.loObj.AutoCenter=.F.
             ELSE
                m.loObj.AutoCenter=.T.
             ENDIF
         NEXT

         =API_RegCloseKey(m.liHKEY)
      ENDIF
   ENDPROC


   * ulozi pozice oken
   PROCEDURE SaveWindPosition()
      LOCAL m.liHKEY, m.liOFlag, m.lii, m.loObj
      STORE 0 TO m.liOFlag, m.liHKEY

      * nyni ho znovu kompletne vytvor
      =API_RegCreateKeyEx(HKEY_CURRENT_USER, This.RegAPP_Path+CHR(0), "REG_SZ"+CHR(0), @m.liHKEY, @m.liOFlag)

      FOR m.lii=1 TO This.Windows.ControlCount
          m.loObj=This.Windows.Controls(m.lii)
          =API_RegSetValueEx(m.liHKEY, m.loObj.Name+CHR(0), REG_BINARY,;
               BINTOC(m.loObj.Left, "RS")+BINTOC(m.loObj.Top, "RS")+BINTOC(m.loObj.Width, "RS")+BINTOC(m.loObj.Height, "RS")+;
               IIF(UPPER(m.loObj.XBaseClass)=="FORM", BINTOC(m.loObj.WindowState, "RS")+BINTOC(m.loObj.Dockable, "RS"), BINTOC(m.loObj.DockPosition, "RS")+BINTOC(0, "RS")))
      NEXT
      =API_RegCloseKey(m.liHKEY)
   ENDPROC


   * nacte nastaveni pakovacich programu z ini souboru
   PROCEDURE RestorePackUtils()

      * nejdriv otestuj zda ini souboru existuje
      * pokud ne, apk ho zaloz a defaultne bude cestina
      LOCAL m.liCount, m.lii, m.lcFile, m.lcPU, m.lcPom, m.lcSection, m.lcKey, m.llChange
      LOCAL ARRAY m.laPom(1)

      m.liCount=0 && nastav pocet zaznamu
      m.lcSection="PACKUTILS"+IIF(m.CVP_PLATFORM=64, "64", "")

      m.lcFile=This.cAPPData+"CVP"+This.cVersion+".INI"
      IF FILE(m.lcFile)
         m.liCount=GetINIInt(m.lcSection, "Count", 0, m.lcFile)

         FOR m.lii=1 TO m.liCount
             m.lcKey="Packutils"+LTRIM(STR(m.lii, 11))
             m.lcPU=GetINIString(m.lcSection, m.lcKey, "NULL", 253, m.lcFile)

             m.lcPU=m.lcPU+IIF(RIGHT(m.lcPU, 1)#",", ",", "")
             IF m.lcPU=="NULL" OR ALINES(m.laPom, m.lcPU, 0, ",")=0
                * pokud tam zaznam chybi (tedy jakakoliv cast)
                m.liCount=m.liCount-1 && pak dekrementuj citac
                LOOP && skoc na dalsi
             ENDIF

             * nyni uprav relativni cesty na pevne
             m.laPom(2)=API_ExpandEnvironmentStrings(m.laPom(2)) && rozbal cestu
             m.laPom(2)=IIF(LEFT(m.laPom(2), 1)="\", ExtractRootFromFile(m.pcCommandLine)+m.laPom(2), m.laPom(2))
             m.lcPom=m.laPom(2)+CHR(0)
             m.laPom(2)=IIF(cvp_PathIsRelative(@m.lcPom)=0, m.laPom(2), m.pcCommandLine+m.laPom(2))

             m.laPom(3)=API_ExpandEnvironmentStrings(m.laPom(3)) && rozbal cestu
             m.laPom(3)=IIF(LEFT(m.laPom(3), 1)="\", ExtractRootFromFile(m.pcCommandLine)+m.laPom(3), m.laPom(3))
             m.lcPom=m.laPom(3)+CHR(0)
             m.laPom(3)=IIF(cvp_PathIsRelative(@m.lcPom)=0, m.laPom(3), m.pcCommandLine+m.laPom(3))

             m.laPom(4)=API_ExpandEnvironmentStrings(m.laPom(4)) && rozbal cestu
             m.laPom(4)=IIF(LEFT(m.laPom(4), 1)="\", ExtractRootFromFile(m.pcCommandLine)+m.laPom(4), m.laPom(4))
             m.lcPom=m.laPom(4)+CHR(0)
             m.laPom(4)=IIF(cvp_PathIsRelative(@m.lcPom)=0, m.laPom(4), m.pcCommandLine+m.laPom(4))
             
             STORE This.iPackUtils+1 TO This.iPackUtils && inkrementuj 1
             DIME This.aPackUtils(This.iPackUtils, 2) && predimenzuj matici
             This.aPackUtils(This.iPackUtils, 1)=m.laPom(1)
             This.aPackUtils(This.iPackUtils, 2)=CREATEOBJECT("_PackUtil_Helper")
             This.aPackUtils(This.iPackUtils, 2).Name=m.laPom(1) && Nazev pakovaci utility (kod)
             This.aPackUtils(This.iPackUtils, 2).C_File=m.laPom(2) &&  pakovaci cast
             This.aPackUtils(This.iPackUtils, 2).D_File=m.laPom(3) &&  dekompresni cast
             This.aPackUtils(This.iPackUtils, 2).VFP=m.laPom(4) &&  VFP plug-in
         NEXT
      ENDIF

      IF m.liCount=0 && pokud v INI souboru nic neni
         * nebo to selhalo, pak nastav natvrdo cestinu
         =WriteINIString("PACKUTILS", "PackUtils1", "BIX,bix.exe,bix.exe,bix.fxp,", m.lcFile) && zakladni sekce
         
         This.iPackUtils=1 && nastav 1
         This.aPackUtils(1, 1)="BIX"
         This.aPackUtils(1, 2)=CREATEOBJECT("_PackUtils")
         This.aPackUtils(1, 2).Name="BIX" && Kod pakovaci utility
         This.aPackUtils(1, 2).C_File=m.pcCommandLine+"bix.exe" &&  pakovaci cast
         This.aPackUtils(1, 2).D_File=m.pcCommandLine+"bix.exe" &&  dekompresni cast
         This.aPackUtils(1, 2).VFP=m.pcCommandLine+"bix.fxp" &&  VFP plug-in
      ENDIF

   ENDPROC


   * nacte nastaveni lokalizace z ini souboru
   PROCEDURE RestoreLanguage()
      * nejdriv otestuj zda ini souboru existuje
      * pokud ne, apk ho zaloz a defaultne bude cestina
      LOCAL m.liCount, m.lii, m.lcFile, m.lcSec, m.lcCollate, m.lcCaption, m.lcHelp, m.lcLibrary,;
            m.liHKEY, m.liOFlag, m.llNew, m.lcLanguage, m.lcPom

      m.liCount=0 && nastav pocet zaznamu
      m.lcFile=This.cAPPData+"CVP"+This.cVersion+".INI"
      IF FILE(m.lcFile)
         m.liCount=GetINIInt("LANGUAGE", "Count", 0, m.lcFile)
         FOR m.lii=1 TO m.liCount

             m.lcSec=GetINIString("LANGUAGE", "Language"+LTRIM(STR(m.lii, 11)), "NULL", 253, m.lcFile)
             IF m.lcSec=="NULL" && pokud tam zaznam chybi
                m.liCount=m.liCount-1 && pak dekrementuj citac
                LOOP && skoc na dalsi
             ENDIF

             m.lcCollate=ALLT(GetINIString(m.lcSec, "Collate", "NULL", 253, m.lcFile))
             m.lcCaption=ALLT(GetINIString(m.lcSec, "Caption", "NULL", 253, m.lcFile))
             m.lcHelp=ALLT(GetINIString(m.lcSec, "Help", "NULL", 253, m.lcFile))
             m.lcLibrary=ALLT(GetINIString(m.lcSec, "Library", "NULL", 253, m.lcFile))

             m.lcHelp=API_ExpandEnvironmentStrings(m.lcHelp) && rozbal cestu
             m.lcLibrary=API_ExpandEnvironmentStrings(m.lcLibrary) && rozbal cestu

             * nyni uprav relativni cesty na pevne             
             m.lcHelp=IIF(LEFT(m.lcHelp, 1)="\", ExtractRootFromFile(m.pcCommandLine)+m.lcHelp, m.lcHelp)
             m.lcLibrary=IIF(LEFT(m.lcLibrary, 1)="\", ExtractRootFromFile(m.pcCommandLine)+m.lcHelp, m.lcLibrary)
 
             m.lcPom=m.lcHelp+CHR(0)
             m.lcHelp=IIF(cvp_PathIsRelative(@m.lcPom)=0, m.lcHelp, m.pcCommandLine+m.lcHelp)
             m.lcPom=m.lcLibrary+CHR(0)
             m.lcLibrary=IIF(cvp_PathIsRelative(@m.lcPom)=0, m.lcLibrary, m.pcCommandLine+m.lcLibrary)

             IF m.lcCollate=="NULL" OR m.lcLibrary=="NULL"
                * pokud tam zaznam chybi (tedy jakakoliv cast)
                m.liCount=m.liCount-1 && pak dekrementuj citac
                LOOP && skoc na dalsi
             ENDIF

             m.lcCaption=IIF(m.lcCaption=="NULL", UPPER(LEFT(m.lcSec, 1))+LOWER(SUBS(m.lcSec, 2)), m.lcCaption)

             STORE This.iLanguage+1 TO This.iLanguage && nastav 1
             DIME This.aLanguages(This.iLanguage, 2) && predimenzuj matici
             This.aLanguages(This.iLanguage, 1)=m.lcSec
             This.aLanguages(This.iLanguage, 2)=CREATEOBJECT("_Language")
             This.aLanguages(This.iLanguage, 2).Collate=m.lcCollate && Collate (trideni)
             This.aLanguages(This.iLanguage, 2).Caption=m.lcCaption && popis jazyka
             This.aLanguages(This.iLanguage, 2).Library=m.lcLibrary && kompletni knihovna
             This.aLanguages(This.iLanguage, 2).Help=m.lcHelp && help
             * otestuj, zda soubory exestuji a pokud ne, pak je najdi
             This.aLanguages(This.iLanguage, 2).TestFile(1)
             This.aLanguages(This.iLanguage, 2).TestFile(2)
         NEXT
      ENDIF

      IF m.liCount=0 && pokud v INI souboru nic neni
         * nebo to selhalo, pak nastav natvrdo cestinu
         =WriteINIString("LANGUAGE", "Language2", "ENGLISH", m.lcFile) && zakladni sekce
         =WriteINIString("ENGLISH", "Collate", "ENGLISH", m.lcFile) && Collate (trideni)
         =WriteINIString("ENGLISH", "Caption", "English", m.lcFile) && popis jazyka
         =WriteINIString("ENGLISH", "Library", "Lang\English\CVP.app", m.lcFile) && kompletni knihovna
         =WriteINIString("ENGLISH", "Help", "Lang\English\cvp.hlp",m .lcFile) && help

         This.iLanguage=1 && nastav 1
         This.aLanguages(1, 1)="ENGLISH"
         This.aLanguages(1, 2)=CREATEOBJECT("_Language")
         This.aLanguages(1, 2).Collate="ENGLISH" && Collate (trideni)
         This.aLanguages(1, 2).Caption="English" && popis jazyka
         This.aLanguages(1, 2).Library=m.pcCommandLine+"Lang\English\CVP.app" && kompletni knihovna
         This.aLanguages(1, 2).Help=m.pcCommandLine+"Lang\English\CVP.hlp" && help
      ENDIF

      STORE 0 TO m.liOFlag, m.liHKEY
      m.lcLanguage=PADR("ENGLISH", 254)+CHR(0)
      * nacti hodnoty z registry
      =API_RegCreateKeyEx(HKEY_CURRENT_USER, This.RegAPP_Path+"\Options"+CHR(0), "REG_SZ"+CHR(0), @m.liHKEY, @m.liOFlag)
      m.llNew=m.liOFlag=REG_CREATED_NEW_KEY
      IF !m.llNew
         * Typ jazyka
         =API_RegQueryValueEx(m.liHKEY, "Language"+CHR(0), REG_SZ, @m.lcLanguage, 254)
      ENDIF
      =API_RegCloseKey(m.liHKEY)
      * nyni to pekne uloz do vlastnosti
      STORE NullTermined(m.lcLanguage) TO This.NewLanguage, This.Language
   ENDPROC


   * pokusi se zavest lokalizovane soubory
   PROCEDURE LoadLocalize()
      LOCAL m.lcExact, m.lii, m.liErr, m.lcMsg, m.loRes

      m.lcExact=SET("EXACT") && puvodni nastaveni SET EXACT
      SET EXACT ON && nastav ON an plne porovnani
      m.lii=ASCAN(This.aLanguages, This.Language) && najdi jazyk
      IF m.lii=0 && pokud to selhalo
         m.lii=ASCAN(This.aLanguages, This.DefaultLanguage) && pak najdi CZECH
         IF m.lii=0 && pokud to selhalo
            SET EXACT &lcExact.
            RETURN Init_Language && pak se vrat
         ENDIF
         STORE This.DefaultLanguage TO This.Language
      ENDIF
      SET EXACT &lcExact.
      STORE ASUBS(This.aLanguages, m.lii, 1) TO m.lii, This.CurrentLanguageID

      * tak nyni jsem lokalizoval objekt
      m.liErr=This.Resources.LoadLibrary(This.aLanguages(m.lii, 2).Library, @m.lcMsg)
      IF m.liErr>Res_LoadLibrary_Failed
         This.CVPLocID=m.liErr
         This.Collate=This.aLanguages(m.lii, 2).Collate && nacti trideni
         This.Help=This.aLanguages(m.lii, 2).Help && nacti trideni
         loRes=This.Resources.GetResource(m.liErr)
         This.Resources.SetResource(m.liErr) && nastav vychozi jazykovou mutaci
         This.FontCharSet=m.loRes.FontCharSet
         * tady se zavola procedura v knihovne, ktera vyplni namapovani jazyku
         DO MapLanguage IN (This.aLanguages(m.lii, 2).Library) WITH This.aLanguages(m.lii, 2)
         RETURN ErrOK
      ENDIF

      IF m.liErr=Res_LoadLibrary_Full
         This.cAPPName=m.XX_Res.ReadStringEx(Main_msgMain)
         This.cNone=m.XX_Res.ReadStringEx(XXF000_valDtl_None)
      ENDIF

      =MESSAGEBOX(IIF(m.liErr=Res_LoadLibrary_Failed, m.lcMsg,;
                  IIF(m.liErr=Res_LoadLibrary_Full, STRTRAN(Main_msgCI_LL_Full, "%d", LTRIM(STR(m.liErr, 11))),;
                  STRTRAN(STRTRAN(Main_msgCI_LL_NotFile, "%d", LTRIM(STR(m.liErr, 11))), "%s", This.aLanguages(m.lii, 2).Library);
                  )), msgType1, "CVP")

      RETURN ErrOther
   ENDPROC


   * uvolni lokalizovane soubory
   PROCEDURE UnLoadLocalize()
      * tak nyni uvolni lokalizovane soubory
      =This.Resources.FreeLibrary(This.CVPLocID)
   ENDPROC


   * provede asociovani/deasociovani souboru
   PROCEDURE AsociateFile
      LPARAMETERS m.lcFile, m.liType
      * lcFile - Typ souboru
      * liType - Typ cinnosti (0 - deasociovat, 1 - asociovat)

      LOCAL m.liHKEY, m.lcApp, m.liOFlag, m.llKeyExist, m.llMain, m.liCount, m.llAsociate,;
            m.lcClass, m.liMaxSubKeyLen, m.liMaxClassLen, m.liOpenFlag, m.lcRegPath,;
            m.liValues, m.liMaxValueNameLen, m.liMaxValueLen, m.liSecurityDescriptor, m.lcDT, m.lcPom

      STORE 0 TO m.liHKEY, m.liOFlag

      m.llKeyExist=API_RegOpenKeyEx(HKEY_CLASSES_ROOT, "."+m.lcFile+CHR(0), @m.liHKEY)=REGAPI_SUCCESS
      m.lcRegPath=IIF(m.lcFile="cvp", This.RegCVP_Path, IIF(m.lcFile="cvpx", This.RegCVPX_Path, IIF(m.lcFile="cvi", This.RegCVI_Path, This.RegLOG_Path)))

      * nejdrive otestuj , zda to neni pouzivano jinym programem
      IF m.llKeyExist
         m.lcApp=SPACE(254)
         =API_RegQueryValueEx(m.liHKEY, ""+CHR(0), REG_SZ, @m.lcApp, 254)
         m.llMain=NullTermined(m.lcApp)==m.lcRegPath
         =API_RegCloseKey(m.liHKEY)
      ENDIF

      IF m.liType=AsociateFile_Create
         IF m.llKeyExist AND !m.llMain
            *  zaregistruj to jako dalsi aplikaci (vzdy)
            =API_RegCreateKeyEx(HKEY_CLASSES_ROOT, "."+m.lcFile+"\OpenWithList\Coverage.Profiler"+CHR(0), "REG_SZ"+CHR(0), @m.liHKEY, @m.liOFlag)
            =API_RegCloseKey(m.liHKEY)
         ELSE
            =API_RegCreateKeyEx(HKEY_CLASSES_ROOT, "."+m.lcFile+CHR(0), "REG_SZ"+CHR(0), @m.liHKEY, @m.liOFlag)
            =API_RegSetValueEx(m.liHKEY, ""+CHR(0), REG_SZ, m.lcRegPath+CHR(0))
            =API_RegCloseKey(m.liHKEY)
         ENDIF
         m.llAsociate=.T.
         m.lcPom=.NULL.
         =cvp_SHChangeNotify(SHCNE_ASSOCCHANGED, SHCNF_IDLIST, @m.lcPom, @m.lcPom) && zavolej obcerstveni systemu ???
      ELSE
         IF m.llKeyExist
            * Delete Key in OpenWithList
            =API_RegDeleteKey(HKEY_CLASSES_ROOT, "."+m.lcFile+"\OpenWithList\Coverage.Profiler"+CHR(0)) && smaz typ souboru

            m.liCount=0
            IF API_RegOpenKeyEx(HKEY_CLASSES_ROOT, "."+m.lcFile+"\OpenWithList"+CHR(0), @m.liHKEY)=REGAPI_SUCCESS
               * Check another application in key OpenWithList
               * If no, delete this OpenWithList key
               m.lcClass=SPACE(254)+CHR(0)
               STORE 0 TO m.liMaxSubKeyLen, m.liMaxClassLen, m.liOpenFlag,;
                          m.liValues, m.liMaxValueNameLen, m.liMaxValueLen, m.liSecurityDescriptor

               =API_RegQueryInfoKey(m.liHKEY, @m.lcClass, @m.liCount, @m.liMaxSubKeyLen, @m.liMaxClassLen,;
                                    @m.liValues ,@m.liMaxValueNameLen, @m.liMaxValueLen, @m.liSecurityDescriptor, @m.lcDT)

               =API_RegCloseKey(m.liHKEY)
            ENDIF

            IF m.llMain
               IF m.liCount=0 && Pokud v openlistu uz nic neni, pak jej smaz (openlist) a smaz i celou vetev
                  =API_RegDeleteKey(HKEY_CLASSES_ROOT, "."+m.lcFile+"\OpenWithList"+CHR(0))
                  =API_RegDeleteKey(HKEY_CLASSES_ROOT, "."+m.lcFile+CHR(0)) && smaz typ souboru
               ELSE
                  * Jinak otevri vetev a smaz tridu 
                  =API_RegCreateKeyEx(HKEY_CLASSES_ROOT, "."+m.lcFile+CHR(0), "REG_SZ"+CHR(0), @m.liHKEY, @m.liOFlag)
                  =API_RegSetValueEx(m.liHKEY, ""+CHR(0), REG_SZ, CHR(0))
                  =API_RegCloseKey(m.liHKEY)
               ENDIF
            ELSE
               IF m.liCount=0
                  =API_RegDeleteKey(HKEY_CLASSES_ROOT, "."+m.lcFile+"\OpenWithList"+CHR(0))
               ENDIF
            ENDIF

            =cvp_SHChangeNotify(SHCNE_ASSOCCHANGED, SHCNF_IDLIST, .NULL., .NULL.) && zavolej obcerstveni systemu ???
         ENDIF
      ENDIF
      RETURN m.llAsociate
   ENDPROC


   * provede zaregistrovani typu souboru Coverage.Profiler.CVPFile,
   * Coverage.Profiler.CVIFile a Coverage.Profiler.LOGFile
   PROCEDURE _RegisterAppFile
      LPARAMETERS m.lcRegPath, m.lcCaption, m.lcCommand, m.lcICO
      
      LOCAL m.liHKEY, m.liOFlag
      STORE 0 TO m.liHKEY, m.liOFlag
      
      =API_RegCreateKeyEx(HKEY_CLASSES_ROOT, m.lcRegPath+CHR(0), "REG_SZ"+CHR(0), @m.liHKEY, @m.liOFlag)
      * nastaveni zakladniho popisu
      =IIF(m.liOFlag=REG_CREATED_NEW_KEY, API_RegSetValueEx(m.liHKEY, ""+CHR(0), REG_SZ, m.lcCaption+CHR(0)), .T.)
      =API_RegCloseKey(m.liHKEY)


      =API_RegCreateKeyEx(HKEY_CLASSES_ROOT, m.lcRegPath+"\shell\open\command"+CHR(0), "REG_SZ"+CHR(0), @m.liHKEY, @m.liOFlag)
      * nastaveni hodnoty klice pro prikaz Open
      =IIF(m.liOFlag=REG_CREATED_NEW_KEY, API_RegSetValueEx(m.liHKEY, ""+CHR(0), REG_SZ, m.lcCommand+CHR(0)), .T.)
      =API_RegCloseKey(m.liHKEY)

      * vytvoreni klice pro ikonu
      =API_RegCreateKeyEx(HKEY_CLASSES_ROOT, m.lcRegPath+"\DefaultIcon"+CHR(0), "REG_SZ"+CHR(0), @m.liHKEY, @m.liOFlag)
      * nastaveni hodnoty klice pro ikonu
      =IIF(m.liOFlag=REG_CREATED_NEW_KEY, API_RegSetValueEx(m.liHKEY, ""+CHR(0), REG_SZ, m.lcICO+CHR(0)), .T.)
      =API_RegCloseKey(m.liHKEY)
   ENDPROC


   PROCEDURE RegisterAppFile
      LPARAMETERS m.llReWrite
      * llReWrite - priznak, zda se ma registrace prepsat

      =IIF(m.llReWrite, This.UnRegisterAppFile(), .T.) && pak je nejdriv smaz

      *******************************************
      * Registrace CVP souboru
      *******************************************
      This._RegisterAppFile(This.RegCVP_Path, "Coverage Profiler CVP File", m.pcCommandLine+"CVP.exe -c"+m.pcCommandLine+"config.fpw %1", m.pcCommandLine+"CVP.exe,0")

      *******************************************
      * Registrace CVPX souboru
      *******************************************
      This._RegisterAppFile(This.RegCVPX_Path, "Coverage Profiler CVPX File", m.pcCommandLine+"CVP.exe -c"+m.pcCommandLine+"config.fpw %1", m.pcCommandLine+"CVP.exe,0")

      *******************************************
      * Registrace CVI souboru
      *******************************************
      This._RegisterAppFile(This.RegCVI_Path, "Coverage Profiler CVI (Index) File", m.pcCommandLine+"CVP.exe -c"+m.pcCommandLine+"config.fpw %1", m.pcCommandLine+"CVP.exe,0")

      *******************************************
      * Registrace LOG souboru
      *******************************************
      This._RegisterAppFile(This.RegLOG_Path, "Coverage Profiler LOG File", m.pcCommandLine+"CVP.exe -c"+m.pcCommandLine+"config.fpw %1", m.pcCommandLine+"CVP.exe,0")

      ************************************************
      This._RegisterAppFile("Applications\Coverage.Profiler", "Coverage Profiler", m.pcCommandLine+"CVP.exe -c"+m.pcCommandLine+"config.fpw %1", m.pcCommandLine+"CVP.exe,0")

   ENDPROC


   * zlikviduje prislusne klice souboru Coverage.Profiler.CVPFile a Coverage.Profiler.LOGFile
   PROCEDURE _UnRegisterAppFile
      LPARAMETERS m.lcRegPath

      =API_RegDeleteKey(HKEY_CLASSES_ROOT, m.lcRegPath+"\shell\open\command"+CHR(0))
      =API_RegDeleteKey(HKEY_CLASSES_ROOT, m.lcRegPath+"\shell\open"+CHR(0))
      =API_RegDeleteKey(HKEY_CLASSES_ROOT, m.lcRegPath+"\shell"+CHR(0))
      =API_RegDeleteKey(HKEY_CLASSES_ROOT, m.lcRegPath+"\DefaultIcon"+CHR(0))
      =API_RegDeleteKey(HKEY_CLASSES_ROOT, m.lcRegPath+CHR(0))

      RETURN
   ENDPROC


   PROCEDURE UnRegisterAppFile
      * nejdrive smaz informace o Coverage.Profiler.CVPFile.1 atd.

      This._UnRegisterAppFile(This.RegCVP_Path)

      * nejdrive smaz informace o Coverage.Profiler.CVPXFile.1 atd.
      This._UnRegisterAppFile(This.RegCVPX_Path)

      * pak smaz informace o Coverage.Profiler.CVIFile.1 atd.
      This._UnRegisterAppFile(This.RegCVI_Path)

      * pak smaz informace o Coverage.Profiler.LOGFile.1 atd.
      This._UnRegisterAppFile(This.RegLOG_Path)

      * pak smaz informace o Coverage.Profiler
      This._UnRegisterAppFile("Applications\Coverage.Profiler")

   ENDPROC


   * provede opravu nastaveni v registry
   PROCEDURE RepairRegistry()
      * provede opravu souboru aplikace
      This.RegisterAppFile(.T.)

      * nyni smaz extension souboru
      This.AsociateFile("cvp", AsociateFile_Delete)
      This.AsociateFile("cvpx", AsociateFile_Delete)
      This.AsociateFile("cvi", AsociateFile_Delete)
      This.AsociateFile("log", AsociateFile_Delete)

      * nyni zaregistruj extension souboru
      This.AsociateFile("cvp", AsociateFile_Create)
      This.AsociateFile("cvpx", AsociateFile_Create)
      This.AsociateFile("cvi", AsociateFile_Create)
      This.AsociateFile("log", AsociateFile_Create)

      This.SaveScreen() && uloz pozici a velikost okna
      This.SaveOptions() && uloz nastaveni aplikace
      This.SaveRecentFiles() && uloz seznam naposled otevrenych souboru
      This.SaveFindValues() && uloz seznam naposled otevrenych souboru
      This.SaveEFRX() && uloz seznam naposled otevrenych souboru
   ENDPROC


   * smaze informace v registry
   PROCEDURE DeleteRegistry()

      * smaze klice ....CVPFile a  ....LOGFile
      This.UnRegisterAppFile()

      * nakonec o samotne aplikaci
      This.DeleteRegistryApp()

      * provede vycisteni informaci o typech souboru .log a .cvp
      This.AsociateFile("cvp",AsociateFile_Delete)
      This.AsociateFile("cvpx",AsociateFile_Delete)
      This.AsociateFile("cvi",AsociateFile_Delete)
      This.AsociateFile("log",AsociateFile_Delete)

   ENDPROC


   * smaze informace v registry
   PROCEDURE DeleteRegistryApp()
      * toto se musi nahradit nacteni klicu
      * a jejich postupnou likvidaci
      =API_RegDeleteKey(HKEY_CURRENT_USER,This.RegAPP_Path+"\Options"+CHR(0))
      =API_RegDeleteKey(HKEY_CURRENT_USER,This.RegAPP_Path+"\RecentFiles"+CHR(0))
      =API_RegDeleteKey(HKEY_CURRENT_USER,This.RegAPP_Path+"\FindValues"+CHR(0))
      =API_RegDeleteKey(HKEY_CURRENT_USER,This.RegAPP_Path+"\EFRX"+CHR(0))
      =API_RegDeleteKey(HKEY_CURRENT_USER,This.RegAPP_Path+CHR(0))
   ENDPROC


*****************************************************************
  #IF ICON_ANIMATE=ICON_ANIMATE_BMP
   PROCEDURE SetSaveTimer()
      IF !This.lSaveTimer AND This.lGUIAllowed
         IF This.AnimatedIcon=XXF000_Icon_Animated
            =This.TestWorkFile("bmpSaveA")
            =CVP_StartAnimate(0, 250, 16, RGB(255, 0, 255), m.XXF010.hwnd, This.bmpSaveA, OBJTOCLIENT(m.XXF010.Save.Image, 2), OBJTOCLIENT(m.XXF010.Save.Image, 1))
         ELSE
            m.XXF010.Save.Image.Picture="resources\ico16\Crash.bmp"
         ENDIF
         This.lSaveTimer=.T.
      ENDIF
   ENDPROC


   PROCEDURE StopSaveTimer()
      IF This.lSaveTimer AND This.lGUIAllowed
         =CVP_StopAnimate(0)
         m.XXF010.Save.Image.Picture="resources\ico16\blank16.bmp"
         This.lSaveTimer=.F.
      ENDIF
   ENDPROC


   PROCEDURE SetPackTimer()
      IF !This.lPackTimer AND This.lGUIAllowed
         IF This.AnimatedIcon=XXF000_Icon_Animated
            =This.TestWorkFile("bmpPackA")
            =CVP_StartAnimate(1, 250, 16, RGB(255, 0, 255), m.XXF010.hwnd, This.bmpPackA, OBJTOCLIENT(m.XXF010.Pack.Image, 2), OBJTOCLIENT(m.XXF010.Pack.Image, 1))
         ELSE
            m.XXF010.Pack.Image.Picture="resources\ico16\Crash.bmp"
         ENDIF
         This.lPackTimer=.T.
      ENDIF
   ENDPROC


   PROCEDURE StopPackTimer()
      IF This.lPackTimer AND This.lGUIAllowed
         *=CVP_StopImgPack()
         =CVP_StopAnimate(1)
         m.XXF010.Pack.Image.Picture="resources\ico16\blank16.bmp"
         This.lPackTimer=.F.
      ENDIF
   ENDPROC


   PROCEDURE SetFindTimer()
      IF !This.lFindTimer AND This.lGUIAllowed
         IF This.AnimatedIcon=XXF000_Icon_Animated
            =This.TestWorkFile("bmpFindA")
            =This.TestWorkFile("bmpFindD")
            =CVP_StartAnimate(0, 100, 1, -1, m.XXF010.hwnd, This.bmpFindA, OBJTOCLIENT(m.XXF010.Save.Image, 2), OBJTOCLIENT(m.XXF010.Save.Image, 1))
            =CVP_StartAnimate(1, 100, -1, -1, m.XXF010.hwnd, This.bmpFindD, OBJTOCLIENT(m.XXF010.Pack.Image, 2), OBJTOCLIENT(m.XXF010.Pack.Image, 1))
         ELSE
            XXF010.Save.Image.Picture="resources\ico16\Crash.bmp"
            XXF010.Pack.Image.Picture="resources\ico16\Crash.bmp"
         ENDIF
         This.lFindTimer=.T.
      ENDIF
   ENDPROC


   PROCEDURE StopFindTimer()
      IF This.lFindTimer AND This.lGUIAllowed
         =CVP_StopAnimate(0)
         =CVP_StopAnimate(1)
         XXF010.Save.Image.Picture="resources\ico16\blank16.bmp"
         XXF010.Pack.Image.Picture="resources\ico16\blank16.bmp"
         This.lFindTimer=.F.
      ENDIF
   ENDPROC


   * otestuje, zda vykopirovany soubor existuje a pokud ne, pak jej vykopiruje 
   PROCEDURE TestWorkFile
      LPARAMETERS m.lcProp
      * lcProp - Nazev vlastnosti, ve ktere se nachazi nazev pracovniho souboru

      LOCAL m.lcFile, m.lcFileDST
      m.lcFileDST=EVAL("This."+m.lcProp)
      IF FILE(m.lcFileDST)
         RETURN .T.
      ENDIF

      DO CASE
         CASE m.lcProp=="bmpSaveA"
              m.lcFile=IIF(VERSION(2)=0, "","resources\ico16\")+"savea.bmp"
              
         CASE m.lcProp=="bmpPackA"
              m.lcFile=IIF(VERSION(2)=0, "","resources\ico16\")+"packa.bmp"

         CASE m.lcProp=="bmpFindA"
              m.lcFile=IIF(VERSION(2)=0, "","resources\ico16\")+"finda.bmp"

         CASE m.lcProp=="bmpFindD"
              m.lcFile=IIF(VERSION(2)=0, "","resources\ico16\")+"findd.bmp"

      ENDCASE
      COPY FILE (m.lcFile) TO (m.lcFileDST)
      m.XX_tmpFiles.Register(m.lcFileDST)

      RETURN .T.
   ENDPROC
  #ENDIF


  #IF ICON_ANIMATE=ICON_ANIMATE_GIF
   PROCEDURE SetSaveTimer()
      IF !This.lSaveTimer AND This.lGUIAllowed
         IF This.AnimatedIcon=XXF000_Icon_Animated
            XXF010.Save.Image.Picture="resources\ico16\savea.gif"
         ELSE
            XXF010.Save.Image.Picture="resources\ico16\Crash.bmp"
         ENDIF
         This.lSaveTimer=.T.
      ENDIF

   ENDPROC


   PROCEDURE StopSaveTimer()
      IF This.lSaveTimer AND This.lGUIAllowed
         XXF010.Save.Image.Picture="resources\ico16\blank16.bmp"
         This.lSaveTimer=.F.
      ENDIF
   ENDPROC


   PROCEDURE SetPackTimer()
      IF !This.lPackTimer AND This.lGUIAllowed
         IF This.AnimatedIcon=XXF000_Icon_Animated
            XXF010.Pack.Image.Picture="resources\ico16\packa.gif"
         ELSE
            XXF010.Pack.Image.Picture="resources\ico16\Crash.bmp"
         ENDIF
         This.lPackTimer=.T.
      ENDIF

   ENDPROC


   PROCEDURE StopPackTimer()
      IF This.lPackTimer AND This.lGUIAllowed
         XXF010.Pack.Image.Picture="resources\ico16\blank16.bmp"
         This.lPackTimer=.F.
      ENDIF
   ENDPROC


   PROCEDURE SetFindTimer()
      IF !This.lFindTimer AND This.lGUIAllowed
         IF This.AnimatedIcon=XXF000_Icon_Animated
            XXF010.Save.Image.Picture="resources\ico16\finda.gif"
            XXF010.Pack.Image.Picture="resources\ico16\findd.gif"
         ELSE
            XXF010.Save.Image.Picture="resources\ico16\Crash.bmp"
            XXF010.Pack.Image.Picture="resources\ico16\Crash.bmp"
         ENDIF
         This.lFindTimer=.T.
      ENDIF
   ENDPROC


   PROCEDURE StopFindTimer()
      IF This.lFindTimer AND This.lGUIAllowed
         XXF010.Save.Image.Picture="resources\ico16\blank16.bmp"
         XXF010.Pack.Image.Picture="resources\ico16\blank16.bmp"
         This.lFindTimer=.F.
      ENDIF
   ENDPROC
 #ENDIF


   * Prida hodnotu do seznamu hledanych hodnot
   PROCEDURE AddFindValue(m.lcValue)
      * lcValue - Hledana hodnota
      LOCAL m.lii
      FOR m.lii=1 TO This.iFindValues
          IF UPPER(This.aFindValues(m.lii))==UPPER(m.lcValue) && pokud je to hledana hodnota
             EXIT && pak ukonci smycku
          ENDIF
      NEXT
      IF m.lii>This.iFindValues && pokud hodnotu nenasel
         This.iFindValues=This.iFindValues+1 && Inkrementuj citac
         DIME This.aFindValues(This.iFindValues) && predimezuj matici
         This.aFindValues(This.iFindValues)=m.lcValue && Uloz hledanou hdonotu
      ENDIF
   ENDPROC


   * Odstrani hodnotu ze seznamu hledanych hodnot
   PROCEDURE RemoveFindValue(m.lcValue)
      * lcValue - Hledana hodnota
      LOCAL m.lii
      m.lcValue=UPPER(m.lcValue)
      FOR lii=1 TO This.iFindValues
          IF UPPER(This.aFindValues(m.lii))==m.lcValue && pokud je to hledana hodnota
             This.iFindValues=This.iFindValues-1 && Dekrementuj citac
             IF This.iFindValues>0
                =ADEL(This.aFindValues, m.lii) && smaz prislusnou bunku
                DIME This.aFindValues(This.iFindValues) && predimezuj matici
             ENDIF
             EXIT && pak ukonci smycku
          ENDIF
      NEXT
   ENDPROC


   * Kompletne smaze seznam hledanych hodnot
   PROCEDURE ClearlstFindValues()
      DIME This.aFindValues(1) && seznam hledanych hodnot
      This.aFindValues(1)=""
      This.iFindValues=0 && citac seznamu

      *A jeste projed vsechyn spustene moduly a vycisti je
      FOR lii=1 TO m.XX_SrvSeznam.CVPFiles.ControlCount
          IF m.XX_SrvSeznam.CVPFiles.Controls(lii).Name="XXF070_"
             =EVAL(m.XX_SrvSeznam.CVPFiles.Controls(m.lii).Name+".cboText.Requery()")
          ENDIF
      NEXT
   ENDPROC


   * Tisk reportu
   PROCEDURE Print(m.loReport)
      * loReport - Objekt reportu
      IF FILE(This.cAPPData+"CVP"+This.cVersion+".INI")
         LOCAL m.lcXXX
         m.lcXXX=GetINIString("SYSTEM", "CVPLogPrint", "NULL", 253, This.cAPPData+"CVP"+This.cVersion+".INI")
         IF !(EMPTY(m.lcXXX) OR m.lcXXX=="NULL")
            SET COVERAGE TO (m.lcXXX)
         ENDIF
         RELE m.lcXXX
      ENDIF

      This.Report=m.loReport
      LOCAL m.lcFile, m.lcAlias, m.lcAliasL, m.lcAliasB, m.loErr, m.llErr, m.lcAliasM, m.loModul
      * Vykopiruj report na pracovni cestu
      m.lcAlias=SYS(2015)
      m.lcAliasB=SYS(2015)
      m.lcAliasL=SYS(2015)

      STORE SYS(2023)+"\"+SYS(2015)+".frx" TO m.lcFile, m.loReport._File
      m.XX_tmpFiles.Register(m.lcFile)
      m.XX_tmpFiles.Register(FORCEEXT(m.lcFile, "frt"))

      m.loErr=.NULL. && vytvor objekt pro zachyceni chyby
      * Otevri lokalizovany report
      TRY
       DO OpenTable IN (This.aLanguages(This.CurrentLanguageID, 2).Library) WITH "USE "+m.loReport.Report+".frx ALIAS "+m.lcAliasL+" IN 0"
      CATCH TO m.loErr
      FINALLY
      ENDTRY

      m.loModul=This.GetModulObj()
      IF ISNULL(m.loErr)
         =This.OPT.Add(m.loModul, "Report layer is opened.")
      ELSE
         =This.OPT.Add(m.loModul, "Report layer is not opened!!!", .T.)
      ENDIF

      * Otevri zakladni report, pokud je to layout
      IF m.loReport.Layout
         TRY
          USE (pcCommandLine+m.loReport.Report+".frx") ALIAS (m.lcAliasB) IN 0
         CATCH TO m.loErr
         FINALLY
         ENDTRY
    
         IF ISNULL(m.loErr)
            =This.OPT.Add(m.loModul, "Report basic is opened.")
         ELSE
            =This.OPT.Add(m.loModul, "Report basic is not opened!!!", .T.)
         ENDIF

      ENDIF

      IF USED(m.lcAliasL) AND IIF(m.loReport.Layout, USED(m.lcAliasB),.T.)
         IF !m.loReport.Layout
            SELE (m.lcAliasL)
            TRY
             COPY TO (m.lcFile)
            CATCH TO m.loErr
            FINALLY
            ENDTRY
            
            USE

            IF ISNULL(m.loErr)
               =This.OPT.Add(m.loModul, "Report layout is copied as table.")
            ELSE
               =This.OPT.Add(m.loModul, "Report layout is not copied as table!!!", .T.)
            ENDIF

            IF !m.loErr.lError
               * Otevri kopii
               m.loReport._Alias=m.lcAlias
               TRY
                USE (m.lcFile) IN 0 ALIAS (m.lcAlias) SHARE AGAIN
               CATCH TO m.loErr
               FINALLY
               ENDTRY

               IF ISNULL(m.loErr)
                  =This.OPT.Add(m.loModul, "Report - basic(copy) is OK.")
               ELSE
                  =This.OPT.Add(m.loModul, "Report - basic(copy) is not OK!!!", .T.)
               ENDIF

            ENDIF
            m.llErr=NOT ISNULL(m.loErr)
         ELSE
            m.llErr=!LReport("L", m.lcAliasB, m.lcAliasL, m.lcFile, @m.lcAlias)
            m.loReport._Alias=m.lcAlias

            IF !m.llErr
               =This.OPT.Add(m.loModul, "Report basic and layer are merged.")
            ELSE
               =This.OPT.Add(m.loModul, "Report - basic(copy) are not merged!!!", .T.)
            ENDIF

            IF USED(m.lcAliasB)
               USE IN (m.lcAliasB)
            ENDIF
            IF USED(m.lcAliasL)
               USE IN (m.lcAliasL)
            ENDIF
            IF m.llErr AND !EMPTY(m.lcAlias) AND USED(m.lcAlias)
               USE IN (m.lcAlias)
            ENDIF
         ENDIF
         RELE m.loErr

         IF !m.llErr
            SELE (m.lcAlias)
            GO TOP

            * Pokud ma prebrat tuto vlastnost z reportu
            IF m.loReport.Orientation=_PP_Default
               m.loReport.Orientation=VAL(PEM_GetProperty(EXPR, "ORIENTATION"))
            ENDIF

            * Pokud ma prebrat tuto vlastnost z reportu
            IF m.loReport.Copies=_PP_Default
               m.loReport.Copies=VAL(PEM_GetProperty(EXPR, "COPIES"))
            ENDIF

            * Pokud ma prebrat tuto vlastnost z reportu
            IF m.loReport.Collate=_PP_Default
               m.loReport.Collate=VAL(PEM_GetProperty(EXPR, "COLLATE"))
            ENDIF
            USE

            IF m.loReport.Output=_PO_Dialog OR m.loReport.Output=_PO_None
               * Spust dialog
               =ShowPrintDlg(@m.loReport)
            ELSE
               This._Print(@m.loReport)
            ENDIF
         ENDIF

         * Kdyz to nekde selhalo, uzavri report/layout
         IF USED(m.lcAliasL)
            USE IN (m.lcAliasL)
         ENDIF
      ENDIF
      This.Report=.NULL.

      DELE FILE (m.lcFile)
      DELE FILE (FORCEEXT(m.lcFile, "frt"))

      XX_tmpFiles.UnRegister(m.lcFile)
      XX_tmpFiles.UnRegister(FORCEEXT(m.lcFile, "frt"))

      IF !(EMPTY(m.lcXXX) OR m.lcXXX=="NULL")
         SET COVERAGE TO
      ENDIF
   ENDPROC


   * Interni metoda pro tisk
   PROCEDURE _Print(m.loReport)
      * loReport - Objekt reportu
      LOCAL m.lcPom, m.lcPrinterName, m.lii, m.llFind, m.lcPomx, m.lcRange, m.loModul
      LOCAL ARRAY m.laPrinters(1)
      IF APRINTER(m.laPrinters)=0
         cvp__fpreset()
         RETURN
      ENDIF
      cvp__fpreset()

      m.lcRange=LTRIM(STR(m.loReport.StartPage, 20))+","+LTRIM(STR(m.loReport.EndPage, 20)) && rozmezi stranek pro tisk

      m.loErr=.NULL.
      * Otevri kopii
      TRY
       USE (m.loReport._File) IN 0 ALIAS (m.loReport._Alias) SHARE AGAIN
      CATCH TO m.loErr
      FINALLY
      ENDTRY

      m.loModul=This.GetModulObj()
      IF ISNULL(m.loErr)
         =This.OPT.Add(m.loModul, "Report merged is open.")
      ELSE
         =This.OPT.Add(m.loModul, "Report merged is not open!!!", .T.)
      ENDIF

      RELE m.loErr

      SELE (m.loReport._Alias)
      LOCATE FOR OBJTYPE=1 AND OBJCODE=53
      IF FOUND()
         m.lcPom=EXPR && nacti obsah pole prvni vety
         =PEM_WriteProperty(@m.lcPom, "ORIENTATION", LTRIM(STR(m.loReport.Orientation, 20)))  && zapis vlastnosti
         REPL WIDTH WITH IIF(m.loReport.Orientation=0, 82300, 116875)
         =PEM_WriteProperty(@m.lcPom, "COPIES", LTRIM(STR(m.loReport.Copies, 20)))      && zapis vlastnosti
         * pokud neni vice jak jedna kopie , pak potlac razeni kopii
         =PEM_WriteProperty(@m.lcPom,"COLLATE", LTRIM(STR(IIF(m.loReport.Copies<=1, 0, m.loReport.Collate), 20)))  && zapis vlastnosti
         REPL EXPR WITH m.lcPom, TAG WITH "", TAG2 WITH ""
      ENDIF

      SELE (m.loReport.Alias)
      DO CASE
         CASE m.loReport.Engine="VFP" AND m.loReport.Output=_PO_Preview
              LOCAL m.lcWindow, m.lcWindowName
              m.lcWindow="wndReport"+SYS(2015)
              m.lcWindowName="wndReportName"+SYS(2015)
              This.tmrc.Enabled=.T. && povol timer
              DEFINE WINDOW (m.lcWindow) FROM 0,0 TO 1,1 NOMDI NOMINIMIZE;
                                         NOZOOM NOGROW SYSTEM ;
                                         TITLE "Report " NAME (m.lcWindowName)

              WITH EVAL(m.lcWindowName)
              STORE .T. TO .ControlBox,.Closable
              .BorderStyle=3
              .BackColor=RGB(192,192,192)
              .Move(-SYSMETRIC(3),-SYSMETRIC(4),_Screen.Width,_Screen.Height - SYSMETRIC(9))
              ENDWITH

              REPORT FORM (m.loReport._File) PREVIEW WINDOW (m.lcWindow)
              cvp__fpreset()
              _Screen.Closable=.T.

              RELE WINDOW (m.lcWindow) && smaz okno
              RELE (m.lcWindowName) && smaz promennou

              This.tmrc.hwnd=0
              This.tmrc.Enabled=.F. && zazkaz timer
              This.tmrc.Caption="" && Titulek nahledu reportu
              USE IN (m.loReport._Alias) 

         CASE m.loReport.Engine="VFP" AND m.loReport.Output=_PO_Printer
              m.lcPrinterName=m.loReport.PrinterName && nazev tiskarny

              SET PRINTER TO NAME (m.lcPrinterName) && nastav tiskarnu
              cvp__fpreset()

              m.lcPom=EVAL(m.loReport._Alias+".EXPR") && nacti obsah pole prvni vety

              =PEM_WriteProperty(@m.lcPom, "DEVICE", m.lcPrinterName)  && zapis vlastnosti
              m.llFind=.F. && zrus priznak nalezu
              FOR m.lii=1 TO ALEN(m.laPrinters, 1)
                  IF m.lcPrinterName==m.laPrinters(m.lii, 1) && pokud je to tato tiskarna
                     m.llFind=.T. && nastav priznak nalezu
                     EXIT && pak ukonci hledani
                  ENDIF
              NEXT
              IF m.llFind
                 =PEM_WriteProperty(@m.lcPom, "OUTPUT", m.laPrinters(m.lii, 2))  && zapis vlastnosti 
              ENDIF

              * nacti pres PRTINFO() default source vybrane tiskarny
              * pak ho zapis do reportu
              m.lcPomX=LTRIM(STR(PRTINFO(7, m.lcPrinterName), 20))
              =PEM_WriteProperty(@m.lcPom, "DEFAULTSOURCE", m.lcPomX)  && zapis vlastnosti

              m.lcPomX=LTRIM(STR(PRTINFO(8, m.lcPrinterName), 20))
              =PEM_WriteProperty(@m.lcPom, "PRINTQUALITY", m.lcPomX)  && zapis vlastnosti

              m.lcPomX=LTRIM(STR(PRTINFO(9, m.lcPrinterName), 20))
              =PEM_WriteProperty(@m.lcPom, "COLOR", m.lcPomX)  && zapis vlastnosti

              m.lcPomX=LTRIM(STR(PRTINFO(10, m.lcPrinterName), 20))
              =PEM_WriteProperty(@m.lcPom, "DUPLEX", m.lcPomX)  && zapis vlastnosti

              m.lcPomX=LTRIM(STR(PRTINFO(11, m.lcPrinterName), 20))
              =PEM_WriteProperty(@m.lcPom, "YRESOLUTION", m.lcPomX)  && zapis vlastnosti

              m.lcPomX=LTRIM(STR(PRTINFO(12, m.lcPrinterName), 20))
              =PEM_WriteProperty(@m.lcPom, "TTOPTION", m.lcPomX)  && zapis vlastnosti

              SELECT (m.loReport._Alias)
              REPL EXPR WITH m.lcPom
              USE
              SELE (m.loReport.Alias)

              IF This.nErr=ErrOK
                 PRINTJOB  && tisk na urcitou tiskarnu
                 REPORT FORM (m.loReport._File) RANGE &lcRange. TO PRINTER NOCONSOLE 
                 ENDPRINTJOB
                 cvp__fpreset()
              ENDIF

              SET PRINTER TO && zrus tiskarnu
              cvp__fpreset()

         OTHERWISE
              * Ostatni enginy
              LOCAL m.lcOutFile, m.liErr, m.loPar
              m.loPar=m.loReport.CreateEFRXPar()
              IF USED(m.loReport._Alias) 
                 USE IN (m.loReport._Alias) 
              ELSE
                 =This.OPT.Add(m.loModul, "Internal cursor-report is not open!!!", .F.)
              ENDIF
 
              * Preview
              IF m.loReport.Output=_PO_Preview
*                 This.tmrc.Enabled=.T. && povol timer
                 m.liErr=m.XXEFRX.Preview(m.loReport.Engine, @m.loPar)
                 This.tmrc.Enabled=.F. && Zakaz timer
                 This.tmrc.hwnd=0
                 This.tmrc.Caption="" && Titulek nahledu reportu
              ENDIF

              * Print
              IF m.loReport.Output=_PO_Printer
                 liErr=m.XXEFRX.Print(m.loReport.Engine, @m.loPar)
              ENDIF

              * Export
              IF m.loReport.Output=_PO_Export
                 m.lcOutFile=ALLTRIM(m.loReport.File) && OREZ VSECHNY MEZERY
                 IF EMPTY(m.lcOutFile)
                    m.loReport.File=m.pcCommandLine+SYS(2015) && zpetne zapis cestu a nazev
                 ENDIF
                 m.liErr=m.XXEFRX.Export(m.loReport.Engine, m.loReport.PrinterName, @m.loPar)
              ENDIF

              m.loReport.Exported=m.loPar.Exported
              m.loReport.Printed=m.loPar.Printed
              RELE m.loPar
      ENDCASE
   ENDPROC


   PROCEDURE ReportPreviewResize(m.liSWidth, m.liSHeight)
      LOCAL m.lotmr
      IF PCOUNT()=0
         m.liSWidth=_Screen.Width
         m.liSHeight=_Screen.Height
      ENDIF
      m.lotmr=This.tmrc
      IF m.lotmr.hwnd>0 AND (m.lotmr.Height#m.liSHeight OR m.lotmr.Width#m.liSWidth)
         m.lotmr.Height=m.liSHeight
         m.lotmr.Width=m.liSWidth
         =cvp_MoveWindow(m.lotmr.HwndN, 0, 0, m.lotmr.Width, m.lotmr.Height, 1)
      ENDIF
   ENDPROC

   ADD OBJECT tmrc AS timer  && timer pro preview rezim
   tmrc.Hwnd=0
   tmrc.HwndN=0
   tmrc.Interval=250
   tmrc.Enabled=.F.
   tmrc.Caption="" && Titulek nahledu reportu

   PROCEDURE tmrc.Timer()
      LOCAL m.liIH, m.lcCaption, m.lcPom, m.lcEngine, m.loEngine, m.liPage
      * jde o prvni spusteni
      m.liIH=This.hwnd
      IF m.liIH=0
         m.liIH=CVP_WOnTopEx() && IH okna
         IF 'Report '#LEFT(CVP_WTitleEx(m.liIH), 7)
            * nejedna se o report
            RETURN
         ENDIF
         This.Hwnd=m.liIH
         This.HwndN=SYS(2327, m.liIH)
         =m.XX_ActSrv.SetFlag()
         =m.XX_ActSrv.GoSrv.SetEnab(ActEvent_Deactivate)
      ENDIF

      m.lcEngine=This.Parent.Report.Engine
      IF m.lcEngine=="VFP"
         m.liPage=_pageno
      ELSE
         m.loEngine=m.XXEFRX.GetEngine(m.lcEngine)
         
         IF !ISNULL(m.loEngine)
            m.liPage=IIF(m.lcEngine=="MERE" AND TYPE("m.loEngine.oForm.oReportEngine.nPageNumber")="N", m.loEngine.oForm.oReportEngine.nPageNumber,;
                     IIF(m.lcEngine=="XFRX" AND TYPE("m.loEngine.oForm.cntXFRX.nPageNo")="N", m.loEngine.oForm.cntXFRX.nPageNo, 0))
         ELSE
            m.liPage=0
         ENDIF
      ENDIF

      * vygeneruj popis
      m.lcCaption=This.Parent.Report.Caption+STRTRAN(m.XX_Res.ReadStringEx(_System_rptpageval),"%Page%",LTRIM(STR(m.liPage, 20)))
      IF SYS(2007, m.lcCaption)#SYS(2007, CVP_WTitleEx(m.liIH))
         =CVP_WSetTitleEx(m.liIH, m.lcCaption)
         STORE m.lcCaption TO This.Caption && Zapamatuj si titulek okna
         m.lcPom=SYS(1272, This.Parent)
      ENDIF
   ENDPROC


   PROCEDURE AddLostFile(m.lcFile, m.lcFullFile)
      LOCAL m.liHKEY, m.liOFlag, m.liIndex, m.liType, m.lcValue, m.lcData, m.llNew, m.llFound
      STORE 0 TO m.liOFlag, m.liHKEY

      =API_RegCreateKeyEx(HKEY_CURRENT_USER, This.RegAPP_Path+"\LostFiles\"+m.lcFile+CHR(0), "REG_SZ"+CHR(0), @m.liHKEY, @m.liOFlag)
      m.llNew=m.liOFlag=REG_CREATED_NEW_KEY
      m.llFound=.F.
      IF !m.llNew
         m.liIndex=0
         DO WHILE .T.
            STORE SPACE(254)+CHR(0) TO m.lcValue, m.lcData
            m.liType=0

            * nacti prvni hodnotu
            m.liErr=API_RegEnumValue(m.liHKEY, m.liIndex, @m.lcValue, @m.liType, @m.lcData)
            IF m.liErr=REGAPI_NO_MORE_ITEMS && pokud tam jiz nic neni
               EXIT && pak ukonci smycku
            ENDIF

            m.lcData=NullTermined(m.lcData)
            IF m.lcData==ALLTRIM(m.lcFullFile)
               m.llFound=.T.
               EXIT
            ENDIF

            m.liIndex=m.liIndex+1 && inkremetuj citac
         ENDDO
      ELSE
         m.liIndex=0 && inkremetuj citac
      ENDIF
      IF !m.llFound
         =API_RegSetValueEx(m.liHKEY, "File"+LTRIM(STR(m.liIndex+1, 11))+CHR(0), REG_SZ, ALLTRIM(m.lcFullFile)+CHR(0))
      ENDIF
      =API_RegCloseKey(m.liHKEY)
   ENDPROC
ENDDEFINE


************************************************************
* Report 
DEFINE CLASS _report AS CUSTOM
   NAme="_report"
   
   Alias="" && Hlavni alias reportu
   Report="" && Nazev reportu

   Printed=.F. && Priznak, zda byl report vytisten
   Exported=.F. && Priznak, zda byl report exportovan/ulozen
   Layout=.F. && Priznak ze zdrojovy report je pouze layout

   Lang=""

   StartPage=1
   EndPage=9999

   Copies=_PP_Default && 1       && pocet kopii
   Orientation=_PP_Default && 0  && orientace papiru
   Collate=_PP_Default && 0      && Styl trideni kopii

   Caption=SPACE(0)   && nadpis reportu

   Engine="VFP"
   Output=_PO_None && Typ vystupu
   PrinterName="" && Nazev tiskarny nebo typu exportu
   File="" && Nazev 
   
   _File="" && Pracovni soubor pro report
   _Alias=""


   SEPage="" && For XFRX
   SplitDocument=0 && Number of page to one document
   nLeftMargin=0 && in Pixels
   nTopMargin=0 && in Pixels

   cFor=""
   lSummary=.F.
   cScope=""
   cWhile=""
   lPlain=.F.
   nInitialRecord=0
   cHeadingText=""

   CodePage=CPCURRENT()

   * Enhanced properties PDF/Word
   Author=""
   Subject=""
   KeyWords=""
   Description=""
   
   Creator=""
   Producer=""
   
   Comments=""
   Category=""
   Manager=""
   Company=""
   
   OPassword=""
   UPassword=""
   wPassword="" && for write
  
   AutoOpen=.F.
   ToEmail=.F.
   Silent=.T.
   Progress=.F.

   ADD OBJECT PRV AS __cReport_PRV
   ADD OBJECT PDF AS __cReport_PDF
   ADD OBJECT WM AS __cReport_WM
   ADD OBJECT EMAIL AS __cReport_EMAIL
   

   PROCEDURE CreateEFRXPar() && Vytvori objekt parametru pro EFRX
      LOCAL m.loPar
      m.loPar=CREATEOBJECT("__cReport")

      m.loPar.TempDirectory=SYS(2023)+"\"
      m.loPar.Progress=This.Progress

      m.loPar.Lang=IIF(This.Lang="CZECH" OR This.Lang="SLOVAK", "csy",;
                   IIF(This.Lang="ENGLISH", "en",;
                   IIF(This.Lang="FRENCH", "fr", "en")))

      m.loPar.RFile=This._File
      m.loPar.OFile=ALLT(This.File)
      m.loPar.OFile=IIF(AT("\\", m.loPar.OFile)>0 OR AT(":", m.loPar.OFile)>0, "", m.pcCommandLine)+m.loPar.OFile
      m.loPar.Caption=This.Caption
      m.loPar.PrinterName=This.PrinterName

      m.loPar.AutoOpen=This.AutoOpen
      m.loPar.ToEmail=This.ToEmail
      m.loPar.Silent=This.Silent

      m.loPar.Author=This.Author
      m.loPar.Subject=This.Subject
      m.loPar.Title=This.Caption
      m.loPar.KeyWords=This.KeyWords
      m.loPar.Description=This.Description

      m.loPar.Creator=This.Creator
      m.loPar.Producer=This.Producer

      m.loPar.Comments=This.Comments
      m.loPar.Category=This.Category
      m.loPar.Manager=This.Manager
      m.loPar.Company=This.Company

      m.loPar.OPassword=This.OPassword
      m.loPar.UPassword=This.UPassword
      m.loPar.WPassword=This.WPassword
      
      m.loPar.PDF.CopyProps(This.PDF)
      m.loPar.PRV.CopyProps(This.PRV)
      m.loPar.WM.CopyProps(This.WM)
      m.loPar.EMAIL.CopyProps(This.EMAIL)

      m.loPar.cFor=This.cFor
      m.loPar.lSummary=This.lSummary
      m.loPar.cScope=This.cScope
      m.loPar.cWhile=This.cWhile
      m.loPar.lPlain=This.lPlain
      m.loPar.nInitialRecord=This.nInitialRecord
      m.loPar.cHeadingText=This.cHeadingText

      m.loPar.SPage=This.StartPage
      m.loPar.EPage=This.EndPage
      m.loPar.SEPage=This.SEPage
      m.loPar.SplitDocument=This.SplitDocument
      m.loPar.nLeftMargin=This.nLeftMargin
      m.loPar.nTopMargin=This.nTopMargin

      m.loPar.oCallBack=This

      RETURN m.loPar
   ENDPROC


   PROCEDURE EFRX_BeforePreview
      LPARAMETERS m.loHost, m.loForm
      * loHost - Odkaz na hostitelsky objekt nebo Engine
      * loForm - Odkaz na formular kde bude preview

      LOCAL m.lcEngine, m.loEngine
      m.lcEngine=This.Engine
      m.loEngine=XXEFRX.GetEngine(m.lcEngine)

      DO CASE
         CASE m.lcEngine=="MERE"
              m.loForm.BorderStyle=1
              m.loForm.Movable=.F.
              m.loForm.MaxButton=.F.
              m.loForm.MinButton=.F.
              m.loForm.Caption="Report "
              m.loForm.Move(-SYSMETRIC(3), -SYSMETRIC(4), _Screen.Width, _Screen.Height - SYSMETRIC(9))
              m.loForm.DataSessionID=1

         CASE m.lcEngine=="XFRX"
              m.loForm.Name="Report"+SYS(2015)
              m.loForm.Caption="Report "
              m.loForm.Move(-SYSMETRIC(3), -SYSMETRIC(4), _Screen.Width, _Screen.Height - SYSMETRIC(9))

         CASE m.lcEngine=="FRX2WORD"
              m.loForm.Name="Report"+SYS(2015)
              m.loForm.Caption="Report "
              m.loForm.Move(-SYSMETRIC(3), -SYSMETRIC(4), _Screen.Width, _Screen.Height - SYSMETRIC(9))

         CASE m.lcEngine=="FRX2ANY"
              m.loForm.BorderStyle=1
              m.loForm.Movable=.F.
              m.loForm.MaxButton=.F.
              m.loForm.MinButton=.F.
              m.loForm.Caption="Report "
              m.loForm.Move(-SYSMETRIC(3), -SYSMETRIC(4), _Screen.Width, _Screen.Height - SYSMETRIC(9))

      ENDCASE
   ENDPROC


   PROCEDURE EFRX_BeforeExport
      LPARAMETERS m.loHost
      * loHost - Odkaz na hostitelsky objekt nebo Engine
   ENDPROC


   PROCEDURE EFRX_BeforePrint
      LPARAMETERS m.loHost
      * loHost - Odkaz na hostitelsky objekt nebo Engine
   ENDPROC


   PROCEDURE EFRX_NextReport
      LPARAMETERS m.loHost
      * loHost - Odkaz na hostitelsky objekt
   ENDPROC


   PROCEDURE EFRX_Progress
      LPARAMETERS m.loHost, m.loPPar
      * loHost - Odkaz na hostitelsky objekt
      * loPPar - Odkaz na objet s parametry pro progress
   ENDPROC


   PROCEDURE EFRX_BeforeEmail
      LPARAMETERS m.loHost
      * loHost - Odkaz na hostitelsky objekt
   ENDPROC

ENDDEFINE


************************************************************
* seznam spustenych oken
DEFINE CLASS _SrvSeznam AS CUSTOM
   Name="_SrvSeznam"

   NewId = 0  && id noveho seznamu
   LastTop =  -(SYSMETRIC(4)*2+SYSMETRIC(9)) && pozice ze shora posledniho dokumentu
   LastLeft = -(SYSMETRIC(4)*2+SYSMETRIC(9)) && pozice zleva posledniho dokumentu

   ADD OBJECT CVPFiles AS CONTAINER && konteiner CVP souboru
   ADD OBJECT BasicAction AS CONTAINER && konteiner akce
   ADD OBJECT ActionGetCont AS _Action_Get_Cont && stinovy konteiner

   ActionGetCont.BasicActionContainer="This.Parent.BasicAction"
   ActionGetCont.ActiveModul_Name="m.XX_System.Modul"
   ActionGetCont.ActSrv_Name="XX_ActSrv"

   PROCEDURE BasicAction.Init
       This.AddObject("_1", "_ACT_1") && akce New
       This.AddObject("_2", "_ACT_2") && akce open
       This.AddObject("_6", "_ACT_6") && akce SaveAll
       This.AddObject("_7", "_ACT_7_0") && akce Help
   ENDPROC


   * vrati startovaci pozice pro modul
   PROCEDURE GetNextPos
      LPARAMETERS m.loInstance, m.liTop, m.liLeft
      *  loInstance - Instance modulu
      * @liTop      - sem se vrati nova pozice Top
      * @liLeft     - sem se vrati nova pozice Left

      LOCAL m.liLastTop, m.liLastLeft, m.liDelta
      m.liDelta=SYSMETRIC(4)*2+SYSMETRIC(9) && delta
      m.liLastTop=This.LastTop
      m.liLastLeft=This.LastLeft

      m.liLastTop=m.liLastTop+IIF(m.liLastTop+m.loInstance.Height+m.liDelta*2> _Screen.Height, -m.liLastTop, m.liDelta)
      m.liLastLeft=m.liLastLeft+IIF(m.liLastLeft+m.loInstance.Width+SYSMETRIC(4)*2+m.liDelta> _Screen.Width, -m.liLastLeft, m.liDelta)
   
      STORE m.liLastTop  TO loInstance.Top, This.LastTop, m.liTop
      STORE m.liLastLeft TO loInstance.Left, This.LastLeft, m.liLeft

   ENDPROC


   * prida modul do seznamu
   PROCEDURE CVPFiles.AddModul
      LPARAMETERS m.lcModul, m.lcClass
      * lcModul - Nazev noveho objektu
      * lcClass - Nazev tridy

      PUBLIC (m.lcModul) && vytvor ji jako globalni pronennou
      This.AddObject(m.lcModul, m.lcClass) && pridej objekt do seznamu
      RETURN EVALUATE("This."+m.lcModul)
   ENDPROC


   * prida modul do seznamu (pouze pro CVP soubory)
   PROCEDURE CVPFiles.Find_AddCVPModul
      LPARAMETERS m.lcModul

      * lcModul - Nazev noveho objektu
      * pak musim prolist seznam a vsem XXF070 rict, aby si pridaly modul do seznamu
*!*       LOCAL lii
*!*       FOR lii=1 TO This.ControlCount
*!*           IF This.Controls(m.lii).Name="XXF070_"
*!*              =EVAL(This.Controls(m.lii).Name+".AddModul(m.lcModul)")
*!*           ENDIF
*!*       NEXT
   ENDPROC


   * odstrani modul ze seznamu
   PROCEDURE CVPFiles.RemoveModul
      LPARAMETERS m.lcModul
      * lcModul - Nazev objektu
      IF NOT PEMSTATUS(This, m.lcModul, 5) && Pokud existuje
         RETURN
      ENDIF

      LOCAL m.lcXXF080, m.lcXXF082, m.lcXXF084, m.lcXXF070, m.lcXXF210, m.lcXXF220, m.lii

      m.lcXXF080=IIF(LEFT(m.lcModul, 7)="XXF000_", EVAL("This."+m.lcModul+".XXF080"),"")
      m.lcXXF082=IIF(LEFT(m.lcModul, 7)="XXF000_", EVAL("This."+m.lcModul+".XXF082"),"")
      m.lcXXF084=IIF(LEFT(m.lcModul, 7)="XXF000_", EVAL("This."+m.lcModul+".XXF084"),"")
      m.lcXXF210=IIF(LEFT(m.lcModul, 7)="XXF000_", EVAL("This."+m.lcModul+".XXF210"),"")
      m.lcXXF220=IIF(LEFT(m.lcModul, 7)="XXF000_", EVAL("This."+m.lcModul+".XXF220"),"")

      This.RemoveObject(m.lcModul) && Odstran objekt ze seznamu
      RELE (m.lcModul) && Zlikviduj globalni promennou

      * Pokud se jedna o CVP soubor
      * Pak musim prolist seznam a vsem XXF070 rict, aby modul smazaly ze seznamu
      IF LEFT(m.lcModul, 7)="XXF000_"
         IF !ISNULL(m.lcXXF080)
            RELE (m.lcXXF080)
         ENDIF
         IF !ISNULL(m.lcXXF082)
            RELE (m.lcXXF082)
         ENDIF
         IF !ISNULL(m.lcXXF084)
            RELE (m.lcXXF084)
         ENDIF
         IF !ISNULL(m.lcXXF210)
            RELE (m.lcXXF210)
         ENDIF
         IF !ISNULL(m.lcXXF220)
            RELE (m.lcXXF220)
         ENDIF

         FOR m.lii=This.ControlCount TO 1 STEP -1
             IF LEFT(This.Controls(m.lii).Name, 7)=="XXF070_" AND EVAL(This.Controls(m.lii).Name+".AModul")==m.lcModul
                RELE (This.Controls(m.lii).Name)
             ENDIF
         NEXT

      ENDIF
   ENDPROC
ENDDEFINE

*****************************************************************************************************************
* trida toolbaru
DEFINE CLASS _CVP_toolbar AS _toolbar
   Name="_CVP_toolbar"

   ControlBox=.T.

   PROCEDURE Init
      LPARAMETERS m.lcName
      * lcName - Nazev toolbaru

      DODEFAULT() && volani puvodni metody
      This.Name=m.lcName
      m.XX_System.Windows.LoadPosition(m.lcName, This) && Nacti pozice okna
   ENDPROC


   PROCEDURE Destroy
      DODEFAULT() && volani puvodni metody
      m.XX_System.Windows.SavePosition(This.Name, This) && uloz pozice okna
      IF !m.plEnd && pokud neni globalni ukonceni
         STORE 0 TO ("m.XX_System."+This.Name)
         =EVAL("_Show"+This.Name+"()")
      ENDIF
   ENDPROC

ENDDEFINE

*****************************************************************************************************************
* trida na vystupni text
DEFINE CLASS _cOutPutText AS CUSTOM
   Name="_cOutPutText"
   OPText="" && zdroj dat pro vystupni okno
   Modul="" && nazev posledniho modulu, ktery zapisoval

   PROCEDURE Add
      LPARAMETERS m.loModul, m.lcText, m.llImportant

      IF m.XX_System.LogDebug=0 AND !m.llImportant
         RETURN
      ENDIF
      IF NOT m.XX_System.lGUIAllowed
         DEBUGOUT m.lcText
         RETURN
      ENDIF
      IF ISNULL(m.loModul)
         This.Modul=""
      ELSE
         IF !EMPTY(This.Modul) AND !This.Modul==m.loModul.Name && pokud se lisi modul
            * pak pridej text identifikujici modul
            IF LEFT(m.loModul.Name, 7)=="XXF000_"
               This.OPText=This.OPText+CRLF+IIF(EMPTY(m.loModul.File), m.loModul.File_Log, m.loModul.File)+CRLF
            ENDIF
            This.Modul=m.loModul.Name && zapis si nazev modulu
         ENDIF
      ENDIF

      This.OPText=This.OPText+TAB+m.lcText+CRLF
      IF TYPE("m.XXF012")="O" AND !ISNULL(m.XXF012)
         m.XXF012.LockScreen=.T.
         m.XXF012.edtList.Value=This.OPText
         m.XXF012.edtList.SelStart=LEN(This.OPText)-LEN(m.lcText)-3
         m.XXF012.LockScreen=.F.
      ENDIF
   ENDPROC
ENDDEFINE

*****************************************************************************************************************
DEFINE CLASS _ACT_7_0 AS _ACT_7
   Name="_ACT_7_0"

   PROCEDURE Run
      LPARAMETERS m.loPar
      * loPar- objekt parametru
      IF PCOUNT()=0 && pokud neni
         * pak ho vytvor
         m.loPar=CREATEOBJECT("_WinHelp")
         m.loPar.hwnd=m.XX_System.hwnd
         m.loPar.File=m.XX_System.Help
         m.loPar.Command=HH_DISPLAY_INDEX
         m.loPar.Data=0
      ENDIF
      RETURN DODEFAULT(m.loPar)
   ENDPROC
ENDDEFINE

*****************************************************************************************************************
DEFINE CLASS _tmrKick AS TIMER
   Name="_tmrKick"
   Enabled=.F.
   Interval=250

   PROCEDURE Timer()
      m.XX_ActSrv.Run(m.XX_System.Modul, _ACT_Close)
      This.Enabled=.F.
   ENDPROC
ENDDEFINE

*****************************************************************************************************************
DEFINE CLASS _VFPRect AS CUSTOM
   Name="_VFPRect"

   WindowState = 0  && stav okna
   DockPosition = -1 && dokovani toolbaru
   Dockable = 0 && dokovatelnost formu

   xBaseClass="" && priznak zakladni tridy
   AutoCenter=.T. && priznak automatickeho vycentrovani
ENDDEFINE

*****************************************************************************************************************
DEFINE CLASS _Language AS DATAENVIRONMENT
   Name="_Language"
   Collate="" && Collate (trideni)
   Caption="" && popis jazyka
   Library="" && kompletni knihovna
   Help="" && help
   FontCharset=1

   * provede test, zda potrebne soubory existuji a pokud ne, pak se ji pokusi lokalizovat
   * pokud se to nepodari, pak vrati .F. jinak .T. a zapise zpet do vlastnosti File cestu a nazev
   PROCEDURE TestFile
      LPARAMETERS m.liFile
      * liFile - Typ souboru (1-Library,2-Help)

      LOCAL m.lcFile, m.llDal
      m.llDal=.T. && nastav priznak, ze soubor neexistuje
      IF !FILE(IIF(m.liFile=1, This.Library, This.Help))
         m.lcFile=JUSTFNAME(IIF(m.liFile=1, This.Library, This.Help)) && vyjmi jen soubor
         m.llDal=FindFile(@m.lcFile) && mjadi soubor
         IF m.llDal
            STORE m.lcFile TO (IIF(m.liFile=1, "This.Library", "This.Help")) && uloz zpet cestu a nazev souboru
         ENDIF
      ENDIF
      RETURN m.llDal && vrat priznak
   ENDPROC

   DIME aMapLanguage(1) && matice na mapovani nazvu jazyka
   iMapLanguage=0 && index matice
ENDDEFINE

*****************************************************************************************************************
DEFINE CLASS _PackUtil_Helper AS CUSTOM
   Name="_PackUtil_Helper" && kod pakovaci utility

   C_File="" && kompresni utilita
   D_File="" && dekompresni utilita
   VFP =""   && VFP plugin pro kompresi a dekompresi
   iPack = .NULL. && Interface pro pakovani a rozpakovani

   lError=.F. && Priznak chyby

   * provede test, zda PU existuje a pokud ne, pak se ji pokusi lokalizovat
   * pokud se to nepodari, pak vrati .F. jinak .T. a zapise zpet do vlastnosti File cestu a nazev

   PROCEDURE IntegrityTest
      LPARAMETERS m.liFile

      * liFile - Typ souboru jez se ma zkontrolovat (0 - Compress, 1 - Dekompress)

      LOCAL m.lcFile, m.lcFile2, m.llDal, m.loo
      m.llDal=.T. && nastav priznak, ze soubor neexistuje
      * nejdive zkontroluj plugin

      m.lcFile=This.VFP
      m.lcFile2=ChangeExtensionFromFile(m.lcFile, "prg")
      IF NOT (FILE(m.lcFile) OR FILE(m.lcFile2))
         m.lcFile=JUSTFNAME(m.lcFile) && vyjmi jen soubor
         m.lcFile2=ChangeExtensionFromFile(m.lcFile, "prg")
         
         m.llDal=FindFile(@m.lcFile) OR FindFile(@m.lcFile2) && najdi soubor
         This.VFP=m.lcFile
         IF !m.llDal
            * varovani pri selhani inicializace
            =m.XX_System.OPT.Add(m.XX_System, STRTRAN(m.XX_Res.ReadStringEx(_PU_TestVFP), "%File%", This.VFP), .T.)
         ENDIF
      ENDIF

      * Ted zkontroluj kompresni a dekompresni soubory
      m.lcFile=IIF(m.liFile=0, This.C_File, This.D_File)
      IF m.llDal AND !FILE(m.lcFile)
         m.lcFile=JUSTFNAME(m.lcFile) && vyjmi jen soubor
         m.llDal=FindFile(@m.lcFile) && najdi soubor
         IF m.llDal
            STORE m.lcFile TO (IIF(m.liFile=0, "This.C_File", "This.D_File"))
         ELSE
            * varovani pri selhani inicializace
            =m.XX_System.OPT.Add(m.XX_System,STRTRAN(m.XX_Res.ReadStringEx(_PU_TestPack), "%File%",IIF(m.liFile=0, This.C_File, This.D_File)), .T.)
         ENDIF
      ENDIF

      IF m.llDal AND ISNULL(This.iPack)
         This.lError=.F.
         DO CVP_GetInterface IN (This.VFP) WITH m.loo
         m.llDal=!This.lError
         IF m.llDal
            This.iPack=m.loo && nalinkuj vytvoreny objekt
         ELSE
            =m.XX_System.OPT.Add(m.XX_System, STRTRAN(m.XX_Res.ReadStringEx(_PU_TestVFPIn), "%File%", This.VFP), .T.)
         ENDIF
      ENDIF

      RETURN m.llDal && vrat priznak
   ENDPROC


   PROCEDURE Error
      LPARAMETERS m.nError, m.cMethod, m.nLine

      This.lError=.T.
   ENDPROC


   PROCEDURE IsStreamAvailable
      RETURN This.iPack.lStreamAvailable
   ENDPROC


   * Dekompress method
   PROCEDURE Decompress
      LPARAMETERS m.loPack && instance of _strucPack

      RETURN This.iPack.Decompress(@m.loPack)
   ENDPROC


   * Compress method
   PROCEDURE Compress
      LPARAMETERS m.loPack && instance of _strucPack

      RETURN This.iPack.Compress(@m.loPack)
   ENDPROC


   * Dekompress stream method
   PROCEDURE DecompressStream
      LPARAMETERS m.loPack && instance of _strucPack

      RETURN This.iPack.DecompressStream(@m.loPack)
   ENDPROC


   * Compress stream method
   PROCEDURE CompressStream
      LPARAMETERS m.loPack && instance of _strucPack

      RETURN This.iPack.CompressStream(@m.loPack)
   ENDPROC

ENDDEFINE

DEFINE CLASS _PackUtil AS CUSTOM
   Name="_PackUtil" 

   lStreamAvailable=.F.

   * Dekompress method
   PROCEDURE Decompress
      LPARAMETERS m.loPack && instance of _strucPack

      RETURN _PP_ErrOK
   ENDPROC


   * Compress method
   PROCEDURE Compress
      LPARAMETERS m.loPack && instance of _strucPack

      RETURN _PP_ErrOK
   ENDPROC


   * Dekompress stream method
   PROCEDURE DecompressStream
      LPARAMETERS m.loPack && instance of _strucPack

      RETURN _PP_ErrOK
   ENDPROC


   * Compress stream method
   PROCEDURE CompressStream
      LPARAMETERS m.loPack && instance of _strucPack

      RETURN _PP_ErrOK
   ENDPROC

ENDDEFINE

*****************************************************************************************************************
DEFINE CLASS _WinHelp AS DATAENVIRONMENT
   Name="_WinHelp"
   hwnd=0 && handle okna ke kteremu prislusi help
   File="" && umisteni a nazev helpoveho souboru
   Command=0 && Prikaz jez se ma provest
   Data="" && (0) data pro prikaz
ENDDEFINE


*****************************************************************************************************************
DEFINE CLASS _xOCXLibrary AS DATAENVIRONMENT
   Name= "_xOCXLibrary"
   Library="" && Nazev knihovny
   DIME aClss(1) && seznam trid jez se maji odzkouset
ENDDEFINE

*****************************************************************************************************************
DEFINE CLASS __cmdFile AS _cmdFilecvp
   Name="_cmdFile"
   FileControl="This.Parent.Text1.Value"
   TypeObj=0

   PROCEDURE GotFocus()
      DODEFAULT()
      IF PEMSTATUS(Thisform, "ActiveColumnName", 5)
         Thisform.ActiveColumnName=This.Parent.Name
      ENDIF
   ENDPROC

   PROCEDURE BeforeGetFile()
      This.FileExtesion=IIF(This.TypeObj=0, "PJX", JUSTEXT(RTRIM(XX201))) && nastav koncovku pro dialog

      This.GetFile_Cap=m.XX_Res.ReadStringEx(;
                       IIF(This.FileExtesion="PJX", _XXLog_RepairSource_odlg_PJX_Cap,;
                       IIF(This.FileExtesion="VCX", _XXLog_RepairSource_odlg_VCX_Cap,;
                       IIF(This.FileExtesion="FRX", _XXLog_RepairSource_odlg_FRX_Cap,;
                       IIF(This.FileExtesion="LBX", _XXLog_RepairSource_odlg_LBX_Cap,;
                       IIF(This.FileExtesion="TSQL", _XXLog_RepairSource_odlg_TSQL_Cap,;
                       IIF(This.FileExtesion="SCX", _XXLog_RepairSource_odlg_SCX_Cap,;
                       IIF(This.FileExtesion="PRG", _XXLog_RepairSource_odlg_PRG_Cap, _XXLog_RepairSource_odlg_DBC_Cap))))))))

      This.DefPath=ADDBS(JUSTPATH(IIF(EMPTY(XX210), RTRIM(XX201), RTRIM(XX210)))) && nastav def. cestu
      This.GetFile_Cap=STRTRAN(This.GetFile_Cap, "%File%", JUSTFNAME(RTRIM(XX201)))
   ENDPROC


   PROCEDURE AfterGetFile()
      LOCAL m.locbo
      IF This.ChangedValue && pokud doslo ke zmene
         WITH This.Parent.Parent.XX210
         *locbo=EVAL(".cboFile"+LTRIM(STR(RECNO(),11)))
         m.locbo=.cboFile
         m.locbo.AddOneListItem(ALLTRIM(XX210)) && nacti data
         .Refresh() && obcerstvi vedlejsi sloupec
         m.XX_System.AddLostFile(JUSTFNAME(ALLTRIM(XX201)), ALLTRIM(XX210))
         ENDWITH
      ENDIF
   ENDPROC

ENDDEFINE

*****************************************************************************************************************
DEFINE CLASS _grdColumn AS _Column
   Name="_grdColumn"
   txtclass="_grdText"

   PROCEDURE MouseMove
      LPARAMETERS m.nButton, m.nShift, m.nXCoord, m.nYCoord
      This.Parent.MouseMove(m.nButton, m.nShift, m.nXCoord, m.nYCoord)
   ENDPROC

   PROCEDURE DblClick()
      This.Parent.DblClick()
   ENDPROC

ENDDEFINE

*****************************************************************************************************************
DEFINE CLASS _grdText AS _Textbox
   Name="_grdText"
   FocusColor=.F.
   PropAsColumn=.T.

   PROCEDURE MouseMove
      LPARAMETERS m.nButton, m.nShift, m.nXCoord, m.nYCoord
      This.Parent.Parent.MouseMove(m.nButton, m.nShift, m.nXCoord, m.nYCoord)
   ENDPROC


   PROCEDURE DblClick()
      This.Parent.Parent.DblClick()
   ENDPROC


   PROCEDURE KeyPress
      LPARAMETERS m.nKeyCode, m.nShiftAltCtrl

      * Enter
      IF m.nKeyCode=13 AND m.nShiftAltCtrl=0 AND PEMSTATUS(This.Parent.Parent, "GoToChild", 5)
         This.Parent.Parent.GoToChild(0)
         NODEFAULT
         RETURN
      ENDIF
      * BackSpace
      IF m.nKeyCode=127 AND m.nShiftAltCtrl=0 AND PEMSTATUS(This.Parent.Parent, "GoToParent", 5)
         This.Parent.Parent.GoToParent()
         NODEFAULT
         RETURN
      ENDIF
      * Home
      IF m.nKeyCode=1 AND m.nShiftAltCtrl=0 AND PEMSTATUS(This.Parent.Parent, "GoToHome", 5)
         This.Parent.Parent.GoToHome()
         NODEFAULT
         RETURN
      ENDIF
      * End
      IF m.nKeyCode=6 AND m.nShiftAltCtrl=0 AND PEMSTATUS(This.Parent.Parent, "GoToEnd", 5)
         This.Parent.Parent.GoToEnd()
         NODEFAULT
         RETURN
      ENDIF
      =DODEFAULT(m.nKeyCode, m.nShiftAltCtrl)
   ENDPROC


   PROCEDURE GotFocus()
      DODEFAULT()
      IF PEMSTATUS(Thisform, "ActiveColumnName", 5)
         Thisform.ActiveColumnName=This.Parent.Name
      ENDIF

      IF This.PropAsColumn
         WITH This.Parent
         This.BackColor=IIF(EMPTY(.DynamicBackColor),.BackColor,EVAL(.DynamicBackColor))
         This.ForeColor=IIF(EMPTY(.DynamicForeColor),.ForeColor,EVAL(.DynamicForeColor))

*!*          This.SelectedBackColor=This.BackColor
*!*          This.SelectedForeColor=This.ForeColor

         This.FontName=IIF(EMPTY(.DynamicFontName),.FontName,EVAL(.DynamicFontName))
         This.FontSize=IIF(EMPTY(.DynamicFontSize),.FontSize,EVAL(.DynamicFontSize))
         This.FontBold=IIF(EMPTY(.DynamicFontBold),.FontBold,EVAL(.DynamicFontBold))
         This.FontItalic=IIF(EMPTY(.DynamicFontItalic),.FontItalic,EVAL(.DynamicFontItalic))
         This.FontOutline=IIF(EMPTY(.DynamicFontOutline),.FontOutline,EVAL(.DynamicFontOutline))
         This.FontShadow=IIF(EMPTY(.DynamicFontShadow),.FontShadow,EVAL(.DynamicFontShadow))
         This.FontStrikethru=IIF(EMPTY(.DynamicFontStrikethru),.FontStrikethru,EVAL(.DynamicFontStrikethru))
         This.FontUnderline=IIF(EMPTY(.DynamicFontUnderline),.FontUnderline,EVAL(.DynamicFontUnderline))

         This.InputMask=IIF(EMPTY(.DynamicInputMask),.InputMask,EVAL(.DynamicInputMask))
         This.Alignment=IIF(EMPTY(.DynamicAlignment),.Alignment,EVAL(.DynamicAlignment))
         ENDWITH
      ENDIF
   ENDPROC

ENDDEFINE

*****************************************************************************************************************
DEFINE CLASS _grdSText AS _grdText
   Name="_grdSText"
   PropAsColumn=.F.

   PROCEDURE Click()
      This.Parent.Parent.Click()
      KEYBOARD "{SHIFT+RIGHTARROW}" PLAIN
      This.GotFocus()
   ENDPROC

   PROCEDURE GotFocus
      LOCAL m.liRGB
      m.liRGB=IIF(EMPTY(This.Parent.DynamicBackColor), RGB(255,255,255), EVAL(This.Parent.DynamicBackColor))
      IF This.BackColor=m.liRGB
         This.ResetToDefault("SelectedBackColor")
      ELSE
         This.SelectedBackColor=BITNOT(m.liRGB)
      ENDIF
   ENDPROC


ENDDEFINE

*****************************************************************************************************************
DEFINE CLASS _grdEdit AS _Editbox
   Name="_grdEdit"
   FocusColor=.F.
   ZWWindowState = 2
   PropAsColumn=.T.

   PROCEDURE KeyPress
      LPARAMETERS m.nKeyCode, m.nShiftAltCtrl
      * Enter
      IF m.nKeyCode=13 AND m.nShiftAltCtrl=0 AND PEMSTATUS(This.Parent.Parent, "GoToChild", 5)
         This.Parent.Parent.GoToChild(0)
         NODEFAULT
         RETURN
      ENDIF
      * BackSpace
      IF m.nKeyCode=127 AND m.nShiftAltCtrl=0 AND PEMSTATUS(This.Parent.Parent, "GoToParent", 5)
         This.Parent.Parent.GoToParent()
         NODEFAULT
         RETURN
      ENDIF
      * Home
      IF m.nKeyCode=1 AND m.nShiftAltCtrl=0 AND PEMSTATUS(This.Parent.Parent, "GoToHome", 5)
         This.Parent.Parent.GoToHome()
         NODEFAULT
         RETURN
      ENDIF
      * End
      IF m.nKeyCode=6 AND m.nShiftAltCtrl=0 AND PEMSTATUS(This.Parent.Parent, "GoToEnd", 5)
         This.Parent.Parent.GoToEnd()
         NODEFAULT
         RETURN
      ENDIF

      IF m.nKeyCode=5 AND m.nShiftAltCtrl=0
         KEYB "{BACKTAB}{UPARROW}{TAB}" PLAIN CLEAR
         NODEFAULT
         RETURN
      ENDIF

      IF m.nKeyCode=24 AND m.nShiftAltCtrl=0
         KEYB "{BACKTAB}{DNARROW}{TAB}" PLAIN CLEAR
         NODEFAULT
         RETURN
      ENDIF

      IF m.nKeyCode=18 AND m.nShiftAltCtrl=0
         KEYB "{BACKTAB}{PGUP}{TAB}" PLAIN CLEAR
         NODEFAULT
         RETURN
      ENDIF

      IF m.nKeyCode=3 AND m.nShiftAltCtrl=0
         KEYB "{BACKTAB}{PGDN}{TAB}" PLAIN CLEAR
         NODEFAULT
         RETURN
      ENDIF
      
      IF m.nKeyCode=19 AND m.nShiftAltCtrl=0
         IF This.SelStart=0
            KEYB "{BACKTAB}" PLAIN CLEAR
            NODEFAULT
            RETURN
         ENDIF
      ENDIF

      IF m.nKeyCode=4 AND m.nShiftAltCtrl=0
         IF This.SelStart=LEN(LTRIM(This.Text))-1
            KEYB "{TAB}" PLAIN CLEAR
            NODEFAULT
            RETURN
         ENDIF
      ENDIF

      =DODEFAULT(m.nKeyCode, m.nShiftAltCtrl)
   ENDPROC


   PROCEDURE MouseMove
      LPARAMETERS m.nButton, m.nShift, m.nXCoord, m.nYCoord
      This.Parent.Parent.MouseMove(m.nButton, m.nShift, m.nXCoord, m.nYCoord)
   ENDPROC


   PROCEDURE DblClick()
      This.Parent.Parent.DblClick()
   ENDPROC


   PROCEDURE GotFocus
      DODEFAULT() && volani puvodni metody
      IF This.PropAsColumn
         WITH This.Parent
         This.BackColor=IIF(EMPTY(.DynamicBackColor),.BackColor,EVAL(.DynamicBackColor))
         This.ForeColor=IIF(EMPTY(.DynamicForeColor),.ForeColor,EVAL(.DynamicForeColor))

*!*          This.SelectedBackColor=This.BackColor
*!*          This.SelectedForeColor=This.ForeColor

         This.FontName=IIF(EMPTY(.DynamicFontName),.FontName,EVAL(.DynamicFontName))
         This.FontSize=IIF(EMPTY(.DynamicFontSize),.FontSize,EVAL(.DynamicFontSize))
         This.FontBold=IIF(EMPTY(.DynamicFontBold),.FontBold,EVAL(.DynamicFontBold))
         This.FontItalic=IIF(EMPTY(.DynamicFontItalic),.FontItalic,EVAL(.DynamicFontItalic))
         This.FontOutline=IIF(EMPTY(.DynamicFontOutline),.FontOutline,EVAL(.DynamicFontOutline))
         This.FontShadow=IIF(EMPTY(.DynamicFontShadow),.FontShadow,EVAL(.DynamicFontShadow))
         This.FontStrikethru=IIF(EMPTY(.DynamicFontStrikethru),.FontStrikethru,EVAL(.DynamicFontStrikethru))
         This.FontUnderline=IIF(EMPTY(.DynamicFontUnderline),.FontUnderline,EVAL(.DynamicFontUnderline))

         ENDWITH
      ENDIF
   ENDPROC
   
ENDDEFINE

*****************************************************************************************************************
DEFINE CLASS __MenuForm AS _Popup
   Name="__MenuForm"

   PROCEDURE Init()
      This.AddBar(1,m.XX_Res.ReadBarEx(_main_mFile_barprm_03, Res_Type_Menu_Prompt), .F., "m.XX_ActSrv.Run(m.XX_System.Modul, "+LTRIM(STR(_ACT_Close, 11))+")", .F.)
      This._1.Message=m.XX_Res.ReadBarEx(_main_mFile_barprm_03, Res_Type_Menu_Message)
      This.AddBar(2,"\-",.F.,"",.F.)
      This._2.Message=""
      This.AddBar(3,m.XX_Res.ReadBarEx(_main_menu_barprm_03, Res_Type_Menu_Prompt), .F., "m.XX_ActSrv.Run(m.XX_System.Modul, "+LTRIM(STR(_ACT_Help, 11))+")", .F.)
      This._3.Message=m.XX_Res.ReadBarEx(_main_menu_barprm_03, Res_Type_Menu_Message)
   ENDPROC


   PROCEDURE ActivPopup
      LPARAMETERS m.loObj

      LOCAL m.loParent
      =GetMainParent(m.loObj, @m.loParent)
      This.Window=m.loParent.Name
      =DODEFAULT(m.loObj)
      This.Window=""
   ENDPROC

ENDDEFINE

*****************************************************************************************************************
DEFINE CLASS __MenuEdit AS _MenuEdit
   Name="__MenuEdit"

   PROCEDURE Init()
      This.x_med_cut.Prompt=m.XX_Res.ReadBarEx(_msm_Edit_prmCut, Res_Type_Menu_Prompt)
      This.x_med_copy.Prompt=m.XX_Res.ReadBarEx(_msm_Edit_prmCopy, Res_Type_Menu_Prompt)
      This.x_med_paste.Prompt=m.XX_Res.ReadBarEx(_msm_Edit_prmPaste, Res_Type_Menu_Prompt)
      This.x_med_slcta.Prompt=m.XX_Res.ReadBarEx(_msm_Edit_prmSelectAll, Res_Type_Menu_Prompt)
      This.x_3.Prompt=m.XX_Res.ReadBarEx(_msm_Edit_prmZoom, Res_Type_Menu_Prompt)
      This.x_med_clear.Prompt=m.XX_Res.ReadBarEx(_msm_Edit_prmClear, Res_Type_Menu_Prompt)
      

      This.x_med_cut.Message=m.XX_Res.ReadBarEx(_msm_Edit_prmCut, Res_Type_Menu_Message)
      This.x_med_copy.Message=m.XX_Res.ReadBarEx(_msm_Edit_prmCopy, Res_Type_Menu_Message)
      This.x_med_paste.Message=m.XX_Res.ReadBarEx(_msm_Edit_prmPaste, Res_Type_Menu_Message)
      This.x_med_slcta.Message=m.XX_Res.ReadBarEx(_msm_Edit_prmSelectAll, Res_Type_Menu_Message)
      This.x_3.Message=m.XX_Res.ReadBarEx(_msm_Edit_prmZoom, Res_Type_Menu_Message)
      This.x_med_clear.Message=m.XX_Res.ReadBarEx(_msm_Edit_prmClear, Res_Type_Menu_Message)
   ENDPROC


   PROCEDURE ActivPopup
      LPARAMETERS m.loObj

      LOCAL m.loParent, m.loObjX, m.liSele, m.lcAlias, m.liRecno, m.liXX101O, m.lcXX400
      =GetMainParent(m.loObj, @m.loParent)
      This.Window=m.loParent.Name

      IF UPPER(m.loObj.Class)=="_GRDEDIT"
         m.lcAlias=LEFT(m.loObj.ControlSource, AT(".", m.loObj.ControlSource)-1)
         IF LEFT(m.lcAlias, 8)=="(XXT610_"
            m.loObjX=CREATEOBJECT(m.loObj.Class)

            m.loObjX.FocusColor=m.loObjX.FocusColor
            m.loObjX.ZWWindowState =m.loObj.ZWWindowState
            m.loObjX.PropAsColumn=m.loObj.PropAsColumn

            m.loObjX.BackColor=m.loObj.BackColor
            m.loObjX.ForeColor=m.loObj.ForeColor
            m.loObjX.FontName=m.loObj.FontName
            m.loObjX.FontSize=m.loObj.FontSize
            m.loObjX.FontBold=m.loObj.FontBold
            m.loObjX.FontItalic=m.loObj.FontItalic
            m.loObjX.FontOutline=m.loObj.FontOutline
            m.loObjX.FontShadow=m.loObj.FontShadow
            m.loObjX.FontStrikethru=m.loObj.FontStrikethru
            m.loObjX.FontUnderline=m.loObj.FontUnderline
            m.loObjX.MaxLength=m.loObj.MaxLength 
            m.loObjX.ReadOnly=m.loObj.ReadOnly
            m.loObjX.Enabled=m.loObj.Enabled

            m.liSele=SELECT()

            SELECT (STUFF(m.lcAlias, 1, 1, ''))
            m.liRecno=RECNO()
            m.liXX101O=XX101O
            m.lcXX400=""
            DO WHILE XX101O=m.liXX101O
               m.lcXX400=RTRIM(XX400)+CRLF+m.lcXX400
               SKIP -1
            ENDDO

            GO (m.liRecno)
            SKIP 1
            SCAN WHILE XX101O=m.liXX101O
                 m.lcXX400=m.lcXX400+RTRIM(XX400)+CRLF
            ENDSCAN

            m.loObjX.Value=m.lcXX400
            GO (m.liRecno)

            SELECT (m.liSele)
            m.loObj=m.loObjX
         ENDIF
      ENDIF

      =DODEFAULT(m.loObj)
      This.Window=""
   ENDPROC
ENDDEFINE


*****************************************************************************************************************
* definice tridy do kontaineru
DEFINE CLASS _File AS CUSTOM
   Name="_File"

   Key="" && kod souboru (XXT100.DBF)
   Group="" && skupina (XXT100)
   Main=.T. && priznak, zda se jedna o hlavni soubor ve skupine
   Caption="" && popis skupiny/souboru

   Necessary=.T. && priznak, zda je soubor nutny pro ulozeni
   Size=0 && velikost nezpakovaneho souboru
   Packed=0 && priznak souboru, zda byl zpakovan
   PackedSize=0 && velikost zpakovaneho souboru
   Saved=0 && priznak, zda byl souboru ulozen

   MaySave=0 && priznak, zda se muze ulozit (jen pro Necessary=.F.)

   File="" && nazev cesty a souboru pro ulozeni a otevreni
   FirstRecord=0 && prvni radek, kde se nachazi ulozeny soubor
   RecCount=-1 && Pocet vet (DBF soubory)

   * vrat priznak, zda se ma soubor ulozit (jen pro ukladani)
   PROCEDURE GetSave()
      RETURN IIF(This.Necessary, .T., This.MaySave=1)
   ENDPROC

   * nastav priznak, pro celou skupinu
   PROCEDURE SetSave
      LPARAMETERS m.liSave
      LOCAL m.lii, m.loP
      m.loP=This.Parent
      FOR m.lii=1 TO m.loP.ControlCount
          IF m.loP.Controls(m.lii).Group==This.Group
             m.loP.Controls(m.lii).MaySave=m.liSave
          ENDIF
      NEXT
   ENDPROC
   
ENDDEFINE


*****************************************************************************************************************
* Definice tridy pro zpakovani
DEFINE CLASS _strucPack AS CUSTOM
   Name="_strucPack"

   PU = .NULL. && odkaz na objekt o pakovaci utilite
   PI = .NULL. && odkaz na objekt tridy _struc_PROCESS_INFORMATION
   SI = .NULL. && odkaz na objekt tridy _struc_STARTUPINFO
   File = .NULL. && odkaz na objekt souboru
   cAlias = "" && Source/Destination alias for stream

   File_S = "" && zdrojovy soubor na zpakovani/pro rozpakovani
   File_D = "" && cilovy soubor po zpakovani/rozpakovani
ENDDEFINE



*****************************************************************************************************************
* definice tridy do kontaineru
DEFINE CLASS _ReportPar AS CUSTOM
   Name="_ReportPar"

   Par1=""
   Par2=""
   Par3=""
   Par4=""

ENDDEFINE


****************************************************************
* Trida pro inicilizaci interface EFRX
****************************************************************
DEFINE CLASS __CVPCFRXs AS __CFRXs
   Name="__CVPCFRXs"

   PROCEDURE InitEngine && Dodatecna inicializace interface
      LPARAMETERS m.loEngine
      * loEngine - Objekt interface
      DO CASE
         CASE m.loEngine.Engine=="XFRX" AND EMPTY(m.loEngine.EPath)
              m.loEngine.EPath=m.loEngine.Path+"XFRXDemo\"

         CASE m.loEngine.Engine=="FRX2WORD" AND EMPTY(m.loEngine.EPath)
              m.loEngine.EPath=m.loEngine.Path+"FRX2WORD\"

         CASE m.loEngine.Engine=="MERE" AND EMPTY(m.loEngine.EPath)
              m.loEngine.EPath="c:\MindsEyeReportEngine\libs\"

         CASE m.loEngine.Engine=="FRX2ANY" AND EMPTY(m.loEngine.EPath)
              m.loEngine.EPath=m.loEngine.Path+"FRX2ANYDemo\"

         CASE m.loEngine.Engine=="EREPORTS" AND EMPTY(m.loEngine.EPath)
              m.loEngine.EPath=m.loEngine.Path+"EREPORTS\"
      ENDCASE
   ENDPROC

ENDDEFINE


****************************************************************
* Definiton class _GetDirEx for function GetDirEx()
****************************************************************
DEFINE CLASS _GetDirEx AS CUSTOM
   Name="_GetDirEx"

   * If property btnND,btnOK or btnCancel empty, then default caption of buttons are not change.
   WTitle="" && Window Title
   Title="" && dialog Title

   NewFolderAllowed=.T. && For Shell version 5.0

   Flag=0 && Member ulFlags in struc. BROWSEINFO (FLL function always insert BIF_USENEWUI if NewFolderAllowed=.T.)

   btnND="" && New caption of button "Make New Folder"
   _btnND_ID=0x3746 && Control ID of button "Make New Folder". Don't change !!!

   btnOK="" && New caption of button "OK"
   _btnOK_ID=0x1 && Control ID of button "OK". Don't change !!!

   btnCancel="" && New caption of button "Cancel"
   _btnCancel_ID=0x2 && Control ID of button "Cancel". Don't change !!!

   DefaultDir="" && Default directory

   OutPutDir="" && Output directory

   IsRoot=.F. && If Default directory is root, same as parametr lReadOnly in function GetDir() in VFP 7.0
ENDDEFINE


****************************************************************
* Definiton class _GetFileEx for function GetFileEx()
****************************************************************
DEFINE CLASS _GetFileEx AS CUSTOM
   Name="_GetFileEx"

   Owner = -1        && HWND      hwndOwner
   Filter =""        && LPCTSTR   lpstrFilter text,*.txt; replace ,; to \0
   FilterIndex = 0   && DWORD     nFilterIndex
   File=""           && LPTSTR    lpstrFile; add \0

*   Instance =0       && HINSTANCE hInstance 
*   CustomFilter = "" && LPTSTR    lpstrCustomFilter; null
*   MaxCustFilter = 0 && DWORD     nMaxCustFilter 
*   FileTitle=""      && LPTSTR    lpstrFileTitle; if empty set null, add \0
*   MaxFileTitle=0    && DWORD     nMaxFileTitle; auto by FileTitle 
*   TemplateName=""   && LPCTSTR   lpTemplateName; if empty set null, add \0 
*   FlagsEx=""        && DWORD     FlagsEx

   MaxFile=2048      && DWORD     nMaxFile; auto by File
   InitialDir=""     && LPCTSTR   lpstrInitialDir; if empty set null, add \0
   Title=""          && LPCTSTR   lpstrTitle; if empty set null add \0
   Flags=0           && DWORD     Flags; 
   FileOffset=0      && WORD      nFileOffset; out for single/multi select
   FileExtension=0   && WORD      nFileExtension; out
   DefExt=""         && LPCTSTR   lpstrDefExt; if empty set null, add \0

*   DIME aFiles(1)    && Array of selected Files
   iFiles=0          && Count of selected files
   SelectedFolder="" && Selected folder for more files 
   aFName=""         && 

   Err=0             && Error Number 

   * OFN_ALLOWMULTISELECT Specifies that the File Name list box allows multiple selections.
   * If you also set the OFN_EXPLORER flag, the dialog box uses the Explorer-style user interface;
   * otherwise, it uses the old-style user interface. 
   * If the user selects more than one file, the lpstrFile buffer returns the path to the current directory
   * followed by the file names of the selected files.
   * The nFileOffset member is the offset, in bytes or characters, to the first file name,
   * and the nFileExtension member is not used.
   * For Explorer-style dialog boxes, the directory and file name strings are NULL separated,
   * with an extra NULL character after the last file name.
   * This format enables the Explorer-style dialog boxes to return long file names that include spaces.
   * For old-style dialog boxes, the directory and file name strings are separated by spaces and the function uses short file names for file names with spaces.
   * You can use the FindFirstFile function to convert between long and short file names. 
   * If you specify a custom template for an old-style dialog box, the definition of the File Name list
   * box must contain the LBS_EXTENDEDSEL value. 
   AllowMultiSelect=.T. 

   * OFN_CREATEPROMPT If the user specifies a file that does not exist,
   * this flag causes the dialog box to prompt the user for permission to create the file.
   * If the user chooses to create the file, the dialog box closes and the function returns the specified name;
   * otherwise, the dialog box remains open. If you use this flag with the OFN_ALLOWMULTISELECT flag,
   * the dialog box allows the user to specify only one nonexistent file.  
   CreatePrompt=.F.

   * OFN_DONTADDTORECENT Windows 2000/XP: Prevents the system from adding a link to the selected file in the
   * file system directory that contains the user's most recently used documents.
   * To retrieve the location of this directory, call the SHGetSpecialFolderLocation function
   * with the CSIDL_RECENT flag.  
   DontAddToRecent=.F.

   * OFN_ENABLEHOOK Enables the hook function specified in the lpfnHook member. 
   EnableHook=.F.

   * OFN_ENABLEINCLUDENOTIFY Windows 2000/XP: Causes the dialog box to send CDN_INCLUDEITEM notification messages
   * to your OFNHookProc hook procedure when the user opens a folder.
   * The dialog box sends a notification for each item in the newly opened folder.
   * These messages enable you to control which items the dialog box displays in the folder's item list.
   EnableIncludeNotify=.F.

   * OFN_ENABLESIZING Windows 2000/XP, Windows 98/Me: Enables the Explorer-style dialog box to be resized using
   * either the mouse or the keyboard. By default, the Explorer-style Open and Save As dialog boxes allow
   * the dialog box to be resized regardless of whether this flag is set. This flag is necessary only if you
   * provide a hook procedure or custom template. The old-style dialog box does not permit resizing. 
   EnableSizing=.T.

   * OFN_ENABLETEMPLATE Indicates that the lpTemplateName member is a pointer to the name of a dialog
   * template resource in the module identified by the hInstance member. 
   *
   * If the OFN_EXPLORER flag is set, the system uses the specified template to create a dialog box
   * that is a child of the default Explorer-style dialog box. If the OFN_EXPLORER flag is not set,
   * the system uses the template to create an old-style dialog box that replaces the default dialog box.
   EnableTemplate=.F.

   * OFN_ENABLETEMPLATEHANDLE Indicates that the hInstance member identifies a data block that contains a
   * preloaded dialog box template. The system ignores the lpTemplateName if this flag is specified. 
   * If the OFN_EXPLORER flag is set, the system uses the specified template to create a dialog box that
   * is a child of the default Explorer-style dialog box. If the OFN_EXPLORER flag is not set,
   * the system uses the template to create an old-style dialog box that replaces the default dialog box.
   EnableTemplateHandle=.F.

   * OFN_EXPLORER Indicates that any customizations made to the Open or Save As dialog box use
   * the new Explorer-style customization methods. For more information,
   * see Explorer-Style Hook Procedures and Explorer-Style Custom Templates. 
   * By default, the Open and Save As dialog boxes use the Explorer-style user interface
   * regardless of whether this flag is set. This flag is necessary only if you provide a hook procedure
   * or custom template, or set the OFN_ALLOWMULTISELECT flag. 
   * If you want the old-style user interface, omit the OFN_EXPLORER flag and provide a replacement
   * old-style template or hook procedure. If you want the old style but do not need a custom template
   * or hook procedure, simply provide a hook procedure that always returns FALSE.
   Explorer=.T.

   * OFN_EXTENSIONDIFFERENT Specifies that the user typed a file name extension that differs from the extension
   * specified by lpstrDefExt. The function does not use this flag if lpstrDefExt is NULL. 
   ExtensionDifferent=.F.

   * OFN_FILEMUSTEXIST Specifies that the user can type only names of existing files in the File Name entry field.
   * If this flag is specified and the user enters an invalid name, the dialog box procedure displays
   * a warning in a message box. If this flag is specified, the OFN_PATHMUSTEXIST flag is also used. 
   FileMustExist=.F.

   * OFN_FORCESHOWHIDDEN Windows 2000/XP: Forces the showing of system and hidden files,
   * thus overriding the user setting to show or not show hidden files.
   * However, a file that is marked both system and hidden is not shown. 
   ForceShowHidden=.T.

   * OFN_HIDEREADONLY Hides the Read Only check box.
   HideReadOnly=.T. 

   * OFN_LONGNAMES For old-style dialog boxes, this flag causes the dialog box to use long file names.
   * If this flag is not specified, or if the OFN_ALLOWMULTISELECT flag is also set,
   * old-style dialog boxes use short file names (8.3 format) for file names with spaces. 
   * Explorer-style dialog boxes ignore this flag and always display long file names.
   LongNames=.F.

   * OFN_NOCHANGEDIR Restores the current directory to its original value if the user changed the directory
   * while searching for files. Windows NT 4.0/2000/XP: This flag is ineffective for GetOpenFileName.
   NoChangeDir=.F.

   * OFN_NODEREFERENCELINKS Directs the dialog box to return the path and file name
   * of the selected shortcut (.LNK) file. If this value is not specified, the dialog box returns
   * the path and file name of the file referenced by the shortcut.
   NoDereferenceLinks=.F.

   * OFN_NOLONGNAMES For old-style dialog boxes, this flag causes the dialog box to use short file names (8.3 format). 
   * Explorer-style dialog boxes ignore this flag and always display long file names.
   NoLongNames=.F.

   * OFN_NONETWORKBUTTON Hides and disables the Network button.
   NoNetworkButton=.F.

   * OFN_NOREADONLYRETURN Specifies that the returned file does not have the Read Only check box selected and
   * is not in a write-protected directory. 
   NoReadOnlyReturn=.F.

   * OFN_NOTESTFILECREATE Specifies that the file is not created before the dialog box is closed.
   * This flag should be specified if the application saves the file on a create-nonmodify network share.
   * When an application specifies this flag, the library does not check for write protection, a full disk,
   * an open drive door, or network protection. Applications using this flag must perform file operations carefully,
   * because a file cannot be reopened once it is closed. 
   NotesFileCreate=.F.

   * OFN_NOVALIDATE Specifies that the common dialog boxes allow invalid characters in the returned file name.
   * Typically, the calling application uses a hook procedure that checks the file name by using
   * the FILEOKSTRING message. If the text box in the edit control is empty or contains nothing but spaces,
   * the lists of files and directories are updated. If the text box in the edit control contains anything else,
   * nFileOffset and nFileExtension are set to values generated by parsing the text.
   * No default extension is added to the text, nor is text copied to the buffer specified by lpstrFileTitle. 
   * If the value specified by nFileOffset is less than zero, the file name is invalid.
   * Otherwise, the file name is valid, and nFileExtension and nFileOffset can be used as
   * if the OFN_NOVALIDATE flag had not been specified.
   NoValidate=.F.

   * OFN_OVERWRITEPROMPT Causes the Save As dialog box to generate a message box if the selected file already exists.
   * The user must confirm whether to overwrite the file.
   OverWritePrompt=.F.

   * OFN_PATHMUSTEXIST Specifies that the user can type only valid paths and file names.
   * If this flag is used and the user types an invalid path and file name in the File Name entry field,
   * the dialog box function displays a warning in a message box.
   PathMustExist=.F.

   * OFN_READONLY Causes the Read Only check box to be selected initially when the dialog box is created.
   * This flag indicates the state of the Read Only check box when the dialog box is closed. 
   ReadOnly=.F.

   * OFN_SHAREAWARE Specifies that if a call to the OpenFile function fails because of a network sharing violation,
   * the error is ignored and the dialog box returns the selected file name. 
   * If this flag is not set, the dialog box notifies your hook procedure when a network sharing violation
   * occurs for the file name specified by the user.
   * If you set the OFN_EXPLORER flag, the dialog box sends the CDN_SHAREVIOLATION message to the hook procedure.
   * If you do not set OFN_EXPLORER, the dialog box sends the SHAREVISTRING registered message to the hook procedure. 
   ShareAware=.F.

   * OFN_SHOWHELP Causes the dialog box to display the Help button. The hwndOwner member must specify
   * the window to receive the HELPMSGSTRING registered messages that the dialog box sends when the
   * user clicks the Help button. An Explorer-style dialog box sends a CDN_HELP notification
   * message to your hook procedure when the user clicks the Help button. 
   ShowHelp=.F.

ENDDEFINE


*************************************
DEFINE CLASS _SF_FIELD AS CUSTOM
   Name="_SF_FIELD"
   OK=.F.

   Field=""
   Type=""
   IsNull=.F.
   Source=""
   Compile=""

   Alias=""
   XX800=""

   Scope=1 && local (1 - a course of M/P, 2 - all courses of M/P, 3 - all M/P of document, 4 - all M/P of all documents)
   XX300I=0 && ID M/P

ENDDEFINE


****************************************************************
* Definiton class _GetDirEx for function GetDirEx()
****************************************************************
DEFINE CLASS _NumberTable AS CUSTOM
   Name="_NumberTable"
   cAlias=""

   PROCEDURE Init()
      This.cAlias=SYS(2015)
      CREATE CURSOR (This.cAlias) (XNUMBER I)
      SELECT (This.cAlias)
      SET COLLATE TO "MACHINE"
      INDEX ON XNUMBER TAG "I01"
      SET COLLATE TO (m.XX_System.Collate)
      INSERT INTO (This.cAlias) VALUES (0)

      m.XX_tmpFiles.Register(DBF(This.cAlias))
      m.XX_tmpFiles.Register(FORCEEXT(DBF(This.cAlias), "CDX"))
   ENDPROC

   PROCEDURE Destroy()
      m.XX_tmpFiles.UnRegister(DBF(This.cAlias)) && odregistruj pracovni soubor
      m.XX_tmpFiles.UnRegister(FORCEEXT(DBF(This.cAlias), "CDX")) && odregistruj pracovni soubor
      USE IN (This.cAlias)
   ENDPROC

   PROCEDURE AddItems
      LPARAMETERS m.liMax
      LOCAL m.liSELE, m.lii, m.liLMax
      m.liSELE=SELECT()
      SET COLLATE TO "MACHINE"
      SELECT (This.cAlias)
      IF NOT SEEK(m.liMax)
         GO BOTTOM
         m.liLMax=MAX(XNUMBER, 1)
         FOR m.lii=m.liLMax TO m.liMax
             INSERT INTO (This.cAlias) VALUES (m.lii)
         NEXT
      ENDIF
      SET COLLATE TO (m.XX_System.Collate)
      SELECT (m.liSELE)
   ENDPROC

ENDDEFINE




*******************************************************************
* SHA1
*******************************************************************
DEFINE CLASS SHA1 AS CUSTOM
   Name="SHA1"

   H0 = 0
   H1 = 0
   H2 = 0
   H3 = 0
   H4 = 0

   FUNCTION SHA1
      LPARAMETERS m.cMessage

      LOCAL m.nNbBlocs, m.nHigh, m.nLow, m.i

      This.H0 = 0x67452301
      This.H1 = 0xEFCDAB89
      This.H2 = 0x98BADCFE
      This.H3 = 0x10325476
      This.H4 = 0xC3D2E1F0

      M.nNbBlocs = LEN(M.cMessage) / 64

      ** Si au dpart, la taille du message n'est pas un multiple de 512,
      ** alors l'algorithme complte le message en ajoutant un 1 et
      ** autant de 0 que ncessaires et les 8 derniers octets servent
      **  stocker la longueur du message.

      M.nLen = LEN(M.cMessage)
      M.nReste = MOD(M.nLen, 64)
      IF M.nReste > 0 OR M.nLen = 0
         M.nNbBlocs = M.nNbBlocs + 1
         IF M.nReste > 55
            M.cMessage = M.cMessage + CHR(2^7) + REPLICATE(CHR(0), (64 - M.nReste) + 55)
            M.nNbBlocs = M.nNbBlocs + 1
         ELSE
            M.cMessage = M.cMessage + CHR(2^7) + REPLICATE(CHR(0), (55 - M.nReste))
         ENDIF
         M.nHigh = (M.nLen*8) / 2^32
         M.nLow = MOD(M.nLen*8, 2^32)
         M.cMessage = M.cMessage + CHR(BITAND(BITRSHIFT(M.nHigh, 24), 0xFF)) ;    && 56
                                 + CHR(BITAND(BITRSHIFT(M.nHigh, 16), 0xFF)) ;    && 57
                                 + CHR(BITAND(BITRSHIFT(M.nHigh, 8), 0xFF))  ;    && 58
                                 + CHR(BITAND(M.nHigh, 0xFF)) ;                   && 59
                                 + CHR(BITAND(BITRSHIFT(M.nLow, 24), 0xFF)) ;     && 60
                                 + CHR(BITAND(BITRSHIFT(M.nLow, 16), 0xFF)) ;     && 61
                                 + CHR(BITAND(BITRSHIFT(M.nLow, 8), 0xFF))  ;     && 62
                                 + CHR(BITAND(M.nLow, 0xFF))                      && 63
      ENDIF

      * NB! lisasin local i

      FOR m.I = 1 TO M.nNbBlocs
         This.ProcessBloc(SUBSTR(M.cMessage, 1 + 64*(m.I-1), 64))
      ENDFOR

      RETURN SUBSTR(TRANSFORM(This.H0, "@0"), 3) + ;
             SUBSTR(TRANSFORM(This.H1, "@0"), 3) + ;
             SUBSTR(TRANSFORM(This.H2, "@0"), 3) + ;
             SUBSTR(TRANSFORM(This.H3, "@0"), 3) + ;
             SUBSTR(TRANSFORM(This.H4, "@0"), 3)

   ENDFUNC

   *******************************************************************
   PROCEDURE ProcessBloc
      LPARAMETERS m.cBloc
      LOCAL m.I, m.A, m.B, m.C, m.D, m.E, m.nTemp
      LOCAL ARRAY m.W(80)

      ** Pour chaque bloc de 512 bits, on divise le bloc en 16 mots de 32 bits
      ** et on les affecte respectivement  W1, W2...W16.
      FOR m.I = 1 TO 16
          m.W(I) = BITLSHIFT(ASC(SUBSTR(M.cBloc, (m.I-1) * 4 + 1, 1)), 24) + ;
                   BITLSHIFT(ASC(SUBSTR(M.cBloc, (m.I-1) * 4 + 2, 1)), 16) + ;
                   BITLSHIFT(ASC(SUBSTR(M.cBloc, (m.I-1) * 4 + 3, 1)), 8) + ;
                   ASC(SUBSTR(M.cBloc, (m.I-1) * 4 + 4, 1))
      ENDFOR

      ** Pour I variant de 17  80, on affecte les mots Wi de la manire suivante :
      ** Wi = Wi-3 XOR Wi-8 XOR Wi-14 XOR Wi-16
      FOR m.I = 17 TO 80
          m.W(m.i) = This.BitLRotate(1, BITXOR(m.W(m.i-3), m.W(m.i-8), m.W(m.i-14), m.W(m.i-16)))
      ENDFOR

      m.A = This.H0
      m.B = This.H1
      m.C = This.H2
      m.D = This.H3
      m.E = This.H4

      ** Pour I variant de 1  80 et avec Sn un dcalage circulaire gauche de n bits,
      ** on effectue les calculs suivants :
      FOR m.I = 1 TO 20
          M.nTemp = This.BitLRotate(5, m.A) + BITOR(BITAND(m.B, m.C), BITAND(BITNOT(m.B), m.D)) + ;
                    m.E + m.W(m.i) + 0x5A827999
          m.E = m.D
          m.D = m.C
          m.C = This.BitLRotate(30, m.B)
          m.B = m.A
          m.A = M.nTemp
      ENDFOR

      FOR m.I = 21 TO 40
          M.nTemp = This.BitLRotate(5, m.A) + BITXOR(m.B, m.C, m.D) + m.E + m.W(m.i) + 0x6ED9EBA1
          m.E = m.D
          m.D = m.C
          m.C = This.BitLRotate(30, m.B)
          m.B = m.A
          m.A = M.nTemp
      ENDFOR

      FOR m.I = 41 TO 60
          M.nTemp = This.BitLRotate(5, m.A) + BITOR(BITAND(m.B, m.C), BITAND(m.B, m.D), BITAND(m.C, m.D)) + ;
                    m.E + m.W(m.i) + 0x8F1BBCDC
          m.E = m.D
          m.D = m.C
          m.C = This.BitLRotate(30, m.B)
          m.B = m.A
          m.A = M.nTemp
      ENDFOR

      FOR m.I = 61 TO 80
          M.nTemp = This.BitLRotate(5, m.A) + BITXOR(m.B, m.C, m.D) + m.E + m.W(m.i) + 0xCA62C1D6
          m.E = m.D
          m.D = m.C
          m.C = This.BitLRotate(30, m.B)
          m.B = m.A
          m.A = M.nTemp
      ENDFOR

      This.H0 = This.H0 + m.A
      This.H1 = This.H1 + m.B
      This.H2 = This.H2 + m.C
      This.H3 = This.H3 + m.D
      This.H4 = This.H4 + m.E
      RETURN
   ENDPROC

   FUNCTION BitLRotate( m.nBits, m.nWord )
      RETURN BITLSHIFT(M.nWord, M.nBits) + BITRSHIFT(M.nWord, (32-(M.nBits)))
   ENDFUNC

ENDDEFINE



**************************************************************
* Z radku zdrojoveho kodu odstrani komentar a strednik
* a pokud byl strednik pred komentarem, pak vrati 1, za komentarem 2 a vubec ne 0
****************************************************************
PROCEDURE Trim_SC
LPARAMETERS m.lcRow

*@lcRow     - Radek zdrojoveho kodu
LOCAL m.lii, m.liComm, m.liMD, m.llComm, m.lcPom
* Najdi komentar

m.liComm=AT_NonSpace(@m.lcRow, 1)
* Pokud to neni kometar
* Pak to otestuj na &&
m.liComm=IIF(!(SUBS(m.lcRow, m.liComm,1)="*" OR LOWER(SUBS(m.lcRow, m.liComm, 4))="note"), AT(CHR(38)+CHR(38), m.lcRow), m.liComm)

IF m.liComm>0 && Nasel nejaky komentar
   m.liMD=RAT_NonSpace(@m.lcRow, LEN(m.lcRow), m.liComm) && Hledej ne mezeru
   m.llComm=SUBS(m.lcRow, m.liMD, 1)=";" && Nastav priznak stredniku
ENDIF

m.lii=RAT_NonSpace(@m.lcRow, IIF(m.liComm>0, m.liComm-1, LEN(m.lcRow)))
m.lii=IIF(SUBS(m.lcRow, m.lii, 1)=";", m.lii, 0) && Nastav priznak stredniku

m.lcRow=IIF(m.liComm>0, LEFT(m.lcRow, IIF(m.lii=0, m.liComm, m.lii)-1),;
            IIF(m.lii=0, m.lcRow, LEFT(m.lcRow, m.lii-1)))

RETURN IIF(m.liComm>0,IIF(lii>0, 1, IIF(m.llComm, 2, 0)),;
       IIF(m.lii>0, 1 ,0))
ENDPROC
       
****************************************************************
* Opravi zdrojovy kod - ukonci radky znaky CRLF
****************************************************************
PROCEDURE RepairSource
LPARAMETERS m.lcSource
*@lcSource - Zdrojovy kod

LOCAL m.liCR, m.liLF
* Zjisti, zda to nemusis upravit
m.liCR=AT(CHR(13),m.lcSource, 1)
m.liLF=AT(CHR(10),m.lcSource, 1)
        
* Pokud tam neni plny CRLF, ale CR nebo LF
IF m.liCR=0 OR m.liLF=0
   * Pak to nahrad CRLF
   m.lcSource=STRTRAN(m.lcSource, IIF(m.liCR=0, CHR(10), CHR(13)), CRLF)
ENDIF
ENDPROC

****************************************************************
* Opravi ridici kody XML
****************************************************************
PROCEDURE StrTranHTMLString
LPARAMETERS m.lcString
* lcString - Retezec, v ketrem se maji nahradit ridici znaky HTML
RETURN STRTRAN(STRTRAN(STRTRAN(STRTRAN(STRTRAN(m.lcString, "&", "&amp;"), ">", "&gt;"), "<", "&lt;"), '"', "&quot;"), '/', "&#47;")
ENDPROC


***************************************************
* Q269387 - HOWTO: Obtain a GUID in Visual FoxPro *
***************************************************
PROCEDURE GetGUID()
#DEFINE s_ok 0

LOCAL m.luGUID, m.lnRetVal, m.lii, m.lcData1, m.lcData2, m.lcData3, m.lcData4, m.lcData5
m.luGUID=REPLICATE(CHR(0), 17)
*!* Call CoCreateGuid
m.lnRetVal=cvp_CoCreateGuid(@m.luGUID)
IF m.lnRetVal=s_ok
   *!* Store the first eight characters of the GUID in data1
   m.lcData1=RIGHT(TRANSFORM(strtolong(LEFT(m.luGUID, 4)), "@0"), 8)
   *!* Store the first group of four characters of the GUID in data2
   m.lcData2=RIGHT(TRANSFORM(strtolong(SUBSTR(m.luGUID, 5, 2)), "@0"), 4)
   *!* Store the second group of four characters of the GUID in data3
   m.lcData3=RIGHT(TRANSFORM(strtolong(SUBSTR(m.luGUID, 7, 2)), "@0"), 4)
   *!* Store the third group of four characters of the GUID in data4
   m.lcData4=RIGHT(TRANSFORM(strtolong(SUBSTR(m.luGUID, 9, 1)), "@0"), 2) + ;
             RIGHT(TRANSFORM(strtolong(SUBSTR(m.luGUID, 10, 1)), "@0"), 2)
   *!* Initialize data5 to a null string
   m.lcData5=""
   *!* Convert the final 12 characters of the GUID and store in data5
   FOR m.lii=1 TO 6
       m.lcData5=m.lcData5+RIGHT(TRANSFORM(strtolong(SUBSTR(m.luGUID, 10+m.lii, 1))), 2)
   ENDFOR
   *!* Check the length of data5. If less than 12, the final 12-len(data5)
   *!* characters are '0'
   IF LEN(m.lcData5)<12
      m.lcData5=m.lcData5+REPLICATE("0", 12-LEN(m.lcData5))
   ENDIF
   *!* Assemble the GUID into a string
   RETURN  "{"+m.lcData1+"-"+m.lcData2+"-"+m.lcData3+"-"+m.lcData4+"-"+m.lcData5+"}"
ENDIF
RETURN ""
ENDPROC

****************************************************************
PROCEDURE strtolong

LPARAMETERS m.lcLongstr
*!* Passed:  4-byte character string (lcLongstr) in low-high ASCII format
*!* Returns:  long integer value
*!* Example:
*!* m.longstr = "1111"
*!* m.longval = strtolong(m.longstr)
LOCAL m.lii, m.lnRetval
m.lnRetval = 0
FOR m.lii = 0 TO 24 STEP 8
    m.lnRetval = m.lnRetval + (ASC(m.lcLongstr) * (2^m.lii))
    m.lcLongstr = RIGHT(m.lcLongstr, LEN(m.lcLongstr) - 1)
NEXT
RETURN m.lnRetval
ENDPROC



****************************************************************
PROCEDURE ColorToRGB
LPARAMETERS m.liColor, m.liR, m.liG, m.liB
* liColor - Color
*@liR     - R phase
*@liG     - G phase
*@liB     - B phase

m.liR=BITAND(0xFF, m.liColor)                    && Red
m.liG=BITRSHIFT(BITAND(0x00FF00, m.liColor), 8)  && Green
m.liB=BITRSHIFT(BITAND(0xFF0000, m.liColor), 16) && Blue
ENDPROC

****************************************************************
PROCEDURE RGBToColor
LPARAMETERS m.liR,m.liG,m.liB
*liR     - R phase
*liG     - G phase
*liB     - B phase
RETURN m.liR+256*m.liG+m.liB*256*256
ENDPROC

****************************************************************
PROCEDURE GetXXR001_XX999
LPARAMETERS m.lcXX999
RETURN m.XX_Res.ReadStringEx(;
       IIF(m.lcXX999="RT", XXR001_XX999_RT, IIF(m.lcXX999="RP", XXR001_XX999_RP, IIF(m.lcXX999="MT", XXR001_XX999_MT, XXR001_XX999_MP))))
ENDPROC

****************************************************************
PROCEDURE GetXXR001_XX001
LPARAMETERS m.liXX001
RETURN m.XX_Res.ReadStringEx(;
       IIF(m.liXX001=1, XXR001_XX001_1, IIF(m.liXX001=2, XXR001_XX001_2, XXR001_XX001_3)))
ENDPROC


****************************************************************
PROCEDURE GetXXR001_XX002
LPARAMETERS m.liXX002
RETURN m.XX_Res.ReadStringEx(IIF(m.liXX002=1, XXR001_XX999_Asc, XXR001_XX999_Desc))
ENDPROC


****************************************************************
PROCEDURE SUMEX
LPARAMETERS m.lnVal, m.lnSUM
m.lnSUM=m.lnSUM+m.lnVal
RETURN .T.
ENDPROC

****************************************************************
PROCEDURE NumToString
LPARAMETERS m.lnVal, m.lcUnit
RETURN TRANSFORM(m.lnVal)+IIF(EMPTY(m.lcUnit), "", " "+m.lcUnit)
ENDPROC


****************************************************************
PROCEDURE TimeDiffToString
LPARAMETERS m.lnVal1, m.lnVal2, m.lcUnit
RETURN TRANSFORM(ROUND((m.lnVal1-m.lnVal2)/1000.00, 4))+IIF(EMPTY(m.lcUnit), "", " "+m.lcUnit)
ENDPROC

