*****************************************************************************************************************
* Definice tridy OCX knihovny
DEFINE CLASS _OCXLibrary AS CUSTOM
   Name= "_OCXLibrary"
   DIME aClss(1) && Seznam trid jez se maji odzkouset
ENDDEFINE


*****************************************************************************************************************
* Definice tridy OCX knihoven
DEFINE CLASS _OCXVersLibraries AS CUSTOM
   Name= "_OCXVersLibraries"

   Active_Library="" && Aktivni knihovna

   * Prida verzi knihovny do seznamu
   PROCEDURE Add
      LPARAMETERS m.lcLibrary
      * lcLibrary - Nazev OCX knihovny - verze
      IF TYPE("This."+m.lcLibrary)#"O"
         This.AddObject(m.lcLibrary,"_OCXLibrary") && Vytvor objekt knihovny
      ENDIF
      RETURN EVAL("This."+m.lcLibrary) && Vrat objekt knihovny
   ENDPROC

   * Odstrani verzi knihovny ze seznamu
   PROCEDURE Remove
      LPARAMETERS m.lcLibrary
      
      * lcLibrary - Nazev OCX knihovny - verze
      IF TYPE("This."+m.lcLibrary)="O"
         This.RemoveObject(m.lcLibrary) && Odstran objekt knihovny
      ENDIF
   ENDPROC

   * Provede otestovani verzi knihoven a jejich trid
   PROCEDURE Test
      LOCAL m.lii, m.liy, m.loo, m.llErr
      FOR m.lii=This.ControlCount TO 1 STEP -1
          FOR m.liy=1 TO ALEN(This.Controls(m.lii).aClss)
              * Pokus se vytvorit tridu
              TRY
               m.loo=CREATEOBJECT(This.Controls(m.lii).aClss(m.liy))
               RELE m.loo
              CATCH
               m.llErr=.T.
              ENDTRY

              IF m.llErr && Pokud doslo k chybe
                 * Pak musis z tehle smycky vyskocit ven
                 EXIT
              ENDIF
          NEXT
          IF !m.llErr && Pokud nedoslo k chybe
             EXIT
          ENDIF
      NEXT

      * Nastav verzi Aktivni knihovny
      This.Active_Library=IIF(m.lii=0, "", This.Controls(m.lii).Name)
      * Pokud doslo k chybe, pak vrat .F. , jinak .T.
      RETURN !m.llErr
   ENDPROC


ENDDEFINE

*****************************************************************************************************************
* Definice tridy testu OCX knihoven
DEFINE CLASS _OCXLibraries AS CUSTOM
   Name= "_OCXLibraries"

   Failed_Library="" && Nazev knihovny, kterou se nepodarilo inializovat (jedna se pouze o zkratku)

   * Prida knihovnu do seznamu
   PROCEDURE Add
      LPARAMETERS m.lcLibrary
      * lcLibrary - Nazev OCX knihovny
      IF TYPE("This."+m.lcLibrary)#"O"
         This.AddObject(m.lcLibrary,"_OCXVersLibraries") && Vytvor objekt knihovny
      ENDIF
      RETURN EVAL("This."+m.lcLibrary) && Vrat objekt knihovny
   ENDPROC

   * Odstrani knihovnu ze seznamu
   PROCEDURE Remove
      LPARAMETERS m.lcLibrary
      * lcLibrary - Nazev OCX knihovny
      IF TYPE("This."+m.lcLibrary)="O"
         This.RemoveObject(m.lcLibrary) && Odstran objekt knihovny
      ENDIF
   ENDPROC

   * Provede otestovani knihoven
   PROCEDURE Test
      LOCAL m.lii, m.llRet
      m.llRet=.T. && Nastav priznak na OK
      FOR m.lii=1 TO This.ControlCount
          IF !This.Controls(m.lii).Test()
             This.Failed_Library=This.Controls(m.lii).Name
             m.llRet=.F. && Nastav na .F.
             EXIT && Ukonci smycku
          ENDIF
      NEXT
      RETURN m.llRet
   ENDPROC

ENDDEFINE
