#INCLUDE "..\Main.h"

*************************************************************
* Procedura, ktera vrati objekt pro pakovani a rozpakovani
PROCEDURE CVP_GetInterface
LPARAMETERS m.loObj
*@loObj - Vlastnost do ktere se zapise odkaz na objekt pro pakovani
m.loObj=CREATEOBJECT("_bix_Archiver")
RETURN
ENDPROC

*************************************************************
* vlastni trida pro pakovani a rozpakovani
DEFINE CLASS _bix_Archiver AS _PackUtil
   Name="_bix_Archiver"
  
   * Dekompresni metoda
   PROCEDURE Decompress
      LPARAMETERS m.loPack
      * loPack - Objekt pro rozpakovani
      LOCAL m.lcDir, m.lcProgram, m.lctmpFile, m.lcUnpackPath, m.liz, m.lcStartupInfo, m.lcProcessInfo, m.liRet, m.liWFS, m.lcPom
      LOCAL ARRAY m.laDir(1)
      
      m.lctmpFile=m.loPack.File_S
      m.lcDir=ADDBS(JUSTPATH(m.lctmpFile))+ CHR(0)
      m.lcUnpackPath=SYS(2023)+"\"+SYS(2015)+"\" && pracovni nazev cesty
      =MKD(m.lcUnpackPath) && vytvor pracovni cestu

      * vytvor C++ strukturu z VFP objektu
      m.lcStartupInfo=m.loPack.SI.CreateString()
      m.lcProcessInfo=m.loPack.PI.CreateString()

      m.lcProgram = " e "+["]+m.lctmpFile+["]+" -o"+["]+m.lcUnpackPath+["]+" -y" + CHR(0)
      =cvp_SetLastError(0)
      m.liRet=_PP_ProcessFailed
      m.lcPom=m.loPack.PU.D_File+CHR(0)
      IF cvp_CreateProcess(@m.lcPom, @m.lcProgram, 0, 0, 1,  NORMAL_PRIORITY_CLASS, 0, @m.lcDir, @m.lcStartupInfo, @m.lcProcessInfo)#0
         * vyborne neselhalo to
         m.loPack.PI.ReadString(@m.lcProcessInfo)
         m.liWFS=WAIT_TIMEOUT
         DO WHILE m.liWFS= WAIT_TIMEOUT
            m.liWFS=cvp_WaitForSingleObject(m.loPack.PI.hProcess, 250)
         ENDDO
         =cvp_CloseHandle(m.loPack.PI.hProcess) && uzavri handle
         m.liz=ADIR(m.laDir, m.lcUnpackPath+"*.*","ASRH") && nacti vsechny soubory

         m.liRet=IIF(m.liz=0,_PP_PAUNFailed,;
                 IIF(cvp_MoveFile((m.lcUnpackPath+m.laDir(1, 1)+CHR(0)), (m.loPack.File_D+CHR(0)))=1, _PP_ErrOK, _PP_PAUNFailed))

      ENDIF
      =RemoveDirectoryAll(m.lcUnpackPath) && zlikviduj pracovni cestu
      RETURN m.liRet
   ENDPROC

   * Kompresni metoda
   PROCEDURE Compress
      LPARAMETERS m.loPack
      * loPack - Objekt pro rozpakovani

      LOCAL m.lcDir, m.lcProgram, m.lcStartupInfo, m.lcProcessInfo, m.liRet, m.liExitCode, m.lcPom

      m.lcDir=ADDBS(JUSTPATH(m.loPack.File_S))+ CHR(0)
      m.lcProgram = " a "+["]+m.loPack.File_D+["]+" "+["]+JUSTFNAME(m.loPack.File_S)+["] + CHR(0)

      m.lcStartupInfo=m.loPack.SI.CreateString()
      m.lcProcessInfo=m.loPack.PI.CreateString()

      =cvp_SetLastError(0)
      m.liRet=_PP_ProcessFailed
      m.lcPom=m.loPack.PU.C_File+CHR(0)
      IF cvp_CreateProcess(@m.lcPom, @m.lcProgram, 0, 0, 1, NORMAL_PRIORITY_CLASS, 0, @m.lcDir, @m.lcStartupInfo, @m.lcProcessInfo)#0
         * vyborne neselhalo to
         m.loPack.PI.ReadString(@m.lcProcessInfo)

         m.liExitCode=STILL_ACTIVE
         DO WHILE m.liExitCode=STILL_ACTIVE
            =cvp_Sleep(500)
            =cvp_GetExitCodeProcess(m.loPack.PI.hProcess, @m.liExitCode)
         ENDDO

         =cvp_CloseHandle(m.loPack.PI.hProcess) && uzavri handle
         m.liRet=_PP_ErrOK
      ENDIF
      RETURN m.liRet
   ENDPROC
ENDDEFIN