#INCLUDE "..\Main.h"
#INCLUDE "VFPZip.h"

*************************************************************
* Procedura, ktera vrati objekt pro pakovani a rozpakovani
PROCEDURE CVP_GetInterface
LPARAMETERS m.loObj
*@loObj - Promenna do ktere se zapise odkaz na objekt pro pakovani
m.loObj=CREATEOBJECT("_VFPZip_Archiver")
RETURN 
ENDPROC

*************************************************************
* vlastni trida pro pakovani a rozpakovani
DEFINE CLASS _VFPZip_Archiver AS _PackUtil
   Name="_VFPZip_Archiver"
  
   * Dekompresni metoda
   PROCEDURE Decompress
      LPARAMETERS m.loPack
      * loPack - Objekt pro rozpakovani

      * Inicializuj doplnkove API funkce
      IF !LoadDllFunc("DECLARE INTEGER AOpen IN "+["]+m.loPack.PU.D_File+["]+" STRING") OR ;
         !LoadDllFunc("DECLARE INTEGER AGetLastErr IN "+["]+m.loPack.PU.D_File+["]) OR ;
         !LoadDllFunc("DECLARE INTEGER AExtFile IN "+["]+m.loPack.PU.D_File+["]+" INTEGER, STRING , INTEGER") OR ;
         !LoadDllFunc("DECLARE INTEGER AClose IN "+["]+m.loPack.PU.D_File+["])
         RETURN _PP_ProcessFailed
      ENDIF

      LOCAL m.liErr, m.lcUnpackPath, m.liRet
      LOCAL ARRAY m.laDir(1)
      
      m.liErr=AOpen(m.loPack.File_S) && Otevri ZIP Archiv
      IF m.liErr=VFP_FALSE && Pokud to selze, pak vrat chybu
         RETURN _PP_PAUNFailed
      ENDIF

      m.lcUnpackPath=SYS(2023)+"\"+SYS(2015)+"\" && pracovni nazev cesty
      =MKD(m.lcUnpackPath) && vytvor pracovni cestu

      m.liErr=AExtFile(0, m.lcUnpackPath, VFP_TRUE )
      =AClose()
      m.liz=ADIR(m.laDir, m.lcUnpackPath+"*.*", "ASRH") && Nacti vsechny soubory
      * Proved kopii do ocekavaneho cile
      m.liRet=IIF(m.liz=0, _PP_PAUNFailed,;
              IIF(cvp_MoveFile((m.lcUnpackPath+m.laDir(1, 1)+CHR(0)), (m.loPack.File_D+CHR(0)))=1, _PP_ErrOK, _PP_PAUNFailed))

      =RemoveDirectoryAll(m.lcUnpackPath) && zlikviduj pracovni cestu
      RETURN m.liRet
   ENDPROC

   * Kompresni metoda
   PROCEDURE Compress
      LPARAMETERS m.loPack
      * loPack - Objekt pro rozpakovani

      * Inicializuj doplnkove API funkce
      IF !LoadDllFunc("DECLARE INTEGER ACreate IN "+["]+m.loPack.PU.C_File+["]+" STRING") OR ;
         !LoadDllFunc("DECLARE INTEGER AGetLastErr IN "+["]+m.loPack.PU.C_File+["]) OR ;
         !LoadDllFunc("DECLARE INTEGER ASetLevel IN "+["]+m.loPack.PU.C_File+["]+" INTEGER") OR ;
         !LoadDllFunc("DECLARE INTEGER AAddFile IN "+["]+m.loPack.PU.C_File+["]+" STRING, INTEGER") OR ;
         !LoadDllFunc("DECLARE INTEGER AClose IN "+["]+m.loPack.PU.C_File+["])
         RETURN _PP_ProcessFailed
      ENDIF

      LOCAL m.liErr
      m.liErr=ACreate(m.loPack.File_D) && Vytvor ZIP Archiv
      IF m.liErr=VFP_FALSE && Pokud to selze, pak vrat chybu
         RETURN _PP_PAUNFailed
      ENDIF

      * Nastav uroven komprese
*      =ASetLevel(BEST_SPEED)
      =ASetLevel(BEST_COMPRESSION)
      m.liErr = AAddFile(m.loPack.File_S, VFP_FALSE) && Pridej soubor do archivu
      =AClose()
      RETURN IIF(m.liErr=VFP_FALSE, _PP_PAUNFailed, _PP_ErrOK)
   ENDPROC
ENDDEFIN