#INCLUDE "..\Main.h"

*************************************************************
* Procedura, ktera vrati objekt pro pakovani a rozpakovani
PROCEDURE CVP_GetInterface
LPARAMETERS m.loObj
*@loObj - Promenna do ktere se zapise odkaz na objekt pro pakovani
m.loObj=CREATEOBJECT("_ZLibStream_Archiver")


*************************************************************
* vlastni trida pro pakovani a rozpakovani
DEFINE CLASS _ZLibStream_Archiver AS _PackUtil
   Name="_ZLibStream_Archiver"

   lStreamAvailable=.T.

   * Dekompresni metoda
   PROCEDURE DecompressStream
      LPARAMETERS m.loPack
      * loPack - Objekt pro rozpakovani

      LOCAL m.liMapZstream, m.liErr, m.liRet, m.liFile, m.liIBuffer, m.XX002, m.lcXX000

      * vytvoen z_stream pes cvp.fll
      m.liMapZstream=CVP_PrepareZstream()
      m.liRet=_PP_ErrOK
      m.liIBuffer=0

      m.liFile = cvp_CreateFile(m.loPack.File_D, GENERIC_WRITE, 0, 0, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0)
      m.liErr = CVP_IIZstream(m.liMapZstream, @m.liIBuffer)

      SELECT (m.loPack.cAlias)
      m.lcXX000=PADR(m.loPack.File.Key, LEN(XX000))
      SCAN REST WHILE XX000=m.lcXX000 AND XX001="0"
           m.XX002=""
           SCAN NEXT 256 WHILE XX000=m.lcXX000 AND XX001="0"
                m.XX002=m.XX002+XX002
           ENDSCAN
           =SYS(2600, m.liIBuffer, LEN(m.XX002), m.XX002)
           =CVP_InflateZstream(m.liMapZstream, m.liFile, LEN(m.XX002))
      ENDSCAN

      =cvp_CloseHandle(m.liFile)
      m.liErr = CVP_IEZstream(m.liMapZstream)
      =CVP_FreeZstream(m.liMapZstream)

      RETURN m.liRet
   ENDPROC

   * Kompresni metoda
   PROCEDURE CompressStream
      LPARAMETERS m.loPack
      * loPack - Objekt pro rozpakovani

      LOCAL m.liMapZstream, m.liErr, m.liSize, m.liFile, m.XX000, m.XX001, m.XX002, m.lcBuffer, m.liDeflate, m.liOBuffer,;
            m.liLevel, m.liWindowBits, m.liMemLevel, m.liStrategy, m.lcFile, m.lcVal
      LOCAL ARRAY m.laDir(1)
       
      m.liMapZstream=CVP_PrepareZstream()
      m.liRet=_PP_ErrOK

      =ADIR(m.laDir, m.loPack.File_S)
      m.liSize=m.laDir(2)
      m.liFile = cvp_CreateFile(m.loPack.File_S, GENERIC_READ, 0, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0)

      * vytvoen z_stream pes cvp.fll
      m.XX000=m.loPack.File.Key
      m.XX001="0"
      m.liOBuffer=0

      m.liLevel=8
      m.liWindowBits=15 
      m.liMemLevel=8
      m.liStrategy=0

      m.lcFile=m.XX_System.cAPPData+"CVP"+m.XX_System.cVersion+".INI"
      IF FILE(m.lcFile)
         m.liLevel=MIN(MAX(VAL(GetINIString("ZLIBStream", "Level", STR(m.liLevel, 1), 10, m.lcFile)), -1), 9)
         m.liWindowBits=MIN(MAX(VAL(GetINIString("ZLIBStream", "WindowBits", STR(m.liWindowBits, 2), 10, m.lcFile)), 3), 15)
         m.liMemLevel=MIN(MAX(VAL(GetINIString("ZLIBStream", "MemLevel", STR(m.liMemLevel, 1), 10, m.lcFile)), 8), 15)
         m.liStrategy=MIN(MAX(VAL(GetINIString("ZLIBStream", "Strategy", STR(m.liStrategy, 1), 10, m.lcFile)), 0), 4)
      ENDIF
      m.liErr = CVP_DIZstream(m.liMapZstream, m.liLevel, m.liWindowBits, m.liMemLevel, m.liStrategy, @m.liOBuffer)
      
      m.XX002=""
      DO WHILE m.liSize>0
         * voln deflate
         m.liDeflate=CVP_DeflateZstream(m.liMapZstream, @m.liSize, m.liFile)

         IF m.liDeflate<0
            m.liRet=m.liDeflate
            EXIT
         ENDIF 
         
         m.lcBuffer=m.XX002+SYS(2600, m.liOBuffer, m.liDeflate)
         DO WHILE LEN(m.lcBuffer)>254
            m.XX002=LEFT(m.lcBuffer, 254)
            INSERT INTO (m.loPack.cAlias) FROM MEMVAR
            m.lcBuffer=SUBSTR(m.lcBuffer, 255)
         ENDDO
         m.XX002=m.lcBuffer

      ENDDO
      IF LEN(m.XX002)>0
         INSERT INTO (m.loPack.cAlias) FROM MEMVAR
      ENDIF

      =cvp_CloseHandle(m.liFile)
      
      m.loPack.File.PackedSize=CVP_DSZstream(m.liMapZstream)
      m.loPack.File.Packed=1
      
      m.liErr = CVP_DEZstream(m.liMapZstream)
      =CVP_FreeZstream(m.liMapZstream)

      RETURN m.liRet
   ENDPROC
ENDDEFIN