**************************************************************************
** Name: RegAPI.PRG
** Version: 1.0.0
** Date created: 2000-01-08
** Decription: Procedury pro praci s Registry
** Author: Martina Jindrova
** E-mail: jindra@egservis.cz
**

#INCLUDE "RegAPI.h"

*******************************************
* Notice
*******************************************

* values are read and stored in string form
* for REG_SZ the NULL character must be taken into account
* for REG_DWORD it must be assumed that it is stored in binary form expressed by a string
* etc ...

*****************************
* Examples
*****************************

* write string value
**************************
*=RegAPIInit()
*LOCAL liHKEY,liOFlag,lcData
*lcData=SPACE(100)
*?API_RegCreateKeyEx(HKEY_CURRENT_USER,"Software\xxx","REG_SZ",@liHKEY,@liOFlag)
*?API_RegSetValueEx(liHKEY,"test",REG_SZ,"ahoj"+CHR(0))
*?API_RegQueryValueEx(liHKEY,"test",REG_SZ,@lcData,100)
*?API_RegCloseKey(liHKEY)

* writing the integer value
******************
*=RegAPIInit()
*set proced to kernel
*LOCAL liHKEY,liOFlag,liData
*liData="    "
*?API_RegCreateKeyEx(HKEY_CURRENT_USER,"Software\xxx","REG_SZ",@liHKEY,@liOFlag)
*?API_RegSetValueEx(liHKEY,"test",REG_DWORD,BINTOC(100,"RS"))
*?API_RegQueryValueEx(liHKEY,"test",REG_DWORD,@liData,4)
*?API_RegCloseKey(liHKEY)
*set proced to

* Deleting the key
***********************
*?API_RegDeleteKey(HKEY_CURRENT_USER,"Software\MyApp\Settings")
*?API_RegDeleteKey(HKEY_CURRENT_USER,"Software\MyApp")


***************************************************************************************
* initialization of API functions
***************************************************************************************

FUNCTION cvp_RegQueryValueEx(lhKey, lpValueName, lpReserved, lpType, lpData, lpcbData)
 DECLARE LONG RegQueryValueEx IN ADVAPI32.DLL  AS cvp_RegQueryValueEx LONG,STRING @,INTEGER ,INTEGER @,STRING @,INTEGER @
  RETURN cvp_RegQueryValueEx(lhKey, @lpValueName, lpReserved, @lpType, @lpData, @lpcbData)
ENDFUNC

FUNCTION cvp_RegSetValueEx( lhKey, lpValueName, lReserved, ldwType, lpData, lcbData)
 DECLARE INTEGER RegSetValueEx IN ADVAPI32.DLL AS cvp_RegSetValueEx LONG,STRING @,INTEGER,INTEGER,STRING @,INTEGER
 RETURN cvp_RegSetValueEx( lhKey, @lpValueName, lReserved, ldwType, @lpData, lcbData)
ENDFUNC

FUNCTION cvp_RegCreateKeyEx(lhKey, lpSubKey, liReserved, lpClass, ldwOptions, lsamDesired, lpSecurityAttributes, lphkResult, lpdwDisposition)
 DECLARE INTEGER RegCreateKeyEx IN ADVAPI32.DLL AS cvp_RegCreateKeyEx LONG,STRING @,INTEGER,STRING @,INTEGER,INTEGER,INTEGER,LONG@, INTEGER @
 RETURN cvp_RegCreateKeyEx(lhKey, @lpSubKey, liReserved, @lpClass, ldwOptions, lsamDesired, lpSecurityAttributes, @lphkResult, @lpdwDisposition)
ENDFUNC

        
FUNCTION cvp_RegOpenKeyEx(lhKey, lpSubKey, lulOptions, lsamDesired, lphkResult) 
 DECLARE INTEGER RegOpenKeyEx in ADVAPI32.DLL AS cvp_RegOpenKeyEx LONG, STRING @,INTEGER,INTEGER,INTEGER @nKeyHandle 
 RETURN cvp_RegOpenKeyEx(lhKey, @lpSubKey, lulOptions, lsamDesired, @lphkResult) 
ENDFUNC


FUNCTION cvp_RegCloseKey(lhkey)
 DECLARE INTEGER RegCloseKey in ADVAPI32.DLL AS cvp_RegCloseKey LONG
 RETURN cvp_RegCloseKey(lhkey)
ENDFUNC


FUNCTION cvp_RegEnumKeyEx(lhKey, ldwIndex, lpName, lpcName, lpReserved, lpClass, lpcClass, lpftLastWriteTime)
 DECLARE INTEGER RegEnumKeyEx IN ADVAPI32.DLL AS cvp_RegEnumKeyEx LONG,INTEGER,STRING @,INTEGER @,INTEGER,STRING @,INTEGER @,INTEGER @
 RETURN cvp_RegEnumKeyEx(lhKey, ldwIndex, @lpName, @lpcName, lpReserved, @lpClass, @lpcClass, @lpftLastWriteTime)
ENDFUNC


FUNCTION cvp_RegDeleteKey( lhKey, lpSubKey)
 DECLARE INTEGER RegDeleteKey IN ADVAPI32.DLL AS cvp_RegDeleteKey LONG, STRING @
 RETURN cvp_RegDeleteKey( lhKey, @lpSubKey)
ENDFUNC


FUNCTION cvp_RegDeleteValue( lhKey, lpSubKey)
 DECLARE INTEGER RegDeleteValue IN ADVAPI32.DLL AS cvp_RegDeleteValue LONG, STRING @
 RETURN cvp_RegDeleteValue( lhKey, @lpSubKey)
ENDFUNC


FUNCTION cvp_RegEnumValue(lhKey, ldwIndex, lpValueName, lpcchValueName, lpReserved, lpType, lpData, lpcbData)
 DECLARE INTEGER RegEnumValue IN ADVAPI32.DLL AS cvp_RegEnumValue LONG,INTEGER,STRING @,INTEGER @,INTEGER,INTEGER @,STRING @,INTEGER @
 RETURN cvp_RegEnumValue(lhKey, ldwIndex, @lpValueName, @lpcchValueName, lpReserved, @lpType, @lpData, @lpcbData)
ENDFUNC


FUNCTION cvp_RegQueryInfoKey( hKey, lpClass, lpcClass, lpReserved, lpcSubKeys, lpcMaxSubKeyLen, lpcMaxClassLen, lpcValues, lpcMaxValueNameLen, lpcMaxValueLen, lpcbSecurityDescriptor, lpftLastWriteTime)
 DECLARE INTEGER RegQueryInfoKey IN ADVAPI32.DLL AS cvp_RegQueryInfoKey  LONG, STRING @, INTEGER @, INTEGER, INTEGER @, INTEGER @, INTEGER @, INTEGER @, INTEGER @, INTEGER @, INTEGER @, STRING @
 RETURN cvp_RegQueryInfoKey( hKey, @lpClass, @lpcClass, lpReserved, @lpcSubKeys, @lpcMaxSubKeyLen, @lpcMaxClassLen, @lpcValues, @lpcMaxValueNameLen, @lpcMaxValueLen, @lpcbSecurityDescriptor, @lpftLastWriteTime)   
ENDFUNC


***************************************************************************************
* Open key
***************************************************************************************
PROCEDURE API_RegOpenKeyEx
LPARAMETERS m.liHRoot, m.lcKey, m.liHKEY
* liHRoot - ID key's root napr: HKEY_CURRENT_USER
* lcKey   - Key name  exam.: "Software\XXXXX"
*@liHKEY  - Key Handle (output)

LOCAL m.liErr
m.liErr=cvp_RegOpenKeyEx(m.liHRoot, @m.lcKey, 0, SECURITY_ACCESS_MASK, @m.liHKEY)
RETURN IIF(m.liErr=ERROR_SUCCESS, REGAPI_SUCCESS, REGAPI_Other)
ENDPROC

***************************************************************************************
* Create key
***************************************************************************************
PROCEDURE API_RegCreateKeyEx
LPARAMETERS m.liHRoot, m.lcKey, m.lcType, m.liHKEY, m.liOpenFlag
* liHKEY     - Key Handle
* lcKey      - Key name exam.: "Software\XXXXX"
* lcType     - Value tyte
*@liHKEY     - Key Handle (output)
*@liOpenFlag - Flags (output)

LOCAL m.liErr
m.liErr=cvp_RegCreateKeyEx(m.liHRoot, @m.lcKey, 0, @m.lcType, 0, SECURITY_ACCESS_MASK, 0, @m.liHKEY, @m.liOpenFlag)
RETURN IIF(m.liErr=ERROR_SUCCESS, REGAPI_SUCCESS, REGAPI_Other)
ENDPROC


***************************************************************************************
* Close key
***************************************************************************************
PROCEDURE API_RegCloseKey
LPARAMETERS m.liHKEY
* liHKEY  - Key Handle
LOCAL m.liErr
m.liErr=cvp_RegCloseKey(m.liHKEY)
RETURN IIF(m.liErr=ERROR_SUCCESS, REGAPI_SUCCESS, REGAPI_Other)
ENDPROC


***************************************************************************************
* Write value to key
***************************************************************************************
PROCEDURE API_RegSetValueEx
LPARAMETERS m.liHKEY, m.lcValue, m.liType, m.lcData
* liHKEY  - Key Handle
* lcValue - Nazev hodnoty
* liType  - Value tyte
* lcData  - Data buffer

LOCAL m.liErr, m.liReserved, m.liData
m.liReserved=0
m.liData=LEN(m.lcData)

m.liErr=cvp_RegSetValueEx(m.liHKEY ,@m.lcValue, m.liReserved, m.liType, @m.lcData, m.liData)
RETURN IIF(m.liErr=ERROR_SUCCESS, REGAPI_SUCCESS, REGAPI_Other)
ENDPROC

***************************************************************************************
* Read value from key
***************************************************************************************
PROCEDURE API_RegQueryValueEx
LPARAMETERS m.liHKEY, m.lcValue, m.liType, m.lcData, m.liData
* liHKEY  - Key Handle
* lcValue - Value name
* liType  - Value tyte
*@lcData  - Data buffer (output)
* liData  - Size of data buffer

LOCAL m.liErr, m.liReserved
m.liReserved=0
m.liErr=cvp_RegQueryValueEx(m.liHKEY, @m.lcValue, m.liReserved, @m.liType, @m.lcData, @m.liData)
m.lcData=LEFT(m.lcData, m.liData) && orez data
RETURN IIF(m.liErr=ERROR_SUCCESS, REGAPI_SUCCESS, REGAPI_Other)
ENDPROC

***************************************************************************************
* Delete key
***************************************************************************************
PROCEDURE API_RegDeleteKey
LPARAMETERS m.liHKEY, m.lcKey
* liHKEY  - Key Handle
* lcKey   - subkey name exam.: "XXXXX"
LOCAL m.liErr
m.liErr=cvp_RegDeleteKey(m.liHKEY, @m.lcKey)
RETURN IIF(m.liErr=ERROR_SUCCESS, REGAPI_SUCCESS, REGAPI_Other)
ENDPROC

***************************************************************************************
* Delete value
***************************************************************************************
PROCEDURE API_RegDeleteValue
LPARAMETERS m.liHKEY, m.lcValue
* liHKEY  - Key Handle
* lcValue - Value name exam.: "Software\XXXXX\hdonota1"
LOCAL m.liErr
m.liErr=cvp_RegDeleteValue(m.liHKEY, @m.lcValue)
RETURN IIF(m.liErr=ERROR_SUCCESS, REGAPI_SUCCESS, REGAPI_Other)
ENDPROC


***************************************************************************************
* Enumerate keys
***************************************************************************************
PROCEDURE API_RegEnumKeyEx
LPARAMETERS m.liHKEY, m.liIndex, m.lcKey, m.lcClass, m.liTime
* liHKEY  - Key Handle
* liIndex - Index of key
*@lcKey   - Key name (output)
* lcClass - Key class
*@liTime  - Write time (output)

LOCAL m.liErr, m.liKey, m.liClass

m.lcClass=ALLT(m.lcClass)+CHR(0)
m.liClass=LEN(m.lcClass)
m.liKey=LEN(m.lcKey)

m.liErr=cvp_RegEnumKeyEx(m.liHKEY, m.liIndex, @m.lcKey, @m.liKey, 0, @m.lcClass, @m.liClass, @m.liTime)
RETURN m.liErr
ENDPROC


***************************************************************************************
* Enumerate values
***************************************************************************************
PROCEDURE API_RegEnumValue
LPARAMETERS m.liHKEY, m.liIndex, m.lcValue, m.liType, m.lcData
* liHKEY  - Key Handle
* liIndex - Index of value
*@lcValue - Value name (output)
*@liType  - Value type (output)
*@lcData  - Data buffer (output)

LOCAL m.liErr, m.liValue, m.liData

m.liValue=LEN(m.lcValue)
IF PCOUNT()<5 
   IF PCOUNT()<4
      m.liErr=cvp_RegEnumValue(m.liHKEY, m.liIndex, @m.lcValue, @m.liValue, 0, 0, 0, 0)
   ELSE
      m.liErr=cvp_RegEnumValue(m.liHKEY, m.liIndex, @m.lcValue, @m.liValue, 0, @m.liType, 0, 0)
   ENDIF
   m.lcValue=LEFT(m.lcValue, m.liValue)
ELSE
   m.liData=LEN(m.lcData)
   m.liErr=cvp_RegEnumValue(m.liHKEY, m.liIndex, @m.lcValue, @m.liValue, 0, @m.liType, @m.lcData, @m.liData)
   m.lcData=LEFT(m.lcData, m.liData)
ENDIF
RETURN m.liErr
ENDPROC


***************************************************************************************
PROCEDURE API_RegQueryInfoKey
LPARAMETERS m.liHKEY, m.lcClass, m.liSubKeys, m.liMaxSubKeyLen, m.liMaxClassLen,;
            m.liValues, m.liMaxValueNameLen, m.liMaxValueLen, m.liSecurityDescriptor, m.lcDT
* liHKEY               - Key Handle
* lcClass              - class buffer
* liSubKeys            - number of subkeys
* liMaxSubKeyLen       - longest subkey name
* liMaxClassLen        - longest class string
* liValues             - number of value entries
* liMaxValueNameLen    - longest value name
* liMaxValueLen        - longest value data
* liSecurityDescriptor - descriptor length
* lcDT                 - last write time

LOCAL m.liErr, m.liClass, m.liReserved

m.liClass=LEN(m.lcClass)
m.liReserved=0
m.lcDT=REPL(CHR(0),16)

m.liErr=cvp_RegQueryInfoKey(m.liHKEY, @m.lcClass, @m.liClass, m.liReserved, @m.liSubKeys, @m.liMaxSubKeyLen,;
                            @m.liMaxClassLen, @m.liValues, @m.liMaxValueNameLen, @m.liMaxValueLen, @m.liSecurityDescriptor, @m.lcDT)
RETURN IIF(m.liErr=ERROR_SUCCESS, REGAPI_SUCCESS, REGAPI_Other)

ENDPROC
