#INCLUDE "simplyfilter.h"

*****************************************************************************************************
* Definice tdy pro parsovn uivatelskho vrazu a jejho pevodu na vraz pro dan datov zdroj
*****************************************************************************************************
DEFINE CLASS _SIMPLYFILTER AS CUSTOM
   Name="_SIMPLYFILTER"


   DIME aErrorMsg(4) && Pole chybovvh hlek
   aErrorMsg(1)=_PC_ErrMsg_ValueIsNotValid
   aErrorMsg(2)=_PC_ErrMsg_ConditionIsNotValid
   aErrorMsg(3)=_PC_ErrMsg_FieldHasBadType
   aErrorMsg(4)=_PC_ErrMsg_FieldNotExists
   
   Alias=""        && Alias kurzoru pro zsobnk token
   
   cField=""       && Kd poloky
   cType=""        && Datov typ poloky
   cSimpleType=0   && Zjednoduen datov typ poloky
   cAlterType=""   && Alternativn datov typy
   lIsNullable=.F. && Pznak null hodnoty
   lCaseInsensitive=.F. && Hledn textu - ignoruje mal/velk
   lAutoAddAsterisk=.F. && Automatick pidn *
   lReduceAccent=.F. && Automatick odstrann diakritiky
   

   DIME aDateOrdering(3,4) && Pole pro formtovn datumovch hodnot na ODBC canonical tvar
   aDateOrdering(1,1)="7890-12-45" && 0 - MDY
   aDateOrdering(1,2)="78-12-45"
   aDateOrdering(1,3)="5678-12-34" && 0 - MDY Short MMDDYYYY
   aDateOrdering(1,4)="56-12-34"

   aDateOrdering(2,1)="7890-45-12" && 1 - DMY
   aDateOrdering(2,2)="78-45-12"
   aDateOrdering(2,3)="5678-34-12" && 1 - DMY Short
   aDateOrdering(2,4)="56-34-12"

   aDateOrdering(3,1)="1234-67-90" && 2 - YMD
   aDateOrdering(3,2)="12-45-78"
   aDateOrdering(3,3)="1234-56-78" && 2 - YMD Short YYYYMMDD
   aDateOrdering(3,4)="12-34-56"



   iDateOrdering=0          && Poad dne, msce a roku v datumu  (0 - MDY, 1 - DMY, 2 - YMD )
   cDateInterval_Day=""     && Kd intervalu dne
   cDateInterval_Month=""   && Kd intervalu msce 
   cDateInterval_Year=""    &&  Kd intervalu roku
   cDateInterval_Quarter="" &&  Kd intervalu kvartlu
   cDateInterval_Week=""    &&  Kd intervalu tdne
   cDateInterval=", , , , , ,"  && ",D,M,R,Q,T, : ,D,M,Y,Q,W,"
   
   DIME aBoolean(1,3)  && Pole pro uivatelsk vyjden booleovsk hodnoty
   aBoolean(1,1)=_PC_Boolean_Standard  && Kd
   aBoolean(1,2)="T"                   && Ano/Yes
   aBoolean(1,3)="F"                   && Ne/No     
      
   cFieldInClose="[" && Prefix nzvu poloky
   cFieldEnClose="]" && Postfix nzvu poloky
   
   cEmbededField=""  && Kd poloky u kter dolo k chyb


   cDataSource="" && VFP, MSSQL, ORACLE, ACCESS, FIREBIRD, MYSQL
   oDataSource=.NULL. && objekt rozhran

   
   PROCEDURE GetDateFormatString(liDateOrdering,llCentury,llShort) && Vrt formtovac etzec datumu
      * liDateOrdering - Poad dne, msce a roku v datumu viz vlastnost iDateOrdering
      * llCentury      - Pznak stolet
      * llShort        - Pznak krtkho zpisu (bez oddlova)
      RETURN This.aDateOrdering(m.liDateOrdering+1,IIF(m.llCentury AND NOT m.llShort,1,IIF(NOT m.llCentury AND NOT m.llShort,2,IIF(m.llCentury AND m.llShort,3,4))))
   ENDPROC

   PROCEDURE AddBoolean(liID,lcTrue,lcFalse) && Pid uivatelsk vyjden booleovsk hodnoty
      * liID    - Id vyjden
      * lcTrue  - Vyjden pro .T.
      * lcFalse - Vyjden pro .F.
      LOCAL liRow
      liRow=ASCAN(This.aBoolean,m.liID,1,-1,1,8)
      IF liRow=0
         liRow=ALEN(This.aBoolean,1)+1
         DIME This.aBoolean(m.liRow,ALEN(This.aBoolean,2))
         This.aBoolean(m.liRow,1)=m.liID
      ENDIF
      
      This.aBoolean(m.liRow,2)=m.lcTrue
      This.aBoolean(m.liRow,3)=m.lcFalse
   ENDPROC


   PROCEDURE RemoveBoolean(liID) && Odstran uivatelsk vyjden booleovsk hodnoty
      * liID    - Id vyjden
      LOCAL liRow
      liRow=ASCAN(This.aBoolean,m.liID,1,-1,1,8)
      IF m.liRow>0
         IF ALEN(This.aBoolean,1)>1
            =ADEL(This.aBoolean,m.liRow)
            DIME This.aBoolean(ALEN(This.aBoolean,1)-1,ALEN(This.aBoolean,2))
         ENDIF   
      ENDIF
      
   ENDPROC

   PROCEDURE cDataSource_ASSIGN(lcValue) && Intern metoda piazen hodnoty vlastnosti cDataSource
      * lcValue - Hodnota vlastnosti
      
      This.oDataSource=.NULL.
      This.oDataSource=CREATEOBJECT("_SF_DS_"+m.lcValue) && instance tdy pro generovn podmnek
      This.cDataSource=m.lcValue
   ENDPROC
 
         
   PROCEDURE cDateInterval_Day_ASSIGN(lcValue) && Intern metoda piazen hodnoty vlastnosti cDateInterval_Day
      This.cDateInterval_Day=m.lcValue
      * Generovn vlastnosti cDateInterval
      This.BuildDateInterval(_PC_DateInterval_D,m.lcValue)
   ENDPROC
   PROCEDURE cDateInterval_Month_ASSIGN(lcValue) && Intern metoda piazen hodnoty vlastnosti cDateInterval_Mont
      This.cDateInterval_Month=m.lcValue
      * Generovn vlastnosti cDateInterval
      This.BuildDateInterval(_PC_DateInterval_M,m.lcValue)
   ENDPROC
   PROCEDURE cDateInterval_Year_ASSIGN(lcValue) && Intern metoda piazen hodnoty vlastnosti cDateInterval_Year
      This.cDateInterval_Year=m.lcValue
      * Generovn vlastnosti cDateInterval
      This.BuildDateInterval(_PC_DateInterval_Y,m.lcValue)
   ENDPROC
   PROCEDURE cDateInterval_Quarter_ASSIGN(lcValue) && Intern metoda piazen hodnoty vlastnosti cDateInterval_Quarter
      This.cDateInterval_Quarter=m.lcValue
      * Generovn vlastnosti cDateInterval
      This.BuildDateInterval(_PC_DateInterval_Q,m.lcValue)
   ENDPROC
   PROCEDURE cDateInterval_Week_ASSIGN(lcValue) && Intern metoda piazen hodnoty vlastnosti cDateInterval_Week
      This.cDateInterval_Week=m.lcValue
      * Generovn vlastnosti cDateInterval
      This.BuildDateInterval(_PC_DateInterval_W,m.lcValue)
   ENDPROC
   
   PROCEDURE BuildDateInterval(liIndex,lcValue) && Generovn vlastnosti cDateInterval
      * liIndex - Index kdu intervalu
      * lcValue - Kd intervalu
      This.cDateInterval=STUFF(This.cDateInterval,m.liIndex*2,1,m.lcValue)
   ENDPROC
   
   PROCEDURE GetDateInterval(liIndex) && Vrt kd datumovho intervalu
      RETURN SUBSTR(This.cDateInterval,m.liIndex*2,1)
   ENDPROC

   PROCEDURE GetSimpleTypeIndex(lcType) && Vrt index zjednoduenho typu poloky
      RETURN IIF(_PC_SimplyType_N==m.lcType,1,;
             IIF(_PC_SimplyType_C==m.lcType,2,;
             IIF(_PC_SimplyType_D==m.lcType,3,;
             IIF(_PC_SimplyType_T==m.lcType,4,;
             IIF(_PC_SimplyType_L==m.lcType,5,6)))))
   ENDPROC

   PROCEDURE iDateOrdering_ASSIGN(liDateOrdering) && Intern metoda piazen hodnoty vlastnosti iDateOrdering
      This.iDateOrdering=m.liDateOrdering
   ENDPROC

   PROCEDURE GetCentury(lcValue) && Vra z datumov hodnoty rok
      * lcValue - Datum v textov prezentaci 
      LOCAL liYear
      liYear=VAL(IIF(INLIST(This.iDateOrdering,0,1),RIGHT(m.lcValue,2),LEFT(m.lcValue,2)))
      RETURN STR(SET("CENTURY",1)+IIF(m.liYear<SET("CENTURY",2),1,0),2)
   ENDPROC

   PROCEDURE Destroy() && 
      * Uklizen pouvanch zdroj
      IF NOT EMPTY(This.Alias) AND USED(This.Alias)
         USE IN (This.Alias)
      ENDIF   
   ENDPROC

   PROCEDURE Init() && Inicializace objektu

      This.iDateOrdering=SET("DATE",1)
      
      * Vytvoen iternho kurzoru pro rozparsovan data
      This.Alias=SYS(2015)
      CREATE CURSOR (This.Alias) (XX000 I,XX001 M, XX002 C(2), XX003 M, XX004 L)

      * Vchoz nastaven kd datumovch interval (esk varianta)
      This.cDateInterval_Day="D"     &&
      This.cDateInterval_Month="M"   &&
      This.cDateInterval_Year="R"    && 
      This.cDateInterval_Quarter="Q" && 
      This.cDateInterval_Week="T"    && 
      
      * Vchoz nastaven datov zdroj
      This.cDataSource="VFP"
   ENDPROC
   
   PROCEDURE NormalizeValue(lcType,lcSource) && Provede normalizaci hodnoty
      * lcType   - Typ zdrojov poloky
      * lcSource - Vraz
   
      * textov pole je vdy uvozeno ' ' pokud obsahuje &,|,>,<,=,..' a znak ' je zdvojen
      IF INLIST(m.lcType,"C","V","M")
         IF AT("'",m.lcSource)>0
            lcSource=STRTRAN(m.lcSource,"'","''")
         ENDIF
         IF AT("&",m.lcSource)>0 OR AT("|",m.lcSource)>0 OR AT(">",m.lcSource)>0 OR ;
            AT(">",m.lcSource)>0 OR AT("=",m.lcSource)>0 OR AT("'",m.lcSource)>0 OR AT("..",m.lcSource)>0 OR ;
            AT("+",m.lcSource)>0 OR AT("-",m.lcSource)>0 OR AT("*",m.lcSource)>0 OR AT("/",m.lcSource)>0
            lcSource="'"+m.lcSource+"'"
         ENDIF   
      ENDIF
      RETURN m.lcSource
   ENDPROC

   PROCEDURE Formalize(lcField,llIsNullable, lcSource, lcType, lcOut, llCaseInsensitive, llAutoAddAsterisk, llReduceAccent) && Formalizovn uivatelem zadanho vrazu na podmnku
      * lcField           - Nzev poloky
      * llIsNullable      - Pznak NULL hodnoty
      * lcSource          - Zdroj uivatleskho vrazu
      * lcType            - Typ poloky
      *@lcOut             - Vygenerovan podmnka
      * llCaseInsensitive - Hledn textu - ignoruje mal/velk
      * llAutoAddAsterisk - Automatick pidn */%
      * llReduceAccent    - Odstrann diakritiky
      
      * textov pole me bt uvozeno znaky ' a '
      * textov pole je vdy uvozeno ' ' pokud obsahuje &,|,>,<,=,' a znak ' je zdvojen
      LOCAL lcTest,liErr,liSele
      LOCAL ARRAY laSeparators(1)
      liSele=SELE()
      SELE (This.Alias)
      ZAP
      
      STORE "" TO lcOut,lcTest

      
      m.lcField=IIF(llCaseInsensitive, STRTRAN(This.oDataSource.cCaseInsensitive,"%VAL%",m.lcField), m.lcField)
      m.lcField=IIF(llReduceAccent, STRTRAN(This.oDataSource.cReduceAccent,"%VAL%",m.lcField), m.lcField)

      * Nastaven informac o zpracovvan poloce
      This.SetFieldInfo(m.lcField,m.llIsNullable, m.lcType, llCaseInsensitive, llAutoAddAsterisk, llReduceAccent)

      * Nastaven validnch token dle datovho typu
      DO CASE
         CASE This.cType="L"
              =ALINES(m.laSeparators,"( ) & | = ..",0," ")

         CASE INLIST(This.cType,"C","V","M")
              =ALINES(m.laSeparators,"( ) & | < <> <= > >= = ..",0," ")
     
         CASE INLIST(This.cType,"D","T")
              =ALINES(m.laSeparators,"( ) & | < <> <= > >= = .. + -",0," ")

         OTHERWISE
              =ALINES(m.laSeparators,"( ) & | < <> <= > >= = .. + - * /",0," ")

      ENDCASE

      This.oDataSource.oParser=This

      * Parsovn vrazu na jednotliv sti
      liErr=This.Parse(@m.lcSource,@m.laSeparators)
      IF m.liErr=_PC_OK

         * Vytven konenho vrazu
         liErr=This.Build(@m.lcOut,@m.lcTest)
         IF m.liErr=_PC_OK
          
            * Kontrola vytvoenho vrazu 
            liErr=This.oDataSource.CheckExpression(@m.lcTest)
         ENDIF
      ENDIF
      This.oDataSource.oParser=.NULL.

      SELE (m.liSele)
      RETURN m.liErr
   ENDPROC
   


   PROCEDURE SetFieldInfo(lcField,llIsNullable, lcType, llCaseInsensitive, llAutoAddAsterisk, llReduceAccent) && Nastaven informac o zpracovvan poloce
      * lcField      - Nzev poloky
      * llIsNullable - Pznak NULL hodnoty
      * lcType       - Typ poloky
      * llCaseInsensitive - Hledn textu - ignoruje mal/velk
      * lAutoAddAsterisk  - Automatick pidn */%
      * llReduceAccent    - Odstrann diakritiky

      This.cField=m.lcField
      This.cType=m.lcType
      This.lIsNullable=m.llIsNullable
      This.lCaseInsensitive=llCaseInsensitive
      This.lAutoAddAsterisk=llAutoAddAsterisk
      This.lReduceAccent=llReduceAccent
      
      * Nastaven Alternativnch datovch typ
      DO CASE
         
         CASE INLIST(This.cType,"Y","B","I","N","F")
              This.cAlterType=""
              This.cSimpleType=_PC_SimplyType_N

         CASE INLIST(This.cType,"C","V","M")
              This.cAlterType=""
              This.cSimpleType=_PC_SimplyType_C
                   
         CASE This.cType="D" OR This.cType="T"
              This.cAlterType=",N,DI,"
              This.cSimpleType=IIF(This.cType="D",_PC_SimplyType_D,_PC_SimplyType_T)

         CASE This.cType="L"
              This.cAlterType=""
              This.cSimpleType=_PC_SimplyType_L

      ENDCASE

   
   ENDPROC

   PROTECTED PROCEDURE Parse(lcSource, laSeparators) && Parsovn uivatelskho vrazu
      * lcSource     - Vraz kter se m parsovat
      * laSeparators - Pole validnch token

      LOCAL lcSep,lii,llCompare,lcValue,liErr,llField,lcType,llEmtyValue
      lii=1
      llCompare=.T.
      lcType=""

      * Prochz se vraz token po tokenu a zpracovvaj se jednotliv opertory a hodnoty
      * Hodnoty se konvertuj na validn textov zpis pro clov datov zdroj

      DO WHILE m.lii>0
         lii=This.FindToken(m.lcSource,@m.laSeparators,1,LEN(m.lcSource),@m.lcSep)
         lcValue=""

         * najdi prvn token
         DO CASE
            CASE m.lii=0
                 lcValue=ALLTRIM(m.lcSource) && [,<,>,<=,>=,=,<>,]
                 IF m.llCompare
                    INSERT INTO (This.Alias) (XX000,XX001,XX002,XX003) VALUES (_PC_TokenType_Operator,"=","","")
                    llCompare=.F.
                 ENDIF

            CASE RECNO()=1 AND m.lii>0 AND  ATC(","+m.lcSep+",",[,(,),<,>,<=,>=,=,<>,..,])=0  && EMPTY(SUBSTR(m.lcSource,1,vlii-1)) AND
                 lcValue=ALLT(SUBSTR(m.lcSource,1,m.lii-1))
                 IF m.llCompare
                    INSERT INTO (This.Alias) (XX000,XX001,XX002,XX003) VALUES (_PC_TokenType_Operator,"=","","")
                    llCompare=.F.
                 ENDIF

            OTHERWISE
                 lcValue=ALLTRIM(SUBSTR(m.lcSource,1,m.lii-1))

         ENDCASE

         IF ATC(m.lcSep,"&|")>0 && pi AND nebo OR opt nastav vchoz porovnn
            llCompare=.T.
         ENDIF
         IF ATC(","+m.lcSep+",",[,<,>,<=,>=,=,<>,..,])>0 && kdy se porovnv, zru to
            llCompare=.F.
         ENDIF

         IF LEN(m.lcValue)>0
            * kontrola a konverze hodnoty
            liErr=This.ConvertValue(@m.lcValue,@m.llField,@m.lcType,@m.llEmtyValue)
            IF m.liErr<>_PC_OK
               RETURN liErr
            ENDIF
            
            IF INLIST(This.cType,"C","V","M")
               m.lcValue=IIF(This.lCaseInsensitive, UPPER(m.lcValue), m.lcValue)
               m.lcValue=IIF(This.lReduceAccent, STRCONV(STRCONV(m.lcValue,9),11,1251,1), m.lcValue)
            ENDIF
 
            INSERT INTO (This.Alias) (XX000,XX001,XX002,XX003,XX004) VALUES (IIF(m.llField,_PC_TokenType_Field,_PC_TokenType_Value),m.lcValue,m.lcType,IIF(m.llField,This.oDataSource.aIE(This.GetSimpleTypeIndex(This.cSimpleType),3),m.lcValue),m.llEmtyValue)
            lcType=This.cSimpleType
         ENDIF   
            
         IF LEN(m.lcSep)>0
            INSERT INTO (This.Alias) (XX000,XX001,XX002,XX003,XX004) VALUES (_PC_TokenType_Operator,m.lcSep,"","",.F.)
         ENDIF
       
         lcSource=SUBSTR(m.lcSource,m.lii+LEN(m.lcSep))
      ENDDO

      RETURN _PC_OK
   ENDPROC

   PROTECTED PROCEDURE Build(lcOut,lcTest) && Tvorba vsledn podmnky
      *@lcOut  - Vstupn vraz
      *@lcTest - Vraz pro kontrolu validity
      
      * Projdi opertory a najdi sekvence ( a ) kter obsahuj pouze opertory +-*/[]
      * ty lze automaticky zkonvertovat na vyjden jednou hodnotou
      * pebyten vty se z internho kurzoru smaou
      * Nakonec se provede sloen vrazu ze zbylch vt internho kurzoru
      LOCAL liLevel,lcDele
      PRIVATE liRecno,liRecnoE
      
      SELE (This.Alias)
      INDEX ON XX000 TAG "I01"  
      SET KEY TO _PC_TokenType_Operator
      GO TOP
      DO WHILE !EOF()
         IF NOT XX001=="("
            SKIP 1
            LOOP
         ENDIF   
      
         liRecno=RECNO()
         liRecnoE=0
      
         * najdi dal
         liLevel=0
         SKIP 1
         DO WHILE !EOF()
            IF ATC(","+XX001+",",[,+,-,*,/,(,),])=0
               EXIT
            ENDIF

            IF XX001=="("
               liLevel=m.liLevel+1
            ENDIF
            
            IF XX001==")"
               IF m.liLevel=0
                  liRecnoE=RECNO()
                  EXIT
               ELSE   
                  liLevel=m.liLevel-1
               ENDIF   
            ENDIF   
            SKIP 1
         ENDDO
         
         GO (m.liRecno)
         IF m.liRecnoE=0 && je tam njak nepovolen opertor, vyhledej dal (
         ENDIF
         
         IF m.liRecnoE>0 && nael ukonujc zvorku, zpracuj obsah
            SET KEY TO
            SET ORDER TO
            SET FILTER TO BETWEEN(RECNO(),m.liRecno,m.liRecnoE)
            STORE "" TO lcOut,lcTest
            
            liErr=This.BuildPart(@m.lcOut,@m.lcTest,.F.)
            SET FILTER TO 
            IF m.liErr<>_PC_OK
               RETURN m.liErr
            ENDIF
            
            GO (m.liRecno)
            REPL XX000 WITH _PC_TokenType_Value, XX001 WITH m.lcOut, XX002 WITH This.cType, XX003 WITH m.lcTest && je to hodnota
            SKIP 1
            DELE NEXT (m.liRecnoE-m.liRecno) && sma nepotebn vty
            SET ORDER TO "I01"
            SET KEY TO _PC_TokenType_Operator
            GO (m.liRecnoE)
            
         ENDIF

         SKIP 1
      ENDDO
      SET KEY TO
      SET ORDER TO

      lcDele=SET("DELETED")
      SET DELETED ON
      
      STORE "" TO lcOut,lcTest    
      liErr=This.BuildPart(@m.lcOut,@m.lcTest,.T.)
      SET DELETED &lcDele.
      
      RETURN m.liErr
   ENDPROC

   PROTECTED PROCEDURE BuildPart(lcOut,lcTest,llCompare) && Intern metoda pro vytvoen vrazu
      LOCAL lcBase,llLoop,lii,liSTI,llEV,;
            lcArg1,lcArg2,lcType1,lcType2,lcOperator,lcDI,;
            liXX000_1,liXX000_2,lcXX003_1,lcXX003_2,lcField, loRamF,loRamS,loRamX

      liSTI=This.GetSimpleTypeIndex(This.cSimpleType)
      lcBase=This.oDataSource.aIE(m.liSTI,3)
      
      This.oDataSource.iSTI=m.liSTI
      This.oDataSource.cField=This.cField
      This.oDataSource.cBase=m.lcBase

      STORE IIF(This.lIsNullable,This.oDataSource.xNVL(),This.cField) TO This.oDataSource.cField,lcField

      * Prochzej se jednotliv tokeny a zpracovvaj se
      * zjituj se tak vjimky kter maj vliv na zpracovn token
      *  - detekce intervalu
      *  - detekce porovnn s przdnou hodnotou
      *  - porovnn textov hodnoty
      *
      * Podle  zjitnch token (opertory, konstany atd)
      * se provd konverze na vraz dle danho datovho zdroje
      
      SELE (This.Alias)
      GO TOP
      
      DO WHILE !EOF()
         SCATTER NAME loRamF MEMO
           
         * detekce intervalu
         IF m.loRamF.XX000<>_PC_TokenType_Operator
            SKIP 1
            IF NOT XX001==".." && detekce zda se nem pidat automaticky =
               IF m.llCompare && emuluj porovnn
                  loRamF.XX000=_PC_TokenType_Operator
                  loRamF.XX001="="
                  SKIP -1
               ENDIF
            ENDIF
            SKIP -1
         ENDIF


          * Detekce EmptyValue u nsledujc hodnoty (jen pro C,M)
         IF m.loRamF.XX000=_PC_TokenType_Operator AND INLIST(This.cType,"C","V","M")
            SKIP +1
            llEV=XX004
            SKIP -1
         ENDIF
           
                 
         IF m.loRamF.XX000=_PC_TokenType_Operator
            IF ATC(m.loRamF.XX001,"&|")>0 && pi AND nebo OR opt nastav vchoz porovnn
               llCompare=.T.
            ENDIF
            IF ATC(","+m.loRamF.XX001+",",[,<,>,<=,>=,=,<>,..,])>0 && kdy se porovnv, zru to
               llCompare=.F.
            ENDIF
         
            llLoop=.F.

            DO CASE
               CASE ATC(","+m.loRamF.XX001+",",[,|,&,(,),+,-,*,/,])>0
                    lcOut=m.lcOut+IIF(m.loRamF.XX001=="&"," AND ", IIF(m.loRamF.XX001=="|"," OR ",m.loRamF.XX001))
                    lcTest=m.lcTest+IIF(m.loRamF.XX001=="&"," AND ", IIF(m.loRamF.XX001=="|"," OR ",m.loRamF.XX001))
                    llLoop=.T.

               CASE ATC(","+m.loRamF.XX001+",",[,<,>,<=,>=,=,<>,])>0 AND NOT INLIST(This.cType,"C","V","M","L")
                    lcOut=m.lcOut+m.lcField+m.loRamF.XX001
                    lcTest=m.lcTest+m.lcBase+m.loRamF.XX001
                    llLoop=.T.

               CASE NOT m.loRamF.XX001=="=" AND INLIST(This.cType,"C","V","M") OR m.llEV && kdy se NEporovnv, vlo pole
                    lcOut=m.lcOut+m.lcField+m.loRamF.XX001
                    lcTest=m.lcTest+m.lcBase+m.loRamF.XX001
                    llLoop=.T.
            ENDCASE

            IF m.llLoop
               IF NOT BOF()
                  SKIP 1
               ENDIF
               LOOP
            ENDIF   
         ENDIF   
          
         IF NOT BOF()
            SKIP 1
         ENDIF

         This.oDataSource.oRamF=m.loRamF
            
         DO CASE
            * Interval
            CASE XX001==".." 
                 SKIP 1
                 SCATTER NAME loRamS MEMO
                 This.oDataSource.oRamS=m.loRamS
                 
                 This.oDataSource.xBetween() 
                 lcOut= m.lcOut +This.oDataSource.cOut
                 lcTest=m.lcTest+This.oDataSource.cTest

            * Datumov hodnoty
            CASE INLIST(This.cSimpleType,"D","T") AND (XX001=="+" OR XX001=="-")
                 lcOperator=XX001
                 This.oDataSource.cOperator=m.lcOperator
                 
                 SKIP 1
                 SCATTER NAME loRamS MEMO

                 IF INLIST(m.loRamF.XX002,"D ","T ") AND (m.loRamS.XX002=="DI" OR m.loRamS.XX002=="N ")
                    * prvn je hodnota/poloka a pak interval
                 ELSE
                    * prvn je interval a pak hodnota/poloka
                    loRamX=m.loRamF
                    loRamF=m.loRamS
                    loRamS=m.loRamX
                    loRamX=.NULL.
                 ENDIF

                 This.oDataSource.oRamF=m.loRamF
                 This.oDataSource.oRamS=m.loRamS

                 * dal hodnota me bt DI nebo N, nD je rovno N
                 IF m.loRamS.XX002=="N "
                    loRamS.XX001=m.loRamS.XX001
                    loRamS.XX003=m.loRamS.XX003
                    lcDI="D"
                 ELSE
                    lcDI=RIGHT(m.loRamS.XX001,1)
                    loRamS.XX001=LEFT(m.loRamS.XX001,LEN(m.loRamS.XX001)-1)
                    loRamS.XX003=LEFT(m.loRamS.XX003,LEN(m.loRamS.XX003)-1)
                 ENDIF   
                    
                 DO CASE
                    CASE m.lcDI=This.GetDateInterval(_PC_DateInterval_D)
                         This.oDataSource.xDateAddDay() 
                         
                    CASE m.lcDI=This.GetDateInterval(_PC_DateInterval_W)
                         This.oDataSource.xDateAddWeek() 
                         
                    CASE m.lcDI=This.GetDateInterval(_PC_DateInterval_M)
                         This.oDataSource.xDateAddMonth() 

                    CASE m.lcDI=This.GetDateInterval(_PC_DateInterval_Q)
                         This.oDataSource.xDateAddQuarter() 
                         
                    CASE m.lcDI=This.GetDateInterval(_PC_DateInterval_Y)
                         This.oDataSource.xDateAddYear() 
                            
                 ENDCASE
                 lcOut= m.lcOut +This.oDataSource.cOut
                 lcTest=m.lcTest+This.oDataSource.cTest

            * ist porovnn etzc
            CASE m.loRamF.XX001=="=" AND INLIST(This.cType,"C","V","M")
                 SCATTER NAME loRamS MEMO
                 This.oDataSource.oRamS=m.loRamS

                 This.oDataSource.xLike() 
                 lcOut= m.lcOut +This.oDataSource.cOut
                 lcTest=m.lcTest+This.oDataSource.cTest


            * Porovnn logick hodnoty
            CASE m.loRamF.XX001=="=" AND This.cType=="L"
                 SCATTER NAME loRamS MEMO
                 This.oDataSource.oRamS=m.loRamS

                 This.oDataSource.xBoolean() 
                 lcOut= m.lcOut +This.oDataSource.cOut
                 lcTest=m.lcTest+This.oDataSource.cTest

            * Ostatn ppady
            OTHERWISE
                 SCATTER NAME loRamS MEMO
                 SKIP -1
                 This.oDataSource.oRamS=m.loRamS

                 This.oDataSource.xOther() 
                 lcOut= m.lcOut +This.oDataSource.cOut
                 lcTest=m.lcTest+This.oDataSource.cTest

         ENDCASE
         SKIP 1
      ENDDO
      RETURN _PC_OK
   ENDPROC


   PROTECTED PROCEDURE FindToken(lcSource,laOdd,liStart,liEnd,lcSep) && Nalezen tokenu v etzci
      *@lcSource  - Zdrojov etzec
      *@laOdd     - Seznam token
      * liStart   - Startovac pozice pro hledn
      * liEnd     - Konen pozice pro hledn
      *@lcSep     - Nalezen token

      * etzec se prochz tak dlouho, dokud se nenajde aspo jeden token ze seznamu
      * Nvratov hodnota obsahuje pozici tokenu v etzci

      LOCAL liFlag,lcChar,liSP
      LOCAL ARRAY laSP(20)
      lcChar=SUBS(m.lcSource,m.liStart,1)
      liFlag=IIF(m.lcChar="'",1,IIF(m.lcChar=This.cFieldInClose,2,0))
      lcSep=""
      liSP=0

      IF m.liFlag>0
         liSP=m.liSP+1
         IF m.liSP>ALEN(m.laSP)
            DIME m.laSP(m.liSP+10)
         ENDIF
         laSP(m.liSP)=m.liFlag
      ENDIF

      DO WHILE m.liStart<=m.liEnd
         IF m.liFlag=0 
            IF ASCAN(m.laOdd,m.lcChar+SUBS(m.lcSource,m.liStart+1,1),1,-1,1,4)>0
               lcSep=m.lcChar+SUBS(m.lcSource,m.liStart+1,1) && zapamatuj si jak to byl oddlova
               RETURN m.liStart
            ENDIF
            IF ASCAN(m.laOdd,m.lcChar,1,-1,1,6)>0
               lcSep=m.lcChar && zapamatuj si jak to byl oddlova
               RETURN m.liStart
            ENDIF
         ENDIF

         liStart=m.liStart+1 && Inkrementuj ta
         lcChar=SUBS(m.lcSource,m.liStart,1) && Nati dal znak

         IF m.liFlag>0
            IF m.liFlag=1 AND m.lcChar="'"
               liFlag=IIF(m.liSP<2,0,m.laSP(m.liSP-1))
               laSP(m.liSP)=.NULL.
               liSP=MAX(m.liSP-1,0)
            ELSE
               IF m.liFlag=2 AND m.lcChar=This.cFieldEnClose
                  liFlag=IIF(m.liSP<2,0,m.laSP(m.liSP-1))
                  laSP(m.liSP)=.NULL.
                  liSP=MAX(m.liSP-1,0)
               ENDIF
            ENDIF
         ELSE
            IF m.lcChar="'"
               liFlag=1
               liSP=m.liSP+1
               IF m.liSP>ALEN(m.laSP)
                  DIME m.laSP(m.liSP+10)
               ENDIF
               laSP(m.liSP)=m.liFlag
            ENDIF

            IF m.lcChar=This.cFieldInClose
               liFlag=2
               liSP=m.liSP+1
               IF m.liSP>ALEN(m.laSP)
                  DIME m.laSP(m.liSP+10)
               ENDIF
               laSP(m.liSP)=m.liFlag
            ENDIF
         ENDIF
      ENDDO
      RETURN 0 && Vra, e nic nenael
   ENDPROC

   PROCEDURE ConvertValue(lcValue,llField,lcType,llEmptyValue) && Konverze textov zadan hodnoty na platn vyjden
      * lcValue      - Hodnota v textov prezentaci
      *@llField      - Pznak zda hodnota byla zkonvertovna na poloku
      * lcType       - Datov typ hodnoty
      *@llEmptyValue - Pznak zda zadan hodnota byla detekovna jako przdn

      * Provede konverzi uivatelskho zpisu hodnoty na lidn textovou prezentaci
      *  dle typu hodnoty, pznaku przdn hodnoty atd.
      * Pokud se konverze nezdaila a datov poloky se  neli od typu hodnoty  
      * (datum + slo/datumov interval, datum a as + slo/datumov interval)
      *  provede se detekce typu a nsledn konverze
      
      LOCAL lcPom,llValid,lcI,lcE,llF,liRet,lii,liRow,llShort,lcFormat
      IF EMPTY(m.lcType)
         lcType=This.cSimpleType
      ENDIF

      lii=This.GetSimpleTypeIndex(m.lcType)
      lcI=This.oDataSource.aIE(m.lii,1)
      lcE=This.oDataSource.aIE(m.lii,2)
      llField=.F.
      llEmptyValue=m.lcValue==['']

      DO CASE
         * Detekovn nzev poloky
         CASE LEFT(m.lcValue,1)==This.cFieldInClose AND RIGHT(m.lcValue,1)==This.cFieldEnClose
              * jmno pevst na kd
              liRet=This.FieldNameToCode(@m.lcValue)
              IF m.liRet<>_PC_OK
                 This.cEmbededField=m.lcValue
                 RETURN m.liRet
              ENDIF
              STORE "" TO lcI,lcE
              STORE .T. TO llF,llField
         
         * Numerick hodnoty
         CASE ATC(","+m.lcType+",",",Y,B,I,N,F,")>0
              * kontrola hodnoty
              IF m.llEmptyValue
                 lcValue=This.oDataSource.aIE(This.GetSimpleTypeIndex(This.cSimpleType),3)
              ELSE   
                 lcPom=CHRTRAN(m.lcValue,',','.')
                 llValid=TYPE(m.lcPom)=="N"
              ENDIF
                     

         * Textov hodnoty
         CASE ATC(","+m.lcType+",",",C,V,M,")>0
              * kontrola zda hodnota neobsahuje lich poet '
              llValid=OCCURS("'",m.lcValue)%2=0

              IF m.llValid 
                 IF m.llEmptyValue
                    lcPom=This.oDataSource.aIE(This.GetSimpleTypeIndex(This.cSimpleType),3)
                    STORE "" TO lcI,lcE
                 ELSE   
                    lcPom=STRTRAN(m.lcValue+IIF(This.lAutoAddAsterisk, This.oDataSource.cAutoAddAsterisk, ""),"'",['+"'"+'])
                 ENDIF
              ENDIF
             
         * Datumov hodnoty
         CASE m.lcType=="D"
              IF m.llEmptyValue
                 lcPom=This.oDataSource.aIE(This.GetSimpleTypeIndex(This.cSimpleType),3)
                 STORE "" TO lcI,lcE
                 llValid=.T.
              ELSE  
                 * otestuj zda tam jsou oddlovae
                 llShort=LEN(CHRTRAN(m.lcValue,"1234567890",""))=0
                 llCentury=LEN(m.lcValue)=8 AND m.llShort OR LEN(m.lcValue)=10 AND NOT m.llShort
                 lcFormat=This.GetDateFormatString(This.iDateOrdering,m.llCentury,m.llShort)
                 
                 DO CASE
                    CASE NOT m.llCentury AND m.llShort
                         lcPom=This.GetCentury(m.lcValue)+CHRTRAN(m.lcFormat,"123456",m.lcValue)
                         llValid=NOT EMPTY(CTOD("^"+m.lcPom))

                    CASE m.llCentury AND m.llShort
                         lcPom=CHRTRAN(m.lcFormat,"12345678",m.lcValue)
                         llValid=NOT EMPTY(CTOD("^"+m.lcPom))

                    CASE NOT m.llCentury AND NOT m.llShort
                         lcPom=This.GetCentury(m.lcValue)+CHRTRAN(m.lcFormat,"12345678",m.lcValue)
                         llValid=NOT EMPTY(CTOD("^"+m.lcPom))

                    CASE m.llCentury AND NOT m.llShort
                         lcPom=CHRTRAN(m.lcFormat,"1234567890",m.lcValue)
                         llValid=NOT EMPTY(CTOD("^"+m.lcPom))
                         
                    OTHERWISE
                         llValid=.F.
                 ENDCASE
              ENDIF

         * Datumov hodnoty s asem (datetime)
         CASE m.lcType=="T"
              IF m.llEmptyValue
                 lcPom=This.oDataSource.aIE(This.GetSimpleTypeIndex(This.cSimpleType),3)
                 STORE "" TO lcI,lcE
                 llValid=.T.
              ELSE   
                 * otestuj zda tam jsou oddlovae
                 llShort=LEN(CHRTRAN(m.lcValue,"1234567890",""))=0
                 llCentury=LEN(m.lcValue)=14 AND m.llShort OR LEN(m.lcValue)=19 AND NOT m.llShort
                 lcFormat=This.GetDateFormatString(This.iDateOrdering,m.llCentury,m.llShort)

                 DO CASE
                    CASE NOT m.llCentury AND m.llShort
                         lcPom=This.GetCentury(LEFT(m.lcValue,6))+CHRTRAN(m.lcFormat,"123456",m.lcValue)+" "+CHRTRAN("12:34:56","123456",RIGHT(m.lcValue,6))
                         llValid=NOT EMPTY(CTOT("^"+m.lcPom))

                    CASE m.llCentury AND m.llShort
                         lcPom=CHRTRAN(m.lcFormat,"12345678",m.lcValue)+" "+CHRTRAN("12:34:56","123456",RIGHT(m.lcValue,6))
                         llValid=NOT EMPTY(CTOT("^"+m.lcPom))

                    CASE NOT m.llCentury AND NOT m.llShort
                         lcPom=This.GetCentury(LEFT(m.lcValue,8))+CHRTRAN(m.lcFormat,"12345678",m.lcValue)+RIGHT(m.lcValue,9)
                         llValid=NOT EMPTY(CTOT("^"+m.lcPom))

                    CASE m.llCentury AND NOT m.llShort
                         lcPom=CHRTRAN(m.lcFormat,"1234567890",m.lcValue)+RIGHT(m.lcValue,9)
                         llValid=NOT EMPTY(CTOT("^"+m.lcPom))

                    OTHERWISE
                         llValid=.F.
                 ENDCASE
              ENDIF   

         * Logick hodnoty
         CASE m.lcType=="L"
              liRow=ASCAN(This.aBoolean,m.lcValue,1,-1,2,15)
              IF m.liRow=0
                 liRow=ASCAN(This.aBoolean,m.lcValue,1,-1,3,15)
                 lcPom="F"
              ELSE
                 lcPom="T"
              ENDIF   
              llValid=m.liRow>0 && me bt T nebo F, ekvivalenty A(no)/N(e) nebo Y(es)/N(o)

         * Datumov interval 
         CASE m.lcType=="DI"
              * kontrola na interval datumu
              * hodnota se se kld ze dvou st, sla a uren typu intervalu
              * nX
              IF ATC(","+RIGHT(m.lcValue,1)+",",This.cDateInterval)=0
                 llValid=.F. && chyba
              ELSE
                 RETURN This.ConvertValue(LEFT(m.lcValue,LEN(m.lcValue)-1),.F.,"N",@m.llEmptyValue)
              ENDIF
                  
      ENDCASE


      IF NOT m.llValid AND m.lcType==This.cType
         * kontrola datovho typu
         lcType=TYPE(m.lcValue)

         * test zda to nen snX 
         * s {+,-}
         * n {1..nek}
         * X {D,M,R}, {D,M,Y}
         IF m.lcType="U" AND INLIST(This.cSimpleType,"D","T")
            lcType="DI"
         ENDIF
         
         IF ATC(","+m.lcType+",",This.cAlterType)>0
           RETURN This.ConvertValue(m.lcValue,.F.,m.lcType,@m.llEmptyValue)
         ENDIF   
      ENDIF

      IF m.llValid
         lcValue=m.lcI+m.lcPom+m.lcE
      ENDIF

      RETURN _PC_OK
   ENDPROC
  
   
   PROCEDURE FieldNameToCode(lcFieldName) && Provede konverzi nzvu/popisu poloky na kd
      *@lcFieldName - Nzev/popis poloky
      
      * Poloka se dle nzvu/popisu vyhled v datovm slovnku
      * Nejprve se provede kontrola zda poloka m shodn datov typ
      *  pokud ne, vrt se chyba
      *  pokud ano, pak jej kd se zape do pedanho parametru
      
      lcType= This.cType
      lcFieldName=m.lcFieldName
      IF m.lcType<>This.cType
         RETURN _PC_FieldHasBadType
      ENDIF   
      RETURN _PC_OK
   ENDPROC
   
   
   PROCEDURE GetErrorMessage(liErr) && Vrt popis chyby dle kdu chyby
       * liErr - Kd chyby
       DO CASE
          CASE INLIST(m.liErr,_PC_ValueIsNotValid,_PC_ConditionIsNotValid)
               RETURN This.aErrorMsg(ABS(m.liErr))
               
          CASE INLIST(m.liErr,_PC_FieldHasBadType,_PC_FieldNotExists)
               RETURN STRTRAN(This.aErrorMsg(ABS(m.liErr)),"%B_111%",This.cEmbededField)

          OTHERWISE
               RETURN ""
      ENDCASE 
   ENDPROC

ENDDEFINE



*****************************************************************************************************
* Obecn definice tdy datovho zdroje
*****************************************************************************************************
DEFINE CLASS _SF_DS AS CUSTOM
   Name="_SF_DS"

   cField=""       && Kd poloky
   cBase=""        && Vchoz hodnota
   iSTI=0          && Index zjednoduenho typu (Simple Type Index)
   cOperator=""    && Token
   oRamF=.NULL.    && Ram objekt s informacemi zpracovvan vty internho kurzoru
   oRamS=.NULL.    && Ram objekt s informacemi nsledujc vty internho kurzoru 
   cOut=""         && Vygenerovan vraz
   cTest=""        && Vygenerovan testovac vraz
   oParser=""      && Odakz na objekt parseru


   cCaseInsensitive="" && Hledn textu - ignoruje mal/velk - (Funkce)
   cAutoAddAsterisk=""  && Automatick pidn  - *
   cReduceAccent=""  && Automatick odstrann diakritiky

   DIME aIE(1,3)   && Pole se definicema uzavrajcch znak a vchozch hodnot datovch typ. Viz vlastnost iSTI.

   PROCEDURE xBetween() && Definice intervalu
   ENDPROC

   PROCEDURE xDateAddDay() && Datum a den
   ENDPROC

   PROCEDURE xDateAddWeek() && Datum a tden
   ENDPROC

   PROCEDURE xDateAddMonth() && Datum a msc
   ENDPROC

   PROCEDURE xDateAddQuarter() && Datum a tvrtlet
   ENDPROC

   PROCEDURE xDateAddYear() && Datum a rok
   ENDPROC

   PROCEDURE xLike() && Porovnn etzc - LIKE
   ENDPROC


   PROCEDURE xBoolean() && Porovnn logickch hodnot
   ENDPROC

   PROCEDURE xOther() && Ostatn
   ENDPROC

   PROCEDURE CheckExpression(lcTest) && Kontrola vrazu
      *@lcTest - condition for testing
      * Pokud vraz nen validn vrac se chyba _PC_ConditionIsNotValid
      RETURN _PC_OK
   ENDPROC

ENDDEFINE


*****************************************************************************************************
* Obecn definice tdy vzdlenho datovho zdroje
*****************************************************************************************************
DEFINE CLASS _SF_DSR AS _SF_DS
   Name="_SF_DSR"

   ihdbc=0   && ODBC handle spojen
   cTable="" && Nzev tabulky pro kontrolu vrazu, pro ORACLE me bt DUAL
   
   PROCEDURE CheckExpression(lcTest) && Kontrola vrazu
      *@lcTest - condition for testing
      LOCAL liRet,lcAlias,liSele,llAsynchronous,lihdbc
      lihdbc=This.ihdbc
      liSele=SELE()
      lcAlias=SYS(2015)

      llAsynchronous=SQLGETPROP(m.lihdbc,"Asynchronous")
      =SQLSETPROP(m.lihdbc,"Asynchronous",.F.)
      liRet=SQLEXEC(m.lihdbc,"SELECT 1 FROM "+This.cTable+" WHERE "+m.lcTest,m.lcAlias)
      =SQLSETPROP(m.lihdbc,"Asynchronous",m.llAsynchronous)
      IF USED(m.lcAlias) 
         USE IN (m.lcAlias)
      ENDIF   
      SELE (m.liSele)
      RETURN IIF(m.liRet<=0,_PC_ConditionIsNotValid,_PC_OK)
   ENDPROC

ENDDEFINE

*****************************************************************************************************
* Definice tdy datovho zdroje VFP (Visual FoxPro)
*****************************************************************************************************
DEFINE CLASS _SF_DS_VFP AS _SF_DS
   Name="_SF_DS_VFP"

   DIME aIE(6,3)
   aIE(1,1)=""
   aIE(1,2)=""
   aIE(1,3)="0"
   
   aIE(2,1)="'"
   aIE(2,2)="'"
   aIE(2,3)="' '"

   aIE(3,1)="{^"
   aIE(3,2)="}"
   aIE(3,3)="{..}"

   aIE(4,1)="{^"
   aIE(4,2)="}"
   aIE(4,3)="{..::}"

   aIE(5,1)="."
   aIE(5,2)="."
   aIE(5,3)=".F."

   aIE(6,1)=""
   aIE(6,2)=""
   aIE(6,3)="0"

   cCaseInsensitive="UPPER(%VAL%)" && Hledn textu - ignoruje mal/velk - (Funkce)
   cAutoAddAsterisk="*"  && Automatick pidn  - *
   cReduceAccent="STRCONV(STRCONV(%VAL%,9),11,1251,1)"  && Automatick odstrann diakritiky


   PROCEDURE xNVL()
      RETURN "NVL("+This.cField+","+This.cBase+")"
   ENDPROC

   PROCEDURE xBetween()
      This.cOut= "BETWEEN("+This.cField+","+This.oRamF.XX001+","+This.oRamS.XX001+")"
      This.cTest="BETWEEN("+This.cBase+"," +This.oRamF.XX003+","+This.oRamS.XX003+")"
   ENDPROC

   PROCEDURE xDateAddDay()
      IF This.oParser.cType="T"
         This.oRamS.XX001=LTRIM(STR(VAL(This.oRamS.XX001)*3600*24,11))
         This.oRamS.XX003=LTRIM(STR(VAL(This.oRamS.XX003)*3600*24,11))
      ENDIF
      
      This.cOut= This.oRamF.XX001+This.cOperator+This.oRamS.XX001
      This.cTest=This.oRamF.XX003+This.cOperator+This.oRamS.XX003
   ENDPROC

   PROCEDURE xDateAddWeek()
      IF This.oParser.cType="T"
         This.oRamS.XX001=LTRIM(STR(VAL(This.oRamS.XX001)*7*3600*24,11))
         This.oRamS.XX003=LTRIM(STR(VAL(This.oRamS.XX003)*7*3600*24,11))
      ELSE
         This.oRamS.XX001=LTRIM(STR(VAL(This.oRamS.XX001)*7,11))
         This.oRamS.XX003=LTRIM(STR(VAL(This.oRamS.XX003)*7,11))
      ENDIF

      This.cOut= This.oRamF.XX001+This.cOperator+This.oRamS.XX001
      This.cTest=This.oRamF.XX003+This.cOperator+This.oRamS.XX003
   ENDPROC

   PROCEDURE xDateAddMonth()
      This.cOut= "GOMONTH("+This.oRamF.XX001+","+This.oRamS.XX001+")"
      This.cTest="GOMONTH("+This.oRamF.XX003+","+This.oRamS.XX003+")"
   ENDPROC

   PROCEDURE xDateAddQuarter()
      This.cOut= "GOMONTH("+This.oRamF.XX001+","+This.oRamS.XX001+"*4)"
      This.cTest="GOMONTH("+This.oRamF.XX003+","+This.oRamS.XX003+"*4)"
   ENDPROC

   PROCEDURE xDateAddYear()
      This.cOut= "GOMONTH("+This.oRamF.XX001+","+This.oRamS.XX001+"*12)"
      This.cTest="GOMONTH("+This.oRamF.XX003+","+This.oRamS.XX003+"*12)"
   ENDPROC

   PROCEDURE xLike()
      This.cOut= "LIKE("+This.oRamS.XX001+","+This.cField+")"
      This.cTest="LIKE("+This.oRamS.XX003+","+This.cBase+")"
   ENDPROC


   PROCEDURE xBoolean()
      IF This.oRamS.XX001==This.aIE(This.iSTI,1)+"T"+This.aIE(This.iSTI,2)
         This.cOut= This.cField
         This.cTest=This.cBase
      ELSE
         This.cOut= "NOT "+This.cField
         This.cTest="NOT "+This.cBase
      ENDIF   
   ENDPROC

   PROCEDURE xOther()
      This.cOut= This.oRamF.XX001
      This.cTest=This.oRamF.XX003
   ENDPROC
   

   PROCEDURE CheckExpression(lcTest) && kontrola vrazu
      *@lcTest - condition for testing
      RETURN IIF(TYPE(lcTest)="U",_PC_ConditionIsNotValid,_PC_OK)
   ENDPROC
   
ENDDEFINE




*****************************************************************************************************
* Definice tdy datovho zdroje MS Access
*****************************************************************************************************
DEFINE CLASS _SF_DS_ACCESS AS _SF_DSR
   Name="_SF_DS_ACCESS"

   DIME aIE(6,3)
   aIE(1,1)=""
   aIE(1,2)=""
   aIE(1,3)="0"
   
   aIE(2,1)="'"
   aIE(2,2)="'"
   aIE(2,3)="' '"

   aIE(3,1)="{d '"
   aIE(3,2)="'}"
   aIE(3,3)="{d '1793-01-01'}"

   aIE(4,1)="{ts '"
   aIE(4,2)="'}"
   aIE(4,3)="{ts '1793-01-01 00:00:00'}"

   aIE(5,1)=""
   aIE(5,2)=""
   aIE(5,3)="0=0"

   aIE(6,1)=""
   aIE(6,2)=""
   aIE(6,3)="0"

   cCaseInsensitive="{fn UPPER(%VAL%)}" && Hledn textu - ignoruje mal/velk - (Funkce)
   cAutoAddAsterisk="*"  && Automatick pidn  - *

   PROCEDURE xNVL()
      RETURN "IIF(ISNULL("+This.cField+"),"+This.cBase+","+This.cField+")"
   ENDPROC

   PROCEDURE xBetween()
      This.cOut= This.cField+" BETWEEN "+This.oRamF.XX001+" AND "+This.oRamS.XX001
      This.cTest=This.cBase +" BETWEEN "+This.oRamF.XX003+" AND "+This.oRamS.XX003
   ENDPROC

   PROCEDURE xDateAddDay()
      This.cOut=  "dateadd('d',"+This.cOperator+This.oRamS.XX001+","+This.oRamF.XX001+")"
      This.cTest= "dateadd('d',"+This.cOperator+This.oRamS.XX003+","+This.oRamF.XX003+")"
   ENDPROC

   PROCEDURE xDateAddWeek()
      This.cOut=  "dateadd('ww',"+This.cOperator+This.oRamS.XX001+","+This.oRamF.XX001+")"
      This.cTest= "dateadd('ww',"+This.cOperator+This.oRamS.XX003+","+This.oRamF.XX003+")"
   ENDPROC

   PROCEDURE xDateAddMonth()
      This.cOut=  "dateadd('m',"+This.cOperator+This.oRamS.XX001+","+This.oRamF.XX001+")"
      This.cTest= "dateadd('m',"+This.cOperator+This.oRamS.XX003+","+This.oRamF.XX003+")"
   ENDPROC

   PROCEDURE xDateAddQuarter()
      This.cOut=  "dateadd('q',"+This.cOperator+This.oRamS.XX001+","+This.oRamF.XX001+")"
      This.cTest= "dateadd('q',"+This.cOperator+This.oRamS.XX003+","+This.oRamF.XX003+")"
   ENDPROC

   PROCEDURE xDateAddYear()
      This.cOut=  "dateadd('yyyy',"+This.cOperator+This.oRamS.XX001+","+This.oRamF.XX001+")"
      This.cTest= "dateadd('yyyy',"+This.cOperator+This.oRamS.XX003+","+This.oRamF.XX003+")"
   ENDPROC

   PROCEDURE xLike()
      This.cOut= This.cField+" LIKE "+This.oRamS.XX001
      This.cTest=This.cBase+" LIKE "+This.oRamS.XX003
   ENDPROC


   PROCEDURE xBoolean()
      IF This.oRamS.XX001==This.aIE(This.iSTI,1)+"T"+This.aIE(This.iSTI,2)
         This.cOut= This.cField
         This.cTest=This.cBase
      ELSE
         This.cOut= "NOT "+This.cField
         This.cTest="NOT "+This.cBase
      ENDIF   
   ENDPROC

   PROCEDURE xOther()
      This.cOut= This.oRamF.XX001
      This.cTest=This.oRamF.XX003
   ENDPROC

ENDDEFINE


*****************************************************************************************************
* Definice tdy datovho zdroje Oracle
*****************************************************************************************************
DEFINE CLASS _SF_DS_ORACLE AS _SF_DSR
   Name="_SF_DS_ORACLE"

   DIME aIE(6,3)
   aIE(1,1)=""
   aIE(1,2)=""
   aIE(1,3)="0"
   
   aIE(2,1)="'"
   aIE(2,2)="'"
   aIE(2,3)="' '"

   aIE(3,1)="{d '"
   aIE(3,2)="'}"
   aIE(3,3)="{d '1793-01-01'}"

   aIE(4,1)="{ts '"
   aIE(4,2)="'}"
   aIE(4,3)="{ts '1793-01-01 00:00:00'}"

   aIE(5,1)=""
   aIE(5,2)=""
   aIE(5,3)="0=0"

   aIE(6,1)=""
   aIE(6,2)=""
   aIE(6,3)="0"

   cCaseInsensitive="{fn UPPER(%VAL%)}" && Hledn textu - ignoruje mal/velk - (Funkce)
   cAutoAddAsterisk="%"  && Automatick pidn  - *
   cReduceAccent="CONVERT(%VAL%,'us7ascii')"  && Automatick odstrann diakritiky

   PROCEDURE xNVL()
      RETURN "NVL("+This.cField+","+This.cBase+")"
   ENDPROC

   PROCEDURE xBetween()
      This.cOut= This.cField+" BETWEEN "+This.oRamF.XX001+" AND "+This.oRamS.XX001
      This.cTest=This.cBase +" BETWEEN "+This.oRamF.XX003+" AND "+This.oRamS.XX003
   ENDPROC

   PROCEDURE xDateAddDay()
      This.cOut=  This.oRamF.XX001+"+NUMTODSINTERVAL("+This.cOperator+This.oRamS.XX001+",'day')"
      This.cTest= This.oRamF.XX003+"+NUMTODSINTERVAL("+This.cOperator+This.oRamS.XX003+",'day')"
   ENDPROC

   PROCEDURE xDateAddWeek()
      This.cOut=  This.oRamF.XX001+This.cOperator+"NUMTODSINTERVAL(7*"+This.oRamS.XX001+",'day')"
      This.cTest= This.oRamF.XX003+This.cOperator+"NUMTODSINTERVAL(7*"+This.oRamS.XX003+",'day')"
   ENDPROC

   PROCEDURE xDateAddMonth()
      This.cOut=  "ADD_MONTHS("+This.oRamF.XX001+","+This.cOperator+This.oRamS.XX001+")"
      This.cTest= "ADD_MONTHS("+This.oRamF.XX003+","+This.cOperator+This.oRamS.XX003+")"
   ENDPROC

   PROCEDURE xDateAddQuarter()
      This.cOut=  "ADD_MONTHS("+This.oRamF.XX001+","+This.cOperator+This.oRamS.XX001+"*4)"
      This.cTest= "ADD_MONTHS("+This.oRamF.XX003+","+This.cOperator+This.oRamS.XX003+"*4)"
   ENDPROC

   PROCEDURE xDateAddYear()
      This.cOut=  "ADD_MONTHS("+This.oRamF.XX001+","+This.cOperator+This.oRamS.XX001+"*12)"
      This.cTest= "ADD_MONTHS("+This.oRamF.XX003+","+This.cOperator+This.oRamS.XX003+"*12)"
   ENDPROC

   PROCEDURE xLike()
      This.cOut= This.cField+" LIKE "+This.oRamS.XX001
      This.cTest=This.cBase+" LIKE "+This.oRamS.XX003
   ENDPROC


   PROCEDURE xBoolean()
      IF This.oRamS.XX001==This.aIE(This.iSTI,1)+"T"+This.aIE(This.iSTI,2)
         This.cOut= This.cField
         This.cTest=This.cBase
      ELSE
         This.cOut= "NOT "+This.cField
         This.cTest="NOT "+This.cBase
      ENDIF   
   ENDPROC

   PROCEDURE xOther()
      This.cOut= This.oRamF.XX001
      This.cTest=This.oRamF.XX003
   ENDPROC


ENDDEFINE


*****************************************************************************************************
* Definice tdy datovho zdroje MS SQL
*****************************************************************************************************
DEFINE CLASS _SF_DS_MSSQL AS _SF_DSR
   Name="_SF_DS_MSSQL"

   DIME aIE(6,3)
   aIE(1,1)=""
   aIE(1,2)=""
   aIE(1,3)="0"
   
   aIE(2,1)="'"
   aIE(2,2)="'"
   aIE(2,3)="' '"

   aIE(3,1)="{d '"
   aIE(3,2)="'}"
   aIE(3,3)="{d '1793-01-01'}"

   aIE(4,1)="{ts '"
   aIE(4,2)="'}"
   aIE(4,3)="{ts '1793-01-01 00:00:00'}"

   aIE(5,1)=""
   aIE(5,2)=""
   aIE(5,3)="0=0"

   aIE(6,1)=""
   aIE(6,2)=""
   aIE(6,3)="0"

   cCaseInsensitive="{fn UPPER(%VAL%)}" && Hledn textu - ignoruje mal/velk - (Funkce)
   cAutoAddAsterisk="%"  && Automatick pidn  - *
   cReduceAccent="%VAL% COLLATE SQL_Latin1_General_Cp1251_CS_AS"  && Automatick odstrann diakritiky

   PROCEDURE xNVL()
      RETURN "ISNULL("+This.cField+","+This.cBase+")"
   ENDPROC

   PROCEDURE xBetween()
      This.cOut= This.cField+" BETWEEN "+This.oRamF.XX001+" AND "+This.oRamS.XX001
      This.cTest=This.cBase +" BETWEEN "+This.oRamF.XX003+" AND "+This.oRamS.XX003
   ENDPROC

   PROCEDURE xDateAddDay()
      This.cOut=  "DATEADD(day,"+This.cOperator+This.oRamS.XX001+","+This.oRamF.XX001+")"
      This.cTest= "DATEADD(day,"+This.cOperator+This.oRamS.XX003+","+This.oRamF.XX003+")"
   ENDPROC

   PROCEDURE xDateAddWeek()
      This.cOut=  "DATEADD(week,"+This.cOperator+This.oRamS.XX001+","+This.oRamF.XX001+")"
      This.cTest= "DATEADD(week,"+This.cOperator+This.oRamS.XX003+","+This.oRamF.XX003+")"
   ENDPROC

   PROCEDURE xDateAddMonth()
      This.cOut=  "DATEADD(month,"+This.cOperator+This.oRamS.XX001+","+This.oRamF.XX001+")"
      This.cTest= "DATEADD(month,"+This.cOperator+This.oRamS.XX003+","+This.oRamF.XX003+")"
   ENDPROC

   PROCEDURE xDateAddQuarter()
      This.cOut=  "DATEADD(quarter,"+This.cOperator+This.oRamS.XX001+","+This.oRamF.XX001+")"
      This.cTest= "DATEADD(quarter,"+This.cOperator+This.oRamS.XX003+","+This.oRamF.XX003+")"
   ENDPROC

   PROCEDURE xDateAddYear()
      This.cOut=  "DATEADD(year,"+This.cOperator+This.oRamS.XX001+","+This.oRamF.XX001+")"
      This.cTest= "DATEADD(year,"+This.cOperator+This.oRamS.XX003+","+This.oRamF.XX003+")"
   ENDPROC

   PROCEDURE xLike()
      This.cOut= This.cField+" LIKE "+This.oRamS.XX001
      This.cTest=This.cBase+" LIKE "+This.oRamS.XX003
   ENDPROC


   PROCEDURE xBoolean()
      IF This.oRamS.XX001==This.aIE(This.iSTI,1)+"T"+This.aIE(This.iSTI,2)
         This.cOut= This.cField
         This.cTest=This.cBase
      ELSE
         This.cOut= "NOT "+This.cField
         This.cTest="NOT "+This.cBase
      ENDIF   
   ENDPROC

   PROCEDURE xOther()
      This.cOut= This.oRamF.XX001
      This.cTest=This.oRamF.XX003
   ENDPROC


ENDDEFINE



*****************************************************************************************************
* Definice tdy datovho zdroje FireBird
*****************************************************************************************************
DEFINE CLASS _SF_DS_FIREBIRD AS _SF_DSR
   Name="_SF_DS_FIREBIRD"

   DIME aIE(6,3)
   aIE(1,1)=""
   aIE(1,2)=""
   aIE(1,3)="0"
   
   aIE(2,1)="'"
   aIE(2,2)="'"
   aIE(2,3)="' '"

   aIE(3,1)="{fn CONVERT({d '"
   aIE(3,2)="'},SQL_DATE)}"
   aIE(3,3)="{fn CONVERT({d '1793-01-01'},SQL_DATE)}"

   aIE(4,1)="{fn CONVERT({ts '"
   aIE(4,2)="'},SQL_TIMESTAMP)}"
   aIE(4,3)="{fn CONVERT({ts '1793-01-01 00:00:00'},SQL_TIMESTAMP)}"

   aIE(5,1)=""
   aIE(5,2)=""
   aIE(5,3)="0=0"

   aIE(6,1)=""
   aIE(6,2)=""
   aIE(6,3)="0"

   cCaseInsensitive="UPPER(%VAL%)" && Hledn textu - ignoruje mal/velk - (Funkce)
   cAutoAddAsterisk="%"  && Automatick pidn  - *
   cReduceAccent="%VAL% COLLATE KOI8-RU"  && Automatick odstrann diakritiky ???

   PROCEDURE xNVL()
      RETURN "COALESCE("+This.cField+","+This.cBase+")"
   ENDPROC

   PROCEDURE xBetween()
      This.cOut= This.cField+" BETWEEN "+This.oRamF.XX001+" AND "+This.oRamS.XX001
      This.cTest=This.cBase +" BETWEEN "+This.oRamF.XX003+" AND "+This.oRamS.XX003
   ENDPROC

   PROCEDURE xDateAddDay()
      This.cOut=  "DATEADD(MONTH,"+This.cOperator+This.oRamS.XX001+","+This.oRamF.XX001+")"
      This.cTest= "DATEADD(MONTH,"+This.cOperator+This.oRamS.XX003+","+This.oRamF.XX003+")"
   ENDPROC

   PROCEDURE xDateAddWeek()
      This.cOut=  "DATEADD(DAY,"+This.cOperator+This.oRamS.XX001+"*7,"+This.oRamF.XX001+")"
      This.cTest= "DATEADD(DAY,"+This.cOperator+This.oRamS.XX003+"*7,"+This.oRamF.XX003+")"
   ENDPROC

   PROCEDURE xDateAddMonth()
      This.cOut=  "DATEADD(MONTH,"+This.cOperator+This.oRamS.XX001+","+This.oRamF.XX001+")"
      This.cTest= "DATEADD(MONTH,"+This.cOperator+This.oRamS.XX003+","+This.oRamF.XX003+")"
   ENDPROC

   PROCEDURE xDateAddQuarter()
      This.cOut=  "DATEADD(MONTH,"+This.cOperator+This.oRamS.XX001+"*4,"+This.oRamF.XX001+")"
      This.cTest= "DATEADD(MONTH,"+This.cOperator+This.oRamS.XX003+"*4,"+This.oRamF.XX003+")"
   ENDPROC

   PROCEDURE xDateAddYear()
      This.cOut=  "DATEADD(MONTH,"+This.cOperator+This.oRamS.XX001+"*12,"+This.oRamF.XX001+")"
      This.cTest= "DATEADD(MONTH,"+This.cOperator+This.oRamS.XX003+"*12,"+This.oRamF.XX003+")"
   ENDPROC

   PROCEDURE xLike()
      This.cOut= This.cField+" LIKE "+This.oRamS.XX001
      This.cTest=This.cBase+" LIKE "+This.oRamS.XX003
   ENDPROC


   PROCEDURE xBoolean()
      IF This.oRamS.XX001==This.aIE(This.iSTI,1)+"T"+This.aIE(This.iSTI,2)
         This.cOut= This.cField
         This.cTest=This.cBase
      ELSE
         This.cOut= "NOT "+This.cField
         This.cTest="NOT "+This.cBase
      ENDIF   
   ENDPROC

   PROCEDURE xOther()
      This.cOut= This.oRamF.XX001
      This.cTest=This.oRamF.XX003
   ENDPROC


ENDDEFINE



*****************************************************************************************************
* Definice tdy datovho zdroje My SQL
*****************************************************************************************************
DEFINE CLASS _SF_DS_MYSQL AS _SF_DSR
   Name="_SF_DS_MYSQL"

   DIME aIE(6,3)
   aIE(1,1)=""
   aIE(1,2)=""
   aIE(1,3)="0"
   
   aIE(2,1)="'"
   aIE(2,2)="'"
   aIE(2,3)="' '"

   aIE(3,1)="'"
   aIE(3,2)="'"
   aIE(3,3)="'1793-01-01'"

   aIE(4,1)="'"
   aIE(4,2)="'"
   aIE(4,3)="'1793-01-01 00:00:00'"

   aIE(5,1)=""
   aIE(5,2)=""
   aIE(5,3)="0=0"

   aIE(6,1)=""
   aIE(6,2)=""
   aIE(6,3)="0"

   cCaseInsensitive="UPPER(%VAL%)" && Hledn textu - ignoruje mal/velk - (Funkce)
   cAutoAddAsterisk="%"  && Automatick pidn  - *
   cReduceAccent="CAST(%VAL% AS CHAR CHARACTER SET utf8) COLLATE utf8_general_ci"  && Automatick odstrann diakritiky

   PROCEDURE xNVL()
      RETURN "COALESCE("+This.cField+","+This.cBase+")"
   ENDPROC

   PROCEDURE xBetween()
      This.cOut= This.cField+" BETWEEN "+This.oRamF.XX001+" AND "+This.oRamS.XX001
      This.cTest=This.cBase +" BETWEEN "+This.oRamF.XX003+" AND "+This.oRamS.XX003
   ENDPROC

   PROCEDURE xDateAddDay()
      This.cOut=  "DATEADD("+This.oRamF.XX001+", INTERVAL ADD "+This.cOperator+This.oRamS.XX001+" MONTH)"
      This.cTest= "DATEADD("+This.oRamF.XX003+", INTERVAL ADD "+This.cOperator+This.oRamS.XX003+" MONTH)"
   ENDPROC

   PROCEDURE xDateAddWeek()
      This.cOut=  "DATEADD("+This.oRamF.XX001+", INTERVAL ADD "+This.cOperator+This.oRamS.XX001+" WEEK)"
      This.cTest= "DATEADD("+This.oRamF.XX003+", INTERVAL ADD "+This.cOperator+This.oRamS.XX003+" WEEK)"
   ENDPROC

   PROCEDURE xDateAddMonth()
      This.cOut=  "DATEADD("+This.oRamF.XX001+", INTERVAL ADD "+This.cOperator+This.oRamS.XX001+" MONTH)"
      This.cTest= "DATEADD("+This.oRamF.XX003+", INTERVAL ADD "+This.cOperator+This.oRamS.XX003+" MONTH)"
   ENDPROC

   PROCEDURE xDateAddQuarter()
      This.cOut=  "DATEADD("+This.oRamF.XX001+", INTERVAL ADD "+This.cOperator+This.oRamS.XX001+" QUARTER)"
      This.cTest= "DATEADD("+This.oRamF.XX003+", INTERVAL ADD "+This.cOperator+This.oRamS.XX003+" QUARTER)"
   ENDPROC

   PROCEDURE xDateAddYear()
      This.cOut=  "DATEADD("+This.oRamF.XX001+", INTERVAL ADD "+This.cOperator+This.oRamS.XX001+" YEAR)"
      This.cTest= "DATEADD("+This.oRamF.XX003+", INTERVAL ADD "+This.cOperator+This.oRamS.XX003+" YAER)"
   ENDPROC

   PROCEDURE xLike()
      This.cOut= This.cField+" LIKE "+This.oRamS.XX001
      This.cTest=This.cBase+" LIKE "+This.oRamS.XX003
   ENDPROC


   PROCEDURE xBoolean()
      IF This.oRamS.XX001==This.aIE(This.iSTI,1)+"T"+This.aIE(This.iSTI,2)
         This.cOut= This.cField
         This.cTest=This.cBase
      ELSE
         This.cOut= "NOT "+This.cField
         This.cTest="NOT "+This.cBase
      ENDIF   
   ENDPROC

   PROCEDURE xOther()
      This.cOut= This.oRamF.XX001
      This.cTest=This.oRamF.XX003
   ENDPROC


ENDDEFINE

