#DEFINE GMEM_FIXED     0
#DEFINE GMEM_MOVEABLE  2
#DEFINE GMEM_ZEROINIT  0x0040

PROCEDURE VFPBMP_Init
LOCAL m.lcPath
m.lcPath=SYS(16)
IF UPPER(LEFT(m.lcPATH, 9))="PROCEDURE"
   m.lcPath=SUBSTR(m.lcPath, AT(" ", m.lcPath, 2)+1)
ENDIF
m.lcPath=ADDBS(JUSTPATH(m.lcPath))
SET LIBRARY TO (m.lcPath+"vfpbmp.fll") ADDITIVE
ENDPROC



FUNCTION vfpbmp_GlobalFree(hMem)
 DECLARE LONG GlobalFree IN kernel32 AS vfpbmp_GlobalFree LONG hMem
 RETURN vfpbmp_GlobalFree(hMem)
ENDFUNC

FUNCTION vfpbmp_GlobalAlloc(wFlags, dwBytes)
 DECLARE LONG GlobalAlloc IN kernel32 AS vfpbmp_GlobalAlloc INTEGER wFlags, INTEGER dwBytes
 RETURN vfpbmp_GlobalAlloc(wFlags, dwBytes)
ENDFUNC

FUNCTION vfpbmp_GlobalLock(hMem)
 DECLARE LONG GlobalLock IN kernel32 AS vfpbmp_GlobalLock LONG hMem
 RETURN vfpbmp_GlobalLock(hMem)
ENDFUNC

FUNCTION vfpbmp_GlobalUnlock(hMem)
 DECLARE LONG GlobalUnlock IN kernel32 AS vfpbmp_GlobalUnlock LONG hMem
 RETURN vfpbmp_GlobalUnlock(hMem)
ENDFUNC


DEFINE CLASS _vfpbmp_FillGradient AS CUSTOM
 Name="_vfpbmp_FillGradient"
 Data=0
 _ByteCount=0
 _Delta=0
 biHeight=0
 biWidth=0
 Type=0
 iY1=0
 iY2=0
 iX1=0
 iX2=0
 C1R=0
 C1G=0
 C1B=0
 C2R=0
 C2G=0
 C2B=0
ENDDEFINE

***********************************************************************
*
***********************************************************************
DEFINE CLASS _bmp AS CUSTOM

*!*	   PROTECTED biSize,Size,Head,Offset,Reserved1,Reserved2,biSize,;
*!*	             biWidth,biHeight,biPlanes,biBitCount,biCompression,biSizeImage,;
*!*	             biXPelsPerMeter,biYPelsPerMeter,biClrUsed,biClrImportant,;
*!*	             ColorArray,Data,_Index,_ByteCount

   Head=""
   Size=0
   Offset=0
   Reserved1=0
   Reserved2=0

   biSize=0 && DWORD  biSize
   biWidth=0 && LONG   biWidth 
   biHeight=0 &&  LONG   biHeight
   biPlanes=0 &&  WORD   biPlanes 
   biBitCount=0 &&  WORD   biBitCount
   biCompression=0 &&  DWORD  biCompression
   biSizeImage=0 &&  DWORD  biSizeImage
   biXPelsPerMeter=0 &&  LONG   biXPelsPerMeter
   biYPelsPerMeter=0 &&  LONG   biYPelsPerMeter
   biClrUsed=0 &&  DWORD  biClrUsed
   biClrImportant=0 &&  DWORD  biClrImportant
   _ByteCount=0 && bytecount per biBitCount

   ColorArray=""
   Data=0
   HeapData=0

   _Index=-1
   _Delta=0

   PictureVal=.NULL.
   
   PROCEDURE Destroy
      This.ClearData()
   ENDPROC


   PROTECTED PROCEDURE ClearData
      IF This.HeapData>0
         =vfpbmp_GlobalUnlock(This.HeapData)
         =vfpbmp_GlobalFree(This.HeapData)
      ENDIF
   ENDPROC


   PROCEDURE C2RGB
      LPARAMETERS m.liColor, m.laColor
      
      EXTERNAL ARRAY laColor
      
      LOCAL m.lcPom
      m.lcPom=RIGHT(TRANSFORM(m.liColor, "@0"), 6)
      m.laColor(1)=INT(VAL("0x"+RIGHT(m.lcPom, 2)))
      m.laColor(2)=INT(VAL("0x"+SUBST(m.lcPom, 3, 2)))
      m.laColor(3)=INT(VAL("0x"+LEFT(m.lcPom, 2)))
   ENDPROC   

   PROCEDURE ReadFromFile
      LPARAMETERS m.lcFile
      
      LOCAL vlcPom, m.liStart
      m.lcPom=FILETOSTR(m.lcFile)

      *BITMAPFILEHEADER
      This.Head=SUBST(m.lcPom, 1, 2)
      This.Size=CTOBIN(SUBST(m.lcPom, 3, 4), "RS") && kompletni velikost BMP souboru
      This.Reserved1=CTOBIN(SUBST(m.lcPom, 7, 2), "2RS")
      This.Reserved2=CTOBIN(SUBST(m.lcPom, 9, 2), "2RS")
      This.Offset=CTOBIN(SUBST(m.lcPom, 11, 4), "RS") && Specifies the offset, in bytes, from the beginning of 
                         && the BITMAPFILEHEADER structure to the bitmap bits. 

      *BITMAPINFOHEADER
      This.biSize=CTOBIN(SUBST(m.lcPom, 15, 4), "RS") && DWORD  biSize
      This.biWidth=CTOBIN(SUBST(m.lcPom, 19, 4), "RS") && LONG   biWidth 
      This.biHeight=CTOBIN(SUBST(m.lcPom, 23, 4), "RS") &&  LONG   biHeight
      This.biPlanes=CTOBIN(SUBST(m.lcPom, 27, 2), "RS") &&  WORD   biPlanes 
      This.biBitCount=CTOBIN(SUBST(m.lcPom, 29, 2), "RS") &&  WORD   biBitCount
      This.biCompression=CTOBIN(SUBST(m.lcPom, 31, 4), "RS") &&  DWORD  biCompression
      This.biSizeImage=CTOBIN(SUBST(m.lcPom, 35, 4), "RS") &&  DWORD  biSizeImage
      This.biXPelsPerMeter=CTOBIN(SUBST(m.lcPom, 39, 4), "RS") &&  LONG   biXPelsPerMeter
      This.biYPelsPerMeter=CTOBIN(SUBST(m.lcPom, 43, 4), "RS") &&  LONG   biYPelsPerMeter
      This.biClrUsed=CTOBIN(SUBST(m.lcPom, 47, 4), "RS") &&  DWORD  biClrUsed
      This.biClrImportant=CTOBIN(SUBST(m.lcPom, 51, 4), "RS") &&  DWORD  biClrImportant


      This._ByteCount=INT(This.biBitCount/8)
      This._Delta=INT(IIF(INT((This.biWidth*This._ByteCount)%4)=0, 0, (INT((This.biWidth*This._ByteCount)/4)+1)*4-(This.biWidth*This._ByteCount)))

      IF This.biCompression=0 AND This.biSizeImage=0
         This.biSizeImage=This.biHeight*((This.biWidth*This._ByteCount)+This._Delta) &&  DWORD  biSizeImage
      ENDIF   


      * Pole barev
      IF This.biBitCount=8
         This._Index=256
         This.ColorArray=SUBST(m.lcPom, 15+This.biSize, This._Index*4)
      ENDIF

      * Data
      This.ClearData()
*      This.HeapData = vfpbmp_GlobalAlloc(GMEM_MOVEABLE+GMEM_ZEROINIT, This.biSizeImage)
      This.HeapData = vfpbmp_GlobalAlloc(GMEM_FIXED+GMEM_ZEROINIT, This.biSizeImage)
      IF This.HeapData=0
         RETURN .F.
      ENDIF
      This.Data = vfpbmp_GlobalLock(This.HeapData)
      IF This.Data=0
         RETURN .F.
      ENDIF
      =SYS(2600, This.Data, This.biSizeImage, SUBST(m.lcPom, This.Offset+1))
      RETURN .T.
   ENDPROC

   PROCEDURE GetIndexByColor
      LPARAMETERS m.liR, m.liG, m.liB, m.liA
      
      LOCAL m.liStart
      IF This.biBitCount>8
         RETURN -1
      ENDIF
      m.liStart=AT(CHR(m.liB)+CHR(m.liG)+CHR(m.liR)+CHR(m.liA), This.ColorArray)
      IF m.liStart=0
         liStart=AT(CHR(m.liB)+CHR(m.liG)+CHR(m.liR), This.ColorArray)
      ENDIF
      RETURN IIF(m.liStart=0,-1,INT((m.liStart-1)/4))
   ENDPROC

   PROCEDURE GetColorByIndex
      LPARAMETERS m.liIndex
      
      LOCAL m.liStart
      IF This.biBitCount>8
         RETURN -1
      ENDIF
      m.liStart=m.liIndex*4+1
      RETURN RGB(ASC(SUBST(This.ColorArray, m.liStart+2, 1)), ASC(SUBST(This.ColorArray, m.liStart+1, 1)), ASC(SUBST(This.ColorArray, m.liStart, 1)))
   ENDPROC

   PROCEDURE SetColorByIndex
      LPARAMETERS m.liIndex, m.liR, m.liG, m.liB, m.liA
      
      IF This.biBitCount>8
         RETURN .F.
      ENDIF
      This.ColorArray=STUFF(This.ColorArray, m.liIndex*4+1, 4, CHR(m.liB)+CHR(m.liG)+CHR(m.liR)+CHR(m.liA))
   ENDPROC

   PROCEDURE AddColor
      LPARAMETERS m.liR, m.liG, m.liB, m.liA
      
      LOCAL m.liIndex
      IF This.biBitCount>8
         RETURN -1
      ENDIF
      m.liIndex=This.GetIndexByColor(m.liR, m.liG, m.liB, m.liA)
      IF m.liIndex=-1 OR m.liIndex>This._Index
         STORE This._Index+1 TO This._Index, m.liIndex
         =This.SetColorByIndex(m.liIndex, m.liR, m.liG, m.liB, m.liA)
      ENDIF
      RETURN m.liIndex
   ENDPROC


   PROCEDURE GetPointColor
      LPARAMETERS m.liY, m.liX, m.llIndex
      
      LOCAL m.liLen, m.lcPom
      m.liLen=This._ByteCount
      m.lcPom=SYS(2600, This.Data+((m.liX-1)*m.liLen+1+(This.biHeight-m.liY)*(This.biWidth*m.liLen+This._Delta))-1, m.liLen)

      RETURN IIF(m.liLen>1,;
                 IIF(m.liLen=2, CTOBIN(m.lcPom, "2S"), IIF(m.liLen=3, CTOBIN(CHR(0)+m.lcPom, "S"),CTOBIN(m.lcPom, "S"))),;
                 IIF(m.llIndex, ASC(m.lcPom), This.GetColorByIndex(ASC(m.lcPom))))
   ENDPROC


   PROCEDURE SetPointColor
      LPARAMETERS m.liY, m.liX, m.liIndex, m.llIndex
      
      IF m.liY<0 OR m.liX<0 OR m.liY>This.biHeight OR m.liX>This.biWidth
         RETURN .F.
      ENDIF
      
      LOCAL m.liLen, m.lcData, m.lcPom
      m.liLen=This._ByteCount
      IF m.liLen=1
         m.lcPom=IIF(!m.llIndex,SUBST(TRANSFORM(m.liIndex,"@0"),3),"")
         m.lcData=CHR(IIF(m.llIndex, m.liIndex, This.AddColor(VAL("0x"+RIGHT(m.lcPom, 2)), VAL("0x"+SUBST(m.lcPom, 5, 2)), VAL("0x"+SUBST(m.lcPom, 3, 2)), 0)))
      ELSE
         m.lcData=RIGHT(BINTOC(m.liIndex, "S"), m.liLen)
      ENDIF
      =SYS(2600, This.Data+((m.liX-1)*m.liLen+1+(This.biHeight-m.liY)*(This.biWidth*m.liLen+This._Delta))-1, m.liLen, m.lcData )
   ENDPROC


   PROCEDURE RGBToRAWData
      LPARAMETERS m.liIndex, m.llIndex
      
      LOCAL m.liLen, m.lcPom
      m.liLen=This._ByteCount
      IF m.liLen=1
         m.lcPom=IIF(!m.llIndex, SUBST(TRANSFORM(m.liIndex, "@0"), 3), "")
         RETURN CHR(IIF(m.llIndex, m.liIndex, This.AddColor(VAL("0x"+RIGHT(m.lcPom, 2)), VAL("0x"+SUBST(m.lcPom, 5, 2)), VAL("0x"+SUBST(m.lcPom, 3, 2)), 0)))
      ENDIF
      RETURN RIGHT(BINTOC(m.liIndex, "S"), m.liLen)
   ENDPROC

   PROCEDURE YToDataIndex
      LPARAMETERS m.liY, m.liX1
      
      RETURN (m.liX1-1)*This._ByteCount+1+(This.biHeight-m.liY)*(This.biWidth*This._ByteCount+This._Delta)
   ENDPROC

   PROCEDURE GetVBuffer
      LPARAMETERS m.liY, m.liX1, m.liLen
      IF m.liX1<0
         RETURN .F.
      ENDIF
      RETURN SYS(2600, This.Data+This.YToDataIndex(m.liY, m.liX1)-1, m.liLen)
   ENDPROC

   PROCEDURE PutVBuffer
      LPARAMETERS m.liY, m.liX1, m.lcBuffer
      
      LOCAL m.liLen, m.lcData, m.lcPom
      m.liLen=This._ByteCount
      IF m.liX1<0
         RETURN .F.
      ENDIF
      =SYS(2600, This.Data+This.YToDataIndex(m.liY, m.liX1)-1, LEN(lcBuffer), m.lcBuffer)
   ENDPROC

   PROCEDURE PutVLine
      LPARAMETERS m.liY, m.liX1, m.liX2, m.liIndex, m.llIndex
      
      LOCAL m.liLen, m.lcData, m.lcPom
      m.liLen=This._ByteCount
      IF m.liX2<m.liX1 OR m.liX1<0 OR m.liX2>This.biWidth
         RETURN .F.
      ENDIF
      IF m.liLen=1
         m.lcPom=IIF(!m.llIndex,SUBST(TRANSFORM(m.liIndex, "@0"), 3), "")
         m.lcData=CHR(IIF(m.llIndex, m.liIndex, This.AddColor(VAL("0x"+RIGHT(m.lcPom, 2)), VAL("0x"+SUBST(m.lcPom, 5, 2)), VAL("0x"+SUBST(m.lcPom, 3, 2)), 0)))
      ELSE
         m.lcData=RIGHT(BINTOC(m.liIndex, "S"), m.liLen)
      ENDIF
      =SYS(2600, This.Data+This.YToDataIndex(m.liY,m.liX1)-1, m.liLen*(m.liX2-m.liX1+1), REPL(m.lcData,m.liX2-m.liX1+1))
   ENDPROC

   PROCEDURE PutHLine
      LPARAMETERS m.liX, m.liY1, m.liY2, m.liIndex, m.llIndex
      
      LOCAL m.liLen, m.lcData, m.lii, m.lcPom
      m.liLen=This._ByteCount
      IF m.liY2<m.liY1 OR m.liY1<0 OR m.liY2>This.biHeight
         RETURN .F.
      ENDIF
      IF m.liLen=1
         m.lcPom=IIF(!m.llIndex, SUBST(TRANSFORM(m.liIndex, "@0"), 3), "")
         m.lcData=CHR(IIF(m.llIndex, m.liIndex, This.AddColor(VAL("0x"+RIGHT(m.lcPom, 2)), VAL("0x"+SUBST(m.lcPom, 5, 2)), VAL("0x"+SUBST(m.lcPom, 3, 2)), 0)))
      ELSE
         m.lcData=RIGHT(BINTOC(m.liIndex, "S"), m.liLen)
      ENDIF
      FOR m.lii=0 TO m.liY2-m.liY1
          =SYS(2600, This.Data+This.YToDataIndex(m.liY1+m.lii, m.liX)-1, m.liLen, m.lcData)
      NEXT
   ENDPROC


   PROCEDURE FillSolid
      LPARAMETERS m.liY1, m.liY2, m.liX1, m.liX2, m.liColor
      
      LOCAL m.liHeight, m.liWidth, m.lii, m.lcData
      m.liHeight=m.liY2-m.liY1+1
      m.liWidth=m.liX2-m.liX1+1
      m.lcData=REPLICATE(This.RGBToRAWData(m.liColor, .T.), m.liWidth)
      m.liLen=LEN(m.lcData)
      FOR m.lii=0 TO m.liHeight-1
          =SYS(2600, This.Data+(This.YToDataIndex(m.lii+m.liY1, @m.liX1)-1), m.liLen, m.lcData)
      NEXT
   ENDPROC


   PROCEDURE FillGradient
      LPARAMETERS m.liType, m.liY1, m.liY2, m.liX1, m.liX2, m.liColor1, m.liColor2
      
      IF m.liY1<0 OR m.liX1<0 OR m.liY2>This.biHeight OR m.liX2>This.biWidth
         RETURN .F.
      ENDIF
      LOCAL ARRAY m.laColor1(3), m.laColor2(3)
      =This.C2RGB(m.liColor1, @m.laColor1)
      =This.C2RGB(m.liColor2, @m.laColor2)

      m.lcData=BINTOC(This.Data, "4RS")+;
               BINTOC(This._ByteCount, "4RS")+;
               BINTOC(This._Delta, "4RS")+;
               BINTOC(This.biHeight, "4RS")+;
               BINTOC(This.biWidth, "4RS")+;
               BINTOC(m.liType, "4RS")+;
               BINTOC(m.liY1, "4RS")+;
               BINTOC(m.liY2, "4RS")+;
               BINTOC(m.liX1, "4RS")+;
               BINTOC(m.liX2, "4RS")+;
               BINTOC(m.laColor1(1), "4RS")+;
               BINTOC(m.laColor1(2), "4RS")+;
               BINTOC(m.laColor1(3), "4RS")+;
               BINTOC(m.laColor2(1), "4RS")+;
               BINTOC(m.laColor2(2), "4RS")+;
               BINTOC(m.laColor2(3), "4RS")

      =vfpbmp_FillGradient(m.lcData)
   ENDPROC

   PROCEDURE SetData
      LPARAMETERS m.lcData
      
      =SYS(2600, This.Data, This.biSizeImage, m.lcData)
   ENDPROC

   PROCEDURE GetData()
      RETURN SYS(2600, This.Data, This.biSizeImage)
   ENDPROC

   PROCEDURE PictureVal_Access

      LOCAL m.liLCA, m.lcData
      m.liLCA=0
      * Write header
      m.lcData="BM"+REPL(CHR(0), 12)

      *BITMAPINFOHEADER
      m.lcData=m.lcData+;
               BINTOC(This.biSize, "RS")+;
               BINTOC(This.biWidth, "RS")+;
               BINTOC(This.biHeight, "RS")+;
               BINTOC(This.biPlanes, "2RS")+;
               BINTOC(This.biBitCount, "2RS")+;
               BINTOC(This.biCompression, "RS")+;
               BINTOC(This.biSizeImage, "RS")+;
               BINTOC(This.biXPelsPerMeter, "RS")+;
               BINTOC(This.biYPelsPerMeter, "RS")+;
               BINTOC(This.biClrUsed, "RS")+;
               BINTOC(This.biClrImportant, "RS")


      IF This.biBitCount=8
         m.lcData=m.lcData+This.ColorArray
         m.liLCA=LEN(This.ColorArray)
      ENDIF   
      m.lcData=m.lcData+SYS(2600, This.Data, This.biSizeImage)

      * Modify header
      m.lcData=STUFF(m.lcData, 3, 4, BINTOC(14+This.biSize+m.liLCA+This.biSizeImage, "RS"))


      RETURN STUFF(m.lcData, 11, 4, BINTOC(14+This.biSize+m.liLCA, "RS"))
   ENDPROC


   PROCEDURE SaveToFile
      LPARAMETERS m.lcFile
      
      LOCAL m.lihFile, m.lcPom, m.liLCA
      m.lihFile=FCREATE(m.lcFile)
      IF m.lihFile<=0
         RETURN .F.
      ENDIF
      m.liLCA=0
      * Write header
      =FWRITE(m.lihFile, "BM"+REPL(CHR(0), 12))

      *BITMAPINFOHEADER
      m.lcPom=BINTOC(This.biSize, "RS")+;
              BINTOC(This.biWidth, "RS")+;
              BINTOC(This.biHeight, "RS")+;
              BINTOC(This.biPlanes, "2RS")+;
              BINTOC(This.biBitCount, "2RS")+;
              BINTOC(This.biCompression, "RS")+;
              BINTOC(This.biSizeImage, "RS")+;
              BINTOC(This.biXPelsPerMeter, "RS")+;
              BINTOC(This.biYPelsPerMeter, "RS")+;
              BINTOC(This.biClrUsed, "RS")+;
              BINTOC(This.biClrImportant, "RS")

      =FWRITE(lihFile,m.lcPom)

      IF This.biBitCount=8
         =FWRITE(m.lihFile, This.ColorArray, LEN(This.ColorArray))
         m.liLCA=LEN(This.ColorArray)
      ENDIF   
      =FWRITE(m.lihFile, SYS(2600, This.Data, This.biSizeImage), This.biSizeImage)

      * modify header
      =FSEEK(m.lihFile, 2) && file size
      =FWRITE(m.lihFile, BINTOC(14+This.biSize+m.liLCA+This.biSizeImage, "RS"))

      =FSEEK(m.lihFile, 10) && offset to image raw data
      =FWRITE(m.lihFile, BINTOC(14+This.biSize+m.liLCA, "RS"))
      =FCLOSE(m.lihFile)
   ENDPROC

   PROCEDURE New
      LPARAMETERS liWidth,liHeight,liPallete
      
      This.Head="BM"
      This.Reserved1=0
      This.Reserved2=0


      This.biSize=40 && DWORD  biSize
      This.biWidth=m.liWidth && LONG   biWidth 
      This.biHeight=m.liHeight &&  LONG   biHeight
      This.biPlanes=1 &&  WORD   biPlanes 
      This.biBitCount=m.liPallete &&  WORD   biBitCount
      This._ByteCount=INT(This.biBitCount/8)
      This.biCompression=0 &&  DWORD  biCompression
      This.biXPelsPerMeter=0 &&  LONG   biXPelsPerMeter
      This.biYPelsPerMeter=0 &&  LONG   biYPelsPerMeter
      This.biClrUsed=0 &&  DWORD  biClrUsed
      This.biClrImportant=0 &&  DWORD  biClrImportant

      This._Delta=INT(IIF(INT((m.liWidth*This._ByteCount)%4)=0, 0, (INT((m.liWidth*This._ByteCount)/4)+1)*4-(m.liWidth*This._ByteCount)))
      This.biSizeImage=m.liHeight*((m.liWidth*This._ByteCount)+This._Delta) &&  DWORD  biSizeImage
      
      This.ColorArray=IIF(m.liPallete=8, REPL(CHR(255), (This._ByteCount*256)*4), "")

      This._Index=-1
      This.Offset=14+This.biSize+LEN(This.ColorArray)
      This.Size=This.Offset+This.biSizeImage
      
      This.ClearData()
      This.HeapData = vfpbmp_GlobalAlloc(GMEM_MOVEABLE+GMEM_ZEROINIT, This.biSizeImage)
      IF This.HeapData=0
         RETURN .F.
      ENDIF
         
      This.Data = vfpbmp_GlobalLock(This.HeapData) 
      RETURN .T.      
   ENDPROC

ENDDEFINE


