# INCLUDE "VFPRes.h"
* Classes for working with localized sources

EXTERNAL PROCEDURE FILLOBJECT
EXTERNAL PROCEDURE RETURNERRSTRING

DEFINE CLASS _VFPResources AS Custom

   PROTECTED ARRAY ahRes(255) && Free handles array

   DIME aResource(1, 3) && Sources array (1) - APP name, (2) - ID , (3) - VFPRes  object
   iResource=0 && Sources array counter

   NoString="Unknown flying string (UFS) %StringID%"
   NoPad="Unknown flying pad (UFP) %PadID%,%PropID%"
   NoBar="Unknown flying bar (UFB) %BarID%,%PropID%"

   PROTECTED CurrLocIndex
   CurrLocIndex=0

   * Load localized library
   PROCEDURE LoadLibrary
      LPARAMETERS m.lcLibrary, m.lcErrMsg
      
      * lcLibrary  - Folder and name of localized APP
      *@lcErrMsg   - Error message (output)
      *RETURN liID - Id of loaded localized APP
      
      LOCAL m.lcExact, m.lii, m.lcPom
      IF This.iResource=ALEN(This.ahRes) 
         RETURN Res_LoadLibrary_Full
      ENDIF

      IF !FILE(m.lcLibrary) 
         RETURN Res_LoadLibrary_NotFile 
      ENDIF

      * Try find localized APP
      m.lcExact=SET("EXACT") 
      SET EXACT ON 
      m.lii=ASCAN(This.aResource, m.lcLibrary) 
      SET EXACT &lcExact.
      IF m.lii>0 
         m.lii=ASUBS(This.aResource,m.lii, 1) 
         RETURN This.aResource(m.lii, 2) 
      ENDIF     

      This.iResource=This.iResource+1 
      DIME This.aResource(This.iResource, 3)
      
      This.aResource(This.iResource,1)=m.lcLibrary 
      This.aResource(This.iResource,2)=ASCAN(This.ahRes, .F.)
      This.aResource(This.iResource,3)=CREATEOBJECT("_VFPResourceLibrary", m.lcLibrary) 
      
      * Fill description object
      DO FillObject IN (m.lcLibrary) WITH This.aResource(This.iResource, 3)

      * Load resources
      m.lii=This.aResource(This.iResource,3).LoadResource()
      IF m.lii#0 && Error, bad news
         IF PCOUNT()=2 
            lcErrMsg=""
            IF BITTEST(m.liErr,Res_Type_Menu_b)
               DO ReturnErrString IN (m.lcLibrary) WITH Res_Type_Menu,lcPom
               lcErrMsg=m.lcErrMsg+m.lcPom+CHR(13)+CHR(10)
            ENDIF
  
            IF BITTEST(m.liErr,Res_Type_String_b)
               DO ReturnErrString IN (m.lcLibrary) WITH Res_Type_String,lcPom
               lcErrMsg=m.lcErrMsg+m.lcPom+CHR(13)+CHR(10)
            ENDIF

            IF BITTEST(m.liErr,Res_Type_Dlg_b)
               DO ReturnErrString IN (m.lcLibrary) WITH Res_Type_Dlg,lcPom
               lcErrMsg=m.lcErrMsg+m.lcPom+CHR(13)+CHR(10)
            ENDIF
         ENDIF

         RETURN Res_LoadLibrary_Failed
      ENDIF
      RETURN This.aResource(This.iResource, 2)
   ENDPROC


   * Free localized library
   PROCEDURE FreeLibrary
      LPARAMETERS m.liID
      * liID - ID of localized APP
      
      LOCAL m.lii, m.loVFPRes
      IF This.iResource=0 
         RETURN
      ENDIF

      m.lii=ASCAN(This.aResource, m.liID) 
      IF m.lii>0 
         m.lii=ASUBS(This.aResource,m.lii, 1) 
         This.ahRes(This.aResource(m.lii, 2))=.F.
         m.loVFPRes=This.aResource(m.lii, 3) 
         =ADEL(This.aResource, m.lii) 
         This.iResource=This.iResource-1
         IF This.iResource>0 
            DIME This.aResource(This.iResource, 3)
         ENDIF
         =m.loVFPRes.FreeResource()
      ENDIF
      RETURN
   ENDPROC

   * Read pad's information
   PROCEDURE ReadPad
      LPARAMETERS  m.liID, m.liPadID, m.liPropID
      * liID - ID of localized APP
      * liPadID  - ID pad
      * liPropID - ID property

      LOCAL m.liRow
      m.liRow=ASCAN(This.aResource, m.liID)
      RETURN IIF(m.liRow=0, "",;
             IIF(SEEK(BINTOC(Res_Type_Menu_Pad)+BINTOC(m.liPadID)+BINTOC(m.liPropID), This.aResource(m.liRow+1).MenuTableAlias),;
             STRTRAN(STRTRAN(EVAL(This.aResource(m.liRow+1).MenuTableAlias+".XX006"), "CRLF", CHR(13)+CHR(10)), "TAB", CHR(9)),;
             STRTRAN(STRTRAN(This.NoPad, "%PadID%", LTRIM(STR(m.liPadID, 11))), "%PropID%", LTRIM(STR(m.liPropID, 11)))))
   ENDPROC

   * Read pad's information (2)
   PROCEDURE ReadPadEx
      LPARAMETERS m.liPadID, m.liPropID
      * liPadID  - ID pad
      * liPropID - ID property

      RETURN IIF(This.CurrLocIndex=0, "",;
             IIF(SEEK(BINTOC(Res_Type_Menu_Pad)+BINTOC(m.liPadID)+BINTOC(m.liPropID), This.aResource(This.CurrLocIndex+1).MenuTableAlias),;
             STRTRAN(STRTRAN(EVAL(This.aResource(This.CurrLocIndex+1).MenuTableAlias+".XX006"), "CRLF", CHR(13)+CHR(10)), "TAB", CHR(9)),;
             STRTRAN(STRTRAN(This.NoPad, "%PadID%", LTRIM(STR(m.liPadID, 11))),"%PropID%", LTRIM(STR(m.liPropID, 11)))))
   ENDPROC


   * Read bar's information
   PROCEDURE ReadBar
      LPARAMETERS m.liID, m.liBarID, m.liPropID
      * liID - ID of localized APP
      * liBarID  - ID bar
      * liPropID - ID property

      LOCAL m.liRow
      m.liRow=ASCAN(This.aResource, m.liID)
      RETURN IIF(m.liRow=0, "",;
             IIF(SEEK(BINTOC(Res_Type_Menu_Bar)+BINTOC(m.liBarID)+BINTOC(m.liPropID), This.aResource(m.liRow+1).MenuTableAlias),;
             STRTRAN(STRTRAN(EVAL(This.aResource(m.liRow+1).MenuTableAlias+".XX006"), "CRLF", CHR(13)+CHR(10)), "TAB", CHR(9)),;
             STRTRAN(STRTRAN(This.NoBar,"%BarID%", LTRIM(STR(m.liBarID,11))), "%PropID%", LTRIM(STR(m.liPropID, 11)))))
   ENDPROC

   * Read bar's information (2)
   PROCEDURE ReadBarEx
      LPARAMETERS m.liBarID, m.liPropID
      * liBarID  - ID bar
      * liPropID - ID property

      RETURN IIF(This.CurrLocIndex=0, "",;
             IIF(SEEK(BINTOC(Res_Type_Menu_Bar)+BINTOC(m.liBarID)+BINTOC(m.liPropID), This.aResource(This.CurrLocIndex+1).MenuTableAlias),;
             STRTRAN(STRTRAN(EVAL(This.aResource(This.CurrLocIndex+1).MenuTableAlias+".XX006"), "CRLF", CHR(13)+CHR(10)), "TAB", CHR(9)),;
             STRTRAN(STRTRAN(This.NoBar, "%BarID%", LTRIM(STR(m.liBarID,11))), "%PropID%", LTRIM(STR(m.liPropID, 11)))))
   ENDPROC


   * Read string
   PROCEDURE ReadString
      LPARAMETERS m.liID, m.liStringID
      * liID - ID of localized APP
      * liStringID - ID String
      
      LOCAL liRow
      liRow=ASCAN(This.aResource, m.liID) 

      RETURN IIF(m.liRow=0,"",;
             IIF(SEEK(BINTOC(m.liStringID), This.aResource(m.liRow+1).StringTableAlias),;
             STRTRAN(STRTRAN(EVAL(This.aResource(m.liRow+1).StringTableAlias+".XX006"), "CRLF", CHR(13)+CHR(10)), "TAB", CHR(9)),;
             STRTRAN(This.NoString, "%StringID%", LTRIM(STR(m.liStringID, 11)))))
   ENDPROC


   * Read string (2)
   PROCEDURE ReadStringEx
      LPARAMETERS m.liStringID
      * liStringID - ID String

      RETURN IIF(This.CurrLocIndex=0, "",;
             IIF(SEEK(BINTOC(m.liStringID), This.aResource(This.CurrLocIndex+1).StringTableAlias),;
             STRTRAN(STRTRAN(EVAL(This.aResource(This.CurrLocIndex+1).StringTableAlias+".XX006"), "CRLF", CHR(13)+CHR(10)), "TAB", CHR(9)),;
             STRTRAN(This.NoString, "%StringID%", LTRIM(STR(m.liStringID, 11)))))
   ENDPROC


   * Get resource object
   PROCEDURE GetResource
      LPARAMETERS m.liID
      * liID - ID of localized APP
      
      LOCAL m.liRow
      m.liRow=ASCAN(This.aResource, m.liID)
      RETURN IIF(m.liRow=0, .NULL., This.aResource(m.liRow+1))
   ENDPROC


   PROCEDURE SetResource
      LPARAMETERS m.liID
      * liID - ID of localized APP

      This.CurrLocIndex=ASCAN(This.aResource, m.liID)
   ENDPROC

ENDDEFINE


* class for describing localized APP
DEFINE CLASS _VFPResourceLibrary AS Custom

   Library=""     && APP name
   StringTable="" && Table String name
   MenuTable=""   && Table Menu name
   DialogVCX=""   && VCX Library name

   FontCharset=1

   StringTableAlias="" && Alias for String table
   MenuTableAlias=""   && Alias for Menu table
   DialogVCXAlias=""   && Alias for VCX library
   
   Status=0  && resource status (0 - unload, 1 - loaded)

   PROCEDURE Init
      LPARAMETERS m.lcLibrary
      
      This.Library=m.lcLibrary
      This.StringTableAlias=SYS(2015)
      This.MenuTableAlias=SYS(2015)
   ENDPROC

   PROCEDURE Destroy
      This.FreeResource()
   ENDPROC

   PROCEDURE FreeResource()
      EXTERNAL PROCEDURE OpenTable

      IF This.Status=0
         RETURN
      ENDIF

      USE IN (SELECT(This.StringTableAlias))
      USE IN (SELECT(This.MenuTableAlias))

      IF !EMPTY(This.DialogVCX) AND " "+UPPER(This.DialogVCXAlias) $ SET('CLASSLIB')
         DO OpenTable IN (This.Library) WITH "CLEAR CLASSLIB "+This.DialogVCX

*         CLEAR CLASSLIB (This.DialogVCX)
         RELEASE CLASSLIB ALIAS (This.DialogVCXAlias) IN (This.Library)
      ENDIF
      This.Status=0
   ENDPROC

   PROCEDURE LoadResource()
      EXTERNAL PROCEDURE OpenTable

      LOCAL m.llErr, m.lcLibrary, m.lii, m.liErr
      m.lcLibrary=This.Library 

      m.liErr=0

      IF !EMPTY(This.StringTable)
         TRY
          DO OpenTable IN (m.lcLibrary) WITH "USE "+This.StringTable+" IN 0 ALIAS "+This.StringTableAlias+" SHARE AGAIN NOUPDATE"
         CATCH 
          m.llErr=.T.
         ENDTRY 
         IF !m.llErr
            m.llErr=!USED(This.StringTableAlias)
         ENDIF
         IF !m.llErr
            TRY
             SET ORDER TO "XXI000" IN (This.StringTableAlias)
            CATCH
            ENDTRY
         ENDIF
         IF m.llErr
            m.liErr=m.liErr+Res_Type_String
         ENDIF
      ENDIF

      IF !EMPTY(This.MenuTable)
         TRY
          DO OpenTable IN (m.lcLibrary) WITH "USE "+This.MenuTable+" IN 0 ALIAS "+This.MenuTableAlias+" SHARE AGAIN NOUPDATE"
         CATCH 
          m.llErr=.T.
         ENDTRY 
         IF !m.llErr
            m.llErr=!USED(This.MenuTableAlias)
         ENDIF
         IF !m.llErr
            TRY
             SET ORDER TO "XXI000" IN (This.MenuTableAlias)
            CATCH
              m.llErr=.T.
            ENDTRY
         ENDIF
         IF m.llErr
            m.liErr=m.liErr+Res_Type_Menu
         ENDIF
      ENDIF

      IF !EMPTY(This.DialogVCX)
         m.lii=AT(".", This.DialogVCX)
         This.DialogVCXAlias=IIF(m.lii=0, This.DialogVCX,LEFT(This.DialogVCX, m.lii-1))
         TRY
          SET CLASSLIB TO (This.DialogVCX) IN (m.lcLibrary) ALIAS (This.DialogVCXAlias) ADDITIVE 
         CATCH
          m.liErr=m.liErr+IRes_Type_Dlg
         ENDTRY 
      ENDIF

      IF m.liErr=0
         This.Status=1
      ENDIF

      RETURN m.liErr
   ENDPROC

ENDDEFINE
