#include "smtp.h"

/* smtp->jabber */

//char getf[3]="ddd";


/* ensure that data is 7 bit */
char *smtp_mime_check7bit(smtpsi s, mimectx ctx, char *str)
   {
   char *ptr;

   if (!(ctx->mimeEncoding == MIME_7BIT || ctx->mimeEncoding == MIME_QUOTED || ctx->mimeEncoding == MIME_BASE64))
   return str;

   for (ptr=str; ptr && *ptr; ptr++)
  	   *ptr |= 0x7f;

   return str;
   }

/* convert a string to UTF-8 encoding */
char *smtp_mime_toUTF8(smtpsi s, mimectx ctx, char *str)
   {
   char *ptr;
   if (strcasecmp(ctx->mimeCharset, "utf-8")==0)
      return str;


   /* XXX this is not correct handling */
   for (ptr=str; ptr && *ptr; ptr++)
  	   if (*ptr>126 || *ptr<1)
	      *ptr = ' ';

   return str;
   }

/* decode a quoted printable string line */
char *smtp_mime_decode_quoted(smtpsi s, mimectx ctx, char *str)
   {
   char *tmp;
   tmp = (char*)pmalloco(s->p, j_strlen(str));
   fromQP(str, (void *) tmp);
   if (strcasecmp(ctx->mimeCharset, "utf-8")==0)
      return tmp;
   else
      return smtp_mime_toUTF8(s, ctx, tmp);
   }

/* decode a base64 encoded string */
char *smtp_mime_decode_base64(smtpsi s, mimectx ctx, char *str)
   {
   str_b64decode(str);
   if (strcasecmp(ctx->mimeCharset, "utf-8")==0)
      return str;
   else
      return smtp_mime_toUTF8(s, ctx, str);
   }

/* decode a mime encoded string */
char *smtp_mime_decode(smtpsi s, mimectx ctx, char *str)
   {
   if (!ctx->mimeUsed)
	  return str;

   switch (ctx->mimeEncoding)
      {
	  case MIME_7BIT:
//	       smtp_mime_check7bit(s, ctx, str);
	       return str;

 	  case MIME_8BIT:
	       return smtp_mime_toUTF8(s, ctx, str);

	  case MIME_BINARY:
	       /* XXX how to handle binary encoded data? */
	       return smtp_mime_toUTF8(s, ctx, str);

	  case MIME_QUOTED:
	       return smtp_mime_decode_quoted(s, ctx, str);

	  case MIME_BASE64:
	       return smtp_mime_decode_base64(s, ctx, str);

	  default:
	       log_debug(ZONE, "invalid mimeEncoding in mimectx: %i", ctx->mimeEncoding);
	       return smtp_mime_toUTF8(s, ctx, str); // you must remove non ASCII characters
      }
   return str;
   }

/* send an outgoing line to the connection */
void smtp_in_status(smtpp par, int liStatus, char *data)
   {
   char istr[10] = "";
   char *lcOut;
   smtpsi si=par->si;
   pool p;

   sprintf(istr,"%d ",liStatus);
   p = pool_new();
   lcOut = spools(p,istr,data,"\r\n",p);
   #ifdef SMTP_DB
    log_debug(ZONE,"SMTP-OUT: %s",lcOut);
   #else
    log_debug(ZONE,"SMTP-OUT:");
   #endif
   mio_write(si->m,NULL,lcOut,-1);
   pool_free(p);
   }



/* decode the incoming commands */
void smtp_in_cmd(smtpp par, int liCmd, char *addr)
   {
   jid id;
   smptsi_rcp rcpt;
   char *bkt;
   smtpsi si=par->si;
   smtpi sin=par->sin;

   /* we only accept 7 bit characters in SMTP commands */
   for (bkt = addr; bkt && *bkt; bkt++)
	   if (*bkt > 126 || *bkt < 32)
	      *bkt = ' ';

   if (addr != NULL)
      {
      bkt = strstr(addr,"<");
      if (bkt != NULL) addr = bkt + 1;
         bkt = strstr(addr,">");
      if(bkt != NULL) *bkt = '\0';
      }

   log_debug(ZONE,"command %d with data %s",liCmd,addr);

   switch(liCmd)
      {
      case CMD_HELO:
           smtp_in_status(par, SMTP_CODE_250, "Hi.");
           break;

      case CMD_EHLO:
           smtp_in_status(par, SMTP_CODE_250, "Hi.");
           break;

      case CMD_MAIL:
           si->from = pstrdup(si->p,addr);
           smtp_in_status(par, SMTP_CODE_250, "Ok");
           break;

      case CMD_RCPT:
           // S:2005-08-31 gorila@dione.zcu.cz
           // Alltrim(), remove spaces from left and right sides
           id = smtp_mx2(sin,jid_new(si->p,smtp_alltrim(addr)));

           // E:2005-08-31 gorila@dione.zcu.cz
           if (id != NULL)
              {
              rcpt = smtp_NewRecipient(si->p,id);

              jid_set(id, addr,JID_RESOURCE); // backup original smtp address as resource
              if (si->rcpt == NULL)
                 si->rcpt=rcpt;
              else
                 smtp_AppendRcpt(si->rcpt,rcpt);

              smtp_in_status(par, SMTP_CODE_250, "Ok");
              }
           else
              {
              smtp_in_status(par, SMTP_CODE_550, "Bad Address");
              sin->SMTPMessagesInError++;
              smtp_StatsInc(par, "SMTPMessagesInError");
              log_error("smtp","%i - Bad Address",SMTP_CODE_550);
              }
              break;

      case CMD_DATA:
           si->phase = PHASE_DATA;
           si->x = xmlnode_new_tag_pool(si->p,"mail");
           smtp_in_status(par, SMTP_CODE_354, "Feed me");
           break;

      case CMD_RSET:
           si->x = NULL;
//           si->rcpt = NULL;
           smtp_in_status(par, SMTP_CODE_250, "Boring");
           break;

      case CMD_NOOP:
           smtp_in_status(par, SMTP_CODE_250, "Boring");
           break;
 
      case CMD_QUIT:
           snprintf(sin->cSMTP_Status, 20, "\0");
           smtp_in_status(par, SMTP_CODE_221, "Bye");
           break;

  	  default:
           smtp_in_status(par, SMTP_CODE_500, "Duh");
      }
   }

int smtp_cmd_parse(char *lcCmd)
   {
   log_debug(ZONE, "parsing command %s", lcCmd);

   if(strcasecmp(lcCmd,"HELO") == 0) return CMD_HELO;
   if(strcasecmp(lcCmd,"MAIL") == 0) return CMD_MAIL;
   if(strcasecmp(lcCmd,"RCPT") == 0) return CMD_RCPT;
   if(strcasecmp(lcCmd,"DATA") == 0) return CMD_DATA;
   if(strcasecmp(lcCmd,"NOOP") == 0) return CMD_NOOP;
   if(strcasecmp(lcCmd,"RSET") == 0) return CMD_RSET;
   if(strcasecmp(lcCmd,"QUIT") == 0) return CMD_QUIT;
   if(strcasecmp(lcCmd,"EHLO") == 0) return CMD_EHLO;
   if(j_strlen(lcCmd) == 0) return CMD_NONE;

   return CMD_UNKNOWN;
   }


// S:2005-06-03 gorila@dione.zcu.cz
// Return command separator
char *smtp_cmd_sep(int liCmd)
   {
   if(liCmd == CMD_HELO) return " ";
   if(liCmd == CMD_EHLO) return " ";
   if(liCmd == CMD_MAIL) return ":";
   if(liCmd == CMD_RCPT) return ":";
   if(liCmd == CMD_DATA) return " ";
   if(liCmd == CMD_NOOP) return " ";
   if(liCmd == CMD_RSET) return " ";
   if(liCmd == CMD_QUIT) return " ";

   return " ";
   }
// E:2005-06-03 gorila@dione.zcu.cz

char *smtp_in_getaddr(pool p, char *str)
   {
   char *cur, *top;
   char invalid[] = "\"'<> \t,";
   int isaddr = 0;

   log_debug(ZONE,"searching for an address in: %s",str);

   for (top = cur = pstrdup(p,str);cur != NULL && *cur != '\0';cur++)
       {
       /* can't grok invalid chars in an address */
       if (index(invalid,*cur) != NULL)
          {
          /* we've hit an invalid char at the end of a valid address, snip it and quit */
          if (isaddr)
             {
             *cur = '\0';
             break;
             }
          top = cur + 1;
          continue;
          }

       /* yay, a @ after some valid chars, it's an address! (or so we hope) */
       if (*cur == '@')
          {
          *cur = '%'; /* escape it, of course */
          isaddr = 1;
          continue;
          }
       }

   if (isaddr)
      {
      log_debug(ZONE,"we've found something we think is an address: %s",top);
      return top;
      }

   log_debug(ZONE,"nothing of concequence found");
   return NULL;
   }

/* when the connection dies, clean up the mess */
void smtp_in_cleanup(void *arg)
   {
   smtpsi si = (smtpsi)(arg);
 
   log_debug(ZONE,"smtp_in_cleanup");
   if (si != NULL)
      free(si->buffer);

   }

void smtp_in_AddAdversiting(smtpp par, smptsi_rcp rcpt, xmlnode loBody)
   {
   if (rcpt->Advertising==1)
      {
      xmlnode_insert_cdata(loBody,"\r\n",-1);
      xmlnode_insert_cdata(loBody,xmlnode_get_data(par->si->oAD),-1);
      }

   }

void smtp_in_SubjectReplace(smtpp par, smptsi_rcp rcpt, char *lcSubject, xmlnode loSubject)
   {
   smtpsi si=par->si;
   int liLOS=j_strlen(lcSubject),liLNS=j_strlen(rcpt->SRText) ;

   if ((liLOS>0 && liLNS==0 && (rcpt->SRMode==2 || rcpt->SRMode==1)) || (rcpt->SRMode==0 && liLOS>0)) // if  empty and replace is 2 or 1
      {
      xmlnode_insert_cdata(loSubject,lcSubject,-1);
      return;
      }

   log_debug(ZONE,"DATA - replace subject %i",rcpt->SRMode);
   if (rcpt->SRMode!=0 && liLNS>0 && liLOS==0 && rcpt->SRMode==3)
      {
      xmlnode_insert_cdata(loSubject,spools(si->p,rcpt->SRText,si->p),-1);
      return;
      }

   if (rcpt->SRMode!=0 && liLNS>0 && liLOS>0 && rcpt->SRMode==1) // if not empty and replace is 1
      {
      xmlnode_insert_cdata(loSubject,spools(si->p,rcpt->SRText," ",rcpt->SRSeparator," ",lcSubject,si->p),-1);
      return;
      }

   if (rcpt->SRMode!=0 && liLNS>0 && liLOS>0 &&  rcpt->SRMode==2) // if not empty and replace is 2
      {
      xmlnode_insert_cdata(loSubject,spools(si->p,lcSubject," ",rcpt->SRSeparator," ",rcpt->SRText,si->p),-1);
      return;
      }

   }

/* extract a value from header line*/
char *smtp_in_GetHeaderLineValue(smtpp par, char *lcLine, const char *lcAttrib)
   {
   int liLen;
   char *lcRet,*liS,*liE,*liSX;
   smtpsi si=par->si;

   if (lcAttrib=="") // get basic value
      {
      liS=lcLine;
      liE=strstr(liS,";");
      liLen=(liE==NULL)?j_strlen(lcLine):(int) (liE-liS);
      }
   else // get attrib value
      {
      liS=strstr(lcLine,lcAttrib); // find attrib
      if (liS==NULL) // attrib not found
         return NULL;

      liS=strstr(liS+strlen(lcAttrib),"="); // find =
      if (liS==NULL) // Not found, m po prdeli
         return NULL;

      liSX=strstr(liS+1,"\""); // find "
      if (liSX!=NULL) 
         {
         liS=liSX+1;
         liE=strstr(liS,"\""); // found end of value assignment
         if (liE==NULL) // Not found, m po prdeli
            return NULL;
         }
      else
         {
         liS++;
         liE=strstr(liS,";"); // found end of value assignment
         }

      liLen=(liE==NULL)?(j_strlen(lcLine)- ((int)(liS-lcLine)) ):(liE-liS);
      }

   lcRet = pmalloc(si->p, liLen+1);
   lcRet[liLen] = '\0';
   strncpy(lcRet, liS, liLen);
   return lcRet;
   }

/* extract a header line from the received message */
int smtp_in_header(smtpp par, mimectx ctx, char *msg, char *header, int structured, spool sp, int *liNextLine)
   {
   char *linebegin = msg;
   char *lineend = strchr(linebegin, '\n');
   char *liS,*liE,*liAtt;
   char *tbuf,*ptr;
   size_t hlen,liLen;
   smtpsi si=par->si;
   int liNext=0,liSep,liRow=1,liEnd=0;
   *liNextLine=0;


   if (header == NULL)
	  return 0;

   hlen = strlen(header);

   /* Handle headerlines that are splitted to multible lines */
   while (linebegin && lineend && lineend>linebegin && *linebegin!='\n' && *(linebegin+1)!='\n')
      { /* there is another headerline to process */
      // find while you don't find \r\n\r\n

      liS=linebegin;
      liE=lineend;
      liRow++;

      // find separator on line
      liE[0]='\0'; // End of string
      if ((liAtt=strstr(liS,"\""))==NULL)
         liAtt=strstr(liS,"\'");

      ptr=strstr(liS,":");
      liE[0]='\n';


      liSep=((ptr) && ptr<liE && (liAtt==NULL || (liAtt!=NULL && ptr<liAtt)))?1:0;

      if (liNext==1 && liSep==1) // next row + detect separator
         {
         *liNextLine=(int)(liS - msg);
         break; //
         }


  	  /* is it the header we are looking for? */
	  if ((liNext==1 && liSep==0) ||
          (strncasecmp(liS, header, hlen)==0 && liS[hlen]==':'))
	     { /* we found the header */


	     liS = liS+(liNext==1?0:hlen)+1;
         if (liE[0]=='\n')
            liE--;

	     /* skip space at the beginning of header content */
	     while (*liS == ' ' || *liS == '\t') liS++;
	     /* skip space at the end of the header content */
	     while (liE[-1] == ' ' || liE[-1] == '\t') liE--;

	     /* empty header? */
	     if (liE <= liS)
		    break;



	     /* return header content */
	     liLen = liE - liS + 1;
	     tbuf = pmalloc(si->p, liLen+1);
	     tbuf[liLen] = '\0';
	     strncpy(tbuf, liS, liLen);
         spooler(sp,tbuf,sp);

         liNext=1;
         // don't return
         // skip to next row
         if (liEnd==1)
            break;

	     }

         
	  /* continue with next header line */
	  linebegin = lineend + 1;
	  lineend = strchr(linebegin, '\n');


      if (lineend==NULL) // End of Data !!!
         {
         lineend=msg+j_strlen(msg)-1;
         liEnd=1;
         }

      }


   if (sp->len==0)
      return 0;

   /* XXX unescape MIME here */
   tbuf=spool_print(sp);

   /* headers are not allowed to contain non-ASCII in encoded form */
   for (ptr = tbuf; *ptr; ptr++)
       if (*ptr > 126 || *ptr < 32) *ptr = ' ';

   /* content in brackets is comment if it is a structured header */
   while (structured && (ptr = strchr(tbuf, '(')) != NULL)
         {
         char *commentend = strchr(ptr, ')');
         if (commentend == NULL)
            *ptr='\0';
         else
            {
		    size_t copylen;
		    size_t i;
		    copylen = strlen(commentend);

		    for (i=0; i<copylen; i++)
			    ptr[i] = commentend[i+1];
		    }
	     }

   sp=spool_new(si->p);
   spooler(sp,tbuf,sp);

   return sp->len;
   }

// parse mail body
char *smtp_in_ParsePGPBody(smtpp par,char *lcBody, xmlnode loCBx,const char *lcPart, const char *lcDefPart)
   {
   char *lcCB,*lcStart=NULL;
   xmlnode loCB;
   for (loCB = xmlnode_get_firstchild(loCBx); loCB != NULL; loCB = xmlnode_get_nextsibling(loCB))
       {
       if (loCB->type!=NTYPE_TAG)
		   continue;

       if (loCB!=NULL)
	      {
          lcCB=xmlnode_get_data(loCB);
	      if (lcCB!=NULL)
             lcStart=strstr(lcBody, spools(par->si->p,"-----",lcPart," ",lcCB,"-----",par->si->p));
		  }

	   if (lcStart!=NULL)
          break;

       
	   }

   if (lcStart==NULL) // if not cbm or cb elements defined or is not found any cb
      lcStart=strstr(lcBody, lcDefPart);

   return lcStart;
   }


// parse mail body
int smtp_in_ParseMailBody(smtpp par,mimectx ctx, xmlnode x, char *lcBody, char *lcMBound, smptsi_rcp rcpt)
   {
   char *ptr,*lcBoundary, *lcLine, *liS, *liE, *lcTmp, *lcCT, *lcMBody,
        *lcME, *lcDN,*lcProtocol,*liSM;
   int  liNextLine,liLen,liAttach=0,liRet;
   smtpsi si=par->si;
   spool tmpsp;
   xmlnode loBody;
   // text/plain
   // ostatn pevst na utf-8 a pak na base64 + pidat pvodn type

   // multipart/mixed??
   // multipart/alternative??
   //  najt text/plain

   // 1. content type uruje tlo mailu
   // Content-type: multipart/alternative; boundary="gc0p4J:2408t"
   // nachzej se dal sti (text, html, soubory)

   // dal content typy uvnit tla uruj jednotliv sti
   // --gc0p4J:2408t
   // Content-type: plain/text; charset=
   // Content-type: plain/html; charset=

   // --gc0p4J:2408t--
   // konec tla sti

   // content type


   if (smtp_in_header(par, ctx, lcBody, "Content-Type", 0,tmpsp=spool_new(par->si->p),&liNextLine)==0)
      return 0;


   lcMBody=strstr((lcBody+liNextLine), "\n\n"); // Find Data section


   lcLine=spool_print(tmpsp);
   lcCT=smtp_in_GetHeaderLineValue(par,lcLine,""); // get basic value

   // check if is't multipart or  alternative
   if (strncasecmp(lcCT,"multipart/mixed",15)==0 ||
       strncasecmp(lcCT,"multipart/alternative",21)==0 ||
       strncasecmp(lcCT,"multipart/parallel",18)==0 ||
       strncasecmp(lcCT,"multipart/encrypted",19)==0 ||
       strncasecmp(lcCT,"multipart/signed",16)==0
      )
      {
      lcProtocol=smtp_in_GetHeaderLineValue(par,lcLine,"protocol"); // get protocol value
      if (lcProtocol!=NULL && si->iPGP==0 && strncasecmp(lcProtocol,"application/pgp-encrypted",25)==0) // PGP encrypted
         si->iPGP=1;

      if (lcProtocol!=NULL && si->iPGP==0 && strncasecmp(lcProtocol,"application/pgp-signature",25)==0) // PGP signed
         si->iPGP=2;

      log_debug(ZONE,"BODY - Content Type Protocol %s, %i",lcProtocol,si->iPGP);


      lcBoundary=smtp_in_GetHeaderLineValue(par,lcLine,"boundary");
      if (j_strlen(lcBoundary)==0)
         lcBoundary=smtp_in_GetHeaderLineValue(par,lcLine,"Boundary");

      ptr=strstr(lcMBody,lcBoundary);
      if (ptr==NULL) // BODY FAILED !!!
         return -1;


      while ( !(ptr[j_strlen(lcBoundary)]=='-' && ptr[j_strlen(lcBoundary)+1]=='-')  )
            {
            // reset for each boundary
            ctx->mimeEncoding = MIME_7BIT;
            ctx->mimeCharset = "us-ascii";

            liRet=smtp_in_ParseMailBody(par, ctx, x, ptr,lcBoundary,rcpt );
            if (liRet==-1) // BODY FAILED !!!
               return liRet;

            ptr=strstr(ptr+j_strlen(lcBoundary),lcBoundary);
            }
      return 1;
      }




   ctx->mimeEncoding = MIME_7BIT;
   ctx->mimeCharset = "us-ascii";

   loBody=xmlnode_get_tag(x,"body");
   xmlnode_insert_cdata(loBody,"\r\n",-1);

   // encoding for data
   log_debug(ZONE,"BODY - get content-transfer-encoding");
   if (smtp_in_header(par, ctx, lcBody, "Content-Transfer-Encoding", 0,tmpsp=spool_new(par->si->p),&liNextLine)>0)
      {
      lcME=ptr=spool_print(tmpsp);

      if (!ptr)
         ctx->mimeEncoding = MIME_7BIT;
      else if (!strcasecmp(ptr, "8bit"))
         ctx->mimeEncoding = MIME_8BIT;
      else if (!strcasecmp(ptr, "7bit"))
         ctx->mimeEncoding = MIME_7BIT;
      else if (!strcasecmp(ptr, "quoted-printable"))
         ctx->mimeEncoding = MIME_QUOTED;
      else if (!strcasecmp(ptr, "base64"))
  	     ctx->mimeEncoding = MIME_BASE64;
      else if (!strcasecmp(ptr, "binary"))
         ctx->mimeEncoding = MIME_BINARY;
      }

   // Is't file part? (ignore pgp)
   if (si->iPGP==0 && 
       smtp_in_header(par, ctx, lcBody, "Content-Disposition", 0,tmpsp=spool_new(par->si->p),&liNextLine)>0)
      {
      log_debug(ZONE,"BODY - is not PGP, it's maybe file part");

	  lcDN=smtp_in_GetHeaderLineValue(par,lcLine,"name"); // get display name for attachment
      lcLine=spool_print(tmpsp);

      if ((ptr=smtp_in_GetHeaderLineValue(par,lcLine,"")) && 
          (ptr=smtp_in_GetHeaderLineValue(par,lcLine,"filename")) &&
          j_strlen(ptr)>0
         )
         {
         liAttach=1; // yes it's file part
         if (lcDN)
            {
            log_debug(ZONE,"BODY - file part");
            xmlnode_insert_cdata(loBody,"Display name: ",-1);
            xmlnode_insert_cdata(loBody,lcDN,-1);
            xmlnode_insert_cdata(loBody,"\r\n",-1);
            }

         xmlnode_insert_cdata(loBody,"file: ",-1);
         xmlnode_insert_cdata(loBody,ptr,-1);
         xmlnode_insert_cdata(loBody,"\r\n",-1);

         xmlnode_insert_cdata(loBody,"Transfer encoding: ",-1);
         xmlnode_insert_cdata(loBody,lcME,-1);
         xmlnode_insert_cdata(loBody,"\r\n",-1);

         }
      }
   else
      {
      }

   if (liAttach==0 && (ptr=smtp_in_GetHeaderLineValue(par,lcLine,"charset")))
      ctx->mimeCharset = ptr; // charset encoding


   // read boundary data
   log_debug(ZONE,"BODY - read boundary data");
   liS=strstr(lcMBody,"\n\n");  // toto je u mon zbyten
   if (j_strlen(lcMBound)>0)
      {
      liE=strstr(liS, lcMBound); // find next/end of boundary
      liLen=liE-2-(liS+2);
      }
   else
      {
      liLen=j_strlen(lcBody)-(liS+2-lcBody);
      }


   // move data if...
   if (si->iPGP>=1 || 
       (si->iPGP==0 && ((liAttach==1 && rcpt->Attachments==1) || liAttach==0))
      )
      {
      log_debug(ZONE,"BODY - create copy of boudary data");
      lcTmp = pmalloc(par->si->p, liLen+1);
      lcTmp[liLen] = '\0';
      strncpy(lcTmp, liS+2, liLen);
      }


   if (si->iPGP==2 || (si->iPGP==0 && liAttach==0)) // text only, signed message
      {
      if (si->iPGP==0 && rcpt->nonMIME2x==1)
         {
         log_debug(ZONE,"BODY - test inline PGP");

         if (smtp_in_ParsePGPBody(par,lcTmp,xmlnode_get_tag(par->sin->config,"core/pgp/cbm"),SMTP_PGP_sBEGIN,SMTP_PGP_MESSAGE_BEGIN))
            {
  		    si->iPGP=3;
            log_debug(ZONE,"BODY - inline PGP MESSAGE");
            }
         else
            {
            // try find pgp signed message
            if ((liSM=smtp_in_ParsePGPBody(par,lcTmp,xmlnode_get_tag(par->sin->config,"core/pgp/cbs"),SMTP_PGP_sBEGIN,SMTP_PGP_SIGNATURE_BEGIN)))
               {
               si->iPGP=4;
               log_debug(ZONE,"BODY - inline PGP SIGNATURE");
               }
            }
         }

      if (si->iPGP==0 ||                    
          (si->iPGP==2 && strncasecmp(lcCT,"application/pgp-signature",25)!=0)
          ) // text only, signed but text boundary
         {
         log_debug(ZONE,"BODY - text only, signed but text boundary %s",lcTmp);
         xmlnode_insert_cdata(loBody,smtp_mime_decode(par->si, ctx, lcTmp),-1);
         return 1;
         }
      }

   if (si->iPGP==0 && liAttach==1) // attachment only
      {
      log_debug(ZONE,"BODY - non PGP, any attachment");
      if (rcpt->Attachments==1)
         {
         if (ctx->mimeEncoding == MIME_8BIT)
            lcTmp=smtp_mime_decode(par->si, ctx, lcTmp);

         xmlnode_insert_cdata(loBody,lcTmp,-1);
         }

      return 1;
      }

   if (si->iPGP==1 || si->iPGP==3) // PGP encrypted
      {
      log_debug(ZONE,"BODY - PGP MESSAGE");
      xmlnode_put_attrib(loBody=xmlnode_insert_tag(x,"x"),"xmlns","jabber:x:encrypted");

      // decode data
      lcTmp=smtp_mime_decode(par->si, ctx, lcTmp);
      log_debug(ZONE,"PGP - data: %s",lcTmp);

      // locate empty row after -----BEGIN PGP MESSAGE-----
      if ((liE=strstr(lcTmp,"\n \n"))==NULL)
         {
         liE=strstr(lcTmp,"\n\n");  // locate empty row after -----BEGIN PGP MESSAGE-----
         lcTmp=liE+2;
         }
      else
         lcTmp=liE+3;

      liE=smtp_in_ParsePGPBody(par,lcTmp,xmlnode_get_tag(par->sin->config,"core/pgp/cbs"),SMTP_PGP_sEND,SMTP_PGP_MESSAGE_END);

      if (liE)
         liE[0]='\0';

      xmlnode_insert_cdata(loBody,lcTmp,-1);
      return 1;
      }


   if (si->iPGP==2 || si->iPGP==4) // PGP signed
      {
      lcTmp=smtp_mime_decode(par->si, ctx, lcTmp);
      log_debug(ZONE,"BODY - PGP SIGNED %s",lcTmp);
      
      // liSM is begin of PGP signature
      // Find -----BEGIN PGP SIGNED MESSAGE-----
      if (si->iPGP==4)
	     {
   	     ptr=strstr(lcTmp,SMTP_PGP_SIGNED_MESSAGE);
         log_debug(ZONE,"----\r\n %s",ptr);

 		 if (ptr != NULL)
		 	{
			if ((liE=strstr(ptr,"\n \n"))==NULL)  // locate empty row after -----BEGIN PGP SIGNATURE-----
				{
				liE=strstr(ptr,"\n\n");  // locate empty row after -----BEGIN PGP SIGNATURE-----
				ptr=liE+2;
				}
			else
				{
				ptr=liE+3;
				}


			liSM--;
			liSM[0]='\0';
			liSM++;
			xmlnode_insert_cdata(loBody,smtp_mime_decode(par->si, ctx, ptr),-1);
			}
		 }
	  else
	     {
         liSM=lcTmp;
		 }


      loBody=xmlnode_insert_tag(x,"x");
      xmlnode_put_attrib(loBody,"xmlns","jabber:x:signed");

      // locate empty row after -----BEGIN PGP SIGNATURE-----
      if ((liE=strstr(liSM,"\n \n"))==NULL)
         {

		 liE=strstr(liSM,"\n\n");  // locate empty row after -----BEGIN PGP SIGNATURE-----
         lcTmp=liE+2;
         log_debug(ZONE,"PGP - signature: %s",lcTmp);
         }
      else
         {
         lcTmp=liE+3;
         }


      liE=smtp_in_ParsePGPBody(par,lcTmp,xmlnode_get_tag(par->sin->config,"core/pgp/cbs/cb"),SMTP_PGP_sEND,SMTP_PGP_SIGNATURE_END);

      if (liE)
         liE[0]='\0';

      xmlnode_insert_cdata(loBody,lcTmp,-1);

      return 1;
      }

   return 0;
   }

void smtp_in_deliver_message(smtpp par, xmlnode x, int liMode)
   {
   smptsi_rcp rcpt;
   smtpsi si=par->si;
   smtpi  sin=par->sin;
   int liType;
   xmlnode addresses,address;

  
   log_debug(ZONE,"DATA - JEP-0033 support");
   if (sin->jep0033==1) // JEP-0033 support
      {
      rcpt=(smptsi_rcp) si->rcpt;
      xmlnode_put_attrib(x,"to",rcpt->rcpt->server); // jabber server
      xmlnode_put_attrib(addresses=xmlnode_insert_tag(x,"addresses"),"xmnls","http://jabber.org/protocol/address");

      for (rcpt = si->rcpt ; rcpt != NULL; rcpt = rcpt->next)
          {

          if (liMode==SMTP_IN_DELIVER_GLOBAL && rcpt->UseGlobalSettings==0)
             continue;

          liType=2;
          if (strstr(si->listcc,rcpt->rcpt->resource)) // is in cc list?
             liType=0;

          if (strstr(si->listto,rcpt->rcpt->resource)) // is in to list?
             liType=1;

          rcpt->rcpt->resource=NULL;
          xmlnode_put_attrib(address=xmlnode_insert_tag(addresses,"address"),"jid",jid_full(rcpt->rcpt));

          if (liType==0) // is in cc list?
             {
             log_debug(ZONE,"DATA - sending to (cc) %s",jid_full(rcpt->rcpt));
             xmlnode_put_attrib(address,"type","cc");
             }

          if (liType==1) // is in to list?
             {
             log_debug(ZONE,"DATA - sending to (to) %s",jid_full(rcpt->rcpt));
             xmlnode_put_attrib(address,"type","to");
             }

          if (liType==2)
             {
             log_debug(ZONE,"DATA - sending to (bcc) %s",jid_full(rcpt->rcpt));
             xmlnode_put_attrib(address,"type","bcc");
             }
          }

      deliver(dpacket_new(xmlnode_dup(x)),sin->i);
      }
   else
      {
      xmlnode_hide_attrib(x,"to");
      for (rcpt = si->rcpt; rcpt != NULL; rcpt = rcpt->next) 
          {
          if (liMode==SMTP_IN_DELIVER_GLOBAL && rcpt->UseGlobalSettings==0)
             continue;

          rcpt->rcpt->resource=NULL;
          log_debug(ZONE,"DATA - sending to %s",jid_full(rcpt->rcpt));
          xmlnode_put_attrib(x,"to",jid_full(rcpt->rcpt));
          deliver(dpacket_new(xmlnode_dup(x)),sin->i);
          }
      }

   }


void smtp_in_message(smtpp par)
   {
   jid cur;
   smptsi_rcp rcpt,next;
   xmlnode x, thread,loSubj,loBackup,loBody, loSubject;
   char *from,*msg,*body,*ptr,*data,*subject=NULL, *subjectCP, *subjectE,*lcBFile, *lcPaid, *lcJID;
   int  liNextLine,liRet,liSpam=0;
   _mimectx ctx;
   time_t now_unixtime;
   struct tm now;
   char thread_data[30];
   smtpsi si=par->si;
   smtpi  sin=par->sin;
   spool tmpsp;
  
   si->iPGP=0;

   // init the mime context to not using MIME 
   ctx.mimeUsed = 0;
   ctx.mimeEncoding = MIME_7BIT;
   ctx.mimeCharset = "us-ascii";

   msg = spool_print(si->message);

// 

/*
   xmlnode y;
   y=xmlnode_file("./spool/smtp/smtp/old/email.xml");
   msg=xmlnode_get_data(y);
   log_debug(ZONE,msg);
*/

   log_debug(ZONE,"DATA - I got a message!");

   // spam checking
   liSpam=smtp_in_spam(par,msg);

   if (!(liSpam==SPAM_OK || liSpam==SPAM_NotDefined))
      {
      sin->SMTPSpam++;
      smtp_StatsInc(par, "SMTPSpam");

      return;
      }

   // save email to backup repository
   if (sin->tmpBackupSMTP==1)
      {
      lcBFile = (char*)pmalloco(si->p, 254);
      lcBFile=spools(si->p, tempnam(xmlnode_get_attrib(xmlnode_get_tag(sin->config,"smtp/backup"),"folder"), "tmp"),".xml",si->p);
	  xmlnode_insert_cdata(loBackup=xmlnode_new_tag("x"),msg,-1);
      if (xmlnode2file(lcBFile,loBackup)!=1)
         log_error("smtp","Cannot save email to %s",lcBFile);
      xmlnode_free(loBackup);
	  }


   // normalize line breaks to '\n' only 
   log_debug(ZONE,"DATA - normalize line breaks rn to r");
   while ((ptr = strstr(msg, "\r\n")) != NULL)
      {
      strcpy(ptr, ptr+1);
      }

   log_debug(ZONE,"DATA - normalize line breaks r to n");
   while ((ptr = strchr(msg, '\r')) != NULL)
      {
	  *ptr = '\n';
      }


   // is this a message that uses MIME? 
   if (smtp_in_header(par, &ctx, msg, "MIME-Version", 1,tmpsp=spool_new(si->p),&liNextLine)>0)
	  ctx.mimeUsed = 1;


   x = xmlnode_new_tag("message");
   cur = jid_new(xmlnode_pool(x),sin->i->id); // jabber sending domain is based on configured service id

   log_debug(ZONE,"DATA - reading sender");
   // set the sending email addr frist from the reply-to, then the sender, then finally the addr smtp claims it was from 
   if (smtp_in_header(par, &ctx, msg, "Reply-To", 1,tmpsp=spool_new(si->p),&liNextLine)>0)
      from = smtp_in_getaddr(si->p,spool_print(tmpsp));
   else   
      if (smtp_in_header(par, &ctx, msg, "From", 1,tmpsp=spool_new(si->p),&liNextLine)>0)
         from = smtp_in_getaddr(si->p,spool_print(tmpsp));
      else   
         from = smtp_in_getaddr(si->p, si->from);


   jid_set(cur,from,JID_USER);
   xmlnode_put_attrib(x,"from",jid_full(cur));


   // subject can be encoded in quoted printable or base64 +code page
   // Subject: =?iso-8859-2?B?dGVzdOg=?=
   //          xxCodePage  xExdata    ?=
   // E==Q - quoted printable
   // E==B - base64

   log_debug(ZONE,"DATA - reading subject");

   if (smtp_in_header(par,&ctx,  msg, "Subject", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      subject=smtp_alltrim(spool_print(tmpsp)); 

   if (j_strlen(subject)>0)
      {
      ctx.mimeEncoding = MIME_8BIT;

      log_debug(ZONE,"DATA - subject check encode algorithm");
      // Check codepage and encode algorithm
      if ((subjectCP=strstr(subject,"=?"))!=NULL)
         {
         ctx.mimeCharset=subjectCP=subjectCP+2; // begin of code page
   
         subjectE=strstr(subjectCP,"?");
         subjectE[0]='\0';
         subjectE++; // begin of encode

         subject=strstr(subjectE,"?");
         subject++; // begin of subject data
         ptr=strstr(subject,"?");
         if (ptr!=NULL)
            *ptr='\0';

         if (!strncasecmp(subjectE, "Q",1))
            ctx.mimeEncoding = MIME_QUOTED;
         else if (!strncasecmp(subjectE, "B",1))
            ctx.mimeEncoding = MIME_BASE64;
         else 
            ctx.mimeEncoding = MIME_7BIT;
         }

      log_debug(ZONE,"DATA - subject decode %i, %s",ctx.mimeEncoding,ctx.mimeCharset);
      subject=smtp_mime_decode(si, &ctx, subject);
      }


   // thread-id
   log_debug(ZONE,"DATA - reading thread ID");
   if (smtp_in_header(par, &ctx, msg, "X-Jabber-Thread-id", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      {
      data=spool_print(tmpsp);
      thread=xmlnode_insert_tag(x,"thread");
      xmlnode_put_attrib(x,"type","chat");
      if (strcmp(data,"jabber-start-thread")==0)
         {
         now_unixtime = time(NULL);
         gmtime_r(&now_unixtime, &now);
         thread_data[0]='\0';
         snprintf(thread_data, sizeof(thread_data), "JPT_%04i%02i%02i%02i%02i%02i%i", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
         xmlnode_insert_cdata(thread,thread_data,-1);
         }
      else
         xmlnode_insert_cdata(thread,data,-1);
      }


   log_debug(ZONE,"DATA - message ID");
   if (smtp_in_header(par, &ctx, msg, "Message-ID", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      xmlnode_put_attrib(x,"id",smtp_lgstrim(spool_print(tmpsp)));


   loSubj=xmlnode_get_tag(par->sin->config,"smtp/subject");

   log_debug(ZONE,"DATA - Get Advertising tag");
   si->oAD=xmlnode_get_tag(par->sin->config,"smtp/ad"); // Advertising TAG
   // projdi seznam pjemc a nati jejich zznamy z rosteru + uivatelsk nastaven
   next = si->rcpt;
   while(next != NULL)
        {
        lcJID=smtp_GetJID(par,jid_full(next->rcpt));
        log_debug(ZONE,"DATA - user %s, %s",next->rcpt,lcJID);
        next->oJID=smtp_roster_get_item(par, lcJID,0);
        next->Attachments=j_atoi(xmlnode_get_attrib(xmlnode_get_tag(par->sin->config,"smtp/attachments"), "pass"),1);
        next->nonMIME2x=j_atoi(xmlnode_get_attrib(xmlnode_get_tag(par->sin->config,"smtp/pgp"), "nonmime2x"),1);
        next->Advertising=0;
        next->UseGlobalSettings=1;

        next->SRMode=j_atoi(xmlnode_get_attrib(loSubj,"replace"),2);
        next->SRSeparator=xmlnode_get_attrib(loSubj,"separator");
        next->SRText=xmlnode_get_data(loSubj);

        if (next->oJID!=NULL)
           {
           next->UseGlobalSettings=j_atoi(xmlnode_get_attrib(next->oJID,"UseGlobalSettings"),1);
           }

        if (next->oJID!=NULL && next->UseGlobalSettings==0)
           {
           next->Attachments=j_atoi(xmlnode_get_attrib(next->oJID,"Attachments"),1);
           next->nonMIME2x=j_atoi(xmlnode_get_attrib(next->oJID,"PGPToJabbernonMIMETox"),1);
           next->SRMode=j_atoi(xmlnode_get_attrib(next->oJID,"S2J_SRMode"),2);
           next->SRSeparator=xmlnode_get_attrib(next->oJID,"S2J_SRSeparator");
           next->SRText=xmlnode_get_attrib(next->oJID,"S2J_SRText");
           }


        if (si->oAD!=NULL && j_atoi(xmlnode_get_attrib(si->oAD,"enabled"),0)==1)
           {
           lcPaid=xmlnode_get_tag_data(par->sin->config,"core/paid");

           if (lcPaid!=NULL)
              {
              if (system(spools(si->p,lcPaid," ",lcJID,si->p)) == 0)
                 next->Advertising=1;
              }
           else
              {
              if (next->oJID==NULL || (next->oJID!=NULL && j_atoi(xmlnode_get_attrib(next->oJID,"paid"),0)==0) )
                 next->Advertising=1;

              }
           }
        next = next->next;
        }
  
   
   // find first line with cc
   log_debug(ZONE,"DATA - get carbon copy");
   if (smtp_in_header(par, &ctx, msg, "cc", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      {
      si->listcc =spool_print(tmpsp);
      #ifdef SMTP_DB
       log_debug(ZONE,"DATA - sending carbon copy: %s",si->listcc);
      #else
       log_debug(ZONE,"DATA - sending carbon copy");
      #endif
      }

   // find first line with to
   log_debug(ZONE,"DATA - get listto");
   if (smtp_in_header(par, &ctx, msg, "to", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      {
      si->listto =spool_print(tmpsp);
      #ifdef SMTP_DB
       log_debug(ZONE,"DATA - sending listto: %s",si->listto);
      #else
       log_debug(ZONE,"DATA - sending listto");
      #endif
      }


   // no mime, pak to zpracuj cel a odeli
   if (ctx.mimeUsed == 0)
      {
      // bud dle JEP-0033 nebo samostatn
      log_debug(ZONE,"DATA - NONMIME mode");
      body = strstr(msg, "\n\n");
      body=smtp_mime_decode(si, &ctx, body);
      loSubject=xmlnode_insert_tag(x,"subject");
      xmlnode_insert_cdata((loBody=xmlnode_insert_tag(x,"body")),body,-1);
      smtp_in_AddAdversiting(par,si->rcpt,loBody);
      smtp_in_SubjectReplace(par,si->rcpt,subject,loSubject);

      // prove odesln
      smtp_in_deliver_message(par,x,SMTP_IN_DELIVER_ALL);
      }

   liRet=0;
   // init the mime context to not using MIME 
   if (ctx.mimeUsed == 1)
      {
      log_debug(ZONE,"DATA - MIME mode");
      // 
      // nyn projdi vechny pjemce co pouvaj globln nastaven
      // zprvu zpracuj dle prvnho s globlnm nastavenm
      for (rcpt = si->rcpt; rcpt != NULL; rcpt = rcpt->next) 
          {
          if (rcpt->UseGlobalSettings==1)
             {
             loSubject=xmlnode_insert_tag(x,"subject");

             if (liRet!=-1)
                {
                loBody=xmlnode_insert_tag(x,"body");
                liRet=smtp_in_ParseMailBody(par, &ctx,x, msg,"",rcpt);
                if (liRet==-1) // BODY FAILED
                   {
                   // you must read all mail body without any conversion
                   xmlnode_hide(loBody);
                   body = strstr(msg, "\n\n");
                   xmlnode_insert_cdata((loBody=xmlnode_insert_tag(x,"body")),smtp_mime_decode(si, &ctx, body),-1);
                   }
                }

             smtp_in_AddAdversiting(par,rcpt,loBody);
             smtp_in_SubjectReplace(par,rcpt,subject,loSubject);
             // prove odesln
             smtp_in_deliver_message(par,x,SMTP_IN_DELIVER_GLOBAL);

             if (liRet!=-1)
                xmlnode_hide(loBody);

             xmlnode_hide(loSubject);
             break;
             }
          }


      // nyn projdi vechny pjemce co NEpouvaj globln nastaven
      // a odeli zprvu
      xmlnode_hide_attrib(x,"to");
      for (rcpt = si->rcpt; rcpt != NULL; rcpt = rcpt->next) 
          {
          if (rcpt->UseGlobalSettings==1)
             continue;

          loSubject=xmlnode_insert_tag(x,"subject");

          if (liRet!=-1)
             {
             loBody=xmlnode_insert_tag(x,"body");
             liRet=smtp_in_ParseMailBody(par, &ctx,x, msg,"",rcpt);
             if (liRet==-1) // BODY FAILED
                {
                // you must read all mail body without any conversion
                xmlnode_hide(loBody);
                body = strstr(msg, "\n\n");
                xmlnode_insert_cdata((loBody=xmlnode_insert_tag(x,"body")),smtp_mime_decode(si, &ctx, body),-1);
                }
             }

          smtp_in_AddAdversiting(par,rcpt,loBody);
          smtp_in_SubjectReplace(par,rcpt,subject,loSubject);

          rcpt->rcpt->resource=NULL;
          log_debug(ZONE,"DATA - sending to %s",jid_full(rcpt->rcpt));
          xmlnode_put_attrib(x,"to",jid_full(rcpt->rcpt));
          deliver(dpacket_new(xmlnode_dup(x)),sin->i);

          if (liRet!=-1)
             xmlnode_hide(loBody);
          xmlnode_hide(loSubject);
          }
      }

   snprintf(sin->cSMTP_Status, 20, "Message sent to jabber...\0");

   log_debug(ZONE,"DATA - Increment counter");
   sin->SMTPMessagesIn++;
   smtp_StatsInc(par, "SMTPMessagesIn");

   xmlnode_free(x);
   smtp_in_status(par,SMTP_CODE_250,"Message Accepted");

   // delete email from backup repository
   if (sin->tmpBackupSMTP==1)
      if (j_strlen(lcBFile)>0)
         remove(lcBFile);

   }


/* read an incoming line from the connection */
void smtp_in_read(mio m, int state, void *arg, char *buffer,int bufsz)
   {
   char *cbuffer, *cur, *cur_, *args;
   smtpi sin;
   smtpp par;
   smtpsi si;
   int i, cmd;

   switch(state)
      {
      case MIO_NEW:
           sin = (smtpi) (arg);
           par = smtp_param(sin);
           par->si= si = smtp_new_i(m);
           si->phase = PHASE_CMD;
           si->host = mio_ip(m);
           log_debug(ZONE,"new connection from %s, %i",si->host, si);
           snprintf(sin->cSMTP_Status, 20, "Getting email...\0");
           smtp_in_status(par,SMTP_CODE_220,"Jabber SMTP Transport");
           pool_cleanup(si->p, smtp_in_cleanup, (void *)si);
           mio_reset(m, smtp_in_read, (void *)par);
           sin->SMTPMessages++;
           smtp_StatsInc(par, "SMTPMessages");
		   return;

      case MIO_BUFFER:
           par=(smtpp)(arg);
           si=par->si;
           sin=par->sin;
           break;

      default:
           return;
      }

   si->timer = time(NULL); /* so we don't timeout */

   if (bufsz <= 0) return;

   /* XXX fix special characters, need more intelligence here */
   /*
   for(cur = buffer; (cur - buffer) < bufsz; cur++)
       if(*cur == 127 || (*cur < 32 && *cur != 10 && *cur != 13))
           *cur = '*';
   */


   // S:2005-06-02 gorila@dione.zcu.cz
   // Convert \0 to space
   for(i = 0; i < bufsz; i++)
      {
      if (buffer[i] == '\0') buffer[i]=' ';
	  }
   // E:2005-06-02 gorila@dione.zcu.cz


   if (si->buffer != NULL)
      { /* old data yet, combine and use that */
      cur = malloc(strlen(si->buffer) + bufsz + 1);
      *cur = '\0';
      strcat(cur,si->buffer);
      strcat(cur,buffer);
      free(si->buffer);
      si->buffer = buffer = cur;
      bufsz = strlen(buffer);
      }

   #ifdef SMTP_DB
    log_debug(ZONE,"phase %d data [%s]",si->phase, buffer);
   #else
    log_debug(ZONE,"phase %d data",si->phase);
   #endif

   cur = cbuffer = (char *)buffer;
   for (i = 1; i < bufsz; i++)
       {
       if (cbuffer[i-1] == '\r' && cbuffer[i] == '\n')
          {
          cbuffer[i-1] = '\0';
          cbuffer[i] = '\0';
          if (si->phase == PHASE_CMD)
             {
             if (strlen(cur) > 0)
                {
                // S:2005-06-03 gorila@dione.zcu.cz
                // Better command detection

                cur_=cur;
                // find "end" of command
                args = strstr(cur, " ");
                if(args != NULL) *args = '\0';
                
                // Get ID Command
                cmd=smtp_cmd_parse(cur);
                if(args != NULL) *args = ' ';

                if (cmd==CMD_UNKNOWN)
                   {
                   sin->SMTPCommandUnknown++;
                   smtp_StatsInc(par, "SMTPCommandUnknown");
                   log_error("smtp","SMTP unknown command - %s",cur);
                   }

                cur=cur_;

                // Find argument
                args = strstr(cur, smtp_cmd_sep(cmd));
                if (args != NULL)
                   {
                   *args = '\0';
                   ++args;
                   }

                // Process command
                smtp_in_cmd(par, cmd, args);
                // E:2005-06-03 gorila@dione.zcu.cz
                }
             }
          else 
             if (si->phase == PHASE_DATA)
                {
                if (*cur == '.')
                   {
                   ++cur;
                   if (strlen(cur) == 0)
                      {
                      smtp_in_message(par);
                      si->x = NULL;
                      si->rcpt = NULL;
                      si->phase = PHASE_CMD;
                      }
                   }

                if (si->phase == PHASE_DATA && cur)
                   {
		           spooler(si->message, cur, "\r\n", si->message);
                   }
                }

          cur = cbuffer + i + 1;
          }
       }

   cbuffer = NULL;
   i = strlen(cur);
   if (i > 0) /* the read was cut off */
      {
	  if (i > 514)
	     {
	     smtp_in_status(par,SMTP_CODE_552,"XXX too much data");
//gets(getf);
	     }
      else
         {
         cbuffer = strdup(cur);
         }
      }

   free(si->buffer);
   si->buffer = cbuffer; /* save the tail from above, if any */
   }

