#include "smtp.h"
char getyyy[3]="123";


void smtp_statistics_write(xmlnode loQuery,const char *lcTagName, const char *lcUnitName, const char *lcValue)
   {
   xmlnode loStatN;
   xmlnode_put_attrib(loStatN=xmlnode_insert_tag(loQuery,"stat"),"name",lcTagName);
   xmlnode_put_attrib(loStatN,"units",lcUnitName);
   xmlnode_put_attrib(loStatN,"value",lcValue); 
   }

// S:2005-08-29 gorila@dione.zcu.cz
int smtp_out_packets_iq(smtpp par, char *type)
   {
   int liProcess=0;
   jpacket jp=par->jp;
   smtpi sin=par->sin;
   time_t now_unixtime;
   struct tm now;
   char lcPom[27];
   char *lcJID, *lcPercent,*lcAT,*lcLang,*lcDateTime,*lcName;
   struct utsname osinfo;
   spool osinfos;
   xmlnode loQuery, loIdentity, loStat, xData, loField, loOption,loJID,loInstruction;
   smtp_jq loQueue;



   lcLang=xmlnode_get_attrib(jp->x, "xml:lang");

   if (lcLang==NULL)
      lcLang=sin->DefaultLang;


   if (liProcess==0 && 
       j_strcmp(xmlnode_get_attrib(jp->x, "id"),"smtp_test_jep0033")==0 &&
       j_strcmp(jp->iqns,"http://jabber.org/protocol/disco#info")==0)
      {

      if (xmlnode_get_tag(jp->x,"query/feature?var=http://jabber.org/protocol/address"))
         sin->jep0033=1;

      return -1;
      }

   
   if (liProcess==0 && j_strcmp(jp->iqns,NS_VERSION)==0 && jp->subtype==JPACKET__GET)
      {
      loQueue=smtp_NewQueueItem(par->tmppool);
      loQueue->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      xmlnode_put_attrib(loQueue->x,"type","result");
      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loQueue->x,"query"),"xmlns",NS_VERSION);
      xmlnode_insert_cdata(xmlnode_insert_tag(loQuery,"name"),smtp_name,-1);
      xmlnode_insert_cdata(xmlnode_insert_tag(loQuery,"version"),smtp_version,-1);

 
      uname(&osinfo);
      osinfos = spool_new(par->tmppool);
      spooler(osinfos,osinfo.sysname, " ", osinfo.release, " ", osinfo.machine,osinfos);

      xmlnode_insert_cdata(xmlnode_insert_tag(loQuery,"os"), spool_print(osinfos) ,-1);

      liProcess=1;
      }



   if (liProcess==0 && j_strcmp(jp->iqns,NS_GATEWAY)==0 && jp->subtype==JPACKET__GET && jp->to->user==NULL)
      {
      loQueue=smtp_NewQueueItem(par->tmppool);
      loQueue->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      xmlnode_put_attrib(loQueue->x,"type","result");
      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loQueue->x,"query"),"xmlns",NS_GATEWAY);


      xmlnode_insert_cdata(xmlnode_insert_tag(loQuery,"desc"),smtp_rc_GetString(par,lcLang,SMTP_RC_GATEWAY_DESCR),-1);
      xmlnode_insert_cdata(xmlnode_insert_tag(loQuery,"prompt"),smtp_rc_GetString(par,lcLang,SMTP_RC_GATEWAY_PROMPT),-1);

      liProcess=1;
      }


   if (liProcess==0 && j_strcmp(jp->iqns,NS_GATEWAY)==0 && jp->subtype==JPACKET__SET && jp->to->user==NULL)
      {
      loQueue=smtp_NewQueueItem(par->tmppool);
      loQueue->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      xmlnode_put_attrib(loQueue->x,"type","result");


      // check prompt element data
      /* translate the recipient into a SMTP address */
      lcJID = smtp_alltrim(xmlnode_get_data(xmlnode_get_tag(jp->x,"query/prompt")));
      lcPercent = strstr(lcJID,"%");
      lcAT = strstr(lcJID,"@");
      
      if (lcPercent==NULL && lcAT==NULL)
         {
         smtp_ReplyError(par, jp, "iq", "Bad address", 405);
         }

      else
         {
         if (lcPercent!=NULL && lcAT!=NULL) // define % and @
            {
            if (lcPercent<lcAT) // % is before @
               *lcAT='\0';
            else
               {
               *lcPercent='\0';
               *lcAT='%';
               }
            }
         else    
            if (lcAT!=NULL)
               *lcAT='%';

         xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loQueue->x,"query"),"xmlns",NS_GATEWAY);
         xmlnode_insert_cdata(xmlnode_insert_tag(loQuery,"prompt"),strcat(strcat(lcJID,"@"),xmlnode_get_attrib(jp->x,"to")),-1);
         }

      liProcess=1;
      }


   if (liProcess==0 && j_strcmp(jp->iqns,NS_TIME)==0 && jp->subtype==JPACKET__GET)
      {
      loQueue=smtp_NewQueueItem(par->tmppool);
      loQueue->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      xmlnode_put_attrib(loQueue->x,"type","result");
      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loQueue->x,"query"),"xmlns",NS_TIME);

      /* create UTC time */
      now_unixtime = time(NULL);
      gmtime_r(&now_unixtime, &now);
      lcPom[0]='\0';
      snprintf(lcPom, sizeof(lcPom), "%02i %s %04i %02i:%02i:%02i +0000", now.tm_mday, smtp_CMonth(now.tm_mon), now.tm_year+1900, now.tm_hour, now.tm_min, now.tm_sec);
      if (lcPom[0])
         xmlnode_insert_cdata(xmlnode_insert_tag(loQuery,"display"),lcPom,27);


      lcDateTime = (char*)pmalloc_x(par->tmppool, 18,' ');
      smtp_GetDateTime((char *)lcDateTime);
      xmlnode_insert_cdata(xmlnode_insert_tag(loQuery,"utc"),lcDateTime,-1);

//       smtp_TEST(par, par->jp);
//      smtp_ToUTF8(par->tmppool, "a  a","aa");

      liProcess=1;
      }


   if (liProcess==0 && j_strcmp(jp->iqns,NS_VCARD)==0 && jp->subtype==JPACKET__GET)
      {
      loQueue=smtp_NewQueueItem(par->tmppool);
      loQueue->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      xmlnode_put_attrib(loQueue->x,"type","result");
      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loQueue->x,"vCard"),"xmlns",NS_VCARD);

      xmlnode_insert_cdata(xmlnode_insert_tag(loQuery,"JABBERID"),xmlnode_get_attrib(jp->x,"to"),-1);

      if (jp->to->user==NULL)
         {
         xmlnode_insert_cdata(xmlnode_insert_tag(loQuery,"FN"),smtp_name,-1);
         xmlnode_insert_cdata(xmlnode_insert_tag(loQuery,"URL"),"http://gorila.netlab.cz/jabber.html",-1);

         xmlnode_insert_cdata(xmlnode_insert_tag(loQuery,"TITLE"),smtp_rc_GetString(par,lcLang,SMTP_RC_VCARD_TITLE),-1);
         xmlnode_insert_cdata(xmlnode_insert_tag(loQuery,"ROLE"),smtp_rc_GetString(par,lcLang,SMTP_RC_VCARD_ROLE),-1);
         xmlnode_insert_cdata(xmlnode_insert_tag(loQuery,"BDAY"),smtp_rc_GetString(par,lcLang,SMTP_RC_VCARD_BDAY),-1);

         loField=xmlnode_insert_tag(loQuery,"DESC");
         xmlnode_insert_cdata(loField,smtp_rc_GetString(par,lcLang,SMTP_RC_VCARD_HISTORY),-1);
         xmlnode_insert_cdata(loField,"\r\nMatthias Wimmer <m@tthias.net>\r\nhttp://devel.amessage.info/smtp-t/\r\n\r\n",-1);
         }

      liProcess=1;
      }

   if (liProcess==0 && j_strcmp(jp->iqns,"http://jabber.org/protocol/disco#info")==0 && jp->subtype==JPACKET__RESULT)
      {

      }


   if (liProcess==0 && j_strcmp(jp->iqns,"http://jabber.org/protocol/disco#info")==0 && jp->subtype==JPACKET__GET)
      {
      loQueue=smtp_NewQueueItem(par->tmppool);
      loQueue->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      xmlnode_put_attrib(loQueue->x,"type","result");

      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loQueue->x,"query"),"xmlns","http://jabber.org/protocol/disco#info");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"feature"),"var","http://jabber.org/protocol/disco");

      if (jp->to->user==NULL)
         {

         xmlnode_put_attrib(loIdentity=xmlnode_insert_tag(loQuery,"identity"),"category","gateway");
         xmlnode_put_attrib(loIdentity,"name",smtp_name);
         xmlnode_put_attrib(loIdentity,"type","x-smtp");

         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"feature"),"var","http://jabber.org/protocol/stats");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"feature"),"var","http://jabber.org/protocol/address");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"feature"),"var","jabber:iq:gateway");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"feature"),"var","jabber:iq:register");
         }
      else
         xmlnode_put_attrib(loIdentity=xmlnode_insert_tag(loQuery,"identity"),"category","client");


      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"feature"),"var","jabber:iq:version");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"feature"),"var","jabber:iq:time");
      xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"feature"),"var","vcard-temp");


      liProcess=1;
      }


   if (liProcess==0 && j_strcmp(jp->iqns,"http://jabber.org/protocol/stats")==00 &&
       jp->subtype==JPACKET__GET && jp->to->user==NULL)
      {
      loQueue=smtp_NewQueueItem(par->tmppool);
      loQueue->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      xmlnode_put_attrib(loQueue->x,"type","result");

      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loQueue->x,"query"),"xmlns","http://jabber.org/protocol/stats");

      if ((loStat=xmlnode_get_firstchild(jp->iq)))
         {


         // read all childs elements
         for (;loStat != NULL; loStat = xmlnode_get_nextsibling(loStat))
             {
	         if (loStat->type!=NTYPE_TAG)
		        continue;

             // main section
             lcName=xmlnode_get_attrib(loStat,"name");
             if (j_strcmp(lcName,"start")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(sin->statistics,"Start"));
				continue;
                }

             if (j_strcmp(lcName,"start/lastdatetime")==0)
                {
                smtp_statistics_write(loQuery,lcName, "date",xmlnode_get_attrib(sin->statistics,"StartLastDatetime"));
				continue;
                }


             if (j_strcmp(lcName,"contacts")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(sin->statistics,"CoreContacts"));
				continue;
                }

            if (j_strcmp(lcName,"contacts/online")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(sin->statistics,"CoreContactsOnline"));
				continue;
                }

             if (j_strcmp(lcName,"contacts/elapsed")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",sin->CoreContacts);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }

             if (j_strcmp(lcName,"contacts/elapsed/online")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",sin->CoreContactsOnline);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }

             if (j_strcmp(lcName,"accounts")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(sin->statistics,"CoreAccounts"));
				continue;
                }

            if (j_strcmp(lcName,"accounts/elapsed")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",sin->CoreAccounts);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }


             // jabber side
             if (j_strcmp(lcName,"jabber/status")==0)
                {
                smtp_statistics_write(loQuery,lcName, "text",sin->cJabber_Status);
				continue;
                }

             if (j_strcmp(lcName,"jabber/messages")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(sin->statistics,"JabberMessages"));
				continue;
                }

			 if (j_strcmp(lcName,"jabber/messages/out")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(sin->statistics,"JabberMessagesOut"));
                continue;
                }

             if (j_strcmp(lcName,"jabber/messages/out/error")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(sin->statistics,"JabberMessagesOutError"));
				continue;
                }

             if (j_strcmp(lcName,"jabber/elapsed/messages")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",sin->JabberMessages);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }

             if (j_strcmp(lcName,"jabber/elapsed/messages/out")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",sin->JabberMessagesOut);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }


             if (j_strcmp(lcName,"jabber/elapsed/messages/out/error")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",sin->JabberMessagesOutError);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }

             // SMTP side
             if (j_strcmp(lcName,"smtp/status")==0)
                {
                smtp_statistics_write(loQuery,lcName, "text",sin->cSMTP_Status);
				continue;
                }

		     if (j_strcmp(lcName,"smtp/command/unknown")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(sin->statistics,"SMTPCommandUnknown"));
				continue;
                }

             if (j_strcmp(lcName,"smtp/elapsed/command/unknown")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",sin->SMTPCommandUnknown);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }

             if (j_strcmp(lcName,"smtp/messages")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(sin->statistics,"SMTPMessages"));
				continue;
				}


             if (j_strcmp(lcName,"smtp/messages/in")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(sin->statistics,"SMTPMessagesIn"));
				continue;
                }

		     if (j_strcmp(lcName,"smtp/messages/in/error")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(sin->statistics,"SMTPMessagesInError"));
				continue;
                }
             if (j_strcmp(lcName,"smtp/elapsed/messages")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",sin->SMTPMessages);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }

             if (j_strcmp(lcName,"smtp/elapsed/messages/in")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",sin->SMTPMessagesIn);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }

            if (j_strcmp(lcName,"smtp/elapsed/messages/in/error")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",sin->SMTPMessagesInError);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }

		     if (j_strcmp(lcName,"smtp/spam")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(sin->statistics,"SMTPSpam"));
				continue;
                }

             if (j_strcmp(lcName,"smtp/elapsed/spam")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",sin->SMTPSpam);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }



             }

         }
      else
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","start");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","start/lastdatetime");

         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","contacts");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","contacts/online");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","contacts/elapsed");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","contacts/elapsed/online");

         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","accounts");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","accounts/elapsed");

         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/status");

         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/messages");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/messages/out");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/messages/out/error");

         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/elapsed/messages");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/elapsed/messages/out");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/elapsed/messages/out/error");

		 xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/status");
		 xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/command/unknown");
		 xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/command/unknown");

         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/messages");
		 xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/messages/in");
		 xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/messages/in/error");

         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/messages");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/messages/in");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/messages/in/error");
		 
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/spam");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/spam");
		 }

      liProcess=1;
      }

   // register service
   if (liProcess==0 && j_strcmp(jp->iqns,NS_REGISTER)==0 && jp->subtype==JPACKET__GET)
      {
      /*
      Nati nastaven uivatele dle JID
      pokud neexistuje, pouij nastaven z konfigu transportu
      */
      lcJID=smtp_GetJID(par,xmlnode_get_attrib(jp->x,"from"));
      loJID=smtp_roster_get_item(par, lcJID,1);

      loQueue=smtp_NewQueueItem(par->tmppool);
      loQueue->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      xmlnode_put_attrib(loQueue->x,"type","result");

      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loQueue->x,"query"),"xmlns",NS_REGISTER);

      if (j_atoi(xmlnode_get_attrib(loJID,"default"),0)==0) // user was registered
         {
         xmlnode_insert_tag(loQuery,"registered");
         }


	  xmlnode_insert_cdata(loInstruction=xmlnode_insert_tag(loQuery,"instruction"),smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_MAIN_I),-1);
      if (j_atoi(xmlnode_get_attrib(loJID,"paid"),0)==1)
         {
	     xmlnode_insert_cdata(loInstruction,"\r\n",-1);
	     xmlnode_insert_cdata(loInstruction,smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_PAID_LBL),-1);
         }


      xmlnode_put_attrib(xData=xmlnode_insert_tag(loQuery,"x"),"xmlns",NS_DATA);
	  xmlnode_insert_cdata(xmlnode_insert_tag(xData,"title"),smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_TITLE),-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(xData,"instructions"),smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_DATA_I),-1);



      if (j_atoi(xmlnode_get_attrib(loJID,"default"),0)==0)
         {
         xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","hidden");
         xmlnode_put_attrib(loField,"var","FORM_TYPE");
         xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),NS_REGISTER,-1);
         }



//      Nati nastaven dle JID

	  // global settings
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","boolean");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_USEGLOBALSETTINGS_LBL));
	  xmlnode_put_attrib(loField,"var","UseGlobalSettings");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"UseGlobalSettings"),-1);
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_USEGLOBALSETTINGS_DSC),-1);


      // jabber to smtp
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value")," ",-1);
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_J2SHEAD),-1);

	  // own  setting - jabber to mime
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","boolean");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_PGPJABBERTOMIME_LBL));
	  xmlnode_put_attrib(loField,"var","PGPJabberToMIME");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"PGPJabberToMIME"),-1);
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_PGPJABBERTOMIME_DSC),-1);


	  // own  setting - subject replace
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value")," ",-1);

	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_SR_HEAD),-1);

      // mode
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","list-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_SR_MODE_LBL));
	  xmlnode_put_attrib(loField,"var","J2S_SRMode");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_SRMode"),-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL0_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"0",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL1_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"1",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL2_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"2",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL3_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"3",-1);

      // separator
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_SR_SEPARATOR_LBL));
	  xmlnode_put_attrib(loField,"var","J2S_SRSeparator");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_SRSeparator"),-1);

      // text
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_SR_TEXT_LBL));
	  xmlnode_put_attrib(loField,"var","J2S_SRText");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_SRText"),-1);

	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_SR_DSC),-1);




      // smtp to jabber
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value")," ",-1);
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_S2JHEAD),-1);

      // own  setting - attachments
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","list-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_ATTACHMENTS_LBL));
	  xmlnode_put_attrib(loField,"var","Attachments");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"Attachments"),-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_ATTACHMENTS_VAL1_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"1",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_ATTACHMENTS_VAL0_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"0",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_ATTACHMENTS_VAL2_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"2",-1);
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_ATTACHMENTS_DSC),-1);

	  // own  setting - to jabber non mime to x
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","boolean");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_PGPTOJABBERNONMIMETOX_LBL));
	  xmlnode_put_attrib(loField,"var","PGPToJabbernonMIMETox");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"PGPToJabbernonMIMETox"),-1);
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_PGPTOJABBERNONMIMETOX_DSC),-1);



	  // own  setting - subject replace
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value")," ",-1);

	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_SR_HEAD),-1);

      // mode
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","list-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_SR_MODE_LBL));
	  xmlnode_put_attrib(loField,"var","S2J_SRMode");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"S2J_SRMode"),-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL0_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"0",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL1_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"1",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL2_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"2",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL3_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"3",-1);

      // separator
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_SR_SEPARATOR_LBL));
	  xmlnode_put_attrib(loField,"var","S2J_SRSeparator");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"S2J_SRSeparator"),-1);

      // text
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_SR_TEXT_LBL));
	  xmlnode_put_attrib(loField,"var","S2J_SRText");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"S2J_SRText"),-1);

	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par,lcLang,SMTP_RC_REGISTER_SR_DSC),-1);


      liProcess=1;
      }

   // unregister service
   if (liProcess==0 && j_strcmp(jp->iqns,NS_REGISTER)==0 && jp->subtype==JPACKET__SET &&
       xmlnode_get_tag(jp->x,"query/remove")!=NULL)
      {
      // test if submit or cancel
      par->sin->CoreAccounts--;
      smtp_StatsDec(par, "CoreAccounts");
      lcJID=smtp_GetJID(par,xmlnode_get_attrib(jp->x,"from"));
      smtp_roster_remove_item(par, lcJID);
      liProcess=-1;
      }

   
   // register service - proccess data (submit)
   if (liProcess==0 && j_strcmp(jp->iqns,NS_REGISTER)==0 && jp->subtype==JPACKET__SET &&
       (xData=xmlnode_get_tag(jp->x,"query/x?type=submit"))!=NULL)
      {
      // test if submit or cancel

   log_debug(ZONE,"xxxxx I want process register form");

      lcJID=smtp_GetJID(par,xmlnode_get_attrib(jp->x,"from"));
   log_debug(ZONE,"xxxxx Get JID %s",lcJID);
      loJID=smtp_roster_get_item(par, lcJID,0);
      if (loJID==NULL)
         {
         loJID=smtp_roster_get_defaultitem(par, lcJID);
   log_debug(ZONE,"xxxxx Get default JID %s",lcJID);
         }

      for (loField = xmlnode_get_firstchild(xData); loField != NULL; loField = xmlnode_get_nextsibling(loField))
          {
          if (loField->type!=NTYPE_TAG)
      	    continue;

   
          lcName=xmlnode_get_attrib(loField,"var");
   
log_debug(ZONE,"xxxxx Attrib: %s, Value: %s",lcName,xmlnode_get_tag_data(loField,"value"));
   
          if (j_strcmp(lcName,"UseGlobalSettings")==0 ||
              j_strcmp(lcName,"Attachments")==0 ||
              j_strcmp(lcName,"PGPJabberToMIME")==0 ||
              j_strcmp(lcName,"PGPToJabbernonMIMETox")==0 ||
              j_strcmp(lcName,"J2S_SRMode")==0 ||
              j_strcmp(lcName,"J2S_SRSeparator")==0 ||
              j_strcmp(lcName,"J2S_SRText")==0 ||
              j_strcmp(lcName,"S2J_SRMode")==0 ||
              j_strcmp(lcName,"S2J_SRSeparator")==0 ||
              j_strcmp(lcName,"S2J_SRText")==0
             )
             xmlnode_put_attrib(loJID,lcName,xmlnode_get_tag_data(loField,"value"));
	         }

log_debug(ZONE,"xxxxx create queue");

      loQueue=smtp_NewQueueItem(par->tmppool);

      if (j_atoi(xmlnode_get_attrib(loJID,"default"),0)==1) // user was not registered
         {
log_debug(ZONE,"xxxxx incremnt counter - 0");
         par->sin->CoreAccounts++;
log_debug(ZONE,"xxxxx incremnt counter");
         smtp_StatsInc(par, "CoreAccounts");

log_debug(ZONE,"xxxxx add item to queue");
         smtp_AppendQueueItem(loQueue, smtp_NewQueueItem(par->tmppool));
log_debug(ZONE,"xxxxx node on  queue item");
         loQueue->next->x=out_SetReply(xmlnode_new_tag("presence"),jp->x);
log_debug(ZONE,"xxxxx set node attrib on  queue item");
         xmlnode_put_attrib(loQueue->next->x,"type","subscribe");
         }

log_debug(ZONE,"xxxxx save roster");
      smtp_roster_set_item(par, lcJID,loJID);

      loQueue->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      xmlnode_put_attrib(loQueue->x,"type","result");
      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loQueue->x,"query"),"xmlns",NS_REGISTER);

	  liProcess=1;
      }

   // register service - proccess data (cancel)
   if (liProcess==0 && j_strcmp(jp->iqns,NS_REGISTER)==0 && jp->subtype==JPACKET__SET &&
       (xData=xmlnode_get_tag(jp->x,"query/x?type=cancel"))!=NULL)
      {
      loQueue=smtp_NewQueueItem(par->tmppool);
      loQueue->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      xmlnode_put_attrib(loQueue->x,"type","result");
      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loQueue->x,"query"),"xmlns",NS_REGISTER);
	  liProcess=1;
      }


   if (liProcess==1)
      smtp_FlushQueue(par->sin->i, loQueue);


   return liProcess;
   }

// E:2005-08-29 gorila@dione.zcu.cz
