#include "smtp.h"

/* jabber->smtp */

char getx[3]="ddd";


void  smtp_logx(smtps so, char * msg, ...)
   {

   va_list ap;
   char logmsg[512] = "";

   va_start(ap, msg);
   vsnprintf(logmsg, 512, msg, ap);

   if (so->oLOG!=NULL)
      {
      xmlnode_insert_cdata(so->oLOG, logmsg,-1);
      xmlnode_insert_cdata(so->oLOG, "\r\n",-1);
      xmlnode2file(so->oLOGFile ,so->oLOG);
      }

   log_debug(ZONE,logmsg);
   return;
   }


/* send an outgoing line to the connection */
void smtp_cmd(smtpp par, int liCmd, char *arg)
   {
   char *lcOut;
   pool p;
   spool lspLine;

   p = pool_new();
   lspLine = spool_new(p);

   switch(liCmd)
      {
      case CMD_HELO:
           spool_add(lspLine,"HELO ");
           break;

      case CMD_EHLO:
           spool_add(lspLine,"EHLO ");
           break;

      case CMD_MAIL:
           spool_add(lspLine,"MAIL FROM: ");
           break;

      case CMD_RCPT:
           spool_add(lspLine,"RCPT TO: ");
           break;

      case CMD_DATA:
           spool_add(lspLine,"DATA");
           break;

      case CMD_QUIT:
           spool_add(lspLine,"QUIT");
           break;
      }

   if (arg != NULL)
      {
      if (liCmd == CMD_HELO || liCmd == CMD_EHLO)
         spool_add(lspLine,arg);
      else
         spooler(lspLine,"<",arg,">",lspLine);
      }

   spool_add(lspLine,"\r\n");
   lcOut = spool_print(lspLine);
   par->so->lastcmd = liCmd;
   #ifdef SMTP_DB
    log_debug(ZONE,"SMTP-SEND %s",lcOut);
   #else
    log_debug(ZONE,"SMTP-SEND");
   #endif

   mio_write(par->so->m,NULL,lcOut,-1);

   pool_free(p);
   }

/* decode the incoming commands */
void smtp_out_status(smtpp par,char *lcData)
   {
   char *lineEnd, *lcBody;
   smtps so=par->so;
   smtpi sin=par->sin;
   xmlnode x,loStatus;
   jid cur;
   int liStatus=so->iStatus;

   #ifdef SMTP_DB
    log_debug(ZONE,"status %d response to command %d with data %s",liStatus,so->lastcmd,lcData);
   #else
    log_debug(ZONE,"status %d response to command %d",liStatus,so->lastcmd);
   #endif

   switch(so->lastcmd)
      {

      case CMD_NONE:
           if (liStatus != SMTP_CODE_220)
              break;
 
           smtp_cmd(par, CMD_HELO, sin->me);
           return;

      case CMD_HELO:
           if (liStatus != SMTP_CODE_250)
              break;

           smtp_cmd(par, CMD_MAIL, so->from);
           return;

      case CMD_EHLO:
           if (liStatus != SMTP_CODE_250)
              break;

           smtp_cmd(par, CMD_MAIL, so->from);
           return;


      case CMD_MAIL:
           if (liStatus != SMTP_CODE_250)
              break;

		   snprintf(par->sin->cJabber_Status, 20, "Check recipients\0");

           for (cur = so->rcpt; cur != NULL; cur = cur->next)
               smtp_cmd(par, CMD_RCPT, jid_full(cur));

           return;

      case CMD_RCPT:
           so->ircpt--;

           if (!(liStatus == SMTP_CODE_250 || liStatus == SMTP_CODE_251))
              break;

           if (so->ircpt==0)
              smtp_cmd(par, CMD_DATA, NULL);

           return;

      case CMD_RCPTE:
           if (!(liStatus == SMTP_CODE_250 || liStatus == SMTP_CODE_251))
              break;

           smtp_cmd(par, CMD_DATA, NULL);
           return;

      case CMD_DATA:
		   snprintf(par->sin->cJabber_Status, 20, "Send data\0");
           lcBody = xmlnode_get_data(so->x);

           if (liStatus != SMTP_CODE_354 || lcBody == NULL)
              break;


           snprintf(sin->cJabber_Status, 20, "Sending data...\0");
           for (x = xmlnode_get_firstattrib(so->x); x != NULL; x = xmlnode_get_nextsibling(x))
               {
               mio_write(so->m,NULL,xmlnode_get_name(x),-1);
               mio_write(so->m,NULL,": ",2);
               mio_write(so->m,NULL,xmlnode_get_data(x),-1);
               mio_write(so->m,NULL,"\r\n",2);
               }
           mio_write(so->m,NULL,"\r\n",2);


           while((lineEnd = strchr(lcBody,'\n')) != NULL)
      	      {
       		  lineEnd[0] = '\0';	/* cut the line */

             // S:2005-04-03 gorila@dione.zcu.cz
//		     while((crpointer = strchr(body, '\r')) != NULL)
//             crpointer[0] = ' ';
             // E:2005-04-03 gorila@dione.zcu.cz

 		      if (lcBody[0]=='.')
		         mio_write(so->m,NULL,".",1); /* escape the dot */

              // S:2005-04-03 gorila@dione.zcu.cz
              // xmlnode2str() return original XML data (without any changes)
              // xmlnode_get_tag_data() return data where CRLF and CR are replaced by LF
              // _mio_write_dump() hate data with length = 0
              // I added this exception
	  	      if (j_strlen(lcBody)>0)
                 mio_write(so->m,NULL,lcBody,-1);
              // E:2005-04-03 gorila@dione.zcu.cz

		      mio_write(so->m,NULL,"\r\n",2);
		      lcBody = lineEnd+1;	/* point to next line */
	          }


	       if (lcBody[0])
		      mio_write(so->m,NULL,lcBody,-1); /* print the rest */


           so->lastcmd = CMD_DATAEND; /* so we know where we are */

           mio_write(so->m,NULL,"\r\n.\r\n",5);
           return;

      case CMD_DATAEND:
           if (!(liStatus == SMTP_CODE_250 || liStatus == SMTP_CODE_221))
              break;

           sin->JabberMessagesOut++;
           smtp_StatsInc(par, "JabberMessagesOut");

           smtp_cmd(par, CMD_QUIT, NULL);

		   return;

      case CMD_QUIT:
           if (!(liStatus == SMTP_CODE_250 || liStatus == SMTP_CODE_221))
              break;

           snprintf(sin->cJabber_Status, 20, " ");
		   // Odeslan prezence o odesln mailu
           x= out_SetReply(xmlnode_new_tag("presence"),par->jp->x);
           xmlnode_insert_cdata(xmlnode_insert_tag(x,"show"),"online",-1);
           xmlnode_insert_cdata(loStatus=xmlnode_insert_tag(x,"status"),"Message sent...\r\n",-1);
           xmlnode_insert_cdata(loStatus,xmlnode_get_data(xmlnode_get_tag(par->jp->x,"body")),-1);
           deliver(dpacket_new(xmlnode_dup(x)),par->sin->i);
           xmlnode_free(x);

           return;

      default:
           #ifdef SMTP_DB
            log_debug(ZONE,"SMTP relay connection not processed %d %d: %s",so->lastcmd,liStatus,lcData);
           #else
            log_debug(ZONE,"SMTP relay connection not processed %d %d:",so->lastcmd,liStatus);
           #endif
      }


   #ifdef SMTP_DB
    log_debug(ZONE,"SMTP relay connection failed %d %d: %s",so->lastcmd,liStatus,lcData);
    log_error("smtp","SMTP relay connection failed %d %d: %s",so->lastcmd,liStatus,lcData);
   #else
    log_debug(ZONE,"SMTP relay connection failed %d %d",so->lastcmd,liStatus);
    log_error("smtp","SMTP relay connection failed %d %d",so->lastcmd,liStatus);
   #endif

   sin->JabberMessagesOutError++;
   smtp_StatsInc(par, "JabberMessagesOutError");
   smtp_ReplyError(par, par->jp, "message", lcData, so->iStatus);
   snprintf(par->sin->cJabber_Status, 20, "SMTP rel. con. fail\0");
   // if this error, end session with SMTP server
   if (so->lastcmd != CMD_QUIT)
      smtp_cmd(par, CMD_QUIT, NULL);


   }

/* when the connection dies, clean up the mess */
void smtp_out_cleanup(void *arg)
   {
   smtpp par = (smtpp)(arg);

   log_debug(ZONE,"smtp_out_cleanup");
   if (par->so != NULL)
      {
      par->so->oJID=par->so->oAD=NULL;

      free(par->so->buffer);
      }
   pool_free(par->tmppool);
   }


smtps smtp_out_new(mio m, smtpp par)
   {
   smtps so;
   smtpi sin=par->sin;
   jid ljidFrom;
   char *to, *host, *subject=NULL, *id, *tocc, *lcCB=NULL, *tmp, *lcBFile=NULL, *lcJID=NULL, *lcPaid=NULL;
   time_t now_unixtime;
   struct tm now;
   char dateheader[27], smtpboundary[30], smtpCT[140];
   xmlnode html,meta,thread,tagx,tagxchild, loHTML=NULL, loBody=NULL, loEncrypted=NULL,loPGP=NULL,loCB=NULL,loSubj=NULL, loSigned=NULL;
   spool datato,datacc,databcc,xmailer;
   jpacket jp=par->jp;
   int liLen,liPGP=0,liMode,lii;

   snprintf(par->sin->cJabber_Status, 20, "Generate e-mail\0");

/*
   log_debug(ZONE,"xxxxxxxxxxxxxxx      -        xxxxxxxxxxxxxxxxxxxxxxxxxxx\r\nspool new\r\n");
   gets((char *)getx);

*/



   par->so = so = smtp_new(m);
   so->oLOG = NULL;
//   so->oLOG = xmlnode_new_tag_pool(so->p,"x");

   // save email to backup repository
   if (sin->tmpBackupJabber==1)
      {

      lcBFile = (char*)pmalloco(so->p, 254);
      lcBFile=tempnam(xmlnode_get_attrib(xmlnode_get_tag(sin->config,"jabber/backup"),"folder"), "tmp");

      so->oLOGFile=spools(so->p,lcBFile,"-log.xml",so->p);

      lcBFile=spools(so->p, lcBFile,".xml",so->p);
      if (xmlnode2file(lcBFile  ,jp->x)!=1)
         log_error("smtp","Cannot save message to %s",lcBFile);



	  }

/* 
   // load from  backup folder
   jp->x=xmlnode_file("./spool/smtp/jabber-b/old/tmpH1Habf.xml");
   log_debug(ZONE,xmlnode2str(jp->x));
*/

   /* translate the jabber address to a sutiable SMTP sender */
   ljidFrom = smtp_2mx(sin, jp->from);

   /* translate the recipient into a SMTP address */
   to = pstrdup(jp->p,jp->to->user);
   host = strstr(to,"%");
   *host = '@';
   ++host;

   log_debug(ZONE,"yay, sending a message from %s to %s",jid_full(ljidFrom),to);
   so->phase = PHASE_SEND;
   so->host = mio_ip(m);

   so->ircpt = 0;
   so->from = pstrdup(so->p,jid_full(ljidFrom));


   /* create xml for outgoing message */
   so->x = xmlnode_new_tag_pool(so->p,"mail");

   datato = spool_new(so->p);
   datacc = spool_new(so->p);
   databcc = spool_new(so->p);


/*
   log_debug(ZONE,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\r\nspool new\r\n");
   gets((char *) &smtpCT);
*/
   xmlnode_put_attrib(so->x,"From",so->from);



   // to,cc, bcc elements
   if ((tagx=xmlnode_get_tag(jp->x,"addresses?xmlns=http://jabber.org/protocol/address"))) 
      {
      log_debug(ZONE,"JEP-0033\r\n");

       // read all childs elements from x element
      for (tagxchild = xmlnode_get_firstchild(tagx); tagxchild != NULL; tagxchild = xmlnode_get_nextsibling(tagxchild))
          {
	      if (tagxchild->type!=NTYPE_TAG)
		     continue;

          tocc=smtp_GetSMTPAddress(xmlnode_get_attrib(tagxchild,"jid"));
          so->rcpt = jid_append(so->rcpt,jid_new(so->p,tocc));
          so->ircpt++;

          // is it to element?
          if (j_strcmp(xmlnode_get_attrib(tagxchild,"type"),"to")==0)
             spooler(datato,tocc," ",datato);

          // is it cc element?
          if (j_strcmp(xmlnode_get_attrib(tagxchild,"type"),"cc")==0)
             spooler(datacc,tocc,"\r\n ",datacc);

          // is it bcc element?
          if (j_strcmp(xmlnode_get_attrib(tagxchild,"type"),"bcc")==0)
             spooler(databcc,tocc,"\r\n ",databcc);

          }
      }
   else
      {
      spooler(datato,to,"\r\n ",datato); // simple recipient
      so->rcpt = jid_new(so->p,to);
      so->ircpt++;
      }



   if (datato->len>0)
      xmlnode_put_attrib(so->x,"to",spool_print(datato));

   if (datacc->len>0)
      xmlnode_put_attrib(so->x,"cc",spool_print(datacc));

   if (databcc->len>0)
      xmlnode_put_attrib(so->x,"bcc",spool_print(databcc));


   // napl informace o uivateli
   log_debug(ZONE,"SMP: GET JID");
   lcJID = smtp_GetJID(par,xmlnode_get_attrib(jp->x,"from"));


   log_debug(ZONE,"SMP: GET SUBJ");
   loSubj=xmlnode_get_tag(par->sin->config,"jabber/subject");
   log_debug(ZONE,"SMP: GET PGP");
   loPGP=xmlnode_get_tag(par->sin->config,"jabber/pgp");

   log_debug(ZONE,"SMP: GET JID ITEM");
   so->oJID=smtp_roster_get_item(par, lcJID,1);
   log_debug(ZONE,"SMP: GET AD ITEM");
   so->oAD=xmlnode_get_tag(par->sin->config,"jabber/ad");


   if (so->oAD!=NULL && j_atoi(xmlnode_get_attrib(so->oAD,"enabled"),0)==1)
      {
      lcPaid=xmlnode_get_tag_data(par->sin->config,"core/paid");


   log_debug(ZONE,"SMP: GET PAID MODULE %s",lcPaid);

      log_debug(ZONE,"SMP: CALL PAID MODULE for JID %s",lcJID);

      if (lcPaid!=NULL)
         {
         lii=system(spools(so->p,lcPaid," ",lcJID,so->p));

      log_debug(ZONE,"SMP: PAID FLAG %i",lii);
         }


      if (lcPaid!=NULL)
         {
         if (system(spools(so->p,lcPaid," ",lcJID,so->p)) == 0)
            so->Advertising=1;
         }
      else
         {
         if (so->oJID==NULL || (so->oJID!=NULL && j_atoi(xmlnode_get_attrib(so->oJID,"paid"),0)==0) )
            so->Advertising=1;

         }
      }


   log_debug(ZONE,"SMP: GET PGP MIME");
   if (loPGP!=NULL)
      so->toPGPMIME=j_atoi(xmlnode_get_attrib(loPGP,"mime"),1);

   log_debug(ZONE,"SMP: GET PGP MIME x GLOBAL");
   if (so->oJID!=NULL && j_atoi(xmlnode_get_attrib(so->oJID,"UseGlobalSettings"),1)==0)
      so->toPGPMIME=j_atoi(xmlnode_get_attrib(so->oJID,"PGPJabberToMIME"),1);



   if (loSubj!=NULL)
      {
   log_debug(ZONE,"SMP: GET SUBJECT SETTINGS");

      so->SRMode=j_atoi(xmlnode_get_attrib(loSubj,"replace"),2);
      so->SRSeparator=pstrdup(so->p,xmlnode_get_attrib(loSubj,"separator"));
      so->SRText=pstrdup(so->p,xmlnode_get_data(loSubj));
      }


   if (so->oJID!=NULL && j_atoi(xmlnode_get_attrib(so->oJID,"UseGlobalSettings"),1)==0)
      {
   log_debug(ZONE,"SMP: GET SUBJECT GLOBAL  SETTINGS");

      so->SRMode=j_atoi(xmlnode_get_attrib(so->oJID,"J2S_SRMode"),2);
      so->SRSeparator=pstrdup(so->p,xmlnode_get_attrib(so->oJID,"J2S_SRSeparator"));
      so->SRText=pstrdup(so->p,xmlnode_get_attrib(so->oJID,"J2S_SRText"));
      }




   // subject
   log_debug(ZONE,"SMP: GET JABBER SUBJECT");
   subject = pstrdup(so->p,smtp_alltrim(xmlnode_get_tag_data(jp->x,"subject")));
   if (loSubj && so->SRMode!=0)
      {
      if (j_strlen(subject)==0 && so->SRMode==3) // if empty and replace is 3
         {
   log_debug(ZONE,"SMP: GET SUBJECT REPLACE 3");
         subject=pstrdup(so->p,so->SRText);
         }

      if (j_strlen(subject)>0 && so->SRMode==1) // if not empty and replace is 1
         {
   log_debug(ZONE,"SMP: GET SUBJECT REPLACE 1");
         subject=spools(so->p,so->SRText," ",so->SRSeparator," ",subject,so->p);
         }

      if (j_strlen(subject)>0 && so->SRMode==2) // if not empty and replace is 2
         {
   log_debug(ZONE,"SMP: GET SUBJECT REPLACE 2");
         subject=spools(so->p,subject," ",so->SRSeparator," ",so->SRText,so->p);
         }

      }

   if (j_strlen(subject)==0)
      subject=pstrdup(so->p,SMTP_SUBJECTMUSTBEFILL);

   if ((liLen=j_strlen(subject))>0)
      {
   log_debug(ZONE,"SMP: SUBJECT RECODING TO QOP");
   log_debug(ZONE,"SMP: ALLOC MEMORY");

      tmp = (char*)pmalloc_x(so->p, liLen*3+(liLen*3/20)+1,' ');
   log_debug(ZONE,"SMP: CODE TEXT");
      lii=toQP(subject, (void *) tmp,0,"()<>@,;:\"/[]?.");

   log_debug(ZONE,"SMP: SAVE TO ATTRIB, toQPErr: %i",lii);
      xmlnode_put_attrib(so->x,"Subject",spools(so->p,"=?utf-8?q?",tmp,"?=",so->p));
      }
   

   log_debug(ZONE,"SMP: SET MAILER");
   xmailer = spool_new(so->p);
   spooler(xmailer,smtp_name," ",smtp_version," ","[http://gorila.netlab.cz/jabber.html]",xmailer);
   xmlnode_put_attrib(so->x,"X-Mailer",spool_print(xmailer));


   log_debug(ZONE,"SMP: PUT MIME");
   xmlnode_put_attrib(so->x,"MIME-Version","1.0");

   jid_set(jp->from,NULL,JID_RESOURCE);
   xmlnode_put_attrib(so->x,"Jabber-ID",jid_full(jp->from));


   tagx = xmlnode_get_tag(sin->config,"core/map");

   log_debug(ZONE,"SMP: SET ID");
   id=xmlnode_get_attrib(jp->x,"id");
   if (j_strlen(id)==0)
      {
      id = (char*)pmalloc_x(par->tmppool, 18,' ');
      smtp_GetDateTime((char *)id);
      }

   xmlnode_put_attrib(so->x,"Message-ID",spools(so->p,"<",xmlnode_get_attrib(tagx, "jabber"),"@",id,">",so->p));



   if (jp->subtype==JPACKET__CHAT)
      {
   log_debug(ZONE,"SMP: SET THREAD ID");
      if ((thread=xmlnode_get_tag(jp->x,"thread"))!= NULL)
         xmlnode_put_attrib(so->x,"X-Jabber-Thread-id",xmlnode_get_data(thread));
      else    
         xmlnode_put_attrib(so->x,"X-Jabber-Thread-id","jabber-start-thread");
      }



   // create time header for message 
   log_debug(ZONE,"SMP: SET DATE");
   now_unixtime = time(NULL);
   gmtime_r(&now_unixtime, &now);
   dateheader[0]='\0';
   snprintf(dateheader, sizeof(dateheader), "%02i %s %04i %02i:%02i:%02i +0000", now.tm_mday, smtp_CMonth(now.tm_mon), now.tm_year+1900, now.tm_hour, now.tm_min, now.tm_sec);
   if (dateheader[0])
 	   xmlnode_put_attrib(so->x,"Date",dateheader);


   log_debug(ZONE,"SMP: GET JABBER PARTs");
   loHTML=xmlnode_get_tag(jp->x,"html");
   loBody=xmlnode_get_tag(jp->x,"body");
   loEncrypted=xmlnode_get_tag(jp->x,"x?xmlns=jabber:x:encrypted"); // is used PGP?
   loSigned=xmlnode_get_tag(jp->x,"x?xmlns=jabber:x:signed"); // is used PGP?


  
   if (loEncrypted || loSigned)
      {
   log_debug(ZONE,"SMP: PGP/SIGNED !!!");
      liPGP=1;
      if (so->Advertising==1)
         liMode=SMTP_PGP_ATTACH;
      else
         liMode=(so->toPGPMIME==1)?SMTP_PGP_MIME:SMTP_PGP_NOMIME;
      }


   // PGP, encrypted or encrypted+signed
   if (loEncrypted!= NULL)
      {
   log_debug(ZONE,"SMP: PGP !!!");
      loCB=xmlnode_get_tag(sin->config,"core/pgp/cbm/cb"); // comment block
      if (loCB)
         lcCB=xmlnode_get_data(loCB);

      switch(liMode)
         {
         case SMTP_PGP_ATTACH:
   log_debug(ZONE,"SMTP: PGP ATTACH!!!");
              smtpboundary[0]='\0';
              snprintf(smtpboundary, sizeof(smtpboundary), "JPB_%04i%02i%02i%02i%02i%02i%i", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
              snprintf(smtpCT, sizeof(smtpCT), "multipart/mixed;\r\n boundary=\"%s\"", smtpboundary);

              xmlnode_put_attrib(so->x,"Content-type",smtpCT);
              xmlnode_put_attrib(so->x,"Content-Description","Jabber message - PGP");

              // advertising message
              xmlnode_insert_cdata(so->x,"\r\n--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);

              xmlnode_insert_cdata(so->x,"Content-Type: text/plain; charset=UTF-8\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Description: Jabber message - Advertising\r\n\r\n",-1);

              xmlnode_insert_cdata(so->x,xmlnode_get_data(so->oAD),-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);

              // PGP message as attachment
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);

              xmlnode_insert_cdata(so->x,"Content-Type: application/pgp-encrypted;\r\n name=\"PGP encrypted message\";\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Disposition: attachment;\r\n filename=\"PGPEncryptedMessage.asc\"\r\n\r\n",-1);

              // PGP message
              xmlnode_insert_cdata(so->x,SMTP_PGP_BEGIN,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n",-1);
              xmlnode_insert_cdata(so->x,"Version: ",-1);
              xmlnode_insert_cdata(so->x,smtp_name,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,smtp_version,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Comment: Transport Layer",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loEncrypted),-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,SMTP_PGP_END,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n\r\n",-1);


              // End of boundary
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"--\r\n\r\n",-1);
              break;

         case SMTP_PGP_MIME:
   log_debug(ZONE,"SMTP: PGP MIME!!!");
              smtpboundary[0]='\0';
              snprintf(smtpboundary, sizeof(smtpboundary), "JPB_%04i%02i%02i%02i%02i%02i%i", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
              snprintf(smtpCT, sizeof(smtpCT), "multipart/encrypted;\r\n protocol=\"application/pgp-encrypted\";\r\n boundary=\"%s\"", smtpboundary);

              // encrypted content type
              xmlnode_put_attrib(so->x,"Content-type",smtpCT);
              xmlnode_put_attrib(so->x,"Content-Description","Jabber message - PGP");

              xmlnode_insert_cdata(so->x,"\r\nThis is an OpenPGP/MIME encrypted message (RFC 2440 and 3156)\r\n",-1);

              // Begin of boundary
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Type: application/pgp-encrypted\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Description: PGP/MIME version identification\r\n\r\nVersion: 1\r\n\r\n",-1);

              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Type: application/octet-stream; name=\"encrypted.asc\"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Description: OpenPGP encrypted message\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Disposition: inline; filename=\"encrypted.asc\"\r\n\r\n",-1);

              // PGP message
              xmlnode_insert_cdata(so->x,SMTP_PGP_BEGIN,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n",-1);
              xmlnode_insert_cdata(so->x,"Version: ",-1);
              xmlnode_insert_cdata(so->x,smtp_name,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,smtp_version,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Comment: Transport Layer",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loEncrypted),-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,SMTP_PGP_END,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n\r\n",-1);

              // End of boundary
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"--\r\n\r\n",-1);
              break;


         default:
   log_debug(ZONE,"SMTP: PGP PLAIN!!!");
              xmlnode_put_attrib(so->x,"Content-Type","text/plain; charset=UTF-8");
              xmlnode_put_attrib(so->x,"Content-Transfer-Encoding","8bit");
              xmlnode_put_attrib(so->x,"Content-Description","Jabber message - PGP");

              // PGP message
              xmlnode_insert_cdata(so->x,SMTP_PGP_BEGIN,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n",-1);
              xmlnode_insert_cdata(so->x,"Charset=UTF-8\r\n",-1);
              xmlnode_insert_cdata(so->x,"Version: ",-1);
              xmlnode_insert_cdata(so->x,smtp_name,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,smtp_version,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Comment: Transport Layer",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loEncrypted),-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,SMTP_PGP_END,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n\r\n",-1);
         }
      }

   // PGP, signed (only)
   if (loSigned!= NULL)
      {
   log_debug(ZONE,"SMTP: PGP SIGNED!!!");
      loCB=xmlnode_get_tag(sin->config,"core/pgp/cbs/cb"); // comment block
      if (loCB)
         lcCB=xmlnode_get_data(loCB);

      switch(liMode)
         {
         case SMTP_PGP_ATTACH:
   log_debug(ZONE,"SMTP: SIGNED ATTACH!!!");
              smtpboundary[0]='\0';
              snprintf(smtpboundary, sizeof(smtpboundary), "JPB_%04i%02i%02i%02i%02i%02i%i", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
              snprintf(smtpCT, sizeof(smtpCT), "multipart/mixed;\r\n boundary=\"%s\"", smtpboundary);

              xmlnode_put_attrib(so->x,"Content-type",smtpCT);
              xmlnode_put_attrib(so->x,"Content-Description","Jabber message - PGP");

              // advertising message
              xmlnode_insert_cdata(so->x,"\r\n--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);

              xmlnode_insert_cdata(so->x,"Content-Type: text/plain; charset=UTF-8\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Description: Jabber message - Advertising\r\n\r\n",-1);

              xmlnode_insert_cdata(so->x,xmlnode_get_data(so->oAD),-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);

              // PGP message as attachment
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);

              xmlnode_insert_cdata(so->x,"Content-Type: application/pgp-signature;\r\n name=\"PGP signature message\";\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit;\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Disposition: attachment;\r\n filename=\"PGPSignatureMessage.asc\"\r\n\r\n",-1);

              // PGP signature body
              xmlnode_insert_cdata(so->x,SMTP_PGP_BEGIN,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_SIGNATURE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n",-1);
              xmlnode_insert_cdata(so->x,"Version: ",-1);
              xmlnode_insert_cdata(so->x,smtp_name,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,smtp_version,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Comment: Transport Layer",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loSigned),-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,SMTP_PGP_END,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_SIGNATURE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n\r\n",-1);


              // End of boundary
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"--\r\n\r\n",-1);
              break;

         case SMTP_PGP_MIME:
   log_debug(ZONE,"SMTP: SIGNED MIME!!!");
              smtpboundary[0]='\0';
              snprintf(smtpboundary, sizeof(smtpboundary), "JPB_%04i%02i%02i%02i%02i%02i%i", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
              snprintf(smtpCT, sizeof(smtpCT), "multipart/signed;\r\n protocol=\"application/signature\";\r\n boundary=\"%s\"", smtpboundary);


              // basic content type
              xmlnode_put_attrib(so->x,"Content-type",smtpCT);
              xmlnode_put_attrib(so->x,"Content-Description","Jabber message - PGP");


              xmlnode_insert_cdata(so->x,"\r\nThis is an OpenPGP/MIME signed message (RFC 2440 and 3156)\r\n",-1);

              // Begin of boundary
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Type: Content-Type: text/plain; charset=UTF-8\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n\r\n",-1);
              // body text
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loBody),-1);


              // PGP signature
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Type: application/pgp-signature; name=\"signature.asc\"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Description: digital signature\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Disposition: attachment; filename=\"signature.asc\"\r\n\r\n",-1);


              // PGP signature body
              xmlnode_insert_cdata(so->x,SMTP_PGP_BEGIN,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_SIGNATURE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n",-1);
              xmlnode_insert_cdata(so->x,"Version: ",-1);
              xmlnode_insert_cdata(so->x,smtp_name,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,smtp_version,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Comment: Transport Layer",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loSigned),-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,SMTP_PGP_END,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_SIGNATURE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n\r\n",-1);

              // End of boundary
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"--\r\n\r\n",-1);
              break;


         default:
   log_debug(ZONE,"SMTP: SIGNED PLAIN!!!");
              xmlnode_put_attrib(so->x,"Content-Type","text/plain; charset=UTF-8");
              xmlnode_put_attrib(so->x,"Content-Transfer-Encoding","8bit");
              xmlnode_put_attrib(so->x,"Content-Description","Jabber message - PGP");

              xmlnode_insert_cdata(so->x,SMTP_PGP_SIGNED_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"\r\nHash: SHA1",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);

              // body text
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loBody),-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);

              // PGP signed
              xmlnode_insert_cdata(so->x,SMTP_PGP_BEGIN,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_SIGNATURE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n",-1);
              xmlnode_insert_cdata(so->x,"Charset=UTF-8\r\n",-1);
              xmlnode_insert_cdata(so->x,"Version: ",-1);
              xmlnode_insert_cdata(so->x,smtp_name,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,smtp_version,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Comment: Transport Layer",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loSigned),-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,SMTP_PGP_END,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_SIGNATURE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n\r\n",-1);
              break;

         }

      }


   // xhtml and text
   if (liPGP==0 && loHTML!= NULL && loBody!= NULL)
      {
   log_debug(ZONE,"SMTP: HTML/TEXT!!!");
      smtpboundary[0]='\0';
      snprintf(smtpboundary, sizeof(smtpboundary), "JPB_%04i%02i%02i%02i%02i%02i%i", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
      snprintf(smtpCT, sizeof(smtpCT), "multipart/alternative; boundary=\"%s\"", smtpboundary);

   log_debug(ZONE,"SMTP: PUT CT");
      xmlnode_put_attrib(so->x,"Content-type",smtpCT);

   log_debug(ZONE,"SMTP: PUT BOUNDARY HEAD");
      xmlnode_insert_cdata(so->x,"--",-1);
      xmlnode_insert_cdata(so->x,smtpboundary,-1);
      xmlnode_insert_cdata(so->x,"\r\n",-1);

      xmlnode_insert_cdata(so->x,"Content-Type: text/plain; charset=UTF-8\r\n",-1);
      xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n",-1);
      xmlnode_insert_cdata(so->x,"Content-Description: Jabber message - text format\r\n",-1);
      xmlnode_insert_cdata(so->x,"\r\n",-1);
      xmlnode_insert_cdata(so->x,xmlnode_get_data(loBody),-1);

      if (so->Advertising==1)
         {
   log_debug(ZONE,"SMTP: ADD AD");
         xmlnode_insert_cdata(so->x,"\r\n",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_data(so->oAD),-1);
         }
      xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
       

      // for html is needly insert <head> tag with meta tag about charset
      // <head><meta content="text/html; charset=utf-8" http-equiv="content-type" /></head>
/*
       html=xmlnode_dup(xmlnode_get_tag(p->x,"html"));
       meta=xmlnode_insert_tag(xmlnode_insert_tag(html,"head"),"meta");
       xmlnode_put_attrib(meta,"content-type","text/html; charset=utf-8");
       xmlnode_put_attrib(meta,"http-equiv","content-type");
*/
      html= xmlnode_new_tag_pool(so->p,"html");
      if (xmlnode_has_attribs(loHTML))
          xmlnode_insert_node(html, xmlnode_get_firstattrib(loHTML));

      meta=xmlnode_insert_tag(xmlnode_insert_tag(html,"head"),"meta");
      xmlnode_put_attrib(meta,"content-type","text/html; charset=utf-8");
      xmlnode_put_attrib(meta,"http-equiv","content-type");
      xmlnode_insert_node(html, xmlnode_get_firstchild(loHTML));

   log_debug(ZONE,"SMTP: PUT BOUNDARY HEAD");
      xmlnode_insert_cdata(so->x,"--",-1);
      xmlnode_insert_cdata(so->x,smtpboundary,-1);
      xmlnode_insert_cdata(so->x,"\r\n",-1);
      xmlnode_insert_cdata(so->x,"Content-Type: text/html; charset=UTF-8\r\n",-1);
      xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n",-1);
      xmlnode_insert_cdata(so->x,"Content-Description: Jabber message - html format\r\n",-1);
      xmlnode_insert_cdata(so->x,"\r\n",-1);
      xmlnode_insert_cdata(so->x,xmlnode2str(html),-1);

      if (so->Advertising==1)
         {
   log_debug(ZONE,"SMTP: ADD AD");
         xmlnode_insert_cdata(so->x,"\r\n",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_data(so->oAD),-1);
         }
      xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
       
   log_debug(ZONE,"SMTP: PUT BOUNDARY FOOTER");
      xmlnode_insert_cdata(so->x,"--",-1);
      xmlnode_insert_cdata(so->x,smtpboundary,-1);
      xmlnode_insert_cdata(so->x,"--\r\n\r\n",-1);
      }


   // only xhtml
   if (liPGP==0 && loHTML!= NULL && loBody== NULL)
      {
   log_debug(ZONE,"SMTP: HTML!!!");
      html= xmlnode_new_tag_pool(so->p,"html");
      if (xmlnode_has_attribs(loHTML))
          xmlnode_insert_node(html, xmlnode_get_firstattrib(loHTML));

   log_debug(ZONE,"SMTP: GENERATE HTML");
      meta=xmlnode_insert_tag(xmlnode_insert_tag(html,"head"),"meta");
      xmlnode_put_attrib(meta,"content-type","text/html; charset=utf-8");
      xmlnode_put_attrib(meta,"http-equiv","content-type");
      xmlnode_insert_node(html, xmlnode_get_firstchild(loHTML));

      xmlnode_put_attrib(so->x,"Content-Type","text/html; charset=UTF-8");
      xmlnode_put_attrib(so->x,"Content-Transfer-Encoding","8bit");
      xmlnode_put_attrib(so->x,"Content-Description","Jabber message - html format");
   log_debug(ZONE,"SMTP: ADD HTML");
      xmlnode_insert_cdata(so->x,xmlnode2str(html),-1);

      if (so->Advertising==1)
         {
   log_debug(ZONE,"SMTP: ADD AD");
         xmlnode_insert_cdata(so->x,"\r\n",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_data(so->oAD),-1);
         }
      xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
      }


   // only text
   if (liPGP==0 && loHTML== NULL && loBody!= NULL)
      {
   log_debug(ZONE,"SMTP: TEXT!!!");
      xmlnode_put_attrib(so->x,"Content-Type","text/plain; charset=UTF-8");
      xmlnode_put_attrib(so->x,"Content-Transfer-Encoding","8bit");
      xmlnode_put_attrib(so->x,"Content-Description","Jabber message - text format");
   log_debug(ZONE,"SMTP: ADD BODY");
      xmlnode_insert_cdata(so->x,xmlnode_get_data(loBody),-1);
      if (so->Advertising==1)
         {
   log_debug(ZONE,"SMTP: ADD AD");
         xmlnode_insert_cdata(so->x,"\r\n",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_data(so->oAD),-1);
         }
      xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
       
      }

   // delete email from backup repository
   if (sin->tmpBackupJabber==1)
      {
   log_debug(ZONE,"SMTP: REMOVE BACKUP FILE");
      if (j_strlen(lcBFile)>0)
         remove(lcBFile);
      }

   return so;
   }

/* read an incoming line from the connection */
void smtp_out_read(mio m, int state, void *arg, char *buffer, int bufsz)
   {
   char *cbuffer, *cur, *args;
   smtpp par = (smtpp)(arg);
   int i;

   log_debug(ZONE,"SMPT: MIO state %i",state);

   switch(state)
      {
      case MIO_CLOSED:
           log_debug(ZONE,"SMPT: MIO_CLOSED\r\n");
           if (par->so==NULL)
              {
              smtp_ReplyError(par, par->jp, "message", "Timeout error", SMTP_CODE_504);
              par->sin->JabberMessagesOutError++;
              smtp_StatsInc(par, "JabberMessagesOutError");
              log_error("smtp","SMTP timeout error");
              snprintf(par->sin->cJabber_Status, 20, "SMTP timeout error\0");
              }

           return;

      case MIO_NEW:
           log_debug(ZONE,"SMPT: MIO_NEW\r\n");
           par->so = smtp_out_new(m, par);
           pool_cleanup(par->so->p, smtp_out_cleanup, (void *)par);
           snprintf(par->sin->cJabber_Status, 20, "Send data to SMTP\0");
           mio_reset(m, smtp_out_read, (void *)par);
           return;

      case MIO_BUFFER:
           log_debug(ZONE,"SMPT: MIO_BUFFER\r\n");
           break;

      default:
           return;
      }


   par->so->timer = time(NULL); /* so we don't timeout */

   if(bufsz <= 0) return;

   if (par->so->buffer != NULL)
      { /* old data yet, combine and use that */
      cur = malloc(strlen(par->so->buffer) + bufsz + 1);
      *cur = '\0';
      strcat(cur,par->so->buffer);
      strcat(cur,buffer);
      free(par->so->buffer);
      par->so->buffer = buffer = cur;
      bufsz = strlen(buffer);
      }

   #ifdef SMTP_DB
    log_debug(ZONE,"phase %d data [%s]",par->so->phase, buffer);
   #else
    log_debug(ZONE,"phase %d data",par->so->phase);
   #endif
   cur = cbuffer = (char *)buffer;
   for(i = 1; i < bufsz; i++)
      {
      if (cbuffer[i-1] == '\r' && cbuffer[i] == '\n')
         {
         cbuffer[i-1] = '\0';
         cbuffer[i] = '\0';

         if (strlen(cur) > 0)
            {
            args = strstr(cur," ");
            if (args != NULL)
               {
               *args = '\0';
               ++args;
               }
            par->so->iStatus=atoi(cur);
            smtp_out_status(par,args);
            }
         cur = cbuffer + i + 1;
         }
      }

   free(par->so->buffer);
   par->so->buffer = NULL;
   i = strlen(cur);
   if (i > 0) /* the read was cut off */
      {
      par->so->buffer = strdup(cur);
      }

   }



// S:2005-09-01 gorila@dione.zcu.cz
int smtp_out_packets_message(smtpp par,char *lcType)
   {
   int liProcess=0;
   jpacket jp=par->jp;
   jid ljidFrom=smtp_2mx(par->sin, jp->from);

   if (jp->to == NULL || jp->to->user == NULL || strstr(jp->to->user,"%") == NULL || ljidFrom == NULL || jpacket_subtype(jp) == JPACKET__ERROR)
      {
      if ((liProcess=smtp_admin_message(par,lcType))==0)
          deliver_fail(par->dp, "Invalid Address");

      liProcess=-1;
      pool_free(par->tmppool);
      }

   if (liProcess==0 && (jp->subtype==JPACKET__CHAT || jp->subtype==JPACKET__NONE))
      {
      /* hide session on the packet, and pass it to be handled after the conneciton is open */
      par->sin->JabberMessages++;
      smtp_StatsInc(par, "JabberMessages");

      snprintf(par->sin->cJabber_Status, 20, "Connect to SMTP\0");
	  mio_connect(pstrdup(par->tmppool,par->sin->relay), par->sin->relayport, smtp_out_read, (void *)par, 30, NULL, NULL);
      liProcess=1;
      }


   if (liProcess==0 && jp->subtype==JPACKET__GROUPCHAT)
      {
      pool_free(par->tmppool);
       // groupchat is not supported
      }

/*
   if (liProcess==1)
      {
      deliver(dpacket_new(xmlnode_dup(x)),sin->i);
      xmlnode_free(x);
      }

*/

   return liProcess;
   }
// E:2005-09-01 gorila@dione.zcu.cz
