/* --------------------------------------------------------------------------
 *
 * License
 *
 * The contents of this file are subject to the Jabber Open Source License
 * Version 1.0 (the "License").  You may not copy or use this file, in either
 * source code or executable form, except in compliance with the License.  You
 * may obtain a copy of the License at http://www.jabber.com/license/ or at
 * http://www.opensource.org/.  
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyrights
 * 
 * Portions created by or assigned to Jabber.com, Inc. are 
 * Copyright (c) 1999-2000 Jabber.com, Inc.  All Rights Reserved.  Contact
 * information for Jabber.com, Inc. is available at http://www.jabber.com/.
 *
 * Portions Copyright (c) 1998-1999 Jeremie Miller.
 *
 * Portions Copyright (c) 2002 Matthias Wimmer.
 * 
 * Acknowledgements
 * 
 * Special thanks to the Jabber Open Source Contributors for their
 * suggestions and support of Jabber.
 * 
 * --------------------------------------------------------------------------*/
 
#include "smtp.h"


/*

This is the smtp server component.

It acts as a simple SMTP server for both receiving email directly from another server or for delivering
email to another server.

What inspired me to write this very frightening thing is a mystery :) 

Jer

*/

/* takes foo@mapped.host or foo%jabber.org@smtp.host and translates to foo@jabber.org */

jid smtp_mx2(smtpi i, jid id)
   {
   char *at, *trhost;
   xmlnode tr;

   if(id == NULL || id->user == NULL) return NULL;

   log_debug(ZONE,"mx2 checking %s",jid_full(id));

   // query for any translation
   tr = xmlnode_get_tag(i->config, spools(id->p, "core/map?mxhost=",id->server,id->p));
   trhost = xmlnode_get_attrib(tr,"jabber");

   if (trhost != NULL)
      jid_set(id,trhost,JID_SERVER);
   else
      {
      if ((at = strstr(id->user,"%")) != NULL)
         {
         *at = '@';
         id = jid_new(id->p,id->user);

         // check to make sure this id is valid to relay between 
         if (id != NULL && i->open == 0 && 
             xmlnode_get_tag(i->config,spools(id->p,"smtp/open=",id->server,id->p)) == NULL
            )
            return NULL;
         }
      else
         return NULL;
      }

   log_debug(ZONE,"mx2 returning %s",jid_full(id));
   return id;
   }

/* takes foo@jabber.org and translates to foo@mapped.host or foo%jabber.org@smtp.host */
jid smtp_2mx(smtpi i, jid from)
   {
   char *at, *trhost, *strid;
   jid id;
   xmlnode tr;

   if(from == NULL || from->user == NULL) return NULL;

   log_debug(ZONE,"2mx checking %s",jid_full(from));

   /* copy jid and modify copy for the result */
   id = jid_new(from->p,jid_full(from));
   jid_set(id,NULL,JID_RESOURCE);

   /* query for any translation */
   tr = xmlnode_get_tag(i->config, spools(id->p, "core/map?jabber=",id->server,id->p));
   trhost = xmlnode_get_attrib(tr,"mxhost");

   if (trhost != NULL)
      jid_set(id,trhost,JID_SERVER);
   else
      {
      strid = jid_full(id);

      at = strstr(strid,"@");
      *at = '%';
      id = jid_new(id->p,i->me);
      jid_set(id,strid,JID_USER);
      }

   log_debug(ZONE,"2mx returning %s",jid_full(id));
   return id;
   }

void smtp_SendMessageToAdmin(smtpi sin, xmlnode loAdmins,xmlnode x, const char *lcMSG)
   {
   xmlnode loMSG,loAdmin;
   loMSG= xmlnode_new_tag("message");

   xmlnode_put_attrib(loMSG,"from",xmlnode_get_attrib(xmlnode_get_parent(x),"id"));
   xmlnode_put_attrib(loMSG,"type","chat");
   xmlnode_insert_cdata(xmlnode_insert_tag(loMSG,"body"),lcMSG,-1);

   for (loAdmin = xmlnode_get_firstchild(loAdmins); loAdmin != NULL; loAdmin = xmlnode_get_nextsibling(loAdmin))
       {
       if (loAdmin->type!=NTYPE_TAG || strcmp(xmlnode_get_attrib(loAdmin,"xmlns"),"smtp:backup:report")!=0 )
	       	    continue;

       xmlnode_put_attrib(loMSG,"to",xmlnode_get_data(loAdmin));
       deliver(dpacket_new(xmlnode_dup(loMSG)),sin->i);
       }

   xmlnode_free(loMSG);
   }

void smtp(instance i, xmlnode x)
   {
   xmlnode config,configF, cur, jep0033, loFile, loRF,loBackup,loMessage;
   xdbcache xc;
   smtpi si;
   char *lcPom,*lcJabberBackup,*lcSMTPBackup,*lcBFile;
   int liErr,lii,liFolderC;
   struct dirent   *dirp;
   struct DIR      *dp;


   log_debug(ZONE,"smtp transport loading");

   xc = xdb_cache(i);
   config = xdb_get(xc, jid_new(xmlnode_pool(x),"config@-internal"),"jabber:config:smtp");



   /* set up internal instance and hash tables */
   si = pmalloco(i->p,sizeof(_smtpi));
   si->i = i;
   si->xc = xc;
   si->JabberMessagesOut=si->JabberMessagesOutError=
	   si->JabberMessages=si->SMTPMessages=
	   si->SMTPMessagesIn=si->SMTPMessagesInError=
       si->SMTPSpam=si->SMTPCommandUnknown=
       si->jep0033=si->CoreContacts=
       si->CoreContactsOnline, si->CoreAccounts=
       si->tmpBackupJabber=si->tmpBackupSMTP=0;
   si->cSMTP_Status[0]=si->cJabber_Status[0]=' ';
   si->cSMTP_Status[1]=si->cJabber_Status[1]='\0';


   // get resources file name and read it
   if ((si->config_file=xmlnode_get_tag_data(config,"config"))==NULL)
      si->config_file=pstrdup(i->p,SMTP_CONFIG_FILE);

   if ((configF=xmlnode_file(si->config_file))==NULL)
      { // file not exist or any other bug
      log_error("smtp","SMTP Server cannot load config file.");
      return;
      }
   si->config = xmlnode_dup_pool(i->p, configF);


   // try create backup folder
   loBackup=xmlnode_get_tag(si->config,"jabber/backup");
   if ((lcJabberBackup=xmlnode_get_attrib(loBackup,"folder")   )==NULL)
      lcJabberBackup= pstrdup(i->p,SMTP_BACKUPJABBER_FOLDER);

   if (smtp_CreateFolder(lcJabberBackup)==0)
      si->tmpBackupJabber=1;


   // test if any file in folder, if yes, send mesage to all admins
   if (si->tmpBackupJabber==1 && (dp = opendir(lcJabberBackup))!=NULL)
      {
      lii=liFolderC=0;
      while ( (dirp = readdir((DIR *)dp)) != NULL)
            {
            if (strcmp(dirp->d_name, ".") == 0  ||
                strcmp(dirp->d_name, "..") == 0 ||
                strcmp(dirp->d_name, "old") == 0)
               continue;      // ignore dot and dot-dot 


            if (lii==0)
               liFolderC=smtp_CreateFolder(spools(i->p,lcJabberBackup,"/old",i->p));

            if (liFolderC==0)
               {
               lcBFile=spools(i->p,lcJabberBackup,"/",dirp->d_name,i->p);
               if ((loMessage=xmlnode_file(lcBFile))!=NULL)
                   smtp_SendMessageToAdmin(si, xmlnode_get_tag(si->config,"jabber/admins"),x, xmlnode2str(loMessage));

               rename(spools(i->p,lcJabberBackup,"/",dirp->d_name,i->p),spools(i->p,lcJabberBackup,"/old/",dirp->d_name,i->p));
               }

            lii=1;
            }
      closedir((DIR *)dp);

      if (lii==1)
         smtp_SendMessageToAdmin(si, xmlnode_get_tag(si->config,"jabber/admins"),x, "Any jabber message cause reboot.");
      }


   loBackup=xmlnode_get_tag(si->config,"smtp/backup");
   if ((lcSMTPBackup=xmlnode_get_attrib(loBackup,"folder") )==NULL)
      lcSMTPBackup= pstrdup(i->p,SMTP_BACKUPSMTP_FOLDER);

   if (smtp_CreateFolder(lcSMTPBackup)==0)
      si->tmpBackupSMTP=1;

   // test if any file in folder, if yes, send mesage to all admins
   if (si->tmpBackupSMTP==1 && (dp = opendir(lcSMTPBackup)) != NULL)
      {
      lii=liFolderC=0;
      while ( (dirp = readdir((DIR *)dp)) != NULL)
            {
            if (strcmp(dirp->d_name, ".") == 0  ||
                strcmp(dirp->d_name, "..") == 0 ||
                strcmp(dirp->d_name, "old") == 0)
               continue;      // ignore dot and dot-dot


            if (lii==0)
               liFolderC=smtp_CreateFolder(spools(i->p,lcSMTPBackup,"/old",i->p));

            if (liFolderC==0)
               {
               lcBFile=spools(i->p,lcSMTPBackup,"/",dirp->d_name,i->p);
               if ((loMessage=xmlnode_file(lcBFile))!=NULL)
                   smtp_SendMessageToAdmin(si, xmlnode_get_tag(si->config,"smtp/admins"),x, xmlnode2str(loMessage));

               rename(spools(i->p,lcSMTPBackup,"/",dirp->d_name,i->p),spools(i->p,lcSMTPBackup,"/old/",dirp->d_name,i->p));
               }

            lii=1;
            }
      closedir((DIR *)dp);

      if (lii==1)
         smtp_SendMessageToAdmin(si, xmlnode_get_tag(si->config,"smtp/admins"),x, "Any SMTP message cause reboot.");

      }


   // get default language
   if ((lcPom=xmlnode_get_tag_data(si->config,"core/language"))==NULL)
      lcPom= SMTP_RC_DEFAULT_LANG;

   si->DefaultLang=pstrdup(i->p, lcPom);


   // get statistics file name and read it
   if ((si->stat_file=xmlnode_get_tag_data(si->config,"core/statistics"))==NULL)
      si->stat_file=pstrdup(i->p, SMTP_STATISTICS_FILE);

   lcPom = (char*)pstrdup(i->p,si->stat_file);
   smtp_GetFolderFromFile(lcPom);
   liErr=smtp_CreateFolder(lcPom);

   if (liErr!=0)
      { // file not exist or any other bug
      log_error("smtp","SMTP Server cannot create folder for statistics file");
      return;
      }

   if ((si->statistics=xmlnode_file(si->stat_file))==NULL)
      { // file not exist or any other bug
      si->statistics=xmlnode_new_tag_pool(si->i->p,"smtp");
      xmlnode_put_attrib(si->statistics,"xmlns","jabber:status:smtp");

      xmlnode_put_attrib(si->statistics,"Start","0");
      xmlnode_put_attrib(si->statistics,"StartLastDatetime","0");

      xmlnode_put_attrib(si->statistics,"CoreAccounts","0");

	  xmlnode_put_attrib(si->statistics,"JabberMessages","0");
      xmlnode_put_attrib(si->statistics,"JabberMessagesOut","0");
      xmlnode_put_attrib(si->statistics,"JabberMessagesOutError","0");

      xmlnode_put_attrib(si->statistics,"SMTPCommandUnknown","0");
      xmlnode_put_attrib(si->statistics,"SMTPMessages","0");
      xmlnode_put_attrib(si->statistics,"SMTPMessagesIn","0");
      xmlnode_put_attrib(si->statistics,"SMTPMessagesInError","0");

      xmlnode_put_attrib(si->statistics,"SMTPSpam","0");
      }  

   xmlnode_put_attrib(si->statistics,"CoreContacts","0");
   xmlnode_put_attrib(si->statistics,"CoreContactsOnline","0");


   // get resources file name and read it
   if ((si->res_file=xmlnode_get_tag_data(si->config,"core/resources"))==NULL)
      si->res_file=pstrdup(i->p,SMTP_RESOURCE_FILE);

   if ((si->resources=xmlnode_file(si->res_file))==NULL)
      { // file not exist or any other bug
      log_error("smtp","SMTP Server must have resource file");
      return;
      }

   // get roster
   if ((si->roster_file=xmlnode_get_tag_data(si->config,"core/roster"))==NULL)
      si->roster_file=pstrdup(i->p,SMTP_ROSTER_FILE);

   si->roster_folder=smtp_GetFolderFromFile((char*)pstrdup(i->p,si->roster_file));
   liErr=smtp_CreateFolder(si->roster_folder);
   if (liErr!=0)
      { // file not exist or any other bug
      log_error("smtp","SMTP Server cannot create folder for roster file");
      return;
      }

   

   si->OnlineList=xmlnode_new_tag_pool(si->i->p,"list");
   si->OfflineList=xmlnode_new_tag_pool(si->i->p,"list");

   si->roster_files=xmlnode_new_tag_pool(si->i->p,"smtp");
   xmlnode_put_attrib(si->roster_files,"xmlns","jabber:rosterfiles:smtp");


   if ((si->roster=xmlnode_file(si->roster_file))==NULL)
      { // file not exist or any other bug
      si->roster=xmlnode_new_tag_pool(si->i->p,"smtp");
      xmlnode_put_attrib(si->roster,"xmlns","jabber:roster:smtp");
      }  
   else
      {
      // build file list from roster.xml
      for (loFile = xmlnode_get_firstchild(si->roster); loFile != NULL; loFile = xmlnode_get_nextsibling(loFile))
          {
          if (loFile->type!=NTYPE_TAG)
              continue;

          if ((loRF=xmlnode_file(xmlnode_get_data(loFile)))==NULL)
             log_error("smtp","SMTP Server cannot read roster file %s",xmlnode_get_data(loFile));

          xmlnode_insert_node(si->roster_files,loRF);
          }
      
      }

   // main body
   if ((si->me = xmlnode_get_tag_data(si->config,"jabber/mxhost")) == NULL)
      {
      log_error("smtp","SMTP Server must have a default SMTP <mxhost>smtp.host.foo</mxhost> configured");
      return;
      }

   if ((cur=xmlnode_get_tag(si->config,"smtp/open")) == NULL || xmlnode_get_data(cur)==NULL )
      si->open = 1;

   // relay smtp server
   cur = xmlnode_get_tag(si->config,"jabber/relay");
   si->relayport=j_atoi(xmlnode_get_attrib(cur, "port"), SMTP_Relay_Port);

   if((si->relay = xmlnode_get_attrib(cur,"ip")) == NULL)
       si->relay = pstrdup(i->p, SMTP_DEFAULT_RELAY);

   register_phandler(i, o_DELIVER, smtp_out_packets, (void *)si);


   si->spamcheck = xmlnode_get_tag_data(si->config,"smtp/spamcheck");

   // vytvoit vlastn thread
   if ((cur = xmlnode_get_tag(config,"smtp/ip")) != NULL)
      for (;cur != NULL; xmlnode_hide(cur), cur = xmlnode_get_tag(config,"smtp/ip"))
          {
          mio_listen(j_atoi(xmlnode_get_attrib(cur, "port"), SMTP_Incomming_Port), xmlnode_get_data(cur), smtp_in_read, (void*)si, NULL, NULL);
          }
   else // no special config, use defaults //
      mio_listen(SMTP_Incomming_Port, NULL, smtp_in_read, (void *)si, NULL, NULL);
 

//   xmlnode_free(config);

   // JEP-0033 test
   cur = xmlnode_get_tag(si->config,"core/map");
   jep0033= xmlnode_new_tag("iq");
   xmlnode_put_attrib(jep0033,"to",xmlnode_get_attrib(cur, "jabber"));
 
   xmlnode_put_attrib(jep0033,"from",xmlnode_get_attrib(xmlnode_get_parent(x),"id"));
   xmlnode_put_attrib(jep0033,"type","get");
   xmlnode_put_attrib(jep0033,"id","smtp_test_jep0033");
   xmlnode_put_attrib(xmlnode_insert_tag(jep0033,"query"),"xmlns","http://jabber.org/protocol/disco#info");

   deliver(dpacket_new(xmlnode_dup(jep0033)),i);
   xmlnode_free(jep0033);


   smtp_StatsSetDelta(si, "Start",1);
   lcPom = (char*)pmalloc_x(i->p, 18,' ');
   smtp_GetDateTime((char *)lcPom);
   smtp_StatsSaveValue_(si, "StartLastDatetime",(char *)lcPom);
   
   }

smtps smtp_new(mio m)
   {
   smtps so;

   so = pmalloco(mio_pool(m), sizeof(_smtps));
   so->m = m;
   so->p = mio_pool(m);
   so->x=so->oJID=so->oAD=NULL;

   so->toPGPMIME=so->SRMode=so->Advertising=0;
   so->SRSeparator=so->SRText=NULL;
   return so;
   }


smtpsi smtp_new_i(mio m)
   {
   smtpsi si;
   si = pmalloco(mio_pool(m), sizeof(_smtpsi));
   si->m = m;
   si->p = mio_pool(m);
   si->message = spool_new(si->p);
   return si;
   }

smtpp smtp_param(smtpi sin)
   {
   smtpp par;
   pool tmppool;

   par=pmalloco(tmppool=pool_new(), sizeof(_smtpp));
   par->tmppool=tmppool;
   par->sin=sin;

   return par;
   }


xmlnode smtp_roster_get_defaultitem(smtpp par, char *lcJID)
   {
   xmlnode loJID, loSubj;
   smtpi sin=par->sin;

   loJID=xmlnode_new_tag_pool(sin->i->p,"item");

   xmlnode_put_attrib(loJID,"jid",lcJID);

   // set default values

   xmlnode_put_attrib(loJID,"UseGlobalSettings","1");
   xmlnode_put_attrib(loJID,"Attachments",xmlnode_get_attrib(xmlnode_get_tag(sin->config,"smtp/attachments"),"pass"));
   xmlnode_put_attrib(loJID,"PGPJabberToMIME",xmlnode_get_attrib(xmlnode_get_tag(sin->config,"jabber/pgp"),"mime"));
   xmlnode_put_attrib(loJID,"PGPToJabbernonMIMETox",xmlnode_get_attrib(xmlnode_get_tag(sin->config,"smtp/pgp"), "nonmime2x"));

   loSubj=xmlnode_get_tag(sin->config,"jabber/subject");
   if ( loSubj!=NULL)
      {
      xmlnode_put_attrib(loJID,"J2S_SRMode",xmlnode_get_attrib(loSubj,"replace"));
      xmlnode_put_attrib(loJID,"J2S_SRSeparator",xmlnode_get_attrib(loSubj,"separator"));
      xmlnode_put_attrib(loJID,"J2S_SRText",xmlnode_get_data(loSubj));
      }


   loSubj=xmlnode_get_tag(sin->config,"smtp/subject");
   if ( loSubj!=NULL)
      {
      xmlnode_put_attrib(loJID,"S2J_SRMode",xmlnode_get_attrib(loSubj,"replace"));
      xmlnode_put_attrib(loJID,"S2J_SRSeparator",xmlnode_get_attrib(loSubj,"separator"));
      xmlnode_put_attrib(loJID,"S2J_SRText",xmlnode_get_data(loSubj));
      }
   
   xmlnode_put_attrib(loJID,"default","1"); // flag of default item
   return loJID;
   }

xmlnode smtp_roster_get_item(smtpp par, char *lcJID, int liDefault)
   {
   xmlnode loJID=NULL,loFile;
   smtpi sin=par->sin;
   int liFound=0;
   char *lcLetter;
   if (j_strlen(lcJID)==0)
      return (xmlnode) NULL;

   lcLetter=pmalloco(par->tmppool,2);
   lcLetter[0]=lcJID[0];
   lcLetter[1]='\0';

   loFile=xmlnode_get_tag(sin->roster,spools(par->tmppool,"file?type=",lcLetter,par->tmppool));

   if (loFile!=NULL)
      if ((loFile=xmlnode_get_tag(sin->roster_files,spools(par->tmppool,"file?type=",lcLetter,par->tmppool)))!=NULL)
         {
         if ((loJID=xmlnode_get_tag(loFile,spools(par->tmppool,"item?jid=",lcJID,par->tmppool)))!=NULL)
            {
            liFound=1;
            }
         }

   if (liFound==0 && liDefault==1) // if not found and must return default item
       loJID=smtp_roster_get_defaultitem(par,lcJID);

   return loJID;
   }


void smtp_roster_set_item(smtpp par, char *lcJID, xmlnode loJID)
   {
   xmlnode loFile,loJIDOld,loFileM;
   smtpi sin=par->sin;
   char *lcFile, *lcLetter;
   int liSaveM=0;
   if (j_strlen(lcJID)==0)
      return;

   lcLetter=pmalloco(par->tmppool,2);
   lcLetter[0]=lcJID[0];
   lcLetter[1]='\0';
   xmlnode_hide_attrib(loJID,"default");

   if ((loFileM=xmlnode_get_tag(sin->roster,spools(par->tmppool,"file?type=",lcLetter,par->tmppool)))==NULL)
      {
      // zznam pro dan psmeno neexistuje
      lcFile = (char*)pmalloco(par->tmppool, 254);
      lcFile=spools(par->tmppool,sin->roster_folder,"/roster_",lcLetter,".xml",par->tmppool);

      xmlnode_put_attrib((loFileM=xmlnode_insert_tag(sin->roster,"file")),"type",lcLetter);
      xmlnode_insert_cdata(loFileM,lcFile,-1);
      liSaveM=1;
      }
   else
      lcFile=xmlnode_get_data(loFileM);

   if ((loFile=xmlnode_get_tag(sin->roster_files,spools(par->tmppool,"file?type=",lcLetter,par->tmppool)))==NULL)
      {
      // zznam pro dan psmeno neexistuje
      xmlnode_put_attrib(loFile=xmlnode_insert_tag(sin->roster_files,"file"),"type",lcLetter);
      }


   if ((loJIDOld=xmlnode_get_tag(loFile,spools(par->tmppool,"item?jid=",lcJID,par->tmppool)))==NULL)
      {
      // new item
      xmlnode_insert_node(loFile,loJID);
      }
   else
      {
      // replace item
/*
	  xmlnode_put_attrib(loJID,"UseGlobalSettings",xmlnode_get_attrib(loJID,"UseGlobalSettings"));
	  xmlnode_put_attrib(loJID,"Attachments",xmlnode_get_attrib(loJID,"Attachments"));
	  xmlnode_put_attrib(loJID,"PGPJabberToMIME",xmlnode_get_attrib(loJID,""PGPJabberToMIME"));
	  xmlnode_put_attrib(loJID,"PGPToJabbernonMIMETox",xmlnode_get_attrib(loJID,"PGPToJabbernonMIMETox"));
	  xmlnode_put_attrib(loJID,"payd",xmlnode_get_attrib(loJID,"payd"));

	  xmlnode_put_attrib(loJID,"J2S_SRMode",xmlnode_get_attrib(loJID,"J2S_SRMode"));
	  xmlnode_put_attrib(loJID,"J2S_SRSeparator",xmlnode_get_attrib(loJID,"J2S_SRSeparator"));
	  xmlnode_put_attrib(loJID,"J2S_SRText",xmlnode_get_attrib(loJID,"J2S_SRText"));

	  xmlnode_put_attrib(loJID,"S2J_SRMode",xmlnode_get_attrib(loJID,"S2J_SRMode"));
	  xmlnode_put_attrib(loJID,"S2J_SRSeparator",xmlnode_get_attrib(loJID,"S2J_SRSeparator"));
	  xmlnode_put_attrib(loJID,"S2J_SRText",xmlnode_get_attrib(loJID,"S2J_SRText"));



*/

      }
      
   xmlnode2file(lcFile,loFile);
   if (liSaveM==1)
      {
      xmlnode2file(sin->roster_file,sin->roster);
      }
   }


void smtp_roster_remove_item(smtpp par, char *lcJID)
   {
   xmlnode loFile,loJIDOld,loFileM;
   smtpi sin=par->sin;
   char *lcFile, *lcLetter;

   if (j_strlen(lcJID)==0)
      return;

   lcLetter=pmalloco(par->tmppool,2);
   lcLetter[0]=lcJID[0];
   lcLetter[1]='\0';

   if ((loFileM=xmlnode_get_tag(sin->roster,spools(par->tmppool,"file?type=",lcLetter,par->tmppool)))==NULL)
      {
      // zznam pro dan psmeno neexistuje
      return;
      }
   else
      lcFile=xmlnode_get_data(loFileM);

   if ((loFile=xmlnode_get_tag(sin->roster_files,spools(par->tmppool,"file?type=",lcLetter,par->tmppool)))==NULL)
      {
      // zznam pro dan psmeno neexistuje
      return;
      }


   if ((loJIDOld=xmlnode_get_tag(loFile,spools(par->tmppool,"item?jid=",lcJID,par->tmppool)))==NULL)
      {
      // item not exist
      return;
      }

   xmlnode_hide(loJIDOld);
   xmlnode2file(lcFile,loFile);
   }


smptsi_rcp smtp_NewRecipient(pool p,jid ojid)
   {
   smptsi_rcp rcp;

   rcp=pmalloco(p, sizeof(_smptsi_rcp));
   rcp->rcpt=ojid;
   rcp->next=NULL;
   return rcp;
   }

smptsi_rcp smtp_AppendRcpt(smptsi_rcp a, smptsi_rcp b)
   {
   smptsi_rcp next;

   if (a == NULL)
      return NULL;

   if (b == NULL)
      return a;

   next = a;
   while(next != NULL)
        {
        if (next->next != NULL)
           next = next->next;
        else
           {
           next->next = b;
           break;
           }
        }
   return a;
   }

int smtp_online_add_item(smtpp par, char *lcFrom, char *lcTo)
   {
   xmlnode loFrom,loFromOff,loTo;
   smtpi sin=par->sin;
   int liCount=0;

   // record is not exist, create it
   if ((loFrom=xmlnode_get_tag(sin->OnlineList,spools(par->tmppool,"from?jid=",lcFrom,par->tmppool)))==NULL)
      xmlnode_put_attrib(loFrom=xmlnode_insert_tag(sin->OnlineList,"from"),"jid",lcFrom);

   // record is not exist, create it
   if ((loFromOff=xmlnode_get_tag(sin->OfflineList,spools(par->tmppool,"from?jid=",lcFrom,par->tmppool)))==NULL)
      xmlnode_put_attrib(loFromOff=xmlnode_insert_tag(sin->OfflineList,"from"),"jid",lcFrom);


   // check to item
   if (j_strlen(lcTo)>0)
      {
      if ((loTo=xmlnode_get_tag(loFrom,spools(par->tmppool,"to=",lcTo,par->tmppool)))==NULL)
         {
         // record is not exist, create it

         // check if exist subitem in offline list
         if ((loTo=xmlnode_get_tag(loFromOff,spools(par->tmppool,"to=",lcTo,par->tmppool)))==NULL)
            xmlnode_insert_cdata(loTo=xmlnode_insert_tag(loFrom,"to"),lcTo,-1);
         else
            {
            smtp_xmlnode_move_node(loTo, loFromOff, loFrom);
            }

         liCount=1;
         }
      }
   else
      for (loTo = xmlnode_get_tag(loFromOff,"to"); loTo != NULL; loTo = xmlnode_get_tag(loFromOff,"to"))
          {
          if (loTo->type!=NTYPE_TAG)
      	    continue;

          smtp_xmlnode_move_node(loTo, loFromOff, loFrom);
          liCount++;
          }

//   xmlnode2file("./spool/on.xml",sin->OnlineList);
//   xmlnode2file("./spool/off.xml",sin->OfflineList);
   return liCount;
   }

int smtp_online_remove_item(smtpp par, char *lcFrom, char *lcTo)
   {
   xmlnode loFrom,loTo,loFromOff;
   smtpi sin=par->sin;
   int liCount=0;

   if ((loFrom=xmlnode_get_tag(sin->OnlineList,spools(par->tmppool,"from?jid=",lcFrom,par->tmppool)))==NULL)
      {
      return 0;      // record is not exist
      }

   loFromOff=xmlnode_get_tag(sin->OfflineList,spools(par->tmppool,"from?jid=",lcFrom,par->tmppool));

   if (j_strlen(lcTo)>0) // remove sub item
      {
      // check to item
      if ((loTo=xmlnode_get_tag(loFrom,spools(par->tmppool,"to=",lcTo,par->tmppool)))!=NULL)
         {
         liCount=1;
         smtp_xmlnode_move_node(loTo, loFrom, loFromOff);
         }
      }
   else
      {
      // move subitems to offline, walk all item 
      for (loTo = xmlnode_get_tag(loFrom,"to"); loTo != NULL; loTo = xmlnode_get_tag(loFrom,"to"))
          {
          if (loTo->type!=NTYPE_TAG)
      	    continue;

          smtp_xmlnode_move_node(loTo, loFrom, loFromOff);
          liCount++;
          }
      }

//   xmlnode2file("./spool/on.xml",sin->OnlineList);
//   xmlnode2file("./spool/off.xml",sin->OfflineList);

   return liCount;
   }


smtp_jq smtp_NewQueueItem(pool p)
   {
   smtp_jq item;
   item=pmalloco(p, sizeof(_smtp_jq));
   item->next=NULL;
   return item;
   }

smtp_jq smtp_AppendQueueItem(smtp_jq a, smtp_jq b)
   {
   smtp_jq next=a;

   if (a == NULL)
      return NULL;

   if (b == NULL)
      return a;

   while(next != NULL)
        {
        if (next->next != NULL)
           {
           next = next->next;
           }
        else
           {
           next->next = b;
           break;
           }
        }

   return a;
   }

void smtp_FlushQueue(instance i, smtp_jq item)
   {
   smtp_jq next = item;
   while(next != NULL)
        {
        deliver(dpacket_new(xmlnode_dup(next->x)),i);
        xmlnode_free(next->x);
        next = next->next;
        }
   }


void smtp_xmlnode_move_node(xmlnode loNode, xmlnode loParentOld, xmlnode loParentNew)
   {
   xmlnode_hide(loNode);
   loNode->next=loNode->prev=NULL;
 
   if (loParentNew->firstchild==NULL)
      loParentNew->firstchild=loNode;
   else
      {
      loNode->next=loParentNew->firstchild;
      loParentNew->firstchild->prev=loNode;
      loParentNew->firstchild=loNode;
      }

   if (loParentNew->lastchild==NULL)
      loParentNew->lastchild=loNode;

   loNode->parent = loParentNew; // change parent of node
//   xmlnode2file("./spool/test2.xml",loParentNew);

    
   }
