#include "smtp.h"

extern smtpi jtin;


void smtp_offline_mtq(void *arg)
   {
   smtp_tu par_o= (smtp_tu) arg;
   xmlnode loOffline,loMessage;
   char *lcOffline,*lcBFile;
   int lii=0,liMax=0;
   struct dirent   *dirp;
   DIR      *dp;

   smtpp par;
   jpacket jp;
   pool p;
   smtp_SendInfoToAdmin("Offline thread... start" );
   log_notice("smtp","Offline thread... start");

   // check all offline jabber message
   if (jtin->tmpOfflineJabber==1)
      {
      loOffline=xmlnode_get_tag(jtin->config,"jabber/offline");
      if ((lcOffline=xmlnode_get_attrib(loOffline,"folder")   )==NULL)
         lcOffline= pstrdup(par_o->p,SMTP_OFFLINEJABBER_FOLDER);

      if ((dp = opendir(lcOffline)) != NULL)
         {
         while ( (dirp = readdir((DIR *)dp)) != NULL)
               {
               if (strcmp(dirp->d_name, ".") == 0  ||
                   strcmp(dirp->d_name, "..") == 0)
                   continue;      // ignore dot and dot-dot

 
               // load jabber message from file
               // and send it to out_message...
               lcBFile=spools(par_o->p,lcOffline,"/",dirp->d_name,par_o->p);
               if ((loMessage=xmlnode_file(lcBFile))!=NULL)
                  {
                  remove(lcBFile);

                  p=pool_new();   
                  par= smtp_param_i(p,jtin->i);
                  pool_cleanup(par->tmppool, smtp_out_Xcleanup, (void *)par);
                  jp = pmalloc(p,sizeof(_jpacket));

                  jp->x = loMessage;
                  jp=par->jp = jpacket_reset(jp);
                  jpacket_subtype(jp);

                  log_notice("smtp","OFFLINE - message %s loaded and will be resent.",lcBFile);
                  smtp_SendInfoToAdmin(spools(par_o->p, "Offline message ",lcBFile," loaded and will be resent.",par_o->p) );
                  smtp_out_packets_message(par,(char *) NULL);
                  }
               else
                  {
                  log_warn("smtp","OFFLINE - message %s not loaded.",lcBFile);
                  smtp_SendInfoToAdmin(spools(par_o->p, "Offline message ",lcBFile," not loaded.",par_o->p) );
                  }


               lii++;

               liMax++;
               if (liMax>=MAXLOOP)
                   break;
               }
 
         closedir((DIR *)dp);
         }
      }

   if (liMax>=MAXLOOP)
      {
      log_warn("smtp","OFFLINE - Max count of LOOP was exceed.");
      smtp_SendInfoToAdmin("OFFLINE - Max count of LOOP was exceed." );
      }

   smtp_SendInfoToAdmin(spools(par_o->p,"Offline thread... end, files: ",smtp_itoa(lii),".",par_o->p) );
   log_notice("smtp",spools(par_o->p,"Offline thread... end, files: ",smtp_itoa(lii),".",par_o->p));
   pool_free(par_o->p);
   }




// create new thread for sending offline messages
result smtp_offline_daemon(void *arg)
   {
   pool p=pool_new();
   smtp_tu par_o;

   par_o=pmalloco(p, sizeof(_smtp_tu));
   par_o->p=p;
   par_o->index=(int *) arg;

   par_o->q=mtq_new(p);
   mtq_send(par_o->q, p, smtp_offline_mtq, (void *)par_o);
   return r_DONE;
   }
