#include "smtp.h"
extern smtpi jtin;


int smtp_out_packets_iq_register(smtpp par, char *type)
   {
   int liProcess=0;
   jpacket jp=par->jp;
   char *lcJID, *lcLang,*lcName, *lcVal;
   xmlnode loQuery, xData, loField, loOption,loJID,loInstruction;
   smtp_jq loQueue;
   smtp_jq_x loData;
   smtp_jq_cb loDataCB;


   lcLang=par->lang;

   // register service
   if (liProcess==0 && j_strcmp(jp->iqns,NS_REGISTER)==0 && jp->subtype==JPACKET__GET)
      {
      /*
      Nati nastaven uivatele dle JID
      pokud neexistuje, pouij nastaven z konfigu transportu
      */
      lcJID=smtp_GetJID(par->tmppool,xmlnode_get_attrib(jp->x,"from"));
      loJID=smtp_roster_get_item(par->tmppool, lcJID,1);

      loQueue=smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      xmlnode_put_attrib(loData->x,"type","result");

      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",NS_REGISTER);

      if (j_atoi(xmlnode_get_attrib(loJID,"default"),0)==0) // user was registered
         xmlnode_insert_tag(loQuery,"registered");


	  xmlnode_insert_cdata(loInstruction=xmlnode_insert_tag(loQuery,"instruction"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_MAIN_I),-1);
      if (j_atoi(xmlnode_get_attrib(loJID,"paid"),0)==1)
         {
	     xmlnode_insert_cdata(loInstruction,"\r\n",-1);
	     xmlnode_insert_cdata(loInstruction,smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_PAID_LBL),-1);
         }


      xmlnode_put_attrib(xData=xmlnode_insert_tag(loQuery,"x"),"xmlns",NS_DATA);
	  xmlnode_insert_cdata(xmlnode_insert_tag(xData,"title"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_TITLE),-1);
	  xmlnode_insert_cdata(xmlnode_insert_tag(xData,"instructions"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_DATA_I),-1);



      if (j_atoi(xmlnode_get_attrib(loJID,"default"),0)==0)
         {
         xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","hidden");
         xmlnode_put_attrib(loField,"var","FORM_TYPE");
         xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),NS_REGISTER,-1);
         }

         //      Nati nastaven dle JID

	  // global settings
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","boolean");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_USEGLOBALSETTINGS_LBL));
	  xmlnode_put_attrib(loField,"var","UseGlobalSettings");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"UseGlobalSettings"),-1);
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_USEGLOBALSETTINGS_DSC),-1);


      // jabber to smtp
      //********************
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value")," ",-1);
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_J2SHEAD),-1);

	  // own  setting - jabber to mime
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","boolean");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_PGPJABBERTOMIME_LBL));
	  xmlnode_put_attrib(loField,"var","PGPJabberToMIME");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"PGPJabberToMIME"),-1);
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_PGPJABBERTOMIME_DSC),-1);


	  // own  setting - subject replace
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value")," ",-1);

	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_SR_HEAD),-1);

      // mode
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","list-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_SR_MODE_LBL));
	  xmlnode_put_attrib(loField,"var","J2S_SRMode");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_SRMode"),-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL0_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"0",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL1_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"1",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL2_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"2",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL3_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"3",-1);

      // separator
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_SR_SEPARATOR_LBL));
	  xmlnode_put_attrib(loField,"var","J2S_SRSeparator");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_SRSeparator"),-1);

      // text
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_SR_TEXT_LBL));
	  xmlnode_put_attrib(loField,"var","J2S_SRText");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_SRText"),-1);

	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_SR_DSC),-1);

      // reply-to adrress (mode, name, addr)
      // mode
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value")," ",-1);

	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","list-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_RT_MODE_LBL));
	  xmlnode_put_attrib(loField,"var","J2S_RTMode");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_RTMode"),-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_RT_MODE_VAL0_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"0",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_RT_MODE_VAL1_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"1",-1);

      // name
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_RT_NAME_LBL));
	  xmlnode_put_attrib(loField,"var","J2S_RTName");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_RTName"),-1);

      // addr
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_RT_ADDR_LBL));
	  xmlnode_put_attrib(loField,"var","J2S_RTAddr");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"J2S_RTAddr"),-1);

	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_RT_DSC),-1);



      // smtp to jabber
      //********************
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value")," ",-1);
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_S2JHEAD),-1);

      // own  setting - attachments
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","list-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_ATTACHMENTS_LBL));
	  xmlnode_put_attrib(loField,"var","Attachments");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"Attachments"),-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_ATTACHMENTS_VAL1_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"1",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_ATTACHMENTS_VAL0_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"0",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_ATTACHMENTS_VAL2_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"2",-1);
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_ATTACHMENTS_DSC),-1);

	  // own  setting - to jabber non mime to x
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","boolean");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_PGPTOJABBERNONMIMETOX_LBL));
	  xmlnode_put_attrib(loField,"var","PGPToJabbernonMIMETox");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"PGPToJabbernonMIMETox"),-1);
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_PGPTOJABBERNONMIMETOX_DSC),-1);


	  // own  setting - all messages are spam
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","boolean");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_ALLMESSAGESARESPAM_LBL));
	  xmlnode_put_attrib(loField,"var","S2J_AllAreSPAM");
      lcVal=xmlnode_get_attrib(loJID,"S2J_AllAreSPAM");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),(j_strlen(lcVal)==0?"0":lcVal),-1);
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_ALLMESSAGESARESPAM_DSC),-1);


	  // own  setting - subject replace
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value")," ",-1);

	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_SR_HEAD),-1);

      // mode
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","list-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_SR_MODE_LBL));
	  xmlnode_put_attrib(loField,"var","S2J_SRMode");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"S2J_SRMode"),-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL0_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"0",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL1_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"1",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL2_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"2",-1);
	  xmlnode_put_attrib(loOption=xmlnode_insert_tag(loField,"option"),"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_SR_MODE_VAL3_LBL));
	  xmlnode_insert_cdata(xmlnode_insert_tag(loOption,"value"),"3",-1);

      // separator
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_SR_SEPARATOR_LBL));
	  xmlnode_put_attrib(loField,"var","S2J_SRSeparator");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"S2J_SRSeparator"),-1);

      // text
	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","text-single");
	  xmlnode_put_attrib(loField,"label",smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_SR_TEXT_LBL));
	  xmlnode_put_attrib(loField,"var","S2J_SRText");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),xmlnode_get_attrib(loJID,"S2J_SRText"),-1);

	  xmlnode_put_attrib(loField=xmlnode_insert_tag(xData,"field"),"type","fixed");
	  xmlnode_insert_cdata(xmlnode_insert_tag(loField,"value"),smtp_rc_GetString(par->tmppool,lcLang,SMTP_RC_REGISTER_SR_DSC),-1);

      liProcess=1;
      }

   // unregister service
   if (liProcess==0 && j_strcmp(jp->iqns,NS_REGISTER)==0 && jp->subtype==JPACKET__SET &&
       xmlnode_get_tag(jp->x,"query/remove")!=NULL)
      {
      // test if submit or cancel
      jtin->CoreAccounts--;
      smtp_StatsDec("CoreAccounts");
      lcJID=smtp_GetJID(par->tmppool,xmlnode_get_attrib(jp->x,"from"));
      smtp_roster_remove_item(par->tmppool, lcJID);
      liProcess=-1;
      }

   
   // register service - proccess data (submit)
   if (liProcess==0 && j_strcmp(jp->iqns,NS_REGISTER)==0 && jp->subtype==JPACKET__SET &&
       (xData=xmlnode_get_tag(jp->x,"query/x?type=submit"))!=NULL)
      {
      // test if submit or cancel

      lcJID=smtp_GetJID(par->tmppool,xmlnode_get_attrib(jp->x,"from"));
      loJID=smtp_roster_get_item(par->tmppool, lcJID,1);

      for (loField = xmlnode_get_firstchild(xData); loField != NULL; loField = xmlnode_get_nextsibling(loField))
          {
          if (loField->type!=NTYPE_TAG)
      	    continue;

          lcName=xmlnode_get_attrib(loField,"var");
          if (j_strcmp(lcName,"UseGlobalSettings")==0 ||
              j_strcmp(lcName,"Attachments")==0 ||
              j_strcmp(lcName,"PGPJabberToMIME")==0 ||
              j_strcmp(lcName,"PGPToJabbernonMIMETox")==0 ||
              j_strcmp(lcName,"J2S_SRMode")==0 ||
              j_strcmp(lcName,"J2S_SRSeparator")==0 ||
              j_strcmp(lcName,"J2S_SRText")==0 ||
              j_strcmp(lcName,"S2J_SRMode")==0 ||
              j_strcmp(lcName,"S2J_SRSeparator")==0 ||
              j_strcmp(lcName,"S2J_SRText")==0 ||
              j_strcmp(lcName,"J2S_RTMode")==0 ||
              j_strcmp(lcName,"J2S_RTName")==0 ||
              j_strcmp(lcName,"J2S_RTAddr")==0 ||
              j_strcmp(lcName,"S2J_AllAreSPAM")==0
             )

             lcVal=xmlnode_get_tag_data(loField,"value");
             if ((j_strcmp(lcName,"J2S_RTAddr")==0 ||
                  j_strcmp(lcName,"J2S_SRSeparator")==0 ||
                  j_strcmp(lcName,"J2S_SRText")==0 ||
                  j_strcmp(lcName,"J2S_RTName")==0 ||
                  j_strcmp(lcName,"J2S_RTAddr")==0 ||
                  j_strcmp(lcName,"S2J_SRSeparator")==0 ||
                  j_strcmp(lcName,"S2J_SRText")==0) && j_strlen(lcVal)==0
                 )
                xmlnode_put_attrib(loJID,lcName,pstrdup(xmlnode_pool(loField)," "));
             else
                xmlnode_put_attrib(loJID,lcName,xmlnode_get_tag_data(loField,"value"));
	         }

      loQueue=smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;

      if (j_atoi(xmlnode_get_attrib(loJID,"default"),0)==1) // user was not registered
         {
         jtin->CoreAccounts++;
         smtp_StatsInc("CoreAccounts");

         smtp_AppendQueueItem(loQueue, smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_X));
         loData=(smtp_jq_x) loQueue->next->Data;
         loData->x=out_SetReply(xmlnode_new_tag("presence"),jp->x);
         xmlnode_put_attrib(loData->x,"type","subscribe");

         smtp_AppendQueueItem(loQueue, smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_CB));
         loDataCB=(smtp_jq_cb) loQueue->next->next->Data;
         loDataCB->cb=(void*) smtp_paid_daemon;
         loDataCB->arg=(void *)jtin;
         log_debug(ZONE,"Call calback procedure %i, %i",loDataCB->cb,loDataCB->arg);
         }

      smtp_roster_set_item(par->tmppool, lcJID,loJID);

      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      xmlnode_put_attrib(loData->x,"type","result");
      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",NS_REGISTER);

	  liProcess=1;
      }

   // register service - proccess data (cancel)
   if (liProcess==0 && j_strcmp(jp->iqns,NS_REGISTER)==0 && jp->subtype==JPACKET__SET &&
       (xData=xmlnode_get_tag(jp->x,"query/x?type=cancel"))!=NULL)
      {
      loQueue=smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      xmlnode_put_attrib(loData->x,"type","result");
      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns",NS_REGISTER);
	  liProcess=1;
      }


   if (liProcess==1)
      smtp_FlushQueue(par->i, loQueue);


   return liProcess;
   }

