#include "smtp.h"
extern smtpi jtin;


void smtp_statistics_write(xmlnode loQuery,const char *lcTagName, const char *lcUnitName, const char *lcValue)
   {
   xmlnode loStatN;
   xmlnode_put_attrib(loStatN=xmlnode_insert_tag(loQuery,"stat"),"name",lcTagName);
   xmlnode_put_attrib(loStatN,"units",lcUnitName);
   xmlnode_put_attrib(loStatN,"value",lcValue); 
   }

int smtp_out_packets_iq_stats(smtpp par, char *type)
   {
   int liProcess=0;
   jpacket jp=par->jp;
   char lcPom[27];
   char *lcName;
   xmlnode loQuery, loStat;
   smtp_jq loQueue;
   smtp_jq_x loData;

   if (liProcess==0 && j_strcmp(jp->iqns,"http://jabber.org/protocol/stats")==0 &&
       jp->subtype==JPACKET__GET && jp->to->user==NULL)
      {
      loQueue=smtp_NewQueueItem(par->tmppool,SMTP_QUEUE_X);
      loData=(smtp_jq_x) loQueue->Data;
      loData->x=out_SetReply(xmlnode_new_tag("iq"),jp->x);
      xmlnode_put_attrib(loData->x,"type","result");

      xmlnode_put_attrib(loQuery=xmlnode_insert_tag(loData->x,"query"),"xmlns","http://jabber.org/protocol/stats");

      if ((loStat=xmlnode_get_firstchild(jp->iq)))
         {


         // read all childs elements
         for (;loStat != NULL; loStat = xmlnode_get_nextsibling(loStat))
             {
	         if (loStat->type!=NTYPE_TAG)
		        continue;

             // main section
             lcName=xmlnode_get_attrib(loStat,"name");
             if (j_strcmp(lcName,"start")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(jtin->statistics,"Start"));
				continue;
                }

             if (j_strcmp(lcName,"start/lastdatetime")==0)
                {
                smtp_statistics_write(loQuery,lcName, "date",xmlnode_get_attrib(jtin->statistics,"StartLastDatetime"));
				continue;
                }


             if (j_strcmp(lcName,"contacts")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(jtin->statistics,"CoreContacts"));
				continue;
                }

            if (j_strcmp(lcName,"contacts/online")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(jtin->statistics,"CoreContactsOnline"));
				continue;
                }

             if (j_strcmp(lcName,"contacts/elapsed")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",jtin->CoreContacts);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }

             if (j_strcmp(lcName,"contacts/elapsed/online")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",jtin->CoreContactsOnline);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }

             if (j_strcmp(lcName,"accounts")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(jtin->statistics,"CoreAccounts"));
				continue;
                }

            if (j_strcmp(lcName,"accounts/elapsed")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",jtin->CoreAccounts);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }


             // jabber side
             if (j_strcmp(lcName,"jabber/status")==0)
                {
                smtp_statistics_write(loQuery,lcName, "text",jtin->cJabber_Status);
				continue;
                }

             if (j_strcmp(lcName,"jabber/messages")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(jtin->statistics,"JabberMessages"));
				continue;
                }

			 if (j_strcmp(lcName,"jabber/messages/out")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(jtin->statistics,"JabberMessagesOut"));
                continue;
                }

             if (j_strcmp(lcName,"jabber/messages/out/error")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(jtin->statistics,"JabberMessagesOutError"));
				continue;
                }

             if (j_strcmp(lcName,"jabber/elapsed/messages")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",jtin->JabberMessages);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }

             if (j_strcmp(lcName,"jabber/elapsed/messages/out")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",jtin->JabberMessagesOut);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }


             if (j_strcmp(lcName,"jabber/elapsed/messages/out/error")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",jtin->JabberMessagesOutError);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }

             // SMTP side
             if (j_strcmp(lcName,"smtp/status")==0)
                {
                smtp_statistics_write(loQuery,lcName, "text",jtin->cSMTP_Status);
				continue;
                }

		     if (j_strcmp(lcName,"smtp/command/unknown")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(jtin->statistics,"SMTPCommandUnknown"));
				continue;
                }

             if (j_strcmp(lcName,"smtp/elapsed/command/unknown")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",jtin->SMTPCommandUnknown);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }

             if (j_strcmp(lcName,"smtp/messages")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(jtin->statistics,"SMTPMessages"));
				continue;
				}


             if (j_strcmp(lcName,"smtp/messages/in")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(jtin->statistics,"SMTPMessagesIn"));
				continue;
                }

		     if (j_strcmp(lcName,"smtp/messages/in/error")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(jtin->statistics,"SMTPMessagesInError"));
				continue;
                }
             if (j_strcmp(lcName,"smtp/elapsed/messages")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",jtin->SMTPMessages);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }

             if (j_strcmp(lcName,"smtp/elapsed/messages/in")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",jtin->SMTPMessagesIn);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }

            if (j_strcmp(lcName,"smtp/elapsed/messages/in/error")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",jtin->SMTPMessagesInError);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }

		     if (j_strcmp(lcName,"smtp/spam")==0)
                {
                smtp_statistics_write(loQuery,lcName, "count",xmlnode_get_attrib(jtin->statistics,"SMTPSpam"));
				continue;
                }

             if (j_strcmp(lcName,"smtp/elapsed/spam")==0)
                {
                snprintf(lcPom, sizeof(lcPom), "%i\0",jtin->SMTPSpam);
                smtp_statistics_write(loQuery,lcName, "count",lcPom);
				continue;
                }



             }

         }
      else
         {
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","start");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","start/lastdatetime");

         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","contacts");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","contacts/online");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","contacts/elapsed");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","contacts/elapsed/online");

         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","accounts");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","accounts/elapsed");

         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/status");

         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/messages");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/messages/out");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/messages/out/error");

         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/elapsed/messages");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/elapsed/messages/out");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","jabber/elapsed/messages/out/error");

		 xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/status");
		 xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/command/unknown");
		 xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/command/unknown");

         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/messages");
		 xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/messages/in");
		 xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/messages/in/error");

         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/messages");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/messages/in");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/messages/in/error");
		 
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/spam");
         xmlnode_put_attrib(xmlnode_insert_tag(loQuery,"stat"),"name","smtp/elapsed/spam");
		 }

      liProcess=1;
      }


   if (liProcess==1)
      smtp_FlushQueue(par->i, loQueue);


   return liProcess;
   }
