#include "smtp.h"

/* jabber->smtp */

char getx[3]="ddd";
extern smtpi jtin;

/* send an outgoing line to the connection */
void smtp_cmd(smtps so, int liCmd, char *arg)
   {
   char *lcOut;
   pool p;
   spool lspLine;

   p = pool_new();
   lspLine = spool_new(p);

   switch(liCmd)
      {
      case CMD_HELO:
           spool_add(lspLine,"HELO ");
           break;

      case CMD_EHLO:
           spool_add(lspLine,"EHLO ");
           break;

      case CMD_MAIL:
           spool_add(lspLine,"MAIL FROM: ");
           break;

      case CMD_RCPT:
           spool_add(lspLine,"RCPT TO: ");
           break;

      case CMD_DATA:
           spool_add(lspLine,"DATA");
           break;

      case CMD_QUIT:
           spool_add(lspLine,"QUIT");
           break;
      }

   if (arg != NULL)
      {
      if (liCmd == CMD_HELO || liCmd == CMD_EHLO)
         spool_add(lspLine,arg);
      else
         spooler(lspLine,"<",arg,">",lspLine);
      }

   spool_add(lspLine,"\r\n");
   lcOut = spool_print(lspLine);
   so->lastcmd = liCmd;
   #ifdef SMTP_DB
    log_debug(ZONE,"SMTP-SEND %s",lcOut);
   #else
    log_debug(ZONE,"SMTP-SEND");
   #endif

   mio_write(so->m,NULL,lcOut,-1);

   pool_free(p);
   }

/* decode the incoming commands */
void smtp_out_status(smtps so,char *lcData)
   {
   char *lineEnd, *lcBody,*lcBFile, *lcSubj, *lcPom;
   xmlnode x,loStatus,xError,loSubj,loText;
   jid cur;
   int liStatus=so->iStatus,liSaved=0,liLen;

   #ifdef SMTP_DB
    log_debug(ZONE,"status %d response to command %d with data %s",liStatus,so->lastcmd,lcData);
   #else
    log_debug(ZONE,"status %d response to command %d",liStatus,so->lastcmd);
   #endif

   switch(so->lastcmd)
      {

      case CMD_NONE:
           if (liStatus != SMTP_CODE_220)
              break;
 
           smtp_cmd(so, CMD_HELO, jtin->me);
           return;

      case CMD_HELO:
           if (liStatus != SMTP_CODE_250)
              break;

           smtp_cmd(so, CMD_MAIL, so->from);
           return;

      case CMD_EHLO:
           if (liStatus != SMTP_CODE_250)
              break;

           smtp_cmd(so, CMD_MAIL, so->from);
           return;


      case CMD_MAIL:
           if (liStatus != SMTP_CODE_250)
              break;

		   snprintf(jtin->cJabber_Status, 20, "Check recipients\0");

           for (cur = so->rcpt; cur != NULL; cur = cur->next)
               smtp_cmd(so, CMD_RCPT, jid_full(cur));

           return;

      case CMD_RCPT:
           so->ircpt--;

           if (!(liStatus == SMTP_CODE_250 || liStatus == SMTP_CODE_251))
              break;

           if (so->ircpt==0)
              smtp_cmd(so, CMD_DATA, NULL);

           return;

      case CMD_RCPTE:
           if (!(liStatus == SMTP_CODE_250 || liStatus == SMTP_CODE_251))
              break;

           smtp_cmd(so, CMD_DATA, NULL);
           return;

      case CMD_DATA:
		   snprintf(jtin->cJabber_Status, 20, "Send data\0");
           lcBody = xmlnode_get_data(so->x);

           if (liStatus != SMTP_CODE_354 || lcBody == NULL)
              break;


           snprintf(jtin->cJabber_Status, 20, "Sending data...\0");
           for (x = xmlnode_get_firstattrib(so->x); x != NULL; x = xmlnode_get_nextsibling(x))
               {
               mio_write(so->m,NULL,xmlnode_get_name(x),-1);
               mio_write(so->m,NULL,": ",2);
               mio_write(so->m,NULL,xmlnode_get_data(x),-1);
               mio_write(so->m,NULL,"\r\n",2);
               }
           mio_write(so->m,NULL,"\r\n",2);


           while((lineEnd = strchr(lcBody,'\n')) != NULL)
      	      {
       		  lineEnd[0] = '\0';	/* cut the line */

             // S:2005-04-03 gorila@dione.zcu.cz
//		     while((crpointer = strchr(body, '\r')) != NULL)
//             crpointer[0] = ' ';
             // E:2005-04-03 gorila@dione.zcu.cz

 		      if (lcBody[0]=='.')
		         mio_write(so->m,NULL,".",1); /* escape the dot */

              // S:2005-04-03 gorila@dione.zcu.cz
              // xmlnode2str() return original XML data (without any changes)
              // xmlnode_get_tag_data() return data where CRLF and CR are replaced by LF
              // _mio_write_dump() hate data with length = 0
              // I added this exception
	  	      if (j_strlen(lcBody)>0)
                 mio_write(so->m,NULL,lcBody,-1);
              // E:2005-04-03 gorila@dione.zcu.cz

		      mio_write(so->m,NULL,"\r\n",2);
		      lcBody = lineEnd+1;	/* point to next line */
	          }


	       if (lcBody[0])
		      mio_write(so->m,NULL,lcBody,-1); /* print the rest */


           so->lastcmd = CMD_DATAEND; /* so we know where we are */

           mio_write(so->m,NULL,"\r\n.\r\n",5);
           return;

      case CMD_DATAEND:
           if (!(liStatus == SMTP_CODE_250 || liStatus == SMTP_CODE_221))
              break;

           jtin->JabberMessagesOut++;
           smtp_StatsInc( "JabberMessagesOut");

           smtp_cmd(so, CMD_QUIT, NULL);

		   // Odeslan prezence o odesln mailu
           x= out_SetReply(xmlnode_new_tag("presence"),so->jp->x);
           xmlnode_insert_cdata(xmlnode_insert_tag(x,"show"),"online",-1);
           xmlnode_insert_cdata(loStatus=xmlnode_insert_tag(x,"status"),smtp_rc_GetString(so->p,so->lang,SMTP_XXX_MESSAGE_SENT),-1);
           xmlnode_insert_cdata(loStatus,"\r\n",-1);
           xmlnode_insert_cdata(loStatus,xmlnode_get_data(xmlnode_get_tag(so->jp->x,"body")),-1);
           deliver(dpacket_new(xmlnode_dup(x)),so->i);
           xmlnode_free(x);
		   return;

      case CMD_QUIT:
           if (!(liStatus == SMTP_CODE_250 || liStatus == SMTP_CODE_221))
              break;

           snprintf(jtin->cJabber_Status, 20, " ");
           return;

      default:
           #ifdef SMTP_DB
            log_debug(ZONE,"SMTP relay connection not processed %d %d: %s",so->lastcmd,liStatus,lcData);
           #else
            log_debug(ZONE,"SMTP relay connection not processed %d %d:",so->lastcmd,liStatus);
           #endif
      }

   #ifdef SMTP_DB
    log_debug(ZONE,"SMTP relay connection failed %d %d: %s",so->lastcmd,liStatus,lcData);
    log_warn("smtp","SMTP relay connection failed %d %d: %s",so->lastcmd,liStatus,lcData);
   #else
    log_debug(ZONE,"SMTP relay connection failed %d %d",so->lastcmd,liStatus);
    log_warn("smtp","SMTP relay connection failed %d %d",so->lastcmd,liStatus);
   #endif
   jtin->JabberMessagesOutError++;
   smtp_StatsInc("JabberMessagesOutError");


   if (so->lastcmd==CMD_RCPT || so->lastcmd==CMD_RCPTE)
      {
      // unknown recipient - must be message
      x= out_SetReply(xmlnode_dup_pool(so->p,so->jp->x),so->jp->x);

      xmlnode_put_attrib(x,"type","error");
      xmlnode_put_attrib(xError=xmlnode_insert_tag(x,"error"),"code","404");
      xmlnode_put_attrib(xError,"type","wait");
      xmlnode_put_attrib(xmlnode_insert_tag(xError,"recipient-unavailable"),"xmlns","urn:ietf:params:xml:ns:xmpp-stanzas");
      xmlnode_put_attrib(loText=xmlnode_insert_tag(xError,"text"),"xmlns","urn:ietf:params:xml:ns:xmpp-stanzas");
      xmlnode_insert_cdata(loText,lcData,-1);

      smtp_SendInfoToAdmin(lcData );


//      xmlnode_insert_cdata(xError,lcData,-1);
/*
 <error code='404' type='wait'> 
    <recipient-unavailable xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/>

<text xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'>
    OPTIONAL descriptive text
  </text>

  </error>
*/


      if ((loSubj=xmlnode_get_tag(x,"subject"))!=NULL)
         {
         lcSubj=xmlnode_get_data(loSubj);
         xmlnode_hide(loSubj);
         }
      liLen=j_strlen(lcSubj)>0;

      lcPom=smtp_rc_GetString(so->p,so->lang,SMTP_XXX_RCPT_NOTFOUND);

      loSubj=xmlnode_insert_tag(x,"subject");
      if (liLen==0 || strstr(lcSubj,lcPom)==NULL)
         {
         xmlnode_insert_cdata(loSubj,lcPom,-1);
         if (liLen>0)
            xmlnode_insert_cdata(loSubj,"  ",-1);
         }

      if (liLen>0)
         xmlnode_insert_cdata(loSubj,lcSubj,-1);


      deliver(dpacket_new(xmlnode_dup(x)),so->i);
      }
   else
      {
      snprintf(jtin->cJabber_Status, 20, "SMTP rel. con. fail\0");

      // save message to offline folder
      if (jtin->tmpOfflineJabber==1)
         {
         lcBFile = (char*)pmalloco(so->p, 254);
         lcBFile=spools(so->p, tempnam(xmlnode_get_attrib(xmlnode_get_tag(jtin->config,"jabber/offline"),"folder"), "tmp"),".xml",so->p);
         if ((liSaved=xmlnode2file(lcBFile  ,so->jp->x))!=1)
            {
            smtp_SendInfoToAdmin(spools(so->p,"Save message to offline repository ",lcBFile," failed.",so->p) );
            log_warn("smtp","Cannot save message to %s",lcBFile);
            }
         else
            smtp_SendInfoToAdmin(spools(so->p,"Save message to offline repository ",lcBFile,".",so->p) );

         }


      if (liSaved==1)
         lcPom=smtp_rc_GetString(so->p,so->lang,SMTP_XXX_SMTP_UNKNOWN_1);
      else
         lcPom=smtp_rc_GetString(so->p,so->lang,SMTP_XXX_SMTP_UNKNOWN_0);


      smtp_SendInfoToAdmin(spools(so->p,lcPom,"\r\n",lcData,so->p) );

      // other errors - can be presence
      x= out_SetReply(xmlnode_new_tag("presence"),so->jp->x);
      xmlnode_insert_cdata(xmlnode_insert_tag(x,"show"),"away",-1);
      xmlnode_insert_cdata(loStatus=xmlnode_insert_tag(x,"status"),lcPom,-1);

      xmlnode_insert_cdata(loStatus,"\r\n",-1);
      xmlnode_insert_cdata(loStatus,xmlnode_get_data(xmlnode_get_tag(so->jp->x,"body")),-1);
      deliver(dpacket_new(xmlnode_dup(x)),so->i);
      xmlnode_free(x);
      }


   // if this error, end session with SMTP server
   if (so->lastcmd != CMD_QUIT)
      smtp_cmd(so, CMD_QUIT, NULL);
   }

/* when the connection dies, clean up the mess */
void smtp_out_cleanup(void *arg)
   {
   smtps so = (smtps)(arg);

   log_debug(ZONE,"smtp_out_cleanup");
   if (so != NULL)
      {
      so->oJID=so->oAD=NULL;
      free(so->buffer);
      }
   }


void smtp_out_add_recipient_to_lis(spool list, char *lcOrig, char *lcRCPT, char *lcLabel, int *liCount)
   {
   int liOrig=j_strlen(lcOrig),liLabel=j_strlen(lcLabel);

   if (*liCount==0 && liLabel==liOrig)
      spooler(list,"<",lcRCPT,">",list);

   if (*liCount==0 && liLabel>liOrig)
      spooler(list,"\"=?utf-8?q?",lcLabel,"?=\" ","<",lcRCPT,">",list);

   if (*liCount>0 && liLabel==liOrig)
      spooler(list,"\r\n ,","<",lcRCPT,">",list);

   if (*liCount>0 && liLabel>liOrig)
      spooler(list,"\r\n ,\"=?utf-8?q?",lcLabel,"?=\" ","<",lcRCPT,">",list);

   *liCount=*liCount+1;
   }


smtps smtp_out_new(mio m, smtps so)
   {
   jid ljidFrom;
   char *to, *host, *subject, *id, *tocc, *lcCB, *tmp, *lcJID, *lcRTName, *lcRTAddr, *lcPaid, *lcFrom,*lcPom;
   time_t now_unixtime;
   struct tm now;
   jpacket jp=so->jp;
   char dateheader[27], smtpboundary[30], smtpCT[140];
   xmlnode html,meta,thread,tagx,tagxchild, loHTML=NULL, loBody=NULL, loEncrypted=NULL,loPGP=NULL,loCB=NULL,loSubj=NULL, loSigned=NULL;
   spool datato,datacc,databcc;
   int liLen,liPGP=0,liMode,lidatato=0,lidatacc=0,lidatabcc=0,lii;
;

   snprintf(jtin->cJabber_Status, 20, "Generate e-mail\0");

/*
   log_debug(ZONE,"xxxxxxxxxxxxxxx      -        xxxxxxxxxxxxxxxxxxxxxxxxxxx\r\nspool new\r\n");
   gets((char *)getx);

*/

   /* translate the jabber address to a sutiable SMTP sender */
   ljidFrom = smtp_2mx(jp->from);

   /* translate the recipient into a SMTP address */
   to = pstrdup(jp->p,jp->to->user);
   host = strstr(to,"%");
   *host = '@';
   ++host;

   log_debug(ZONE,"yay, sending a message from %s to %s",jid_full(ljidFrom),to);
   so->phase = PHASE_SEND;
   so->host = mio_ip(m);

   so->ircpt = 0;

   lcFrom=jid_full(ljidFrom);
   tmp = (char*)pmalloco(so->p, j_strlen(lcFrom)*3+(j_strlen(lcFrom)*3/20)+1);
   toEscape(lcFrom, (void *) tmp,"()<>,;:\"/[]?");

   so->from=spools(so->p,"<",tmp,">",so->p);
   lcFrom=tmp;

   /* create xml for outgoing message */
   so->x = xmlnode_new_tag_pool(so->p,"mail");

   datato = spool_new(so->p);
   datacc = spool_new(so->p);
   databcc = spool_new(so->p);

/*
   log_debug(ZONE,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\r\nspool new\r\n");
   gets((char *) &smtpCT);
*/
   xmlnode_put_attrib(so->x,"From",so->from);

   // to,cc, bcc elements
   if ((tagx=xmlnode_get_tag(jp->x,"addresses?xmlns=http://jabber.org/protocol/address"))) 
      {
      log_debug(ZONE,"JEP-0033\r\n");

       // read all childs elements from x element
      for (tagxchild = xmlnode_get_firstchild(tagx); tagxchild != NULL; tagxchild = xmlnode_get_nextsibling(tagxchild))
          {
	      if (tagxchild->type!=NTYPE_TAG)
		     continue;

   
          tocc=lcPom=smtp_GetSMTPAddress(xmlnode_get_attrib(tagxchild,"jid"));
          lii=j_strlen(tocc);
          tmp = (char*)pmalloco(so->p, lii*3+(lii*3/20)+1);
          toEscape(tocc, (void *) tmp,"()<>,;:\"/[]?");

          if (j_strlen(tmp)>lii)
             {
             lcPom = (char*)pmalloc_x(so->p, lii*3+(lii*3/20)+1,' ');
             toQP(tocc, (void *) lcPom,0,"()<>,@;:\"/[]?.");
             }

          so->rcpt = jid_append(so->rcpt,jid_new(so->p,tmp));
          so->ircpt++;

          // is it to element?
          if (j_strcmp(xmlnode_get_attrib(tagxchild,"type"),"to")==0)
             smtp_out_add_recipient_to_lis(datato,tocc, tmp, lcPom, &lidatato);

          // is it cc element?
          if (j_strcmp(xmlnode_get_attrib(tagxchild,"type"),"cc")==0)
             smtp_out_add_recipient_to_lis(datacc,tocc, tmp, lcPom, &lidatacc);

          // is it bcc element?
          if (j_strcmp(xmlnode_get_attrib(tagxchild,"type"),"bcc")==0)
             smtp_out_add_recipient_to_lis(databcc,tocc, tmp, lcPom, &lidatabcc);

          }
      }
   else
      {
      lii=j_strlen(to);

      tmp = (char*)pmalloco(so->p, lii*3+(lii*3/20)+1);
      toEscape(to, (void *) tmp,"()<>,;:\"/[]?");
      if (j_strlen(tmp)>lii)
         {
         lcPom = (char*)pmalloc_x(so->p, lii*3+(lii*3/20)+1,' ');
         toQP(to, (void *) lcPom,0,"()<>,@;:\"/[]?.");

         spooler(datato,"\"=?utf-8?q?",lcPom,"?=\" ","<",tmp,">",datato); // simple recipient
         }
      else
         spooler(datato,"<",tmp,">",datato); // simple recipient

      so->rcpt = jid_new(so->p,to);
      so->ircpt++;
      }



   if (datato->len>0)
      xmlnode_put_attrib(so->x,"to",spool_print(datato));

   if (datacc->len>0)
      xmlnode_put_attrib(so->x,"cc",spool_print(datacc));

   if (databcc->len>0)
      xmlnode_put_attrib(so->x,"bcc",spool_print(databcc));


   // napl informace o uivateli
   lcJID = smtp_GetJID(so->p,xmlnode_get_attrib(jp->x,"from"));

   loSubj=xmlnode_get_tag(jtin->config,"jabber/subject");
   loPGP=xmlnode_get_tag(jtin->config,"jabber/pgp");

   so->oJID=smtp_roster_get_item(so->p, lcJID,0);
   so->oAD=xmlnode_get_tag(jtin->config,"jabber/ad");

   so->Advertising=0;
   if (so->oAD!=NULL && j_atoi(xmlnode_get_attrib(so->oAD,"enabled"),0)==1)
      {
      lcPaid=xmlnode_get_tag_data(jtin->config,"core/paid");
   
      if ((so->oJID==NULL || (lcPaid!=NULL && system(spools(so->p,lcPaid," ",lcJID,so->p)) == 0) ) ||
          (so->oJID!=NULL && j_atoi(xmlnode_get_attrib(so->oJID,"paid"),0)==0) )
         so->Advertising=1;
      }


   if (loPGP!=NULL)
      so->toPGPMIME=j_atoi(xmlnode_get_attrib(loPGP,"mime"),1);

   if (so->oJID!=NULL && j_atoi(xmlnode_get_attrib(so->oJID,"UseGlobalSettings"),1)==0)
      so->toPGPMIME=j_atoi(xmlnode_get_attrib(so->oJID,"PGPJabberToMIME"),1);


   if (loSubj!=NULL)
      {
      so->SRMode=j_atoi(xmlnode_get_attrib(loSubj,"replace"),2);
      so->SRSeparator=pstrdup(so->p,xmlnode_get_attrib(loSubj,"separator"));
      so->SRText=pstrdup(so->p,xmlnode_get_data(loSubj));
      }

   if (so->oJID!=NULL && j_atoi(xmlnode_get_attrib(so->oJID,"UseGlobalSettings"),1)==0)
      {
      so->SRMode=j_atoi(xmlnode_get_attrib(so->oJID,"J2S_SRMode"),2);
      so->SRSeparator=pstrdup(so->p,xmlnode_get_attrib(so->oJID,"J2S_SRSeparator"));
      so->SRText=pstrdup(so->p,xmlnode_get_attrib(so->oJID,"J2S_SRText"));
      }

   // subject
   subject = pstrdup(so->p,smtp_alltrim(xmlnode_get_tag_data(jp->x,"subject")));
   if (loSubj && so->SRMode!=0)
      {
      if (j_strlen(subject)==0 && so->SRMode==3) // if empty and replace is 3
         subject=spools(so->p,so->SRText,so->p);

      if (j_strlen(subject)>0 && so->SRMode==1) // if not empty and replace is 1
         subject=spools(so->p,so->SRText," ",so->SRSeparator," ",subject,so->p);

      if (j_strlen(subject)>0 && so->SRMode==2) // if not empty and replace is 2
         subject=spools(so->p,subject," ",so->SRSeparator," ",so->SRText,so->p);

      }


   if (j_strlen(subject)==0)
      subject=smtp_rc_GetString(so->p,so->lang,SMTP_XXX_NOSUBJECT);


   if ((liLen=j_strlen(subject))>0)
      {
      tmp = (char*)pmalloc_x(so->p, liLen*3+(liLen*3/20)+1,' ');
      toQP(subject, (void *) tmp,0,"()<>@,;:\"/[]?.");
      xmlnode_put_attrib(so->x,"Subject",spools(so->p,"=?utf-8?q?",tmp,"?=",so->p));
      }

   // reply-to
   if (jp->subtype!=JPACKET__CHAT &&
       so->oJID!=NULL && j_atoi(xmlnode_get_attrib(so->oJID,"UseGlobalSettings"),1)==0 &&
       j_atoi(xmlnode_get_attrib(so->oJID,"J2S_RTMode"),0)==1
       )
      {

      lcRTName=smtp_alltrim(xmlnode_get_attrib(so->oJID,"J2S_RTName"));
      if ( (lcRTAddr=smtp_alltrim(xmlnode_get_attrib(so->oJID,"J2S_RTAddr")))!=NULL)
         {
         if (j_strlen(lcRTName)>0)
            {
            tmp = (char*)pmalloco(so->p, j_strlen(lcRTName)*3+(j_strlen(lcRTName)*3/20)+1);
            toQP(lcRTName, (void *) tmp,0,"()<>@,;:\"/[]?.");
            lcRTName=spools(so->p,"=?utf-8?q?",tmp,"?=",so->p);
            }

         tmp = (char*)pmalloco(so->p, j_strlen(lcRTAddr)*3+(j_strlen(lcRTAddr)*3/20)+1);
         toEscape(lcRTAddr, (void *) tmp,"()<>,;:\"/[]?");
         lcRTAddr=tmp;

         if (j_strlen(lcRTName)>0)
            subject=spools(so->p,"\"",lcRTName,"\" <",lcRTAddr,">" ,so->p);
         else
            subject=spools(so->p,"<",lcRTAddr,">" ,so->p);

         xmlnode_put_attrib(so->x,"Reply-to",subject);
         }
      }

   xmlnode_put_attrib(so->x,"X-Mailer",spools(so->p,smtp_name," ",smtp_version," ","[http://gorila.netlab.cz/jabber.html]",so->p));
   xmlnode_put_attrib(so->x,"MIME-Version","1.0");
   xmlnode_put_attrib(so->x,"Jabber-ID",lcFrom);



   id=xmlnode_get_attrib(jp->x,"id");
   if (j_strlen(id)==0)
      {
      id = (char*)pmalloc_x(so->p, 18,' ');
      smtp_GetDateTime((char *)id);
      }

   xmlnode_put_attrib(so->x,"Message-ID",spools(so->p,"<",jtin->me,"@",id,">",so->p));


   if (jp->subtype==JPACKET__CHAT)
      {
      if ((thread=xmlnode_get_tag(jp->x,"thread"))!= NULL)
         xmlnode_put_attrib(so->x,"X-Jabber-Thread-id",xmlnode_get_data(thread));
      else    
         xmlnode_put_attrib(so->x,"X-Jabber-Thread-id","jabber-start-thread");
      }

   /* create time header for message */
   now_unixtime = time(NULL);
   gmtime_r(&now_unixtime, &now);
   dateheader[0]='\0';
   snprintf(dateheader, sizeof(dateheader), "%02i %s %04i %02i:%02i:%02i +0000", now.tm_mday, smtp_CMonth(now.tm_mon), now.tm_year+1900, now.tm_hour, now.tm_min, now.tm_sec);
   if (dateheader[0])
 	   xmlnode_put_attrib(so->x,"Date",dateheader);


   loHTML=xmlnode_get_tag(jp->x,"html");
   loBody=xmlnode_get_tag(jp->x,"body");
   loEncrypted=xmlnode_get_tag(jp->x,"x?xmlns=jabber:x:encrypted"); // is used PGP?
   loSigned=xmlnode_get_tag(jp->x,"x?xmlns=jabber:x:signed"); // is used PGP?


  
   if (loEncrypted || loSigned)
      {
      liPGP=1;
      if (so->Advertising==1)
         liMode=SMTP_PGP_ATTACH;
      else
         liMode=(so->toPGPMIME==1)?SMTP_PGP_MIME:SMTP_PGP_NOMIME;
      }


   // PGP, encrypted or encrypted+signed
   if (loEncrypted!= NULL)
      {
      loCB=xmlnode_get_tag(jtin->config,"core/pgp/cbm/cb"); // comment block
      if (loCB)
         lcCB=xmlnode_get_data(loCB);

      switch(liMode)
         {
         case SMTP_PGP_ATTACH:
              smtpboundary[0]='\0';
              snprintf(smtpboundary, sizeof(smtpboundary), "JPB_%04i%02i%02i%02i%02i%02i%i", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
              snprintf(smtpCT, sizeof(smtpCT), "multipart/mixed;\r\n boundary=\"%s\"", smtpboundary);

              xmlnode_put_attrib(so->x,"Content-type",smtpCT);
              xmlnode_put_attrib(so->x,"Content-Description","Jabber message - PGP");

              // advertising message
              xmlnode_insert_cdata(so->x,"\r\n--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);

              xmlnode_insert_cdata(so->x,"Content-Type: text/plain; charset=UTF-8\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Description: Jabber message - Advertising\r\n\r\n",-1);

              xmlnode_insert_cdata(so->x,xmlnode_get_data(so->oAD),-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);

              // PGP message as attachment
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);

              xmlnode_insert_cdata(so->x,"Content-Type: application/pgp-encrypted;\r\n name=\"PGP encrypted message\";\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Disposition: attachment;\r\n filename=\"PGPEncryptedMessage.asc\"\r\n\r\n",-1);

              // PGP message
              xmlnode_insert_cdata(so->x,SMTP_PGP_BEGIN,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n",-1);
              xmlnode_insert_cdata(so->x,"Version: ",-1);
              xmlnode_insert_cdata(so->x,smtp_name,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,smtp_version,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Comment: Transport Layer",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loEncrypted),-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,SMTP_PGP_END,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n\r\n",-1);


              // End of boundary
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"--\r\n\r\n",-1);
              break;

         case SMTP_PGP_MIME:
              smtpboundary[0]='\0';
              snprintf(smtpboundary, sizeof(smtpboundary), "JPB_%04i%02i%02i%02i%02i%02i%i", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
              snprintf(smtpCT, sizeof(smtpCT), "multipart/encrypted;\r\n protocol=\"application/pgp-encrypted\";\r\n boundary=\"%s\"", smtpboundary);

              // encrypted content type
              xmlnode_put_attrib(so->x,"Content-type",smtpCT);
              xmlnode_put_attrib(so->x,"Content-Description","Jabber message - PGP");

              xmlnode_insert_cdata(so->x,"\r\nThis is an OpenPGP/MIME encrypted message (RFC 2440 and 3156)\r\n",-1);

              // Begin of boundary
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Type: application/pgp-encrypted\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Description: PGP/MIME version identification\r\n\r\nVersion: 1\r\n\r\n",-1);

              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Type: application/octet-stream; name=\"encrypted.asc\"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Description: OpenPGP encrypted message\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Disposition: inline; filename=\"encrypted.asc\"\r\n\r\n",-1);

              // PGP message
              xmlnode_insert_cdata(so->x,SMTP_PGP_BEGIN,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n",-1);
              xmlnode_insert_cdata(so->x,"Version: ",-1);
              xmlnode_insert_cdata(so->x,smtp_name,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,smtp_version,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Comment: Transport Layer",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loEncrypted),-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,SMTP_PGP_END,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n\r\n",-1);

              // End of boundary
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"--\r\n\r\n",-1);
              break;


         default:
              xmlnode_put_attrib(so->x,"Content-Type","text/plain; charset=UTF-8");
              xmlnode_put_attrib(so->x,"Content-Transfer-Encoding","8bit");
              xmlnode_put_attrib(so->x,"Content-Description","Jabber message - PGP");

              // PGP message
              xmlnode_insert_cdata(so->x,SMTP_PGP_BEGIN,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n",-1);
              xmlnode_insert_cdata(so->x,"Charset=UTF-8\r\n",-1);
              xmlnode_insert_cdata(so->x,"Version: ",-1);
              xmlnode_insert_cdata(so->x,smtp_name,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,smtp_version,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Comment: Transport Layer",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loEncrypted),-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,SMTP_PGP_END,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n\r\n",-1);
         }
      }

   // PGP, signed (only)
   if (loSigned!= NULL)
      {
      loCB=xmlnode_get_tag(jtin->config,"core/pgp/cbs/cb"); // comment block
      if (loCB)
         lcCB=xmlnode_get_data(loCB);

      switch(liMode)
         {
         case SMTP_PGP_ATTACH:
              smtpboundary[0]='\0';
              snprintf(smtpboundary, sizeof(smtpboundary), "JPB_%04i%02i%02i%02i%02i%02i%i", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
              snprintf(smtpCT, sizeof(smtpCT), "multipart/mixed;\r\n boundary=\"%s\"", smtpboundary);

              xmlnode_put_attrib(so->x,"Content-type",smtpCT);
              xmlnode_put_attrib(so->x,"Content-Description","Jabber message - PGP");

              // advertijting message
              xmlnode_insert_cdata(so->x,"\r\n--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);

              xmlnode_insert_cdata(so->x,"Content-Type: text/plain; charset=UTF-8\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Description: Jabber message - Advertising\r\n\r\n",-1);

              xmlnode_insert_cdata(so->x,xmlnode_get_data(so->oAD),-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);

              // PGP message as attachment
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);

              xmlnode_insert_cdata(so->x,"Content-Type: application/pgp-signature;\r\n name=\"PGP signature message\";\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit;\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Disposition: attachment;\r\n filename=\"PGPSignatureMessage.asc\"\r\n\r\n",-1);

              // PGP signature body
              xmlnode_insert_cdata(so->x,SMTP_PGP_BEGIN,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_SIGNATURE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n",-1);
              xmlnode_insert_cdata(so->x,"Version: ",-1);
              xmlnode_insert_cdata(so->x,smtp_name,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,smtp_version,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Comment: Transport Layer",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loSigned),-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,SMTP_PGP_END,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_SIGNATURE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n\r\n",-1);


              // End of boundary
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"--\r\n\r\n",-1);
              break;

         case SMTP_PGP_MIME:
              smtpboundary[0]='\0';
              snprintf(smtpboundary, sizeof(smtpboundary), "JPB_%04i%02i%02i%02i%02i%02i%i", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
              snprintf(smtpCT, sizeof(smtpCT), "multipart/signed;\r\n protocol=\"application/signature\";\r\n boundary=\"%s\"", smtpboundary);


              // basic content type
              xmlnode_put_attrib(so->x,"Content-type",smtpCT);
              xmlnode_put_attrib(so->x,"Content-Description","Jabber message - PGP");


              xmlnode_insert_cdata(so->x,"\r\nThis is an OpenPGP/MIME signed message (RFC 2440 and 3156)\r\n",-1);

              // Begin of boundary
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Type: Content-Type: text/plain; charset=UTF-8\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n\r\n",-1);
              // body text
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loBody),-1);


              // PGP signature
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Type: application/pgp-signature; name=\"signature.asc\"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Description: digital signature\r\n",-1);
              xmlnode_insert_cdata(so->x,"Content-Disposition: attachment; filename=\"signature.asc\"\r\n\r\n",-1);


              // PGP signature body
              xmlnode_insert_cdata(so->x,SMTP_PGP_BEGIN,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_SIGNATURE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n",-1);
              xmlnode_insert_cdata(so->x,"Version: ",-1);
              xmlnode_insert_cdata(so->x,smtp_name,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,smtp_version,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Comment: Transport Layer",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loSigned),-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,SMTP_PGP_END,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_SIGNATURE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n\r\n",-1);

              // End of boundary
              xmlnode_insert_cdata(so->x,"--",-1);
              xmlnode_insert_cdata(so->x,smtpboundary,-1);
              xmlnode_insert_cdata(so->x,"--\r\n\r\n",-1);
              break;


         default:
              xmlnode_put_attrib(so->x,"Content-Type","text/plain; charset=UTF-8");
              xmlnode_put_attrib(so->x,"Content-Transfer-Encoding","8bit");
              xmlnode_put_attrib(so->x,"Content-Description","Jabber message - PGP");

              xmlnode_insert_cdata(so->x,SMTP_PGP_SIGNED_MESSAGE,-1);
              xmlnode_insert_cdata(so->x,"\r\nHash: SHA1",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);

              // body text
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loBody),-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);

              // PGP signed
              xmlnode_insert_cdata(so->x,SMTP_PGP_BEGIN,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_SIGNATURE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n",-1);
              xmlnode_insert_cdata(so->x,"Charset=UTF-8\r\n",-1);
              xmlnode_insert_cdata(so->x,"Version: ",-1);
              xmlnode_insert_cdata(so->x,smtp_name,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,smtp_version,-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,"Comment: Transport Layer",-1);
              xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
              xmlnode_insert_cdata(so->x,xmlnode_get_data(loSigned),-1);
              xmlnode_insert_cdata(so->x,"\r\n",-1);
              xmlnode_insert_cdata(so->x,SMTP_PGP_END,-1);
              xmlnode_insert_cdata(so->x," ",-1);
              xmlnode_insert_cdata(so->x,((lcCB) && j_strlen(lcCB)>0)?lcCB:SMTP_PGP_SIGNATURE,-1);
              xmlnode_insert_cdata(so->x,"-----\r\n\r\n",-1);
              break;

         }

      }


   // xhtml and text
   if (liPGP==0 && loHTML!= NULL && loBody!= NULL)
      {
      smtpboundary[0]='\0';
      snprintf(smtpboundary, sizeof(smtpboundary), "JPB_%04i%02i%02i%02i%02i%02i%i", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
      snprintf(smtpCT, sizeof(smtpCT), "multipart/alternative; boundary=\"%s\"", smtpboundary);

      xmlnode_put_attrib(so->x,"Content-type",smtpCT);

      xmlnode_insert_cdata(so->x,"--",-1);
      xmlnode_insert_cdata(so->x,smtpboundary,-1);
      xmlnode_insert_cdata(so->x,"\r\n",-1);

      xmlnode_insert_cdata(so->x,"Content-Type: text/plain; charset=UTF-8\r\n",-1);
      xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n",-1);
      xmlnode_insert_cdata(so->x,"Content-Description: Jabber message - text format\r\n",-1);
      xmlnode_insert_cdata(so->x,"\r\n",-1);
      xmlnode_insert_cdata(so->x,xmlnode_get_data(loBody),-1);
      if (so->Advertising==1)
         {
         xmlnode_insert_cdata(so->x,"\r\n",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_data(so->oAD),-1);
         }
      xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
       

      // for html is needly insert <head> tag with meta tag about charset
      // <head><meta content="text/html; charset=utf-8" http-equiv="content-type" /></head>
/*
       html=xmlnode_dup(xmlnode_get_tag(p->x,"html"));
       meta=xmlnode_insert_tag(xmlnode_insert_tag(html,"head"),"meta");
       xmlnode_put_attrib(meta,"content-type","text/html; charset=utf-8");
       xmlnode_put_attrib(meta,"http-equiv","content-type");
*/
      html= xmlnode_new_tag_pool(so->p,"html");
      if (xmlnode_has_attribs(loHTML))
          xmlnode_insert_node(html, xmlnode_get_firstattrib(loHTML));

      meta=xmlnode_insert_tag(xmlnode_insert_tag(html,"head"),"meta");
      xmlnode_put_attrib(meta,"content-type","text/html; charset=utf-8");
      xmlnode_put_attrib(meta,"http-equiv","content-type");
      xmlnode_insert_node(html, xmlnode_get_firstchild(loHTML));

      xmlnode_insert_cdata(so->x,"--",-1);
      xmlnode_insert_cdata(so->x,smtpboundary,-1);
      xmlnode_insert_cdata(so->x,"\r\n",-1);
      xmlnode_insert_cdata(so->x,"Content-Type: text/html; charset=UTF-8\r\n",-1);
      xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n",-1);
      xmlnode_insert_cdata(so->x,"Content-Description: Jabber message - html format\r\n",-1);
      xmlnode_insert_cdata(so->x,"\r\n",-1);
      xmlnode_insert_cdata(so->x,xmlnode2str(html),-1);

      if (so->Advertising==1)
         {
         xmlnode_insert_cdata(so->x,"\r\n",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_data(so->oAD),-1);
         }
      xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
       
      xmlnode_insert_cdata(so->x,"--",-1);
      xmlnode_insert_cdata(so->x,smtpboundary,-1);
      xmlnode_insert_cdata(so->x,"--\r\n\r\n",-1);
      }


   // only xhtml
   if (liPGP==0 && loHTML!= NULL && loBody== NULL)
      {
      html= xmlnode_new_tag_pool(so->p,"html");
      if (xmlnode_has_attribs(loHTML))
          xmlnode_insert_node(html, xmlnode_get_firstattrib(loHTML));

      meta=xmlnode_insert_tag(xmlnode_insert_tag(html,"head"),"meta");
      xmlnode_put_attrib(meta,"content-type","text/html; charset=utf-8");
      xmlnode_put_attrib(meta,"http-equiv","content-type");
      xmlnode_insert_node(html, xmlnode_get_firstchild(loHTML));

      xmlnode_put_attrib(so->x,"Content-Type","text/html; charset=UTF-8");
      xmlnode_put_attrib(so->x,"Content-Transfer-Encoding","8bit");
      xmlnode_put_attrib(so->x,"Content-Description","Jabber message - html format");
      xmlnode_insert_cdata(so->x,xmlnode2str(html),-1);

      if (so->Advertising==1)
         {
         xmlnode_insert_cdata(so->x,"\r\n",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_data(so->oAD),-1);
         }
      xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
      }


   // only text
   if (liPGP==0 && loHTML== NULL && loBody!= NULL)
      {
      xmlnode_put_attrib(so->x,"Content-Type","text/plain; charset=UTF-8");
      xmlnode_put_attrib(so->x,"Content-Transfer-Encoding","8bit");
      xmlnode_put_attrib(so->x,"Content-Description","Jabber message - text format");
      xmlnode_insert_cdata(so->x,xmlnode_get_data(loBody),-1);
      if (so->Advertising==1)
         {
         xmlnode_insert_cdata(so->x,"\r\n",-1);
         xmlnode_insert_cdata(so->x,xmlnode_get_data(so->oAD),-1);
         }
      xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
       
      }


   return so;
   }

/* read an incoming line from the connection */
void smtp_out_read(mio m, int state, void *arg, char *buffer, int bufsz)
   {
   char *cbuffer, *cur, *args,*lcBFile;
   int i,liSaved=0;
   jpacket jp;
   xmlnode x,loStatus;
   smtpsx par_so=(smtpsx)(arg);
   smtpp par =par_so->par;
   smtps so =par_so->so;
   log_debug(ZONE,"SMPT: MIO state %i, %s",state, buffer);

   switch(state)
      {
      case MIO_CLOSED:
           if (par_so->state==MIO_NEW)
              {
              log_debug(ZONE,"SMPT: MIO CONNECT FAILED, message save to offline folder");
              jtin->JabberMessagesOutError++;
              smtp_StatsInc( "JabberMessagesOutError");
              log_warn("smtp","SMTP timeout error");
              snprintf(jtin->cJabber_Status, 20, "SMTP timeout error\0");


              // copy file from backup to offline folder
              if (jtin->tmpOfflineJabber==1 && jtin->tmpBackupJabber==1 && j_strlen(par_so->cBFile)>0)
                 {
                 lcBFile = (char*)pmalloco(par_so->p, 254);
                 lcBFile=spools(par_so->p, tempnam(xmlnode_get_attrib(xmlnode_get_tag(jtin->config,"jabber/offline"),"folder"), "tmp"),".xml",par_so->p);
                 rename(par_so->cBFile,lcBFile);
                 par_so->cBFile=NULL;
                 liSaved=1;
                 smtp_SendInfoToAdmin(spools(par_so->p,"Move message from backup repository to offline repository... ",par_so->cBFile,par_so->p) );
                 }

/*
              if (liSaved==1)
                 smtp_ReplyError(par->i, par->jp, "message", smtp_rc_GetString(par_so->p,par_so->par->lang,SMTP_XXX_TIMEOUT_1), SMTP_CODE_504);

              if (liSaved==0)
                 smtp_ReplyError(par->i, par->jp, "message", smtp_rc_GetString(par_so->p,par_so->par->lang,SMTP_XXX_TIMEOUT_0), SMTP_CODE_504);
*/


//<remote-server-timeout/> wait 504 

              // Timeout error
              x= out_SetReply(xmlnode_new_tag("presence"),par->jp->x);
              xmlnode_insert_cdata(xmlnode_insert_tag(x,"show"),"dnd",-1);

              if (liSaved==1)
                 xmlnode_insert_cdata(loStatus=xmlnode_insert_tag(x,"status"),smtp_rc_GetString(par_so->p,par_so->par->lang,SMTP_XXX_TIMEOUT_1),-1);
              else
                 xmlnode_insert_cdata(loStatus=xmlnode_insert_tag(x,"status"),smtp_rc_GetString(par_so->p,par_so->par->lang,SMTP_XXX_TIMEOUT_0),-1);

              xmlnode_insert_cdata(loStatus,"\r\n",-1);
              xmlnode_insert_cdata(loStatus,xmlnode_get_data(xmlnode_get_tag(par->jp->x,"body")),-1);
              deliver(dpacket_new(xmlnode_dup(x)),par->i);
              xmlnode_free(x);

              pool_free(par_so->par->tmppool);
              }
           else
              {
              // delete email from backup repository
              if (jtin->tmpBackupJabber==1 && j_strlen(par_so->cBFile)>0)
                 {
                 remove(par_so->cBFile);
                 smtp_SendInfoToAdmin(spools(par_so->p,"Delete message from backup repository... ",par_so->cBFile,par_so->p) );
                 }

              }

           pool_free(par_so->p);
           return;

      case MIO_ERROR:
           log_debug(ZONE,"SMPT: MIO_ERROR, TIMEOUT ERROR AT sending message");
           jtin->JabberMessagesOutError++;
           smtp_StatsInc( "JabberMessagesOutError");
           log_warn("smtp","SMTP timeout error");
           snprintf(jtin->cJabber_Status, 20, "SMTP timeout error\0");

           // copy file from backup to offline folder
           if (jtin->tmpOfflineJabber==1 && jtin->tmpBackupJabber==1 && j_strlen(par_so->cBFile)>0)
              {
              lcBFile = (char*)pmalloco(so->p, 254);
              lcBFile=spools(so->p, tempnam(xmlnode_get_attrib(xmlnode_get_tag(jtin->config,"jabber/offline"),"folder"), "tmp"),".xml",so->p);
              rename(par_so->cBFile,lcBFile);
              par_so->cBFile=NULL;
              liSaved=1;
              smtp_SendInfoToAdmin( spools(par_so->p,"Move message from backup repository to offline repository... ",par_so->cBFile,par_so->p) );
              }
/*
           if (liSaved==1)
              smtp_ReplyError(so->i, so->jp, "message", smtp_rc_GetString(so->p,so->lang,SMTP_XXX_TIMEOUT_1), SMTP_CODE_504);

           if (liSaved==0)
              smtp_ReplyError(so->i, so->jp, "message", smtp_rc_GetString(so->p,so->lang,SMTP_XXX_TIMEOUT_0), SMTP_CODE_504);
*/

           // Timeout error
           x= out_SetReply(xmlnode_new_tag("presence"),so->jp->x);
           xmlnode_insert_cdata(xmlnode_insert_tag(x,"show"),"dnd",-1);

           if (liSaved==1)
              xmlnode_insert_cdata(loStatus=xmlnode_insert_tag(x,"status"),smtp_rc_GetString(so->p,so->lang,SMTP_XXX_TIMEOUT_1),-1);
           else
              xmlnode_insert_cdata(loStatus=xmlnode_insert_tag(x,"status"),smtp_rc_GetString(so->p,so->lang,SMTP_XXX_TIMEOUT_0),-1);

           xmlnode_insert_cdata(loStatus,"\r\n",-1);
           xmlnode_insert_cdata(loStatus,xmlnode_get_data(xmlnode_get_tag(so->jp->x,"body")),-1);
           deliver(dpacket_new(xmlnode_dup(x)),so->i);
           xmlnode_free(x);

           pool_free(par_so->p); // maybe bug?
           return;


      case MIO_NEW:
           log_debug(ZONE,"SMPT: MIO_NEW\r\n");
           par_so->state=MIO_BUFFER;
           // create so structure
           par_so->so=so = smtp_new_out(m);
           pool_cleanup(so->p, smtp_out_cleanup, (void *)so);

           jp=so->jp = pmalloc(so->p,sizeof(_jpacket));
           jp->x = xmlnode_dup_pool(so->p,par->jp->x);
           jp=so->jp = jpacket_reset(jp);
           jpacket_subtype(jp);

           so->i = par->i;
           so->lang= pstrdup(so->p,par->lang);
           so->phase=PHASE_NONE;
           pool_free(par->tmppool);

           so = smtp_out_new(m, so); // create data for SMTP session
           snprintf(jtin->cJabber_Status, 20, "Send data to SMTP\0");
           mio_reset(m, smtp_out_read, (void *)par_so);

           return;

      case MIO_BUFFER:
           log_debug(ZONE,"SMPT: MIO_BUFFER\r\n");
           break;

      default:
           log_debug(ZONE,"SMPT: MIO UNKNOWN STATE\r\n");
           return;
      }


   so->timer = time(NULL); /* so we don't timeout */

   if(bufsz <= 0) return;

   if (so->buffer != NULL)
      { /* old data yet, combine and use that */
      cur = malloc(strlen(so->buffer) + bufsz + 1);
      *cur = '\0';
      strcat(cur,so->buffer);
      strcat(cur,buffer);
      free(so->buffer);
      so->buffer = buffer = cur;
      bufsz = strlen(buffer);
      }

   #ifdef SMTP_DB
    log_debug(ZONE,"phase %d data [%s]",so->phase, buffer);
   #else
    log_debug(ZONE,"phase %d data",so->phase);
   #endif
   cur = cbuffer = (char *)buffer;
   for(i = 1; i < bufsz; i++)
      {
      if (cbuffer[i-1] == '\r' && cbuffer[i] == '\n')
         {
         cbuffer[i-1] = '\0';
         cbuffer[i] = '\0';

         if (strlen(cur) > 0)
            {
            args = strstr(cur," ");
            if (args != NULL)
               {
               *args = '\0';
               ++args;
               }
            so->iStatus=atoi(cur);
            smtp_out_status(so,args);
            }
         cur = cbuffer + i + 1;
         }
      }

   free(so->buffer);
   so->buffer = NULL;
   i = strlen(cur);
   if (i > 0) /* the read was cut off */
      {
      so->buffer = strdup(cur);
      }

   }



// S:2005-09-01 gorila@dione.zcu.cz
int smtp_out_packets_message(smtpp par,char *lcType)
   {
   int liProcess=0,liErr,liLen;
   jpacket jp=par->jp;
   jid ljidFrom=smtp_2mx( jp->from);
   pool p;
   smtpsx par_so;
   xmlnode xErr,loSubj;
   char *lcSubj=NULL,*lcJID, *lcPom;
   

   if (jp->to == NULL || jp->to->user == NULL || strstr(jp->to->user,"%") == NULL || ljidFrom == NULL)
      {
      log_debug(ZONE,"ADMIN MESSAGE");

      if ((liProcess=smtp_admin_message(par,lcType))==0 && par->dp!=NULL)
          deliver_fail(par->dp, "Invalid Address");

      liProcess=-1;
      }

   if (liProcess==0 && (jp->subtype==JPACKET__CHAT || jp->subtype==JPACKET__NONE || jp->subtype == JPACKET__ERROR))
      {
      /* hide session on the packet, and pass it to be handled after the conneciton is open */

      // it is error, but it not unknown recipient
      if (jp->subtype == JPACKET__ERROR &&
         (liErr=j_atoi(xmlnode_get_attrib(xmlnode_get_tag(jp->x,"error"),"code"),0))!=404)
         return -1;

      if (jp->subtype != JPACKET__ERROR)
         {
         // test na JEP-0088, ignore it
         if (xmlnode_get_tag(jp->x,"composing")!=NULL ||
             xmlnode_get_tag(jp->x,"paused")!=NULL ||
             xmlnode_get_tag(jp->x,"inactive")!=NULL ||
             xmlnode_get_tag(jp->x,"gone")!=NULL
            )
            return -1;

         // test na JEP-0022, ignore it
         if (xmlnode_get_tag(jp->x,"x?xmlns=jabber:x:event")!=NULL &&
             (j_strlen(xmlnode_get_tag_data(jp->x,"body"))==0 ||
              j_strlen(xmlnode_get_tag_data(jp->x,"html"))==0) &&
             j_strlen(xmlnode_get_tag_data(jp->x,"subject"))==0
            )
            return -1;

         lcJID = smtp_GetJID(par->tmppool,xmlnode_get_attrib(jp->x,"from"));
         // check for registered users
         if (j_atoi(xmlnode_get_tag_data(jtin->config,"jabber/registered"),0)==1 &&
             smtp_roster_get_item(par->tmppool, lcJID,0)== NULL)
            {
            deliver_fail(par->dp, smtp_rc_GetString(par->tmppool,par->lang,SMTP_XXX_MUST_REGISTER));
            return -1;
            }

         }


      jtin->JabberMessages++;
      smtp_StatsInc("JabberMessages");
      
      // it is error - unknown recipient
      if (jp->subtype == JPACKET__ERROR && liErr==404)
         {
         xErr=par->jp->x;
         lcPom=smtp_rc_GetString(par->tmppool,par->lang,SMTP_XXX_RCPT_NOTFOUND);

         if ((loSubj=xmlnode_get_tag(xErr,"subject"))!=NULL)
            {
            lcSubj=xmlnode_get_data(loSubj);
            xmlnode_hide(loSubj);
            }
         liLen=j_strlen(lcSubj)>0;

         loSubj=xmlnode_insert_tag(xErr,"subject");

         // pidej pedmt, jen pokud tam nen
         if (liLen==0 || strstr(lcSubj,lcPom)==NULL)
            {
            xmlnode_insert_cdata(loSubj,lcPom,-1);

            if (liLen>0)
               xmlnode_insert_cdata(loSubj,"  ",-1);
            }

         if (liLen>0)
            xmlnode_insert_cdata(loSubj,lcSubj,-1);

         }


      snprintf(jtin->cJabber_Status, 20, "Connect to SMTP\0");
      p=pool_new();   
      par_so= pmalloc(p,sizeof(_smtpsx));
      par_so->p=p;
      par_so->state=MIO_NEW;
      par_so->par=par;

      // save message to backup repository
      if (jtin->tmpBackupJabber==1)
         {
         log_debug(ZONE,"SMPT: save to backup folder\r\n");
         par_so->cBFile = (char*)pmalloco(p, 254);
         par_so->cBFile=spools(p, tempnam(xmlnode_get_attrib(xmlnode_get_tag(jtin->config,"jabber/backup"),"folder"), "tmp"),".xml",p);
         if (xmlnode2file(par_so->cBFile  ,par->jp->x)!=1)
            {
            smtp_SendInfoToAdmin(spools(p,"Save message to backup repository... ",par_so->cBFile," ...failed",p) );
            log_warn("smtp","Cannot save message to %s",par_so->cBFile);
            }
         else
            smtp_SendInfoToAdmin(spools(p,"Save message to backup repository... ",par_so->cBFile,p) );
         }

	  mio_connect(pstrdup(par->tmppool,jtin->relay), jtin->relayport, smtp_out_read, (void *)par_so, 30, NULL, NULL);
      liProcess=-2;
      }



/*
   if (liProcess==1)
      {
      deliver(dpacket_new(xmlnode_dup(x)),jtin->i);
      xmlnode_free(x);
      }

*/

   return liProcess;
   }
// E:2005-09-01 gorila@dione.zcu.cz
