#include "smtp.h"

extern smtpi jtin;

xmlnode smtp_roster_get_defaultitem(pool p,char *lcJID)
   {
   xmlnode loJID, loSubj;

   loJID=xmlnode_new_tag_pool(p, "item");

   xmlnode_put_attrib(loJID,"jid",pstrdup(p,lcJID));

   // set default values

   xmlnode_put_attrib(loJID,"UseGlobalSettings","1");
   xmlnode_put_attrib(loJID,"Attachments",xmlnode_get_attrib(xmlnode_get_tag(jtin->config,"smtp/attachments"),"pass"));
   xmlnode_put_attrib(loJID,"PGPJabberToMIME",xmlnode_get_attrib(xmlnode_get_tag(jtin->config,"jabber/pgp"),"mime"));
   xmlnode_put_attrib(loJID,"PGPToJabbernonMIMETox",xmlnode_get_attrib(xmlnode_get_tag(jtin->config,"smtp/pgp"), "nonmime2x"));
   xmlnode_put_attrib(loJID,"S2J_AllAreSPAM",xmlnode_get_data(xmlnode_get_tag(jtin->config,"smtp/allmessagesarespam")));


   xmlnode_put_attrib(loJID,"J2S_RTMode","0");
   xmlnode_put_attrib(loJID,"J2S_RTName",pstrdup(p,lcJID));
   xmlnode_put_attrib(loJID,"J2S_RTAddr",pstrdup(p,lcJID));

   loSubj=xmlnode_get_tag(jtin->config,"jabber/subject");
   if ( loSubj!=NULL)
      {
      xmlnode_put_attrib(loJID,"J2S_SRMode",xmlnode_get_attrib(loSubj,"replace"));
      xmlnode_put_attrib(loJID,"J2S_SRSeparator",xmlnode_get_attrib(loSubj,"separator"));
      xmlnode_put_attrib(loJID,"J2S_SRText",xmlnode_get_data(loSubj));
      }


   loSubj=xmlnode_get_tag(jtin->config,"smtp/subject");
   if ( loSubj!=NULL)
      {
      xmlnode_put_attrib(loJID,"S2J_SRMode",xmlnode_get_attrib(loSubj,"replace"));
      xmlnode_put_attrib(loJID,"S2J_SRSeparator",xmlnode_get_attrib(loSubj,"separator"));
      xmlnode_put_attrib(loJID,"S2J_SRText",xmlnode_get_data(loSubj));
      }
   
   xmlnode_put_attrib(loJID,"default","1"); // flag of default item
   return loJID;
   }

xmlnode smtp_roster_get_item(pool p, char *lcJID, int liDefault)
   {
   xmlnode loJID=NULL,loFile;
   int liFound=0;
   char *lcLetter;
   if (j_strlen(lcJID)==0)
      return (xmlnode) NULL;

   lcLetter = (char*)pmalloc_x(p, 4,'\0');
   lcLetter[0]=lcJID[0];
   if (lcJID[0]<0)
      toEscape(lcLetter,(void *)lcLetter,"()<>,;:\"/[]?");

   loFile=xmlnode_get_tag(jtin->roster,spools(p,"file?type=",lcLetter,p));

   if (loFile!=NULL)
      if ((loFile=xmlnode_get_tag(jtin->roster_files,spools(p,"file?type=",lcLetter,p)))!=NULL)
         {
         if ((loJID=xmlnode_get_tag(loFile,spools(p,"item?jid=",lcJID,p)))!=NULL)
            {
            liFound=1;
            if (j_strlen(xmlnode_get_attrib(loJID,"J2S_RTMode"))==0)
               {
               xmlnode_put_attrib(loJID,"J2S_RTMode","0");
               xmlnode_put_attrib(loJID,"J2S_RTName",pstrdup(jtin->i->p,lcJID));
               xmlnode_put_attrib(loJID,"J2S_RTAddr",pstrdup(jtin->i->p,lcJID));
               }
            }
         }

   if (liFound==0 && liDefault==1) // if not found and must return default item
       loJID=smtp_roster_get_defaultitem(jtin->i->p,lcJID);

   return loJID;
   }


void smtp_roster_set_item(pool p, char *lcJID, xmlnode loJID)
   {
   xmlnode loFile,loJIDOld,loFileM;
   char *lcFile, *lcLetter;
   int liSaveM=0;
   if (j_strlen(lcJID)==0)
      return ;

   smtp_SendInfoToAdmin(spools(p,"ROSTER - Add item ",lcJID ,p));
   log_notice("smtp","ROSTER - Add item %s",lcJID);

   lcLetter = (char*)pmalloc_x(p, 4,'\0');
   lcLetter[0]=lcJID[0];
   if (lcJID[0]<0)
      toEscape(lcLetter,(void *)lcLetter,"()<>,;:\"/[]?");

   xmlnode_hide_attrib(loJID,"default");

   if ((loFileM=xmlnode_get_tag(jtin->roster,spools(p,"file?type=",lcLetter,p)))==NULL)
      {
      // zznam pro dan psmeno neexistuje
      lcFile = (char*)pmalloco(jtin->i->p, 254);
      lcFile=spools(p,jtin->roster_folder,"/roster_",lcLetter,".xml",p);

      xmlnode_put_attrib((loFileM=xmlnode_insert_tag(jtin->roster,"file")),"type",lcLetter);
      xmlnode_insert_cdata(loFileM,lcFile,-1);
      liSaveM=1;
      }
   else
      lcFile=xmlnode_get_data(loFileM);

   if ((loFile=xmlnode_get_tag(jtin->roster_files,spools(p,"file?type=",lcLetter,p)))==NULL)
      {
      // zznam pro dan psmeno neexistuje
      xmlnode_put_attrib(loFile=xmlnode_insert_tag(jtin->roster_files,"file"),"type",lcLetter);
      }


   if ((loJIDOld=xmlnode_get_tag(loFile,spools(p,"item?jid=",lcJID,p)))==NULL)
      {
      // new item
      xmlnode_insert_node(loFile,loJID);
      }
   else
      {
      // replace item
/*
	  xmlnode_put_attrib(loJID,"UseGlobalSettings",xmlnode_get_attrib(loJID,"UseGlobalSettings"));
	  xmlnode_put_attrib(loJID,"Attachments",xmlnode_get_attrib(loJID,"Attachments"));
	  xmlnode_put_attrib(loJID,"PGPJabberToMIME",xmlnode_get_attrib(loJID,""PGPJabberToMIME"));
	  xmlnode_put_attrib(loJID,"PGPToJabbernonMIMETox",xmlnode_get_attrib(loJID,"PGPToJabbernonMIMETox"));
	  xmlnode_put_attrib(loJID,"payd",xmlnode_get_attrib(loJID,"payd"));

	  xmlnode_put_attrib(loJID,"J2S_SRMode",xmlnode_get_attrib(loJID,"J2S_SRMode"));
	  xmlnode_put_attrib(loJID,"J2S_SRSeparator",xmlnode_get_attrib(loJID,"J2S_SRSeparator"));
	  xmlnode_put_attrib(loJID,"J2S_SRText",xmlnode_get_attrib(loJID,"J2S_SRText"));

	  xmlnode_put_attrib(loJID,"J2S_RTMode",xmlnode_get_attrib(loJID,"J2S_RTMode"));
	  xmlnode_put_attrib(loJID,"J2S_RTName",xmlnode_get_attrib(loJID,"J2S_RTName"));
	  xmlnode_put_attrib(loJID,"J2S_RTAddr",xmlnode_get_attrib(loJID,"J2S_RTAddr"));

	  xmlnode_put_attrib(loJID,"S2J_SRMode",xmlnode_get_attrib(loJID,"S2J_SRMode"));
	  xmlnode_put_attrib(loJID,"S2J_SRSeparator",xmlnode_get_attrib(loJID,"S2J_SRSeparator"));
	  xmlnode_put_attrib(loJID,"S2J_SRText",xmlnode_get_attrib(loJID,"S2J_SRText"));




*/

      }
      
   if (xmlnode2file(lcFile,loFile)!=1)
      {
      log_alert("smtp","ROSTER - Cannot save roster-letter file %s.",lcFile);
      smtp_SendInfoToAdmin(spools(p,"ROSTER - Cannot save roster-letter file ",lcFile,".",p ));
      }


   if (liSaveM==1)
      if( xmlnode2file(jtin->roster_file,jtin->roster)!=1)
         {
         log_alert("smtp","ROSTER - Cannot save main roster file %s.",jtin->roster_file);
         smtp_SendInfoToAdmin(spools(p,"ROSTER - Cannot save main roster file ",jtin->roster_file,".",p ));
         }
   
   }


void smtp_roster_remove_item(pool p, char *lcJID)
   {
   xmlnode loFile,loJIDOld,loFileM;
   char *lcFile, *lcLetter;
   if (j_strlen(lcJID)==0)
      return;

   smtp_SendInfoToAdmin(spools(p,"ROSTER - Remove item ",lcJID ,p));
   log_notice("smtp","ROSTER - Remove item %s",lcJID);

   lcLetter = (char*)pmalloc_x(p, 4,'\0');
   lcLetter[0]=lcJID[0];
   if (lcJID[0]<0)
      toEscape(lcLetter,(void *)lcLetter,"()<>,;:\"/[]?");

   if ((loFileM=xmlnode_get_tag(jtin->roster,spools(p,"file?type=",lcLetter,p)))==NULL)
      // zznam pro dan psmeno neexistuje
      return;

   lcFile=xmlnode_get_data(loFileM);

   if ((loFile=xmlnode_get_tag(jtin->roster_files,spools(p,"file?type=",lcLetter,p)))==NULL)
      {
      // zznam pro dan psmeno neexistuje
      return;
      }


   if ((loJIDOld=xmlnode_get_tag(loFile,spools(p,"item?jid=",lcJID,p)))==NULL)
      {
      // item not exist
      return;
      }

   xmlnode_hide(loJIDOld);
   if (xmlnode2file(lcFile,loFile)!=1)
      {
      log_alert("smtp","ROSTER - Cannot save roster-letter file %s.",lcFile);
      smtp_SendInfoToAdmin(spools(p,"ROSTER - Cannot save roster-letter file ",lcFile,".",p ));
      }
   }



int smtp_online_add_item(pool p, char *lcFrom, char *lcTo)
   {
   xmlnode loFrom,loFromOff,loTo;
   int liCount=0,liMax=0;

   smtp_SendInfoToAdmin(spools(p,"ONLINE - add item from: ",lcFrom," to:",lcTo ,p));
   log_notice("smtp","ONLINE - add item from: %s to: %s",lcFrom,lcTo);

   // record is not exist, create it
   if ((loFrom=xmlnode_get_tag(jtin->OnlineList,spools(p,"from?jid=",lcFrom,p)))==NULL)
      xmlnode_put_attrib(loFrom=xmlnode_insert_tag(jtin->OnlineList,"from"),"jid",lcFrom);

   // record is not exist, create it
   if ((loFromOff=xmlnode_get_tag(jtin->OfflineList,spools(p,"from?jid=",lcFrom,p)))==NULL)
      xmlnode_put_attrib(loFromOff=xmlnode_insert_tag(jtin->OfflineList,"from"),"jid",lcFrom);


   // check to item
   if (j_strlen(lcTo)>0)
      {
      if ((loTo=xmlnode_get_tag(loFrom,spools(p,"to=",lcTo,p)))==NULL)
         {
         // record is not exist, create it

         // check if exist subitem in offline list
         if ((loTo=xmlnode_get_tag(loFromOff,spools(p,"to=",lcTo,p)))==NULL)
            xmlnode_insert_cdata(loTo=xmlnode_insert_tag(loFrom,"to"),lcTo,-1);
         else
            {
            smtp_xmlnode_move_node(loTo, loFromOff, loFrom);
            }

          liCount=1;
         }
      }
   else
      {
      xmlnode_put_attrib(loFrom,"login","1");
      for (loTo = xmlnode_get_tag(loFromOff,"to"); loTo != NULL; loTo = xmlnode_get_tag(loFromOff,"to"))
          {
          if (loTo->type!=NTYPE_TAG)
      	    continue;

          smtp_xmlnode_move_node(loTo, loFromOff, loFrom);
          liCount++;

          liMax++;
          if (liMax>=MAXLOOP)
             break;
          }

      if (liMax>=MAXLOOP)
         {
         log_warn("smtp","ONLINE - Max count of LOOP was exceed.");
         smtp_SendInfoToAdmin("ONLINE - Max count of LOOP was exceed." );
         }

      }


//   xmlnode2file("./spool/on.xml",jtin->OnlineList);
//   xmlnode2file("./spool/off.xml",jtin->OfflineList);
   return liCount;
   }

int smtp_online_remove_item(pool p, char *lcFrom, char *lcTo)
   {
   xmlnode loFrom,loTo,loFromOff;
   int liCount=0,liMax=0;

   smtp_SendInfoToAdmin(spools(p,"ONLINE - remove item from: ",lcFrom," to:",lcTo ,p));
   log_notice("smtp","ONLINE - remove item from: %s to: %s",lcFrom,lcTo);

   if ((loFrom=xmlnode_get_tag(jtin->OnlineList,spools(p,"from?jid=",lcFrom,p)))==NULL)
      {
      return 0;      // record is not exist
      }

   loFromOff=xmlnode_get_tag(jtin->OfflineList,spools(p,"from?jid=",lcFrom,p));

   if (j_strlen(lcTo)>0) // remove sub item
      {
      if (xmlnode_get_attrib(loFrom,"login")==NULL)
          xmlnode_put_attrib(loFrom,"login","-2");

      // check to item
      if ((loTo=xmlnode_get_tag(loFrom,spools(p,"to=",lcTo,p)))!=NULL)
         {
         liCount=1;
         smtp_xmlnode_move_node(loTo, loFrom, loFromOff);
         }
      }
   else
      {
      xmlnode_put_attrib(loFrom,"login","0");
      // move subitems to offline, walk all item 
      for (loTo = xmlnode_get_tag(loFrom,"to"); loTo != NULL; loTo = xmlnode_get_tag(loFrom,"to"))
          {
          if (loTo->type!=NTYPE_TAG)
      	    continue;

          smtp_xmlnode_move_node(loTo, loFrom, loFromOff);
          liCount++;

          liMax++;
          if (liMax>=MAXLOOP)
             break;

          }

      if (liMax>=MAXLOOP)
         {
         log_warn("smtp","ONLINE - Max count of LOOP was exceed.");
         smtp_SendInfoToAdmin("ONLINE - Max count of LOOP was exceed." );
         }


      }

//   xmlnode2file("./spool/on.xml",jtin->OnlineList);
//   xmlnode2file("./spool/off.xml",jtin->OfflineList);
   return liCount;
   }
