/* --------------------------------------------------------------------------
 *
 * License
 *
 * The contents of this file are subject to the Jabber Open Source License
 * Version 1.0 (the "License").  You may not copy or use this file, in either
 * source code or executable form, except in compliance with the License.  You
 * may obtain a copy of the License at http://www.jabber.com/license/ or at
 * http://www.opensource.org/.  
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyrights
 * 
 * Portions created by or assigned to Jabber.com, Inc. are 
 * Copyright (c) 1999-2000 Jabber.com, Inc.  All Rights Reserved.  Contact
 * information for Jabber.com, Inc. is available at http://www.jabber.com/.
 *
 * Portions Copyright (c) 1998-1999 Jeremie Miller.
 *
 * Portions Copyright (c) 2002 Matthias Wimmer.
 * 
 * Portions Copyright (c) 2006 Martin Jindra.
 * 
 * Acknowledgements
 * 
 * Special thanks to the Jabber Open Source Contributors for their
 * suggestions and support of Jabber.
 * 
 * --------------------------------------------------------------------------*/
 
#include "smtp.h"

smtpi  jtin;


/*

This is the smtp server component.

It acts as a simple SMTP server for both receiving email directly from another server or for delivering
email to another server.

What inspired me to write this very frightening thing is a mystery :) 

Jer

*/

/* takes foo@mapped.host or foo%jabber.org@smtp.host and translates to foo@jabber.org */

jid smtp_mx2( jid id)
   {
   char *at, *trhost;
   xmlnode tr;

   if(id == NULL || id->user == NULL) return NULL;

   log_debug(ZONE,"mx2 checking %s",jid_full(id));

   // query for any translation

   if ((at = strstr(id->user,"%")) != NULL)
      {
      *at = '@';
      id = jid_new(id->p,id->user);

      // check to make sure this id is valid to relay between 
      if (id != NULL && jtin->open == 0 && 
          xmlnode_get_tag(jtin->config,spools(id->p,"smtp/open=",id->server,id->p)) == NULL
          )
         return NULL;
      }
   else
      {
      tr = xmlnode_get_tag(jtin->config, spools(id->p, "core/map?mxhost=",id->server,id->p));
      trhost = xmlnode_get_attrib(tr,"jabber");

      if (trhost == NULL)
         return NULL;

      jid_set(id,trhost,JID_SERVER);
      }

   log_debug(ZONE,"mx2 returning %s",jid_full(id));
   return id;
   }

/* takes foo@jabber.org and translates to foo@mapped.host or foo%jabber.org@smtp.host */
jid smtp_2mx( jid from)
   {
   char *at, *trhost, *strid;
   jid id;
   xmlnode tr;

   if(from == NULL || from->user == NULL) return NULL;

   log_debug(ZONE,"2mx checking %s",jid_full(from));

   /* copy jid and modify copy for the result */
   id = jid_new(from->p,jid_full(from));
   jid_set(id,NULL,JID_RESOURCE);

   /* query for any translation */
   tr = xmlnode_get_tag(jtin->config, spools(id->p, "core/map?jabber=",id->server,id->p));
   trhost = xmlnode_get_attrib(tr,"mxhost");

   if (trhost != NULL)
      jid_set(id,trhost,JID_SERVER);
   else
      {
      strid = jid_full(id);

      at = strstr(strid,"@");
      *at = '%';
      id = jid_new(id->p,jtin->me);
      jid_set(id,strid,JID_USER);
      }

   log_debug(ZONE,"2mx returning %s",jid_full(id));
   return id;
   }

void smtp_SendMessageToAdmin(xmlnode loAdmins, const char *lcMSG)
   {
   xmlnode loMSG,loAdmin;
   loMSG= xmlnode_new_tag("message");

   xmlnode_put_attrib(loMSG,"from",jtin->met);
   xmlnode_put_attrib(loMSG,"type","chat");
   xmlnode_insert_cdata(xmlnode_insert_tag(loMSG,"body"),lcMSG,-1);

   for (loAdmin = xmlnode_get_firstchild(loAdmins); loAdmin != NULL; loAdmin = xmlnode_get_nextsibling(loAdmin))
       {
       if (loAdmin->type!=NTYPE_TAG || strcmp(xmlnode_get_attrib(loAdmin,"xmlns"),"smtp:backup:report")!=0 )
	       	    continue;

       xmlnode_put_attrib(loMSG,"to",xmlnode_get_data(loAdmin));
       deliver(dpacket_new(xmlnode_dup(loMSG)),jtin->i);
       }

   xmlnode_free(loMSG);
   }



void smtp_SendInfoToAdmin( const char *lcMSG)
   {
   xmlnode loMSG,loAdmin,loStatus;
   loMSG= xmlnode_new_tag("presence");

   xmlnode_put_attrib(loMSG,"from",jtin->met);
   xmlnode_insert_cdata(xmlnode_insert_tag(loMSG,"show"),"chat",-1);
   xmlnode_insert_cdata(loStatus=xmlnode_insert_tag(loMSG,"status"),lcMSG,-1);

   for (loAdmin = xmlnode_get_firstchild(xmlnode_get_tag(jtin->config,"core/admins")); loAdmin != NULL; loAdmin = xmlnode_get_nextsibling(loAdmin))
       {
       if (loAdmin->type!=NTYPE_TAG || strcmp(xmlnode_get_attrib(loAdmin,"xmlns"),"smtp:admin:info_track")!=0 )
	       	    continue;

       xmlnode_put_attrib(loMSG,"to",xmlnode_get_data(loAdmin));
       deliver(dpacket_new(xmlnode_dup(loMSG)),jtin->i);
       }

   xmlnode_free(loMSG);
   }

void smtp(instance i, xmlnode x)
   {
   xmlnode config,configF, cur, jep0033, loFile, loRF,loBackup,loOffline,loJID;
   xdbcache xc;
   char *lcPom,*lcJabberBackup,*lcSMTPBackup,*lcJabberOffline,*lcSMTPOffline;
   int liErr,lii,liFolderC,liMax=0;
   struct dirent   *dirp;
   DIR      *dp;
   pool p;


   log_debug(ZONE,"SMTP transport loading");
   p=pool_new();

   xc = xdb_cache(i);
   config = xdb_get(xc, jid_new(xmlnode_pool(x),"config@-internal"),"jabber:config:smtp");

   jtin = pmalloco(i->p,sizeof(_smtpi));
   jtin->met = xmlnode_get_attrib(xmlnode_get_parent(x),"id");

   /* set up internal instance and hash tables */
   jtin->i = i;
   jtin->xc = xc;
   jtin->JabberMessagesOut=jtin->JabberMessagesOutError=
	   jtin->JabberMessages=jtin->SMTPMessages=
	   jtin->SMTPMessagesIn=jtin->SMTPMessagesInError=
       jtin->SMTPSpam=jtin->SMTPCommandUnknown=
       jtin->jep0033=jtin->CoreContacts=
       jtin->CoreContactsOnline, jtin->CoreAccounts=
       jtin->tmpBackupJabber=jtin->tmpBackupSMTP=
       jtin->tmpOfflineJabber=jtin->tmpOfflineSMTP=0;
   jtin->cSMTP_Status[0]=jtin->cJabber_Status[0]=' ';
   jtin->cSMTP_Status[1]=jtin->cJabber_Status[1]='\0';


   // get resources file name and read it
   if ((jtin->config_file=xmlnode_get_tag_data(config,"config"))==NULL)
      jtin->config_file=pstrdup(i->p,SMTP_CONFIG_FILE);

   if ((configF=xmlnode_file(jtin->config_file))==NULL)
      { // file not exist or any other bug
      log_error("smtp","Transport cannot load config file.");
      return;
      }
   jtin->config = xmlnode_dup_pool(i->p, configF);


   // try create backup folder
   loBackup=xmlnode_get_tag(jtin->config,"jabber/backup");
   if ((lcJabberBackup=xmlnode_get_attrib(loBackup,"folder")   )==NULL)
      lcJabberBackup= pstrdup(p,SMTP_BACKUPJABBER_FOLDER);

   if (smtp_CreateFolder(lcJabberBackup)==0)
      jtin->tmpBackupJabber=1;


   // test if any file in folder, if yes, send mesage to all admins
   if (jtin->tmpBackupJabber==1 && (dp = opendir(lcJabberBackup))!=NULL)
      {
      lii=liFolderC=0;
      while ( (dirp = readdir((DIR *)dp)) != NULL)
            {
            if (strcmp(dirp->d_name, ".") == 0  ||
                strcmp(dirp->d_name, "..") == 0 ||
                strcmp(dirp->d_name, "old") == 0)
               continue;      // ignore dot and dot-dot 


            if (lii==0)
               liFolderC=smtp_CreateFolder(spools(p,lcJabberBackup,"/old",p));

            if (liFolderC==0)
               rename(spools(p,lcJabberBackup,"/",dirp->d_name,p),spools(p,lcJabberBackup,"/old/",dirp->d_name,p));

            lii++;
            liMax++;
            if (liMax>=MAXLOOP)
                break;

            }
      closedir((DIR *)dp);

      if (liMax>=MAXLOOP)
         {
         log_warn("smtp","JABBER-BACKUP - Max count of LOOP was exceed.");
         smtp_SendInfoToAdmin("JABBER-BACKUP - Max count of LOOP was exceed." );
         }

      if (lii>0)
         smtp_SendMessageToAdmin( xmlnode_get_tag(jtin->config,"jabber/admins"), spools(p,"Any jabber message (",smtp_itoa(lii),") cause reboot.",p) );
      }


   loBackup=xmlnode_get_tag(jtin->config,"smtp/backup");
   if ((lcSMTPBackup=xmlnode_get_attrib(loBackup,"folder") )==NULL)
      lcSMTPBackup= pstrdup(p,SMTP_BACKUPSMTP_FOLDER);


   if (smtp_CreateFolder(lcSMTPBackup)==0)
      jtin->tmpBackupSMTP=1;

   // test if any file in folder, if yes, send mesage to all admins
   if (jtin->tmpBackupSMTP==1 && (dp = opendir(lcSMTPBackup)) != NULL)
      {
      lii=liFolderC=liMax=0;
      while ( (dirp = readdir((DIR *)dp)) != NULL)
            {
            if (strcmp(dirp->d_name, ".") == 0  ||
                strcmp(dirp->d_name, "..") == 0 ||
                strcmp(dirp->d_name, "old") == 0)
               continue;      // ignore dot and dot-dot


            if (lii==0)
               liFolderC=smtp_CreateFolder(spools(p,lcSMTPBackup,"/old",p));

            if (liFolderC==0)
               rename(spools(p,lcSMTPBackup,"/",dirp->d_name,p),spools(p,lcSMTPBackup,"/old/",dirp->d_name,p));

            lii++;
            liMax++;
            if (liMax>=MAXLOOP)
                break;

            }
      closedir((DIR *)dp);

      if (liMax>=MAXLOOP)
         {
         log_warn("smtp","JABBER-BACKUP - Max count of LOOP was exceed.");
         smtp_SendInfoToAdmin("JABBER-BACKUP - Max count of LOOP was exceed." );
         }

      if (lii>0)
         smtp_SendMessageToAdmin( xmlnode_get_tag(jtin->config,"smtp/admins"), spools(p,"Any SMTP message (",smtp_itoa(lii),") cause reboot.",p));
      }



   // try create offline folder - jabber
   loOffline=xmlnode_get_tag(jtin->config,"jabber/offline");
   if ((lcJabberOffline=xmlnode_get_attrib(loOffline,"folder")   )==NULL)
      lcJabberOffline= pstrdup(p,SMTP_OFFLINEJABBER_FOLDER);

   if (smtp_CreateFolder(lcJabberOffline)==0)
      jtin->tmpOfflineJabber=1;


   // try create offline folder - smtp
   loOffline=xmlnode_get_tag(jtin->config,"smtp/offline");
   if ((lcSMTPOffline=xmlnode_get_attrib(loOffline,"folder")   )==NULL)
      lcSMTPOffline= pstrdup(p,SMTP_OFFLINESMTP_FOLDER);

   if (smtp_CreateFolder(lcSMTPOffline)==0)
      jtin->tmpOfflineSMTP=1;


   // get default language
   if ((lcPom=xmlnode_get_tag_data(jtin->config,"core/language"))==NULL)
      lcPom= SMTP_RC_DEFAULT_LANG;

   jtin->DefaultLang=pstrdup(i->p, lcPom);

   // get statistics file name and read it
   if ((jtin->stat_file=xmlnode_get_tag_data(jtin->config,"core/statistics"))==NULL)
      jtin->stat_file=pstrdup(i->p, SMTP_STATISTICS_FILE);

   lcPom = (char*)pstrdup(p,jtin->stat_file);
   smtp_GetFolderFromFile(lcPom);
   liErr=smtp_CreateFolder(lcPom);


   if (liErr!=0)
      { // file not exist or any other bug
      log_error("smtp","Transport cannot create folder for statistics file");
      return;
      }

   if ((jtin->statistics=xmlnode_file(jtin->stat_file))==NULL)
      { // file not exist or any other bug
      log_warn("smtp","Transport cannot load statistics file (%s).",jtin->stat_file);

      jtin->statistics=xmlnode_new_tag_pool(jtin->i->p,"smtp");
      xmlnode_put_attrib(jtin->statistics,"xmlns","jabber:status:smtp");

      xmlnode_put_attrib(jtin->statistics,"Start","0");
      xmlnode_put_attrib(jtin->statistics,"StartLastDatetime","0");

	  xmlnode_put_attrib(jtin->statistics,"JabberMessages","0");
      xmlnode_put_attrib(jtin->statistics,"JabberMessagesOut","0");
      xmlnode_put_attrib(jtin->statistics,"JabberMessagesOutError","0");

      xmlnode_put_attrib(jtin->statistics,"SMTPCommandUnknown","0");
      xmlnode_put_attrib(jtin->statistics,"SMTPMessages","0");
      xmlnode_put_attrib(jtin->statistics,"SMTPMessagesIn","0");
      xmlnode_put_attrib(jtin->statistics,"SMTPMessagesInError","0");

      xmlnode_put_attrib(jtin->statistics,"SMTPSpam","0");
      }  
   

   xmlnode_put_attrib(jtin->statistics,"CoreContacts","0");
   xmlnode_put_attrib(jtin->statistics,"CoreContactsOnline","0");
   


   // get resources file name and read it
   if ((jtin->res_file=xmlnode_get_tag_data(jtin->config,"core/resources"))==NULL)
      jtin->res_file=pstrdup(i->p,SMTP_RESOURCE_FILE);

   if ((jtin->resources=xmlnode_file(jtin->res_file))==NULL)
      { // file not exist or any other bug
      log_error("smtp","Transport cannot load resource file (%s).",jtin->res_file);
      return;
      }

   // get roster
   if ((jtin->roster_file=xmlnode_get_tag_data(jtin->config,"core/roster"))==NULL)
      jtin->roster_file=pstrdup(i->p,SMTP_ROSTER_FILE);

   jtin->roster_folder=smtp_GetFolderFromFile((char*)pstrdup(i->p,jtin->roster_file));
   liErr=smtp_CreateFolder(jtin->roster_folder);
   if (liErr!=0)
      { // file not exist or any other bug
      log_error("smtp","Transport cannot create folder (%s) for roster file.",jtin->roster_folder);
      return;
      }


   jtin->OnlineList=xmlnode_new_tag_pool(jtin->i->p,"list");
   jtin->OfflineList=xmlnode_new_tag_pool(jtin->i->p,"list");

   jtin->roster_files=xmlnode_new_tag_pool(jtin->i->p,"smtp");
   xmlnode_put_attrib(jtin->roster_files,"xmlns","jabber:rosterfiles:smtp");

   if ((jtin->roster=xmlnode_file(jtin->roster_file))==NULL)
      { // file not exist or any other bug
      jtin->roster=xmlnode_new_tag_pool(jtin->i->p,"smtp");
      xmlnode_put_attrib(jtin->roster,"xmlns","jabber:roster:smtp");
      log_warn("smtp","Transport cannot load roster file (%s)", jtin->roster_file);
      }  
   else
      {
      // build file list from roster.xml
      for (loFile = xmlnode_get_firstchild(jtin->roster); loFile != NULL; loFile = xmlnode_get_nextsibling(loFile))
          {
          if (loFile->type!=NTYPE_TAG)
              continue;

          if ((loRF=xmlnode_file(xmlnode_get_data(loFile)))==NULL)
             {
             log_warn("smtp","Transport cannot read roster file %s",xmlnode_get_data(loFile));
             continue;
             }

          xmlnode_insert_node(jtin->roster_files,loRF);
          }
      }


   // recalc user's accounts by saved files
   lii=0;
   for (loFile = xmlnode_get_tag(jtin->roster_files,"file"); loFile != NULL; loFile = xmlnode_get_nextsibling(loFile))
       {
       if (loFile->type!=NTYPE_TAG)
          continue;

       // walk all jid in file
       for (loJID = xmlnode_get_tag(loFile,"item"); loJID != NULL; loJID = xmlnode_get_nextsibling(loJID))
           {
           if (loJID->type!=NTYPE_TAG)
               continue;

           lii++;
           }
       }
   xmlnode_put_attrib(jtin->statistics,"CoreAccounts",smtp_itoa(lii));


   // main body
   if ((jtin->me = xmlnode_get_tag_data(jtin->config,"jabber/mxhost")) == NULL)
      {
      log_error("smtp","Transport must have a default SMTP <mxhost>smtp.host.foo</mxhost> configured");
      return;
      }

   if ((cur=xmlnode_get_tag(jtin->config,"smtp/open")) == NULL || xmlnode_get_data(cur)==NULL )
      jtin->open = 1;



   // relay smtp server
   cur = xmlnode_get_tag(jtin->config,"jabber/relay");
   jtin->relayport=j_atoi(xmlnode_get_attrib(cur, "port"), SMTP_Relay_Port);

   if((jtin->relay = xmlnode_get_attrib(cur,"ip")) == NULL)
       jtin->relay = pstrdup(i->p, SMTP_DEFAULT_RELAY);

   register_phandler(i, o_DELIVER, smtp_out_packets, (void *)jtin);


   jtin->spamcheck = xmlnode_get_tag_data(jtin->config,"smtp/spamcheck");


   // vytvoit vlastn thread
   if ((cur = xmlnode_get_tag(config,"smtp/ip")) != NULL)
      for (;cur != NULL; xmlnode_hide(cur), cur = xmlnode_get_tag(config,"smtp/ip"))
          {
          mio_listen(j_atoi(xmlnode_get_attrib(cur, "port"), SMTP_Incomming_Port), xmlnode_get_data(cur), smtp_in_read, (void*)jtin, NULL, NULL);
          }
   else // no special config, use defaults //
      mio_listen(SMTP_Incomming_Port, NULL, smtp_in_read, (void *)jtin, NULL, NULL);
 
   // JEP-0033 test
   cur = xmlnode_get_tag(jtin->config,"core/map");
   jep0033= xmlnode_new_tag("iq");
   xmlnode_put_attrib(jep0033,"to",xmlnode_get_attrib(cur, "jabber"));
 
   xmlnode_put_attrib(jep0033,"from",jtin->met);
   xmlnode_put_attrib(jep0033,"type","get");
   xmlnode_put_attrib(jep0033,"id","smtp_test_jep0033");
   xmlnode_put_attrib(xmlnode_insert_tag(jep0033,"query"),"xmlns","http://jabber.org/protocol/disco#info");

   deliver(dpacket_new(xmlnode_dup(jep0033)),i);
   xmlnode_free(jep0033);


   smtp_StatsSetDelta("Start",1);
   lcPom = (char*)pmalloc_x(p, 18,' ');
   smtp_GetDateTime((char *)lcPom);
   smtp_StatsSaveValue("StartLastDatetime",(char *)lcPom);
   log_notice("smtp","Transport loaded - %s.",lcPom);

   if ((cur=xmlnode_get_tag(jtin->config,"jabber/offline"))!=NULL)
      register_beat(j_atoi(xmlnode_get_attrib(cur,"interval"),1)*60 , smtp_offline_daemon, (void *) 1);

   if ((cur=xmlnode_get_tag(jtin->config,"core/paid"))!=NULL)
      register_beat(j_atoi(xmlnode_get_attrib(cur,"interval"),1)*3600 , smtp_paid_daemon, (void *)jtin);

   pool_free(p);
   }

smtps smtp_new_out(mio m)
   {
   smtps so;

   so = pmalloco(mio_pool(m), sizeof(_smtps));
   so->m = m;
   so->p = mio_pool(m);
   so->x=so->oJID=so->oAD=NULL;
   
   so->toPGPMIME=so->SRMode=0;
   so->SRSeparator=so->SRText=NULL;
   return so;
   }


smtpsi smtp_new_in(mio m)
   {
   smtpsi si;
   si = pmalloco(mio_pool(m), sizeof(_smtpsi));
   si->m = m;
   si->p = mio_pool(m);
   si->message = spool_new(si->p);
   return si;
   }

smtpp smtp_param_i(pool p,instance i)
   {
   smtpp par;
   par=pmalloco(p, sizeof(_smtpp));
   par->tmppool=p;
   par->i = i;

   return par;
   }


smptsi_rcp smtp_NewRecipient(pool p,jid ojid)
   {
   smptsi_rcp rcp;

   rcp=pmalloco(p, sizeof(_smptsi_rcp));
   rcp->rcpt=ojid;
   rcp->next=NULL;
   return rcp;
   }

smptsi_rcp smtp_AppendRcpt(smptsi_rcp a, smptsi_rcp b)
   {
   smptsi_rcp next;

   if (a == NULL)
      return NULL;

   if (b == NULL)
      return a;

   next = a;
   while(next != NULL)
        {
        if (next->next != NULL)
           next = next->next;
        else
           {
           next->next = b;
           break;
           }
        }
   return a;
   }

smtp_jq smtp_NewQueueItem(pool p, int liType)
   {
   smtp_jq item;
   item=pmalloco(p, sizeof(_smtp_jq));
   switch (liType)
      {
	  case SMTP_QUEUE_X:
           item->Data=pmalloco(p, sizeof(_smtp_jq_x));
           break;

	  case SMTP_QUEUE_CB:
           item->Data=pmalloco(p, sizeof(_smtp_jq_cb));
           break;
      }

   item->iType=liType;
   item->next=NULL;
   return item;
   }


smtp_jq smtp_AppendQueueItem(smtp_jq a, smtp_jq b)
   {
   smtp_jq next=a;

   if (a == NULL)
      return NULL;

   if (b == NULL)
      return a;

   while(next != NULL)
        {
        if (next->next != NULL)
           next = next->next;
        else
           {
           next->next = b;
           break;
           }
        }
   return b;
   }





void smtp_FlushQueue(instance i, smtp_jq item)
   {
   smtp_jq next = item;
   smtp_jq_cb item_cb; 
   smtp_jq_x item_x; 

   while(next != NULL)
        {
        switch (next->iType)
           {
	       case SMTP_QUEUE_X:
                (smtp_jq_x) item_x= (smtp_jq_x) next->Data;
                deliver(dpacket_new(xmlnode_dup(item_x->x)),i);
                xmlnode_free(item_x->x);
                break;

  	       case SMTP_QUEUE_CB:
                (smtp_jq_cb) item_cb= (smtp_jq_cb) next->Data;
                (*(smtp_queue_cb)item_cb->cb)(item_cb->arg);
                break;
           }

        next = next->next;
        }
   }


