#include <jabberd.h>

#include <time.h>
#include <stdio.h>
#include <math.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <dirent.h>

//#include <iconv.h> // http://mir.zyrianes.net/cygwin/release/libiconv/

#define smtp_version "0.5.9.004"
#define smtp_name    "Jabber-SMTP-Transport"


#include "rc_strings.h"

#define MAXLOOP      100000

#define PHASE_NONE -1
#define PHASE_SEND 0
#define PHASE_CMD 1
#define PHASE_DATA 2

#define CMD_UNKNOWN -1
#define CMD_NONE 0
#define CMD_HELO 1
#define CMD_MAIL 2
#define CMD_RCPT 3
#define CMD_DATA 4
#define CMD_NOOP 5
#define CMD_RSET 6
#define CMD_QUIT 7
#define CMD_DATA2 8
#define CMD_RCPTE 31
#define CMD_DATAEND 32
#define CMD_EHLO 9

#define MIME_7BIT 0
#define MIME_8BIT 1
#define MIME_BINARY 2
#define MIME_QUOTED 3
#define MIME_BASE64 4


#define SPAM_OK          0
#define SPAM_NotDefined  1
#define SPAM_Error430   -1
#define SPAM_Error570   -2

#define SMTP_Relay_Port       25
#define SMTP_Incomming_Port 5225

#define NS_DATA  "jabber:x:data"



#define SMTP_BACKUPSMTP_FOLDER         "./spool/smtp/smtp-b"
#define SMTP_BACKUPJABBER_FOLDER       "./spool/smtp/jabber-b"
#define SMTP_OFFLINESMTP_FOLDER         "./spool/smtp/smtp-o"
#define SMTP_OFFLINEJABBER_FOLDER       "./spool/smtp/jabber-o"

#define SMTP_STATISTICS_FILE           "./spool/statistics.xml"
#define SMTP_RESOURCE_FILE             "./smtp/resources.xml"
#define SMTP_ROSTER_FILE               "./spool/smtp/roster/roster.xml"
#define SMTP_CONFIG_FILE             "./smpt/config.xml"

#define SMTP_DEFAULT_RELAY             "localhost"


#define SMTP_PGP_ATTACH 0
#define SMTP_PGP_MIME   1
#define SMTP_PGP_NOMIME 2


#define SMTP_PGP_MESSAGE         "PGP MESSAGE"
#define SMTP_PGP_SIGNATURE       "PGP SIGNATURE"
#define SMTP_PGP_SIGNED_MESSAGE  "-----BEGIN PGP SIGNED MESSAGE-----"
#define SMTP_PGP_BEGIN           "-----BEGIN"
#define SMTP_PGP_END             "-----END"

#define SMTP_PGP_sBEGIN          "BEGIN"
#define SMTP_PGP_sEND            "END"
#define SMTP_PGP_MESSAGE_BEGIN   "-----BEGIN PGP MESSAGE-----"
#define SMTP_PGP_SIGNATURE_BEGIN "-----BEGIN PGP SIGNATURE-----"
#define SMTP_PGP_MESSAGE_END     "-----END PGP MESSAGE-----"
#define SMTP_PGP_SIGNATURE_END   "-----END PGP SIGNATURE-----"


#define SMTP_IN_DELIVER_ALL    0
#define SMTP_IN_DELIVER_GLOBAL 1
#define SMTP_IN_DELIVER_USER   2


#define SMTP_ADMIN_JID   0
#define SMTP_ADMIN_EMAIL 1

#define SMTP_ADMIN_NS_JID   "smtp:admin:jid"
#define SMTP_ADMIN_NS_EMAIL "smtp:admin:email"



#define SMTP_CODE_220 220
#define SMTP_CODE_221 221
#define SMTP_CODE_250 250
#define SMTP_CODE_251 251
#define SMTP_CODE_354 354
#define SMTP_CODE_404 404
#define SMTP_CODE_500 500
#define SMTP_CODE_504 504
#define SMTP_CODE_550 550
#define SMTP_CODE_552 552

#define SMTP_DB


#define SMTP_QUEUE_X   0
#define SMTP_QUEUE_CB  1

/* smtp parser instance */
typedef struct smtpi_struct
{
   instance i;
   char *server; /* our master server address, if any */
   char *relay; /* the smtp relay delivering our messages for us */
   int relayport; /* the smtp relay port */
//   int timeout; /* how long to wait for an incoming request */
   char *me; /* our default smtp hostname */
   char *met; /* our default smtp transport JID */
   int open; /* if this component is wide open */
   char *spamcheck;
   int jep0033; /* JEP-0033: Extended Stanza Addressing, support */ 
   xmlnode config;
   xmlnode status;
   xdbcache xc;

   int JabberMessages,JabberMessagesOut,JabberMessagesOutError,
       SMTPCommandUnknown,SMTPMessages,
	   SMTPMessagesIn,SMTPMessagesInError,
       SMTPSpam, CoreContacts, CoreContactsOnline, CoreAccounts;


   int tmpBackupJabber,tmpBackupSMTP;
   int tmpOfflineJabber,tmpOfflineSMTP;

   char *config_file; /* config file name */
   char *stat_file; /* Statistics file name */
   char *res_file; /* Resources file name */
   char *roster_file; /* Roster file name */
   char *roster_folder; /* Roster folder */

   char *DefaultLang; /* Default language */

   char cSMTP_Status[20];
   char cJabber_Status[20];

   xmlnode statistics; /* Statistics node */
   xmlnode resources; /* resources node */
   xmlnode roster; /* roster node */
   xmlnode roster_files; /* roster files node */
   xmlnode OnlineList; /* Online list */
   xmlnode OfflineList; /* Offline list */
} *smtpi, _smtpi;

/* our 'session' data  - jabber to smtp*/
typedef struct smtps_struct
{
   int phase, timer, lastcmd, iStatus, ircpt,mio_status;
   char *from;
   char *buffer;
   char *host;
   jid rcpt;
   mio m;
   pool p;
   xmlnode x, oJID, oAD;
   
   int toPGPMIME,Advertising,SRMode;
   char *SRSeparator, *SRText, *lang;
   
   jpacket jp; // incomming jabber packet
   instance i;
  
} *smtps, _smtps;



/* our 'session' data - smtp to jabber*/
typedef struct smptsi_rcp_struc
{ 
   jid rcpt;
   xmlnode oJID;
   int Advertising,nonMIME2x,Attachments,UseGlobalSettings,SRMode,S2J_AllAreSPAM;
   char *SRSeparator, *SRText, *smtpaddr;

   struct smptsi_rcp_struc *next; /* for lists of recipients */
} *smptsi_rcp,_smptsi_rcp;


typedef struct smtpsi_struct
{
   int phase, timer, lastcmd ;
   char *from;
   char *buffer;
   char *host;
   char *listcc;
   char *listto;
   char *MBody;
   spool message;

   void *rcpt;

   mio m;
   pool p;
   xmlnode x;
   int iPGP;
   xmlnode oAD;
} *smtpsi, _smtpsi;


/* our 'session' data */
typedef struct smtp_param
{
   jpacket jp; // incomming jabber packet
   dpacket dp; // incomming jabber delivery packet
   pool tmppool;
   char *lang;

   instance i;
} *smtpp, _smtpp;

typedef struct smtpsx_struct
{
 smtpp par;
 smtps so;
 pool p;
 int state;
 char *cBFile;
} *smtpsx, _smtpsx;


/* context for MIME decoding */
typedef struct mimectx_struct
{
   int mimeUsed;
   int mimeEncoding;
   char *mimeCharset;
} *mimectx, _mimectx;


typedef struct smtp_jabber_queue_struc_x
{
xmlnode x; // xmlnode
} *smtp_jq_x,_smtp_jq_x;

typedef struct smtp_jabber_queue_struc_cb
{
void *cb; 
void *arg; 
} *smtp_jq_cb,_smtp_jq_cb;

typedef struct smtp_jabber_queue_struc
{
struct smtp_jabber_queue_struc *next; /* next queue item */
void *Data;
int iType;

} *smtp_jq,_smtp_jq;



typedef struct smtp_thread_universal
{
   pool p;
   mtq  q;
   int *index;
} *smtp_tu, _smtp_tu;



// smtp.c
smtps smtp_new_out(mio m);
smtpsi smtp_new_in(mio m);
smtpp smtp_param_i(pool p,instance i);

void smtp_SendInfoToAdmin(const char *lcMSG);

smptsi_rcp smtp_NewRecipient(pool p,jid ojid);
smptsi_rcp smtp_AppendRcpt(smptsi_rcp a, smptsi_rcp b);

jid smtp_2mx(jid id);
jid smtp_mx2(jid id);


typedef void (*smtp_queue_cb)(void *arg);

smtp_jq smtp_NewQueueItem(pool p, int liType);
smtp_jq smtp_AppendQueueItem(smtp_jq a, smtp_jq b);
void smtp_FlushQueue(instance i, smtp_jq item);

// roster.h
xmlnode smtp_roster_get_item(pool p, char *lcJID, int liDefault);
void smtp_roster_set_item(pool p, char *lcJID, xmlnode loJID);
void smtp_roster_remove_item(pool p, char *lcJID);
int smtp_online_add_item(pool p, char *lcFrom, char *lcTo);
int smtp_online_remove_item(pool p, char *lcFrom, char *lcTo);


// in.c
void smtp_in_read(mio m, int state, void *arg, char *buffer,int bufsz);
void smtp_in_status(smtpsi si, int liStatus, char *data);

// in_spam.c
int smtp_in_spam(smtpsi si, char *msg);


// out.c
result smtp_out_packets(instance i, dpacket p, void *arg);
void smtp_out_Xcleanup(void *arg);

// out_iq.c
int smtp_out_packets_iq(smtpp par, char *lcType);

// out_iq_register.c
int smtp_out_packets_iq_register(smtpp par, char *type);

// out_iq_vcard.c
int smtp_out_packets_iq_vcard(smtpp par, char *type);

// out_iq_gateway.c
int smtp_out_packets_iq_gateway(smtpp par, char *type);

// out_iq_time.c
int smtp_out_packets_iq_time(smtpp par, char *type);

// out_iq_version.c
int smtp_out_packets_iq_version(smtpp par, char *type);

// out_iq_di.c
int smtp_out_packets_iq_di(smtpp par, char *type);

// out_iq_stats.c
int smtp_out_packets_iq_stats(smtpp par, char *type);

// out_presence.c
int smtp_out_packets_presence(smtpp par, char *lcType);

// out_mesage.c
int smtp_out_packets_message(smtpp par, char *lcType);

// out_admin.c
int smtp_admin_message(smtpp par, char *lcType);

// out_S10N.c
int smtp_out_packets_S10N(smtpp par, char *lcType);



// offline.c
result smtp_offline_daemon(void *arg);

// paid.c
result smtp_paid_daemon(void *arg);


// utils.c
char *smtp_alltrim(char *lcChar);
char *smtp_lgstrim(char *lcChar);
char *smtp_strcasestr(char *lcWhere,char *lcWhat);
char *smtp_CMonth(int liMonth);
char *smtp_itoa(int liNumber);
xmlnode out_SetReply(xmlnode loNew, xmlnode loOld);
void smtp_ReplyError(instance i, jpacket loOrig, const char *lcNodeName, const char *lcBody, int liError);
void smtp_StatsInc(const char *lcStatName);
void smtp_StatsDec(const char *lcStatName);
void smtp_StatsSetDelta(const char *lcStatName, int liDelta);
void smtp_StatsSaveValue(const char *lcStatName,char *lcValue);
char *smtp_GetDateTime(char *lcDateTime);
char *smtp_GetFolderFromFile(char *lcFolder);
int smtp_CreateFolder(char *lcFolder);
void smtp_xmlnode_move_node(xmlnode loNode, xmlnode loParentOld, xmlnode loParentNew);
char *smtp_rc_GetString(pool p,char *lcLang, int liID);
char *smtp_GetSMTPAddress(char *lcJID);
char *smtp_GetJID(pool p,char *lcJID);
char *smtp_ToUTF8(pool p, char *lcText,const char *charmap);
void fromQP(char *string, void *byteStream);
void toQP(char *string, void *byteStream, int liSoftLines, const char *lcSpec);
void toEscape(char *string, void *byteStream, const char *lcSpec);
void fromEscape(char *string, void *byteStream);
//void smtp_TEST(smtpp par, jpacket loOrig);

