#include "smtp.h"

/* smtp->jabber */

extern smtpi jtin;


/* ensure that data is 7 bit */
char *smtp_mime_check7bit(smtpsi si, mimectx ctx, char *str)
   {
   char *ptr;

   if (!(ctx->mimeEncoding == MIME_7BIT || ctx->mimeEncoding == MIME_QUOTED || ctx->mimeEncoding == MIME_BASE64))
   return str;

   for (ptr=str; ptr && *ptr; ptr++)
  	   *ptr |= 0x7f;

   return str;
   }

/* convert a string to UTF-8 encoding */
char *smtp_mime_toUTF8(smtpsi si, mimectx ctx, char *str)
   {
   char *ptr;
   if (strcasecmp(ctx->mimeCharset, "utf-8")==0)
      return str;

   /* XXX this is not correct handling */
   for (ptr=str; ptr && *ptr; ptr++)
  	   if (*ptr>126 || *ptr<1)
	      *ptr = ' ';

   return str;
   }

/* decode a quoted printable string line */
char *smtp_mime_decode_quoted(smtpsi si, mimectx ctx, char *str)
   {
   char *tmp;
   tmp = (char*)pmalloco(si->p, j_strlen(str)+1);
   fromQP(str, (void *) tmp);
   if (strcasecmp(ctx->mimeCharset, "utf-8")==0)
      return tmp;
   else
      return smtp_mime_toUTF8(si, ctx, tmp);
   }

/* decode a base64 encoded string */
char *smtp_mime_decode_base64(smtpsi si, mimectx ctx, char *str)
   {
   str_b64decode(str);
   if (strcasecmp(ctx->mimeCharset, "utf-8")==0)
      return str;
   else
      return smtp_mime_toUTF8(si, ctx, str);
   }

/* decode a mime encoded string */
char *smtp_mime_decode(smtpsi si, mimectx ctx, char *str)
   {
   if (!ctx->mimeUsed)
	  return str;

   switch (ctx->mimeEncoding)
      {
	  case MIME_7BIT:
//	       smtp_mime_check7bit(s, ctx, str);
	       return str;

 	  case MIME_8BIT:
	       return smtp_mime_toUTF8(si, ctx, str);

	  case MIME_BINARY:
	       /* XXX how to handle binary encoded data? */
	       return smtp_mime_toUTF8(si, ctx, str);

	  case MIME_QUOTED:
	       return smtp_mime_decode_quoted(si, ctx, str);

	  case MIME_BASE64:
	       return smtp_mime_decode_base64(si, ctx, str);

	  default:
	       log_warn("smtp", "Invalid mimeEncoding in mimectx: %i", ctx->mimeEncoding);
	       return smtp_mime_toUTF8(si, ctx, str); // you must remove non ASCII characters
      }
   return str;
   }


char *smtp_in_getaddr(pool p, char *str)
   {
   char *cur, *top;
   int isaddr = 0;

   SMTP_DEBUG(SMTP_ZONE,"searching for an address in: %s",str);

   for (top = cur = pstrdup(p,str);cur != NULL && *cur != '\0';cur++)
       {
       /* can't grok invalid chars in an address */
       if (index(SMTP_JID_ICHS,*cur) != NULL)
          {
          /* we've hit an invalid char at the end of a valid address, snip it and quit */
          if (isaddr)
             {
             *cur = '\0';
             break;
             }
          top = cur + 1;
          continue;
          }

       /* yay, a @ after some valid chars, it's an address! (or so we hope) */
       if (*cur == '@')
          {
          *cur = '%'; /* escape it, of course */
          isaddr = 1;
          continue;
          }
       }

   if (isaddr)
      {
      SMTP_DEBUG(SMTP_ZONE,"we've found something we think is an address: %s",top);
      return top;
      }

   SMTP_DEBUG(SMTP_ZONE,"nothing of concequence found");
   return NULL;
   }


char *smtp_in_getaddrex(pool p, char *str)
   {
   char *cur, *top;
   int isaddr = 0;

   SMTP_DEBUG(SMTP_ZONE,"searching for an address in: %s",str);

   for (top = cur = pstrdup(p,str);cur != NULL && *cur != '\0';cur++)
       {
       /* can't grok invalid chars in an address */
       if (index(SMTP_JID_ICHS,*cur) != NULL)
          {
          /* we've hit an invalid char at the end of a valid address, snip it and quit */
          if (isaddr)
             {
             *cur = '\0';
             break;
             }
          top = cur + 1;
          continue;
          }

       /* yay, a @ after some valid chars, it's an address! (or so we hope) */
       if (*cur == '@')
          {
          isaddr = 1;
          continue;
          }
       }

   if (isaddr)
      {
      SMTP_DEBUG(SMTP_ZONE,"we've found something we think is an address: %s",top);
      return top;
      }

   SMTP_DEBUG(SMTP_ZONE,"nothing of concequence found");
   return NULL;
   }


/* send an outgoing line to the connection */
void smtp_in_status(smtpsi si, int liStatus, char *data)
   {
   char *lcOut,*istr;
   pool p;

   p = pool_new();
   smtp_PoolsReg(12, p);
   istr= (char *) pmalloc_x(p,18,' ');
   sprintf(istr,"%d ",liStatus);

   lcOut = spools(p,istr,data,"\r\n",p);
   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"SMTP-OUT: %s",lcOut);
   #else
    SMTP_DEBUG(SMTP_ZONE,"SMTP-OUT:");
   #endif
   mio_write(si->m,NULL,lcOut,-1);
   pool_free(p);
   }



/* decode the incoming commands */
void smtp_in_cmd(smtpsi si, int liCmd, char *addr)
   {
   jid id;
   smptsi_rcp rcpt;
   char *bkt,*tmp,*lcJID=NULL,*lcFrom;
   xmlnode loJID=NULL;
   smtp_cjid loItem;
   int liUseGlobalSettings,liS2J_AllAreSPAM,liFail,liSpamer=0;
   pool p;
   smtpp par;

   /* we only accept 7 bit characters in SMTP commands */
   for (bkt = addr; bkt && *bkt; bkt++)
	   if (*bkt > 126 || *bkt < 32)
	      *bkt = ' ';

   if (addr != NULL)
      {
      bkt = strstr(addr,"<");
      if (bkt != NULL) addr = bkt + 1;
         bkt = strstr(addr,">");
      if(bkt != NULL) *bkt = '\0';
      }

   SMTP_DEBUG(SMTP_ZONE,"command %d with data %s",liCmd,addr);

   switch(liCmd)
      {
      case CMD_HELO:
           smtp_in_status(si, SMTP_CODE_250, "Hi.");
           break;

      case CMD_EHLO:
           smtp_in_status(si, SMTP_CODE_250, "Hi.");
           break;

      case CMD_MAIL:
           si->from = pstrdup(si->p,addr);
           smtp_in_status(si, SMTP_CODE_250, "Ok");
           jtin->Stats->SMTPMessages++;
           jtin->Stats->_SMTPMessages++;
           smtp_StatsSave();
           break;

      case CMD_RCPT:
           // S:2005-08-31 gorila@dione.zcu.cz
           // Alltrim(), remove spaces from left and right sides

           addr=smtp_alltrim(addr);
           tmp = (char*)pmalloco(si->p, j_strlen(addr)+1);
           fromEscape(addr, (void *) tmp);
           id = smtp_mx2(jid_new(si->p,tmp));
           rcpt = smtp_NewRecipient(si->p,id);
           rcpt->smtpaddr=smtp_alltrim(addr); // original smtp address

           // Get roster item about recipient
           if (id != NULL)
              {
              lcJID=jid_full(id);
              loJID=smtp_roster_get_item(lcJID,0);
              }

           lcFrom = (char*)pmalloco(si->p, j_strlen(si->from)+1);
           fromEscape(si->from, (void *) lcFrom);
           // check for spammer list
           liFail=-1; // Any bug
           if (jtin->Spamer_Open==1)
              liSpamer=0;
           else
              liSpamer=smtp_check_list(lcFrom,xmlnode_get_tag(jtin->config,"smtp/spamer/item"));

           // check for acount spammer list
           if (liSpamer!=1 && loJID!=NULL)
              liSpamer=smtp_check_list(lcFrom,xmlnode_get_tag(loJID,"spamlist/item"));

           // E:2005-08-31 gorila@dione.zcu.cz
           if (liSpamer!=1 && id != NULL)
              {
              if (loJID== NULL &&
                  j_atoi(xmlnode_get_tag_data(jtin->config,"smtp/registered"),0)==1)
                 {
                 jtin->Stats->SMTPMessagesInError++;
                 jtin->Stats->_SMTPMessagesInError++;
                 smtp_StatsSave();
                 log_warn("smtp","%i - Bad Address - must be register",SMTP_CODE_553);
                 if (xmlnode_get_tag(jtin->config,"smtp/forwarde/item=553")!=NULL)
                    liFail=553;
                 }
              else              
                 {
                 liUseGlobalSettings=1;
                 liS2J_AllAreSPAM=j_atoi(xmlnode_get_data(xmlnode_get_tag(jtin->config,"smtp/allmessagesarespam")),0);
                 if (loJID!=NULL)
                    liUseGlobalSettings=j_atoi(xmlnode_get_attrib(loJID,"UseGlobalSettings"),1);

                 if (loJID!=NULL && liUseGlobalSettings==0)
                    liS2J_AllAreSPAM=j_atoi(xmlnode_get_attrib(loJID,"S2J_AllAreSPAM"),0);

// testy na bouncy... rozdli na dv sti
// pokud je bouncy povolen, pak slo, jinak nastavit -1
                 if (liS2J_AllAreSPAM==1)
                    {
                    if (xmlnode_get_tag(jtin->config,"smtp/forwarde/item=450")!=NULL)
                        liFail=450;
                    }
                 else if (liS2J_AllAreSPAM==2)
                    {
                    // nem seznam kontakt... pry
                    if ((loItem=smtp_cjidGet(lcJID))==NULL)
                       {
                       if (xmlnode_get_tag(jtin->config,"smtp/forwarde/item=450")!=NULL) // find item in list
                          liFail=450;
                       }
                         
                    else if (xmlnode_get_tag(loItem->item,spools(si->p,"to=",smtp_in_getaddr(si->p,lcFrom),"@",jtin->met,si->p))==NULL)
                            {
                            if (xmlnode_get_tag(jtin->config,"smtp/forwarde/item=450")!=NULL) // find contact item in list
                               liFail=450;
                            }
                    else
                       liFail=0;
                    }
                 else
                    liFail=0;

                 }
              }

           if (liSpamer!=1 && id == NULL)
              {
              jtin->Stats->SMTPMessagesInError++;
              jtin->Stats->_SMTPMessagesInError++;
              smtp_StatsSave();
              log_warn("smtp","%i - Bad Address",SMTP_CODE_550);
              if (xmlnode_get_tag(jtin->config,"smtp/forwarde/item=550")!=NULL)
                 liFail=550;
              }

           if (liFail>0)
              {
              rcpt->iErr=liFail;
              if (si->rcptFD == NULL)
                 si->rcptFD=rcpt;
              else
                 smtp_AppendRcpt(si->rcptFD,rcpt);
              }

           if (liFail==0)
              {
              if (si->rcpt == NULL)
                 si->rcpt=rcpt;
              else
                 smtp_AppendRcpt(si->rcpt,rcpt);
              }

           smtp_in_status(si, SMTP_CODE_250, "Ok");
           break;

      case CMD_DATA:
           if (si->rcptFD!=NULL ) // any recipient is bad
              {
              p=pool_new();   
              par= smtp_param_i(p,jtin->i);
              smtp_PoolsReg(3, p);

              smtp_out_process_message(par, (void*) smtp_in_recipient_cb, (void*) si, (void*) smtp_in_recipient_cbf, (void*) si);
              }

           if (si->rcpt==NULL && si->rcptFD==NULL) // all recipients are bad, but nothing for receinving
              {
              smtp_in_status(si, SMTP_CODE_554, "Message not accepted");
              }

           if (si->rcpt!=NULL) // any recipients are...
              {
              si->phase = PHASE_DATA;
              si->x = xmlnode_new_tag_pool(si->p,"message");
              if (si->rcptFD==NULL) // potvrd to jen tehdy, kdy jsou vichni validn
                 smtp_in_status(si, SMTP_CODE_354, "Feed me");
              }
           break;

      case CMD_RSET:
           si->x = NULL;
           si->rcpt = NULL;
           free(si->buffer); // Free internal buffer
           smtp_in_status(si, SMTP_CODE_250, "Boring");
           break;

      case CMD_NOOP:
           smtp_in_status(si, SMTP_CODE_250, "Boring");
           break;
 
      case CMD_QUIT:
           snprintf(jtin->cSMTP_Status, 20, "\0");
           smtp_in_status(si, SMTP_CODE_221, "Bye");
           break;

  	  default:
           smtp_in_status(si, SMTP_CODE_500, "Duh");
      }
   }

int smtp_cmd_parse(char *lcCmd)
   {
   SMTP_DEBUG(SMTP_ZONE, "parsing command %s", lcCmd);

   if(strcasecmp(lcCmd,"HELO") == 0) return CMD_HELO;
   if(strcasecmp(lcCmd,"MAIL") == 0) return CMD_MAIL;
   if(strcasecmp(lcCmd,"RCPT") == 0) return CMD_RCPT;
   if(strcasecmp(lcCmd,"DATA") == 0) return CMD_DATA;
   if(strcasecmp(lcCmd,"NOOP") == 0) return CMD_NOOP;
   if(strcasecmp(lcCmd,"RSET") == 0) return CMD_RSET;
   if(strcasecmp(lcCmd,"QUIT") == 0) return CMD_QUIT;
   if(strcasecmp(lcCmd,"EHLO") == 0) return CMD_EHLO;
   if(j_strlen(lcCmd) == 0) return CMD_NONE;

   return CMD_UNKNOWN;
   }


// S:2005-06-03 gorila@dione.zcu.cz
// Return command separator
char *smtp_cmd_sep(int liCmd)
   {
   if(liCmd == CMD_HELO) return " ";
   if(liCmd == CMD_EHLO) return " ";
   if(liCmd == CMD_MAIL) return ":";
   if(liCmd == CMD_RCPT) return ":";
   if(liCmd == CMD_DATA) return " ";
   if(liCmd == CMD_NOOP) return " ";
   if(liCmd == CMD_RSET) return " ";
   if(liCmd == CMD_QUIT) return " ";

   return " ";
   }
// E:2005-06-03 gorila@dione.zcu.cz



/* when the connection dies, clean up the mess */
void smtp_in_cleanup(void *arg)
   {
   smtpsi si = (smtpsi)(arg);
   int liIndex=smtp_Pools(0,0,si->p);
   log_notice("smtp","DEALLOC MEMORY - pool: %i, %i",si->p,liIndex);

   if (si != NULL)
      free(si->buffer);
   }

void smtp_in_AddAdversiting(smtpsi si, smptsi_rcp rcpt, xmlnode loBody)
   {
   if (rcpt->Advertising==1)
      {
      xmlnode_insert_cdata(loBody,"\r\n",-1);
      xmlnode_insert_cdata(loBody,xmlnode_get_data(si->oAD),-1);
      }

   }

void smtp_in_SubjectReplace(smtpsi si, smptsi_rcp rcpt, char *lcSubject, xmlnode loSubject)
   {
   int liLOS=j_strlen(lcSubject),liLNS=j_strlen(rcpt->SRText) ;

   if ((liLOS>0 && liLNS==0 && (rcpt->SRMode==2 || rcpt->SRMode==1)) || (rcpt->SRMode==0 && liLOS>0)) // if  empty and replace is 2 or 1
      {
      xmlnode_insert_cdata(loSubject,lcSubject,-1);
      return;
      }

   SMTP_DEBUG(SMTP_ZONE,"DATA - replace subject %i",rcpt->SRMode);
   if (rcpt->SRMode!=0 && liLNS>0 && liLOS==0 && rcpt->SRMode==3)
      {
      xmlnode_insert_cdata(loSubject,spools(si->p,rcpt->SRText,si->p),-1);
      return;
      }

   if (rcpt->SRMode!=0 && liLNS>0 && liLOS>0 && rcpt->SRMode==1) // if not empty and replace is 1
      {
      xmlnode_insert_cdata(loSubject,spools(si->p,rcpt->SRText," ",rcpt->SRSeparator," ",lcSubject,si->p),-1);
      return;
      }

   if (rcpt->SRMode!=0 && liLNS>0 && liLOS>0 &&  rcpt->SRMode==2) // if not empty and replace is 2
      {
      xmlnode_insert_cdata(loSubject,spools(si->p,lcSubject," ",rcpt->SRSeparator," ",rcpt->SRText,si->p),-1);
      return;
      }
 
   }

/* extract a value from header line*/
char *smtp_in_GetHeaderLineValue(smtpsi si, char *lcLine, const char *lcAttrib)
   {
   int liLen;
   char *lcRet,*liS,*liE,*liSX;
   if (j_strlen(lcLine)==0)
       return (char *) NULL;

   if (lcAttrib=="") // get basic value
      {
      liS=lcLine;
      liE=strstr(liS,";");
      liLen=(liE==NULL)?j_strlen(lcLine):(int) (liE-liS);
      }
   else // get attrib value
      {
      liS=smtp_strcasestr(lcLine,(char *)lcAttrib); // find attrib


      if (liS==NULL) // attrib not found
         return NULL;

      liS=strstr(liS+strlen(lcAttrib),"="); // find =
      if (liS==NULL) // Not found, m po prdeli
         return NULL;

      liSX=strstr(liS+1,"\""); // find "
      if (liSX!=NULL) 
         {
         liS=liSX+1;
         liE=strstr(liS,"\""); // found end of value assignment
         if (liE==NULL) // Not found, m po prdeli
            return NULL;
         }
      else
         {
         liS++;
         liE=strstr(liS,";"); // found end of value assignment
         }

      liLen=(liE==NULL)?(j_strlen(lcLine)- ((int)(liS-lcLine)) ):(liE-liS);
      }


   lcRet = pmalloc(si->p, liLen+1);
   lcRet[liLen] = '\0';
   strncpy(lcRet, liS, liLen);
   return lcRet;
   }

/* extract a header line from the received message */
int smtp_in_header(smtpsi si, char *msg, char *header, int structured, spool sp, int *liNextLine)
   {
   char *linebegin = msg;
   char *lineend = strchr(linebegin, '\n');
   char *liS,*liE,*liAtt;
   char *tbuf,*ptr;
   size_t hlen,liLen;
   int liNext=0,liSep,liRow=1,liEnd=0;
   *liNextLine=0;

   if (header == NULL)
	  return 0;

   hlen = strlen(header);

   /* Handle headerlines that are splitted to multible lines */
   while (linebegin && lineend && lineend>linebegin && *linebegin!='\n' && *(linebegin+1)!='\n')
      { /* there is another headerline to process */
      // find while you don't find \r\n\r\n

      liS=linebegin;
      liE=lineend;
      liRow++;

      // find separator on line
      liE[0]='\0'; // End of string
      if ((liAtt=strstr(liS,"\""))==NULL)
         liAtt=strstr(liS,"\'");

      ptr=strstr(liS,":");
      liE[0]='\n';

      liSep=((ptr) && ptr<liE && (liAtt==NULL || (liAtt!=NULL && ptr<liAtt)))?1:0;

      if (liNext==1 && liSep==1) // next row + detect separator
         {
         *liNextLine=(int)(liS - msg);
         break; //
         }


  	  /* is it the header we are looking for? */
	  if ((liNext==1 && liSep==0) ||
          (strncasecmp(liS, header, hlen)==0 && liS[hlen]==':'))
	     { /* we found the header */


	     liS = liS+(liNext==1?0:hlen)+1;
         if (liE[0]=='\n')
            liE--;

	     /* skip space at the beginning of header content */
	     while (*liS == ' ' || *liS == '\t') liS++;
	     /* skip space at the end of the header content */
	     while (liE[-1] == ' ' || liE[-1] == '\t') liE--;

	     /* empty header? */
	     if (liE <= liS)
		    break;

	     /* return header content */
	     liLen = liE - liS + 1;
	     tbuf = pmalloc(si->p, liLen+1);
	     tbuf[liLen] = '\0';
	     strncpy(tbuf, liS, liLen);
         spooler(sp,tbuf,sp);
         liNext=1;
         // don't return
         // skip to next row
         if (liEnd==1)
            break;

	     }

         
	  /* continue with next header line */
	  linebegin = lineend + 1;
	  lineend = strchr(linebegin, '\n');
      if (lineend==NULL) // End of Data !!!
         {
         lineend=msg+j_strlen(msg)-1;
         liEnd=1;
         }
      }


   if (sp->len==0)
      return 0;

   /* XXX unescape MIME here */
   tbuf=spool_print(sp);

   /* headers are not allowed to contain non-ASCII in encoded form */
   for (ptr = tbuf; *ptr; ptr++)
       if (*ptr > 126 || *ptr < 32) *ptr = ' ';

   /* content in brackets is comment if it is a structured header */
   while (structured && (ptr = strchr(tbuf, '(')) != NULL)
         {
         char *commentend = strchr(ptr, ')');
         if (commentend == NULL)
            *ptr='\0';
         else
            {
		    size_t copylen;
		    size_t i;
		    copylen = strlen(commentend);

		    for (i=0; i<copylen; i++)
			    ptr[i] = commentend[i+1];
		    }
	     }

   sp=spool_new(si->p);
   spooler(sp,tbuf,sp);

   return sp->len;
   }

// parse mail body
char *smtp_in_ParsePGPBody(smtpsi si,char *lcBody, xmlnode loCBx,const char *lcPart, const char *lcDefPart)
   {
   char *lcCB,*lcStart=NULL;
   xmlnode loCB;
   for (loCB = xmlnode_get_firstchild(loCBx); loCB != NULL; loCB = xmlnode_get_nextsibling(loCB))
       {
       if (loCB->type!=NTYPE_TAG)
		   continue;

       if (loCB!=NULL)
	      {
          lcCB=xmlnode_get_data(loCB);
	      if (lcCB!=NULL)
             lcStart=strstr(lcBody, spools(si->p,"-----",lcPart," ",lcCB,"-----",si->p));
		  }

	   if (lcStart!=NULL)
          break;

       
	   }

   if (lcStart==NULL) // if not cbm or cb elements defined or is not found any cb
      lcStart=strstr(lcBody, lcDefPart);

   return lcStart;
   }


// parse mail body
int smtp_in_ParseMailBody(smtpsi si,mimectx ctx, char *lcBody, char *lcMBound, smptsi_rcp rcpt)
   {
   char *ptr,*lcBoundary, *lcLine, *lcLinetmp, *liS, *liE, *lcTmp, *lcCT, *lcMBody,
        *lcME, *lcDN,*lcProtocol,*liSM,*lcEndB;
   int  liNextLine;
   int liLen,liAttach=0,liRet;
   spool tmpsp;
   xmlnode loBody;
   // text/plain
   // ostatn pevst na utf-8 a pak na base64 + pidat pvodn type

   // multipart/mixed??
   // multipart/alternative??
   //  najt text/plain

   // 1. content type uruje tlo mailu
   // Content-type: multipart/alternative; boundary="gc0p4J:2408t"
   // nachzej se dal sti (text, html, soubory)

   // dal content typy uvnit tla uruj jednotliv sti
   // --gc0p4J:2408t
   // Content-type: plain/text; charset=
   // Content-type: plain/html; charset=

   // --gc0p4J:2408t--
   // konec tla sti

   // content type


   if (smtp_in_header(si, lcBody, "Content-Type", 0,tmpsp=spool_new(si->p),&liNextLine)==0)
      return 0;

   lcMBody=strstr((lcBody+liNextLine), "\n\n"); // Get Data section

   lcLine=spool_print(tmpsp);
   lcCT=smtp_in_GetHeaderLineValue(si,lcLine,""); // get basic value

   // check if is't multipart or  alternative
   if (strncasecmp(lcCT,"multipart/mixed",15)==0 ||
       strncasecmp(lcCT,"multipart/alternative",21)==0 ||
       strncasecmp(lcCT,"multipart/parallel",18)==0 ||
       strncasecmp(lcCT,"multipart/encrypted",19)==0 ||
       strncasecmp(lcCT,"multipart/signed",16)==0
      )
      {
      lcProtocol=smtp_in_GetHeaderLineValue(si,lcLine,"protocol"); // get protocol value
      SMTP_DEBUG(SMTP_ZONE,"BODY - get protocol %s",lcProtocol);

      if (lcProtocol!=NULL && si->iPGP==0 && strncasecmp(lcProtocol,"application/pgp-encrypted",25)==0) // PGP encrypted
         si->iPGP=1;

      if (lcProtocol!=NULL && si->iPGP==0 && strncasecmp(lcProtocol,"application/pgp-signature",25)==0) // PGP signed
         si->iPGP=2;

      SMTP_DEBUG(SMTP_ZONE,"BODY - Content Type Protocol %i",si->iPGP);

      lcBoundary=smtp_in_GetHeaderLineValue(si,lcLine,"boundary");
      if (j_strlen(lcBoundary)==0)
         return -1;

      lcBoundary=spools(si->p,"--",lcBoundary,si->p);

      if ((ptr=strstr(lcMBody,lcBoundary))==NULL) // BODY FAILED !!!
         return -1;

      if ((lcEndB=strstr(lcMBody,spools(si->p,lcBoundary,"--",si->p)))==NULL) // BODY FAILED !!!
         return -1;

      while ( ptr<lcEndB)
            {
            // reset for each boundary
            ctx->mimeEncoding = MIME_7BIT;
            ctx->mimeCharset = "us-ascii";

            liRet=smtp_in_ParseMailBody(si, ctx, ptr,lcBoundary,rcpt );
            if (liRet==-1) // BODY FAILED !!!
               return liRet;

            ptr=strstr(ptr+j_strlen(lcBoundary),lcBoundary);
            }
      return 1;
      }

   ctx->mimeEncoding = MIME_7BIT;
   ctx->mimeCharset = "us-ascii";

   loBody=xmlnode_get_tag(si->x,"body");
   xmlnode_insert_cdata(loBody,"\r\n",-1);

   // encoding for data
   SMTP_DEBUG(SMTP_ZONE,"BODY - get content-transfer-encoding");
   if (smtp_in_header(si, lcBody, "Content-Transfer-Encoding", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      {
      lcME=ptr=spool_print(tmpsp);

      if (!ptr)
         ctx->mimeEncoding = MIME_7BIT;
      else if (strcasecmp(ptr, "8bit")==0)
         ctx->mimeEncoding = MIME_8BIT;
      else if (strcasecmp(ptr, "7bit")==0)
         ctx->mimeEncoding = MIME_7BIT;
      else if (strcasecmp(ptr, "quoted-printable")==0)
         ctx->mimeEncoding = MIME_QUOTED;
      else if (strcasecmp(ptr, "base64")==0)
  	     ctx->mimeEncoding = MIME_BASE64;
      else if (strcasecmp(ptr, "binary")==0)
         ctx->mimeEncoding = MIME_BINARY;
      }

   // Is't file part? (ignore pgp)
   if (si->iPGP==0 && 
       smtp_in_header(si, lcBody, "Content-Disposition", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      {
      SMTP_DEBUG(SMTP_ZONE,"BODY - is not PGP, it's maybe file part");

	  lcDN=smtp_in_GetHeaderLineValue(si,lcLine,"name"); // get display name for attachment
      lcLinetmp=spool_print(tmpsp);

      if ((ptr=smtp_in_GetHeaderLineValue(si,lcLinetmp,"")) && 
          (ptr=smtp_in_GetHeaderLineValue(si,lcLinetmp,"filename")) &&
          j_strlen(ptr)>0
         )
         {
         liAttach=1; // yes it's file part
         if (lcDN)
            {
            SMTP_DEBUG(SMTP_ZONE,"BODY - file part");
            xmlnode_insert_cdata(loBody,"Display name: ",-1);
            xmlnode_insert_cdata(loBody,lcDN,-1);
            xmlnode_insert_cdata(loBody,"\r\n",-1);
            }

         xmlnode_insert_cdata(loBody,"file: ",-1);
         xmlnode_insert_cdata(loBody,ptr,-1);
         xmlnode_insert_cdata(loBody,"\r\n",-1);

         xmlnode_insert_cdata(loBody,"Transfer encoding: ",-1);
         xmlnode_insert_cdata(loBody,lcME,-1);
         xmlnode_insert_cdata(loBody,"\r\n",-1);

         }
      }
   else
      {
      }

   if (liAttach==0 && (ptr=smtp_in_GetHeaderLineValue(si,lcLine,"charset")))
      ctx->mimeCharset = ptr; // charset encoding

   // read boundary data
   SMTP_DEBUG(SMTP_ZONE,"BODY - read boundary data");
   liS=strstr(lcMBody,"\n\n");  // toto je u mon zbyten
   if (j_strlen(lcMBound)>0)
      {
      liE=strstr(liS, lcMBound); // find next/end of boundary
      liLen=liE-(liS);
      }
   else
      {
      liLen=j_strlen(lcBody)-(liS-lcBody);
      }

   // move data if...
   if (si->iPGP>=1 || 
       (si->iPGP==0 && ((liAttach==1 && rcpt->Attachments==1) || liAttach==0))
      )
      {
      SMTP_DEBUG(SMTP_ZONE,"BODY - create copy of boudary data, %i",liLen);
      lcTmp = pmalloc(si->p, liLen+1);
      lcTmp[liLen] = '\0';
      strncpy(lcTmp, liS, liLen);
      }


   if (si->iPGP==2 || (si->iPGP==0 && liAttach==0)) // text only, signed message
      {
      if (si->iPGP==0 && rcpt->nonMIME2x==1)
         {
         SMTP_DEBUG(SMTP_ZONE,"BODY - test inline PGP");

         if (smtp_in_ParsePGPBody(si,lcTmp,xmlnode_get_tag(jtin->config,"core/pgp/cbm"),SMTP_PGP_sBEGIN,SMTP_PGP_MESSAGE_BEGIN))
            {
  		    si->iPGP=3;
            SMTP_DEBUG(SMTP_ZONE,"BODY - inline PGP MESSAGE");
            }
         else
            {
            // try find pgp signed message
            if ((liSM=smtp_in_ParsePGPBody(si,lcTmp,xmlnode_get_tag(jtin->config,"core/pgp/cbs"),SMTP_PGP_sBEGIN,SMTP_PGP_SIGNATURE_BEGIN)))
               {
               si->iPGP=4;
               SMTP_DEBUG(SMTP_ZONE,"BODY - inline PGP SIGNATURE");
               }
            }
         }

      if (si->iPGP==0 ||                    
          (si->iPGP==2 && strncasecmp(lcCT,"application/pgp-signature",25)!=0)
          ) // text only, signed but text boundary
         {
         SMTP_DEBUG(SMTP_ZONE,"BODY - text only, signed but text boundary %s",lcTmp);
         xmlnode_insert_cdata(loBody,smtp_mime_decode(si, ctx, lcTmp),-1);
         return 1;
         }
      }

   if (si->iPGP==0 && liAttach==1) // attachment only
      {
      SMTP_DEBUG(SMTP_ZONE,"BODY - non PGP, any attachment");
      if (rcpt->Attachments==1)
         {
         if (ctx->mimeEncoding == MIME_8BIT)
            lcTmp=smtp_mime_decode(si, ctx, lcTmp);

         xmlnode_insert_cdata(loBody,lcTmp,-1);
         }

      return 1;
      }

   if (si->iPGP==1 || si->iPGP==3) // PGP encrypted
      {
      SMTP_DEBUG(SMTP_ZONE,"BODY - PGP MESSAGE");
      xmlnode_put_attrib(loBody=xmlnode_insert_tag(si->x,"x"),"xmlns","jabber:x:encrypted");

      // decode data
      lcTmp=smtp_mime_decode(si, ctx, lcTmp);
      SMTP_DEBUG(SMTP_ZONE,"PGP - data: %s",lcTmp);

      // locate empty row after -----BEGIN PGP MESSAGE-----
      if ((liE=strstr(lcTmp,"\n \n"))==NULL)
         {
         liE=strstr(lcTmp,"\n\n");  // locate empty row after -----BEGIN PGP MESSAGE-----
         lcTmp=liE+2;
         }
      else
         lcTmp=liE+3;

      liE=smtp_in_ParsePGPBody(si,lcTmp,xmlnode_get_tag(jtin->config,"core/pgp/cbs"),SMTP_PGP_sEND,SMTP_PGP_MESSAGE_END);

      if (liE)
         liE[0]='\0';

      xmlnode_insert_cdata(loBody,lcTmp,-1);
      return 1;
      }


   if (si->iPGP==2 || si->iPGP==4) // PGP signed
      {
      lcTmp=smtp_mime_decode(si, ctx, lcTmp);
      SMTP_DEBUG(SMTP_ZONE,"BODY - PGP SIGNED %s",lcTmp);
      
      // liSM is begin of PGP signature
      // Find -----BEGIN PGP SIGNED MESSAGE-----
      if (si->iPGP==4)
	     {
   	     ptr=strstr(lcTmp,SMTP_PGP_SIGNED_MESSAGE);
         SMTP_DEBUG(SMTP_ZONE,"----\r\n %s",ptr);

 		 if (ptr != NULL)
		 	{
			if ((liE=strstr(ptr,"\n \n"))==NULL)  // locate empty row after -----BEGIN PGP SIGNATURE-----
				{
				liE=strstr(ptr,"\n\n");  // locate empty row after -----BEGIN PGP SIGNATURE-----
				ptr=liE+2;
				}
			else
				{
				ptr=liE+3;
				}


			liSM--;
			liSM[0]='\0';
			liSM++;
			xmlnode_insert_cdata(loBody,smtp_mime_decode(si, ctx, ptr),-1);
			}
		 }
	  else
	     {
         liSM=lcTmp;
		 }


      loBody=xmlnode_insert_tag(si->x,"x");
      xmlnode_put_attrib(loBody,"xmlns","jabber:x:signed");

      // locate empty row after -----BEGIN PGP SIGNATURE-----
      if ((liE=strstr(liSM,"\n \n"))==NULL)
         {

		 liE=strstr(liSM,"\n\n");  // locate empty row after -----BEGIN PGP SIGNATURE-----
         lcTmp=liE+2;
         SMTP_DEBUG(SMTP_ZONE,"PGP - signature: %s",lcTmp);
         }
      else
         {
         lcTmp=liE+3;
         }


      liE=smtp_in_ParsePGPBody(si,lcTmp,xmlnode_get_tag(jtin->config,"core/pgp/cbs/cb"),SMTP_PGP_sEND,SMTP_PGP_SIGNATURE_END);

      if (liE)
         liE[0]='\0';

      xmlnode_insert_cdata(loBody,lcTmp,-1);

      return 1;
      }

   return 0;
   }

void smtp_in_deliver_message(smtpsi si, int liMode)
   {
   smptsi_rcp rcpt;
   int liType;
   xmlnode addresses,address;

  
   if (jtin->jep0033==1) // JEP-0033 support
      {
      SMTP_DEBUG(SMTP_ZONE,"DATA - JEP-0033 support");
      rcpt=(smptsi_rcp) si->rcpt;
      xmlnode_put_attrib(si->x,"to",rcpt->rcpt->server); // jabber server
      xmlnode_put_attrib(addresses=xmlnode_insert_tag(si->x,"addresses"),"xmnls","http://jabber.org/protocol/address");

      for (rcpt = si->rcpt ; rcpt != NULL; rcpt = rcpt->next)
          {
          if (liMode==SMTP_IN_DELIVER_GLOBAL && rcpt->UseGlobalSettings==0)
             continue;

          liType=2;
          if (strstr(si->listcc,rcpt->smtpaddr)) // is in cc list?
             liType=0;

          if (strstr(si->listto,rcpt->smtpaddr)) // is in to list?
             liType=1;

          xmlnode_put_attrib(address=xmlnode_insert_tag(addresses,"address"),"jid",jid_full(rcpt->rcpt));

          if (liType==0) // is in cc list?
             {
             SMTP_DEBUG(SMTP_ZONE,"DATA - sending to (cc) %s",jid_full(rcpt->rcpt));
             xmlnode_put_attrib(address,"type","cc");
             }

          if (liType==1) // is in to list?
             {
             SMTP_DEBUG(SMTP_ZONE,"DATA - sending to (to) %s",jid_full(rcpt->rcpt));
             xmlnode_put_attrib(address,"type","to");
             }

          if (liType==2)
             {
             SMTP_DEBUG(SMTP_ZONE,"DATA - sending to (bcc) %s",jid_full(rcpt->rcpt));
             xmlnode_put_attrib(address,"type","bcc");
             }
          }

      deliver(dpacket_new(xmlnode_dup(si->x)),jtin->i);
      }
   else
      {
      SMTP_DEBUG(SMTP_ZONE,"DATA - NOT JEP-0033 support");
      xmlnode_hide_attrib(si->x,"to");
      for (rcpt = si->rcpt; rcpt != NULL; rcpt = rcpt->next) 
          {
          if (liMode==SMTP_IN_DELIVER_GLOBAL && rcpt->UseGlobalSettings==0)
             continue;

          SMTP_DEBUG(SMTP_ZONE,"DATA - sending to %s",jid_full(rcpt->rcpt));
          xmlnode_put_attrib(si->x,"to",jid_full(rcpt->rcpt));
          deliver(dpacket_new(xmlnode_dup(si->x)),jtin->i);
          }
      }

   }




int smtp_in_message(smtpsi si,int liType)
   {
   jid cur;
   smptsi_rcp rcpt,next;
   xmlnode thread,loSubj,loBody, loSubject;
   char *msg,*body,*ptr,*data,*subject=NULL, *subjectCP, *subjectE,*lcBFile, *tmp, *lcJID, *lcPaid, *lcPom,*lcMax,*thread_data;
   int  liNextLine,liSpam=0,liRet=0,lii;
   _mimectx ctx;
   time_t now_unixtime;
   struct tm now;
   spool tmpsp;
  
   si->iPGP=0;

   // init the mime context to not using MIME 
   ctx.mimeUsed = 0;
   ctx.mimeEncoding = MIME_7BIT;
   ctx.mimeCharset = "us-ascii";

   msg = xmlnode_get_data(si->obody);


   SMTP_DEBUG(SMTP_ZONE,"DATA - I got a message!");

   // save email to backup repository
   if (jtin->tmpBackupSMTP==1)
      {
      lcBFile = (char*)pmalloco(si->p, 254);
      lcBFile[-1] = '\0';
      lcBFile=spools(si->p, tempnam(jtin->smtp_backup, "tmp"),".xml",si->p);

      xmlnode_hide(si->obody);
      if (liType==SMTP_IN_EMAIL)
         {
         tmpsp=spool_new(si->p);
         lii=0;
         for (rcpt = si->rcpt; rcpt != NULL; rcpt = rcpt->next) 
             {
             if (lii==0)
                spooler(tmpsp,jid_full(rcpt->rcpt),tmpsp);
             else
                spooler(tmpsp,",",jid_full(rcpt->rcpt),tmpsp);
             }
         xmlnode_put_attrib(si->omsg,"to",spool_print(tmpsp));


         tmp = (char*)pmalloco(si->p, j_strlen(msg)*3+(j_strlen(msg)*3/20)+1);
         toEscape(msg, (void *) tmp,"()<>,;:\"/[]?");
         loBody = xmlnode_insert_tag(si->omsg,"data");
         xmlnode_insert_cdata(loBody,tmp,-1);
         }


      if (xmlnode2file(lcBFile,si->omsg)!=1)
         {
         log_warn("smtp","Cannot save email to %s.",lcBFile);
         smtp_SendInfoToAdmin(spools(si->p,"Cannot save email to ",lcBFile,".",si->p),SMTP_SITA_P );
         }

	  }


   // normalize line breaks to '\n' only 
   SMTP_DEBUG(SMTP_ZONE,"DATA - normalize line breaks");
   while ((ptr = strstr(msg, "\r\n")) != NULL)
      strcpy(ptr, ptr+1);

   SMTP_DEBUG(SMTP_ZONE,"DATA - normalize line breaks II");

   while ((ptr = strchr(msg, '\r')) != NULL)
	  *ptr = '\n';

   si->MBody = strstr(msg, "\n\n");
///////
//ftp://ftp.rfc-editor.org/in-notes/rfc3464.txt
////

   loSubj=xmlnode_get_tag(jtin->config,"smtp/subject");
   SMTP_DEBUG(SMTP_ZONE,"DATA - Get Advertising tag");
   si->oAD=xmlnode_get_tag(jtin->config,"smtp/ad"); // Advertising TAG

   // projdi seznam pjemc a nati jejich zznamy z rosteru + uivatelsk nastaven
   next = si->rcpt;
   while(next != NULL)
        {
        lcJID=smtp_GetJID(si->p,jid_full(next->rcpt));
        SMTP_DEBUG(SMTP_ZONE,"DATA - user %s",lcJID);
        next->oJID=smtp_roster_get_item(lcJID,0);
        next->Attachments=j_atoi(xmlnode_get_attrib(xmlnode_get_tag(jtin->config,"smtp/attachments"), "pass"),1);
        next->nonMIME2x=j_atoi(xmlnode_get_attrib(xmlnode_get_tag(jtin->config,"smtp/pgp"), "nonmime2x"),1);
        next->Advertising=0;
        next->UseGlobalSettings=1;

        next->SRMode=j_atoi(xmlnode_get_attrib(loSubj,"replace"),2);
        next->SRSeparator=xmlnode_get_attrib(loSubj,"separator");
        next->SRText=xmlnode_get_data(loSubj);

        if (next->oJID!=NULL)
           {
           next->UseGlobalSettings=j_atoi(xmlnode_get_attrib(next->oJID,"UseGlobalSettings"),1);
           }

        if (next->oJID!=NULL && next->UseGlobalSettings==0)
           {
           next->Attachments=j_atoi(xmlnode_get_attrib(next->oJID,"Attachments"),1);
           next->nonMIME2x=j_atoi(xmlnode_get_attrib(next->oJID,"PGPToJabbernonMIMETox"),1);
           next->SRMode=j_atoi(xmlnode_get_attrib(next->oJID,"S2J_SRMode"),2);
           next->SRSeparator=xmlnode_get_attrib(next->oJID,"S2J_SRSeparator");
           next->SRText=xmlnode_get_attrib(next->oJID,"S2J_SRText");
           }


        if (si->oAD!=NULL && j_atoi(xmlnode_get_attrib(si->oAD,"enabled"),0)==1)
           {
           lcPaid=xmlnode_get_tag_data(jtin->config,"core/paid");

           if ((next->oJID==NULL && (lcPaid==NULL || (lcPaid!=NULL && system(spools(si->p,lcPaid," '",lcJID,"'",si->p)) == 0) )) ||
               (next->oJID!=NULL && j_atoi(xmlnode_get_attrib(next->oJID,"paid"),0)==0)
              )
              next->Advertising=1;
           }

        next = next->next;
        }
  

   // spam checking
   if (liType==SMTP_IN_EMAIL)
      {
      liSpam=smtp_in_spam(si,msg);
      if (!(liSpam==SPAM_OK || liSpam==SPAM_NotDefined))
         {
         // delete email from backup repository
        if (jtin->tmpBackupSMTP==1 && j_strlen(lcBFile)>0)
           remove(lcBFile);

         jtin->Stats->SMTPSpam++;
         jtin->Stats->_SMTPSpam++;
         smtp_StatsSave();
         return 0;
         }
      }


   // is this a message that uses MIME? 
   if (smtp_in_header(si, msg, "MIME-Version", 1,tmpsp=spool_new(si->p),&liNextLine)>0)
	  ctx.mimeUsed = 1;

   cur = jid_new(xmlnode_pool(si->x),jtin->i->id); // jabber sending domain is based on configured service id

   SMTP_DEBUG(SMTP_ZONE,"DATA - reading sender");
   // set the sending email addr frist from the reply-to, then the sender, then finally the addr smtp claims it was from 
   if (smtp_in_header(si, msg, "Reply-To", 1,tmpsp=spool_new(si->p),&liNextLine)>0)
      si->fromEx = smtp_in_getaddr(si->p,spool_print(tmpsp));
   else   
      if (smtp_in_header(si, msg, "From", 1,tmpsp=spool_new(si->p),&liNextLine)>0)
         si->fromEx = smtp_in_getaddr(si->p,spool_print(tmpsp));
      else   
         si->fromEx = smtp_in_getaddr(si->p, si->from);


   jid_set(cur,si->fromEx,JID_USER);
   xmlnode_put_attrib(si->x,"from",jid_full(cur));


   // subject can be encoded in quoted printable or base64 +code page
   // Subject: =?iso-8859-2?B?dGVzdOg=?=
   //          xxCodePage  xExdata    ?=
   // E==Q - quoted printable
   // E==B - base64

   SMTP_DEBUG(SMTP_ZONE,"DATA - reading subject");

   if (smtp_in_header(si, msg, "Subject", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      subject=smtp_alltrim(spool_print(tmpsp)); 



   if (j_strlen(subject)>0) 
      {
      lii=0;
      tmpsp=spool_new(si->p);
      lcMax=subject+j_strlen(subject)-1;

   SMTP_DEBUG(SMTP_ZONE,"DATA: %s",subject);

      while (lii==0)
         {
         ctx.mimeEncoding = MIME_7BIT;
         ctx.mimeCharset = "us-ascii";

         SMTP_DEBUG(SMTP_ZONE,"DATA - subject check encode algorithm");
         // Check codepage and encode algorithm
         if ((subjectCP=strstr(subject,"=?"))==NULL) // no encoding
            {
            spooler(tmpsp,smtp_mime_decode(si, &ctx, subject),tmpsp);
            break;
            }

         // any part of subject is coded
         // check if any string before coded part
         if (subjectCP!=subject)
            {
            *subjectCP='\0';
            spooler(tmpsp,smtp_mime_decode(si, &ctx, subject),tmpsp);
            }

         // now decode text
         ctx.mimeEncoding = MIME_8BIT;
         ctx.mimeCharset=subjectCP=subjectCP+2; // begin of code page
   
         subjectE=strstr(subjectCP,"?");
         *subjectE='\0';
         subjectE++; // begin of encode

         lcPom=strstr(subjectE,"?");
         lcPom++; // begin of subject data
         ptr=strstr(lcPom,"=?"); // end of encoded data
         if (ptr!=NULL)
             *ptr='\0';

         if (!strncasecmp(subjectE, "Q",1))
            ctx.mimeEncoding = MIME_QUOTED;
         else if (!strncasecmp(subjectE, "B",1))
            ctx.mimeEncoding = MIME_BASE64;
         else 
            ctx.mimeEncoding = MIME_7BIT;

   SMTP_DEBUG(SMTP_ZONE,"DATA part: %s",lcPom);

         spooler(tmpsp,smtp_mime_decode(si, &ctx, lcPom),tmpsp);

         if (ptr+3>lcMax) // you are out
            break;

         subject=ptr+3;
         }
      subject=spool_print(tmpsp);
      }

   // thread-id
   SMTP_DEBUG(SMTP_ZONE,"DATA - reading thread ID");
   if (smtp_in_header(si, msg, "X-Jabber-Thread-id", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      {
      data=spool_print(tmpsp);
      thread=xmlnode_insert_tag(si->x,"thread");
      xmlnode_put_attrib(si->x,"type","chat");
      if (strcasecmp(data,"jabber-start-thread")==0)
         {
         now_unixtime = time(NULL);
         gmtime_r(&now_unixtime, &now);
         thread_data=(char*)pmalloc_x(si->p, 30,'\0');
         snprintf(thread_data, 30, "JPT_%04i%02i%02i%02i%02i%02i%i", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
         xmlnode_insert_cdata(thread,thread_data,-1);
         }
      else
         xmlnode_insert_cdata(thread,data,-1);
      }


   SMTP_DEBUG(SMTP_ZONE,"DATA - message ID");
   if (smtp_in_header(si, msg, "Message-ID", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      xmlnode_put_attrib(si->x,"id",smtp_lgstrim(spool_print(tmpsp)));


   // find first line with cc
   SMTP_DEBUG(SMTP_ZONE,"DATA - get carbon copy");
   if (smtp_in_header(si, msg, "cc", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      {
      si->listcc =spool_print(tmpsp);
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"DATA - sending carbon copy: %s",si->listcc);
      #else
       SMTP_DEBUG(SMTP_ZONE,"DATA - sending carbon copy");
      #endif
      }

   // find first line with to
   SMTP_DEBUG(SMTP_ZONE,"DATA - get listto");
   if (smtp_in_header(si, msg, "to", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      {
      si->listto =spool_print(tmpsp);
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"DATA - sending listto: %s",si->listto);
      #else
       SMTP_DEBUG(SMTP_ZONE,"DATA - sending listto");
      #endif
      }

   // no mime, pak to zpracuj cel a odeli
   next=si->rcpt;
   if (ctx.mimeUsed == 0)
      {
      // bud dle JEP-0033 nebo samostatn
      SMTP_DEBUG(SMTP_ZONE,"DATA - NONMIME mode");
      body=smtp_mime_decode(si, &ctx, si->MBody);
      loSubject=xmlnode_insert_tag(si->x,"subject");
      smtp_in_SubjectReplace(si,next,subject,loSubject);
      xmlnode_insert_cdata((loBody=xmlnode_insert_tag(si->x,"body")),body,-1);
      smtp_in_AddAdversiting(si,next,loBody);

      // prove odesln
      smtp_in_deliver_message(si,SMTP_IN_DELIVER_ALL);
      }

   if (ctx.mimeUsed == 1)
      {
      SMTP_DEBUG(SMTP_ZONE,"DATA - MIME mode");
      // 
      // nyn projdi vechny pjemce co pouvaj globln nastaven
      // zprvu zpracuj dle prvnho s globlnm nastavenm
      for (rcpt = si->rcpt; rcpt != NULL; rcpt = rcpt->next) 
          {
          if (rcpt->UseGlobalSettings==0)
             continue;

          loSubject=xmlnode_insert_tag(si->x,"subject");
          if (liRet!=-1)
             {
             loBody=xmlnode_insert_tag(si->x,"body");
             liRet=smtp_in_ParseMailBody(si, &ctx, msg,"",rcpt);
             if (liRet==-1) // BODY FAILED
                {
                // you must read all mail body without any conversion
                xmlnode_hide(loBody);
                xmlnode_insert_cdata((loBody=xmlnode_insert_tag(si->x,"body")),smtp_mime_decode(si, &ctx, si->MBody),-1);
                }
             }
          smtp_in_AddAdversiting(si,rcpt,loBody);
          smtp_in_SubjectReplace(si,rcpt,subject,loSubject);
          // prove odesln
          smtp_in_deliver_message(si,SMTP_IN_DELIVER_GLOBAL);

          if (liRet!=-1)
             xmlnode_hide(loBody);

          xmlnode_hide(loSubject);
          break;
          }


      // nyn projdi vechny pjemce co NEpouvaj globln nastaven
      // a odeli zprvu
      xmlnode_hide_attrib(si->x,"to");
      for (rcpt = si->rcpt; rcpt != NULL; rcpt = rcpt->next) 
          {
          if (rcpt->UseGlobalSettings==1)
             continue;

          loSubject=xmlnode_insert_tag(si->x,"subject");

          if (liRet!=-1)
             {
             loBody=xmlnode_insert_tag(si->x,"body");
             liRet=smtp_in_ParseMailBody(si, &ctx, msg,"",rcpt);
             if (liRet==-1) // BODY FAILED
                {
                // you must read all mail body without any conversion
                xmlnode_hide(loBody);
                xmlnode_insert_cdata((loBody=xmlnode_insert_tag(si->x,"body")),smtp_mime_decode(si, &ctx, si->MBody),-1);
                }
             }

          smtp_in_AddAdversiting(si,rcpt,loBody);
          smtp_in_SubjectReplace(si,rcpt,subject,loSubject);

          SMTP_DEBUG(SMTP_ZONE,"DATA - sending to %s",jid_full(rcpt->rcpt));
          xmlnode_put_attrib(si->x,"to",jid_full(rcpt->rcpt));
          deliver(dpacket_new(xmlnode_dup(si->x)),jtin->i);

          if (liRet!=-1)
             xmlnode_hide(loBody);

          xmlnode_hide(loSubject);
          }
      }

   snprintf(jtin->cSMTP_Status, 20, "Message sent to jabber...\0");
   SMTP_DEBUG(SMTP_ZONE,"DATA - Increment counter");
   jtin->Stats->SMTPMessagesIn++;
   jtin->Stats->_SMTPMessagesIn++;
   smtp_StatsSave();


   // delete email from backup repository
   if (jtin->tmpBackupSMTP==1 && j_strlen(lcBFile)>0)
      remove(lcBFile);

   return 1;
   }


/* read an incoming line from the connection */
void smtp_in_read(mio m, int state, void *arg, char *buffer,int bufsz)
   {
   char *cbuffer, *cur, *cur_, *args;
   smtpsi si;
   int i, cmd;

   switch(state)
      {
      case MIO_NEW:
           si=smtp_new_in(m);
           si->phase = PHASE_CMD;
           si->host = mio_ip(m);
           SMTP_DEBUG(SMTP_ZONE,"new connection from %s, %i",si->host, si);
           snprintf(jtin->cSMTP_Status, 20, "Getting email...\0");
           smtp_in_status(si,SMTP_CODE_220,"Jabber SMTP Transport");
           pool_cleanup(si->p, smtp_in_cleanup, (void *)si);

           log_notice("smtp","ALLOC MEMORY   - pool: %i, %i", si->p,5000);
           smtp_Pools(1,5000,si->p);

           mio_reset(m, smtp_in_read, (void *)si);
		   return;

      case MIO_BUFFER:
           si=(smtpsi)(arg);
           break;

      default:
           return;
      }

   si->timer = time(NULL); /* so we don't timeout */

   if (bufsz <= 0) return;

   /* XXX fix special characters, need more intelligence here */
   /*
   for(cur = buffer; (cur - buffer) < bufsz; cur++)
       if(*cur == 127 || (*cur < 32 && *cur != 10 && *cur != 13))
           *cur = '*';
   */


   // S:2005-06-02 gorila@dione.zcu.cz
   // Convert \0 to space
   for(i = 0; i < bufsz; i++)
      {
      if (buffer[i] == '\0') buffer[i]=' ';
	  }
   // E:2005-06-02 gorila@dione.zcu.cz


   if (si->buffer != NULL)
      { /* old data yet, combine and use that */
      cur = malloc(strlen(si->buffer) + bufsz + 1);
      *cur = '\0';
      strcat(cur,si->buffer);
      strcat(cur,buffer);
      free(si->buffer);
      si->buffer = buffer = cur;
      bufsz = strlen(buffer);
      }

   SMTP_DEBUG(SMTP_ZONE,"phase %d data",si->phase);

   cur = cbuffer = (char *)buffer;
   for (i = 1; i < bufsz; i++)
       {
       if (cbuffer[i-1] == '\r' && cbuffer[i] == '\n')
          {
          cbuffer[i-1] = '\0';
          cbuffer[i] = '\0';
          if (si->phase == PHASE_CMD)
             {
             if (strlen(cur) > 0)
                {
                // S:2005-06-03 gorila@dione.zcu.cz
                // Better command detection

                cur_=cur;
                // find "end" of command
                args = strstr(cur, " ");
                if(args != NULL) *args = '\0';
                
                // Get ID Command
                cmd=smtp_cmd_parse(cur);
                if(args != NULL) *args = ' ';

                if (cmd==CMD_UNKNOWN)
                   {
                   jtin->Stats->SMTPCommandUnknown++;
                   jtin->Stats->_SMTPCommandUnknown++;
                   smtp_StatsSave();
                   log_warn("smtp","SMTP unknown command - %s",cur);
                   }

                cur=cur_;

                // Find argument
                args = strstr(cur, smtp_cmd_sep(cmd));
                if (args != NULL)
                   {
                   *args = '\0';
                   ++args;
                   }

                // Process command
                smtp_in_cmd(si, cmd, args);
                // E:2005-06-03 gorila@dione.zcu.cz
                }
             }
          else 
             if (si->phase == PHASE_DATA)
                {
                if (*cur == '.')
                   {
                   ++cur;
                   if (strlen(cur) == 0)
                      {
                      if (smtp_in_message(si,SMTP_IN_EMAIL)==1)
                          smtp_in_status(si,SMTP_CODE_250,"Message Accepted");

                      si->x = NULL;
                      si->rcpt = NULL;
                      si->phase = PHASE_CMD;
                      }
                   }

                if (si->phase == PHASE_DATA && cur)
                   {
                   xmlnode_insert_cdata(si->obody,cur,-1);
                   xmlnode_insert_cdata(si->obody,"\r\n",-1);
                   }
                }

          cur = cbuffer + i + 1;
          }
       }

   cbuffer = NULL;
   i = strlen(cur);
   if (i > 0) /* the read was cut off */
      {
	  if (i > 514)
	     {
	     smtp_in_status(si,SMTP_CODE_552,"XXX too much data");
	     }
      else
         {
         cbuffer = strdup(cur);
         }
      }

   free(si->buffer);
   si->buffer = cbuffer; /* save the tail from above, if any */
   }



void smtp_in_offline_message(xmlnode loMSG)
   {
   smtpsi si;
   smptsi_rcp rcpt;
   pool p=pool_new();
   smtp_PoolsReg(20, p);

   char *lcMSG, *lcPom=NULL, *lcAddr, *addr, *tmp,*lcMax,*lcBFile;
   spool tmpsp;
   int liNextLine,liMode=1;
   jid id;
   xmlnode loBody;

   si=smtp_new_ino(p);
   si->phase = PHASE_CMD;
   si->x = xmlnode_new_tag_pool(si->p,"message");

   lcPom=xmlnode_get_attrib(loMSG,"to");
   loBody = xmlnode_get_tag(loMSG,"data");

   if (loBody==NULL) // old version
      {
      tmp=lcMSG=xmlnode_get_data(loMSG);
      si->omsg=xmlnode_new_tag_pool(si->p,"x");
      }
   else
      {
      si->omsg=loMSG;
      lcMSG=xmlnode_get_data(loBody);
      tmp = (char*)pmalloco(si->p, j_strlen(lcMSG)+1);
      fromEscape(lcMSG, (void *) tmp);
      lcMSG=tmp;
      }

   xmlnode_insert_cdata(si->obody=xmlnode_insert_tag(si->omsg,"body"),tmp,-1); // create new tag
   // si->rcpt must be rebuild from "to:" attribute

   // find first line with to
   if (smtp_in_header(si, lcMSG, "to", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      si->listto =spool_print(tmpsp);

   if (j_strlen(lcPom)==0)
      {
      lcPom=si->listto;
      liMode=0;
      }

   if (j_strlen(lcPom)>0)
      {
      lcMax=lcPom+j_strlen(lcPom);
      lcAddr = strtok( lcPom,",");

      while( lcAddr != NULL  && lcPom<lcMax )
         {
         if (liMode==0) // po staru
            addr=smtp_in_getaddrex(si->p,smtp_alltrim(smtp_2ws(lcAddr)));
         else
            addr=smtp_alltrim(smtp_2ws(lcAddr));

         lcPom+=j_strlen(lcAddr)+1;
         lcAddr = strtok( lcPom,",");

         if (liMode==0) // po staru
            {
            tmp = (char*)pmalloc_x(si->p, j_strlen(addr)+1,'\0');
            fromEscape(addr, (void *) tmp);
            id=jid_new(si->p,tmp);

            id=jid_new(si->p,addr);

            id = smtp_mx2(id);
            }
         else
            id = jid_new(si->p,addr);

         if (id == NULL)
            continue;

         if (smtp_roster_get_item(jid_full(id),0)== NULL &&
             j_atoi(xmlnode_get_tag_data(jtin->config,"smtp/registered"),0)==1)
            {}
         else              
            {
            rcpt = smtp_NewRecipient(si->p,id);
            rcpt->smtpaddr=pstrdup(si->p,addr);
            if (si->rcpt == NULL)
               si->rcpt=rcpt;
            else
               smtp_AppendRcpt(si->rcpt,rcpt);
            }
         }

      if (si->rcpt != NULL)
         smtp_in_message(si,SMTP_IN_OFFLINE);

      // save email to backup repository
      if (si->rcpt == NULL && jtin->tmpBackupSMTP==1)
         {
         loBody=xmlnode_get_tag(loMSG,"body");
         if (loBody)  // skryj dekodovan text
            xmlnode_hide(loBody);

         lcBFile = (char*)pmalloco(si->p, 254);
         lcBFile[-1] = '\0';
         lcBFile=spools(si->p, tempnam(spools(si->p,jtin->smtp_backup,"/old",si->p), "tmp"),".xml",si->p);
         if (xmlnode2file(lcBFile,loMSG)!=1)
            {
            log_warn("smtp","Cannot save email to %s",lcBFile);
            smtp_SendInfoToAdmin(spools(si->p,"Save email to backup repository... ",lcBFile," ...failed",si->p),SMTP_SITA_P );
            }
         }
      }
   pool_free(p);
   }



smtps smtp_in_recipient_cb(smtps so, void *lugmArg)
   {
   char *subject, *id, *tmp,*lcPom;
   time_t now_unixtime;
   struct tm now;
   char *dateheader, *smtpboundary, *smtpCT;
   spool datato;
   int liLen,lii;
   smtpsi si= (smtpsi) lugmArg;
   smptsi_rcp next;
   xmlnode loLang;


   SMTP_DEBUG(SMTP_ZONE,"yay, sending a message from %s to %s",jtin->me,si->from);

   so->from=spools(so->p,pstrdup(so->p,"MAILER-DAEMON"),"@",jtin->me,so->p);
   datato = spool_new(so->p);


   dateheader = (char*)pmalloc_x(so->p, 28,' ');
   dateheader[27] = '\0';
   smtpboundary = (char*)pmalloc_x(so->p, 31,' ');
   smtpboundary[30] = '\0';


   xmlnode_put_attrib(so->x,"From",spools(so->p,"Mail Delivery Subsystem <",so->from,">",so->p));

   lii=j_strlen(si->from);

   tmp = (char*)pmalloco(so->p, lii*3+(lii*3/20)+1);
   toEscape(si->from, (void *) tmp,"()<>,;:\"/[]?");
   if (j_strlen(tmp)>lii)
      {
      lcPom = (char*)pmalloc_x(so->p, lii*3+(lii*3/20)+1,' ');
      toQP(si->from, (void *) lcPom,0,"()<>,@;:\"/[]?.");

      spooler(datato,"\"=?utf-8?q?",lcPom,"?=\" ","<",tmp,">",datato); // simple recipient
      }
   else
      spooler(datato,"<",tmp,">",datato); // simple recipient

   so->rcpt = jid_new(so->p,si->from);
   so->ircpt++;


   if (datato->len>0)
      xmlnode_put_attrib(so->x,"to",spool_print(datato));


   // subject
   subject = pstrdup(so->p,"Returned mail: User unknown");
   liLen=j_strlen(subject);

   log_debug(ZONE,"encode subject");
   tmp = (char*)pmalloc_x(so->p, liLen*3+(liLen*3/20)+1,' ');
   toQP(subject, (void *) tmp,0,"()<>@,;:\"/[]?.");
   xmlnode_put_attrib(so->x,"Subject",spools(so->p,"=?utf-8?q?",tmp,"?=",so->p));

   xmlnode_put_attrib(so->x,"X-Mailer",spools(so->p,smtp_name," ",smtp_version," ","[http://gorila.netlab.cz/jabber.html]",so->p));
   xmlnode_put_attrib(so->x,"MIME-Version","1.0");
   xmlnode_put_attrib(so->x,"Jabber-ID",so->from);

   id = (char*)pmalloc_x(so->p, 18,' ');
   smtp_GetDateTime((char *)id);
   while ((lcPom = strstr(id, ":")) != NULL)
      {
      *lcPom='.';
      }

   xmlnode_put_attrib(so->x,"Message-ID",spools(so->p,"<",id,"@",jtin->me,">",so->p));

   /* create time header for message */
   now_unixtime = time(NULL);
   gmtime_r(&now_unixtime, &now);
   snprintf(dateheader, j_strlen(dateheader), "%02i %s %04i %02i:%02i:%02i +0000\0", now.tm_mday, smtp_CMonth(now.tm_mon), now.tm_year+1900, now.tm_hour, now.tm_min, now.tm_sec);
   if (dateheader[0])
 	   xmlnode_put_attrib(so->x,"Date",dateheader);


/*
   Date: Fri, 8 Jul 1994 09:21:47 -0400
   From: Mail Delivery Subsystem <MAILER-DAEMON@CS.UTK.EDU>
   Subject: Returned mail: User unknown
   To: <owner-ups-mib@CS.UTK.EDU>
   MIME-Version: 1.0
   Content-Type: multipart/report; report-type=delivery-status;
          boundary="JAA13167.773673707/CS.UTK.EDU"

   --JAA13167.773673707/CS.UTK.EDU
   content-type: text/plain; charset=us-ascii

          ----- The following addresses had delivery problems -----
   <arathib@vnet.ibm.com> (unrecoverable error)
   <wsnell@sdcc13.ucsd.edu> (unrecoverable error)

    --JAA13167.773673707/CS.UTK.EDU
   content-type: message/delivery-status

   Reporting-MTA: dns; cs.utk.edu

   Original-Recipient: rfc822;arathib@vnet.ibm.com
   Final-Recipient: rfc822;arathib@vnet.ibm.com
   Action: failed
   Status: 5.0.0 (permanent failure)
   Diagnostic-Code: smtp;  550 'arathib@vnet.IBM.COM' is not a
    registered gateway user
   Remote-MTA: dns; vnet.ibm.com

   Original-Recipient: rfc822;johnh@hpnjld.njd.hp.com
   Final-Recipient: rfc822;johnh@hpnjld.njd.hp.com
   Action: delayed
   Status: 4.0.0 (hpnjld.njd.jp.com: host name lookup failure)

   Original-Recipient: rfc822;wsnell@sdcc13.ucsd.edu
   Final-Recipient: rfc822;wsnell@sdcc13.ucsd.edu
   Action: failed
   Status: 5.0.0
   Diagnostic-Code: smtp; 550 user unknown
   Remote-MTA: dns; sdcc13.ucsd.edu

   --JAA13167.773673707/CS.UTK.EDU
   content-type: message/rfc822

    [original message goes here]

   --JAA13167.773673707/CS.UTK.EDU--

*/

      snprintf(smtpboundary, j_strlen(smtpboundary), "JPB_%04i%02i%02i%02i%02i%02i%i\0", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
      smtpCT=spools(so->p,"multipart/report; report-type=delivery-status; boundary=\"",smtpboundary , "\"",so->p );
      xmlnode_put_attrib(so->x,"Content-type",smtpCT);


      xmlnode_insert_cdata(so->x,"--",-1);
      xmlnode_insert_cdata(so->x,smtpboundary,-1);
      xmlnode_insert_cdata(so->x,"\r\n",-1);

      xmlnode_insert_cdata(so->x,"Content-Type: text/plain; charset=UTF-8\r\n",-1);
      xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n",-1);
      xmlnode_insert_cdata(so->x,"\r\n",-1);


      // put header
      for (loLang = xmlnode_get_tag(jtin->resources,"strings/lang"); loLang != NULL; loLang = xmlnode_get_nextsibling(loLang))
          {
          if (loLang->type!=NTYPE_TAG)
             continue;

          xmlnode_insert_cdata(so->x,smtp_rc_GetString(so->p,xmlnode_get_attrib(loLang,"xml:lang"),SMTP_CB_MESSAGE_HEADER),-1);
          xmlnode_insert_cdata(so->x,"\r\n",-1);
          }

      next = si->rcptFD;
      while (next != NULL)
        {
        xmlnode_insert_cdata(so->x,next->smtpaddr,-1);
        xmlnode_insert_cdata(so->x," (unrecoverable error)\r\n",-1);

        next = next->next;
        }


      xmlnode_insert_cdata(so->x,"\r\n",-1); // end of boundary

      // next boundary
      xmlnode_insert_cdata(so->x,"\r\n--",-1);
      xmlnode_insert_cdata(so->x,smtpboundary,-1);
      xmlnode_insert_cdata(so->x,"\r\n",-1);
      xmlnode_insert_cdata(so->x,"content-type: message/delivery-status\r\n",-1);
      xmlnode_insert_cdata(so->x,"\r\nReporting-MTA: dns;",-1);
      xmlnode_insert_cdata(so->x,jtin->me,-1);
      xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);

      next = si->rcptFD;
      while (next != NULL)
        {
        xmlnode_insert_cdata(so->x,"Original-Recipient: rfc822;",-1);
        xmlnode_insert_cdata(so->x,next->smtpaddr,-1);
        xmlnode_insert_cdata(so->x,"\r\n",-1);

        xmlnode_insert_cdata(so->x,"Final-Recipient: rfc822;",-1);
        xmlnode_insert_cdata(so->x,next->smtpaddr,-1);
        xmlnode_insert_cdata(so->x,"\r\n",-1);

        xmlnode_insert_cdata(so->x,"Action: failed\r\n",-1);
        xmlnode_insert_cdata(so->x,"Status: 5.0.0 (permanent failure)\r\n",-1);

        xmlnode_insert_cdata(so->x,"Diagnostic-Code: smtp; ",-1);
        xmlnode_insert_cdata(so->x,smtp_itoa(so->p, next->iErr),-1);
        xmlnode_insert_cdata(so->x," '",-1);
        xmlnode_insert_cdata(so->x,next->smtpaddr,-1);
        xmlnode_insert_cdata(so->x,"' ",-1);
        switch (next->iErr)
          {
	      case 553:
               xmlnode_insert_cdata(so->x,"Mailbox is not registered for receiving\r\n",-1);
               break;

	      case 450:
               xmlnode_insert_cdata(so->x,"Mailbox don't receive e-mail\r\n",-1);
               break;

	      case 550:
               xmlnode_insert_cdata(so->x,"Mailbox unavailable\r\n",-1);
               break;

	      default:
               xmlnode_insert_cdata(so->x,"Unknown error\r\n",-1);
               break;

          }        

        xmlnode_insert_cdata(so->x,"Remote-MTA: dns; ",-1);
        xmlnode_insert_cdata(so->x,jtin->me,-1);
        xmlnode_insert_cdata(so->x,"\r\n",-1);



        xmlnode_insert_cdata(so->x,"\r\n",-1);

        next = next->next;
        }

/*
 

   
   Original-Recipient: rfc822;arathib@vnet.ibm.com
   Final-Recipient: rfc822;arathib@vnet.ibm.com
   Action: failed
   Status: 5.0.0 (permanent failure)
   Diagnostic-Code: smtp;  550 'arathib@vnet.IBM.COM' is not a
    registered gateway user
   Remote-MTA: dns; vnet.ibm.com

   Original-Recipient: rfc822;johnh@hpnjld.njd.hp.com
   Final-Recipient: rfc822;johnh@hpnjld.njd.hp.com
   Action: delayed
   Status: 4.0.0 (hpnjld.njd.jp.com: host name lookup failure)

   Original-Recipient: rfc822;wsnell@sdcc13.ucsd.edu
   Final-Recipient: rfc822;wsnell@sdcc13.ucsd.edu
   Action: failed
   Status: 5.0.0
   Diagnostic-Code: smtp; 550 user unknown
   Remote-MTA: dns; sdcc13.ucsd.edu


*/
      xmlnode_insert_cdata(so->x,"\r\n",-1); // end of boundary

      // next boundary, orig. message
      xmlnode_insert_cdata(so->x,"\r\n--",-1);
      xmlnode_insert_cdata(so->x,smtpboundary,-1);
      xmlnode_insert_cdata(so->x,"\r\n",-1);
      xmlnode_insert_cdata(so->x,"content-type: message/rfc822\r\n\r\n",-1);

//      xmlnode_insert_cdata(so->x,si->MBody,-1);

      xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
      xmlnode_insert_cdata(so->x,"--",-1);
      xmlnode_insert_cdata(so->x,smtpboundary,-1);
      xmlnode_insert_cdata(so->x,"--\r\n\r\n",-1);


   if (si->rcpt==NULL) // all recipients are bad
       smtp_in_status(si, SMTP_CODE_554, "Message not accepted");
   else
       smtp_in_status(si, SMTP_CODE_354, "Feed me");

   return so;
   }




smtps smtp_in_recipient_cbf(smtps so, void *lugmArg)
   {
   smtpsi si= (smtpsi) lugmArg;
   smtp_in_status(si, SMTP_CODE_554, "Message not accepted");
   return so;
   }
