#include "smtp.h"

#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

extern smtpi jtin;

int smtp_in_spam(smtpsi si, char *msg)
   {

   /* call the spam detection */
   if (j_strlen(jtin->spamcheck)==0)
      {
      SMTP_DEBUG(SMTP_ZONE, "not using spam check");
      return SPAM_NotDefined;
      }

   pid_t checkpid;
   int pipefd[2],liLen;
     

   if (pipe(pipefd))
      {
      log_error(ZONE, "could not create pipe to feed spamcheck script");
      smtp_in_status(si,430,"problem executing spam control");
	  return SPAM_Error430;
	  }

   log_debug(ZONE, "calling %s for spam check", jtin->spamcheck);
   checkpid = fork();

   if (checkpid == -1)
      {
      close(pipefd[0]);
	  close(pipefd[1]);
	  log_error(ZONE, "cannot fork child process for spam checking");
	  smtp_in_status(si,430,"problem executing spam control");
	  return SPAM_Error430;
	  }

   if (checkpid == 0)
      {
      /* inside child process */
	  /* close writing end of pipe */
	  close(pipefd[1]);

   	  /* dup pipe to standard input */
	  dup2(pipefd[0], 0);
	  close(pipefd[0]);

	  /* execute the script */
	  execlp(jtin->spamcheck, NULL);

	  /* execlp only returns on error */
	  _exit(42);
	  }
   else
      {
      /* inside parent process */
      int status;
	  ssize_t written = 0;
	  ssize_t wstat;
	  size_t towrite;

	  /* close reading end of the pipe */
	  close(pipefd[0]);

	  /* feed message to the pipe */
	  towrite = liLen = strlen(msg);
	  while (towrite > 0)
         {
	     wstat = write(pipefd[1], msg+written, towrite-written);
		 if (wstat == -1)
            {
		    log_error(ZONE, "problem writing to spam check pipe");
		    smtp_in_status(si,430,"problem executing spam control");
		    return SPAM_Error430;
		    }
		 written += wstat;
		 towrite = liLen-written;
	     }

	  write(pipefd[1], msg, liLen);

      /* close the pipe */
	  close(pipefd[1]);

	  waitpid(checkpid, &status, 0);

	  if (WIFEXITED(status))
         {
	     /* normal exit of child process */
		 int exitcode = WEXITSTATUS(status);
		 switch (exitcode)
            {
		    case 42:
		         log_error(ZONE, "could not execute spam check script");
		         smtp_in_status(si,430,"problem executing spam control");
			     return SPAM_Error430;

		    case 0: /* no spam mail */
			     break;

      		case 1: /* the message is spam */
 			     log_debug(ZONE, "recevied message seems to be spam, rejecting");
			     smtp_in_status(si,570,"this mail is probably spam and has not been accepted");
			     return SPAM_Error570;

		    default: /* illegal return code */
			     log_error(ZONE, "illegal exit code from spam check skript: %i", exitcode);
			     smtp_in_status(si,430,"problem executing spam control");
			     return SPAM_Error430;
		    }
	     }
      else
         {
	     log_error(ZONE, "spam check exited abnormally");
		 smtp_in_status(si,430,"problem executing spam control");
	 	 return SPAM_Error430;
	     }
      }
   return SPAM_OK;
   }

