#include "smtp.h"

extern smtpi jtin;


void smtp_offline_jmtq(void *arg)
   {
   smtp_tu par_o= (smtp_tu) arg;
   xmlnode loOffline,loMessage;
   char *lcOffline,*lcBFile;
   int lii=0;
   struct dirent   *dirp;
   DIR      *dp;

   // check all offline jabber message
   if (jtin->tmpOfflineJabber==1)
      {
      loOffline=xmlnode_get_tag(jtin->config,"jabber/offline");
      if ((lcOffline=xmlnode_get_attrib(loOffline,"folder")   )==NULL)
         lcOffline= pstrdup(par_o->p,SMTP_OFFLINEJABBER_FOLDER);

      if ((dp = opendir(lcOffline)) != NULL)
         {
         while ( (dirp = readdir((DIR *)dp)) != NULL)
               {
               if (strcmp(dirp->d_name, ".") == 0  ||
                   strcmp(dirp->d_name, "..") == 0)
                   continue;      // ignore dot and dot-dot

 
               // load jabber message from file
               // and send it to out_message...
               lcBFile=spools(par_o->p,lcOffline,"/",dirp->d_name,par_o->p);
               if ((loMessage=xmlnode_file(lcBFile))!=NULL)
                  {
                  remove(lcBFile);
                  smtp_PoolsReg(2100, xmlnode_pool(loMessage));

                  smtp_out_offline_message(loMessage);
                  xmlnode_free(loMessage);
                  }
               else
                  {
                  log_warn("smtp","OFFLINE - message %s not loaded.",lcBFile);
                  smtp_SendInfoToAdmin(spools(par_o->p, "Offline message ",lcBFile," not loaded.",par_o->p),SMTP_SITA_P );
                  }


               lii++;
               }
 
         closedir((DIR *)dp);
         }
      }
   
   pool_free(par_o->p);
   }

void smtp_offline_smtq(void *arg)
   {
   smtp_tu par_o= (smtp_tu) arg;
   xmlnode loOffline,loMessage;
   char *lcOffline,*lcBFile;
   int lii=0;
   struct dirent   *dirp;
   DIR      *dp;


   // check all offline jabber message
   if (jtin->tmpOfflineSMTP==1)
      {
      loOffline=xmlnode_get_tag(jtin->config,"smtp/offline");
      if ((lcOffline=xmlnode_get_attrib(loOffline,"folder")   )==NULL)
         lcOffline= pstrdup(par_o->p,SMTP_OFFLINESMTP_FOLDER);

      if ((dp = opendir(lcOffline)) != NULL)
         {
         while ( (dirp = readdir((DIR *)dp)) != NULL)
               {
               if (strcmp(dirp->d_name, ".") == 0  ||
                   strcmp(dirp->d_name, "..") == 0)
                   continue;      // ignore dot and dot-dot

 
               // load jabber message from file
               // and send it to out_message...
               lcBFile=spools(par_o->p,lcOffline,"/",dirp->d_name,par_o->p);
               if ((loMessage=xmlnode_file(lcBFile))!=NULL)
                  {
                  remove(lcBFile);
                  smtp_PoolsReg(2110, xmlnode_pool(loMessage));

                  smtp_in_offline_message(loMessage);
                  xmlnode_free(loMessage);
                  }
               else
                  {
                  log_warn("smtp","OFFLINE - email %s not loaded.",lcBFile);
                  smtp_SendInfoToAdmin(spools(par_o->p, "Offline email ",lcBFile," not loaded.",par_o->p),SMTP_SITA_P );
                  }
               lii++;
               }
 
         closedir((DIR *)dp);
         }
      }

   pool_free(par_o->p);
   }



// create new thread for sending offline messages
result smtp_offline_jdaemon(void *arg)
   {
   pool p=pool_new();
   smtp_PoolsReg(22, p);

   smtp_tu par_o;

   par_o=pmalloco(p, sizeof(_smtp_tu));
   par_o->p=p;
   par_o->index=(int *) arg;

   par_o->q=mtq_new(p);
   mtq_send(par_o->q, p, smtp_offline_jmtq, (void *)par_o);
   return r_DONE;
   }

// create new thread for sending offline messages
result smtp_offline_sdaemon(void *arg)
   {
   pool p=pool_new();
   smtp_PoolsReg(23, p);

   smtp_tu par_o;

   par_o=pmalloco(p, sizeof(_smtp_tu));
   par_o->p=p;
   par_o->index=(int *) arg;

   par_o->q=mtq_new(p);
   mtq_send(par_o->q, p, smtp_offline_smtq, (void *)par_o);
   return r_DONE;
   }
