#include "smtp.h"

extern smtpi jtin;

// S:2005-09-01 gorila@dione.zcu.cz
result smtp_out_packets(instance i, dpacket dp, void *arg)
   {
   smtpp par;
   char *lcType;
   jpacket jp;
   int liProcess=0;
   pool p;

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"smtp getting a packet: %s",xmlnode2str(dp->x));
   #endif

   p=pool_new();   
   par= smtp_param_i(p,i);
   smtp_PoolsReg(0, p);

   jp = pmalloc(p,sizeof(_jpacket));

   jp->x = dp->x;
   jp=par->jp = jpacket_reset(jp);
   jpacket_subtype(jp);

/*
   SMTP_DEBUG(SMTP_ZONE,"===================");
   jid test=jid_new(p,"gorila@dione.zcu.cz");
   SMTP_DEBUG(SMTP_ZONE,"TEST: %s",jid_full(smtp_2mx( test)));
   SMTP_DEBUG(SMTP_ZONE,"===================");
   test=jid_new(p,"gorila%dione.zcu.cz@smtp.localhost");
   SMTP_DEBUG(SMTP_ZONE,"TEST2: %s",jid_full(smtp_mx2(test)));
*/
   par->dp=dp; // remember delivery packet

   if ((par->lang=xmlnode_get_attrib(par->jp->x, "xml:lang"))==NULL)
      par->lang=jtin->DefaultLang;


   /* XXX check and make sure it's a message and stuff */
   lcType=xmlnode_get_attrib(dp->x,"type");


   SMTP_DEBUG(SMTP_ZONE,"smtp getting a packet: %i, %i",jp->type,jp->subtype);
   switch(jp->type)
      {
      // is it message?
      case JPACKET_MESSAGE:
           if ((liProcess=smtp_out_packets_message(par,(char *)lcType))==0)
              smtp_ReplyError(i, jp, "message", "Not Implemented", 501);
 
           break;


      // is it presence?
      case JPACKET_PRESENCE:
           if ((liProcess=smtp_out_packets_presence(par,(char *)lcType))==0)
              smtp_ReplyError(i, jp, "presence", "Not Implemented", 501);

           break;


      // is it presence(x)?
      case JPACKET_S10N:
           if ((liProcess=smtp_out_packets_S10N(par,(char *)lcType))==0)
              smtp_ReplyError(i, jp, "presence", "Not Implemented", 501);

           break;

      // is it iq?
      case JPACKET_IQ:
           if ((liProcess=smtp_out_packets_iq(par, (char *)lcType))==0)
              smtp_ReplyError(i, jp, "iq", "Not Implemented", 501);

           break;

       
      // is it unknown packet?
      case JPACKET_UNKNOWN:
           break;

      }



   if (liProcess!=-2)
      pool_free(p);

   return r_DONE;
   }
// E:2005-09-01 gorila@dione.zcu.cz
