#include "smtp.h"
extern smtpi jtin;

int _smtp_opm_check_JID(char *lcJID,const char *lcNS)
   {
   int liProcess=0;
   xmlnode loAdmin;

   for (loAdmin = xmlnode_get_firstchild(xmlnode_get_tag(jtin->config,"core/admins")); loAdmin != NULL; loAdmin = xmlnode_get_nextsibling(loAdmin))
        {
        if (loAdmin->type!=NTYPE_TAG || strcmp(xmlnode_get_attrib(loAdmin,"xmlns"),lcNS)!=0 )  
           continue;

        if (strcmp(lcJID,xmlnode_get_data(loAdmin))==0)
           {
           liProcess=1;
           break;
           }
        }

   return liProcess;
   
   }


int _smtp_out_packets_message_admin(smtpp par,int liType,char *lcJID, char *lcMSG)
   {
   int liProcess=0,liDefault;
   char *lcSep, *lcRes, *lcData, *lcNS;
   xmlnode loJID,loMsg;

   switch (liType)
      {
	  case SMTP_ADMIN_JID:
           lcNS=SMTP_ADMIN_NS_JID;
	       break;

      default:
           lcNS=SMTP_ADMIN_NS_EMAIL;

      }

   // Nyn otestuj pjemce, zda to nen admin
   // pokud ano, pak jeho zprvu zpracuj
   // jinak vra Invalid Address
   liProcess=_smtp_opm_check_JID(lcJID,lcNS);

   if (liProcess==1)
      {
      // read first line from message
      lcSep = strstr(lcMSG,"\r");
      if (lcSep==NULL)
          lcSep = strstr(lcMSG,"\n");

      if (lcSep!=NULL)
          *lcSep='\0';

      // Read JID and Data from message
      lcData = strstr(lcMSG," ");
      if (lcData!=NULL)
         {
         *lcData='\0';
         lcData++;

         lcRes = strstr(lcMSG,"/");
         if (lcRes!=NULL)
            {
            *lcRes='\0';
            lcRes++;

            if (strcmp(lcRes,"paid")==0)
               {
               // Get JID item from roster
               loJID=smtp_roster_get_item( lcMSG,1);
               liDefault=j_atoi(xmlnode_get_attrib(loJID,"default"),0);
               xmlnode_put_attrib(loJID,"paid",strcmp(lcData,"Y")==0?"1":"0");
               smtp_roster_set_item(lcMSG,loJID);
               if (liDefault==1) // default item, remove it
                  xmlnode_free(loJID);

               }
            }
         }
       else
         {
         if (strcmp(lcMSG,"login")==0)
            {
            loMsg=out_SetReply(xmlnode_dup_pool(par->tmppool,par->jp->x),par->jp->x);
            xmlnode_put_attrib(loMsg,"type","chat");
            deliver(dpacket_new(xmlnode_dup(loMsg)),par->i);
            }
         }

      }


   return liProcess;
   }

char *_smtp_opmadmin_getfolder(pool p, char *lcFLD)
   {
   if (j_strcmp(lcFLD,"jb")==0)
      return jtin->jabber_backup;
   else if (j_strcmp(lcFLD,"jbo")==0)
      return spools(p,jtin->jabber_backup,"/old",p);
   else if (j_strcmp(lcFLD,"jo")==0)
      return jtin->jabber_offline;
   else if (j_strcmp(lcFLD,"sb")==0)
      return jtin->smtp_backup;
   else if (j_strcmp(lcFLD,"so")==0)
      return jtin->smtp_offline;
   else if (j_strcmp(lcFLD,"sbo")==0)
      return spools(p,jtin->smtp_backup,"/old",p);
   else if (j_strcmp(lcFLD,"tmp")==0)
      return jtin->core_tmp;
   else
      return NULL;

   return NULL;
   }


int _smtp_opmadmin_getcntfolder(char *lcFLD,int liOld)
   {
   int lii=0;
   struct dirent   *dirp;
   DIR      *dp;

   if ((dp = opendir(lcFLD))==NULL)
      return -1;

   lii=0;
   while ( (dirp = readdir((DIR *)dp)) != NULL)
      {
      if (strcmp(dirp->d_name, ".") == 0  ||
          strcmp(dirp->d_name, "..") == 0 ||
          (liOld=1 && strcmp(dirp->d_name, "old") == 0)
         )
         continue;      // ignore dot and dot-dot 

      lii++;
      }
   closedir((DIR *)dp);
   return lii;
   }

int _smtp_opmadmin_formatfolder(const char *lcFLDX,char *lcFLD, int lii, xmlnode loBody)
   {
   xmlnode_insert_cdata(loBody,lcFLDX,-1);
   xmlnode_insert_cdata(loBody," - ",-1);
   xmlnode_insert_cdata(loBody,lcFLD,-1);
   xmlnode_insert_cdata(loBody," : ",-1);
   xmlnode_insert_cdata(loBody,smtp_itoa(xmlnode_pool(loBody),lii),-1);
   xmlnode_insert_cdata(loBody,"\r\n",-1);


   return lii;
   }

int _smtp_opmadmin_transport(smtpp par,char *lcJID,char *lcMSG)
   {
   int liProcess=0,lii,liFirst=-1;
   char *laWords[5],*lcFolder=NULL,*lcFolderD=NULL, *lcBFile, *lcMax;
   xmlnode x,loBody,loBackup,loFile,loJID;
   struct dirent   *dirp;
   DIR      *dp;
   pool p=par->tmppool;
   
   lcMax=lcMSG+j_strlen(lcMSG);
   laWords[0]=smtp_getword(&lcMSG, " ",lcMax);
   laWords[1]=smtp_getword(&lcMSG, " ",lcMax);

   x= out_SetReply(xmlnode_new_tag("message"),par->jp->x);
   smtp_PoolsReg(1000, xmlnode_pool(x));

   xmlnode_put_attrib(x,"type","chat");
   loBody=xmlnode_insert_tag(x,"body");

   // command stats
   if (liProcess==0 && j_strcmp(laWords[0],"stats")==0)
      {
      if (jtin->tmpBackupJabber==1)
         {
         lcFolder=jtin->jabber_backup;
         lii=_smtp_opmadmin_getcntfolder(lcFolder ,1);
         _smtp_opmadmin_formatfolder("jb",lcFolder ,lii,loBody);

         lcFolder=spools(p,jtin->jabber_backup,"/old",p);
         lii=_smtp_opmadmin_getcntfolder(lcFolder ,0);
         _smtp_opmadmin_formatfolder("jbo",lcFolder ,lii,loBody);
         }

      if (jtin->tmpOfflineJabber==1)
         {
         lcFolder=jtin->jabber_offline;
         lii=_smtp_opmadmin_getcntfolder(lcFolder ,0);
         _smtp_opmadmin_formatfolder("jo",lcFolder ,lii,loBody);
         }

      if (jtin->tmpBackupSMTP==1)
         {
         lcFolder=jtin->smtp_backup;
         lii=_smtp_opmadmin_getcntfolder(lcFolder ,1);
         _smtp_opmadmin_formatfolder("sb",lcFolder ,lii,loBody);

         lcFolder=spools(p,jtin->smtp_backup,"/old",p);
         lii=_smtp_opmadmin_getcntfolder(lcFolder ,0);
         _smtp_opmadmin_formatfolder("sbo",lcFolder ,lii,loBody);
         }

      if (jtin->tmpOfflineSMTP==1)
         {
         lcFolder=jtin->smtp_offline;
         lii=_smtp_opmadmin_getcntfolder(lcFolder ,0);
         _smtp_opmadmin_formatfolder("so",lcFolder ,lii,loBody);
         }

      if (jtin->tmpCoreTmp==1)
         {
         lcFolder=jtin->core_tmp;
         lii=_smtp_opmadmin_getcntfolder(lcFolder ,0);
         _smtp_opmadmin_formatfolder("tmp",lcFolder ,lii,loBody);
         }

      // accounts + payed accounts
      xmlnode_insert_cdata(loBody,"\r\nAccounts: ",-1);
      xmlnode_insert_cdata(loBody,smtp_itoa(p,jtin->Stats->_CoreAccounts),-1);

      lii=0;
      for (loFile = xmlnode_get_tag(jtin->roster_files,"file"); loFile != NULL; loFile = xmlnode_get_nextsibling(loFile))
          {
          if (loFile->type!=NTYPE_TAG)
             continue;

          // walk all jid in file
          for (loJID = xmlnode_get_tag(loFile,"item"); loJID != NULL; loJID = xmlnode_get_nextsibling(loJID))
              {
              if (loJID->type!=NTYPE_TAG || j_atoi(xmlnode_get_attrib(loJID,"paid"),0)==0)
                  continue;

              lii++;
              }
          }
      xmlnode_insert_cdata(loBody,"\r\nAccounts-paid: ",-1);
      xmlnode_insert_cdata(loBody,smtp_itoa(p,lii),-1);
      xmlnode_insert_cdata(loBody,"\r\n",-1);


      liProcess=1;
      }

   // command ls
   if (liProcess==0 && j_strcmp(laWords[0],"ls")==0 && j_strlen(laWords[1])>0)
      {
      laWords[2]=smtp_getword(&lcMSG, " ",lcMax);
      lcFolder=_smtp_opmadmin_getfolder(p,laWords[1]);
      if (j_strlen(laWords[2])>0 && strncasecmp(laWords[2],"/f",2)==0)
         liFirst=j_atoi((laWords[2]+2),-1);

      if (j_strlen(lcFolder)>0)
         {
         if ((dp = opendir(lcFolder))!=NULL)
            {
            lii=0;
            while ( (dirp = readdir((DIR *)dp)) != NULL)
                  {
                  if (strcmp(dirp->d_name, ".") == 0  ||
                      strcmp(dirp->d_name, "..") == 0 ||
                      strcmp(dirp->d_name, "old") == 0)
                      continue;      // ignore dot and dot-dot 

                  if (lii>0)
                     xmlnode_insert_cdata(loBody," | ",-1);

                  xmlnode_insert_cdata(loBody,dirp->d_name,-1);

                  lii++;
                  if (liFirst>0 && lii==(liFirst-1))
                      break;
                  }
            closedir((DIR *)dp);
            xmlnode_insert_cdata(loBody,"\r\n",-1);

            if (lii==0)
               {
               xmlnode_insert_cdata(loBody,lcFolder,-1);
               xmlnode_insert_cdata(loBody," : ",-1);
               xmlnode_insert_cdata(loBody,smtp_itoa(p,lii),-1);
               xmlnode_insert_cdata(loBody,"\r\n",-1);
               }
            }
         else
            {
            xmlnode_insert_cdata(loBody,lcFolder,-1);
            xmlnode_insert_cdata(loBody," : failed\r\n",-1);
            }
         }
      else
         {
         xmlnode_insert_cdata(loBody,"Folder unknown\r\n",-1);
         }
      liProcess=1;
      }

   // command get
   if (liProcess==0 && j_strcmp(laWords[0],"get")==0 && j_strlen(laWords[1])>0)
      {
      laWords[2]=smtp_getword(&lcMSG, " ",lcMax);
      lcFolder=_smtp_opmadmin_getfolder(p,laWords[1]);

      if (j_strlen(laWords[2])>0 && j_strlen(lcFolder)>0)
         {
         loBackup=xmlnode_file(spools(p,lcFolder,"/",laWords[2],p));
         smtp_PoolsReg(2220, xmlnode_pool(loBackup));

         if (loBackup==NULL)
            xmlnode_insert_cdata(loBody,"Cannot read file\r\n",-1);
         else
            {
            xmlnode_insert_cdata(loBody,xmlnode2str(loBackup),-1);
            xmlnode_free(loBackup);
            }
         }
      else
         {
         if (j_strlen(lcFolder)==0)
            xmlnode_insert_cdata(loBody,"Folder unknown\r\n",-1);

         if (j_strlen(laWords[2])==0)
            xmlnode_insert_cdata(loBody,"File unknown\r\n",-1);

         }
      liProcess=1;
      }

   // command rm
   if (liProcess==0 && j_strcmp(laWords[0],"rm")==0)
      {
      laWords[2]=smtp_getword(&lcMSG, " ",lcMax);
      laWords[3]=smtp_getword(&lcMSG, " ",lcMax);

      lcFolder=_smtp_opmadmin_getfolder(p,laWords[1]);

      if (j_strlen(laWords[3])>0 && strncasecmp(laWords[3],"/f",2)==0)
         liFirst=j_atoi((laWords[3]+2),-1);

      if (j_strlen(laWords[2])>0 && strncasecmp(laWords[2],"/f",2)==0)
         liFirst=j_atoi((laWords[2]+2),-1);

      if (j_strlen(lcFolder)>0)
         {
         if (j_strlen(laWords[2])>0)
            {
            remove(spools(p,lcFolder,"/",laWords[2],p));
            xmlnode_insert_cdata(loBody,"File deleted\r\n",-1);
            }
         else
            {
            lii=0;
            if ((dp = opendir(lcFolder))!=NULL)
               {
               while ( (dirp = readdir((DIR *)dp)) != NULL)
                  {
                  if (strcmp(dirp->d_name, ".") == 0  ||
                      strcmp(dirp->d_name, "..") == 0 ||
                      strcmp(dirp->d_name, "old") == 0)
                      continue;      // ignore dot and dot-dot 

                  remove(spools(p,lcFolder,"/",dirp->d_name,p));
                  lii++;

                  if (liFirst>0 && lii==(liFirst-1))
                      break;
                  }
               closedir((DIR *)dp);

               xmlnode_insert_cdata(loBody,lcFolder,-1);
               xmlnode_insert_cdata(loBody," : ",-1);
               xmlnode_insert_cdata(loBody,smtp_itoa(p,lii),-1);
               xmlnode_insert_cdata(loBody,"\r\n",-1);
               }
            else
               {
               xmlnode_insert_cdata(loBody,"Cannot open ",-1);
               xmlnode_insert_cdata(loBody,lcFolder,-1);
               xmlnode_insert_cdata(loBody,"\r\n",-1);
               }

            xmlnode_insert_cdata(loBody,"All files deleted\r\n",-1);
            }
         }
      else
         xmlnode_insert_cdata(loBody,"Folder unknown\r\n",-1);

      liProcess=1;
      }

   // command mv
   if (liProcess==0 && j_strcmp(laWords[0],"mv")==0)
      {
      laWords[2]=smtp_getword(&lcMSG, " ",lcMax);
      laWords[3]=smtp_getword(&lcMSG, " ",lcMax);
      laWords[4]=smtp_getword(&lcMSG, " ",lcMax);

      lcFolder=_smtp_opmadmin_getfolder(p,laWords[1]);
      lcFolderD=_smtp_opmadmin_getfolder(p,laWords[2]);

      if (j_strlen(laWords[4])>0 && strncasecmp(laWords[4],"/f",2)==0)
         liFirst=j_atoi((laWords[4]+2),-1);

      if (j_strlen(laWords[3])>0 && strncasecmp(laWords[3],"/f",2)==0)
         liFirst=j_atoi((laWords[3]+2),-1);

      if (j_strlen(lcFolder)>0 && j_strlen(lcFolderD)>0)
         {
         if (j_strlen(laWords[3])>0)
            {
            lcBFile = (char*)pmalloco(p, 254);
            lcBFile[-1] = '\0';
            lcBFile=spools(p, tempnam(lcFolderD, "tmp"),".xml",p);

            rename(spools(p,lcFolder,"/", laWords[3] ,p), lcBFile);
            xmlnode_insert_cdata(loBody,"File moved\r\n",-1);
            }
         else
            {
            lii=0;
            if ((dp = opendir(lcFolder))!=NULL)
               {
               while ( (dirp = readdir((DIR *)dp)) != NULL)
                  {
                  if (strcmp(dirp->d_name, ".") == 0  ||
                      strcmp(dirp->d_name, "..") == 0 ||
                      strcmp(dirp->d_name, "old") == 0)
                      continue;      // ignore dot and dot-dot 

                  lcBFile = (char*)pmalloco(p, 254);
                  lcBFile[-1] = '\0';
                  lcBFile=spools(p, tempnam(lcFolderD, "tmp"),".xml",p);

                  rename(spools(p,lcFolder,"/", dirp->d_name,p),lcBFile);
                  lii++;

                  if (liFirst>0 && lii==(liFirst-1))
                      break;
                  }
               closedir((DIR *)dp);

               xmlnode_insert_cdata(loBody,lcFolder,-1);
               xmlnode_insert_cdata(loBody," : ",-1);
               xmlnode_insert_cdata(loBody,smtp_itoa(p,lii),-1);
               xmlnode_insert_cdata(loBody,"\r\n",-1);
               }
            else
               {
               xmlnode_insert_cdata(loBody,"Cannot open ",-1);
               xmlnode_insert_cdata(loBody,lcFolder,-1);
               xmlnode_insert_cdata(loBody,"\r\n",-1);
               }
            }
         }
      else
         {
         if (j_strlen(lcFolder)==0)
             xmlnode_insert_cdata(loBody,"Source folder unknown\r\n",-1);

         if (j_strlen(lcFolderD)==0)
             xmlnode_insert_cdata(loBody,"Destination folder unknown\r\n",-1);

         }

      liProcess=1;
      }

/*
// sloky backup a offline
//!transport stats - vrt info o poctu soubor v jabber, jabber/old,jabber-offline, smtp a smtp/old
//!transport ls jb[jbo, jo, sb, sbo] /fxxxx - vrt seznam soubor z 
//    jb  - jabber backup
//    jbo - jabber backup-old
//    jo  - jabber offline
//    sb  - smtp backup
//    sbo - smtp backup-old
//    tmp - tmp

//!transport get xxx [file name] - vrt soubor ze sloky uren xxx, viz !ls
//!transport rm xxx [file name]  /fxxxx - smae soubor ve sloce uren xxx, viz !ls
//!transport mv xxx yyy [file name] /fxxxx - pesune  soubor ze sloky xxx, do yyy !ls

*/

   if (liProcess==1)
      deliver(dpacket_new(xmlnode_dup(x)),par->i);
 
   xmlnode_free(x);

   return liProcess;
   }
int _smtp_opmadmin_config(smtpp par,char *lcJID,char *lcMSG)
   {
   char *laWords[5],*lcMax;
   int liProcess=0;
   xmlnode x,loBody,loNode;
/*
// config
// !config get  - vrt cel konfig
!config set [vtev] hodnota - ulo xml string do vtv  ?!?
!config set [vtev:cdata] hodnota - ulo hodnotu do vtv
!config set [vtev?atribut] hodnota - ulo hodnotu do vtve a atributu
//!config save - ulo konfig do souboru
*/


   lcMax=lcMSG+j_strlen(lcMSG);
   laWords[0]=smtp_getword(&lcMSG, " ",lcMax);
   laWords[1]=smtp_getword(&lcMSG, " ",lcMax);
   laWords[2]=smtp_getword(&lcMSG, " ",lcMax);
   
   x= out_SetReply(xmlnode_new_tag("message"),par->jp->x);
   smtp_PoolsReg(1010, xmlnode_pool(x));

   xmlnode_put_attrib(x,"type","chat");
   loBody=xmlnode_insert_tag(x,"body");

   if (liProcess==0 && j_strcmp(laWords[0],"get")==0)
      {
      // vra cel konfig
      if (j_strlen(laWords[1])==0 && j_strlen(laWords[2])==0)
         xmlnode_insert_cdata(loBody,xmlnode2str(jtin->config),-1);

      // vrat data z nodu
      // laWords[1] obsahuje vbrov kritria
      // laWords[2] obsahuje typ vrcen (:xml, :cdata, ?atribute_name
      if (j_strlen(laWords[1])>0 && j_strlen(laWords[2])>0)
         {
          
         if (strcasecmp(laWords[2],":xml")==0) // get XML data from branch
            {
            loNode=xmlnode_get_tag(jtin->config,laWords[1]);
            if (loNode==NULL)
               xmlnode_insert_cdata(loBody,"Node not found.",-1);
            else
               xmlnode_insert_cdata(loBody,xmlnode2str(loNode),-1);
            }

         if (strcasecmp(laWords[2],":cdata")==0) // get data to branch
            {
            loNode=xmlnode_get_tag(jtin->config,laWords[1]);
            if (loNode==NULL)
               xmlnode_insert_cdata(loBody,"Node not found.",-1);
            else
               xmlnode_insert_cdata(loBody,xmlnode_get_data(loNode),-1);
            }

         if (*laWords[2]=='?') // get data from branch attribute
            {
            *laWords[2]='\0';
            laWords[2]++;

            loNode=xmlnode_get_tag(jtin->config,laWords[1]);
            if (loNode==NULL)
               xmlnode_insert_cdata(loBody,"Node not found.",-1);
            else
               {
               xmlnode_insert_cdata(loBody,xmlnode_get_attrib(loNode,laWords[2]),-1);
               }

            }

         }

      liProcess=1;
      }


   if (liProcess==0 && j_strcmp(laWords[0],"save")==0)
      {
      if (xmlnode2file(jtin->config_file,jtin->config)!=1)
         xmlnode_insert_cdata(loBody,"Config not saved.",-1);
      else
         xmlnode_insert_cdata(loBody,"Config saved.",-1);

      liProcess=1;
      }

   if (liProcess==1)
      deliver(dpacket_new(xmlnode_dup(x)),par->i);
 
   xmlnode_free(x);

   return liProcess;
   }
int _smtp_opmadmin_account(smtpp par,char *lcJID,char *lcMSG)
   {
   int liProcess=0;
/*
// accounts
!account stats - vrt statistiku o tech (poet JID, poet files in indexu, poet files, seznam files not loaded)
!account ls index - vrt seznam soubor z indexovho souboru
!account rm index/letter - smae soubor z indexovho souboru

!account ls file - vrt seznam soubor s ty
!account rm file/letter - smae soubor s ty

!account list - vrt seznam t JID
!account list/letter - vrt seznam JID t dle prvnho psmena

!account get [jid?attrib] - vrt et pro JID, nebo nastaven pro JID (if empty attrib, return xml)
!account set [jid?attrib value - nastav et pro JID (if empty attrib , need xml) xml must be on next row
*/
   return liProcess;
   }

int smtp_admin_message(smtpp par,char *lcType)
   {
   jpacket jp=par->jp;
   char *lcJID, *lcMSG, *lcSep,*lcData, *lcCmd,*lcMax,*lcERow;
   int liExit=0,liExecute,liMax=0,liLen;

   lcJID=smtp_GetJID(par->tmppool,jid_full(jp->from));
   lcCmd=lcMSG=xmlnode_get_tag_data(jp->x,"body");
   if ((liLen=j_strlen(lcMSG))>0)
      lcMax=lcMSG+liLen;
   else
      return 1;
   
   while (liExit==0)
      {
      liExecute=0;

      // check first letter of next row
      lcERow = strstr(lcMSG,"\r");
      if (lcERow==NULL)
          lcERow = strstr(lcMSG,"\n");

      if (lcERow==NULL)  // nen dn enter, jen jeden dek
         {
         liExecute=liExit=1;
         lcERow=lcMax;
         }
      else
         {
         lcSep=lcERow;
         while ((*lcSep == '\r' || *lcSep == '\n') && lcSep<lcMax) // najdi dal dek
           {lcSep++;}

         if (lcSep>lcMax)
            liExecute=liExit=1;
         else
            // check if next row is command
            if (strncasecmp(lcSep,SMTP_CMDG_TRANSPORT,j_strlen(SMTP_CMDG_TRANSPORT))==0 || 
                strncasecmp(lcSep,SMTP_CMDG_CONFIG,j_strlen(SMTP_CMDG_CONFIG))==0 ||
                strncasecmp(lcSep,SMTP_CMDG_ACCOUNT,j_strlen(SMTP_CMDG_ACCOUNT))==0)
               liExecute=1;
         }

      if (liExit!=1)
         {
         *lcERow='\0'; //ukoni pkaz
         lcMSG=lcSep;
         }

      if (liExecute==1 && lcERow>lcCmd)
         {
         lcSep= strstr(lcCmd," ");
         if (lcSep!=NULL)
            lcData=lcSep+1;
         else
            lcData=NULL;

         lcCmd=smtp_2ws(lcCmd);

         if (lcCmd[0]=='!')
            {
            if (strncasecmp(lcCmd,SMTP_CMDG_TRANSPORT,j_strlen(SMTP_CMDG_TRANSPORT))==0 &&
                _smtp_opm_check_JID(lcJID,SMTP_ADMIN_NS_TRANSPORT)==1)
               _smtp_opmadmin_transport(par,lcJID,lcData);
            else if (strncasecmp(lcCmd,SMTP_CMDG_CONFIG,j_strlen(SMTP_CMDG_CONFIG))==0 &&
                _smtp_opm_check_JID(lcJID,SMTP_ADMIN_NS_CONFIG)==1)
               _smtp_opmadmin_config(par,lcJID,lcData);
            else if (strncasecmp(lcCmd,SMTP_CMDG_ACCOUNT,j_strlen(SMTP_CMDG_ACCOUNT))==0 &&
                _smtp_opm_check_JID(lcJID,SMTP_ADMIN_NS_ACCOUNT)==1)
               _smtp_opmadmin_account(par,lcJID,lcData);
            }
         else
            _smtp_out_packets_message_admin(par,SMTP_ADMIN_JID,lcJID,lcMSG);

         }

      if (liExecute==1 && liExit!=1)
          lcCmd=lcMSG;

      liMax++;
      if (liMax>=MAXLOOP)
          break;

      }

   if (liMax>=MAXLOOP)
      {
      log_warn("smtp","ADMIN - Max count of LOOP was exceed.");
      smtp_SendInfoToAdmin("ADMIN - Max count of LOOP was exceed.",SMTP_SITA_P );
      }

   return 1;
   }

