#include "smtp.h"

extern smtpi jtin;

void smtp_poolm_mtq(void *arg)
   {
   smtp_tu par_o= (smtp_tu) arg;
   smtp_pools next=jtin->pools, curr;
   time_t tstamp=time(NULL);
   int liEnd=0;

   // projdi seznam  v pool manageru
   // zkontroluj asovou znaku
   // ve co je tam dl jak 30 minut, uvolni a poli info adminovi

   log_alert("smtp","POOL MANAGER DAEMON - START");

   while(next != NULL)
        {
        curr=next;

        if (next->next != NULL)
           next = next->next;
        else
           liEnd=1;

        log_alert("smtp","POOL MANAGER DAEMON - pool: %i, %i, %i",(int)curr->pl,curr->index,curr->tmp);

        if (curr->tmp==1 && tstamp>curr->tstamp+60*SMTP_poolm_timeout)
           {
           log_alert("smtp","POOL MANAGER DAEMON - MEMORY LEAK: %i, %i",(int)curr->pl,curr->index);
           smtp_SendInfoToAdmin(spools(par_o->p,"POOL MANAGER DAEMON - MEMORY LEAK: ",smtp_itoa(par_o->p,(int)curr->pl),", ",smtp_itoa(par_o->p,(int)curr->index),".",par_o->p ),SMTP_SITA_M);

           smtp_Pools(0,0,curr->pl); // uvolni pool
           }

        if (liEnd==1)
           break;

        }
   pool_free(par_o->p);
   }


// create new thread for getting paid flag
result smtp_poolm_daemon(void *arg)
   {
   pool p=pool_new();
   smtp_PoolsReg(31, p);

   smtp_tu par_o;

   par_o=pmalloco(p, sizeof(_smtp_tu));
   par_o->p=p;

   par_o->q=mtq_new(p);
   mtq_send(par_o->q, p, smtp_poolm_mtq, (void *)par_o);
   return r_DONE;
   }


int smtp_Pools(int liType,int liIndex,pool pl)
   {
   smtp_pools root=jtin->pools,last,b=NULL,prev=NULL,next=jtin->pools;
   pool p;
//   int lii=0;

   if (pl == NULL)
      return 0;

   // check if pool in list
   while(next != NULL)
        {
        if (next->pl==pl)
           {
           b=next;
           break;
           }

        prev=next;
        if (next->next != NULL)
           next = next->next;
        else
           break;
        }

   if (liType==1 && b==NULL) // Add pool into list
      {
      // Create new item

      b=pmalloco(p=pool_new(), sizeof(_smtp_pools));
      b->p=p; 
      b->pl=pl;
      b->index=liIndex;
      b->last=b->next=NULL;
      b->tstamp=time(NULL);
      b->tmp=1;

      if (root == NULL)
         {
         jtin->pools=b;
         }
      else if ((last=root->last)==NULL) // save Last item
         {
         root->last=root->next=b;
         }
      else
         {
         last->next=b;
         root->last=b;
         }
      }

   if (liType==0 && b!=NULL) // Remove pool from list
      {
      if (b==root && b->next==NULL) // root item
         jtin->pools=NULL; // clear it
      else if (b==root && b->next!=NULL) // check to first item
         {
         jtin->pools=b->next;
         jtin->pools->last=b->last;
         }
      else if (root->last==b) // check to last item
         {
         root->last=prev; // copy last item to rootlast
         prev->next=NULL; // clear next item
         }
      else
         {
         prev->next=b->next;  // change next item
         }

      liIndex=b->index;
      pool_free(b->p); // free item
      }
   return liIndex;
   }

void smtp_PoolsReg(int liIndex,pool p)
   {
   pool_cleanup(p, smtp_X_cleanup, (void *) p);
   log_notice("smtp","ALLOC MEMORY   - pool: %i, %i", (int)p,liIndex);
   smtp_Pools(1,liIndex,p);
   }


/* when the connection dies, clean up the mess */
void smtp_X_cleanup(void *arg)
   {
   int liIndex;
   pool p = (pool) arg;
   liIndex=smtp_Pools(0,0,p);
   log_notice("smtp","DEALLOC MEMORY - pool: %i, %i",(int)p,liIndex);
   }


int smtp_PoolsGetMem()
   {
   smtp_pools next=jtin->pools;
   int lii=0;

   while(next != NULL)
        {
        lii+=(pool_size(next->p)+pool_size(next->pl));

//   log_notice("smtp","Get Pool size %i-%i, %i",(int)next->pl,next->index,pool_size(next->pl));

        if (next->next != NULL)
           next = next->next;
        else
           break;

        }
   return lii;
   }

void smtp_PoolsSettmp(pool pl, int liTmp)
   {
   smtp_pools next=jtin->pools;

   while(next != NULL)
        {
        if (next->pl==pl)
           {
           next->tmp=liTmp;
           break;
           }

        if (next->next != NULL)
           next = next->next;
        else
           break;

        }
   }
