#include "smtp.h"

extern smtpi jtin;

xmlnode smtp_roster_get_defaultitem(char *lcJID)
   {
   xmlnode loJID, loSubj;
   pool p;
   loJID=xmlnode_new_tag_pool(p=pool_new(), "item");
   smtp_PoolsReg(1800, p);

   xmlnode_put_attrib(loJID,"jid",lcJID);

   // set default values

   xmlnode_put_attrib(loJID,"UseGlobalSettings","1");
   xmlnode_put_attrib(loJID,"Attachments",xmlnode_get_attrib(xmlnode_get_tag(jtin->config,"smtp/attachments"),"pass"));
   xmlnode_put_attrib(loJID,"PGPJabberToMIME",xmlnode_get_attrib(xmlnode_get_tag(jtin->config,"jabber/pgp"),"mime"));
   xmlnode_put_attrib(loJID,"PGPToJabbernonMIMETox",xmlnode_get_attrib(xmlnode_get_tag(jtin->config,"smtp/pgp"), "nonmime2x"));
   xmlnode_put_attrib(loJID,"S2J_AllAreSPAM",xmlnode_get_data(xmlnode_get_tag(jtin->config,"smtp/allmessagesarespam")));


   xmlnode_put_attrib(loJID,"J2S_RTMode","0");
   xmlnode_put_attrib(loJID,"J2S_RTName",lcJID);
   xmlnode_put_attrib(loJID,"J2S_RTAddr",lcJID);

   loSubj=xmlnode_get_tag(jtin->config,"jabber/subject");
   if ( loSubj!=NULL)
      {
      xmlnode_put_attrib(loJID,"J2S_SRMode",xmlnode_get_attrib(loSubj,"replace"));
      xmlnode_put_attrib(loJID,"J2S_SRSeparator",xmlnode_get_attrib(loSubj,"separator"));
      xmlnode_put_attrib(loJID,"J2S_SRText",xmlnode_get_data(loSubj));
      }


   loSubj=xmlnode_get_tag(jtin->config,"smtp/subject");
   if ( loSubj!=NULL)
      {
      xmlnode_put_attrib(loJID,"S2J_SRMode",xmlnode_get_attrib(loSubj,"replace"));
      xmlnode_put_attrib(loJID,"S2J_SRSeparator",xmlnode_get_attrib(loSubj,"separator"));
      xmlnode_put_attrib(loJID,"S2J_SRText",xmlnode_get_data(loSubj));
      }
   
   xmlnode_put_attrib(loJID,"default","1"); // flag of default item
   return loJID;
   }

xmlnode smtp_roster_get_item( char *lcJID, int liDefault)
   {
   xmlnode loJID=NULL,loFile;
   int liFound=0;
   char *lcLetter;
   pool p;

   if (j_strlen(lcJID)==0)
      return (xmlnode) NULL;

   p=pool_new();
   smtp_PoolsReg(1801, p);

 
   lcLetter = (char*)pmalloc_x(p, 4,'\0');
   lcLetter[0]=lcJID[0];
   if (lcJID[0]<0)
      toEscape(lcLetter,(void *)lcLetter,"()<>,;:\"/[]?");

   loFile=xmlnode_get_tag(jtin->roster,spools(p,"file?type=",lcLetter,p));

   if (loFile!=NULL)
      if ((loFile=xmlnode_get_tag(jtin->roster_files,spools(p,"file?type=",lcLetter,p)))!=NULL)
         {
         if ((loJID=xmlnode_get_tag(loFile,spools(p,"item?jid=",lcJID,p)))!=NULL)
            {
            liFound=1;
            if (j_strlen(xmlnode_get_attrib(loJID,"J2S_RTMode"))==0)
               {
               xmlnode_put_attrib(loJID,"J2S_RTMode","0");
               xmlnode_put_attrib(loJID,"J2S_RTName",lcJID);
               xmlnode_put_attrib(loJID,"J2S_RTAddr",lcJID);
               }
            }
         }

   if (liFound==0 && liDefault!=0) // if not found and must return default item
      loJID=smtp_roster_get_defaultitem(lcJID);


   pool_free(p);
   return loJID;
   }


void smtp_roster_set_item(char *lcJID, xmlnode loJID)
   {
   xmlnode loFile,loJIDOld,loFileM;
   char *lcFile, *lcLetter;
   pool p;

   int liSaveM=0;
   if (j_strlen(lcJID)==0)
      return ;

   p=pool_new();
   smtp_PoolsReg(1802, p);

   lcLetter = (char*)pmalloc_x(p, 4,'\0');
   lcLetter[0]=lcJID[0];
   if (lcJID[0]<0)
      toEscape(lcLetter,(void *)lcLetter,"()<>,;:\"/[]?");

   xmlnode_hide_attrib(loJID,"default");

   if ((loFileM=xmlnode_get_tag(jtin->roster,spools(p,"file?type=",lcLetter,p)))==NULL)
      {
      // zznam pro dan psmeno neexistuje
      lcFile = (char*)pmalloco(p, 254);
      lcFile[-1] = '\0';
      lcFile=spools(p,jtin->roster_folder,"/roster_",lcLetter,".xml",p);

      xmlnode_put_attrib((loFileM=xmlnode_insert_tag(jtin->roster,"file")),"type",lcLetter);
      xmlnode_insert_cdata(loFileM,lcFile,-1);
      liSaveM=1;
      }
   else
      lcFile=xmlnode_get_data(loFileM);

   if ((loFile=xmlnode_get_tag(jtin->roster_files,spools(p,"file?type=",lcLetter,p)))==NULL)
      {
      // zznam pro dan psmeno neexistuje
      xmlnode_put_attrib(loFile=xmlnode_insert_tag(jtin->roster_files,"file"),"type",lcLetter);
      }


   if ((loJIDOld=xmlnode_get_tag(loFile,spools(p,"item?jid=",lcJID,p)))==NULL)
      {
      // new item
      xmlnode_insert_node(loFile,loJID);
      }
   else
      {
      // replace item
      }
      
   if (xmlnode2file(lcFile,loFile)!=1)
      {
      log_alert("smtp","ROSTER - Cannot save roster-letter file %s.",lcFile);
      smtp_SendInfoToAdmin(spools(p,"ROSTER - Cannot save roster-letter file ",lcFile,".",p ),SMTP_SITA_P);
      }


   if (liSaveM==1)
      if ( xmlnode2file(jtin->roster_file,jtin->roster)!=1)
         {
         log_alert("smtp","ROSTER - Cannot save main roster file %s.",jtin->roster_file);
         smtp_SendInfoToAdmin(spools(p,"ROSTER - Cannot save main roster file ",jtin->roster_file,".",p ),SMTP_SITA_P);
         }
   
   pool_free(p);
   }


void smtp_roster_remove_item(char *lcJID)
   {
   xmlnode loFile,loJIDOld,loFileM;
   char *lcFile, *lcLetter;
   pool p;


   if (j_strlen(lcJID)==0)
      return;

   p=pool_new();
   smtp_PoolsReg(1803, p);

   lcLetter = (char*)pmalloc_x(p, 4,'\0');
   lcLetter[0]=lcJID[0];
   if (lcJID[0]<0)
      toEscape(lcLetter,(void *)lcLetter,"()<>,;:\"/[]?");

   if ((loFileM=xmlnode_get_tag(jtin->roster,spools(p,"file?type=",lcLetter,p)))!=NULL)
      // zznam pro dan psmeno existuje
      {
      lcFile=xmlnode_get_data(loFileM);
      if ((loFile=xmlnode_get_tag(jtin->roster_files,spools(p,"file?type=",lcLetter,p)))!=NULL)
         {
         // zznam pro dan psmeno existuje
         if ((loJIDOld=xmlnode_get_tag(loFile,spools(p,"item?jid=",lcJID,p)))!=NULL)
            {
            // item exist
            xmlnode_hide(loJIDOld);
            if (xmlnode2file(lcFile,loFile)!=1)
               {
               log_alert("smtp","ROSTER - Cannot save roster-letter file %s.",lcFile);
               smtp_SendInfoToAdmin(spools(p,"ROSTER - Cannot save roster-letter file ",lcFile,".",p ),SMTP_SITA_P);
               }
            }
         }
      }

   pool_free(p);
   }



smtp_cjid smtp_cjidNew(xmlnode loNode,char *lcJID)
   {
   smtp_cjid item;
   pool p;

   if (loNode==NULL && lcJID==NULL)
      return NULL;

   if (loNode==NULL)
      {
      item=pmalloco(p=pool_new(), sizeof(_smtp_cjid));
      smtp_PoolsReg(40, p);
      smtp_PoolsSettmp(p, 0);

      item->p=p;
      item->item=xmlnode_new_tag_pool(p,"item");
      item->cJID=pstrdup(p,lcJID);
      xmlnode_put_attrib(item->item,"jid",lcJID);
      }
   else
      {
      item=pmalloco(p=xmlnode_pool(loNode), sizeof(_smtp_cjid));
      item->p=p;
      item->item=loNode;
      item->cJID=xmlnode_get_attrib(loNode,"jid");
      }

   item->offitem=xmlnode_new_tag_pool(p,"item");
   item->last=NULL;
   item->iLogin=0;

   return item;
   }


smtp_cjid smtp_cjidGet(char *lcJID)
   {
   smtp_cjid next=jtin->ContactList,b=NULL;
   while(next != NULL)
        {
        if (j_strcmp(next->cJID,lcJID)==0)
           {
           b=next;
           break;
           }

        if (next->next != NULL)
           next = next->next;
        else
           break;

        }
   return b;
   }


smtp_cjid smtp_cjidAppend(smtp_cjid b)
   {
   smtp_cjid root=jtin->ContactList,last;
   if (b == NULL)
      return NULL;

   if (root == NULL)
      {
      jtin->ContactList=b;
      return b;
      }

   if ((last=root->last)==NULL) // save Last item
      root->last=root->next=b;
   else
      {
      last->next=b;
      root->last=b;
      }

   return b;
   }


void smtp_cjidDel(char *lcJID)
   {
   smtp_cjid root=jtin->ContactList,next=jtin->ContactList,prev;
   if (lcJID==NULL)
       return;

   while(next != NULL)
        {
        if (j_strcmp(next->cJID,lcJID)==0)
           {
           if (next==root && next->next==NULL) // root item
              jtin->ContactList=NULL; // clear it
           else if (next==root && next->next!=NULL) // check to first item
              {
              jtin->ContactList=next->next;
              jtin->ContactList->last=next->last;
              }
           else if (root->last==next) // check to last item
              {
              root->last=prev; // copy last item to rootlast
              prev->next=NULL; // clear next item
              }
           else
              prev->next=next->next;  // change next item

           pool_free(next->p); // free item
           break;
           }

        prev=next;
        if (next->next != NULL)
           next = next->next;
        else
           break;
        }
   return ;
   }


int smtp_cjidGetCount(int liFlag)
   {
   int lii=0;
   smtp_cjid next=jtin->ContactList;
   xmlnode loJID;
   
   while(next != NULL)
        {
        if (liFlag==0)
           lii++;
        else
           {
           // get paid flag from roster
           loJID=smtp_roster_get_item(xmlnode_get_attrib(next->item,"jid") ,0);
           if (loJID!=NULL && j_atoi(xmlnode_get_attrib(loJID,"paid"),0)!=0)
               lii++;

           }


        if (next->next != NULL)
           next = next->next;
        else
           break;

        }
   return lii;
   }


int smtp_cjidGetMem()
   {
   int lii=0;
   smtp_cjid next=jtin->ContactList;
   
   while(next != NULL)
        {
        lii+=pool_size(next->p);
        if (next->next != NULL)
           next = next->next;
        else
           break;

        }
   return lii;
   }

int smtp_cjidGetContactsCount()
   {
   int lii=0;
   smtp_cjid next=jtin->ContactList;
   xmlnode loTo;

   
   while(next != NULL)
        {

        for (loTo = xmlnode_get_tag(next->item,"to"); loTo != NULL; loTo = xmlnode_get_nextsibling(loTo))
            {
            if (loTo->type!=NTYPE_TAG)
                continue;

            lii++;
            }

        if (next->next != NULL)
           next = next->next;
        else
           break;

        }
   return lii;
   }


int smtp_online_add_item(char *lcFrom, char *lcTo)
   {
   xmlnode loTo;
   smtp_cjid loItem;
   int liCount=0;
   char *lcFile;
   pool p=pool_new();
   smtp_PoolsReg(1804, p);

   if ((loItem=smtp_cjidGet(lcFrom))==NULL) // find item in list
      smtp_cjidAppend(loItem=smtp_cjidNew(NULL,lcFrom)); // not exist add it
  

   // check to item
   if (j_strlen(lcTo)>0)
      {
      if ((loTo=xmlnode_get_tag(loItem->item,spools(p,"to=",lcTo,p)))==NULL)
         {
         // record is not exist, create it
         // check if exist subitem in offline list
         if ((loTo=xmlnode_get_tag(loItem->offitem,spools(p,"to=",lcTo,p)))==NULL)
            xmlnode_insert_cdata(loTo=xmlnode_insert_tag(loItem->item,"to"),lcTo,-1);
         else
            {
            smtp_xmlnode_move_node(loTo, loItem->offitem, loItem->item);
            }

          liCount=1;
         }
      }
   else
      {
      loItem->iLogin=1;
      for (loTo = xmlnode_get_tag(loItem->offitem,"to"); loTo != NULL; loTo = xmlnode_get_tag(loItem->offitem,"to"))
          {
          if (loTo->type!=NTYPE_TAG)
      	    continue;

          smtp_xmlnode_move_node(loTo, loItem->offitem, loItem->item);
          liCount++;
          }
      }

   if (liCount>0)
      {
      lcFile=spools(p,jtin->roster_folder,"/",lcFrom,".xml",p);
      if (xmlnode2file(lcFile,loItem->item)!=1)
         {
         log_alert("smtp","ROSTER contacts - Cannot save roster-contacts file %s.",lcFrom);
         smtp_SendInfoToAdmin(spools(p,"ROSTER contacts - Cannot save contacts-letter file ",lcFrom,".",p ),SMTP_SITA_P);
         }
      }

   pool_free(p);
   return liCount;
   }

int smtp_online_remove_item(char *lcFrom, char *lcTo)
   {
   xmlnode loTo;
   smtp_cjid loItem;
   int liCount=0;
   char *lcFile;
   pool p;

   if ((loItem=smtp_cjidGet(lcFrom))==NULL) // find item in list
      return 0;      // record is not exist

   p=pool_new();
   smtp_PoolsReg(1805,p);

   lcFile=spools(p,jtin->roster_folder,"/",lcFrom,".xml",p);

   if (j_strlen(lcTo)>0) // remove sub item
      {
      // check to item
      if ((loTo=xmlnode_get_tag(loItem->item,spools(p,"to=",lcTo,p)))!=NULL)
         {
         liCount=1;
         smtp_xmlnode_move_node(loTo, loItem->item, loItem->offitem);
         }
      }
   else
      {
      // move subitems to offline, walk all item 
      for (loTo = xmlnode_get_tag(loItem->item,"to"); loTo != NULL; loTo = xmlnode_get_nextsibling(loTo))
          {
          if (loTo->type!=NTYPE_TAG)
      	    continue;

          liCount++;
          }
      }


   if (j_strlen(lcTo)==0 || xmlnode_get_tag(loItem->item,"to")==NULL)
      {
      smtp_cjidDel(lcFrom);
      // Delete file 
      remove(lcFile);
      }
   else
      {
      if (xmlnode2file(lcFile,loItem->item)!=1)
         {
         log_alert("smtp","ROSTER contacts - Cannot save roster-contacts file %s.",lcFrom);
         smtp_SendInfoToAdmin(spools(p,"ROSTER contacts - Cannot save contacts-letter file ",lcFrom,".",p ),SMTP_SITA_P);
         }
      }

   pool_free(p);
   return liCount;
   }
