/* --------------------------------------------------------------------------
 *
 * License
 *
 * The contents of this file are subject to the Jabber Open Source License
 * Version 1.0 (the "License").  You may not copy or use this file, in either
 * source code or executable form, except in compliance with the License.  You
 * may obtain a copy of the License at http://www.jabber.com/license/ or at
 * http://www.opensource.org/.  
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyrights
 * 
 * Portions created by or assigned to Jabber.com, Inc. are 
 * Copyright (c) 1999-2000 Jabber.com, Inc.  All Rights Reserved.  Contact
 * information for Jabber.com, Inc. is available at http://www.jabber.com/.
 *
 * Portions Copyright (c) 1998-1999 Jeremie Miller.
 *
 * Portions Copyright (c) 2002 Matthias Wimmer.
 * 
 * Portions Copyright (c) 2006 Martin Jindra.
 * 
 * Acknowledgements
 * 
 * Special thanks to the Jabber Open Source Contributors for their
 * suggestions and support of Jabber.
 * 
 * --------------------------------------------------------------------------*/
 
#include "smtp.h"

smtpi  jtin;


/*

This is the smtp server component.

It acts as a simple SMTP server for both receiving email directly from another server or for delivering
email to another server.

What inspired me to write this very frightening thing is a mystery :) 

Jer

*/

/* takes foo@mapped.host or foo%jabber.org@smtp.host and translates to foo@jabber.org */

jid smtp_mx2( jid id)
   {
   char *at, *trhost;
   xmlnode tr;

   if(id == NULL || id->user == NULL) return NULL;

   log_notice(ZONE,"mx2 checking %s",jid_full(id));

   // query for any translation
   if ((at = strstr(id->user,"%")) != NULL)
      {
      *at = '@';
      id = jid_new(id->p,id->user);

      // check to make sure this id is valid to relay between 
      if (id != NULL && jtin->SMTP_Open == 0 && 
          smtp_check_list(jid_full(id),xmlnode_get_tag(jtin->config,"smtp/opens/item"))!=1
          )
         return NULL;

//          xmlnode_get_tag(jtin->config,spools(id->p,"smtp/open=",id->server,id->p)) == NULL

      }
   else
      {
      tr = xmlnode_get_tag(jtin->config, spools(id->p, "core/map?mxhost=",id->server,id->p));
      trhost = xmlnode_get_attrib(tr,"jabber");

      if (trhost == NULL)
         return NULL;

      jid_set(id,trhost,JID_SERVER);
      }

   log_notice(ZONE,"mx2 returning %s",jid_full(id));
   return id;
   }

/* takes foo@jabber.org and translates to foo@mapped.host or foo%jabber.org@smtp.host */
jid smtp_2mx( jid from)
   {
   char *at, *trhost, *strid;
   jid id;
   xmlnode tr;

   if(from == NULL || from->user == NULL) return NULL;

   log_debug(ZONE,"2mx checking %s",jid_full(from));

   /* copy jid and modify copy for the result */
   id = jid_new(from->p,jid_full(from));
   jid_set(id,NULL,JID_RESOURCE);

   /* query for any translation */
   tr = xmlnode_get_tag(jtin->config, spools(id->p, "core/map?jabber=",id->server,id->p));
   trhost = xmlnode_get_attrib(tr,"mxhost");

   if (trhost != NULL)
      jid_set(id,trhost,JID_SERVER);
   else
      {
      // check to make sure this id is valid to relay between 
      if (id != NULL && jtin->Jabber_Open == 0 && 
          smtp_check_list(jid_full(id),xmlnode_get_tag(jtin->config,"jabber/opens/item"))!=1
         )
         return NULL;

//          xmlnode_get_tag(jtin->config,spools(id->p,"jabber/open=",id->server,id->p)) == NULL




      strid = jid_full(id);
      at = strstr(strid,"@");
      *at = '%';
      id = jid_new(id->p,jtin->me);
      jid_set(id,strid,JID_USER);
      }

   log_debug(ZONE,"2mx returning %s",jid_full(id));
   return id;
   }

void smtp_SendInfoToAdmin(const char *lcMSG,int liType)
   {
   xmlnode loMSG,loAdmin;
   if (liType==SMTP_SITA_P)
      loMSG= xmlnode_new_tag("presence");
   else
      loMSG= xmlnode_new_tag("message");

   smtp_PoolsReg(1420, xmlnode_pool(loMSG));

   xmlnode_put_attrib(loMSG,"from",jtin->met);

   if (liType==SMTP_SITA_P)
      {
      xmlnode_insert_cdata(xmlnode_insert_tag(loMSG,"show"),"chat",-1);
      xmlnode_insert_cdata(xmlnode_insert_tag(loMSG,"status"),lcMSG,-1);
      }
   else
      {
      xmlnode_put_attrib(loMSG,"type","chat");
      xmlnode_insert_cdata(xmlnode_insert_tag(loMSG,"body"),lcMSG,-1);
      }

   for (loAdmin = xmlnode_get_firstchild(xmlnode_get_tag(jtin->config,"core/admins")); loAdmin != NULL; loAdmin = xmlnode_get_nextsibling(loAdmin))
       {
       if (loAdmin->type!=NTYPE_TAG || strcmp(xmlnode_get_attrib(loAdmin,"xmlns"),"smtp:admin:info_track")!=0 )
	       	    continue;

       xmlnode_put_attrib(loMSG,"to",xmlnode_get_data(loAdmin));
       deliver(dpacket_new(xmlnode_dup(loMSG)),jtin->i);
       }

   xmlnode_free(loMSG);
   }


result smtp_memtest(void *arg)
   {
   pool p=pool_new();
   char *lcPom=(char*) pmalloc_x(p, 4,' ');
   *(lcPom+3)='\0';
   
   if (jtin->memtest==NULL)
      jtin->memtest=xmlnode_new_tag_pool(jtin->i->p,"test");

   xmlnode_put_attrib(jtin->memtest,"test",lcPom);
log_notice("smtp","========= MEMTEST");

   return r_DONE;
   }


void smtp(instance i, xmlnode x)
   {
   xmlnode config,configF, cur, jep0033, loFile, loRF,loBackup,loOffline,loJID;
   xdbcache xc;
   char *lcPom,*lcFile;
   int liErr,lii,liFolderC;
   struct dirent   *dirp;
   DIR      *dp;
   pool p;


   log_debug(ZONE,"SMTP transport loading");
   xc = xdb_cache(i);
   config = xdb_get(xc, jid_new(xmlnode_pool(x),"config@-internal"),"jabber:config:smtp");

   jtin = pmalloco(i->p,sizeof(_smtpi));
   jtin->met = xmlnode_get_attrib(xmlnode_get_parent(x),"id");

   /* set up internal instance and hash tables */
   jtin->i = i;
   jtin->xc = xc;
   jtin->jep0033= jtin->tmpBackupJabber=jtin->tmpBackupSMTP=
       jtin->tmpOfflineJabber=jtin->tmpOfflineSMTP=jtin->tmpCoreTmp=0;
   jtin->cSMTP_Status[0]=jtin->cJabber_Status[0]=' ';
   jtin->cSMTP_Status[1]=jtin->cJabber_Status[1]='\0';
   jtin->ContactList=NULL;
   jtin->memtest=NULL;
   jtin->pools=NULL;

   p=pool_new();
   smtp_PoolsReg(100, p);

   // get resources file name and read it
   if ((jtin->config_file=xmlnode_get_tag_data(config,"config"))==NULL)
      jtin->config_file=pstrdup(i->p,SMTP_CONFIG_FILE);

   if ((configF=xmlnode_file(jtin->config_file))==NULL)
      { // file not exist or any other bug
      log_error("smtp","Transport cannot load config file.");
      return;
      }
   jtin->config = xmlnode_dup_pool(i->p, configF);
   xmlnode_free(configF);

   // try create backup folder
   loBackup=xmlnode_get_tag(jtin->config,"jabber/backup");
   if ((jtin->jabber_backup=xmlnode_get_attrib(loBackup,"folder")   )==NULL)
      jtin->jabber_backup= pstrdup(i->p,SMTP_BACKUPJABBER_FOLDER);

   if (smtp_CreateFolder(jtin->jabber_backup)==0 &&
       (liFolderC=smtp_CreateFolder(spools(p,jtin->jabber_backup,"/old",p)))==0)
      jtin->tmpBackupJabber=1;


   // test if any file in folder, if yes, send mesage to all admins
   if (jtin->tmpBackupJabber==1 && (dp = opendir(jtin->jabber_backup))!=NULL)
      {
      lii=0;
      while ( (dirp = readdir((DIR *)dp)) != NULL)
            {
            if (strcmp(dirp->d_name, ".") == 0  ||
                strcmp(dirp->d_name, "..") == 0 ||
                strcmp(dirp->d_name, "old") == 0)
               continue;      // ignore dot and dot-dot 

            rename(spools(p,jtin->jabber_backup,"/",dirp->d_name,p),spools(p,jtin->jabber_backup,"/old/",dirp->d_name,p));

            lii++;
            }
      closedir((DIR *)dp);

      if (lii>0)
         smtp_SendInfoToAdmin(spools(p,"Any jabber message (",smtp_itoa(p,lii),") cause reboot.",p),SMTP_SITA_M );
      }


   loBackup=xmlnode_get_tag(jtin->config,"smtp/backup");
   if ((jtin->smtp_backup=xmlnode_get_attrib(loBackup,"folder") )==NULL)
      jtin->smtp_backup= pstrdup(i->p,SMTP_BACKUPSMTP_FOLDER);


   if (smtp_CreateFolder(jtin->smtp_backup)==0 &&
       (liFolderC=smtp_CreateFolder(spools(p,jtin->smtp_backup,"/old",p)))==0)
      jtin->tmpBackupSMTP=1;

   // test if any file in folder, if yes, send mesage to all admins
   if (jtin->tmpBackupSMTP==1 && (dp = opendir(jtin->smtp_backup)) != NULL)
      {
      lii=0;
      while ( (dirp = readdir((DIR *)dp)) != NULL)
            {
            if (strcmp(dirp->d_name, ".") == 0  ||
                strcmp(dirp->d_name, "..") == 0 ||
                strcmp(dirp->d_name, "old") == 0)
               continue;      // ignore dot and dot-dot

            rename(spools(p,jtin->smtp_backup,"/",dirp->d_name,p),spools(p,jtin->smtp_backup,"/old/",dirp->d_name,p));

            lii++;
            }
      closedir((DIR *)dp);

      if (lii>0)
         smtp_SendInfoToAdmin(spools(p,"Any SMTP message (",smtp_itoa(p,lii),") cause reboot.",p),SMTP_SITA_M);
      }



   // try create offline folder - jabber
   loOffline=xmlnode_get_tag(jtin->config,"jabber/offline");
   if ((jtin->jabber_offline=xmlnode_get_attrib(loOffline,"folder"))==NULL)
      jtin->jabber_offline= pstrdup(i->p,SMTP_OFFLINEJABBER_FOLDER);

   if (smtp_CreateFolder(jtin->jabber_offline)==0)
      jtin->tmpOfflineJabber=1;


   // try create offline folder - smtp
   loOffline=xmlnode_get_tag(jtin->config,"smtp/offline");
   if ((jtin->smtp_offline=xmlnode_get_attrib(loOffline,"folder"))==NULL)
      jtin->smtp_offline= pstrdup(i->p,SMTP_OFFLINESMTP_FOLDER);

   if (smtp_CreateFolder(jtin->smtp_offline)==0)
      jtin->tmpOfflineSMTP=1;


   // try create tmp folder - core
   jtin->core_tmp= pstrdup(i->p,SMTP_CORETMP_FOLDER);
   if (smtp_CreateFolder(jtin->core_tmp)==0)
      jtin->tmpCoreTmp=1;


   // get default language
   if ((lcPom=xmlnode_get_tag_data(jtin->config,"core/language"))==NULL)
      lcPom= SMTP_RC_DEFAULT_LANG;

   jtin->DefaultLang=pstrdup(i->p, lcPom);

   // get statistics file name and read it
   if ((jtin->stat_file=xmlnode_get_tag_data(jtin->config,"core/statistics"))==NULL)
      jtin->stat_file=pstrdup(i->p, SMTP_STATISTICS_FILE);

   lcPom = (char*)pstrdup(p,jtin->stat_file);
   smtp_GetFolderFromFile(lcPom);
   liErr=smtp_CreateFolder(lcPom);


   if (liErr!=0)
      { // file not exist or any other bug
      log_error("smtp","Transport cannot create folder for statistics file");
      return;
      }

   // Create statistics structure
   jtin->Stats=(smtp_stats) pmalloco(jtin->i->p, sizeof(_smtp_stats));
   jtin->Stats->StartLastDatetime = (char*) pmalloc_x(jtin->i->p, 18,' ');

   // Fill it from XML File
   if ((cur=xmlnode_file(jtin->stat_file))==NULL)
      { // file not exist or any other bug
      log_warn("smtp","Transport cannot load statistics file (%s).",jtin->stat_file);
      smtp_SendInfoToAdmin(spools(p, "Transport cannot load statistics file (",jtin->stat_file,").",p),SMTP_SITA_P );

      jtin->Stats->Start=0;

	  jtin->Stats->_JabberMessages=0;
      jtin->Stats->_JabberMessagesOut=0;
      jtin->Stats->_JabberMessagesOutError=0;

      jtin->Stats->_SMTPCommandUnknown=0;
      jtin->Stats->_SMTPMessages=0;
      jtin->Stats->_SMTPMessagesIn=0;
      jtin->Stats->_SMTPMessagesInError=0;

      jtin->Stats->_SMTPSpam=0;
      }  
   else
      {
      // Fill it from XML File
      jtin->Stats->Start=j_atoi(xmlnode_get_attrib(cur,"Start"),0);

	  jtin->Stats->_JabberMessages=j_atoi(xmlnode_get_attrib(cur,"JabberMessages"),0);
      jtin->Stats->_JabberMessagesOut=j_atoi(xmlnode_get_attrib(cur,"JabberMessagesOut"),0);
      jtin->Stats->_JabberMessagesOutError=j_atoi(xmlnode_get_attrib(cur,"JabberMessagesOutError"),0);

      jtin->Stats->_SMTPCommandUnknown=j_atoi(xmlnode_get_attrib(cur,"SMTPCommandUnknown"),0);
      jtin->Stats->_SMTPMessages=j_atoi(xmlnode_get_attrib(cur,"SMTPMessages"),0);
      jtin->Stats->_SMTPMessagesIn=j_atoi(xmlnode_get_attrib(cur,"SMTPMessagesIn"),0);
      jtin->Stats->_SMTPMessagesInError=j_atoi(xmlnode_get_attrib(cur,"SMTPMessagesInError"),0);

      jtin->Stats->_SMTPSpam=j_atoi(xmlnode_get_attrib(cur,"SMTPSpam"),0);

      xmlnode_free(cur);
      }
   

   jtin->Stats->_CoreContacts=0;
   jtin->Stats->_CoreContactsOnline=0;
   


   // get resources file name and read it
   if ((jtin->res_file=xmlnode_get_tag_data(jtin->config,"core/resources"))==NULL)
      jtin->res_file=pstrdup(i->p,SMTP_RESOURCE_FILE);

   if ((jtin->resources=xmlnode_file(jtin->res_file))==NULL)
      { // file not exist or any other bug
      log_error("smtp","Transport cannot load resource file (%s).",jtin->res_file);
      return;
      }

   smtp_PoolsReg(2000, xmlnode_pool(jtin->resources));
   smtp_PoolsSettmp(xmlnode_pool(jtin->resources), 0);

   // get roster
   if ((jtin->roster_file=xmlnode_get_tag_data(jtin->config,"core/roster"))==NULL)
      jtin->roster_file=pstrdup(i->p,SMTP_ROSTER_FILE);

   jtin->roster_folder=smtp_GetFolderFromFile((char*)pstrdup(i->p,jtin->roster_file));
   liErr=smtp_CreateFolder(jtin->roster_folder);
   if (liErr!=0)
      { // file not exist or any other bug
      log_error("smtp","Transport cannot create folder (%s) for roster file.",jtin->roster_folder);
      return;
      }

   liErr=smtp_CreateFolder(spools(p,jtin->roster_folder,"/backup",p));
   if (liErr!=0)
      { // file not exist or any other bug
      log_error("smtp","Transport cannot create folder (%s) for roster file.",spools(p,jtin->roster_folder,"/backup",p));
      return;
      }


   jtin->roster_files=xmlnode_new_tag("smtp");
   smtp_PoolsReg(2021, xmlnode_pool(jtin->roster_files));
   smtp_PoolsSettmp(xmlnode_pool(jtin->roster_files), 0);

   xmlnode_put_attrib(jtin->roster_files,"xmlns","jabber:rosterfiles:smtp");

   if ((jtin->roster=xmlnode_file(jtin->roster_file))==NULL)
      { // file not exist or any other bug
      jtin->roster=xmlnode_new_tag("smtp");
      xmlnode_put_attrib(jtin->roster,"xmlns","jabber:roster:smtp");
      log_warn("smtp","Transport cannot load roster file (%s)", jtin->roster_file);
      smtp_SendInfoToAdmin(spools(p, "Transport cannot load roster file (",jtin->roster_file,").",p),SMTP_SITA_M );
      }  
   else
      {
      // build file list from roster.xml
      for (loFile = xmlnode_get_firstchild(jtin->roster); loFile != NULL; loFile = xmlnode_get_nextsibling(loFile))
          {
          if (loFile->type!=NTYPE_TAG)
              continue;

          lcFile=xmlnode_get_data(loFile);
          if ((loRF=xmlnode_file(lcFile))==NULL)
             {
             log_warn("smtp","Transport cannot read roster file %s",lcFile);
             smtp_SendInfoToAdmin(spools(p, "Transport cannot read roster file ",lcFile,".",p),SMTP_SITA_M );
             continue;
             }

          xmlnode_insert_node(jtin->roster_files,loRF);
          xmlnode_free(loRF);
          }
      }
   smtp_PoolsReg(2020, xmlnode_pool(jtin->roster));
   smtp_PoolsSettmp(xmlnode_pool(jtin->roster), 0);

   // Read contacts
   if ((dp = opendir(jtin->roster_folder))!=NULL)
      {
      while ( (dirp = readdir((DIR *)dp)) != NULL)
            {
            if (strcmp(dirp->d_name, ".") == 0  ||
                strcmp(dirp->d_name, "..") == 0 ||
                strcmp(dirp->d_name, "backup") == 0 ||
                strchr(dirp->d_name,'@')==NULL)
               continue;      // ignore dot and dot-dot and not contacts list

            // try read file with contacts
            // if reading failed, then copy it to backup folder
            //  and send info to admin

            lcFile=spools(p,jtin->roster_folder,"/",dirp->d_name,p);
            if ((cur=xmlnode_file(lcFile))==NULL)
               {
               log_warn("smtp","Transport cannot load contact file (%s)", lcFile);
               smtp_SendInfoToAdmin(spools(p, "Transport cannot load contact file (",lcFile,").",p),SMTP_SITA_M );
               rename(lcFile,spools(p,jtin->roster_folder,"/backup/",dirp->d_name,p));
               continue;
               }

            smtp_PoolsReg(2030, xmlnode_pool(cur));
            smtp_PoolsSettmp(xmlnode_pool(cur), 0);

            smtp_cjidAppend(smtp_cjidNew(cur,NULL));
            }
      closedir((DIR *)dp);
      }


   // recalc user's accounts by saved files
   lii=0;
   for (loFile = xmlnode_get_tag(jtin->roster_files,"file"); loFile != NULL; loFile = xmlnode_get_nextsibling(loFile))
       {
       if (loFile->type!=NTYPE_TAG)
          continue;

       // walk all jid in file
       for (loJID = xmlnode_get_tag(loFile,"item"); loJID != NULL; loJID = xmlnode_get_nextsibling(loJID))
           {
           if (loJID->type!=NTYPE_TAG)
               continue;

           lii++;
           }
       }
   jtin->Stats->_CoreAccounts=lii;


   // main body
   if ((jtin->me = xmlnode_get_tag_data(jtin->config,"jabber/mxhost")) == NULL)
      {
      log_error("smtp","Transport must have a default SMTP <mxhost>smtp.host.foo</mxhost> configured");
      return;
      }

   if (xmlnode_get_tag(jtin->config,"smtp/opens") == NULL)
      jtin->SMTP_Open = 1;

   if (xmlnode_get_tag(jtin->config,"jabber/opens") == NULL)
      jtin->Jabber_Open = 1;

   if (xmlnode_get_tag(jtin->config,"smtp/spamer") == NULL)
      jtin->Spamer_Open = 1;

   // relay smtp server
   cur = xmlnode_get_tag(jtin->config,"jabber/relay");
   jtin->relayport=j_atoi(xmlnode_get_attrib(cur, "port"), SMTP_Relay_Port);

   if((jtin->relay = xmlnode_get_attrib(cur,"ip")) == NULL)
       jtin->relay = pstrdup(i->p, SMTP_DEFAULT_RELAY);

   register_phandler(i, o_DELIVER, smtp_out_packets, (void *)jtin);


   jtin->spamcheck = xmlnode_get_tag_data(jtin->config,"smtp/spamcheck");


   // vytvoit vlastn thread
   if ((cur = xmlnode_get_tag(config,"smtp/ip")) != NULL)
      for (;cur != NULL; xmlnode_hide(cur), cur = xmlnode_get_tag(config,"smtp/ip"))
          {
          mio_listen(j_atoi(xmlnode_get_attrib(cur, "port"), SMTP_Incomming_Port), xmlnode_get_data(cur), smtp_in_read, (void*)jtin, NULL, NULL);
          }
   else // no special config, use defaults //
      mio_listen(SMTP_Incomming_Port, NULL, smtp_in_read, (void *)jtin, NULL, NULL);
 
   // JEP-0033 test
   cur = xmlnode_get_tag(jtin->config,"core/map");
   jep0033= xmlnode_new_tag_pool(p,"iq");

   xmlnode_put_attrib(jep0033,"to",xmlnode_get_attrib(cur, "jabber"));
 
   xmlnode_put_attrib(jep0033,"from",jtin->met);
   xmlnode_put_attrib(jep0033,"type","get");
   xmlnode_put_attrib(jep0033,"id","smtp_test_jep0033");
   xmlnode_put_attrib(xmlnode_insert_tag(jep0033,"query"),"xmlns","http://jabber.org/protocol/disco#info");

   deliver(dpacket_new(xmlnode_dup(jep0033)),i);

   if ((cur=xmlnode_get_tag(jtin->config,"jabber/offline"))!=NULL)
      register_beat(j_atoi(xmlnode_get_attrib(cur,"interval"),1)*60 , smtp_offline_jdaemon, (void *) 1);


   if ((cur=xmlnode_get_tag(jtin->config,"smtp/offline"))!=NULL)
      register_beat(j_atoi(xmlnode_get_attrib(cur,"interval"),1)*60 , smtp_offline_sdaemon, (void *) 1);

   if ((cur=xmlnode_get_tag(jtin->config,"core/paid"))!=NULL)
      register_beat(j_atoi(xmlnode_get_attrib(cur,"interval"),1)*3600 , smtp_paid_daemon, (void *)jtin);


   register_beat(60*SMTP_poolm_timeout , smtp_poolm_daemon, (void *)jtin);

//register_beat(5 , smtp_memtest, (void *)jtin);

   jtin->Stats->Start++;
   jtin->Stats->StartLastDatetime=smtp_GetDateTime(jtin->Stats->StartLastDatetime);
   smtp_StatsSave();

   SMTP_DEBUG(SMTP_ZONE,"Transport loaded - %s.",jtin->Stats->StartLastDatetime);
   smtp_SendInfoToAdmin(spools(p, "Transport loaded - ",jtin->Stats->StartLastDatetime,".",p),SMTP_SITA_M);

   pool_free(p);
   }


void smtp_StatsSave()
   {
   xmlnode loStats;
   loStats=xmlnode_new_tag("smtp");
   pool p=xmlnode_pool(loStats);

   xmlnode_put_attrib(loStats,"xmlns","jabber:status:smtp");

   xmlnode_put_attrib(loStats,"Start",smtp_itoa(p,jtin->Stats->Start));
   xmlnode_put_attrib(loStats,"StartLastDatetime",jtin->Stats->StartLastDatetime);

   xmlnode_put_attrib(loStats,"JabberMessages",smtp_itoa(p,jtin->Stats->_JabberMessages));
   xmlnode_put_attrib(loStats,"JabberMessagesOut",smtp_itoa(p,jtin->Stats->_JabberMessagesOut));
   xmlnode_put_attrib(loStats,"JabberMessagesOutError",smtp_itoa(p,jtin->Stats->_JabberMessagesOutError));

   xmlnode_put_attrib(loStats,"SMTPCommandUnknown",smtp_itoa(p,jtin->Stats->_SMTPCommandUnknown));
   xmlnode_put_attrib(loStats,"SMTPMessages",smtp_itoa(p,jtin->Stats->_SMTPMessages));
   xmlnode_put_attrib(loStats,"SMTPMessagesIn",smtp_itoa(p,jtin->Stats->_SMTPMessagesIn));
   xmlnode_put_attrib(loStats,"SMTPMessagesInError",smtp_itoa(p,jtin->Stats->_SMTPMessagesInError));

   xmlnode_put_attrib(loStats,"SMTPSpam",smtp_itoa(p,jtin->Stats->_SMTPSpam));

   xmlnode2file(jtin->stat_file,loStats);
   xmlnode_free(loStats);
   }

smtps smtp_new_out(mio m)
   {
   smtps so;

   so = pmalloco(mio_pool(m), sizeof(_smtps));
   so->m = m;
   so->p = mio_pool(m);
   so->x=so->oJID=so->oAD=NULL;
   so->jp=NULL;
   
   so->toPGPMIME=so->SRMode=0;
   so->SRSeparator=so->SRText=NULL;
   return so;
   }

smtpsi smtp_new_ino(pool p)
   {
   smtpsi si;
   si = pmalloco(p, sizeof(_smtpsi));
   si->m = NULL;
   si->p = p;
   si->omsg = xmlnode_new_tag_pool(p,"x");
   si->obody = xmlnode_insert_tag(si->omsg,"body");
   si->rcpt=si->rcptFD=NULL;
   return si;
   }

smtpsi smtp_new_in(mio m)
   {
   smtpsi si;
   si=smtp_new_ino(mio_pool(m));
   si->m = m;
   return si;
   }


smtpp smtp_param_i(pool p,instance i)
   {
   smtpp par;
   par=pmalloco(p, sizeof(_smtpp));
   par->tmppool=p;
   par->i = i;
   par->jp = NULL;
   par->lang=jtin->DefaultLang;
   return par;
   }


smptsi_rcp smtp_NewRecipient(pool p,jid ojid)
   {
   smptsi_rcp rcp;

   rcp=pmalloco(p, sizeof(_smptsi_rcp));
   rcp->rcpt=ojid;
   rcp->next=NULL;
   return rcp;
   }

smptsi_rcp smtp_AppendRcpt(smptsi_rcp a, smptsi_rcp b)
   {
   smptsi_rcp next;

   if (a == NULL)
      return NULL;

   if (b == NULL)
      return a;

   next = a;
   while(next != NULL)
        {
        if (next->next != NULL)
           next = next->next;
        else
           {
           next->next = b;
           break;
           }
        }
   return a;
   }




smtp_jq smtp_NewQueueItem(pool p, int liType)
   {
   smtp_jq item;
   item=pmalloco(p, sizeof(_smtp_jq));
   switch (liType)
      {
	  case SMTP_QUEUE_X:
           item->Data=pmalloco(p, sizeof(_smtp_jq_x));
           break;

	  case SMTP_QUEUE_CB:
           item->Data=pmalloco(p, sizeof(_smtp_jq_cb));
           break;
      }

   item->iType=liType;
   item->next=NULL;
   return item;
   }


smtp_jq smtp_AppendQueueItem(smtp_jq a, smtp_jq b)
   {
   smtp_jq next=a;

   if (a == NULL)
      return NULL;

   if (b == NULL)
      return a;

   while(next != NULL)
        {
        if (next->next != NULL)
           next = next->next;
        else
           {
           next->next = b;
           break;
           }
        }
   return b;
   }





void smtp_FlushQueue(instance i, smtp_jq item)
   {
   smtp_jq next = item;
   smtp_jq_cb item_cb; 
   smtp_jq_x item_x; 

   while(next != NULL)
        {
        switch (next->iType)
           {
	       case SMTP_QUEUE_X:
                (smtp_jq_x) item_x= (smtp_jq_x) next->Data;
                deliver(dpacket_new(xmlnode_dup(item_x->x)),i);
                xmlnode_free(item_x->x);
                break;

  	       case SMTP_QUEUE_CB:
                (smtp_jq_cb) item_cb= (smtp_jq_cb) next->Data;
                (*(smtp_queue_cb)item_cb->cb)(item_cb->arg);
                break;
           }

        next = next->next;
        }
   }





smtp_jcmdq smtp_CmdNew()
   {
   smtp_jcmdq item;
   pool p;
   item=pmalloco(p=pool_new(), sizeof(_smtp_jcmdq));
   smtp_PoolsReg(200, p);

   item->p=p;
   item->next=NULL;
   item->iLevel=0;
   item->cSessionID=NULL;
   return item;
   }


smtp_jcmdq smtp_CmdAppend(smtp_jcmdq b)
   {
   smtp_jcmdq next=jtin->qcmd;

   if (b == NULL)
      return NULL;

   if (next == NULL)
      {
      jtin->qcmd=b;
      return b;
      }

   while(next != NULL)
        {
        if (next->next != NULL)
           next = next->next;
        else
           {
           next->next = b;
           break;
           }
        }
   return b;
   }

smtp_jcmdq smtp_CmdGet(char *lcSessionID)
   {
   smtp_jcmdq next=jtin->qcmd,b=NULL;

   while(next != NULL)
        {
        if (j_strcmp(next->cSessionID,lcSessionID)==0)
           {
           b=next;
           break;
           }

        if (next->next != NULL)
           next = next->next;
        else
           break;

        }
   return b;
   }

void smtp_CmdDel(char *lcSessionID)
   {
   smtp_jcmdq next=jtin->qcmd,prev=NULL;
   if (lcSessionID==NULL)
       return;

   while(next != NULL)
        {
        if (j_strcmp(next->cSessionID,lcSessionID)==0)
           {
           if (next==jtin->qcmd)
              jtin->qcmd=NULL;
           else
              prev->next=next->next;

           pool_free(next->p);
           break;
           }

        prev=next;
        if (next->next != NULL)
           next = next->next;
        else
           break;
        }
   return ;
   }

int smtp_CmdGetMem()
   {
   smtp_jcmdq next=jtin->qcmd;
   int lii=0;

   while(next != NULL)
        {
        lii+=pool_size(next->p);

        if (next->next != NULL)
           next = next->next;
        else
           break;

        }
   return lii;
   }
