#include <jabberd.h>

#include <time.h>
#include <stdio.h>
#include <math.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <dirent.h>

//#include <iconv.h> // http://mir.zyrianes.net/cygwin/release/libiconv/

#define smtp_version "0.5.9.016"
#define smtp_name    "Jabber-SMTP-Transport"


#include "rc_strings.h"

#define MAXLOOP      100000

#define PHASE_NONE -1
#define PHASE_SEND 0
#define PHASE_CMD 1
#define PHASE_DATA 2

#define CMD_UNKNOWN -1
#define CMD_NONE 0
#define CMD_HELO 1
#define CMD_MAIL 2
#define CMD_RCPT 3
#define CMD_DATA 4
#define CMD_NOOP 5
#define CMD_RSET 6
#define CMD_QUIT 7
#define CMD_DATA2 8
#define CMD_RCPTE 31
#define CMD_DATAEND 32
#define CMD_EHLO 9

#define MIME_7BIT 0
#define MIME_8BIT 1
#define MIME_BINARY 2
#define MIME_QUOTED 3
#define MIME_BASE64 4


#define SPAM_OK          0
#define SPAM_NotDefined  1
#define SPAM_Error430   -1
#define SPAM_Error570   -2

#define SMTP_Relay_Port       25
#define SMTP_Incomming_Port 5225

#define SMTP_poolm_timeout  30 // minutes

#define NS_DATA  "jabber:x:data"


#define SMTP_JID_ICHS  "\"'<> \t,"

#define NS_COMMANDS    "http://jabber.org/protocol/commands"
#define NS_STATS       "http://jabber.org/protocol/stats"
#define NS_ADDRESS     "http://jabber.org/protocol/address"
#define NS_DISCO_INFO  "http://jabber.org/protocol/disco#info"
#define NS_DISCO_ITEMS "http://jabber.org/protocol/disco#items"
#define NS_DISCO       "http://jabber.org/protocol/disco"
#define NS_CAPS        "http://jabber.org/protocol/caps"
#define NS_XHTML_IM    "http://jabber.org/protocol/xhtml-im"

#define SMTP_BACKUPSMTP_FOLDER         "./spool/smtp/smtp-b"
#define SMTP_BACKUPJABBER_FOLDER       "./spool/smtp/jabber-b"
#define SMTP_OFFLINESMTP_FOLDER        "./spool/smtp/smtp-o"
#define SMTP_OFFLINEJABBER_FOLDER      "./spool/smtp/jabber-o"
#define SMTP_CORETMP_FOLDER            "./spool/smtp/tmp"


#define SMTP_STATISTICS_FILE           "./spool/statistics.xml"
#define SMTP_RESOURCE_FILE             "./smtp/resources.xml"
#define SMTP_ROSTER_FILE               "./spool/smtp/roster/roster.xml"
#define SMTP_CONFIG_FILE             "./smpt/config.xml"

#define SMTP_DEFAULT_RELAY             "localhost"


#define SMTP_PGP_ATTACH 0
#define SMTP_PGP_MIME   1
#define SMTP_PGP_NOMIME 2


#define SMTP_PGP_MESSAGE         "PGP MESSAGE"
#define SMTP_PGP_SIGNATURE       "PGP SIGNATURE"
#define SMTP_PGP_SIGNED_MESSAGE  "-----BEGIN PGP SIGNED MESSAGE-----"
#define SMTP_PGP_BEGIN           "-----BEGIN"
#define SMTP_PGP_END             "-----END"

#define SMTP_PGP_sBEGIN          "BEGIN"
#define SMTP_PGP_sEND            "END"
#define SMTP_PGP_MESSAGE_BEGIN   "-----BEGIN PGP MESSAGE-----"
#define SMTP_PGP_SIGNATURE_BEGIN "-----BEGIN PGP SIGNATURE-----"
#define SMTP_PGP_MESSAGE_END     "-----END PGP MESSAGE-----"
#define SMTP_PGP_SIGNATURE_END   "-----END PGP SIGNATURE-----"


#define SMTP_IN_DELIVER_ALL    0
#define SMTP_IN_DELIVER_GLOBAL 1
#define SMTP_IN_DELIVER_USER   2


#define SMTP_ADMIN_JID   0
#define SMTP_ADMIN_EMAIL 1

#define SMTP_ADMIN_NS_JID       "smtp:admin:jid"
#define SMTP_ADMIN_NS_EMAIL     "smtp:admin:email"
#define SMTP_ADMIN_NS_INFOTRACK "smtp:admin:info_track"
#define SMTP_ADMIN_NS_CONFIG    "smtp:admin:config"
#define SMTP_ADMIN_NS_TRANSPORT "smtp:admin:transport"
#define SMTP_ADMIN_NS_ACCOUNT   "smtp:admin:account"



#define SMTP_CODE_220 220
#define SMTP_CODE_221 221
#define SMTP_CODE_250 250
#define SMTP_CODE_251 251
#define SMTP_CODE_354 354
#define SMTP_CODE_404 404
#define SMTP_CODE_500 500
#define SMTP_CODE_503 503
#define SMTP_CODE_504 504
#define SMTP_CODE_550 550
#define SMTP_CODE_554 554
#define SMTP_CODE_553 553
#define SMTP_CODE_552 552

#define SMTP_DB
//#define SMTP_DEBUG log_notice
//#define SMTP_ZONE "smtp"
#define SMTP_DEBUG log_debug
#define SMTP_ZONE ZONE


#define SMTP_IN_EMAIL   0
#define SMTP_IN_OFFLINE 1


#define SMTP_QUEUE_X   0
#define SMTP_QUEUE_CB  1


#define SMTP_CMDG_TRANSPORT "!transport"
#define SMTP_CMDG_CONFIG    "!config"
#define SMTP_CMDG_ACCOUNT   "!account"

#define SMTP_SITA_P 0
#define SMTP_SITA_M 1


typedef struct smtp_jcmd_struc
{
struct smtp_jcmd_struc *next; /* next item */
void *Data;
char *cSessionID;
int iLevel;
pool p;
} *smtp_jcmdq,_smtp_jcmdq;


typedef struct smtp_roster_data_struc
{
char *jid,*J2S_RTName,*J2S_RTAddr,*J2S_SRSeparator,*J2S_SRText,*S2J_SRSeparator,*S2J_SRText,*Spamlist;
int UseGlobalSettings,Attachments,PGPJabberToMIME,PGPToJabbernonMIMETox,S2J_AllAreSPAM,J2S_RTMode,
    J2S_SRMode,S2J_SRMode;

} *smtp_rjiddata,_smtp_rjiddata;

/*
Roster map:
File->next (File)
  ->item->next (item->item)



*/

typedef struct smtp_roster_struc
{
struct smtp_roster_struc *next; /* next item - file*/
struct smtp_roster_struc *last; /* last item - file*/
char *cType; // first char
char *cFile; // XML file
xmlnode item; // first item of list
pool p;
} *smtp_rjid,_smtp_rjid;


typedef struct smtp_contacts_struc
{
struct smtp_contacts_struc *next; /* next item */
struct smtp_contacts_struc *last; /* last item */
xmlnode item;
xmlnode offitem;
char *cJID;
pool p;
int iLogin;
} *smtp_cjid,_smtp_cjid;


typedef struct smtp_pools_struc
{
struct smtp_pools_struc *next; /* next item */
struct smtp_pools_struc *last; /* last item */
pool p; // master pool
pool pl; // pool in list
int index;
int tmp;
time_t tstamp;
} *smtp_pools,_smtp_pools;

typedef struct smtp_stats_struct
{

   int JabberMessages,JabberMessagesOut,JabberMessagesOutError,
       SMTPCommandUnknown,SMTPMessages,
	   SMTPMessagesIn,SMTPMessagesInError,
       SMTPSpam, CoreAccounts;

   int Start;
   char *StartLastDatetime;

   int _JabberMessages, _JabberMessagesOut, _JabberMessagesOutError,
       _SMTPCommandUnknown,_SMTPMessages,_SMTPMessagesIn,_SMTPMessagesInError,
       _SMTPSpam,_CoreContacts,_CoreContactsOnline,_CoreAccounts;


} *smtp_stats, _smtp_stats;


/* smtp parser instance */
typedef struct smtpi_struct
{
   instance i;
   char *server; /* our master server address, if any */
   char *relay; /* the smtp relay delivering our messages for us */
   int relayport; /* the smtp relay port */
//   int timeout; /* how long to wait for an incoming request */
   char *me; /* our default smtp hostname */
   char *met; /* our default smtp transport JID */
   int SMTP_Open; /* if this component is wide open */
   int Jabber_Open; /* if this component is wide open */
   int Spamer_Open; /* if this component is wide open */
   char *spamcheck;
   int jep0033; /* JEP-0033: Extended Stanza Addressing, support */ 
   xmlnode config;
   xmlnode status;
   xdbcache xc;

   int tmpBackupJabber,tmpBackupSMTP;
   int tmpOfflineJabber,tmpOfflineSMTP;
   int tmpCoreTmp;

   char *config_file; /* config file name */
   char *stat_file; /* Statistics file name */
   char *res_file; /* Resources file name */
   char *roster_file; /* Roster file name */
   char *roster_folder; /* Roster folder */

   char *jabber_backup;
   char *jabber_offline;
   char *smtp_backup;
   char *smtp_offline;
   char *core_tmp;

   char *DefaultLang; /* Default language */

   char cSMTP_Status[20];
   char cJabber_Status[20];

   xmlnode memtest; /* resources node */
   xmlnode resources; /* resources node */
   xmlnode roster; /* roster node */
   xmlnode roster_files; /* roster files node */

   smtp_jcmdq qcmd;
   smtp_cjid ContactList;
   smtp_stats Stats; // statistika
   smtp_pools pools;

} *smtpi, _smtpi;

/* our 'session' data  - jabber to smtp*/
typedef struct smtps_struct
{
   int phase, timer, lastcmd, iStatus, ircpt,mio_status;
   char *from;
   char *buffer;
   char *host;
   jid rcpt;
   mio m;
   pool p;
   xmlnode x, oJID, oAD;
   
   int toPGPMIME,Advertising,SRMode;
   char *SRSeparator, *SRText, *lang;
   
   jpacket jp; // incomming jabber packet
   instance i;
  
} *smtps, _smtps;



/* our 'session' data - smtp to jabber*/
typedef struct smptsi_rcp_struc
{ 
   jid rcpt;
   xmlnode oJID;
   int iErr,Advertising,nonMIME2x,Attachments,UseGlobalSettings,SRMode,S2J_AllAreSPAM;
   char *SRSeparator, *SRText, *smtpaddr;

   struct smptsi_rcp_struc *next; /* for lists of recipients */
} *smptsi_rcp,_smptsi_rcp;


typedef struct smtpsi_struct
{
   int phase, timer, lastcmd ;
   char *from;
   char *fromEx;
   char *buffer;
   char *host;
   char *listcc;
   char *listto;
   char *MBody;

   void *rcpt;
   void *rcptFD;

   mio m;
   pool p;
   xmlnode x,omsg, obody;
   int iPGP;
   xmlnode oAD;
} *smtpsi, _smtpsi;


/* our 'session' data */
typedef struct smtp_param
{
   jpacket jp; // incomming jabber packet
   dpacket dp; // incomming jabber delivery packet
   pool tmppool;
   char *lang;

   instance i;
} *smtpp, _smtpp;

typedef struct smtpsx_struct
{
 smtpp par;
 smtps so;
 pool p;
 int state;
 char *cBFile;
 void *gmCB;
 void *gmArg;
 void *gmCBF;
 void *gmArgF;
} *smtpsx, _smtpsx;


/* context for MIME decoding */
typedef struct mimectx_struct
{
   int mimeUsed;
   int mimeEncoding;
   char *mimeCharset;
} *mimectx, _mimectx;


typedef struct smtp_jabber_queue_struc_x
{
xmlnode x; // xmlnode
} *smtp_jq_x,_smtp_jq_x;

typedef struct smtp_jabber_queue_struc_cb
{
void *cb; 
void *arg; 
} *smtp_jq_cb,_smtp_jq_cb;

typedef struct smtp_jabber_queue_struc
{
struct smtp_jabber_queue_struc *next; /* next queue item */
void *Data;
int iType;

} *smtp_jq,_smtp_jq;




typedef struct smtp_thread_universal
{
   pool p;
   mtq  q;
   int *index;
} *smtp_tu, _smtp_tu;



// smtp.c
smtps smtp_new_out(mio m);
smtpsi smtp_new_in(mio m);
smtpsi smtp_new_ino(pool p);
smtpp smtp_param_i(pool p,instance i);
void smtp_SendInfoToAdmin(const char *lcMSG, int liType);
smptsi_rcp smtp_NewRecipient(pool p,jid ojid);
smptsi_rcp smtp_AppendRcpt(smptsi_rcp a, smptsi_rcp b);
jid smtp_2mx(jid id);
jid smtp_mx2(jid id);

typedef void (*smtp_queue_cb)(void *arg);
typedef void (*smtp_j2s_cb)(smtps so, void *arg);

smtp_jq smtp_NewQueueItem(pool p, int liType);
smtp_jq smtp_AppendQueueItem(smtp_jq a, smtp_jq b);
void smtp_FlushQueue(instance i, smtp_jq item);

smtp_jcmdq smtp_CmdNew();
smtp_jcmdq smtp_CmdAppend(smtp_jcmdq b);
smtp_jcmdq smtp_CmdGet(char *lcSessionID);
void smtp_CmdDel(char *lcSessionID);
int smtp_CmdGetMem();

void smtp_StatsSave();


//poolm.h
int smtp_Pools(int liType,int liIndex,pool pl);
void smtp_PoolsReg(int liIndex,pool p);
void smtp_X_cleanup(void *arg);
int smtp_PoolsGetMem();
result smtp_poolm_daemon(void *arg);
void smtp_PoolsSettmp(pool pl,int liTmp);


// roster.h
xmlnode smtp_roster_get_item(char *lcJID, int liDefault);
void smtp_roster_set_item(char *lcJID, xmlnode loJID);
void smtp_roster_remove_item(char *lcJID);

int smtp_online_add_item( char *lcFrom, char *lcTo);
int smtp_online_remove_item( char *lcFrom, char *lcTo);

smtp_cjid smtp_cjidNew(xmlnode loNode,char *lcJID);
smtp_cjid smtp_cjidGet(char *lcJID);
smtp_cjid smtp_cjidAppend(smtp_cjid b);
void smtp_cjidDel(char *lcJID);
int smtp_cjidGetCount(int liFlag);
int smtp_cjidGetContactsCount();
int smtp_cjidGetMem();

// in.c
void smtp_in_read(mio m, int state, void *arg, char *buffer,int bufsz);
void smtp_in_status(smtpsi si, int liStatus, char *data);
void smtp_in_offline_message(xmlnode loMSG);
smtps smtp_in_recipient_cb(smtps so, void *lugmArg);
smtps smtp_in_recipient_cbf(smtps so, void *lugmArg);

// in_spam.c
int smtp_in_spam(smtpsi si, char *msg);


// out.c
result smtp_out_packets(instance i, dpacket p, void *arg);

// out_iq.c
int smtp_out_packets_iq(smtpp par, char *lcType);

// out_iq_register.c
int smtp_out_packets_iq_register(smtpp par, char *type);
void smtp_opiqr_SaveToJID(xmlnode xData,xmlnode loJID);
void smtp_opiqr_FillDataFromJID(pool p, const char *lcGroup,xmlnode xData,xmlnode loJID,char *lcLang);

// out_iq_vcard.c
int smtp_out_packets_iq_vcard(smtpp par, char *type);

// out_iq_gateway.c
int smtp_out_packets_iq_gateway(smtpp par, char *type);

// out_iq_time.c
int smtp_out_packets_iq_time(smtpp par, char *type);

// out_iq_version.c
int smtp_out_packets_iq_version(smtpp par, char *type);

// out_iq_di.c
int smtp_out_packets_iq_di(smtpp par, char *type);

// out_iq_stats.c
int smtp_out_packets_iq_stats(smtpp par, char *type);

// out_presence.c
int smtp_out_packets_presence(smtpp par, char *lcType);

// out_mesage.c
int smtp_out_packets_message(smtpp par, char *lcType);
void smtp_out_offline_message(xmlnode loMSG);
void smtp_out_process_message(smtpp par, void *luCB, void *luArg, void *luCBF, void *luArgF);

// out_admin.c
int smtp_admin_message(smtpp par, char *lcType);
int _smtp_opm_check_JID(char *lcJID,const char *lcNS);
int _smtp_opmadmin_getcntfolder(char *lcFLD,int liOld);
char *_smtp_opmadmin_getfolder(pool p, char *lcFLD);


// out_S10N.c
int smtp_out_packets_S10N(smtpp par, char *lcType);



// offline.c
result smtp_offline_jdaemon(void *arg);
result smtp_offline_sdaemon(void *arg);

// paid.c
result smtp_paid_daemon(void *arg);


// utils.c
char *smtp_alltrim(char *lcChar);
char *smtp_2ws(char *lcChar);
char *smtp_lgstrim(char *lcChar);
char *smtp_strcasestr(char *lcWhere,char *lcWhat);
char *smtp_CMonth(int liMonth);
char *smtp_itoa(pool p, int liNumber);
xmlnode out_SetReply(xmlnode loNew, xmlnode loOld);
void smtp_ReplyError(instance i, jpacket loOrig, const char *lcNodeName, const char *lcBody, int liError);
char *smtp_GetDateTime(char *lcDateTime);
char *smtp_GetFolderFromFile(char *lcFolder);
int smtp_CreateFolder(char *lcFolder);
void smtp_xmlnode_move_node(xmlnode loNode, xmlnode loParentOld, xmlnode loParentNew);
char *smtp_rc_GetString(pool p,char *lcLang, int liID);
char *smtp_GetSMTPAddress(char *lcJID);
char *smtp_GetJID(pool p,char *lcJID);
char *smtp_ToUTF8(pool p, char *lcText,const char *charmap);
void fromQP(char *string, void *byteStream);
void toQP(char *string, void *byteStream, int liSoftLines, const char *lcSpec);
void toEscape(char *string, void *byteStream, const char *lcSpec);
void fromEscape(char *string, void *byteStream);
char *smtp_getword(char **lcChar, char *lcSep, char *lcMax);
int smtp_check_list(char *lcItem,xmlnode loItem);

//void smtp_TEST(smtpp par, jpacket loOrig);

