#include "smtp.h"

extern smtpi jtin;

char *pcMonths[12]={"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

char *smtp_itoa(pool p,int liNumber)
   {
   char *lcItoA;
   lcItoA = (char*)pmalloc_x(p, 18,'\0');
   snprintf(lcItoA, 17, "%i\0",liNumber);
   return lcItoA;
   }


char *smtp_getword(char **lcChar, char *lcSep, char *lcMax)
   {
   char *lcToken;

   if (*lcChar==NULL || lcSep==NULL || lcMax==NULL)
      return NULL;

   // Get token
   lcToken=strtok(*lcChar,lcSep); // find first word
   *lcChar+=j_strlen(lcToken)+1;
   if (*lcChar>lcMax) // are out of string
      *lcChar=lcMax; 

   return lcToken;
   }

char *smtp_alltrim(char *lcChar)
   {
   char *lcXXX;

   if (!lcChar)
      return lcChar;

   // skip space at the beginning 
   lcXXX=lcChar+j_strlen(lcChar)-1;
   while (*lcChar == ' ' && lcChar<=lcXXX)
         {
         *lcChar = '\0';
         lcChar++;
         }

   // skip space at the end  
   while (*lcXXX == ' ' && lcXXX>=lcChar)
         {
         *lcXXX = '\0';
         lcXXX--;
         }
   return lcChar;
   }

char *smtp_2ws(char *lcChar)
   {
   char *lcXXX;

   if (!lcChar)
      return lcChar;

   // skip space at the beginning 
   lcXXX=lcChar+j_strlen(lcChar)-1;
   while ((*lcChar == '\r' || *lcChar == '\n' || *lcChar == '\t') && lcChar<=lcXXX)
         {
         *lcChar = ' ';
         lcChar++;
         }

   // skip space at the end  
   while ((*lcXXX == '\r' || *lcXXX == '\n' || *lcXXX == '\t') && lcXXX>=lcChar)
         {
         *lcXXX = ' ';
         lcXXX--;
         }
   return lcChar;
   }

char *smtp_lgstrim(char *lcChar)
   {
   char *lcXXX;

   if (lcChar==NULL)
      return NULL;

   // skip < at the beginning 
   lcXXX=lcChar+j_strlen(lcChar)-1;
   while (*lcChar != '<' && lcChar<=lcXXX)
         {
         lcChar++;
         }

   if (*lcChar == '<')
      {
      *lcChar = '\0';
      }

   lcXXX=lcChar=lcChar+1;

   // skip > at the end  
   lcXXX=lcChar+j_strlen(lcChar)-1;
   while (lcXXX[0] != '>' && lcXXX>=lcChar)
         {
         lcXXX--;
         }
   
   if (*lcXXX == '>')
      {
      *lcXXX = '\0';
      }
   return lcChar;
   }


char *smtp_strcasestr(char *lcWhere, char *lcWhat)
   {
   char *lcXXX;
   int liLen=j_strlen(lcWhere),liLenWhat=j_strlen(lcWhat);

   if (lcWhere==NULL || lcWhat==NULL)
      return (char *)NULL;

   lcXXX=lcWhere;
   while (lcXXX<=(lcWhere+liLen-1))
         {
         if (strncasecmp(lcXXX, lcWhat,liLenWhat)==0)
            break;

         lcXXX++;
         }

    if (lcXXX<=(lcWhere+liLen-1))
       return lcXXX;
    else
       return (char *)NULL;
    }


xmlnode out_SetReply(xmlnode loNew, xmlnode loOld)
   {
   char *lcId;
   xmlnode addresses,address,addressesN,addressN;

   xmlnode_put_attrib(loNew,"from",xmlnode_get_attrib(loOld,"to"));
   xmlnode_put_attrib(loNew,"to",xmlnode_get_attrib(loOld,"from"));
   if ((lcId=xmlnode_get_attrib(loOld,"id")))
      xmlnode_put_attrib(loNew,"id",lcId);


   // JEP-0033 stanzas
   if ((addresses=xmlnode_get_tag(loOld,"addresses?xmlns=http://jabber.org/protocol/address"))) 
      {
      // put adresses element to new node
      xmlnode_put_attrib(addressesN=xmlnode_insert_tag(loNew,"addresses"),"xmnls","http://jabber.org/protocol/address");

       // copy all childs elements to new node
      for (address = xmlnode_get_firstchild(addresses); address != NULL; address = xmlnode_get_nextsibling(address))
          {
	      if (address->type!=NTYPE_TAG)
		     continue;

		  xmlnode_put_attrib(addressN=xmlnode_insert_tag(addressesN,"address"),"jid",xmlnode_get_attrib(address,"jid"));
          xmlnode_put_attrib(addressN,"type",xmlnode_get_attrib(address,"type"));
          }
      }

   return loNew;
   }

void smtp_ReplyError(instance i, jpacket loOrig, const char *lcNodeName, const char *lcBody, int liError)
   {
   xmlnode x501, xError;
   pool p=pool_new();
   smtp_PoolsReg(11, p);

   x501= out_SetReply(xmlnode_dup_pool(p,loOrig->x),loOrig->x);
   xmlnode_put_attrib(x501,"type","error");

   xmlnode_put_attrib(xError=xmlnode_insert_tag(x501,"error"),"code",smtp_itoa(p,liError));
   xmlnode_insert_cdata(xError,lcBody,-1);

   deliver(dpacket_new(xmlnode_dup(x501)),i);
   pool_free(p);
   }


char *smtp_CMonth(int liMonth)
   {
   return pcMonths[liMonth];
   }


char *smtp_GetDateTime(char *lcDateTime)
   {
   time_t now_unixtime;
   struct tm now;

   now_unixtime = time(NULL);
   gmtime_r(&now_unixtime, &now);
   snprintf(lcDateTime, j_strlen(lcDateTime), "%04i%02i%02iT%02i:%02i:%02i\0", now.tm_year+1900, now.tm_mon+1, now.tm_mday, now.tm_hour+(now.tm_isdst/3600), now.tm_min, now.tm_sec);
   return lcDateTime;
   }

char *smtp_GetFolderFromFile(char *lcFile)
   {
   char *lcXXX;
   // skip > at the end  
   lcXXX=lcFile+j_strlen(lcFile)-1;
   while (lcXXX[0] != '/' && lcXXX>=lcFile)
         {
         lcXXX--;
         }
   
   if (*lcXXX == '/')
      {
      *lcXXX = '\0';
      }

   return lcFile;
   }

char *_smtp_rc_GetString(pool p, char *lcLang,int liID)
   {
   xmlnode loLang,loString,loStrings;

   if ((loStrings=xmlnode_get_tag(jtin->resources,"strings"))==NULL)
      return NULL; 

   if ((loLang=xmlnode_get_tag(loStrings,spools(p, "lang?xml:lang=", lcLang, p)))==NULL)
      return NULL;

   if ((loString=xmlnode_get_tag(loLang,spools(p, "string?id=", smtp_itoa(p,liID), p)))==NULL)
      return pstrdup(p,SMTP_RC_UNKNOWN);
   else
      return pstrdup(p,xmlnode_get_data(loString));
   }

char *smtp_rc_GetString(pool p,char *lcLang,int liID)
   {
   char *lcString, *ptr;
   int liLen=j_strlen(lcLang);
   xmlnode loMap;
   
   lcString=_smtp_rc_GetString(p,lcLang,liID);

   // string for lang/sublang not found, but lang has sublang
   if (lcString==NULL && liLen>2)
      { // try find string by lang
      lcLang[2]='\0';
      lcString=_smtp_rc_GetString(p,lcLang,liID);
      }

   // string for lang not found, try found string for  map language
   if (lcString==NULL)
      {
      if (liLen>2)
         { // try find string by lang/sublang
         lcLang[2]='-';
         if ((loMap=xmlnode_get_tag(jtin->resources,spools(p, "languages/map?xml:lang=", lcLang, p)))!=NULL)
            lcString=_smtp_rc_GetString(p,xmlnode_get_data(loMap),liID);

         lcLang[2]='\0';
         }

      // try find string by lang
      if (lcString==NULL)
         if ((loMap=xmlnode_get_tag(jtin->resources,spools(p, "languages/map?xml:lang=", lcLang, p)))!=NULL)
            lcString=_smtp_rc_GetString(p,xmlnode_get_data(loMap),liID);

      }

   // string for map language not found, try found string for default language
   if (lcString==NULL)
      lcString=_smtp_rc_GetString(p,SMTP_RC_DEFAULT_LANG,liID);

   // string for default language not found, return "Unknown string"
   if (lcString==NULL)
      lcString=pstrdup(p,SMTP_RC_UNKNOWN);


   while ((ptr = strstr(lcString, "\\n")) != NULL)
      {
      *ptr='\r';
      *(ptr+1)='\n';
      }

   return lcString;
   }



char *smtp_GetSMTPAddress(char *lcJID)
   {
   char *host;

   host = strstr(lcJID,"@");
   *host = '\0';
   host = strstr(lcJID,"%");
   *host = '@';
   ++host;
   return host;
   }

char *smtp_GetJID(pool p,char *lcJID)
   {
   char *lcNewJID,*lcSep;
   lcSep = strchr(lcJID,'/');
   if (lcSep!=NULL)
       *lcSep='\0';

   lcNewJID = pstrdup(p,lcJID);
   if (lcSep!=NULL)
       *lcSep='/';
   return lcNewJID;
   }




void fromQP(char *string, void *byteStream)
   {
   char *binPtr = (char *)byteStream, lcChar;
   int strSize = strlen(string);
   int i = 0, j = 0;
   
   for(i = 0, j = 0; i < strSize; i++, j++)
      {
      lcChar=string[i]; // read char
      if (lcChar== '=') // escaped char
         {
         if (string[i+1]=='\r' || string[i+1]=='\n')
            {
//            binPtr[j] = ' ';
            j--;
            i=i+(((string[i+1]=='\r' && string[i+2]=='\n'))?2:1);
            }
         else
            {
            binPtr[j] = (string[i+1]-(string[i+1]<65?48:55))*16+(string[i+2]-(string[i+2]<65?48:55));
            i+=2;
            }
         }
      else
         binPtr[j] = lcChar;

      }
   binPtr[j] = '\0';

   }


void toQP(char *string, void *byteStream, int liSoftLines, const char *lcSpec)
   {
   char *binPtr = (char *)byteStream, cHEX[3]="  \0";
   int strSize = strlen(string);
   int i = 0, j = 0, liEnter=0, liASCII;
   unsigned int lcChar;

   for(i = 0, j = 0; i < strSize; i++, j++)
      {
      lcChar=string[i]; // read char

      if ((lcChar>=33 && lcChar<=60) ||
          (lcChar>=62 && lcChar<=126)) //  || lcChar==32

         if (j_strlen(lcSpec)==0 ||
            (j_strlen(lcSpec)>0 && strchr(lcSpec,lcChar)!=NULL))
           liASCII=3;
         else
           liASCII=1;
      else
         liASCII=3;

      if (liEnter+liASCII>60 && liSoftLines==1)
         {
         binPtr[j+0] = '=';
         binPtr[j+1] = 13;
         binPtr[j+2] = 10;
         j+=3;
         liEnter=0;
         }

      if (liASCII==1) // US-ASCII
         {      
         binPtr[j] = lcChar;
         liEnter++;
         }
      else
         {      
         binPtr[j] = '=';

         if ((int)lcChar<0) 
            lcChar=lcChar+256;

         if ((int)lcChar<16) 
            snprintf(cHEX, 3, "0%X\0",lcChar);
         else
            snprintf(cHEX, 3, "%XX\0",lcChar);

         binPtr[j+1] = cHEX[0] ;
         binPtr[j+2] = cHEX[1];


         j+=2;
         liEnter+=2;
         }

      }
   binPtr[j] = '\0';
   }


void toEscape(char *string, void *byteStream, const char *lcSpec)
   {
   char *binPtr = (char *)byteStream, cHEX[3]="  \0";
   int strSize = strlen(string);
   int i = 0, j = 0,liASCII;
   unsigned int lcChar;

   for(i = 0, j = 0; i < strSize; i++, j++)
      {
      lcChar=string[i]; // read char

      if ((lcChar>=33 && lcChar<=36) ||
          (lcChar>=38 && lcChar<=126))

         if (j_strlen(lcSpec)==0 ||
            (j_strlen(lcSpec)>0 && strchr(lcSpec,lcChar)!=NULL))
           liASCII=3;
         else
           liASCII=1;
      else
         liASCII=3;

      if (liASCII==1) // US-ASCII
         {      
         binPtr[j] = lcChar;
         }
      else
         {      
         binPtr[j] = '%';
         if ((int)lcChar<0) 
            lcChar=lcChar+256;

         if ((int)lcChar<16) 
            snprintf(cHEX, 3, "0%X\0",lcChar);
         else
            snprintf(cHEX, 3, "%XX\0",lcChar);

         binPtr[j+1] = cHEX[0] ;
         binPtr[j+2] = cHEX[1];

         j+=2;
         }

      }
   binPtr[j] = '\0';
   }


void fromEscape(char *string, void *byteStream)
   {
   char *binPtr = (char *)byteStream, lcChar;
   int strSize = strlen(string);
   int i = 0, j = 0;
   
   for(i = 0, j = 0; i < strSize; i++, j++)
      {
      lcChar=string[i]; // read char
      if (lcChar== '%') // escaped char
         {
         binPtr[j] = (string[i+1]-(string[i+1]<65?48:55))*16+(string[i+2]-(string[i+2]<65?48:55));
         i+=2;
         }
      else
         binPtr[j] = lcChar;
      }
   binPtr[j] = '\0';

   }

int smtp_CreateFolder(char *lcFolder)
   {
   char *lcSep, *lcStart;
   int liBackup;

   lcStart=lcFolder;
   if ((lcSep = strstr(lcFolder,"/\0"))==NULL)
      lcSep = strstr(lcFolder,"\\0");
      
   if (lcSep==NULL)
      lcStart=lcFolder;
   else
      lcStart=lcSep+1;

   while( lcStart != NULL )
        {
        if (lcSep!=NULL)
           *lcSep='\0';

        // While there are tokens in "string" 
        liBackup=mkdir(lcFolder,S_IRUSR | S_IWUSR | S_IXUSR );
        if (!(liBackup==-1 || errno == EEXIST))
            return errno;

        if (lcSep!=NULL)
           *lcSep='/';

        if (lcSep!=NULL)
           {
           // Get next token: 
           if ((lcSep = strstr(lcStart,"/\0"))==NULL)
              lcSep = strstr(lcStart,"\\0");

           if (lcSep!=NULL)
              lcStart=lcSep+1;
           }
        else
           lcStart=NULL;

        }    
   return 0;
   }


void smtp_xmlnode_move_node(xmlnode loNode, xmlnode loParentOld, xmlnode loParentNew)
   {
   if (loParentOld==NULL || loParentNew==NULL)
      return;


   xmlnode_hide(loNode);
   loNode->next=loNode->prev=NULL;
 
   if (loParentNew->firstchild==NULL)
      loParentNew->firstchild=loNode;
   else
      {
      loNode->next=loParentNew->firstchild;
      loParentNew->firstchild->prev=loNode;
      loParentNew->firstchild=loNode;
      }

   if (loParentNew->lastchild==NULL)
      loParentNew->lastchild=loNode;

   loNode->parent = loParentNew; // change parent of node
//   xmlnode2file("./spool/test2.xml",loParentNew);

    
   }




int smtp_check_list(char *lcItem,xmlnode loItem)
   {
   // check spammers elememet in smtp section
   char *lcIP,*lcAsterix;
   int liLen,liMode=-1,liModeE;

   for (; loItem != NULL; loItem = xmlnode_get_nextsibling(loItem))
       {
       if (loItem->type!=NTYPE_TAG)
		   continue;

       lcIP=xmlnode_get_attrib(loItem,"ip");
       if (lcIP==NULL)
		   continue;

       lcAsterix=strchr(lcIP,'*');
	   if (lcAsterix==NULL && strcasecmp(lcItem,lcIP)==0) // it is...
          return j_atoi(xmlnode_get_attrib(loItem,"mode"),0);

	   if (lcAsterix==NULL) // it is...
          return -1;

       liLen=j_strlen(lcIP)-( (lcAsterix- lcIP)+1 );

	   if (strcasecmp((lcItem+(j_strlen(lcItem)-liLen)),(lcAsterix+1))!=0) // not it is...
          continue;

       liMode=j_atoi(xmlnode_get_attrib(loItem,"mode"),0); // get mode
       // check exceptions mode
       liModeE=smtp_check_list(lcItem,xmlnode_get_tag(loItem,"item"));
       if (liModeE==-1)
          return liMode;

       return liMode!=liModeE?liModeE:liMode;
	   }

   return liMode;
   }






/*
void smtp_TEST(smtpp par, jpacket loOrig)
   {
   xmlnode loConfig;
char gethx[3];
   
//   xdbcache xc;
   int liValue, liRet;
   jid ljidConfig;

   ljidConfig=jid_new(xmlnode_pool(loOrig->x),"config@-internal");

   
//   xc = xdb_cache(par->jtin->i);
   loConfig = xdb_get(par->jtin->xc,ljidConfig ,"smtp:iq:roster");

   log_debug(ZONE,"xxxxxxxxxxxxxxx      100        xxxxxxxxxxxxxxxxxxxxxxxxxxx\r\n");
   log_debug(ZONE,xmlnode2str(loConfig));
//   gets((char *)gethx);

   liValue=j_atoi(xmlnode_get_attrib(loConfig,"test"),0);
   liValue++;

   xmlnode_put_attrib(loConfig,"test",smtp_itoa(liValue));

   log_debug(ZONE,"xxxxxxxxxxxxxxx     200      xxxxxxxxxxxxxxxxxxxxxxxxxxx\r\n");
   log_debug(ZONE,xmlnode2str(loConfig));
//   gets((char *)gethx);

//int xdb_act(xdbcache xc, jid owner, char *ns, char *act, char *match, xmlnode data)
 //if(xdb_act(m->si->xc, m->user->id, NS_AUTH, "check", NULL, xmlnode_get_tag(m->packet->iq,"password")))
//   xdb_act(j->xc, j->id, "jabber:jud:users", "insert", spools(p->p,"?jid=",xmlnode_get_attrib(q,"jid"),p->p), q); // sync the xdb

//   liRet=xdb_set(par->jtin->xc, ljidConfig,"jabber:status:smtp",loConfig);
   xdb_act(par->jtin->xc, ljidConfig, "smtp:iq:roster", "check", NULL, loConfig); // sync the xdb 
   log_debug(ZONE,"xxxxxxxxxxxxxxx      300     xxxxxxxxxxxxxxxxxxxxxxxxxxx\r\nReturn value %i\r\n",liRet);

   loConfig = xdb_get(par->jtin->xc,ljidConfig ,"smtp:iq:roster");

   log_debug(ZONE,"xxxxxxxxxxxxxxx      400     xxxxxxxxxxxxxxxxxxxxxxxxxxx\r\n");
   log_debug(ZONE,xmlnode2str(loConfig));
   gets((char *)gethx);

   }
*/

/*
char *smtp_ToUTF8(pool p, char *lcText,const char *charmap)
   {

   int liIn,liOut;
   char *lcRet;
iconv_t iconv_obj;

   liIn=j_strlen(lcText);
   liOut=2*liIn;
   log_debug(ZONE,"xxxxxxxxxxxxxxx -   %i %i\r\n",liIn,liOut);

   lcRet = (char*)pmalloco(p, liOut);

//  from cp1250 to utf-8
   iconv_obj = iconv_open("UTF-8", "CP1250");
  
   log_debug(ZONE,"xxxxxxxxxxxxxxx -   %i \r\n",(int) iconv_obj);
   if ((iconv_obj == (iconv_t) -1))
      {
      log_debug(ZONE, "[SMTP]: Error - iconv_open returned %d",iconv_obj);

      }
   else
      {
   log_debug(ZONE,"xxxxxxxxxxxxxxx -   START");
      iconv(iconv_obj, (const char**)&lcText, &liIn, &lcRet, &liOut);
//      iconv(iconv_obj, NULL, NULL, &wrptr, &liOut);

   log_debug(ZONE,"xxxxxxxxxxxxxxx -   END");
      iconv_close(iconv_obj);
      }

   log_debug(ZONE,"xxxxxxxxxxxxxxx -   %s \r\n",lcRet);
   return lcRet;

   }
*/

