#ifndef VERSION
 #include <jabberd.h>
#endif

#include "poolm.h"
#include "hookjpm.h"
#include "threads.h"

static HJPMI_struc HJPMI_Root; 
static void *HJPMI_Lost_cb=NULL;

HJPMI_struc _HJPM_CreateItem(char *lcID)
   {
   HJPMI_struc b;
   pool p;

   b=pmalloco(p=pool_new(), sizeof(_HJPMI_struc));
   b->p=p; 
   b->iMode=HJPM_MODE_CBF;
   b->id=pstrdup(p,lcID);
   b->last=b->next=b->child=NULL;
   b->tstamp=time(NULL);
   PM_Reg(4500,NULL, b->p,0,NULL);
   return b;
   }


// get item in list
HJPMI_struc HJPM_GetItem(char *lcID, HJPMI_struc loPrev)
   {
   HJPMI_struc b=NULL,next=HJPMI_Root->child;
   if (j_strlen(lcID)==0)
      return b;

   // check if group in list
   while(next != NULL)
      {
      if (j_strcmp(next->id,lcID)==0)
         {
         b=next;
         break;
         }

      next = next->next;
      }

   return b;
   }



HJPMI_struc _HJPM_Reg(char *lcID,void *CBFP,void *CBF,void *CBFA)
   {
   HJPMI_struc loItem=NULL,loLast,loRoot=HJPMI_Root;

   loItem=HJPM_GetItem(lcID,NULL); // get Item from list
   if (loItem==NULL)
      {
      loItem=_HJPM_CreateItem(lcID);
      loItem->CBFP=CBFP;
      loItem->CBF=CBF;
      loItem->CBFA=CBFA;

      if (loRoot->child == NULL)
         {
         loRoot->child=loItem;
         }
      else if ((loLast=loRoot->child->last)==NULL) // save Last item
         {
         loRoot->child->last=loRoot->child->next=loItem;
         }
      else
         {
         loLast->next=loItem;
         loRoot->child->last=loItem;
         }

      }

   return loItem;
   }

void _HJPM_Unreg(char *lcID)
   {
   HJPMI_struc loItem,loPrev,loRoot=HJPMI_Root;

   if (j_strlen(lcID) == 0)
      return;

   loItem=HJPM_GetItem(lcID,loPrev); // get item from list
   if (loItem!=NULL)
      {
   
      if (loItem==loRoot->child && loItem->next==NULL) // root item
         {
         loRoot->child=NULL; // clear it
         }
      else if (loItem==loRoot->child && loItem->next!=NULL) // check to first item
         {
         loRoot->child=loItem->next;
         loRoot->child->last=loItem->last;
         }
      else if (loRoot->child->last==loItem) // check to last item
         {
         loRoot->child->last=loPrev; // copy last item to rootlast
         loPrev->next=NULL; // clear next item
         }
      else
         {
         loPrev->next=loItem->next;  // change next item
         }

      PM_SetItemTmp(loItem->p,1);
      pool_free(loItem->p); // free item
      }

   return;
   }

HJPMI_struc HJPM_Reg(char *lcID,void *CBFP,void *CBF,void *CBFA)
   {
   // lcID - ID of jabber packet
   // CBFP; // processing callback function
   // CBF; // end callback function
   // CBFA; // callback function argument
   HJPMI_struc loItem;
   loItem=_HJPM_Reg(lcID,CBFP,CBF,CBFA);
   return loItem;
   }



int HJPM_RunCBF(char *lcID,jpacket loJP)
   {
   HJPMI_struc loHook;
   int liMode;
   loHook=HJPM_GetItem(lcID,NULL);

   if (loHook==NULL)
      return HJPM_MODE_CBFSP;

   if (loHook->CBFP!=NULL)
      (*(hjpm_cbfp)loHook->CBFP)((void*) loHook->CBFA,loJP);

   if (loHook->CBF!=NULL)
      (*(hjpm_cbf) loHook->CBF)((void*) loHook->CBFA);

   liMode=loHook->iMode;
   _HJPM_Unreg(loHook->id);
   return liMode;
   }



int HJPM_GetMem(char *lcID, int liType)
   {
   HJPMI_struc loItem=HJPMI_Root;
   int lii=0;
   while(loItem != NULL)
      {
      if ((lcID==NULL || j_strcmp(loItem->id,lcID)==0) && (liType==HJPM_MEMORY_CORE || liType==HJPM_MEMORY_ALL))
         lii+=pool_size(loItem->p);

      loItem = loItem->next;
      }
    
   return lii;
   }




// ************************************************
// hook jabber packet manager daemon
// ************************************************
// Walk list
void _HJPM_List(_tud TUD,HJPMI_struc loRoot,time_t tstamp)
   {
   HJPMI_struc loNext=loRoot, loItem;
   char *lcPom;

   lcPom = (char*)pmalloc_x(TUD->p, 254,'\0');

   while(loNext != NULL)
      {
      loItem=loNext;

      loNext = loNext->next;

      if (tstamp>loItem->tstamp+60*HJPMI_TimeOut)
         {
         log_alert("HJPM","MEL: %s",loItem->id);

         if (loItem->CBF!=NULL)
            (*(hjpm_cbf) loItem->CBF)((void*) loItem->CBFA);

         if (HJPMI_Lost_cb!=NULL)
            {
            snprintf(lcPom, 254, "HOOK JABBER PACKET MANAGER DAEMON - MEMORY LEAK: %s.",loItem->id);
            (*(hjpm_lost_cb)HJPMI_Lost_cb)((void*) lcPom);
            }

         _HJPM_Unreg(loItem->id);
         }

      }
   }

// daemon thread
void HJPM_mtq(void *arg)
   {
   _tud TUD= (_tud) arg;
   time_t tstamp=time(NULL);
   // projdi seznam  v hook jabber packet manageru
   // zkontroluj asovou znaku
   // ve co je tam dle jak 30 minut, uvolni a poli info adminovi

   _HJPM_List(TUD,HJPMI_Root->child,tstamp);
   PM_SetItemTmp(TUD->p,1);
   pool_free(TUD->p);
   }


// create new thread for getting paid flag
result HJPM_Daemon(void *arg)
   {
   _tud TUD=TU_NewData();

   PM_Reg(4510,NULL, TUD->p,0,NULL);
   mtq_send(TUD->q, TUD->p, HJPM_mtq, (void *)TUD);
   return r_DONE;
   }


// init of daemon
void HJPM_InitDaemon()
  {
  register_beat(60*HJPMI_TimeOut , HJPM_Daemon, (void *)NULL);
  }

// init of root
HJPMI_struc HJPM_InitRoot(void *arg)
  {
  HJPMI_Root=_HJPM_CreateItem("_ROOT_");
  HJPMI_Lost_cb= arg;
  return HJPMI_Root;
  }
