#include "smtp.h"

/* smtp->jabber */

extern smtpi jtin;

void smtp_list_to_spool(spool tmpsp,smptsi_rcp loList)
   {
   // seznam pjemc
   while (loList != NULL)
     {
     spooler(tmpsp,loList->smtpaddr," ",tmpsp);
     loList = loList->next;
     }
   return;
   }

void smtp_save_raw_to_backup(smtpsi si,xmlnode loSave)
   {
   si->cFile=spools(si->p, tempnam(jtin->smtp_backup, "tmp"),".xml",si->p);

   if (xmlnode2file(si->cFile,loSave)!=1)
      {
      log_warn("smtp","Cannot save email to %s.",si->cFile);
      smtp_SendInfoToAdmin(spools(si->p,"Cannot save email to ",si->cFile,".",si->p),SMTP_SITA_P );
      }

   return;
   }


void smtp_save_to_backup(smtpsi si)
   {
   xmlnode loSave;
   pool poSave;
   spool tmpsp;
   int lii;
   smptsi_rcp rcpt;
   char *tmp;

   if (jtin->tmpBackupSMTP==0)
      return;


   si->cStatus=pstrdup(si->p,"Save email to backup repository");
   poSave=pool_new();
   PM_Reg(5050, si->p,poSave,1,NULL);

   si->cFile = (char*)pmalloco(si->p, 254);
   si->cFile[-1] = '\0';
   si->cFile=spools(si->p, tempnam(jtin->smtp_backup, "tmp"),".xml",si->p);

   loSave=xmlnode_new_tag_pool(poSave,"x");
   tmpsp=spool_new(poSave);
   lii=0;
   for (rcpt = si->rcpt; rcpt != NULL; rcpt = rcpt->next) 
       {
       if (lii==0)
          spooler(tmpsp,jid_full(rcpt->rcpt),tmpsp);
       else
          spooler(tmpsp,",",jid_full(rcpt->rcpt),tmpsp);
       }
   xmlnode_put_attrib(loSave,"to",spool_print(tmpsp));
   xmlnode_put_attrib(loSave,"from",si->from);
   xmlnode_put_attrib(loSave,"fromEx",si->fromEx);
   xmlnode_put_attrib(loSave,"jidfrom",si->jidfrom);

   tmp = (char*)pmalloco(poSave, EQP_LENGTH(j_strlen(si->Body)));
   toEscape(si->Body, (void *) tmp,SEQ_ESCAPE);
   xmlnode_insert_cdata(xmlnode_insert_tag(loSave,"data"),tmp,-1);


   smtp_save_raw_to_backup(si,loSave);
 
   pool_free(poSave);
   return;
   }


void smtp_delete_from_backup(smtpsi si)
   {
   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"DATA - DELETE TEMO FILE %i %s",jtin->tmpBackupSMTP,si->cFile);
   #endif

   if (jtin->tmpBackupSMTP==1 && j_strlen(si->cFile)>0)
      remove(si->cFile);
   return;
   }


/* prepare data pool */
void smtp_si_prepare_data(smtpsi si)
   {
   si->pMessage=pool_new();
   si->cMessage=spool_new(si->pMessage);
   PM_Reg(5000,si->p,si->pMessage,0,NULL);
   }

/* ensure that data is 7 bit */
char *smtp_mime_check7bit(pool p, mimectx ctx, char *str)
   {
   char *ptr;

   if (!(ctx->mimeEncoding == MIME_7BIT || ctx->mimeEncoding == MIME_QUOTED || ctx->mimeEncoding == MIME_BASE64))
   return str;

   for (ptr=str; ptr && *ptr; ptr++)
  	   *ptr |= 0x7f;

   return str;
   }

/* convert a string to UTF-8 encoding */
char *smtp_mime_toUTF8(pool p, mimectx ctx, char *str)
   {
   char *ptr;
   if (strcasecmp(ctx->mimeCharset, "utf-8")==0)
      return str;

   /* XXX this is not correct handling */
   for (ptr=str; ptr && *ptr; ptr++)
  	   if (*ptr>126 || *ptr<1)
	      *ptr = ' ';

   return str;
   }

/* decode a quoted printable string line */
char *smtp_mime_decode_quoted(pool p, mimectx ctx, char *str)
   {
   char *tmp;
   tmp = (char*)pmalloco(p, j_strlen(str)+1);
   fromQP(str, (void *) tmp);
   if (strcasecmp(ctx->mimeCharset, "utf-8")==0)
      return tmp;
   else
      return smtp_mime_toUTF8(p, ctx, tmp);
   }

/* decode a base64 encoded string */
char *smtp_mime_decode_base64(pool p, mimectx ctx, char *str)
   {
   str_b64decode(str);
   if (strcasecmp(ctx->mimeCharset, "utf-8")==0)
      return str;
   else
      return smtp_mime_toUTF8(p, ctx, str);
   }

/* decode a mime encoded string */
char *smtp_mime_decode(pool p, mimectx ctx, char *str)
   {
   if (!ctx->mimeUsed)
	  return str;

   switch (ctx->mimeEncoding)
      {
	  case MIME_7BIT:
//	       smtp_mime_check7bit(s, ctx, str);
	       return str;

 	  case MIME_8BIT:
	       return smtp_mime_toUTF8(p, ctx, str);

	  case MIME_BINARY:
	       /* XXX how to handle binary encoded data? */
	       return smtp_mime_toUTF8(p, ctx, str);

	  case MIME_QUOTED:
	       return smtp_mime_decode_quoted(p, ctx, str);

	  case MIME_BASE64:
	       return smtp_mime_decode_base64(p, ctx, str);

	  default:
	       log_warn("smtp", "Invalid mimeEncoding in mimectx: %i", ctx->mimeEncoding);
	       return smtp_mime_toUTF8(p, ctx, str); // you must remove non ASCII characters
      }
   return str;
   }


char *smtp_in_getaddr(pool p, char *str)
   {
   char *cur, *top;
   int isaddr = 0;

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"searching for an address in: %s",str);
   #endif
//From: "New America Loan" <VincentWiley @apparellimited.com>

   for (top = cur = pstrdup(p,str);cur != NULL && *cur != '\0';cur++)
       {
       /* can't grok invalid chars in an address */
       if (index(SMTP_JID_ICHS,*cur) != NULL)
          {
          /* we've hit an invalid char at the end of a valid address, snip it and quit */
          if (isaddr)
             {
             *cur = '\0';
             break;
             }
          top = cur + 1;
          continue;
          }

       /* yay, a @ after some valid chars, it's an address! (or so we hope) */
       if (*cur == '@')
          {
          *cur = '%'; /* escape it, of course */
          isaddr = 1;
          continue;
          }
       }

   if (isaddr)
      {
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"we've found something we think is an address: %s",top);
      #endif
      return top;
      }

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"nothing of concequence found");
   #endif
   return NULL;
   }


char *smtp_in_getaddrex(pool p, char *str)
   {
   char *cur, *top;
   int isaddr = 0;

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"searching for an address in: %s",str);
   #endif

   for (top = cur = pstrdup(p,str);cur != NULL && *cur != '\0';cur++)
       {
       /* can't grok invalid chars in an address */
       if (index(SMTP_JID_ICHS,*cur) != NULL)
          {
          /* we've hit an invalid char at the end of a valid address, snip it and quit */
          if (isaddr)
             {
             *cur = '\0';
             break;
             }
          top = cur + 1;
          continue;
          }

       /* yay, a @ after some valid chars, it's an address! (or so we hope) */
       if (*cur == '@')
          {
          isaddr = 1;
          continue;
          }
       }

   if (isaddr)
      {
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"we've found something we think is an address: %s",top);
      #endif
      return top;
      }

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"nothing of concequence found");
   #endif
   return NULL;
   }



void smtp_in_AddAdversiting(smtpsi si, smptsi_rcp rcpt, xmlnode loBody)
   {
   if (rcpt->Advertising==1)
      {
      xmlnode_insert_cdata(loBody,"\r\n",-1);
      xmlnode_insert_cdata(loBody,xmlnode_get_data(si->oAD),-1);
      }

   }

void smtp_in_ThreadReplace(smtpsi si, smptsi_rcp rcpt)
   {

   xmlnode loThread=xmlnode_get_tag(si->x,"thread");
   if (loThread!=NULL)
      xmlnode_hide(loThread);

   // Add thread data
   if ((si->iThreadData==1 && rcpt->OutputMode==0) || rcpt->OutputMode==2 )
      {
      loThread=xmlnode_insert_tag(si->x,"thread");
      xmlnode_put_attrib(si->x,"type","chat");
      xmlnode_insert_cdata(loThread,si->cThreadData,-1);
      }

   }

void smtp_in_SubjectReplace(smtpsi si, smptsi_rcp rcpt, char *lcSubject, xmlnode loSubject)
   {
   int liLOS=j_strlen(lcSubject),liLNS=j_strlen(rcpt->SRText) ;

   if ((liLOS>0 && liLNS==0 && (rcpt->SRMode==2 || rcpt->SRMode==1)) || (rcpt->SRMode==0 && liLOS>0)) // if  empty and replace is 2 or 1
      {
      xmlnode_insert_cdata(loSubject,lcSubject,-1);
      return;
      }

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"DATA - replace subject %i",rcpt->SRMode);
   #endif
   if (rcpt->SRMode!=0 && liLNS>0 && liLOS==0 && rcpt->SRMode==3)
      {
      xmlnode_insert_cdata(loSubject,spools(si->p,rcpt->SRText,si->p),-1);
      return;
      }

   if (rcpt->SRMode!=0 && liLNS>0 && liLOS>0 && rcpt->SRMode==1) // if not empty and replace is 1
      {
      xmlnode_insert_cdata(loSubject,spools(si->p,rcpt->SRText," ",rcpt->SRSeparator," ",lcSubject,si->p),-1);
      return;
      }

   if (rcpt->SRMode!=0 && liLNS>0 && liLOS>0 &&  rcpt->SRMode==2) // if not empty and replace is 2
      {
      xmlnode_insert_cdata(loSubject,spools(si->p,lcSubject," ",rcpt->SRSeparator," ",rcpt->SRText,si->p),-1);
      return;
      }
 
   }

/* extract a value from header line*/
char *smtp_in_GetHeaderLineValue(smtpsi si, char *lcLine, const char *lcAttrib)
   {
   int liLen;
   char *lcRet,*liS,*liE,*liSX;
   if (j_strlen(lcLine)==0)
       return (char *) NULL;

   if (lcAttrib=="") // get basic value
      {
      liS=lcLine;
      liE=strstr(liS,";");
      liLen=(liE==NULL)?j_strlen(lcLine):(int) (liE-liS);
      }
   else // get attrib value
      {
      liS=smtp_strcasestr(lcLine,(char *)lcAttrib); // find attrib


      if (liS==NULL) // attrib not found
         return NULL;

      liS=strstr(liS+strlen(lcAttrib),"="); // find =
      if (liS==NULL) // Not found, m po prdeli
         return NULL;

      liSX=strstr(liS+1,"\""); // find "
      if (liSX!=NULL) 
         {
         liS=liSX+1;
         liE=strstr(liS,"\""); // found end of value assignment
         if (liE==NULL) // Not found, m po prdeli
            return NULL;
         }
      else
         {
         liS++;
         liE=strstr(liS,";"); // found end of value assignment
         }

      liLen=(liE==NULL)?(j_strlen(lcLine)- ((int)(liS-lcLine)) ):(liE-liS);
      }


   lcRet = pmalloc(si->p, liLen+1);
   lcRet[liLen] = '\0';
   strncpy(lcRet, liS, liLen);
   return lcRet;
   }

/* extract a header line from the received message */
int smtp_in_header(smtpsi si, char *msg, char *header, int structured, spool sp, long long *liNextLine)
   {
   char *linebegin = msg;
   char *lineend = strchr(linebegin, '\n');
   char *liS,*liE,*liAtt;
   char *tbuf,*ptr;
   size_t hlen,liLen;
   int liNext=0,liSep,liRow=1,liEnd=0;
   *liNextLine=0;

   if (header == NULL)
	  return 0;

   hlen = strlen(header);

   /* Handle headerlines that are splitted to multible lines */
   while (linebegin && lineend && lineend>linebegin && *linebegin!='\n' && *(linebegin+1)!='\n')
      { /* there is another headerline to process */
      // find while you don't find \r\n\r\n

      liS=linebegin;
      liE=lineend;
      liRow++;

      // find separator on line
      liE[0]='\0'; // End of string
      if ((liAtt=strstr(liS,"\""))==NULL)
         liAtt=strstr(liS,"\'");

      ptr=strstr(liS,":");
      liE[0]='\n';

      liSep=((ptr) && ptr<liE && (liAtt==NULL || (liAtt!=NULL && ptr<liAtt)))?1:0;

      if (liNext==1 && liSep==1) // next row + detect separator
         {
         *liNextLine=(long long)(liS - msg);
         break; //
         }


  	  /* is it the header we are looking for? */
	  if ((liNext==1 && liSep==0) ||
          (strncasecmp(liS, header, hlen)==0 && liS[hlen]==':'))
	     { /* we found the header */


	     liS = liS+(liNext==1?0:hlen)+1;
         if (liE[0]=='\n')
            liE--;

	     /* skip space at the beginning of header content */
	     while (*liS == ' ' || *liS == '\t') liS++;
	     /* skip space at the end of the header content */
	     while (liE[-1] == ' ' || liE[-1] == '\t') liE--;

	     /* empty header? */
	     if (liE <= liS)
		    break;

	     /* return header content */
	     liLen = liE - liS + 1;
	     tbuf = pmalloc(si->p, liLen+1);
	     tbuf[liLen] = '\0';
	     strncpy(tbuf, liS, liLen);
         spooler(sp,tbuf,sp);
         liNext=1;
         // don't return
         // skip to next row
         if (liEnd==1)
            break;

	     }

         
	  /* continue with next header line */
	  linebegin = lineend + 1;
	  lineend = strchr(linebegin, '\n');
      if (lineend==NULL) // End of Data !!!
         {
         lineend=msg+j_strlen(msg)-1;
         liEnd=1;
         }
      }


   if (sp->len==0)
      return 0;

   /* XXX unescape MIME here */
   tbuf=spool_print(sp);

   /* headers are not allowed to contain non-ASCII in encoded form */
   for (ptr = tbuf; *ptr; ptr++)
       if (*ptr > 126 || *ptr < 32) *ptr = ' ';

   /* content in brackets is comment if it is a structured header */
   while (structured && (ptr = strchr(tbuf, '(')) != NULL)
         {
         char *commentend = strchr(ptr, ')');
         if (commentend == NULL)
            *ptr='\0';
         else
            {
		    size_t copylen;
		    size_t i;
		    copylen = strlen(commentend);

		    for (i=0; i<copylen; i++)
			    ptr[i] = commentend[i+1];
		    }
	     }

   sp=spool_new(si->p);
   spooler(sp,tbuf,sp);

   return sp->len;
   }

// parse mail body
char *smtp_in_ParsePGPBody(smtpsi si,char *lcBody, xmlnode loCBx,const char *lcPart, const char *lcDefPart)
   {
   char *lcCB,*lcStart=NULL;
   xmlnode loCB;
   for (loCB = xmlnode_get_firstchild(loCBx); loCB != NULL; loCB = xmlnode_get_nextsibling(loCB))
       {
       if (loCB->type!=NTYPE_TAG)
		   continue;

       if (loCB!=NULL)
	      {
          lcCB=xmlnode_get_data(loCB);
	      if (lcCB!=NULL)
             lcStart=strstr(lcBody, spools(si->p,"-----",lcPart," ",lcCB,"-----",si->p));
		  }

	   if (lcStart!=NULL)
          break;

       
	   }

   if (lcStart==NULL) // if not cbm or cb elements defined or is not found any cb
      lcStart=strstr(lcBody, lcDefPart);

   return lcStart;
   }


// parse mail body
int smtp_in_ParseMailBody(smtpsi si,mimectx ctx, char *lcBody, char *lcMBound, smptsi_rcp rcpt)
   {
   char *ptr,*lcBoundary, *lcLine, *lcLinetmp, *liS, *liE, *lcTmp, *lcCT, *lcMBody,
        *lcME, *lcDN,*lcProtocol,*liSM,*lcEndB;
   long long  liNextLine;
   int liLen,liAttach=0,liRet;
   spool tmpsp;
   xmlnode loBody;
   pool tmpp;
   // text/plain
   // ostatn pevst na utf-8 a pak na base64 + pidat pvodn type

   // multipart/mixed??
   // multipart/alternative??
   //  najt text/plain

   // 1. content type uruje tlo mailu
   // Content-type: multipart/alternative; boundary="gc0p4J:2408t"
   // nachzej se dal sti (text, html, soubory)

   // dal content typy uvnit tla uruj jednotliv sti
   // --gc0p4J:2408t
   // Content-type: plain/text; charset=
   // Content-type: plain/html; charset=

   // --gc0p4J:2408t--
   // konec tla sti

   // content type


   if (smtp_in_header(si, lcBody, "Content-Type", 0,tmpsp=spool_new(si->p),&liNextLine)==0)
      return 0;

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"BODY - lcBody: %s",lcBody);
   #endif

   lcMBody=strstr((lcBody+liNextLine), "\n\n"); // Get Data section
   if (lcMBody)
      {
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"BODY - lcMBody - exist %i",lcMBody);
      #endif
      lcMBody+=2;
      }
   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"BODY - lcMBody %i %s",lcMBody,lcMBody);
   #endif

   lcLine=spool_print(tmpsp);
   lcCT=smtp_in_GetHeaderLineValue(si,lcLine,""); // get basic value

   // check if is't multipart or  alternative
   if (strncasecmp(lcCT,"multipart/mixed",15)==0 ||
       strncasecmp(lcCT,"multipart/alternative",21)==0 ||
       strncasecmp(lcCT,"multipart/parallel",18)==0 ||
       strncasecmp(lcCT,"multipart/encrypted",19)==0 ||
       strncasecmp(lcCT,"multipart/signed",16)==0
      )
      {
      lcProtocol=smtp_in_GetHeaderLineValue(si,lcLine,"protocol"); // get protocol value
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"BODY - get protocol %s",lcProtocol);
      #endif

      if (lcProtocol!=NULL && si->iPGP==0 && strncasecmp(lcProtocol,"application/pgp-encrypted",25)==0) // PGP encrypted
         si->iPGP=1;

      if (lcProtocol!=NULL && si->iPGP==0 && strncasecmp(lcProtocol,"application/pgp-signature",25)==0) // PGP signed
         si->iPGP=2;

      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"BODY - Content Type Protocol %i",si->iPGP);
      #endif

      lcBoundary=smtp_in_GetHeaderLineValue(si,lcLine,"boundary");
      if (j_strlen(lcBoundary)==0)
         return -1;

      lcBoundary=spools(si->p,"--",lcBoundary,si->p);

      if ((ptr=strstr(lcMBody,lcBoundary))==NULL) // BODY FAILED !!!
         return -1;

      if ((lcEndB=strstr(lcMBody,spools(si->p,lcBoundary,"--",si->p)))==NULL) // BODY FAILED !!!
         return -1;

      while ( ptr<lcEndB)
            {
            // reset for each boundary
            ctx->mimeEncoding = MIME_7BIT;
            ctx->mimeCharset = "us-ascii";

            liRet=smtp_in_ParseMailBody(si, ctx, ptr,lcBoundary,rcpt );
            if (liRet==-1) // BODY FAILED !!!
               return liRet;

            ptr=strstr(ptr+j_strlen(lcBoundary),lcBoundary);
            }
      return 1;
      }

   ctx->mimeEncoding = MIME_7BIT;
   ctx->mimeCharset = "us-ascii";

   loBody=xmlnode_get_tag(si->x,"body");
   xmlnode_insert_cdata(loBody,"\r\n",-1);

   // encoding for data
   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"BODY - get content-transfer-encoding");
   #endif
   if (smtp_in_header(si, lcBody, "Content-Transfer-Encoding", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      {
      lcME=ptr=spool_print(tmpsp);

      if (!ptr)
         ctx->mimeEncoding = MIME_7BIT;
      else if (strcasecmp(ptr, "8bit")==0)
         ctx->mimeEncoding = MIME_8BIT;
      else if (strcasecmp(ptr, "7bit")==0)
         ctx->mimeEncoding = MIME_7BIT;
      else if (strcasecmp(ptr, "quoted-printable")==0)
         ctx->mimeEncoding = MIME_QUOTED;
      else if (strcasecmp(ptr, "base64")==0)
  	     ctx->mimeEncoding = MIME_BASE64;
      else if (strcasecmp(ptr, "binary")==0)
         ctx->mimeEncoding = MIME_BINARY;
      }

   // Is't file part? (ignore pgp)
   if (si->iPGP==0 && 
       smtp_in_header(si, lcBody, "Content-Disposition", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      {
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"BODY - is not PGP, it's maybe file part");
      #endif

	  lcDN=smtp_in_GetHeaderLineValue(si,lcLine,"name"); // get display name for attachment
      lcLinetmp=spool_print(tmpsp);

      if ((ptr=smtp_in_GetHeaderLineValue(si,lcLinetmp,"")) && 
          (ptr=smtp_in_GetHeaderLineValue(si,lcLinetmp,"filename")) &&
          j_strlen(ptr)>0
         )
         {
         liAttach=1; // yes it's file part
         if (lcDN)
            {
            #ifdef SMTP_DB
             SMTP_DEBUG(SMTP_ZONE,"BODY - file part");
            #endif
            xmlnode_insert_cdata(loBody,"Display name: ",-1);
            xmlnode_insert_cdata(loBody,lcDN,-1);
            xmlnode_insert_cdata(loBody,"\r\n",-1);
            }

         xmlnode_insert_cdata(loBody,"file: ",-1);
         xmlnode_insert_cdata(loBody,ptr,-1);
         xmlnode_insert_cdata(loBody,"\r\n",-1);

         xmlnode_insert_cdata(loBody,"Transfer encoding: ",-1);
         xmlnode_insert_cdata(loBody,lcME,-1);
         xmlnode_insert_cdata(loBody,"\r\n",-1);

         }
      }
   else
      {
      }

   if (liAttach==0 && (ptr=smtp_in_GetHeaderLineValue(si,lcLine,"charset")))
      ctx->mimeCharset = ptr; // charset encoding

   // read boundary data
   if (j_strlen(lcMBound)>0)
      {
      liS=lcMBody;
      liE=strstr(lcMBody, lcMBound); // find next/end of boundary
      liLen=liE-(liS);
      }
   else
      {
      liLen=j_strlen(lcMBody);
      liS=lcMBody;
      }

   // move data if...
   if (si->iPGP>=1 || 
       (si->iPGP==0 && ((liAttach==1 && rcpt->Attachments==1) || liAttach==0))
      )
      {
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"BODY - create copy of boudary data, %i %s",liLen,liS);
      #endif
      lcTmp = pmalloc(si->p, liLen+1);
      lcTmp[liLen] = '\0';
      strncpy(lcTmp, liS, liLen);
      }


   if (si->iPGP==2 || (si->iPGP==0 && liAttach==0)) // text only, signed message
      {
      if (si->iPGP==0 && rcpt->nonMIME2x==1)
         {
         #ifdef SMTP_DB
          SMTP_DEBUG(SMTP_ZONE,"BODY - test inline PGP");
         #endif

         if (smtp_in_ParsePGPBody(si,lcTmp,xmlnode_get_tag(jtin->config,"core/pgp/cbm"),SMTP_PGP_sBEGIN,SMTP_PGP_MESSAGE_BEGIN))
            {
  		    si->iPGP=3;
            #ifdef SMTP_DB
             SMTP_DEBUG(SMTP_ZONE,"BODY - inline PGP MESSAGE");
            #endif
            }
         else
            {
            // try find pgp signed message
            if ((liSM=smtp_in_ParsePGPBody(si,lcTmp,xmlnode_get_tag(jtin->config,"core/pgp/cbs"),SMTP_PGP_sBEGIN,SMTP_PGP_SIGNATURE_BEGIN)))
               {
               si->iPGP=4;
               #ifdef SMTP_DB
                SMTP_DEBUG(SMTP_ZONE,"BODY - inline PGP SIGNATURE");
               #endif
               }
            }
         }

      if (si->iPGP==0 ||                    
          (si->iPGP==2 && strncasecmp(lcCT,"application/pgp-signature",25)!=0)
          ) // text only, signed but text boundary
         {
         #ifdef SMTP_DB
          SMTP_DEBUG(SMTP_ZONE,"BODY - text only, signed but text boundary %s",lcTmp);
         #endif
         PM_Reg(5060, si->p,tmpp=pool_new(),1,NULL);
         xmlnode_insert_cdata(loBody,smtp_mime_decode(tmpp, ctx, lcTmp),-1);
         pool_free(tmpp);
            
         return 1;
         }
      }

   if (si->iPGP==0 && liAttach==1) // attachment only
      {
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"BODY - non PGP, any attachment");
      #endif
      if (rcpt->Attachments==1)
         {
         if (ctx->mimeEncoding == MIME_8BIT)
            {
            PM_Reg(5062, si->p, tmpp=pool_new(),1,NULL);
            xmlnode_insert_cdata(loBody,smtp_mime_decode(tmpp, ctx, lcTmp),-1);
            pool_free(tmpp);
            }
         else
            xmlnode_insert_cdata(loBody,lcTmp,-1);
         }

      return 1;
      }

   if (si->iPGP==1 || si->iPGP==3) // PGP encrypted
      {
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"BODY - PGP MESSAGE");
      #endif
      xmlnode_put_attrib(loBody=xmlnode_insert_tag(si->x,"x"),"xmlns","jabber:x:encrypted");

      // decode data
      PM_Reg(5064, si->p,tmpp=pool_new(),1,NULL);
      lcTmp=smtp_mime_decode(tmpp, ctx, lcTmp);
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"PGP - data: %s",lcTmp);
      #endif

      // locate empty row after -----BEGIN PGP MESSAGE-----
      if ((liE=strstr(lcTmp,"\n \n"))==NULL)
         {
         liE=strstr(lcTmp,"\n\n");  // locate empty row after -----BEGIN PGP MESSAGE-----
         lcTmp=liE+2;
         }
      else
         lcTmp=liE+3;

      liE=smtp_in_ParsePGPBody(si,lcTmp,xmlnode_get_tag(jtin->config,"core/pgp/cbs"),SMTP_PGP_sEND,SMTP_PGP_MESSAGE_END);

      if (liE)
         liE[0]='\0';

      xmlnode_insert_cdata(loBody,lcTmp,-1);
      pool_free(tmpp);
      return 1;
      }


   if (si->iPGP==2 || si->iPGP==4) // PGP signed
      {
      PM_Reg(5066,si->p, tmpp=pool_new(),1,NULL);
      lcTmp=smtp_mime_decode(tmpp, ctx, lcTmp);
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"BODY - PGP SIGNED %s",lcTmp);
      #endif
      
      // liSM is begin of PGP signature
      // Find -----BEGIN PGP SIGNED MESSAGE-----
      if (si->iPGP==4)
	     {
   	     ptr=strstr(lcTmp,SMTP_PGP_SIGNED_MESSAGE);
         #ifdef SMTP_DB
          SMTP_DEBUG(SMTP_ZONE,"----\r\n %s",ptr);
         #endif

 		 if (ptr != NULL)
		 	{
			if ((liE=strstr(ptr,"\n \n"))==NULL)  // locate empty row after -----BEGIN PGP SIGNATURE-----
				{
				liE=strstr(ptr,"\n\n");  // locate empty row after -----BEGIN PGP SIGNATURE-----
				ptr=liE+2;
				}
			else
				{
				ptr=liE+3;
				}


			liSM--;
			liSM[0]='\0';
			liSM++;
			xmlnode_insert_cdata(loBody,smtp_mime_decode(tmpp, ctx, ptr),-1);
			}
		 }
	  else
	     {
         liSM=lcTmp;
		 }


      loBody=xmlnode_insert_tag(si->x,"x");
      xmlnode_put_attrib(loBody,"xmlns","jabber:x:signed");

      // locate empty row after -----BEGIN PGP SIGNATURE-----
      if ((liE=strstr(liSM,"\n \n"))==NULL)
         {

		 liE=strstr(liSM,"\n\n");  // locate empty row after -----BEGIN PGP SIGNATURE-----
         lcTmp=liE+2;
         #ifdef SMTP_DB
          SMTP_DEBUG(SMTP_ZONE,"PGP - signature: %s",lcTmp); 
         #endif
         }
      else
         {
         lcTmp=liE+3;
         }


      liE=smtp_in_ParsePGPBody(si,lcTmp,xmlnode_get_tag(jtin->config,"core/pgp/cbs/cb"),SMTP_PGP_sEND,SMTP_PGP_SIGNATURE_END);

      if (liE)
         liE[0]='\0';

      xmlnode_insert_cdata(loBody,lcTmp,-1);
      pool_free(tmpp);

      return 1;
      }

   return 0;
   }

void smtp_in_deliver_message(smtpsi si, int liMode)
   {
   smptsi_rcp rcpt;
   int liType;
   xmlnode addresses,address;

  
   if (jtin->jep0033==1) // JEP-0033 support
      {
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"DATA - JEP-0033 support");
      #endif
      rcpt= si->rcpt;
      xmlnode_put_attrib(si->x,"to",rcpt->rcpt->server); // jabber server
      xmlnode_put_attrib(addresses=xmlnode_insert_tag(si->x,"addresses"),"xmnls","http://jabber.org/protocol/address");

      for (rcpt = si->rcpt ; rcpt != NULL; rcpt = rcpt->next)
          {
          if ((liMode==SMTP_IN_DELIVER_GLOBAL && rcpt->UseGlobalSettings==0) || rcpt->iSpammer==1)
             continue;

          liType=2;
          if (strstr(si->listcc,rcpt->smtpaddr)) // is in cc list?
             liType=0;

          if (strstr(si->listto,rcpt->smtpaddr)) // is in to list?
             liType=1;

          xmlnode_put_attrib(address=xmlnode_insert_tag(addresses,"address"),"jid",jid_full(rcpt->rcpt));

          if (liType==0) // is in cc list?
             {
             #ifdef SMTP_DB
              SMTP_DEBUG(SMTP_ZONE,"DATA - sending to (cc) %s",jid_full(rcpt->rcpt));
             #endif
             xmlnode_put_attrib(address,"type","cc");
             }

          if (liType==1) // is in to list?
             {
             #ifdef SMTP_DB
              SMTP_DEBUG(SMTP_ZONE,"DATA - sending to (to) %s",jid_full(rcpt->rcpt));
             #endif
             xmlnode_put_attrib(address,"type","to");
             }

          if (liType==2)
             {
             #ifdef SMTP_DB
              SMTP_DEBUG(SMTP_ZONE,"DATA - sending to (bcc) %s",jid_full(rcpt->rcpt));
             #endif
             xmlnode_put_attrib(address,"type","bcc");
             }
          }

      deliver(dpacket_new(xmlnode_dup(si->x)),jtin->i);
      smtp_stats_out(si->x);
      }
   else
      {
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"DATA - NOT JEP-0033 support");
      #endif
      xmlnode_hide_attrib(si->x,"to");
      for (rcpt = si->rcpt; rcpt != NULL; rcpt = rcpt->next) 
          {
          if ((liMode==SMTP_IN_DELIVER_GLOBAL && rcpt->UseGlobalSettings==0) || rcpt->iSpammer==1)
             continue;

          #ifdef SMTP_DB
           SMTP_DEBUG(SMTP_ZONE,"DATA - sending to %s",jid_full(rcpt->rcpt));
          #endif
          xmlnode_put_attrib(si->x,"to",jid_full(rcpt->rcpt));

          deliver(dpacket_new(xmlnode_dup(si->x)),jtin->i);
          smtp_stats_out(si->x);
          }
      }

   }




void smtp_in_message(void *arg)
   {
   jid cur;
   smtpsi si = (smtpsi)(arg);
   smptsi_rcp rcpt,next;
   xmlnode loSubj,loBody, loSubject,loBRs,loBR,loBaseMsg,loDerivMsg,loMail,loEML;
   char *msg,*body,*ptr,*data,*subject=NULL, *subjectCP, *subjectE, *lcJID, 
        *lcPom,*lcMax,*thread_data,*lcXXX, *lcFrom;
   int  liSpam=0,liRet=0,lii;
   long long liNextLine; 
   _mimectx ctx;
   time_t now_unixtime;
   struct tm now;
   spool tmpsp,rcpts;
   pool p,tmpp;
   smtpp par;
  
   si->cStatus=pstrdup(si->p,"I got message");
   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"DATA - I got a message! (size: %i)",si->iSize);
   #endif


   // normalize line breaks to '\n' only 
   si->cStatus=pstrdup(si->p,"Normalize line breaks");
   msg = si->Body;
   if (j_strlen(msg)!=0)
      {
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"DATA - normalize line breaks");
      #endif
      while ((ptr = strstr(msg, "\r\n")) != NULL)
         strcpy(ptr, ptr+1);

      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"DATA - normalize line breaks II");
      #endif
      while ((ptr = strchr(msg, '\r')) != NULL)
	     *ptr = '\n';
      }


   si->MBody = strstr(msg, "\n\n");
   si->MBody += 2;

   si->cStatus=pstrdup(si->p,"Reading sender");
   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"DATA - Getting FROM");
   #endif
   // set the sending email addr frist from the reply-to, then the sender, then finally the addr smtp claims it was from 
   if (smtp_in_header(si, msg, "Resent-From", 1,tmpsp=spool_new(si->p),&liNextLine)>0)
      lcFrom = smtp_in_getaddrex(si->p,spool_print(tmpsp));
   else   
      if (smtp_in_header(si, msg, "Reply-To", 1,tmpsp=spool_new(si->p),&liNextLine)>0)
         lcFrom = smtp_in_getaddrex(si->p,spool_print(tmpsp));
      else   
         if (smtp_in_header(si, msg, "From", 1,tmpsp=spool_new(si->p),&liNextLine)>0)
            lcFrom = smtp_in_getaddrex(si->p,spool_print(tmpsp));
         else   
            lcFrom = smtp_in_getaddrex(si->p,si->from);


   lcXXX = (char*)pmalloc_x(si->p, 1024,'\0');

   // seznam pjemc
   rcpts=spool_new(si->p);
   smtp_list_to_spool(rcpts,si->rcptFD);
   smtp_list_to_spool(rcpts,si->rcpt);

   // test zda je odeslatel spammer pro vechny pjemce
   if (si->rcpt!=NULL && (next = si->rcpt)->_iGSpammer==1)
      {
      jtin->Stats->SMTPSpammers++;
      jtin->Stats->_SMTPSpammers++;
      jtin->Stats->SMTPMessages--;
      jtin->Stats->_SMTPMessages--;
      smtp_StatsSave();

      smtp_SendInfoToAdmin(spools(si->p,"Sender is spammer for all recipients... from: ", lcFrom," recipients: ",spool_print(rcpts) ,si->p),SMTP_SITA_M);
      smtp_reset_in(si);

      if (si->iType==SMTP_IN_EMAIL)
          pool_free(si->p);
      return ;

      }              


   // check maxsize
   if (si->iSize>jtin->iMaxSize && jtin->iMaxSize>0)
      {
      jtin->Stats->_SMTPMaxSize++;
      jtin->Stats->SMTPMaxSize++;
      jtin->Stats->SMTPMessages--;
      jtin->Stats->_SMTPMessages--;
      smtp_StatsSave();
      si->iProcessMail=2;

      p=pool_new();   
      par= smtp_param_i(p,jtin->i);
      PM_Reg(5004,si->p, p,1,NULL);

      smtp_SendInfoToAdmin(spools(si->p,"DATA is overflow ",smtp_itoa(si->p,si->iSize),">",smtp_itoa(si->p,SMTP_DATA_MAX)," (",smtp_itoa(si->p,(int)si),") from: ", lcFrom," recipients: ",spool_print(rcpts) ,si->p),SMTP_SITA_M);


      next = si->rcpt;
      while (next != NULL)
        {
        snprintf(lcXXX, 1024, smtp_rc_GetString(si->p,xmlnode_get_attrib(next->oJID,"lang"),SMTP_RC_ID_2250),jtin->iMaxSize,si->iSize,lcFrom,'\0');
        smtp_SendInfoToAny(NULL,jid_full(next->rcpt), lcXXX ,j_atoi(xmlnode_get_attrib(next->oJID,"SendSystemMessage"),SMTP_SITA_P),NULL); 
        next = next->next;
        }

      xmlnode_put_attrib(loMail=xmlnode_new_tag("x"),"to",lcFrom);
      xmlnode_put_attrib(loMail,"from",spools(si->p,"MAILER-DAEMON","@",jtin->me,si->p));
      xmlnode_insert_cdata(loBody=xmlnode_insert_tag(loMail,"body"),spools(si->p,"A mail is bigger (",smtp_itoa(si->p,si->iSize),"B) than allowed size (",smtp_itoa(si->p,SMTP_DATA_MAX),"B)",si->p),-1);
      xmlnode_insert_cdata(xmlnode_insert_tag(loMail,"subject"),"Jabber-SMTP transport, bigmail",-1);
      xmlnode_insert_cdata(loBody,spools(si->p,"Sender: ",lcFrom,"\r\n",si->p),-1);
      xmlnode_insert_cdata(loBody,"Recipients: ",-1);
      xmlnode_insert_cdata(loBody,spool_print(rcpts),-1);

      smtp_out_process_message(par, (void*) smtp_in_replytosmtp_cb, (void*) loMail, (void*) smtp_in_replytosmtp_cbf, (void*) loMail);


      smtp_reset_in(si);
      if (si->iType==SMTP_IN_EMAIL)
         pool_free(si->p);
      return;
      }

   // any recipient is bad, send bouncy message
   if ((next = si->rcptFD)!=NULL)
      {
      si->cStatus=pstrdup(si->p,"Any recipient failed, sending bounce message");
      if (next->_iForwarde==1)
         {
         p=pool_new();   
         par= smtp_param_i(p,jtin->i);
         PM_Reg(5003,si->p, p,1,NULL);
         xmlnode_put_attrib(loBRs=xmlnode_new_tag("x"),"from",lcFrom);
         PM_Reg(5030,si->p, xmlnode_pool(loBRs),1,NULL);
         }

      while (next != NULL)
        {
        if (next->iForwarde==1)
           {
           xmlnode_put_attrib(loBR=xmlnode_insert_tag(loBRs,"rcptfd"),"smtpaddr",next->smtpaddr);
           xmlnode_put_attrib(loBR,"iErr",smtp_itoa(p,next->iErr));
           }

        if (next->iErr==553)
           {
           snprintf(lcXXX, 1024, smtp_rc_GetString(si->p,xmlnode_get_attrib(next->oJID,"lang"),SMTP_RC_ID_2270),lcFrom,'\0');
           smtp_SendInfoToAny(NULL,jid_full(next->rcpt), lcXXX ,j_atoi(xmlnode_get_attrib(next->oJID,"SendSystemMessage"),SMTP_SITA_P),NULL);
           jtin->Stats->SMTPNRRecipient++;
           jtin->Stats->_SMTPNRRecipient++;
           }

        if (next->iErr==450)
           {
           snprintf(lcXXX, 1024, smtp_rc_GetString(si->p,xmlnode_get_attrib(next->oJID,"lang"),SMTP_RC_ID_2280),lcFrom,'\0');
           smtp_SendInfoToAny(NULL,jid_full(next->rcpt), lcXXX ,j_atoi(xmlnode_get_attrib(next->oJID,"SendSystemMessage"),SMTP_SITA_P),NULL);
           jtin->Stats->SMTPBlockedByRecipient++;
           jtin->Stats->_SMTPBlockedByRecipient++;
           }

        if (next->iErr==550)
           {
           jtin->Stats->SMTPBadRecipient++;
           jtin->Stats->_SMTPBadRecipient++;
           }

        next = next->next;
        }

      if (si->rcptFD->_iForwarde==1)
         smtp_out_process_message(par, (void*) smtp_in_recipient_cb, (void*) loBRs, (void*) smtp_in_recipient_cbf, (void*) loBRs);
      // send message to recipients so, e-mail is ommited because 

      }              

   if (si->rcpt==NULL) // all recipients are bad, but nothing for receinving
      {
      jtin->Stats->SMTPNoRecipient++;
      jtin->Stats->_SMTPNoRecipient++;
      jtin->Stats->SMTPMessages--;
      jtin->Stats->_SMTPMessages--;
      smtp_StatsSave();

      si->iProcessMail=2;
      smtp_reset_in(si);

      if (si->iType==SMTP_IN_EMAIL)
          pool_free(si->p);

      return;
      }


   if (si->iFastProcessing==1)
      {
      jtin->Stats->SMTPNoProcess++;
      jtin->Stats->_SMTPNoProcess++;
      jtin->Stats->SMTPMessages--;
      jtin->Stats->_SMTPMessages--;
      smtp_StatsSave();

      smtp_SendInfoToAdmin(spools(si->p,"FastProcessing detected, but no out agou?!?... from: ", lcFrom," recipients: ",spool_print(rcpts) ,si->p),SMTP_SITA_M);

      if (si->buffer!=NULL)
         free(si->buffer);

      if (si->iType==SMTP_IN_EMAIL)
          pool_free(si->p);
      return ;
      }

   if (j_strlen(msg)==0)
      {
      jtin->Stats->SMTPNoProcess++;
      jtin->Stats->_SMTPNoProcess++;
      jtin->Stats->SMTPMessages--;
      jtin->Stats->_SMTPMessages--;
      smtp_StatsSave();

      smtp_SendInfoToAdmin(spools(si->p,"Mail data empty... from: ", lcFrom," recipients: ",spool_print(rcpts) ,si->p),SMTP_SITA_M);

      next = si->rcpt;
      while (next != NULL)
        {
        snprintf(lcXXX, 1024, smtp_rc_GetString(si->p,xmlnode_get_attrib(next->oJID,"lang"),SMTP_RC_ID_2290),lcFrom,'\0');
        smtp_SendInfoToAny(NULL,jid_full(next->rcpt), lcXXX ,j_atoi(xmlnode_get_attrib(next->oJID,"SendSystemMessage"),SMTP_SITA_P),NULL);
        next = next->next;
        }

      if (si->buffer!=NULL)
         free(si->buffer);

      if (si->iType==SMTP_IN_EMAIL)
          pool_free(si->p);
      return ;
      }

   // Check if exist property "X-Jabber-Bouncy"
   // if exist, then ignore this mail
   //   xmlnode_put_attrib(so->x,"X-Jabber-Bouncy","fuck-off");
   if (smtp_in_header(si, msg, "X-Jabber-Bouncy", 1,tmpsp=spool_new(si->p),&liNextLine)>0)
      {
      jtin->Stats->SMTPBouncy++;
      jtin->Stats->_SMTPBouncy++;
      jtin->Stats->SMTPMessages--;
      jtin->Stats->_SMTPMessages--;
      smtp_StatsSave();

      smtp_delete_from_backup(si);

      si->iProcessMail=2;
      smtp_reset_in(si);

      if (si->iType==SMTP_IN_EMAIL)
          pool_free(si->p);
      return;
      }


   si->iPGP=0;
   // init the mime context to not using MIME 
   ctx.mimeUsed = 0;
   ctx.mimeEncoding = MIME_7BIT;
   ctx.mimeCharset = "us-ascii";

///////
//ftp://ftp.rfc-editor.org/in-notes/rfc3464.txt
////


   // spam checking
   if (si->iType==SMTP_IN_EMAIL)
      {
      si->cStatus=pstrdup(si->p,"Checking email as SPAM");
      liSpam=smtp_in_spam(si,msg);
      if (!(liSpam==SPAM_OK || liSpam==SPAM_NotDefined))
         {
         // delete email from backup repository
         si->iProcessMail=2;
         smtp_delete_from_backup(si);

         jtin->Stats->SMTPSpam++;
         jtin->Stats->_SMTPSpam++;
         jtin->Stats->SMTPMessages--;
         jtin->Stats->_SMTPMessages--;
         smtp_StatsSave();
         liRet=1;

         switch (liSpam)
            {
            case 570:
                 smtp_SendInfoToAdmin(spools(si->p,"570 - This mail is probably spam and has not been accepted; from: ", lcFrom," recipients: ",spool_print(rcpts) ,si->p),SMTP_SITA_M);
                 next = si->rcpt;
                 while (next != NULL)
                   {
                   snprintf(lcXXX, 1024, smtp_rc_GetString(si->p,xmlnode_get_attrib(next->oJID,"lang"),SMTP_RC_ID_2300),lcFrom,'\0');
                   smtp_SendInfoToAny(NULL,jid_full(next->rcpt), lcXXX ,j_atoi(xmlnode_get_attrib(next->oJID,"SendSystemMessage"),SMTP_SITA_P),NULL);
                   next = next->next;
                   }
                 break;

            case 430:
                 smtp_SendInfoToAdmin(spools(si->p,"430 - problem executing spam control; from: ", lcFrom," recipients: ",spool_print(rcpts) ,si->p),SMTP_SITA_M);
                 break;
            }

         smtp_reset_in(si);
         if (si->iType==SMTP_IN_EMAIL)
             pool_free(si->p);

         return; // liRet
         }
      }



   loSubj=xmlnode_get_tag(jtin->config,"smtp/defaultaccount");
   si->oAD=xmlnode_get_tag(jtin->config,"smtp/ad"); // Advertising TAG

   loBaseMsg = xmlnode_new_tag("message");
   PM_Reg(5040, si->p,xmlnode_pool(loBaseMsg),1,NULL);

   // projdi seznam pjemc a nati jejich zznamy z rosteru + uivatelsk nastaven
   next =  si->rcpt;
   while(next != NULL)
        {
        lcJID=smtp_GetJID(si->p,jid_full(next->rcpt));
        #ifdef SMTP_DB
         SMTP_DEBUG(SMTP_ZONE,"DATA - user %s",jid_full(next->rcpt));
        #endif

        if (next->oJID!=NULL)
           {
           next->UseGlobalSettings=j_atoi(xmlnode_get_attrib(next->oJID,"UseGlobalSettings"),1);
           next->Attachments=j_atoi(xmlnode_get_attrib(next->oJID,"Attachments"),1);
           next->nonMIME2x=j_atoi(xmlnode_get_attrib(next->oJID,"PGPToJabbernonMIMETox"),1);

           next->SRMode=j_atoi(xmlnode_get_attrib(next->oJID,"S2J_SRMode"),2);
           next->SRSeparator=xmlnode_get_attrib(next->oJID,"S2J_SRSeparator");
           next->SRText=xmlnode_get_attrib(next->oJID,"S2J_SRText");
           next->OutputMode=j_atoi(xmlnode_get_attrib(next->oJID,"S2J_OutputMode"),0);
           }


        if (si->oAD!=NULL && j_atoi(xmlnode_get_attrib(si->oAD,"enabled"),0)==1)
           {
           if (smtp_ispaid(lcJID,next->oJID)==0)
              next->Advertising=1;
           }

        next = next->next;
        }
  



//STOP DD
   // unescape lcFrom
/*
   ptr = (char*)pmalloco(si->p, j_strlen(lcFrom)+1);
   fromEscape(lcFrom, (void *) ptr);
   cur = jid_new(si->p,ptr);

           tmp = pstrdup(p,si->fromEx);
           bkt = strstr(tmp,"@");
           *bkt = '%';
           loFrom = jid_new(p,jtin->met);
           jid_set(loFrom,tmp,JID_USER);
           si->jidfrom=pstrdup(si->p,jid_full(loFrom));

*/
   cur = jid_new(si->p,jtin->met);
   lcFrom=smtp_in_getaddr(si->p,lcFrom); // nahra @ znakem %
   jid_set(cur,lcFrom,JID_USER);
   xmlnode_put_attrib(loBaseMsg,"from",jid_full(cur));


   // subject can be encoded in quoted printable or base64 +code page
   // Subject: =?iso-8859-2?B?dGVzdOg=?=
   //          xxCodePage  xExdata    ?=
   // E==Q - quoted printable
   // E==B - base64

   si->cStatus=pstrdup(si->p,"Reading subject");
   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"DATA - reading subject");
   #endif

   if (smtp_in_header(si, msg, "Subject", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      subject=smtp_alltrim(spool_print(tmpsp)); 



   if (j_strlen(subject)>0) 
      {
      lii=0;
      tmpsp=spool_new(si->p);
      lcMax=subject+j_strlen(subject)-1;

      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"DATA: %s",subject); 
      #endif

      while (lii==0)
         {
         ctx.mimeEncoding = MIME_7BIT;
         ctx.mimeCharset = "us-ascii";

         #ifdef SMTP_DB
          SMTP_DEBUG(SMTP_ZONE,"DATA - subject check encode algorithm");
         #endif
         // Check codepage and encode algorithm
         if ((subjectCP=strstr(subject,"=?"))==NULL) // no encoding
            {
            PM_Reg(5070, si->p,tmpp=pool_new(),1,NULL);
            spooler(tmpsp,smtp_mime_decode(tmpp, &ctx, subject),tmpsp);
            pool_free(tmpp);
            break;
            }

         // any part of subject is coded
         // check if any string before coded part
         if (subjectCP!=subject)
            {
            *subjectCP='\0';
            PM_Reg(5072,si->p, tmpp=pool_new(),1,NULL);
            spooler(tmpsp,smtp_mime_decode(tmpp, &ctx, subject),tmpsp);
            pool_free(tmpp);
            }

         // now decode text
         ctx.mimeEncoding = MIME_8BIT;
         ctx.mimeCharset=subjectCP=subjectCP+2; // begin of code page
   
         subjectE=strstr(subjectCP,"?");
         *subjectE='\0';
         subjectE++; // begin of encode

         lcPom=strstr(subjectE,"?");
         lcPom++; // begin of subject data
         ptr=strstr(lcPom,"?="); // end of encoded data
         if (ptr==NULL)
             ptr=strstr(lcPom,"=?"); // end of encoded data

//Subject: =?us-ascii?Q?Re=3ATV=20a=20pocitac?=
//Subject: Re: Fw: =?UTF-8?B?0JjQvdGC0LXRgNGE0LXQudGBINCyINGC0YDQtdGC0YzQtdC8?=
// =?UTF-8?B?INC40LfQvNC10YDQtdC90LjQuA==?=
         if (ptr!=NULL)
             *ptr='\0';

         if (!strncasecmp(subjectE, "Q",1))
            ctx.mimeEncoding = MIME_QUOTED;
         else if (!strncasecmp(subjectE, "B",1))
            ctx.mimeEncoding = MIME_BASE64;
         else 
            ctx.mimeEncoding = MIME_7BIT;

         #ifdef SMTP_DB
          SMTP_DEBUG(SMTP_ZONE,"DATA part: %s",lcPom);
         #endif

         PM_Reg(5073,si->p, tmpp=pool_new(),1,NULL);
         spooler(tmpsp,smtp_mime_decode(tmpp, &ctx, lcPom),tmpsp);
         pool_free(tmpp);
  
         if (ptr+3>lcMax) // you are out
            break;

         subject=ptr+2;
         }
      subject=spool_print(tmpsp);
      }

   // thread-id
   si->cStatus=pstrdup(si->p,"Reading thread ID");
   si->cThreadData=NULL;
   si->iThreadData=0; // no thread
   data=NULL;

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"DATA - reading thread ID");
   #endif
   if (smtp_in_header(si, msg, "X-Jabber-Thread-id", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      {
      data=spool_print(tmpsp);
      si->iThreadData=1;
      }

   if (j_strlen(data)==0 || strcasecmp(data,"jabber-start-thread")==0)
      {
      now_unixtime = time(NULL);
      gmtime_r(&now_unixtime, &now);
      thread_data=(char*)pmalloc_x(si->p, 30,'\0');
      snprintf(thread_data, 30, "JPT_%04i%02i%02i%02i%02i%02i%i", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
      si->cThreadData=thread_data;
      }
   else
      si->cThreadData=data;


   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"DATA - message ID");
   #endif
   if (smtp_in_header(si, msg, "Message-ID", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      xmlnode_put_attrib(loBaseMsg,"id",smtp_lgstrim(spool_print(tmpsp)));


   // find first line with cc
   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"DATA - get carbon copy");
   #endif
   if (smtp_in_header(si, msg, "cc", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      {
      si->listcc =spool_print(tmpsp);
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"DATA - sending carbon copy: %s",si->listcc);
      #endif
      }

   // find first line with to
   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"DATA - get listto");
   #endif
   if (smtp_in_header(si, msg, "to", 0,tmpsp=spool_new(si->p),&liNextLine)>0)
      {
      si->listto =spool_print(tmpsp);
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"DATA - sending listto: %s",si->listto);
      #endif
      }

   // no mime, pak to zpracuj cel a odeli
   ctx.mimeUsed = 0;
   ctx.mimeEncoding = MIME_7BIT;
   ctx.mimeCharset = "us-ascii";

   // is this a message that uses MIME? 
   if (smtp_in_header(si, msg, "MIME-Version", 1,tmpsp=spool_new(si->p),&liNextLine)>0)
	  ctx.mimeUsed = 1;

   next= si->rcpt;
   if (ctx.mimeUsed == 0)
      {
      // bud dle JEP-0033 nebo samostatn
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"DATA - NONMIME mode");
      #endif
      si->x=loBaseMsg;
      PM_Reg(5074, si->p,tmpp=pool_new(),1,NULL);
      body=smtp_mime_decode(tmpp, &ctx, si->MBody);
      pool_free(tmpp);

      loSubject=xmlnode_insert_tag(loBaseMsg,"subject");
      smtp_in_SubjectReplace(si,next,subject,loSubject);
      if (j_atoi(xmlnode_get_attrib(next->oJID,"S2J_MailMode"),0)==0 || j_atoi(xmlnode_get_attrib(next->oJID,"S2J_MailMode"),0)==2)
         xmlnode_insert_cdata((loBody=xmlnode_insert_tag(loBaseMsg,"body")),body,-1);

      if (j_atoi(xmlnode_get_attrib(next->oJID,"S2J_MailMode"),0)==1)
          xmlnode_insert_cdata((loBody=xmlnode_insert_tag(loBaseMsg,"body")),msg,-1);

      if (j_atoi(xmlnode_get_attrib(next->oJID,"S2J_MailMode"),0)==2)
         {
         xmlnode_insert_cdata((loEML=xmlnode_insert_tag(loBaseMsg,"x")),msg,-1);
         xmlnode_put_attrib(loEML,"xmlns",NS_EML);
         }

      smtp_in_AddAdversiting(si,next,loBody);

      // prove odesln
      si->cStatus=pstrdup(si->p,"Deliver message");
      smtp_in_deliver_message(si,SMTP_IN_DELIVER_ALL);
      si->x=NULL;
      }

   if (ctx.mimeUsed == 1)
      {
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"DATA - MIME mode");
      #endif

      liRet=0;
      // 
      // nyn projdi vechny pjemce co pouvaj globln nastaven
      // zprvu zpracuj dle prvnho s globlnm nastavenm
      rcpt=NULL;
      for (rcpt =  si->rcpt; rcpt != NULL; rcpt = rcpt->next) 
          {
          if (rcpt->UseGlobalSettings==1 && rcpt->iSpammer==0)
             break;

          }

      if (rcpt!=NULL)
         {
         // najdi prvnho co pov
         loDerivMsg = xmlnode_dup(loBaseMsg);
         PM_Reg(5042,si->p, xmlnode_pool(loDerivMsg),1,NULL);
         si->x=loDerivMsg;

         loSubject=xmlnode_insert_tag(loDerivMsg,"subject");
         loEML=NULL;

         if (j_atoi(xmlnode_get_attrib(rcpt->oJID,"S2J_MailMode"),0)==0 || j_atoi(xmlnode_get_attrib(rcpt->oJID,"S2J_MailMode"),0)==2)
            {
            loBody=xmlnode_insert_tag(loDerivMsg,"body");
            liRet=smtp_in_ParseMailBody(si, &ctx, msg,"",rcpt);
            if (liRet==-1) // BODY FAILED
               {
               // you must read all mail body without any conversion
               xmlnode_hide(loBody);
               PM_Reg(5075, si->p,tmpp=pool_new(),1,NULL);
               xmlnode_insert_cdata((loBody=xmlnode_insert_tag(loDerivMsg,"body")),smtp_mime_decode(tmpp, &ctx, si->MBody),-1);
               pool_free(tmpp);
               }
            }

         if (j_atoi(xmlnode_get_attrib(rcpt->oJID,"S2J_MailMode"),0)==1)
            xmlnode_insert_cdata((loBody=xmlnode_insert_tag(loDerivMsg,"body")),msg,-1);

         if (j_atoi(xmlnode_get_attrib(rcpt->oJID,"S2J_MailMode"),0)==2)
            {
            xmlnode_insert_cdata((loEML=xmlnode_insert_tag(loDerivMsg,"x")),msg,-1);
            xmlnode_put_attrib(loEML,"xmlns",NS_EML);
            }


         smtp_in_AddAdversiting(si,rcpt,loBody);
         smtp_in_SubjectReplace(si,rcpt,subject,loSubject);

         // prove odesln
         si->cStatus=pstrdup(si->p,"Deliver message");
         smtp_in_deliver_message(si,SMTP_IN_DELIVER_GLOBAL);
         si->x=NULL;
         xmlnode_free(loDerivMsg);
         }

      // nyn projdi vechny pjemce co NEpouvaj globln nastaven
      // a odeli zprvu
      xmlnode_hide_attrib(si->x,"to");
      for (rcpt =  si->rcpt; rcpt != NULL; rcpt = rcpt->next) 
          {
          if (rcpt->UseGlobalSettings==1 || rcpt->iSpammer==1)
             continue;

          loDerivMsg = xmlnode_dup(loBaseMsg);
          PM_Reg(5044, si->p,xmlnode_pool(loDerivMsg),1,NULL);
          si->x=loDerivMsg;

          loSubject=xmlnode_insert_tag(loDerivMsg,"subject");

         if (j_atoi(xmlnode_get_attrib(rcpt->oJID,"S2J_MailMode"),0)==0 || j_atoi(xmlnode_get_attrib(rcpt->oJID,"S2J_MailMode"),0)==2)
             {
             loBody=xmlnode_insert_tag(loDerivMsg,"body");
             liRet=smtp_in_ParseMailBody(si, &ctx, msg,"",rcpt);
             if (liRet==-1) // BODY FAILED
                {
                // you must read all mail body without any conversion
                xmlnode_hide(loBody);
                tmpp=pool_new();
                PM_Reg(5076, si->p,tmpp,1,NULL);
                xmlnode_insert_cdata((loBody=xmlnode_insert_tag(loDerivMsg,"body")),smtp_mime_decode(tmpp, &ctx, si->MBody),-1);
                pool_free(tmpp);
                }
             }

         if (j_atoi(xmlnode_get_attrib(rcpt->oJID,"S2J_MailMode"),0)==1)
            xmlnode_insert_cdata((loBody=xmlnode_insert_tag(loDerivMsg,"body")),msg,-1);

         if (j_atoi(xmlnode_get_attrib(rcpt->oJID,"S2J_MailMode"),0)==2)
            {
            xmlnode_insert_cdata((loEML=xmlnode_insert_tag(loDerivMsg,"x")),msg,-1);
            xmlnode_put_attrib(loEML,"xmlns",NS_EML);
            }

          smtp_in_AddAdversiting(si,rcpt,loBody);
          smtp_in_SubjectReplace(si,rcpt,subject,loSubject);
          smtp_in_ThreadReplace(si,rcpt);

          #ifdef SMTP_DB
           SMTP_DEBUG(SMTP_ZONE,"DATA - sending to %s",jid_full(rcpt->rcpt));
          #endif
          xmlnode_put_attrib(loDerivMsg,"to",jid_full(rcpt->rcpt));
          si->cStatus=pstrdup(si->p,"Deliver message");
          deliver(dpacket_new(xmlnode_dup(loDerivMsg)),jtin->i);
          smtp_stats_out(loDerivMsg);

          si->x=NULL;
          xmlnode_free(loDerivMsg);
          }
      }

   xmlnode_free(loBaseMsg);

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"DATA - Increment counter");
   #endif
   jtin->Stats->SMTPProcessed++;
   jtin->Stats->_SMTPProcessed++;
   jtin->Stats->SMTPMessages--;
   jtin->Stats->_SMTPMessages--;
   smtp_StatsSave();


   // delete email from backup repository
   smtp_delete_from_backup(si);

   si->iProcessMail=2;
   smtp_reset_in(si);

   if (si->iType==SMTP_IN_EMAIL)
       pool_free(si->p);
 
   return;
   }

// ***********************************************************
// Process offline smtp message
// ***********************************************************
void smtp_in_offline_message(xmlnode loMSG, char *lcOFile)
   {
   smtpsi si;
   smptsi_rcp rcpt;
   pool p=pool_new(),tmpp=pool_new();
   char *lcMSG, *lcPom=NULL, *lcAddr, *addr, *tmp,*lcMax,*lcBFile;
   spool tmpsp;
   int liMode=1;
   long long liNextLine;
   jid id;
   xmlnode loBody,loDescr;

   PM_Reg(5020, NULL,p,1,NULL);
   PM_Reg(5080, NULL,tmpp,1,NULL);

   si=smtp_new_in(p,NULL);
   si->phase = PHASE_CMD;
   si->x = xmlnode_new_tag_pool(si->p,"message");
   si->iType=SMTP_IN_OFFLINE;

   lcPom=xmlnode_get_attrib(loMSG,"to");

   si->from=xmlnode_get_attrib(loMSG,"from");
   si->fromEx=xmlnode_get_attrib(loMSG,"fromEx");
   si->jidfrom=xmlnode_get_attrib(loMSG,"jidfrom");

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"yay, reentering offline message to %s",lcPom);
   #endif

   loBody = xmlnode_get_tag(loMSG,"data");
   smtp_si_prepare_data(si);

   if (loBody==NULL) // old version
      {
      lcMSG=xmlnode_get_data(loMSG);
      }
   else
      {
      si->oMsg=loMSG;
      tmp=xmlnode_get_data(loBody);
      lcMSG = (char*)pmalloco(tmpp, j_strlen(tmp)+1);
      fromEscape(tmp, (void *) lcMSG);
      }


   // si->rcpt must be rebuild from "to:" attribute
   // find first line with to
   if (smtp_in_header(si, lcMSG, "to", 0,tmpsp=spool_new(tmpp),&liNextLine)>0)
      si->listto =spool_print(tmpsp);


   if (j_strlen(lcPom)==0)
      {
      lcPom=si->listto;
      liMode=0;
      }

   if (j_strlen(lcPom)>0)
      {
      lcMax=lcPom+j_strlen(lcPom);
      lcAddr = strtok( lcPom,",");

      while( lcAddr != NULL  && lcPom<lcMax )
         {
         if (liMode==0) // po staru
            addr=smtp_in_getaddrex(si->p,smtp_alltrim(smtp_2ws(lcAddr)));
         else
            addr=smtp_alltrim(smtp_2ws(lcAddr));

         lcPom+=j_strlen(lcAddr)+1;
         lcAddr = strtok( lcPom,",");

         if (liMode==0) // po staru
            {
            tmp = (char*)pmalloc_x(tmpp, j_strlen(addr)+1,'\0');
            fromEscape(addr, (void *) tmp);
            id=jid_new(si->p,tmp);
            id = smtp_mx2(id);
            }
         else
            {
            id = jid_new(si->p,addr);
            }

         if (id == NULL)
            {
            continue;
            }

         if (SMTP_TestItemRoster(jid_full(id))== 0 &&
             j_atoi(xmlnode_get_tag_data(jtin->config,"smtp/registered"),0)==1)
            {
            }
         else              
            {
            rcpt = smtp_NewRecipient(si->p,id);
            rcpt->smtpaddr=pstrdup(si->p,addr);
            if (si->rcpt == NULL)
               si->rcpt=rcpt;
            else
               smtp_AppendRcpt(si->rcpt,rcpt);
            }
         }

      // add text to si structure   
      if (si->rcpt != NULL)
         {
         spool_add(si->cMessage,lcMSG);
         // save email to backup repository
         lcBFile=spools(tmpp, tempnam(jtin->smtp_backup,"tmp"),".xml",tmpp);
         rename(lcOFile,lcBFile);
         }

      pool_free(tmpp);



      if (si->rcpt != NULL)
         smtp_in_message((void*) si);


      // save email to backup repository
      if (si->rcpt == NULL && jtin->tmpBackupSMTP==1)
         {
         lcBFile=spools(si->p, tempnam(spools(si->p,jtin->smtp_backup,"/old",si->p), "tmp"),".xml",si->p);

         if ((loDescr=xmlnode_get_tag(loMSG,"description"))==NULL)
              loDescr=xmlnode_insert_tag(loMSG,"description");

         lcPom = (char*)pmalloc_x(si->p, 18,' ');
         smtp_GetDateTime((char *)lcPom);
         xmlnode_insert_cdata(loDescr,spools(si->p,lcPom," Bad recipient","\r\n",si->p),-1);
         if (xmlnode2file(lcBFile,loMSG)!=1)
            {
            log_warn("smtp","Cannot save email to %s",lcBFile);
            smtp_SendInfoToAdmin(spools(si->p,"Save email to backup repository... ",lcBFile," ...failed",si->p),SMTP_SITA_P );
            }
         }
      }
   else
      pool_free(tmpp);

   pool_free(p);
   }


// ***********************************************************
// Callback function for generating SMTP message acros jabber
// ***********************************************************

smtps smtp_in_recipient_cb(smtps so, void *lugmArg)
   {
   char *subject, *id, *tmp,*lcPom;
   time_t now_unixtime;
   struct tm now;
   char *dateheader, *smtpboundary, *smtpCT,*lcFrom;
   spool datato;
   int liLen,lii;
   xmlnode loLang,loBRs=(xmlnode) lugmArg,loBR;
   pool p=pool_new();

   PM_Reg(5090,so->p, p,1,NULL);


   lcFrom=xmlnode_get_attrib(loBRs,"from");
   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"yay, sending a bound message from %s to %s",jtin->me,lcFrom);  
   #endif

   so->from=spools(so->p,pstrdup(so->p,"MAILER-DAEMON"),"@",jtin->me,so->p);
   datato = spool_new(p);

   dateheader = (char*)pmalloc_x(p, 28,' ');
   dateheader[27] = '\0';
   smtpboundary = (char*)pmalloc_x(p, 31,' ');
   smtpboundary[30] = '\0';


   xmlnode_put_attrib(so->x,"From",spools(p,"Mail Delivery Subsystem <",so->from,">",p));

   lii=j_strlen(lcFrom);

   tmp = (char*)pmalloco(p, EQP_LENGTH(lii));
   toEscape(lcFrom, (void *) tmp,SEQ_ESCAPE);
   if (j_strlen(tmp)>lii)
      {
      lcPom = (char*)pmalloc_x(p, EQP_LENGTH(lii),' ');
      toQP(lcFrom, (void *) lcPom,0,SEQ_QP);

      spooler(datato,"\"=?utf-8?q?",lcPom,"?=\" ","<",tmp,">",datato); // simple recipient
      }
   else
      spooler(datato,"<",tmp,">",datato); // simple recipient

   so->rcpt = jid_new(so->p,lcFrom);
   so->ircpt++;


   if (datato->len>0)
      xmlnode_put_attrib(so->x,"to",spool_print(datato));


   // subject
   subject = pstrdup(so->p,"Returned mail: User unknown");
   liLen=j_strlen(subject);

   log_debug(ZONE,"encode subject");
   tmp = (char*)pmalloc_x(p, EQP_LENGTH(liLen),' ');
   toQP(subject, (void *) tmp,0,SEQ_QP);
   xmlnode_put_attrib(so->x,"Subject",spools(so->p,"=?utf-8?q?",tmp,"?=",so->p));

   xmlnode_put_attrib(so->x,"X-Mailer",spools(p,smtp_name," ",smtp_version," ","[http://gorila.netlab.cz/jabber.html]",p));
   xmlnode_put_attrib(so->x,"MIME-Version","1.0");
   xmlnode_put_attrib(so->x,"Jabber-ID",so->from);
   xmlnode_put_attrib(so->x,"X-Jabber-Bouncy","Mr. Kalousek, You are number one.");

   id = (char*)pmalloc_x(p, 18,' ');
   smtp_GetDateTime((char *)id);
   while ((lcPom = strstr(id, ":")) != NULL)
      {
      *lcPom='.';
      }

   xmlnode_put_attrib(so->x,"Message-ID",spools(p,"<",id,"@",jtin->me,">",p));

   /* create time header for message */
   now_unixtime = time(NULL);
   gmtime_r(&now_unixtime, &now);
   snprintf(dateheader, j_strlen(dateheader), "%02i %s %04i %02i:%02i:%02i +0000\0", now.tm_mday, smtp_CMonth(now.tm_mon), now.tm_year+1900, now.tm_hour, now.tm_min, now.tm_sec);
   if (dateheader[0])
 	   xmlnode_put_attrib(so->x,"Date",dateheader);


/*
   Date: Fri, 8 Jul 1994 09:21:47 -0400
   From: Mail Delivery Subsystem <MAILER-DAEMON@CS.UTK.EDU>
   Subject: Returned mail: User unknown
   To: <owner-ups-mib@CS.UTK.EDU>
   MIME-Version: 1.0
   Content-Type: multipart/report; report-type=delivery-status;
          boundary="JAA13167.773673707/CS.UTK.EDU"

   --JAA13167.773673707/CS.UTK.EDU
   content-type: text/plain; charset=us-ascii

          ----- The following addresses had delivery problems -----
   <arathib@vnet.ibm.com> (unrecoverable error)
   <wsnell@sdcc13.ucsd.edu> (unrecoverable error)

    --JAA13167.773673707/CS.UTK.EDU
   content-type: message/delivery-status

   Reporting-MTA: dns; cs.utk.edu

   Original-Recipient: rfc822;arathib@vnet.ibm.com
   Final-Recipient: rfc822;arathib@vnet.ibm.com
   Action: failed
   Status: 5.0.0 (permanent failure)
   Diagnostic-Code: smtp;  550 'arathib@vnet.IBM.COM' is not a
    registered gateway user
   Remote-MTA: dns; vnet.ibm.com

   Original-Recipient: rfc822;johnh@hpnjld.njd.hp.com
   Final-Recipient: rfc822;johnh@hpnjld.njd.hp.com
   Action: delayed
   Status: 4.0.0 (hpnjld.njd.jp.com: host name lookup failure)

   Original-Recipient: rfc822;wsnell@sdcc13.ucsd.edu
   Final-Recipient: rfc822;wsnell@sdcc13.ucsd.edu
   Action: failed
   Status: 5.0.0
   Diagnostic-Code: smtp; 550 user unknown
   Remote-MTA: dns; sdcc13.ucsd.edu

   --JAA13167.773673707/CS.UTK.EDU
   content-type: message/rfc822

    [original message goes here]

   --JAA13167.773673707/CS.UTK.EDU--

*/

   snprintf(smtpboundary, j_strlen(smtpboundary), "JPB_%04i%02i%02i%02i%02i%02i%i\0", now.tm_year+1900, now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec, rand());
   smtpCT=spools(p,"multipart/report; report-type=delivery-status; boundary=\"",smtpboundary , "\"",p );
   xmlnode_put_attrib(so->x,"Content-type",smtpCT);


   xmlnode_insert_cdata(so->x,"--",-1);
   xmlnode_insert_cdata(so->x,smtpboundary,-1);
   xmlnode_insert_cdata(so->x,"\r\n",-1);

   xmlnode_insert_cdata(so->x,"Content-Type: text/plain; charset=UTF-8\r\n",-1);
   xmlnode_insert_cdata(so->x,"Content-Transfer-Encoding: 8bit\r\n",-1);
   xmlnode_insert_cdata(so->x,"\r\n",-1);

   // put header
   for (loLang = xmlnode_get_tag(jtin->resources,"strings/lang"); loLang != NULL; loLang = xmlnode_get_nextsibling(loLang))
       {
       if (loLang->type!=NTYPE_TAG)
          continue;

       xmlnode_insert_cdata(so->x,smtp_rc_GetString(p,xmlnode_get_attrib(loLang,"xml:lang"),SMTP_CB_MESSAGE_HEADER),-1);
       xmlnode_insert_cdata(so->x,"\r\n",-1);
       }

   for (loBR = xmlnode_get_firstchild(loBRs); loBR != NULL; loBR = xmlnode_get_nextsibling(loBR))
       {
       if (loBR->type!=NTYPE_TAG)
	      continue;

       xmlnode_insert_cdata(so->x,xmlnode_get_attrib(loBR,"smtpaddr"),-1);
       xmlnode_insert_cdata(so->x," (unrecoverable error)\r\n",-1);
       }

   xmlnode_insert_cdata(so->x,"\r\n",-1); // end of boundary

   // next boundary
   xmlnode_insert_cdata(so->x,"\r\n--",-1);
   xmlnode_insert_cdata(so->x,smtpboundary,-1);
   xmlnode_insert_cdata(so->x,"\r\n",-1);
   xmlnode_insert_cdata(so->x,"content-type: message/delivery-status\r\n",-1);
   xmlnode_insert_cdata(so->x,"\r\nReporting-MTA: dns;",-1);
   xmlnode_insert_cdata(so->x,jtin->me,-1);
   xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);

   xmlnode_insert_cdata(so->x,xmlnode_get_attrib(loBR,"smtpaddr"),-1);

   for (loBR = xmlnode_get_firstchild(loBRs); loBR != NULL; loBR = xmlnode_get_nextsibling(loBR))
       {
       if (loBR->type!=NTYPE_TAG)
	       continue;

       xmlnode_insert_cdata(so->x,"Original-Recipient: rfc822;",-1);
       xmlnode_insert_cdata(so->x,xmlnode_get_attrib(loBR,"smtpaddr"),-1);
       xmlnode_insert_cdata(so->x,"\r\n",-1);

       xmlnode_insert_cdata(so->x,"Final-Recipient: rfc822;",-1);
       xmlnode_insert_cdata(so->x,xmlnode_get_attrib(loBR,"smtpaddr"),-1);
       xmlnode_insert_cdata(so->x,"\r\n",-1);

       xmlnode_insert_cdata(so->x,"Action: failed\r\n",-1);
       xmlnode_insert_cdata(so->x,"Status: 5.0.0 (permanent failure)\r\n",-1);

       xmlnode_insert_cdata(so->x,"Diagnostic-Code: smtp; ",-1);
       xmlnode_insert_cdata(so->x,xmlnode_get_attrib(loBR,"iErr"),-1);
       xmlnode_insert_cdata(so->x," '",-1);
       xmlnode_insert_cdata(so->x,xmlnode_get_attrib(loBR,"smtpaddr"),-1);
       xmlnode_insert_cdata(so->x,"' ",-1);
       lii=j_atoi(xmlnode_get_attrib(loBR,"iErr"),0);
       switch (lii)
         {
         case 553:
              xmlnode_insert_cdata(so->x,"Mailbox is not registered for receiving\r\n",-1);
              break;

  	     case 450:
              xmlnode_insert_cdata(so->x,"Mailbox don't receive e-mail\r\n",-1);
              break;

         case 550:
              xmlnode_insert_cdata(so->x,"Mailbox unavailable\r\n",-1);
              break;

  	     default:
              xmlnode_insert_cdata(so->x,"Unknown error\r\n",-1);
              break;

         }

       xmlnode_insert_cdata(so->x,"Remote-MTA: dns; ",-1);
       xmlnode_insert_cdata(so->x,jtin->me,-1);
       xmlnode_insert_cdata(so->x,"\r\n",-1);
       xmlnode_insert_cdata(so->x,"\r\n",-1);
       }

/*
 

   
   Original-Recipient: rfc822;arathib@vnet.ibm.com
   Final-Recipient: rfc822;arathib@vnet.ibm.com
   Action: failed
   Status: 5.0.0 (permanent failure)
   Diagnostic-Code: smtp;  550 'arathib@vnet.IBM.COM' is not a
    registered gateway user
   Remote-MTA: dns; vnet.ibm.com

   Original-Recipient: rfc822;johnh@hpnjld.njd.hp.com
   Final-Recipient: rfc822;johnh@hpnjld.njd.hp.com
   Action: delayed
   Status: 4.0.0 (hpnjld.njd.jp.com: host name lookup failure)

   Original-Recipient: rfc822;wsnell@sdcc13.ucsd.edu
   Final-Recipient: rfc822;wsnell@sdcc13.ucsd.edu
   Action: failed
   Status: 5.0.0
   Diagnostic-Code: smtp; 550 user unknown
   Remote-MTA: dns; sdcc13.ucsd.edu


*/
   xmlnode_insert_cdata(so->x,"\r\n",-1); // end of boundary

      // next boundary, orig. message
   xmlnode_insert_cdata(so->x,"\r\n--",-1);
   xmlnode_insert_cdata(so->x,smtpboundary,-1);
   xmlnode_insert_cdata(so->x,"\r\n",-1);
   xmlnode_insert_cdata(so->x,"content-type: message/rfc822\r\n\r\n",-1);

//   xmlnode_insert_cdata(so->x,so->MBody,-1);

   xmlnode_insert_cdata(so->x,"\r\n\r\n",-1);
   xmlnode_insert_cdata(so->x,"--",-1);
   xmlnode_insert_cdata(so->x,smtpboundary,-1);
   xmlnode_insert_cdata(so->x,"--\r\n\r\n",-1);

   xmlnode_free(loBRs);
   pool_free(p);
   return so;
   }


// ***********************************************
// Failed callback function
// ***********************************************

smtps smtp_in_recipient_cbf(smtps so, void *lugmArg)
   {
   xmlnode loBRs=(xmlnode) lugmArg;
   xmlnode_free(loBRs);
   return so;
   }


// ***********************************************
// Reply to smtp, general
// ***********************************************
smtps smtp_in_replytosmtp_cb(smtps so, void *lugmArg)
   {
   char *subject, *id, *tmp,*lcPom;
   time_t now_unixtime;
   struct tm now;
   char *dateheader,*lcTo;
   spool datato;
   int liLen,lii;
   xmlnode loMail=(xmlnode) lugmArg;

   lcTo=xmlnode_get_attrib(loMail,"to");
   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"yay, sending a offline message from %s to %s",jtin->me,so->from);
   #endif

   so->from=pstrdup(so->p,xmlnode_get_attrib(loMail,"to"));
   datato = spool_new(so->p);

   dateheader = (char*)pmalloc_x(so->p, 28,' ');
   dateheader[27] = '\0';

   xmlnode_put_attrib(so->x,"From",spools(so->p,"Mail Delivery Subsystem <",so->from,">",so->p));

   lii=j_strlen(lcTo);

   tmp = (char*)pmalloco(so->p, EQP_LENGTH(lii));
   toEscape(lcTo, (void *) tmp,SEQ_ESCAPE);
   if (j_strlen(tmp)>lii)
      {
      lcPom = (char*)pmalloc_x(so->p, EQP_LENGTH(lii),' ');
      toQP(lcTo, (void *) lcPom,0,SEQ_QP);

      spooler(datato,"\"=?utf-8?q?",lcPom,"?=\" ","<",tmp,">",datato); // simple recipient
      }
   else
      spooler(datato,"<",tmp,">",datato); // simple recipient

   so->rcpt = jid_new(so->p,lcTo);
   so->ircpt++;


   if (datato->len>0)
      xmlnode_put_attrib(so->x,"to",spool_print(datato));


   // subject
   subject = pstrdup(so->p,xmlnode_get_tag_data(loMail,"subject"));
   liLen=j_strlen(subject);

   tmp = (char*)pmalloc_x(so->p, EQP_LENGTH(liLen),' ');
   toQP(subject, (void *) tmp,0,SEQ_QP);
   xmlnode_put_attrib(so->x,"Subject",spools(so->p,"=?utf-8?q?",tmp,"?=",so->p));

   xmlnode_put_attrib(so->x,"X-Mailer",spools(so->p,smtp_name," ",smtp_version," ","[http://gorila.netlab.cz/jabber.html]",so->p));
   xmlnode_put_attrib(so->x,"MIME-Version","1.0");
   xmlnode_put_attrib(so->x,"Jabber-ID",so->from);
   xmlnode_put_attrib(so->x,"X-Jabber-Bouncy","DATA size pass maxsize.");

   id = (char*)pmalloc_x(so->p, 18,' ');
   smtp_GetDateTime((char *)id);
   while ((lcPom = strstr(id, ":")) != NULL)
      {
      *lcPom='.';
      }

   xmlnode_put_attrib(so->x,"Message-ID",spools(so->p,"<",id,"@",jtin->me,">",so->p));

   /* create time header for message */
   now_unixtime = time(NULL);
   gmtime_r(&now_unixtime, &now);
   snprintf(dateheader, j_strlen(dateheader), "%02i %s %04i %02i:%02i:%02i +0000\0", now.tm_mday, smtp_CMonth(now.tm_mon), now.tm_year+1900, now.tm_hour, now.tm_min, now.tm_sec);
   if (dateheader[0])
 	   xmlnode_put_attrib(so->x,"Date",dateheader);

   xmlnode_put_attrib(so->x,"Content-Type","text/plain; charset=UTF-8");
   xmlnode_put_attrib(so->x,"Content-Transfer-Encoding","8bit");
   xmlnode_put_attrib(so->x,"Content-Description","Jabber message - text format");
   xmlnode_insert_cdata(so->x,xmlnode_get_tag_data(loMail,"body"),-1);

   xmlnode_free(loMail);
   return so;
   }

// ***********************************************
// Reply to smtp, general, callback
// ***********************************************
smtps smtp_in_replytosmtp_cbf(smtps so, void *lugmArg)
   {
   xmlnode loMail=(xmlnode) lugmArg;
   xmlnode_free(loMail);
   return so;
   }


// ***********************************************
// SMTP part, getting email
// ***********************************************

// send an outgoing line to the connection 
void smtp_in_status(smtpsi si, int liStatus, char *data)
   {
   char *lcOut,*istr;
   pool p;

   p = pool_new();
   PM_Reg(5012,si->p, p,1,NULL);
   istr= (char *) pmalloc_x(p,18,' ');
   sprintf(istr,"%d ",liStatus);

   lcOut = spools(p,istr,data,"\r\n",p);
   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"SMTP-OUT: %s",lcOut);
   #endif
   mio_write(si->m,NULL,lcOut,-1);
   pool_free(p);
   }



/* decode the incoming commands */
void smtp_in_cmd(smtpsi si, int liCmd, char *lcParam)
   {
   jid id=NULL,loFrom;
   smptsi_rcp rcpt;
   char *bkt,*tmp,*lcJID=NULL,*lcFrom,*lcSep,*lcNextP=NULL,*lcXXX;
   xmlnode loJID=NULL;
   smtp_cjid loItem;
   spool rcpts;
   int liUseGlobalSettings,liS2J_AllAreSPAM,liFail=0,liSpamer=0,liFound,liForwarde=0,liType=0;
   pool p;

   p=pool_new();
   PM_Reg(5100,si->p, p,1,NULL);

/*
   // we only accept 7 bit characters in SMTP commands 
   for (bkt = addr; bkt && *bkt; bkt++)
	   if (*bkt > 126 || *bkt < 32)
	      *bkt = ' ';
*/

   if (lcParam != NULL)
      {
      lcNextP = strstr(lcParam+1, " ");
      if (lcNextP != NULL)
         {
         *lcNextP = '\0';
         lcNextP++;
         }     
      }

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"command %d with data %s %s",liCmd,lcParam,lcNextP);
   #endif

   switch(liCmd)
      {
      case CMD_HELO:
           smtp_in_status(si, SMTP_CODE_250, "Hi.");
           break;

      case CMD_EHLO:
           smtp_in_status(si, SMTP_CODE_250, "Hi.");
           smtp_in_status(si, SMTP_CODE_250, "8BITMIME");
           smtp_in_status(si, SMTP_CODE_250, "SIZE 100000");
           break;

      case CMD_MAIL:
           // get next arguments from addr
           //MAIL FROM: <jindra@egservis.cz> SIZE=500000

           si->from=pstrdup(si->p,smtp_in_getaddrex(p,lcParam)); // get clear smtp address

           lcFrom = (char*)pmalloco(p, j_strlen(si->from)+1);
           fromEscape(si->from, (void *) lcFrom);
           si->fromEx=pstrdup(si->p,lcFrom);

           tmp = pstrdup(p,si->fromEx);
           bkt = strstr(tmp,"@");
           *bkt = '%';
           loFrom = jid_new(p,jtin->met);
           jid_set(loFrom,tmp,JID_USER);
           si->jidfrom=pstrdup(si->p,jid_full(loFrom));

           if (lcNextP != NULL && (lcSep = strstr(lcNextP, "SIZE="))!=NULL) // next parameter? check SIZE=
              {  
              tmp = strstr(lcSep, " ");
              if (tmp!=NULL) *lcNextP = '\0';

              // lcSep is pointer to SIZE=
              lcSep+=5; // move pointer to value
              si->iSizeMF=j_atoi(lcSep,0);
              }

           smtp_in_status(si, SMTP_CODE_250, "Ok");
           smtp_StatsSave();
           break;

      case CMD_RCPT:
           // S:2005-08-31 gorila@dione.zcu.cz
           // Alltrim(), remove spaces from left and right sides

           lcXXX = (char*)pmalloc_x(p, 1024,'\0');

           si->cStatus=pstrdup(si->p,"Read RECIPIENT");

           bkt = strstr(lcParam,"<");
           if (bkt != NULL) lcParam = bkt + 1;
           bkt = strstr(lcParam,">");
           if(bkt != NULL) *bkt = '\0';

           lcParam=smtp_alltrim(lcParam);
           lcParam=smtp_in_getaddrex(p,lcParam); // get clear smtp address
           if (lcParam)
              {
              tmp = (char*)pmalloco(p, j_strlen(lcParam)+1);
              fromEscape(lcParam, (void *) tmp);
              id = smtp_mx2(jid_new(si->p,tmp));
              }

           // Get roster item about recipient
           if (id != NULL)
              {
              lcJID=jid_full(id);
              loJID=SMTP_PieceSettings(lcJID , si->jidfrom, &liType); // nati nastaven
              }

           // check size of mail
           if (si->iSizeMF>jtin->iMaxSize)
              {
              smtp_in_status(si,SMTP_CODE_552,spools(p,"Channel size limit exceeded: ",lcParam,p));
              if (id!=NULL)
                 {
                 snprintf(lcXXX, 1024, smtp_rc_GetString(p,xmlnode_get_attrib(loJID,"lang"),SMTP_RC_ID_2250),jtin->iMaxSize,si->iSizeMF,si->fromEx,'\0');
                 smtp_SendInfoToAny(NULL,lcJID, lcXXX ,j_atoi(xmlnode_get_attrib(loJID,"SendSystemMessage"),SMTP_SITA_P),NULL);
                 }
              break;
              }

           rcpt = smtp_NewRecipient(si->p,id);
           rcpt->smtpaddr=pstrdup(si->p,smtp_alltrim(lcParam)); // original smtp address
           rcpt->oJID=loJID;
 
           lcFrom = si->fromEx;

           // check for spammer list; liSpamer=0 no spammer; liSpamer=1 Yes Spammer
           liFail=-1; // Any bug
           if (jtin->Spamer_Open==1)
              liSpamer=0;
           else
              liSpamer=smtp_check_list(lcFrom,xmlnode_get_tag(jtin->config,"smtp/spamer/item"),&liFound);

           // check for acount spammer list
           if (liSpamer!=1 && loJID!=NULL)
              liSpamer=smtp_check_list(lcFrom,xmlnode_get_tag(loJID,"graylist/item"),&liFound);

           // E:2005-08-31 gorila@dione.zcu.cz
           if (liSpamer!=1 && id != NULL)
              {
              if (loJID== NULL &&
                  j_atoi(xmlnode_get_tag_data(jtin->config,"smtp/registered"),0)==1)
                 {
                 smtp_StatsSave();
                 log_warn("smtp","%i - Bad Address - must be register",SMTP_CODE_553);
                 liFail=553;
                 if (xmlnode_get_tag(jtin->config,"smtp/forwarde/item=553")!=NULL)
                    liForwarde=1;
                 }
              else              
                 {
                 liUseGlobalSettings=1;
                 liS2J_AllAreSPAM=j_atoi(xmlnode_get_attrib(xmlnode_get_tag(jtin->config,"smtp/defaultaccount"),"S2J_AllAreSPAM"),0);
                 if (loJID!=NULL)
                    liUseGlobalSettings=j_atoi(xmlnode_get_attrib(loJID,"UseGlobalSettings"),1);

                 if (loJID!=NULL && liUseGlobalSettings==0)
                    liS2J_AllAreSPAM=j_atoi(xmlnode_get_attrib(loJID,"S2J_AllAreSPAM"),0);

// testy na bouncy... rozdli na dv sti
// pokud je bouncy povolen, pak slo, jinak nastavit -1
                 if (liS2J_AllAreSPAM==1) // All is spam
                    {
                    liFail=450;
                    if (xmlnode_get_tag(jtin->config,"smtp/forwarde/item=450")!=NULL)
                       liForwarde=1;
                    }
                 else if (liS2J_AllAreSPAM==2) // the sender is not in contact list (roster)
                    {
                    // nem seznam kontakt... pry
                    if ((loItem=smtp_cjidGet(lcJID))==NULL)
                       {
                       liFail=450;
                       if (xmlnode_get_tag(jtin->config,"smtp/forwarde/item=450")!=NULL) // find item in list
                          liForwarde=1;
                       }
                         
                    else if (xmlnode_get_tag(loItem->item,spools(p,"to=",smtp_in_getaddr(p,lcFrom),"@",jtin->met,p))==NULL)
                            {
                            liFail=450;
                            if (xmlnode_get_tag(jtin->config,"smtp/forwarde/item=450")!=NULL) // find contact item in list
                               liForwarde=1;
                            }
                    else
                       liFail=0;
                    }
                 else
                    liFail=0;

                 }
              }
           else
              { // spammer send message
              snprintf(lcXXX, 1024, smtp_rc_GetString(p,xmlnode_get_attrib(loJID,"lang"),SMTP_RC_ID_2260),si->fromEx);
              smtp_SendInfoToAny(NULL,lcJID, lcXXX ,j_atoi(xmlnode_get_attrib(loJID,"SendSystemMessage"),SMTP_SITA_P),NULL);
              }


           rcpt->iSpammer=liSpamer;

           if (liSpamer!=1 && id == NULL)
              {
              smtp_StatsSave();
              log_warn("smtp","%i - Bad Address",SMTP_CODE_550);
              liFail=550;
              if (xmlnode_get_tag(jtin->config,"smtp/forwarde/item=550")!=NULL)
                 liForwarde=1;
              }

           if (liFail>0)
              {
              rcpt->iErr=liFail;
              rcpt->iForwarde=liForwarde;

              if (si->rcptFD == NULL)
                 si->rcptFD=rcpt;
              else
                 smtp_AppendRcpt(si->rcptFD,rcpt);

              if ((rcpt=si->rcptFD)->_iForwarde==0 && liForwarde==1) // get root of list
                   rcpt->_iForwarde=1;

              }

           if (liFail==0 || liSpamer==1) // if recipent OK or sender is spammer
              {
              if (si->rcpt == NULL)
                 si->rcpt= rcpt;
              else
                 smtp_AppendRcpt( si->rcpt,rcpt);
              }

           if (si->rcpt && (rcpt=si->rcpt)->_iSpammer==0 && liSpamer==1) // get root of list 
                rcpt->_iSpammer=1;

           smtp_SetGSpammerRcpt( si->rcpt);

           smtp_in_status(si, SMTP_CODE_250, "Ok");
           break;

      case CMD_DATA:
           si->phase = PHASE_DATA;
           si->cStatus=pstrdup(si->p,"Reading DATA");
           smtp_in_status(si, SMTP_CODE_354, "Feed me");
           break;


      case CMD_RSET:           
           smtp_reset_in(si);
           si->cStatus=pstrdup(si->p,"RESET");
           smtp_si_prepare_data(si);
           smtp_in_status(si, SMTP_CODE_250, "Boring");
           break;

      case CMD_NOOP:
           smtp_in_status(si, SMTP_CODE_250, "Boring");
           break;
 
      case CMD_QUIT:
           smtp_in_status(si, SMTP_CODE_221, "Bye");
           if (si->iProcessMail==1)  // process email, DOT detected
              {
              si->Body = spool_print_pool(si->p,si->cMessage);
              PM_SetItemTmpEx(5000,si->p,si->pMessage,1);
              pool_free(si->pMessage);
              si->pMessage=NULL;

              // v tuto chvli by mlo dojt k uloen do backup sloky
              if (si->iFastProcessing==0) // nen rychl zpracovn
                 smtp_save_to_backup(si);

              // Run as thread
              si->q=mtq_new(si->p);
              mtq_send(si->q, si->p, smtp_in_message, (void *)si);
              }

           if (si->iProcessMail==0)  // email will not processed, DOT not detected
              {
              si->iProcessMail=99; // block status
              jtin->Stats->SMTPNoProcess++;
              jtin->Stats->_SMTPNoProcess++;
              jtin->Stats->SMTPMessages--;
              jtin->Stats->_SMTPMessages--;
              smtp_StatsSave();

              rcpts=spool_new(si->p);
              smtp_list_to_spool(rcpts,si->rcptFD);
              smtp_list_to_spool(rcpts,si->rcpt);

              log_warn("smtp","A message are not processed. Host send QUIT.");
              smtp_SendInfoToAdmin(spools(p,"A message are hangup. Host send QUIT. from: ", si->fromEx," recipients: ",spool_print(rcpts) ,p),SMTP_SITA_M);

              smtp_reset_in(si);
              PM_SetItemTmp(si->p,1);
              pool_free(si->p);
              }


           break;

  	  default:
           smtp_in_status(si, SMTP_CODE_500, "Duh");
      }

   pool_free(p);
   }

int smtp_cmd_parse(char *lcCmd)
   {
   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE, "parsing command %s", lcCmd);
   #endif

   if(strcasecmp(lcCmd,"HELO") == 0) return CMD_HELO;
   if(strcasecmp(lcCmd,"MAIL") == 0) return CMD_MAIL;
   if(strcasecmp(lcCmd,"RCPT") == 0) return CMD_RCPT;
   if(strcasecmp(lcCmd,"DATA") == 0) return CMD_DATA;
   if(strcasecmp(lcCmd,"NOOP") == 0) return CMD_NOOP;
   if(strcasecmp(lcCmd,"RSET") == 0) return CMD_RSET;
   if(strcasecmp(lcCmd,"QUIT") == 0) return CMD_QUIT;
   if(strcasecmp(lcCmd,"EHLO") == 0) return CMD_EHLO;
   if(j_strlen(lcCmd) == 0) return CMD_NONE;

   return CMD_UNKNOWN;
   }


// S:2005-06-03 gorila@dione.zcu.cz
// Return command separator
char *smtp_cmd_sep(int liCmd)
   {
   if(liCmd == CMD_HELO) return " ";
   if(liCmd == CMD_EHLO) return " ";
   if(liCmd == CMD_MAIL) return ":";
   if(liCmd == CMD_RCPT) return ":";
   if(liCmd == CMD_DATA) return " ";
   if(liCmd == CMD_NOOP) return " ";
   if(liCmd == CMD_RSET) return " ";
   if(liCmd == CMD_QUIT) return " ";

   return " ";
   }
// E:2005-06-03 gorila@dione.zcu.cz



/* when the connection dies, clean up the mess */
void smtp_in_cleanup(void *arg)
   {
//   smtpsi si = (smtpsi)(arg);
   }

int smtp_in_read_proccessbuffer(smtpsi si, char *lcBuffer, int bufsz)
   {
   char *cbuffer=lcBuffer, *cur_, *args,*lcEnd;
   int i=0, cmd,liDelta;

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"DATA: (%i) %s",bufsz,lcBuffer);
   #endif

   lcEnd=lcBuffer+bufsz-1;
   for (i = 1; i < bufsz; i++)
       {
//       #ifdef SMTP_DB
//        SMTP_DEBUG(SMTP_ZONE,"ROW-CHAR: (%i): %c",i,cbuffer[i]);
//       #endif
       if (cbuffer[i-1] == '\r')
          {
          cbuffer[i-1] = '\0';
          liDelta=0;
          if (cbuffer[i] == '\n')
              {
              liDelta=1;
              cbuffer[i] = '\0';
              }

//          #ifdef SMTP_DB
//           SMTP_DEBUG(SMTP_ZONE,"ROW: phase %d data (%i): %s",si->phase,si,lcBuffer);
//          #endif

          if (si->phase == PHASE_CMD && j_strlen(lcBuffer) > 0)
             {
             // S:2005-06-03 gorila@dione.zcu.cz
             // Better command detection

             cur_=lcBuffer;
             // find "end" of command
             args = strstr(lcBuffer, " ");
             if(args != NULL) *args = '\0';
                
             // Get ID Command
             cmd=smtp_cmd_parse(lcBuffer);
             if(args != NULL) *args = ' ';

             if (cmd==CMD_UNKNOWN)
                {
                jtin->Stats->SMTPCommandUnknown++;
                jtin->Stats->_SMTPCommandUnknown++;
                smtp_StatsSave();
                log_warn("smtp","SMTP unknown command - %s (%i)",lcBuffer,si);
                }

             lcBuffer=cur_;

             // Find argument
             args = strstr(lcBuffer, smtp_cmd_sep(cmd));
             if (args != NULL)
                {
                *args = '\0';
                ++args;
                }
             
             // Process command
             smtp_in_cmd(si, cmd, args);
             // E:2005-06-03 gorila@dione.zcu.cz
             *lcBuffer='\0';
             }
          else
             {
             // detekce konce dat
             #ifdef SMTP_DB
              SMTP_DEBUG(SMTP_ZONE,"ROW (%i) %c %s",j_strlen(lcBuffer),*lcBuffer,lcBuffer);
             #endif
             if (si->phase == PHASE_DATA && si->iEnd==0 && j_strlen(lcBuffer) == 0) // ENTER
                si->iEnd=1;
             else
                {
                if (si->phase == PHASE_DATA && si->iEnd==1 && *lcBuffer == '.') // DOT
                   {
                   if (lcEnd-lcBuffer==(liDelta==0?1:2))
                      {
                      si->iType=SMTP_IN_EMAIL;
                      si->iProcessMail=1;
                      smtp_in_status(si,SMTP_CODE_250,"Message Accepted");

                      si->phase = PHASE_CMD;
                      }
                   else
                      {
                      si->iEnd=0;
                      }
                   }
                }

             if (si->phase == PHASE_DATA && (si->iFastProcessing==0 || (si->iDCRLF==0 && si->iFastProcessing==1)))
                {
                spooler(si->cMessage, lcBuffer, "\r\n", si->cMessage);
                }
             }
          lcBuffer = cbuffer + i + liDelta;
          }
       }

   if (j_strlen(lcBuffer)>0)
      {
      // if mail je vt jak maxsize, then save ony last 1024 B
      if (j_strlen(lcBuffer)>jtin->iFastProcessingBufferSize && si->iFastProcessing==1)
         si->buffer = strdup(lcBuffer + (j_strlen(lcBuffer)-jtin->iFastProcessingBufferSize)); /* save the tail from above, if any */
      else
         si->buffer = strdup(lcBuffer); /* save the tail from above, if any */

      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"phase %d data- %i (buffer overflow) (%i)",si->phase,j_strlen(si->buffer),si);
      #endif
      }
   return 0;
   }



/* read an incoming line from the connection */
void smtp_in_read(mio m, int state, void *arg, char *buffer,int bufsz)
   {
   char *cbuffer, *cur;
   smtpsi si;
   int i=0, liReAlloc=0;
   pool px;

// if (j_atoi(xmlnode_get_attrib(xmlnode_get_tag(jtin->configr,"smtp"),"state"),0)==0)


   if (state==MIO_NEW || (state==MIO_BUFFER && (smtpsi)(arg)==NULL) )
      {
      i=1;
      si=smtp_new_in(pool_new(),m);
      si->phase = PHASE_CMD;
      si->host = mio_ip(m);
      jtin->Stats->SMTPMessages++;
      jtin->Stats->_SMTPMessages++;
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"new connection from %s (%i))",si->host, si);
      #endif
      smtp_in_status(si,SMTP_CODE_220,"Jabber SMTP Transport");
      pool_cleanup(mio_pool(m), smtp_in_cleanup, (void *)si);
      PM_Reg(5000,NULL,si->p,0,(void*) si);
      smtp_si_prepare_data(si);
      si->cStatus=spools(si->p,"New SMTP connection from ",si->host,si->p);
      si->iTimerS=si->iTimerN = time(NULL); /* so we don't timeout */

      mio_reset(m, smtp_in_read, (void *)si);

      if (state==MIO_NEW)
         return;
      }


   if (state==MIO_CLOSED)
      {
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"End connection from %s)",mio_ip(m));
      #endif
      return;
      }

   if (state!=MIO_BUFFER)
      return;


   si->iTimerN = time(NULL);

   if (bufsz <= 0) return;

   // state!=MIO_BUFFER
   if (i==0)
      si=(smtpsi)(arg);

   if (si->phase == PHASE_DATA)
      {
      si->iSize+=bufsz;
      if (si->iSize>jtin->iMaxSize && jtin->iMaxSize>0 && si->iFastProcessing==0)
         si->iFastProcessing=1;

      if (si->rcpt==NULL && si->iFastProcessing==0)
         si->iFastProcessing=1;

      if (si->rcpt!=NULL && (si->rcpt)->_iGSpammer==1 && si->iFastProcessing==0)
         si->iFastProcessing=1;

      }

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"(%p) phase: %d FP:%i data: %i %s",si,si->phase,si->iFastProcessing,bufsz,buffer);
   #endif

   // prove detekci CRLF+CRLF
   if (si->iDCRLF==0)
      {
      px=pool_new();
      PM_Reg(5000,si->p,px,1,(void*)NULL);
      cur=spool_print_pool(px,si->cMessage);
      if (si->cMessage->len>0 && strstr(cur, "\r\n\r\n"))
         si->iDCRLF=1;
      pool_free(px);
      }

   // S:2005-06-02 gorila@dione.zcu.cz
   // Convert \0 to space
   for(i = 0; i < bufsz; i++)
      {
      if (buffer[i] == '\0') buffer[i]=' ';
	  }
   // E:2005-06-02 gorila@dione.zcu.cz

   if (j_strlen(si->buffer)>0)
      { /* old data yet, combine and use that */
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"********************* OLD BUFFER %i (%i):%s",strlen(si->buffer),si,si->buffer);
      #endif
      cur = (char *)malloc(strlen(si->buffer) + bufsz + 1);
      *cur = '\0';
      strcat(cur,si->buffer);
      strcat(cur,buffer);
      free(si->buffer);
      si->buffer=NULL;
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"********************* OLD BUFFER DATA %s",si->buffer);
      #endif
      bufsz = strlen(cur);
      liReAlloc=1;
      cbuffer=cur;
      }
   else
      cur = cbuffer = (char *)buffer;


   smtp_in_read_proccessbuffer(si,cur,bufsz);

   if (liReAlloc==1 && bufsz>0)
      {
      #ifdef SMTP_DB
       SMTP_DEBUG(SMTP_ZONE,"****************** dealloc old buffer (%i): %s",si,cbuffer);
      #endif
      free(cbuffer);
      }


   }


// find email which has timeout 
result smtp_in_daemon(void *arg)
   {
   PMI_struc loGroupP,loItemP,loItem;
   smtpsi si;
   int liEnd=0,liLen;
   time_t iTimeC=time(NULL);
   spool rcpts;
   char *lcBuffer;

   #ifdef SMTP_DB
    SMTP_DEBUG(SMTP_ZONE,"TEST E-MAIL TIMEOUT ");
   #endif

   loGroupP=PM_GetGroup(5000); // get group from list (all receiving smtp messages)
   loItemP=loGroupP->child;
   while(loItemP != NULL)
        {
        loItem=loItemP;

        if (loItemP->next != NULL)
           loItemP = loItemP->next;
        else
           liEnd=1;

        si= (smtpsi) loItem->data;
        if (iTimeC>=si->iTimerN+jtin->timeout && si->iProcessMail==0)
           {
           #ifdef SMTP_DB
            SMTP_DEBUG(SMTP_ZONE,"E-MAIL TIMEOUT %i",iTimeC-si->iTimerN);
           #endif
            
           if (si->iDOTAdd==0) // don't DOT on End
              {
              si->iDOTAdd=1;
              si->iProcessMail=1;
              liLen=j_strlen(si->buffer);
              si->iTimerN=iTimeC;
              lcBuffer = (char *)malloc(liLen + 6);
              if (liLen>0)
                 {
                 #ifdef SMTP_DB
                  SMTP_DEBUG(SMTP_ZONE,"E-MAIL TIMEOUT - %i %s",liLen,si->buffer);
                 #endif

                 lcBuffer = (char *)malloc(liLen + 6);
                 *lcBuffer='\0';
                 strcpy(lcBuffer,si->buffer);
                 lcBuffer[liLen]='\r';
                 lcBuffer[liLen+1]='\n';
                 lcBuffer[liLen+2]='.';
                 lcBuffer[liLen+3]='\r';
                 lcBuffer[liLen+4]='\n';
                 lcBuffer[liLen+5]='\0';

                 free(si->buffer); 
                 si->buffer=NULL;
                 }
              else
                 {
                 lcBuffer[0]='\r';
                 lcBuffer[1]='\n';
                 lcBuffer[2]='.';
                 lcBuffer[3]='\r';
                 lcBuffer[4]='\n';
                 lcBuffer[5]='\0';
                 }

              smtp_in_read_proccessbuffer(si, lcBuffer, liLen+5);
              free(lcBuffer); 
              }
           else
              {
              si->iProcessMail=-1;
              jtin->Stats->SMTPNoProcess++;
              jtin->Stats->_SMTPNoProcess++;
              jtin->Stats->SMTPMessages--;
              jtin->Stats->_SMTPMessages--;
              smtp_StatsSave();


              rcpts=spool_new(si->p);
              smtp_list_to_spool(rcpts,si->rcptFD);
              smtp_list_to_spool(rcpts,si->rcpt);

              log_warn("smtp","A message are hangup. Daemon quit MIO.");
              smtp_SendInfoToAdmin(spools(si->p,"A message are hangup. Daemon quit MIO. from: ", si->fromEx," recipients: ",spool_print(rcpts) ,si->p),SMTP_SITA_M);

              smtp_reset_in(si);
              mio_close(si->m);

              PM_SetItemTmp(si->p,1);
              pool_free(si->p);
              }
           }

        if (liEnd==1)
           break;
        }

   return r_DONE;
   }

/*
nezmar:/var/qmail/queue/mess/18# cat 3097888
Received: (qmail 28684 invoked from network); 9 Sep 2007 08:11:48 -0000
Received: from unknown (HELO viktor.humboldtec.cz) (84.244.82.132)
  by nezmar.netlab.cz with SMTP; 9 Sep 2007 08:11:48 -0000
Received: (qmail 4724 invoked from network); 9 Sep 2007 07:444 -0000
Received: from unknown (HELO spamb.bright.net) (209.143.0.184)
  by 132-82-244-84.zapcechy.adsl-llu.static.bluetone.cz with SMTP; 9 Sep 2007 07:444 -0000
QUIT*/
