#include "smtp.h"

extern smtpi jtin;

void jabstats_init()
   {
   pth_mutex_t mutex = PTH_MUTEX_INIT;
   pth_mutex_acquire(&mutex, TRUE, NULL);
   time_t now_unixtime;
   struct tm now;
   pool p=pool_new();
   char *lcFile;
   int liYear;

   PM_Reg(7501,NULL,p,1,(void*) NULL);

   now_unixtime = time(NULL);
   gmtime_r(&now_unixtime, &now);
   liYear =now.tm_year+1900;

   // pokud je soubor nahranej, testuj rok
   if (jtin->jabstats)
      {
      if (j_atoi(xmlnode_get_attrib(jtin->jabstats,"id"),0)!=liYear)
         {
         xmlnode_free(jtin->jabstats);
         jtin->jabstats=NULL;
         }
      }

   if (jtin->jabstats==NULL)
      {
      lcFile=spools(p,jtin->jabstats_folder,"/",smtp_itoa( p,liYear),".xml",p);
      if ((jtin->jabstats=xmlnode_file(lcFile))==NULL)
         { // file not exist or any other bug

         if (access(lcFile,F_OK)!=0)
            log_error("smtp","Transport cannot load jabstats file (%s).",lcFile);

         // create new file
         jtin->jabstats=xmlnode_new_tag("year");
         PM_Reg(7500,NULL,xmlnode_pool(jtin->jabstats),0,(void*) jtin->jabstats);
         xmlnode_put_attrib(jtin->jabstats,"id",smtp_itoa( p,liYear));
         }
      }   

   pool_free(p);
   pth_mutex_release(&mutex);
   }

void jabstats_add(jpacket jp)
   {
   time_t now_unixtime;
   struct tm now;
   xmlnode loDay,loJID,loCopy,loRcpt,loJabstats;
   pool p=pool_new();
   char *lcDate,*lcJID,*lcFile,*lcTo;
   int lii;
   PM_Reg(7510,NULL,p,1,(void*) NULL);

//   SMTP_DEBUG(SMTP_ZONE,"JABSTATS - start");
   jabstats_init(); // inicializace
//   SMTP_DEBUG(SMTP_ZONE,"JABSTATS - next");

   pth_mutex_t mutex = PTH_MUTEX_INIT;
   pth_mutex_acquire(&mutex, TRUE, NULL);

   now_unixtime = time(NULL);
   gmtime_r(&now_unixtime, &now);

   lcJID=smtp_GetJID(p,xmlnode_get_attrib(jp->x,"from"));
   lcTo=smtp_GetJID(p,xmlnode_get_attrib(jp->x,"to"));

   // najdi dle datumu zda ma JID, pokudne zaloit, pokud ano, inkrementuj
   lcDate = (char*)pmalloc_x(p, 11,' ');
   snprintf(lcDate, j_strlen(lcDate), "%04i-%02i-%02i\0", now.tm_year+1900, now.tm_mon+1, now.tm_mday);
   loDay=xmlnode_get_tag(jtin->jabstats,spools(p,"day?id=",lcDate,p));
   if (loDay==NULL)
      {
      loDay=xmlnode_insert_tag(jtin->jabstats,"day");
      xmlnode_put_attrib(loDay,"id",lcDate);
      loJID=NULL;
      } 
   else
      {
      loJID=xmlnode_get_tag(loDay,spools(p,"jid?from=",lcJID,p));
      } 

   if (loJID==NULL)
      {
      loJID=xmlnode_insert_tag(loDay,"jid");
      xmlnode_put_attrib(loJID,"from",lcJID);
      xmlnode_put_attrib(loJID,"count","1");
      xmlnode_put_attrib(loJID,"stepover","0");
      lii=1;
      }
   else
      {
      lii=j_atoi(xmlnode_get_attrib(loJID,"count"),0)+1;
      xmlnode_put_attrib(loJID,"count",smtp_itoa( p,lii));
      }

   // ulo do loJID adresu pjemce
   loRcpt=xmlnode_get_tag(loJID,spools(p,"recipient?to=",lcTo,p));
   if (loRcpt==NULL)
      {
      loRcpt=xmlnode_insert_tag(loJID,"recipient");
      xmlnode_put_attrib(loRcpt,"to",lcTo);
      xmlnode_put_attrib(loRcpt,"count","1");
      }
   else
      {
      lii=j_atoi(xmlnode_get_attrib(loRcpt,"count"),0)+1;
      xmlnode_put_attrib(loRcpt,"count",smtp_itoa( p,lii));
      }


   // nyn otestuj zda nepekroil limit za den
   if ((loJabstats=xmlnode_get_tag(jtin->config,"core/jabstats")) &&
       lii>=j_atoi(xmlnode_get_attrib(loJabstats,"daymaxlimit"),0) &&
       j_atoi(xmlnode_get_attrib(loJID,"stepover"),0)==0
      )
      {
      smtp_SendInfoToAdmin(spools(p,"The sender ",lcJID," step over day limit: ",smtp_itoa( p,lii),".",p),SMTP_SITA_M );
      xmlnode_put_attrib(loJID,"stepover","1");
      }


   // ulo XML, pes kopii
   loCopy=xmlnode_dup_pool(p,jtin->jabstats);
   lcFile=spools(p,jtin->jabstats_folder,"/",xmlnode_get_attrib(jtin->jabstats,"id"),".xml",p);
   if (xmlnode2file(lcFile,loCopy)!=1)
      {
      log_alert("smtp","JABSTATS - Cannot save file %s.",lcFile);
      smtp_SendInfoToAdmin(spools(p,"JABSTATS - Cannot save file ",lcFile,".",p ),SMTP_SITA_P);
      }

//   jtin->jabstats_folder // sloka kam se ukld statistika odeslanch email



   // vytvo statistiku - kdo a kdy poslal message na smtp
   // <year id="2008">
   //  <day id="yyyymmdd">
   //   <jid from="bla@xx.cz" count="1" >
   //    <recipient to="blah@xx.cz count="1" />
   //   </jid>
   //  </day>
   // </year>

   pool_free(p);
   pth_mutex_release(&mutex);
   }
